// Code generated by go-swagger; DO NOT EDIT.

package snapshots

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateDashboardSnapshotReader is a Reader for the CreateDashboardSnapshot structure.
type CreateDashboardSnapshotReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateDashboardSnapshotReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateDashboardSnapshotOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCreateDashboardSnapshotUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateDashboardSnapshotForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateDashboardSnapshotInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /snapshots] createDashboardSnapshot", response, response.Code())
	}
}

// NewCreateDashboardSnapshotOK creates a CreateDashboardSnapshotOK with default headers values
func NewCreateDashboardSnapshotOK() *CreateDashboardSnapshotOK {
	return &CreateDashboardSnapshotOK{}
}

/*
CreateDashboardSnapshotOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateDashboardSnapshotOK struct {
	Payload *models.CreateDashboardSnapshotOKBody
}

// IsSuccess returns true when this create dashboard snapshot Ok response has a 2xx status code
func (o *CreateDashboardSnapshotOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create dashboard snapshot Ok response has a 3xx status code
func (o *CreateDashboardSnapshotOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create dashboard snapshot Ok response has a 4xx status code
func (o *CreateDashboardSnapshotOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create dashboard snapshot Ok response has a 5xx status code
func (o *CreateDashboardSnapshotOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create dashboard snapshot Ok response a status code equal to that given
func (o *CreateDashboardSnapshotOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create dashboard snapshot Ok response
func (o *CreateDashboardSnapshotOK) Code() int {
	return 200
}

func (o *CreateDashboardSnapshotOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotOk %s", 200, payload)
}

func (o *CreateDashboardSnapshotOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotOk %s", 200, payload)
}

func (o *CreateDashboardSnapshotOK) GetPayload() *models.CreateDashboardSnapshotOKBody {
	return o.Payload
}

func (o *CreateDashboardSnapshotOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CreateDashboardSnapshotOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDashboardSnapshotUnauthorized creates a CreateDashboardSnapshotUnauthorized with default headers values
func NewCreateDashboardSnapshotUnauthorized() *CreateDashboardSnapshotUnauthorized {
	return &CreateDashboardSnapshotUnauthorized{}
}

/*
CreateDashboardSnapshotUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateDashboardSnapshotUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create dashboard snapshot unauthorized response has a 2xx status code
func (o *CreateDashboardSnapshotUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create dashboard snapshot unauthorized response has a 3xx status code
func (o *CreateDashboardSnapshotUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create dashboard snapshot unauthorized response has a 4xx status code
func (o *CreateDashboardSnapshotUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create dashboard snapshot unauthorized response has a 5xx status code
func (o *CreateDashboardSnapshotUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create dashboard snapshot unauthorized response a status code equal to that given
func (o *CreateDashboardSnapshotUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create dashboard snapshot unauthorized response
func (o *CreateDashboardSnapshotUnauthorized) Code() int {
	return 401
}

func (o *CreateDashboardSnapshotUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotUnauthorized %s", 401, payload)
}

func (o *CreateDashboardSnapshotUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotUnauthorized %s", 401, payload)
}

func (o *CreateDashboardSnapshotUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateDashboardSnapshotUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDashboardSnapshotForbidden creates a CreateDashboardSnapshotForbidden with default headers values
func NewCreateDashboardSnapshotForbidden() *CreateDashboardSnapshotForbidden {
	return &CreateDashboardSnapshotForbidden{}
}

/*
CreateDashboardSnapshotForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateDashboardSnapshotForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create dashboard snapshot forbidden response has a 2xx status code
func (o *CreateDashboardSnapshotForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create dashboard snapshot forbidden response has a 3xx status code
func (o *CreateDashboardSnapshotForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create dashboard snapshot forbidden response has a 4xx status code
func (o *CreateDashboardSnapshotForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create dashboard snapshot forbidden response has a 5xx status code
func (o *CreateDashboardSnapshotForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create dashboard snapshot forbidden response a status code equal to that given
func (o *CreateDashboardSnapshotForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create dashboard snapshot forbidden response
func (o *CreateDashboardSnapshotForbidden) Code() int {
	return 403
}

func (o *CreateDashboardSnapshotForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotForbidden %s", 403, payload)
}

func (o *CreateDashboardSnapshotForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotForbidden %s", 403, payload)
}

func (o *CreateDashboardSnapshotForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateDashboardSnapshotForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateDashboardSnapshotInternalServerError creates a CreateDashboardSnapshotInternalServerError with default headers values
func NewCreateDashboardSnapshotInternalServerError() *CreateDashboardSnapshotInternalServerError {
	return &CreateDashboardSnapshotInternalServerError{}
}

/*
CreateDashboardSnapshotInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateDashboardSnapshotInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create dashboard snapshot internal server error response has a 2xx status code
func (o *CreateDashboardSnapshotInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create dashboard snapshot internal server error response has a 3xx status code
func (o *CreateDashboardSnapshotInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create dashboard snapshot internal server error response has a 4xx status code
func (o *CreateDashboardSnapshotInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create dashboard snapshot internal server error response has a 5xx status code
func (o *CreateDashboardSnapshotInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create dashboard snapshot internal server error response a status code equal to that given
func (o *CreateDashboardSnapshotInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create dashboard snapshot internal server error response
func (o *CreateDashboardSnapshotInternalServerError) Code() int {
	return 500
}

func (o *CreateDashboardSnapshotInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotInternalServerError %s", 500, payload)
}

func (o *CreateDashboardSnapshotInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /snapshots][%d] createDashboardSnapshotInternalServerError %s", 500, payload)
}

func (o *CreateDashboardSnapshotInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateDashboardSnapshotInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
