// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CacheConfigResponse cache config response
//
// swagger:model CacheConfigResponse
type CacheConfigResponse struct {

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"created,omitempty"`

	// Fields that can be set by the API caller - read/write
	DataSourceID int64 `json:"dataSourceID,omitempty"`

	// data source UID
	DataSourceUID string `json:"dataSourceUID,omitempty"`

	// These are returned by the HTTP API, but are managed internally - read-only
	// Note: 'created' and 'updated' are special properties managed automatically by xorm, but we are setting them manually
	DefaultTTLMs int64 `json:"defaultTTLMs,omitempty"`

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// message
	Message string `json:"message,omitempty"`

	// TTL MS, or "time to live", is how long a cached item will stay in the cache before it is removed (in milliseconds)
	TTLQueriesMs int64 `json:"ttlQueriesMs,omitempty"`

	// ttl resources ms
	TTLResourcesMs int64 `json:"ttlResourcesMs,omitempty"`

	// updated
	// Format: date-time
	Updated strfmt.DateTime `json:"updated,omitempty"`

	// If UseDefaultTTL is enabled, then the TTLQueriesMS and TTLResourcesMS in this object is always sent as the default TTL located in grafana.ini
	UseDefaultTTL bool `json:"useDefaultTTL,omitempty"`
}

// Validate validates this cache config response
func (m *CacheConfigResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CacheConfigResponse) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CacheConfigResponse) validateUpdated(formats strfmt.Registry) error {
	if swag.IsZero(m.Updated) { // not required
		return nil
	}

	if err := validate.FormatOf("updated", "body", "date-time", m.Updated.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cache config response based on context it is used
func (m *CacheConfigResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CacheConfigResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CacheConfigResponse) UnmarshalBinary(b []byte) error {
	var res CacheConfigResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
