// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the gateway to get.
	//
	// GatewayArn is a required field
	GatewayArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGatewayInput"}

	if s.GatewayArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The details of the gateway.
	Gateway *Gateway `type:"structure"`
}

// String returns the string representation
func (s GetGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetGateway = "GetGateway"

// GetGatewayRequest returns a request value for making API operation for
// Alexa For Business.
//
// Retrieves the details of a gateway.
//
//    // Example sending a request using GetGatewayRequest.
//    req := client.GetGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway
func (c *Client) GetGatewayRequest(input *GetGatewayInput) GetGatewayRequest {
	op := &aws.Operation{
		Name:       opGetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGatewayInput{}
	}

	req := c.newRequest(op, input, &GetGatewayOutput{})
	return GetGatewayRequest{Request: req, Input: input, Copy: c.GetGatewayRequest}
}

// GetGatewayRequest is the request type for the
// GetGateway API operation.
type GetGatewayRequest struct {
	*aws.Request
	Input *GetGatewayInput
	Copy  func(*GetGatewayInput) GetGatewayRequest
}

// Send marshals and sends the GetGateway API request.
func (r GetGatewayRequest) Send(ctx context.Context) (*GetGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGatewayResponse{
		GetGatewayOutput: r.Request.Data.(*GetGatewayOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGatewayResponse is the response type for the
// GetGateway API operation.
type GetGatewayResponse struct {
	*GetGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGateway request.
func (r *GetGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
