// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request of DeleteSubscriber
type DeleteSubscriberInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose subscriber you want
	// to delete.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose subscriber you want to delete.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// The notification whose subscriber you want to delete.
	//
	// Notification is a required field
	Notification *Notification `type:"structure" required:"true"`

	// The subscriber that you want to delete.
	//
	// Subscriber is a required field
	Subscriber *Subscriber `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSubscriberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSubscriberInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.BudgetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BudgetName", 1))
	}

	if s.Notification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Notification"))
	}

	if s.Subscriber == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subscriber"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(aws.ErrInvalidParams))
		}
	}
	if s.Subscriber != nil {
		if err := s.Subscriber.Validate(); err != nil {
			invalidParams.AddNested("Subscriber", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response of DeleteSubscriber
type DeleteSubscriberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSubscriberOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSubscriber = "DeleteSubscriber"

// DeleteSubscriberRequest returns a request value for making API operation for
// AWS Budgets.
//
// Deletes a subscriber.
//
// Deleting the last subscriber to a notification also deletes the notification.
//
//    // Example sending a request using DeleteSubscriberRequest.
//    req := client.DeleteSubscriberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteSubscriberRequest(input *DeleteSubscriberInput) DeleteSubscriberRequest {
	op := &aws.Operation{
		Name:       opDeleteSubscriber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubscriberInput{}
	}

	req := c.newRequest(op, input, &DeleteSubscriberOutput{})
	return DeleteSubscriberRequest{Request: req, Input: input, Copy: c.DeleteSubscriberRequest}
}

// DeleteSubscriberRequest is the request type for the
// DeleteSubscriber API operation.
type DeleteSubscriberRequest struct {
	*aws.Request
	Input *DeleteSubscriberInput
	Copy  func(*DeleteSubscriberInput) DeleteSubscriberRequest
}

// Send marshals and sends the DeleteSubscriber API request.
func (r DeleteSubscriberRequest) Send(ctx context.Context) (*DeleteSubscriberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSubscriberResponse{
		DeleteSubscriberOutput: r.Request.Data.(*DeleteSubscriberOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSubscriberResponse is the response type for the
// DeleteSubscriber API operation.
type DeleteSubscriberResponse struct {
	*DeleteSubscriberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSubscriber request.
func (r *DeleteSubscriberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
