// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeReplicationInstanceTaskLogsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReplicationInstanceTaskLogsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstanceTaskLogsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReplicationInstanceTaskLogsInput"}

	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationInstanceTaskLogsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// An array of replication task log metadata. Each member of the array contains
	// the replication task name, ARN, and task log size (in bytes).
	ReplicationInstanceTaskLogs []ReplicationInstanceTaskLog `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstanceTaskLogsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReplicationInstanceTaskLogs = "DescribeReplicationInstanceTaskLogs"

// DescribeReplicationInstanceTaskLogsRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Returns information about the task logs for the specified task.
//
//    // Example sending a request using DescribeReplicationInstanceTaskLogsRequest.
//    req := client.DescribeReplicationInstanceTaskLogsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs
func (c *Client) DescribeReplicationInstanceTaskLogsRequest(input *DescribeReplicationInstanceTaskLogsInput) DescribeReplicationInstanceTaskLogsRequest {
	op := &aws.Operation{
		Name:       opDescribeReplicationInstanceTaskLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstanceTaskLogsInput{}
	}

	req := c.newRequest(op, input, &DescribeReplicationInstanceTaskLogsOutput{})
	return DescribeReplicationInstanceTaskLogsRequest{Request: req, Input: input, Copy: c.DescribeReplicationInstanceTaskLogsRequest}
}

// DescribeReplicationInstanceTaskLogsRequest is the request type for the
// DescribeReplicationInstanceTaskLogs API operation.
type DescribeReplicationInstanceTaskLogsRequest struct {
	*aws.Request
	Input *DescribeReplicationInstanceTaskLogsInput
	Copy  func(*DescribeReplicationInstanceTaskLogsInput) DescribeReplicationInstanceTaskLogsRequest
}

// Send marshals and sends the DescribeReplicationInstanceTaskLogs API request.
func (r DescribeReplicationInstanceTaskLogsRequest) Send(ctx context.Context) (*DescribeReplicationInstanceTaskLogsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReplicationInstanceTaskLogsResponse{
		DescribeReplicationInstanceTaskLogsOutput: r.Request.Data.(*DescribeReplicationInstanceTaskLogsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReplicationInstanceTaskLogsRequestPaginator returns a paginator for DescribeReplicationInstanceTaskLogs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReplicationInstanceTaskLogsRequest(input)
//   p := databasemigrationservice.NewDescribeReplicationInstanceTaskLogsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReplicationInstanceTaskLogsPaginator(req DescribeReplicationInstanceTaskLogsRequest) DescribeReplicationInstanceTaskLogsPaginator {
	return DescribeReplicationInstanceTaskLogsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReplicationInstanceTaskLogsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReplicationInstanceTaskLogsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReplicationInstanceTaskLogsPaginator struct {
	aws.Pager
}

func (p *DescribeReplicationInstanceTaskLogsPaginator) CurrentPage() *DescribeReplicationInstanceTaskLogsOutput {
	return p.Pager.CurrentPage().(*DescribeReplicationInstanceTaskLogsOutput)
}

// DescribeReplicationInstanceTaskLogsResponse is the response type for the
// DescribeReplicationInstanceTaskLogs API operation.
type DescribeReplicationInstanceTaskLogsResponse struct {
	*DescribeReplicationInstanceTaskLogsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReplicationInstanceTaskLogs request.
func (r *DescribeReplicationInstanceTaskLogsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
