// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisableFastSnapshotRestoresInput struct {
	_ struct{} `type:"structure"`

	// One or more Availability Zones. For example, us-east-2a.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `locationName:"AvailabilityZone" locationNameList:"AvailabilityZone" type:"list" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of one or more snapshots. For example, snap-1234567890abcdef0.
	//
	// SourceSnapshotIds is a required field
	SourceSnapshotIds []string `locationName:"SourceSnapshotId" locationNameList:"SnapshotId" type:"list" required:"true"`
}

// String returns the string representation
func (s DisableFastSnapshotRestoresInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableFastSnapshotRestoresInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableFastSnapshotRestoresInput"}

	if s.AvailabilityZones == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZones"))
	}

	if s.SourceSnapshotIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceSnapshotIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableFastSnapshotRestoresOutput struct {
	_ struct{} `type:"structure"`

	// Information about the snapshots for which fast snapshot restores were successfully
	// disabled.
	Successful []DisableFastSnapshotRestoreSuccessItem `locationName:"successful" locationNameList:"item" type:"list"`

	// Information about the snapshots for which fast snapshot restores could not
	// be disabled.
	Unsuccessful []DisableFastSnapshotRestoreErrorItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DisableFastSnapshotRestoresOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableFastSnapshotRestores = "DisableFastSnapshotRestores"

// DisableFastSnapshotRestoresRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables fast snapshot restores for the specified snapshots in the specified
// Availability Zones.
//
//    // Example sending a request using DisableFastSnapshotRestoresRequest.
//    req := client.DisableFastSnapshotRestoresRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestores
func (c *Client) DisableFastSnapshotRestoresRequest(input *DisableFastSnapshotRestoresInput) DisableFastSnapshotRestoresRequest {
	op := &aws.Operation{
		Name:       opDisableFastSnapshotRestores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableFastSnapshotRestoresInput{}
	}

	req := c.newRequest(op, input, &DisableFastSnapshotRestoresOutput{})
	return DisableFastSnapshotRestoresRequest{Request: req, Input: input, Copy: c.DisableFastSnapshotRestoresRequest}
}

// DisableFastSnapshotRestoresRequest is the request type for the
// DisableFastSnapshotRestores API operation.
type DisableFastSnapshotRestoresRequest struct {
	*aws.Request
	Input *DisableFastSnapshotRestoresInput
	Copy  func(*DisableFastSnapshotRestoresInput) DisableFastSnapshotRestoresRequest
}

// Send marshals and sends the DisableFastSnapshotRestores API request.
func (r DisableFastSnapshotRestoresRequest) Send(ctx context.Context) (*DisableFastSnapshotRestoresResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableFastSnapshotRestoresResponse{
		DisableFastSnapshotRestoresOutput: r.Request.Data.(*DisableFastSnapshotRestoresOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableFastSnapshotRestoresResponse is the response type for the
// DisableFastSnapshotRestores API operation.
type DisableFastSnapshotRestoresResponse struct {
	*DisableFastSnapshotRestoresOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableFastSnapshotRestores request.
func (r *DisableFastSnapshotRestoresResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
