// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteInsightInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight to delete.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInsightInput"}

	if s.InsightArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("InsightArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteInsightInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight that was deleted.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteInsightOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Deletes the insight specified by the InsightArn.
//
//    // Example sending a request using DeleteInsightRequest.
//    req := client.DeleteInsightRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *Client) DeleteInsightRequest(input *DeleteInsightInput) DeleteInsightRequest {
	op := &aws.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	req := c.newRequest(op, input, &DeleteInsightOutput{})
	return DeleteInsightRequest{Request: req, Input: input, Copy: c.DeleteInsightRequest}
}

// DeleteInsightRequest is the request type for the
// DeleteInsight API operation.
type DeleteInsightRequest struct {
	*aws.Request
	Input *DeleteInsightInput
	Copy  func(*DeleteInsightInput) DeleteInsightRequest
}

// Send marshals and sends the DeleteInsight API request.
func (r DeleteInsightRequest) Send(ctx context.Context) (*DeleteInsightResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInsightResponse{
		DeleteInsightOutput: r.Request.Data.(*DeleteInsightOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInsightResponse is the response type for the
// DeleteInsight API operation.
type DeleteInsightResponse struct {
	*DeleteInsightOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInsight request.
func (r *DeleteInsightResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
