// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreatePullRequestApprovalRuleInput struct {
	_ struct{} `type:"structure"`

	// The content of the approval rule, including the number of approvals needed
	// and the structure of an approval pool defined for approvals, if any. For
	// more information about approval pools, see the AWS CodeCommit User Guide.
	//
	// When you create the content of the approval rule, you can specify approvers
	// in an approval pool in one of two ways:
	//
	//    * CodeCommitApprovers: This option only requires an AWS account and a
	//    resource. It can be used for both IAM users and federated access users
	//    whose name matches the provided resource name. This is a very powerful
	//    option that offers a great deal of flexibility. For example, if you specify
	//    the AWS account 123456789012 and Mary_Major, all of the following would
	//    be counted as approvals coming from that user: An IAM user in the account
	//    (arn:aws:iam::123456789012:user/Mary_Major) A federated user identified
	//    in IAM as Mary_Major (arn:aws:sts::123456789012:federated-user/Mary_Major)
	//    This option does not recognize an active session of someone assuming the
	//    role of CodeCommitReview with a role session name of Mary_Major (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major)
	//    unless you include a wildcard (*Mary_Major).
	//
	//    * Fully qualified ARN: This option allows you to specify the fully qualified
	//    Amazon Resource Name (ARN) of the IAM user or role.
	//
	// For more information about IAM ARNs, wildcards, and formats, see IAM Identifiers
	// (https://docs.aws.amazon.com/iam/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	//
	// ApprovalRuleContent is a required field
	ApprovalRuleContent *string `locationName:"approvalRuleContent" min:"1" type:"string" required:"true"`

	// The name for the approval rule.
	//
	// ApprovalRuleName is a required field
	ApprovalRuleName *string `locationName:"approvalRuleName" min:"1" type:"string" required:"true"`

	// The system-generated ID of the pull request for which you want to create
	// the approval rule.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePullRequestApprovalRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePullRequestApprovalRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePullRequestApprovalRuleInput"}

	if s.ApprovalRuleContent == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleContent"))
	}
	if s.ApprovalRuleContent != nil && len(*s.ApprovalRuleContent) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleContent", 1))
	}

	if s.ApprovalRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleName"))
	}
	if s.ApprovalRuleName != nil && len(*s.ApprovalRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleName", 1))
	}

	if s.PullRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PullRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreatePullRequestApprovalRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the created approval rule.
	//
	// ApprovalRule is a required field
	ApprovalRule *ApprovalRule `locationName:"approvalRule" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePullRequestApprovalRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreatePullRequestApprovalRule = "CreatePullRequestApprovalRule"

// CreatePullRequestApprovalRuleRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Creates an approval rule for a pull request.
//
//    // Example sending a request using CreatePullRequestApprovalRuleRequest.
//    req := client.CreatePullRequestApprovalRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequestApprovalRule
func (c *Client) CreatePullRequestApprovalRuleRequest(input *CreatePullRequestApprovalRuleInput) CreatePullRequestApprovalRuleRequest {
	op := &aws.Operation{
		Name:       opCreatePullRequestApprovalRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePullRequestApprovalRuleInput{}
	}

	req := c.newRequest(op, input, &CreatePullRequestApprovalRuleOutput{})
	return CreatePullRequestApprovalRuleRequest{Request: req, Input: input, Copy: c.CreatePullRequestApprovalRuleRequest}
}

// CreatePullRequestApprovalRuleRequest is the request type for the
// CreatePullRequestApprovalRule API operation.
type CreatePullRequestApprovalRuleRequest struct {
	*aws.Request
	Input *CreatePullRequestApprovalRuleInput
	Copy  func(*CreatePullRequestApprovalRuleInput) CreatePullRequestApprovalRuleRequest
}

// Send marshals and sends the CreatePullRequestApprovalRule API request.
func (r CreatePullRequestApprovalRuleRequest) Send(ctx context.Context) (*CreatePullRequestApprovalRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePullRequestApprovalRuleResponse{
		CreatePullRequestApprovalRuleOutput: r.Request.Data.(*CreatePullRequestApprovalRuleOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePullRequestApprovalRuleResponse is the response type for the
// CreatePullRequestApprovalRule API operation.
type CreatePullRequestApprovalRuleResponse struct {
	*CreatePullRequestApprovalRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePullRequestApprovalRule request.
func (r *CreatePullRequestApprovalRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
