// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SelectResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// The SQL query SELECT command.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`

	// The maximum number of query results returned on each page.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SelectResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectResourceConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelectResourceConfigInput"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SelectResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns the QueryInfo object.
	QueryInfo *QueryInfo `type:"structure"`

	// Returns the results for the SQL query.
	Results []string `type:"list"`
}

// String returns the string representation
func (s SelectResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opSelectResourceConfig = "SelectResourceConfig"

// SelectResourceConfigRequest returns a request value for making API operation for
// AWS Config.
//
// Accepts a structured query language (SQL) SELECT command, performs the corresponding
// search, and returns resource configurations matching the properties.
//
// For more information about query components, see the Query Components (https://docs.aws.amazon.com/config/latest/developerguide/query-components.html)
// section in the AWS Config Developer Guide.
//
//    // Example sending a request using SelectResourceConfigRequest.
//    req := client.SelectResourceConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SelectResourceConfig
func (c *Client) SelectResourceConfigRequest(input *SelectResourceConfigInput) SelectResourceConfigRequest {
	op := &aws.Operation{
		Name:       opSelectResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SelectResourceConfigInput{}
	}

	req := c.newRequest(op, input, &SelectResourceConfigOutput{})
	return SelectResourceConfigRequest{Request: req, Input: input, Copy: c.SelectResourceConfigRequest}
}

// SelectResourceConfigRequest is the request type for the
// SelectResourceConfig API operation.
type SelectResourceConfigRequest struct {
	*aws.Request
	Input *SelectResourceConfigInput
	Copy  func(*SelectResourceConfigInput) SelectResourceConfigRequest
}

// Send marshals and sends the SelectResourceConfig API request.
func (r SelectResourceConfigRequest) Send(ctx context.Context) (*SelectResourceConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SelectResourceConfigResponse{
		SelectResourceConfigOutput: r.Request.Data.(*SelectResourceConfigOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SelectResourceConfigResponse is the response type for the
// SelectResourceConfig API operation.
type SelectResourceConfigResponse struct {
	*SelectResourceConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SelectResourceConfig request.
func (r *SelectResourceConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
