// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeIdentityIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the principal, which can be an IAM role, IAM user, or the root
	// user.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`

	// The type of resource: bundle | conversion-task | customer-gateway | dhcp-options
	// | elastic-ip-allocation | elastic-ip-association | export-task | flow-log
	// | image | import-task | instance | internet-gateway | network-acl | network-acl-association
	// | network-interface | network-interface-attachment | prefix-list | reservation
	// | route-table | route-table-association | security-group | snapshot | subnet
	// | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
	// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway
	Resource *string `locationName:"resource" type:"string"`
}

// String returns the string representation
func (s DescribeIdentityIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityIdFormatInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIdentityIdFormatInput"}

	if s.PrincipalArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrincipalArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeIdentityIdFormatOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ID format for the resources.
	Statuses []IdFormat `locationName:"statusSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeIdentityIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeIdentityIdFormat = "DescribeIdentityIdFormat"

// DescribeIdentityIdFormatRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for resources for the specified IAM user,
// IAM role, or root user. For example, you can view the resource types that
// are enabled for longer IDs. This request only returns information about resource
// types whose ID formats can be modified; it does not return information about
// other resource types. For more information, see Resource IDs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// These settings apply to the principal specified in the request. They do not
// apply to the principal that makes the request.
//
//    // Example sending a request using DescribeIdentityIdFormatRequest.
//    req := client.DescribeIdentityIdFormatRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *Client) DescribeIdentityIdFormatRequest(input *DescribeIdentityIdFormatInput) DescribeIdentityIdFormatRequest {
	op := &aws.Operation{
		Name:       opDescribeIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityIdFormatInput{}
	}

	req := c.newRequest(op, input, &DescribeIdentityIdFormatOutput{})
	return DescribeIdentityIdFormatRequest{Request: req, Input: input, Copy: c.DescribeIdentityIdFormatRequest}
}

// DescribeIdentityIdFormatRequest is the request type for the
// DescribeIdentityIdFormat API operation.
type DescribeIdentityIdFormatRequest struct {
	*aws.Request
	Input *DescribeIdentityIdFormatInput
	Copy  func(*DescribeIdentityIdFormatInput) DescribeIdentityIdFormatRequest
}

// Send marshals and sends the DescribeIdentityIdFormat API request.
func (r DescribeIdentityIdFormatRequest) Send(ctx context.Context) (*DescribeIdentityIdFormatResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIdentityIdFormatResponse{
		DescribeIdentityIdFormatOutput: r.Request.Data.(*DescribeIdentityIdFormatOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIdentityIdFormatResponse is the response type for the
// DescribeIdentityIdFormat API operation.
type DescribeIdentityIdFormatResponse struct {
	*DescribeIdentityIdFormatOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIdentityIdFormat request.
func (r *DescribeIdentityIdFormatResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
