// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MemoryBankService_CreateMemory_FullMethodName     = "/google.cloud.aiplatform.v1beta1.MemoryBankService/CreateMemory"
	MemoryBankService_GetMemory_FullMethodName        = "/google.cloud.aiplatform.v1beta1.MemoryBankService/GetMemory"
	MemoryBankService_UpdateMemory_FullMethodName     = "/google.cloud.aiplatform.v1beta1.MemoryBankService/UpdateMemory"
	MemoryBankService_ListMemories_FullMethodName     = "/google.cloud.aiplatform.v1beta1.MemoryBankService/ListMemories"
	MemoryBankService_DeleteMemory_FullMethodName     = "/google.cloud.aiplatform.v1beta1.MemoryBankService/DeleteMemory"
	MemoryBankService_GenerateMemories_FullMethodName = "/google.cloud.aiplatform.v1beta1.MemoryBankService/GenerateMemories"
	MemoryBankService_RetrieveMemories_FullMethodName = "/google.cloud.aiplatform.v1beta1.MemoryBankService/RetrieveMemories"
)

// MemoryBankServiceClient is the client API for MemoryBankService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MemoryBankServiceClient interface {
	// Create a Memory.
	CreateMemory(ctx context.Context, in *CreateMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a Memory.
	GetMemory(ctx context.Context, in *GetMemoryRequest, opts ...grpc.CallOption) (*Memory, error)
	// Update a Memory.
	UpdateMemory(ctx context.Context, in *UpdateMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List Memories.
	ListMemories(ctx context.Context, in *ListMemoriesRequest, opts ...grpc.CallOption) (*ListMemoriesResponse, error)
	// Delete a Memory.
	DeleteMemory(ctx context.Context, in *DeleteMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generate memories.
	GenerateMemories(ctx context.Context, in *GenerateMemoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieve memories.
	RetrieveMemories(ctx context.Context, in *RetrieveMemoriesRequest, opts ...grpc.CallOption) (*RetrieveMemoriesResponse, error)
}

type memoryBankServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMemoryBankServiceClient(cc grpc.ClientConnInterface) MemoryBankServiceClient {
	return &memoryBankServiceClient{cc}
}

func (c *memoryBankServiceClient) CreateMemory(ctx context.Context, in *CreateMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MemoryBankService_CreateMemory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) GetMemory(ctx context.Context, in *GetMemoryRequest, opts ...grpc.CallOption) (*Memory, error) {
	out := new(Memory)
	err := c.cc.Invoke(ctx, MemoryBankService_GetMemory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) UpdateMemory(ctx context.Context, in *UpdateMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MemoryBankService_UpdateMemory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) ListMemories(ctx context.Context, in *ListMemoriesRequest, opts ...grpc.CallOption) (*ListMemoriesResponse, error) {
	out := new(ListMemoriesResponse)
	err := c.cc.Invoke(ctx, MemoryBankService_ListMemories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) DeleteMemory(ctx context.Context, in *DeleteMemoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MemoryBankService_DeleteMemory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) GenerateMemories(ctx context.Context, in *GenerateMemoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, MemoryBankService_GenerateMemories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memoryBankServiceClient) RetrieveMemories(ctx context.Context, in *RetrieveMemoriesRequest, opts ...grpc.CallOption) (*RetrieveMemoriesResponse, error) {
	out := new(RetrieveMemoriesResponse)
	err := c.cc.Invoke(ctx, MemoryBankService_RetrieveMemories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MemoryBankServiceServer is the server API for MemoryBankService service.
// All implementations should embed UnimplementedMemoryBankServiceServer
// for forward compatibility
type MemoryBankServiceServer interface {
	// Create a Memory.
	CreateMemory(context.Context, *CreateMemoryRequest) (*longrunningpb.Operation, error)
	// Get a Memory.
	GetMemory(context.Context, *GetMemoryRequest) (*Memory, error)
	// Update a Memory.
	UpdateMemory(context.Context, *UpdateMemoryRequest) (*longrunningpb.Operation, error)
	// List Memories.
	ListMemories(context.Context, *ListMemoriesRequest) (*ListMemoriesResponse, error)
	// Delete a Memory.
	DeleteMemory(context.Context, *DeleteMemoryRequest) (*longrunningpb.Operation, error)
	// Generate memories.
	GenerateMemories(context.Context, *GenerateMemoriesRequest) (*longrunningpb.Operation, error)
	// Retrieve memories.
	RetrieveMemories(context.Context, *RetrieveMemoriesRequest) (*RetrieveMemoriesResponse, error)
}

// UnimplementedMemoryBankServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMemoryBankServiceServer struct {
}

func (UnimplementedMemoryBankServiceServer) CreateMemory(context.Context, *CreateMemoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMemory not implemented")
}
func (UnimplementedMemoryBankServiceServer) GetMemory(context.Context, *GetMemoryRequest) (*Memory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMemory not implemented")
}
func (UnimplementedMemoryBankServiceServer) UpdateMemory(context.Context, *UpdateMemoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMemory not implemented")
}
func (UnimplementedMemoryBankServiceServer) ListMemories(context.Context, *ListMemoriesRequest) (*ListMemoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMemories not implemented")
}
func (UnimplementedMemoryBankServiceServer) DeleteMemory(context.Context, *DeleteMemoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMemory not implemented")
}
func (UnimplementedMemoryBankServiceServer) GenerateMemories(context.Context, *GenerateMemoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateMemories not implemented")
}
func (UnimplementedMemoryBankServiceServer) RetrieveMemories(context.Context, *RetrieveMemoriesRequest) (*RetrieveMemoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveMemories not implemented")
}

// UnsafeMemoryBankServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MemoryBankServiceServer will
// result in compilation errors.
type UnsafeMemoryBankServiceServer interface {
	mustEmbedUnimplementedMemoryBankServiceServer()
}

func RegisterMemoryBankServiceServer(s grpc.ServiceRegistrar, srv MemoryBankServiceServer) {
	s.RegisterService(&MemoryBankService_ServiceDesc, srv)
}

func _MemoryBankService_CreateMemory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMemoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).CreateMemory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_CreateMemory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).CreateMemory(ctx, req.(*CreateMemoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_GetMemory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMemoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).GetMemory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_GetMemory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).GetMemory(ctx, req.(*GetMemoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_UpdateMemory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMemoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).UpdateMemory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_UpdateMemory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).UpdateMemory(ctx, req.(*UpdateMemoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_ListMemories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMemoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).ListMemories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_ListMemories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).ListMemories(ctx, req.(*ListMemoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_DeleteMemory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMemoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).DeleteMemory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_DeleteMemory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).DeleteMemory(ctx, req.(*DeleteMemoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_GenerateMemories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateMemoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).GenerateMemories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_GenerateMemories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).GenerateMemories(ctx, req.(*GenerateMemoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MemoryBankService_RetrieveMemories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveMemoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemoryBankServiceServer).RetrieveMemories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MemoryBankService_RetrieveMemories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemoryBankServiceServer).RetrieveMemories(ctx, req.(*RetrieveMemoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MemoryBankService_ServiceDesc is the grpc.ServiceDesc for MemoryBankService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MemoryBankService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.MemoryBankService",
	HandlerType: (*MemoryBankServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMemory",
			Handler:    _MemoryBankService_CreateMemory_Handler,
		},
		{
			MethodName: "GetMemory",
			Handler:    _MemoryBankService_GetMemory_Handler,
		},
		{
			MethodName: "UpdateMemory",
			Handler:    _MemoryBankService_UpdateMemory_Handler,
		},
		{
			MethodName: "ListMemories",
			Handler:    _MemoryBankService_ListMemories_Handler,
		},
		{
			MethodName: "DeleteMemory",
			Handler:    _MemoryBankService_DeleteMemory_Handler,
		},
		{
			MethodName: "GenerateMemories",
			Handler:    _MemoryBankService_GenerateMemories_Handler,
		},
		{
			MethodName: "RetrieveMemories",
			Handler:    _MemoryBankService_RetrieveMemories_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/memory_bank_service.proto",
}
