// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.feed.post

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"

	comatprototypes "github.com/bluesky-social/indigo/api/atproto"
	"github.com/bluesky-social/indigo/lex/util"
	cbg "github.com/whyrusleeping/cbor-gen"
)

func init() {
	util.RegisterType("app.bsky.feed.post", &FeedPost{})
} //
// RECORDTYPE: FeedPost
type FeedPost struct {
	LexiconTypeID string `json:"$type,const=app.bsky.feed.post" cborgen:"$type,const=app.bsky.feed.post"`
	// createdAt: Client-declared timestamp when this post was originally created.
	CreatedAt string          `json:"createdAt" cborgen:"createdAt"`
	Embed     *FeedPost_Embed `json:"embed,omitempty" cborgen:"embed,omitempty"`
	// entities: DEPRECATED: replaced by app.bsky.richtext.facet.
	Entities []*FeedPost_Entity `json:"entities,omitempty" cborgen:"entities,omitempty"`
	// facets: Annotations of text (mentions, URLs, hashtags, etc)
	Facets []*RichtextFacet `json:"facets,omitempty" cborgen:"facets,omitempty"`
	// labels: Self-label values for this post. Effectively content warnings.
	Labels *FeedPost_Labels `json:"labels,omitempty" cborgen:"labels,omitempty"`
	// langs: Indicates human language of post primary text content.
	Langs []string           `json:"langs,omitempty" cborgen:"langs,omitempty"`
	Reply *FeedPost_ReplyRef `json:"reply,omitempty" cborgen:"reply,omitempty"`
	// tags: Additional hashtags, in addition to any included in post text and facets.
	Tags []string `json:"tags,omitempty" cborgen:"tags,omitempty"`
	// text: The primary post content. May be an empty string, if there are embeds.
	Text string `json:"text" cborgen:"text"`
}

type FeedPost_Embed struct {
	EmbedImages          *EmbedImages
	EmbedExternal        *EmbedExternal
	EmbedRecord          *EmbedRecord
	EmbedRecordWithMedia *EmbedRecordWithMedia
}

func (t *FeedPost_Embed) MarshalJSON() ([]byte, error) {
	if t.EmbedImages != nil {
		t.EmbedImages.LexiconTypeID = "app.bsky.embed.images"
		return json.Marshal(t.EmbedImages)
	}
	if t.EmbedExternal != nil {
		t.EmbedExternal.LexiconTypeID = "app.bsky.embed.external"
		return json.Marshal(t.EmbedExternal)
	}
	if t.EmbedRecord != nil {
		t.EmbedRecord.LexiconTypeID = "app.bsky.embed.record"
		return json.Marshal(t.EmbedRecord)
	}
	if t.EmbedRecordWithMedia != nil {
		t.EmbedRecordWithMedia.LexiconTypeID = "app.bsky.embed.recordWithMedia"
		return json.Marshal(t.EmbedRecordWithMedia)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *FeedPost_Embed) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.embed.images":
		t.EmbedImages = new(EmbedImages)
		return json.Unmarshal(b, t.EmbedImages)
	case "app.bsky.embed.external":
		t.EmbedExternal = new(EmbedExternal)
		return json.Unmarshal(b, t.EmbedExternal)
	case "app.bsky.embed.record":
		t.EmbedRecord = new(EmbedRecord)
		return json.Unmarshal(b, t.EmbedRecord)
	case "app.bsky.embed.recordWithMedia":
		t.EmbedRecordWithMedia = new(EmbedRecordWithMedia)
		return json.Unmarshal(b, t.EmbedRecordWithMedia)

	default:
		return nil
	}
}

func (t *FeedPost_Embed) MarshalCBOR(w io.Writer) error {

	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}
	if t.EmbedImages != nil {
		return t.EmbedImages.MarshalCBOR(w)
	}
	if t.EmbedExternal != nil {
		return t.EmbedExternal.MarshalCBOR(w)
	}
	if t.EmbedRecord != nil {
		return t.EmbedRecord.MarshalCBOR(w)
	}
	if t.EmbedRecordWithMedia != nil {
		return t.EmbedRecordWithMedia.MarshalCBOR(w)
	}
	return fmt.Errorf("cannot cbor marshal empty enum")
}
func (t *FeedPost_Embed) UnmarshalCBOR(r io.Reader) error {
	typ, b, err := util.CborTypeExtractReader(r)
	if err != nil {
		return err
	}

	switch typ {
	case "app.bsky.embed.images":
		t.EmbedImages = new(EmbedImages)
		return t.EmbedImages.UnmarshalCBOR(bytes.NewReader(b))
	case "app.bsky.embed.external":
		t.EmbedExternal = new(EmbedExternal)
		return t.EmbedExternal.UnmarshalCBOR(bytes.NewReader(b))
	case "app.bsky.embed.record":
		t.EmbedRecord = new(EmbedRecord)
		return t.EmbedRecord.UnmarshalCBOR(bytes.NewReader(b))
	case "app.bsky.embed.recordWithMedia":
		t.EmbedRecordWithMedia = new(EmbedRecordWithMedia)
		return t.EmbedRecordWithMedia.UnmarshalCBOR(bytes.NewReader(b))

	default:
		return nil
	}
}

// FeedPost_Entity is a "entity" in the app.bsky.feed.post schema.
//
// Deprecated: use facets instead.
type FeedPost_Entity struct {
	Index *FeedPost_TextSlice `json:"index" cborgen:"index"`
	// type: Expected values are 'mention' and 'link'.
	Type  string `json:"type" cborgen:"type"`
	Value string `json:"value" cborgen:"value"`
}

// Self-label values for this post. Effectively content warnings.
type FeedPost_Labels struct {
	LabelDefs_SelfLabels *comatprototypes.LabelDefs_SelfLabels
}

func (t *FeedPost_Labels) MarshalJSON() ([]byte, error) {
	if t.LabelDefs_SelfLabels != nil {
		t.LabelDefs_SelfLabels.LexiconTypeID = "com.atproto.label.defs#selfLabels"
		return json.Marshal(t.LabelDefs_SelfLabels)
	}
	return nil, fmt.Errorf("cannot marshal empty enum")
}
func (t *FeedPost_Labels) UnmarshalJSON(b []byte) error {
	typ, err := util.TypeExtract(b)
	if err != nil {
		return err
	}

	switch typ {
	case "com.atproto.label.defs#selfLabels":
		t.LabelDefs_SelfLabels = new(comatprototypes.LabelDefs_SelfLabels)
		return json.Unmarshal(b, t.LabelDefs_SelfLabels)

	default:
		return nil
	}
}

func (t *FeedPost_Labels) MarshalCBOR(w io.Writer) error {

	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}
	if t.LabelDefs_SelfLabels != nil {
		return t.LabelDefs_SelfLabels.MarshalCBOR(w)
	}
	return fmt.Errorf("cannot cbor marshal empty enum")
}
func (t *FeedPost_Labels) UnmarshalCBOR(r io.Reader) error {
	typ, b, err := util.CborTypeExtractReader(r)
	if err != nil {
		return err
	}

	switch typ {
	case "com.atproto.label.defs#selfLabels":
		t.LabelDefs_SelfLabels = new(comatprototypes.LabelDefs_SelfLabels)
		return t.LabelDefs_SelfLabels.UnmarshalCBOR(bytes.NewReader(b))

	default:
		return nil
	}
}

// FeedPost_ReplyRef is a "replyRef" in the app.bsky.feed.post schema.
type FeedPost_ReplyRef struct {
	Parent *comatprototypes.RepoStrongRef `json:"parent" cborgen:"parent"`
	Root   *comatprototypes.RepoStrongRef `json:"root" cborgen:"root"`
}

// FeedPost_TextSlice is a "textSlice" in the app.bsky.feed.post schema.
//
// Deprecated. Use app.bsky.richtext instead -- A text segment. Start is inclusive, end is exclusive. Indices are for utf16-encoded strings.
type FeedPost_TextSlice struct {
	End   int64 `json:"end" cborgen:"end"`
	Start int64 `json:"start" cborgen:"start"`
}
