// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package bigtable aliases all exported identifiers in package
// "cloud.google.com/go/bigtable/apiv2/bigtablepb".
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package bigtable

import (
	src "cloud.google.com/go/bigtable/apiv2/bigtablepb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/bigtable/apiv2/bigtablepb
const (
	ReadChangeStreamResponse_DataChange_CONTINUATION       = src.ReadChangeStreamResponse_DataChange_CONTINUATION
	ReadChangeStreamResponse_DataChange_GARBAGE_COLLECTION = src.ReadChangeStreamResponse_DataChange_GARBAGE_COLLECTION
	ReadChangeStreamResponse_DataChange_TYPE_UNSPECIFIED   = src.ReadChangeStreamResponse_DataChange_TYPE_UNSPECIFIED
	ReadChangeStreamResponse_DataChange_USER               = src.ReadChangeStreamResponse_DataChange_USER
	ReadRowsRequest_REQUEST_STATS_FULL                     = src.ReadRowsRequest_REQUEST_STATS_FULL
	ReadRowsRequest_REQUEST_STATS_NONE                     = src.ReadRowsRequest_REQUEST_STATS_NONE
	ReadRowsRequest_REQUEST_STATS_VIEW_UNSPECIFIED         = src.ReadRowsRequest_REQUEST_STATS_VIEW_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/bigtable/apiv2/bigtablepb
var (
	File_google_bigtable_v2_bigtable_proto         = src.File_google_bigtable_v2_bigtable_proto
	File_google_bigtable_v2_data_proto             = src.File_google_bigtable_v2_data_proto
	File_google_bigtable_v2_feature_flags_proto    = src.File_google_bigtable_v2_feature_flags_proto
	File_google_bigtable_v2_request_stats_proto    = src.File_google_bigtable_v2_request_stats_proto
	File_google_bigtable_v2_response_params_proto  = src.File_google_bigtable_v2_response_params_proto
	File_google_bigtable_v2_types_proto            = src.File_google_bigtable_v2_types_proto
	ReadChangeStreamResponse_DataChange_Type_name  = src.ReadChangeStreamResponse_DataChange_Type_name
	ReadChangeStreamResponse_DataChange_Type_value = src.ReadChangeStreamResponse_DataChange_Type_value
	ReadRowsRequest_RequestStatsView_name          = src.ReadRowsRequest_RequestStatsView_name
	ReadRowsRequest_RequestStatsView_value         = src.ReadRowsRequest_RequestStatsView_value
)

// `ArrayValue` is an ordered list of `Value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ArrayValue = src.ArrayValue

// BigtableClient is the client API for Bigtable service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type BigtableClient = src.BigtableClient

// BigtableServer is the server API for Bigtable service.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type BigtableServer = src.BigtableServer
type Bigtable_ExecuteQueryClient = src.Bigtable_ExecuteQueryClient
type Bigtable_ExecuteQueryServer = src.Bigtable_ExecuteQueryServer
type Bigtable_GenerateInitialChangeStreamPartitionsClient = src.Bigtable_GenerateInitialChangeStreamPartitionsClient
type Bigtable_GenerateInitialChangeStreamPartitionsServer = src.Bigtable_GenerateInitialChangeStreamPartitionsServer
type Bigtable_MutateRowsClient = src.Bigtable_MutateRowsClient
type Bigtable_MutateRowsServer = src.Bigtable_MutateRowsServer
type Bigtable_ReadChangeStreamClient = src.Bigtable_ReadChangeStreamClient
type Bigtable_ReadChangeStreamServer = src.Bigtable_ReadChangeStreamServer
type Bigtable_ReadRowsClient = src.Bigtable_ReadRowsClient
type Bigtable_ReadRowsServer = src.Bigtable_ReadRowsServer
type Bigtable_SampleRowKeysClient = src.Bigtable_SampleRowKeysClient
type Bigtable_SampleRowKeysServer = src.Bigtable_SampleRowKeysServer

// Specifies (some of) the contents of a single row/column/timestamp of a
// table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Cell = src.Cell

// Request message for Bigtable.CheckAndMutateRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type CheckAndMutateRowRequest = src.CheckAndMutateRowRequest

// Response message for Bigtable.CheckAndMutateRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type CheckAndMutateRowResponse = src.CheckAndMutateRowResponse

// Specifies (some of) the contents of a single row/column intersection of a
// table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Column = src.Column

// Describes a column in a Bigtable Query Language result set.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ColumnMetadata = src.ColumnMetadata

// Specifies a contiguous range of columns within a single column family. The
// range spans from &lt;column_family&gt;:&lt;start_qualifier&gt; to
// &lt;column_family&gt;:&lt;end_qualifier&gt;, where both bounds can be either
// inclusive or exclusive.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ColumnRange = src.ColumnRange
type ColumnRange_EndQualifierClosed = src.ColumnRange_EndQualifierClosed
type ColumnRange_EndQualifierOpen = src.ColumnRange_EndQualifierOpen
type ColumnRange_StartQualifierClosed = src.ColumnRange_StartQualifierClosed
type ColumnRange_StartQualifierOpen = src.ColumnRange_StartQualifierOpen

// Request message for Bigtable.ExecuteQuery
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ExecuteQueryRequest = src.ExecuteQueryRequest
type ExecuteQueryRequest_ProtoFormat = src.ExecuteQueryRequest_ProtoFormat

// Response message for Bigtable.ExecuteQuery
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ExecuteQueryResponse = src.ExecuteQueryResponse
type ExecuteQueryResponse_Metadata = src.ExecuteQueryResponse_Metadata
type ExecuteQueryResponse_Results = src.ExecuteQueryResponse_Results

// Specifies (some of) the contents of a single row/column family intersection
// of a table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Family = src.Family

// Feature flags supported or enabled by a client. This is intended to be sent
// as part of request metadata to assure the server that certain behaviors are
// safe to enable. This proto is meant to be serialized and websafe-base64
// encoded under the `bigtable-features` metadata key. The value will remain
// constant for the lifetime of a client and due to HTTP2's HPACK compression,
// the request overhead will be tiny. This is an internal implementation detail
// and should not be used by end users directly.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type FeatureFlags = src.FeatureFlags

// FullReadStatsView captures all known information about a read.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type FullReadStatsView = src.FullReadStatsView

// NOTE: This API is intended to be used by Apache Beam BigtableIO. Request
// message for Bigtable.GenerateInitialChangeStreamPartitions.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type GenerateInitialChangeStreamPartitionsRequest = src.GenerateInitialChangeStreamPartitionsRequest

// NOTE: This API is intended to be used by Apache Beam BigtableIO. Response
// message for Bigtable.GenerateInitialChangeStreamPartitions.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type GenerateInitialChangeStreamPartitionsResponse = src.GenerateInitialChangeStreamPartitionsResponse

// Request message for Bigtable.MutateRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowRequest = src.MutateRowRequest

// Response message for Bigtable.MutateRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowResponse = src.MutateRowResponse

// Request message for BigtableService.MutateRows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowsRequest = src.MutateRowsRequest

// A mutation for a given row.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowsRequest_Entry = src.MutateRowsRequest_Entry

// Response message for BigtableService.MutateRows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowsResponse = src.MutateRowsResponse

// The result of applying a passed mutation in the original request.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type MutateRowsResponse_Entry = src.MutateRowsResponse_Entry

// Specifies a particular change to be made to the contents of a row.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation = src.Mutation

// A Mutation which incrementally updates a cell in an `Aggregate` family.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_AddToCell = src.Mutation_AddToCell
type Mutation_AddToCell_ = src.Mutation_AddToCell_

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_DeleteFromColumn = src.Mutation_DeleteFromColumn
type Mutation_DeleteFromColumn_ = src.Mutation_DeleteFromColumn_

// A Mutation which deletes all cells from the specified column family.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_DeleteFromFamily = src.Mutation_DeleteFromFamily
type Mutation_DeleteFromFamily_ = src.Mutation_DeleteFromFamily_

// A Mutation which deletes all cells from the containing row.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_DeleteFromRow = src.Mutation_DeleteFromRow
type Mutation_DeleteFromRow_ = src.Mutation_DeleteFromRow_

// A Mutation which merges accumulated state into a cell in an `Aggregate`
// family.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_MergeToCell = src.Mutation_MergeToCell
type Mutation_MergeToCell_ = src.Mutation_MergeToCell_

// A Mutation which sets the value of the specified cell.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Mutation_SetCell = src.Mutation_SetCell
type Mutation_SetCell_ = src.Mutation_SetCell_

// A partial result set from the streaming query API. CBT client will buffer
// partial_rows from result_sets until it gets a resumption_token.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type PartialResultSet = src.PartialResultSet
type PartialResultSet_ProtoRowsBatch = src.PartialResultSet_ProtoRowsBatch

// Request message for client connection keep-alive and warming.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type PingAndWarmRequest = src.PingAndWarmRequest

// Response message for Bigtable.PingAndWarm connection keepalive and warming.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type PingAndWarmResponse = src.PingAndWarmResponse

// Protocol buffers format descriptor, as described by Messages ProtoSchema
// and ProtoRows
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ProtoFormat = src.ProtoFormat

// Rows represented in proto format. This should be constructed by
// concatenating the `batch_data` from each of the relevant `ProtoRowsBatch`
// messages and parsing the result as a `ProtoRows` message.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ProtoRows = src.ProtoRows

// Batch of serialized ProtoRows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ProtoRowsBatch = src.ProtoRowsBatch

// ResultSet schema in proto format
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ProtoSchema = src.ProtoSchema

// Information about how client should adjust the load to Bigtable.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RateLimitInfo = src.RateLimitInfo

// NOTE: This API is intended to be used by Apache Beam BigtableIO. Request
// message for Bigtable.ReadChangeStream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamRequest = src.ReadChangeStreamRequest
type ReadChangeStreamRequest_ContinuationTokens = src.ReadChangeStreamRequest_ContinuationTokens
type ReadChangeStreamRequest_StartTime = src.ReadChangeStreamRequest_StartTime

// NOTE: This API is intended to be used by Apache Beam BigtableIO. Response
// message for Bigtable.ReadChangeStream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse = src.ReadChangeStreamResponse

// A message indicating that the client should stop reading from the stream.
// If status is OK and `continuation_tokens` & `new_partitions` are empty, the
// stream has finished (for example if there was an `end_time` specified). If
// `continuation_tokens` & `new_partitions` are present, then a change in
// partitioning requires the client to open a new stream for each token to
// resume reading. Example: [B, D) ends | v new_partitions: [A, C) [C, E)
// continuation_tokens.partitions: [B,C) [C,D) ^---^ ^---^ ^ ^ | | |
// StreamContinuationToken 2 | StreamContinuationToken 1 To read the new
// partition [A,C), supply the continuation tokens whose ranges cover the new
// partition, for example ContinuationToken[A,B) & ContinuationToken[B,C).
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_CloseStream = src.ReadChangeStreamResponse_CloseStream
type ReadChangeStreamResponse_CloseStream_ = src.ReadChangeStreamResponse_CloseStream_

// A message corresponding to one or more mutations to the partition being
// streamed. A single logical `DataChange` message may also be split across a
// sequence of multiple individual messages. Messages other than the first in a
// sequence will only have the `type` and `chunks` fields populated, with the
// final message in the sequence also containing `done` set to true.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_DataChange = src.ReadChangeStreamResponse_DataChange
type ReadChangeStreamResponse_DataChange_ = src.ReadChangeStreamResponse_DataChange_

// The type of mutation.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_DataChange_Type = src.ReadChangeStreamResponse_DataChange_Type

// A periodic message with information that can be used to checkpoint the
// state of a stream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_Heartbeat = src.ReadChangeStreamResponse_Heartbeat
type ReadChangeStreamResponse_Heartbeat_ = src.ReadChangeStreamResponse_Heartbeat_

// A partial or complete mutation.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_MutationChunk = src.ReadChangeStreamResponse_MutationChunk

// Information about the chunking of this mutation. Only `SetCell` mutations
// can be chunked, and all chunks for a `SetCell` will be delivered
// contiguously with no other mutation types interleaved.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadChangeStreamResponse_MutationChunk_ChunkInfo = src.ReadChangeStreamResponse_MutationChunk_ChunkInfo

// ReadIterationStats captures information about the iteration of rows or
// cells over the course of a read, e.g. how many results were scanned in a
// read operation versus the results returned.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadIterationStats = src.ReadIterationStats

// Request message for Bigtable.ReadModifyWriteRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadModifyWriteRowRequest = src.ReadModifyWriteRowRequest

// Response message for Bigtable.ReadModifyWriteRow.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadModifyWriteRowResponse = src.ReadModifyWriteRowResponse

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadModifyWriteRule = src.ReadModifyWriteRule
type ReadModifyWriteRule_AppendValue = src.ReadModifyWriteRule_AppendValue
type ReadModifyWriteRule_IncrementAmount = src.ReadModifyWriteRule_IncrementAmount

// Request message for Bigtable.ReadRows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadRowsRequest = src.ReadRowsRequest

// The desired view into RequestStats that should be returned in the response.
// See also: RequestStats message.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadRowsRequest_RequestStatsView = src.ReadRowsRequest_RequestStatsView

// Response message for Bigtable.ReadRows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadRowsResponse = src.ReadRowsResponse

// Specifies a piece of a row's contents returned as part of the read response
// stream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ReadRowsResponse_CellChunk = src.ReadRowsResponse_CellChunk
type ReadRowsResponse_CellChunk_CommitRow = src.ReadRowsResponse_CellChunk_CommitRow
type ReadRowsResponse_CellChunk_ResetRow = src.ReadRowsResponse_CellChunk_ResetRow

// RequestLatencyStats provides a measurement of the latency of the request as
// it interacts with different systems over its lifetime, e.g. how long the
// request took to execute within a frontend server.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RequestLatencyStats = src.RequestLatencyStats

// RequestStats is the container for additional information pertaining to a
// single request, helpful for evaluating the performance of the sent request.
// Currently, there are the following supported methods: -
// google.bigtable.v2.ReadRows
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RequestStats = src.RequestStats
type RequestStats_FullReadStatsView = src.RequestStats_FullReadStatsView

// Response metadata proto This is an experimental feature that will be used
// to get zone_id and cluster_id from response trailers to tag the metrics.
// This should not be used by customers directly
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ResponseParams = src.ResponseParams

// Describes the structure of a Bigtable result set.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ResultSetMetadata = src.ResultSetMetadata
type ResultSetMetadata_ProtoSchema = src.ResultSetMetadata_ProtoSchema

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Row = src.Row

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X." There are two broad categories of
// RowFilters (true filters and transformers), as well as two ways to compose
// simple filters into more complex ones (chains and interleaves). They work as
// follows: * True filters alter the input row by excluding some of its cells
// wholesale from the output row. An example of a true filter is the
// `value_regex_filter`, which excludes cells whose values don't match the
// specified pattern. All regex true filters use RE2 syntax
// (https://github.com/google/re2/wiki/Syntax) in raw byte mode (RE2::Latin1),
// and are evaluated as full matches. An important point to keep in mind is
// that `RE2(.)` is equivalent by default to `RE2([^\n])`, meaning that it does
// not match newlines. When attempting to match an arbitrary byte, you should
// therefore use the escape sequence `\C`, which may need to be further escaped
// as `\\C` in your client language. * Transformers alter the input row by
// changing the values of some of its cells in the output, without excluding
// them completely. Currently, the only supported transformer is the
// `strip_value_transformer`, which replaces every cell's value with the empty
// string. * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation. The total serialized
// size of a RowFilter message must not exceed 20480 bytes, and RowFilters may
// not be nested within each other (in Chains or Interleaves) to a depth of
// more than 20.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowFilter = src.RowFilter
type RowFilter_ApplyLabelTransformer = src.RowFilter_ApplyLabelTransformer
type RowFilter_BlockAllFilter = src.RowFilter_BlockAllFilter
type RowFilter_CellsPerColumnLimitFilter = src.RowFilter_CellsPerColumnLimitFilter
type RowFilter_CellsPerRowLimitFilter = src.RowFilter_CellsPerRowLimitFilter
type RowFilter_CellsPerRowOffsetFilter = src.RowFilter_CellsPerRowOffsetFilter

// A RowFilter which sends rows through several RowFilters in sequence.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowFilter_Chain = src.RowFilter_Chain
type RowFilter_Chain_ = src.RowFilter_Chain_
type RowFilter_ColumnQualifierRegexFilter = src.RowFilter_ColumnQualifierRegexFilter
type RowFilter_ColumnRangeFilter = src.RowFilter_ColumnRangeFilter

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowFilter_Condition = src.RowFilter_Condition
type RowFilter_Condition_ = src.RowFilter_Condition_
type RowFilter_FamilyNameRegexFilter = src.RowFilter_FamilyNameRegexFilter

// A RowFilter which sends each row to each of several component RowFilters
// and interleaves the results.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowFilter_Interleave = src.RowFilter_Interleave
type RowFilter_Interleave_ = src.RowFilter_Interleave_
type RowFilter_PassAllFilter = src.RowFilter_PassAllFilter
type RowFilter_RowKeyRegexFilter = src.RowFilter_RowKeyRegexFilter
type RowFilter_RowSampleFilter = src.RowFilter_RowSampleFilter
type RowFilter_Sink = src.RowFilter_Sink
type RowFilter_StripValueTransformer = src.RowFilter_StripValueTransformer
type RowFilter_TimestampRangeFilter = src.RowFilter_TimestampRangeFilter
type RowFilter_ValueRangeFilter = src.RowFilter_ValueRangeFilter
type RowFilter_ValueRegexFilter = src.RowFilter_ValueRegexFilter

// Specifies a contiguous range of rows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowRange = src.RowRange
type RowRange_EndKeyClosed = src.RowRange_EndKeyClosed
type RowRange_EndKeyOpen = src.RowRange_EndKeyOpen
type RowRange_StartKeyClosed = src.RowRange_StartKeyClosed
type RowRange_StartKeyOpen = src.RowRange_StartKeyOpen

// Specifies a non-contiguous set of rows.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type RowSet = src.RowSet

// Request message for Bigtable.SampleRowKeys.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type SampleRowKeysRequest = src.SampleRowKeysRequest

// Response message for Bigtable.SampleRowKeys.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type SampleRowKeysResponse = src.SampleRowKeysResponse

// NOTE: This API is intended to be used by Apache Beam BigtableIO. The
// information required to continue reading the data from a `StreamPartition`
// from where a previous read left off.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type StreamContinuationToken = src.StreamContinuationToken

// NOTE: This API is intended to be used by Apache Beam BigtableIO. The
// information required to continue reading the data from multiple
// `StreamPartitions` from where a previous read left off.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type StreamContinuationTokens = src.StreamContinuationTokens

// NOTE: This API is intended to be used by Apache Beam BigtableIO. A
// partition of a change stream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type StreamPartition = src.StreamPartition

// Specified a contiguous range of microsecond timestamps.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type TimestampRange = src.TimestampRange

// `Type` represents the type of data that is written to, read from, or stored
// in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
// familiarity and consistency across products and features. For compatibility
// with Bigtable's existing untyped APIs, each `Type` includes an `Encoding`
// which describes how to convert to/from the underlying data. Each encoding
// also defines the following properties: - Order-preserving: Does the encoded
// value sort consistently with the original typed value? Note that Bigtable
// will always sort data based on the raw encoded value, *not* the decoded
// type. - Example: BYTES values sort in the same order as their raw encodings.
// - Counterexample: Encoding INT64 as a fixed-width decimal string does *not*
// preserve sort order when dealing with negative numbers. `INT64(1) >
// INT64(-1)`, but `STRING("-00001") > STRING("00001)`. - Self-delimiting: If
// we concatenate two encoded values, can we always tell where the first one
// ends and the second one begins? - Example: If we encode INT64s to
// fixed-width STRINGs, the first value will always contain exactly N digits,
// possibly preceded by a sign. - Counterexample: If we concatenate two UTF-8
// encoded STRINGs, we have no way to tell where the first one ends. -
// Compatibility: Which other systems have matching encoding schemes? For
// example, does this encoding have a GoogleSQL equivalent? HBase? Java?
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type = src.Type

// A value that combines incremental updates into a summarized value. Data is
// never directly written or read using type `Aggregate`. Writes will provide
// either the `input_type` or `state_type`, and reads will always return the
// `state_type` .
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Aggregate = src.Type_Aggregate
type Type_AggregateType = src.Type_AggregateType
type Type_Aggregate_HllppUniqueCount = src.Type_Aggregate_HllppUniqueCount

// Computes an approximate unique count over the input values. When using raw
// data as input, be careful to use a consistent encoding. Otherwise the same
// value encoded differently could count more than once, or two distinct values
// could count as identical. Input: Any, or omit for Raw State: TBD Special
// state conversions: `Int64` (the unique count estimate)
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Aggregate_HyperLogLogPlusPlusUniqueCount = src.Type_Aggregate_HyperLogLogPlusPlusUniqueCount

// Computes the max of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Aggregate_Max = src.Type_Aggregate_Max
type Type_Aggregate_Max_ = src.Type_Aggregate_Max_

// Computes the min of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Aggregate_Min = src.Type_Aggregate_Min
type Type_Aggregate_Min_ = src.Type_Aggregate_Min_

// Computes the sum of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Aggregate_Sum = src.Type_Aggregate_Sum
type Type_Aggregate_Sum_ = src.Type_Aggregate_Sum_

// An ordered list of elements of a given type. Values of type `Array` are
// stored in `Value.array_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Array = src.Type_Array
type Type_ArrayType = src.Type_ArrayType

// bool Values of type `Bool` are stored in `Value.bool_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Bool = src.Type_Bool
type Type_BoolType = src.Type_BoolType

// Bytes Values of type `Bytes` are stored in `Value.bytes_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Bytes = src.Type_Bytes
type Type_BytesType = src.Type_BytesType

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Bytes_Encoding = src.Type_Bytes_Encoding

// Leaves the value "as-is" * Order-preserving? Yes * Self-delimiting? No *
// Compatibility? N/A
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Bytes_Encoding_Raw = src.Type_Bytes_Encoding_Raw
type Type_Bytes_Encoding_Raw_ = src.Type_Bytes_Encoding_Raw_

// Date Values of type `Date` are stored in `Value.date_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Date = src.Type_Date
type Type_DateType = src.Type_DateType

// Float32 Values of type `Float32` are stored in `Value.float_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Float32 = src.Type_Float32
type Type_Float32Type = src.Type_Float32Type

// Float64 Values of type `Float64` are stored in `Value.float_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Float64 = src.Type_Float64
type Type_Float64Type = src.Type_Float64Type

// Int64 Values of type `Int64` are stored in `Value.int_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Int64 = src.Type_Int64
type Type_Int64Type = src.Type_Int64Type

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Int64_Encoding = src.Type_Int64_Encoding

// Encodes the value as an 8-byte big endian twos complement `Bytes` value. *
// Order-preserving? No (positive values only) * Self-delimiting? Yes *
// Compatibility? - BigQuery Federation `BINARY` encoding - HBase
// `Bytes.toBytes` - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Int64_Encoding_BigEndianBytes = src.Type_Int64_Encoding_BigEndianBytes
type Type_Int64_Encoding_BigEndianBytes_ = src.Type_Int64_Encoding_BigEndianBytes_

// A mapping of keys to values of a given type. Values of type `Map` are
// stored in a `Value.array_value` where each entry is another
// `Value.array_value` with two elements (the key and the value, in that
// order). Normally encoded Map values won't have repeated keys, however,
// clients are expected to handle the case in which they do. If the same key
// appears multiple times, the _last_ value takes precedence.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Map = src.Type_Map
type Type_MapType = src.Type_MapType

// String Values of type `String` are stored in `Value.string_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_String = src.Type_String
type Type_StringType = src.Type_StringType

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_String_Encoding = src.Type_String_Encoding

// UTF-8 encoding * Order-preserving? Yes (code point order) *
// Self-delimiting? No * Compatibility? - BigQuery Federation `TEXT` encoding -
// HBase `Bytes.toBytes` - Java `String#getBytes(StandardCharsets.UTF_8)`
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_String_Encoding_Utf8Bytes = src.Type_String_Encoding_Utf8Bytes
type Type_String_Encoding_Utf8Bytes_ = src.Type_String_Encoding_Utf8Bytes_

// Deprecated: prefer the equivalent `Utf8Bytes`. Deprecated: Marked as
// deprecated in google/bigtable/v2/types.proto.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_String_Encoding_Utf8Raw = src.Type_String_Encoding_Utf8Raw
type Type_String_Encoding_Utf8Raw_ = src.Type_String_Encoding_Utf8Raw_

// A structured data value, consisting of fields which map to dynamically
// typed values. Values of type `Struct` are stored in `Value.array_value`
// where entries are in the same order and number as `field_types`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Struct = src.Type_Struct
type Type_StructType = src.Type_StructType

// A struct field and its type.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Struct_Field = src.Type_Struct_Field

// Timestamp Values of type `Timestamp` are stored in `Value.timestamp_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Type_Timestamp = src.Type_Timestamp
type Type_TimestampType = src.Type_TimestampType

// UnimplementedBigtableServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type UnimplementedBigtableServer = src.UnimplementedBigtableServer

// `Value` represents a dynamically typed value. The typed fields in `Value`
// are used as a transport encoding for the actual value (which may be of a
// more complex type). See the documentation of the `Type` message for more
// details.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type Value = src.Value

// Specifies a contiguous range of raw byte values.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/apiv2/bigtablepb
type ValueRange = src.ValueRange
type ValueRange_EndValueClosed = src.ValueRange_EndValueClosed
type ValueRange_EndValueOpen = src.ValueRange_EndValueOpen
type ValueRange_StartValueClosed = src.ValueRange_StartValueClosed
type ValueRange_StartValueOpen = src.ValueRange_StartValueOpen
type Value_ArrayValue = src.Value_ArrayValue
type Value_BoolValue = src.Value_BoolValue
type Value_BytesValue = src.Value_BytesValue
type Value_DateValue = src.Value_DateValue
type Value_FloatValue = src.Value_FloatValue
type Value_IntValue = src.Value_IntValue
type Value_RawTimestampMicros = src.Value_RawTimestampMicros
type Value_RawValue = src.Value_RawValue
type Value_StringValue = src.Value_StringValue
type Value_TimestampValue = src.Value_TimestampValue

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/apiv2/bigtablepb
func NewBigtableClient(cc grpc.ClientConnInterface) BigtableClient { return src.NewBigtableClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/apiv2/bigtablepb
func RegisterBigtableServer(s *grpc.Server, srv BigtableServer) { src.RegisterBigtableServer(s, srv) }
