// Code generated by go-swagger; DO NOT EDIT.

// Copyright Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package silence

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/prometheus/alertmanager/api/v2/models"
)

// GetSilencesReader is a Reader for the GetSilences structure.
type GetSilencesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSilencesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSilencesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewGetSilencesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetSilencesOK creates a GetSilencesOK with default headers values
func NewGetSilencesOK() *GetSilencesOK {
	return &GetSilencesOK{}
}

/*
GetSilencesOK describes a response with status code 200, with default header values.

Get silences response
*/
type GetSilencesOK struct {
	Payload models.GettableSilences
}

// IsSuccess returns true when this get silences o k response has a 2xx status code
func (o *GetSilencesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get silences o k response has a 3xx status code
func (o *GetSilencesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get silences o k response has a 4xx status code
func (o *GetSilencesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get silences o k response has a 5xx status code
func (o *GetSilencesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get silences o k response a status code equal to that given
func (o *GetSilencesOK) IsCode(code int) bool {
	return code == 200
}

func (o *GetSilencesOK) Error() string {
	return fmt.Sprintf("[GET /silences][%d] getSilencesOK  %+v", 200, o.Payload)
}

func (o *GetSilencesOK) String() string {
	return fmt.Sprintf("[GET /silences][%d] getSilencesOK  %+v", 200, o.Payload)
}

func (o *GetSilencesOK) GetPayload() models.GettableSilences {
	return o.Payload
}

func (o *GetSilencesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSilencesInternalServerError creates a GetSilencesInternalServerError with default headers values
func NewGetSilencesInternalServerError() *GetSilencesInternalServerError {
	return &GetSilencesInternalServerError{}
}

/*
GetSilencesInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type GetSilencesInternalServerError struct {
	Payload string
}

// IsSuccess returns true when this get silences internal server error response has a 2xx status code
func (o *GetSilencesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get silences internal server error response has a 3xx status code
func (o *GetSilencesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get silences internal server error response has a 4xx status code
func (o *GetSilencesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get silences internal server error response has a 5xx status code
func (o *GetSilencesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get silences internal server error response a status code equal to that given
func (o *GetSilencesInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *GetSilencesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /silences][%d] getSilencesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetSilencesInternalServerError) String() string {
	return fmt.Sprintf("[GET /silences][%d] getSilencesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetSilencesInternalServerError) GetPayload() string {
	return o.Payload
}

func (o *GetSilencesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
