// Code generated by protoc-gen-go4grpc; DO NOT EDIT
// source: api.proto

/*
Package apipb is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	HasAncestorRequest
	HasAncestorResponse
	GetRefRequest
	GetRefResponse
	GoFindTryWorkRequest
	GoFindTryWorkResponse
	GerritTryWorkItem
	TryVoteMessage
	MajorMinor
	ListGoReleasesRequest
	ListGoReleasesResponse
	GoRelease
	DashboardRequest
	DashboardResponse
	DashCommit
	DashRepoHead
*/
package apipb

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "context"
	grpc "grpc.go4.org"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type HasAncestorRequest struct {
	Commit   string `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
	Ancestor string `protobuf:"bytes,2,opt,name=ancestor" json:"ancestor,omitempty"`
}

func (m *HasAncestorRequest) Reset()                    { *m = HasAncestorRequest{} }
func (m *HasAncestorRequest) String() string            { return proto.CompactTextString(m) }
func (*HasAncestorRequest) ProtoMessage()               {}
func (*HasAncestorRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *HasAncestorRequest) GetCommit() string {
	if m != nil {
		return m.Commit
	}
	return ""
}

func (m *HasAncestorRequest) GetAncestor() string {
	if m != nil {
		return m.Ancestor
	}
	return ""
}

type HasAncestorResponse struct {
	// has_ancestor is whether ancestor appears in commit's history.
	HasAncestor bool `protobuf:"varint,1,opt,name=has_ancestor,json=hasAncestor" json:"has_ancestor,omitempty"`
	// unknown_commit is true if the provided commit was unknown.
	UnknownCommit bool `protobuf:"varint,2,opt,name=unknown_commit,json=unknownCommit" json:"unknown_commit,omitempty"`
}

func (m *HasAncestorResponse) Reset()                    { *m = HasAncestorResponse{} }
func (m *HasAncestorResponse) String() string            { return proto.CompactTextString(m) }
func (*HasAncestorResponse) ProtoMessage()               {}
func (*HasAncestorResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *HasAncestorResponse) GetHasAncestor() bool {
	if m != nil {
		return m.HasAncestor
	}
	return false
}

func (m *HasAncestorResponse) GetUnknownCommit() bool {
	if m != nil {
		return m.UnknownCommit
	}
	return false
}

type GetRefRequest struct {
	Ref string `protobuf:"bytes,1,opt,name=ref" json:"ref,omitempty"`
	// Either gerrit_server & gerrit_project must be specified, or
	// github. Currently only Gerrit is supported.
	GerritServer  string `protobuf:"bytes,2,opt,name=gerrit_server,json=gerritServer" json:"gerrit_server,omitempty"`
	GerritProject string `protobuf:"bytes,3,opt,name=gerrit_project,json=gerritProject" json:"gerrit_project,omitempty"`
}

func (m *GetRefRequest) Reset()                    { *m = GetRefRequest{} }
func (m *GetRefRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRefRequest) ProtoMessage()               {}
func (*GetRefRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GetRefRequest) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *GetRefRequest) GetGerritServer() string {
	if m != nil {
		return m.GerritServer
	}
	return ""
}

func (m *GetRefRequest) GetGerritProject() string {
	if m != nil {
		return m.GerritProject
	}
	return ""
}

type GetRefResponse struct {
	Value string `protobuf:"bytes,1,opt,name=value" json:"value,omitempty"`
}

func (m *GetRefResponse) Reset()                    { *m = GetRefResponse{} }
func (m *GetRefResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRefResponse) ProtoMessage()               {}
func (*GetRefResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GetRefResponse) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type GoFindTryWorkRequest struct {
	// for_staging says whether this is a trybot request for the staging
	// cluster. When using staging, the comment "Run-StagingTryBot"
	// is used instead of label:Run-TryBot=1.
	ForStaging bool `protobuf:"varint,1,opt,name=for_staging,json=forStaging" json:"for_staging,omitempty"`
}

func (m *GoFindTryWorkRequest) Reset()                    { *m = GoFindTryWorkRequest{} }
func (m *GoFindTryWorkRequest) String() string            { return proto.CompactTextString(m) }
func (*GoFindTryWorkRequest) ProtoMessage()               {}
func (*GoFindTryWorkRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GoFindTryWorkRequest) GetForStaging() bool {
	if m != nil {
		return m.ForStaging
	}
	return false
}

type GoFindTryWorkResponse struct {
	// waiting are the Gerrit CLs wanting a trybot run and not yet with results.
	// These might already be running.
	Waiting []*GerritTryWorkItem `protobuf:"bytes,1,rep,name=waiting" json:"waiting,omitempty"`
}

func (m *GoFindTryWorkResponse) Reset()                    { *m = GoFindTryWorkResponse{} }
func (m *GoFindTryWorkResponse) String() string            { return proto.CompactTextString(m) }
func (*GoFindTryWorkResponse) ProtoMessage()               {}
func (*GoFindTryWorkResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GoFindTryWorkResponse) GetWaiting() []*GerritTryWorkItem {
	if m != nil {
		return m.Waiting
	}
	return nil
}

type GerritTryWorkItem struct {
	Project  string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	Branch   string `protobuf:"bytes,2,opt,name=branch" json:"branch,omitempty"`
	ChangeId string `protobuf:"bytes,3,opt,name=change_id,json=changeId" json:"change_id,omitempty"`
	Commit   string `protobuf:"bytes,4,opt,name=commit" json:"commit,omitempty"`
	Version  int32  `protobuf:"varint,9,opt,name=version" json:"version,omitempty"`
	// go_commit is set for subrepos and is the Go commit(s) to test against.
	// go_branch is a branch name of go_commit, for showing to users when
	// a try set fails.
	GoCommit []string `protobuf:"bytes,5,rep,name=go_commit,json=goCommit" json:"go_commit,omitempty"`
	GoBranch []string `protobuf:"bytes,6,rep,name=go_branch,json=goBranch" json:"go_branch,omitempty"`
	// go_version specifies the major and minor version of the targeted Go toolchain.
	// For Go repo, it contains exactly one element.
	// For subrepos, it contains elements that correspond to go_commit.
	GoVersion []*MajorMinor `protobuf:"bytes,7,rep,name=go_version,json=goVersion" json:"go_version,omitempty"`
	// try_message is the list of TRY=xxxx messages associated with Run-TryBot votes.
	TryMessage []*TryVoteMessage `protobuf:"bytes,8,rep,name=try_message,json=tryMessage" json:"try_message,omitempty"`
}

func (m *GerritTryWorkItem) Reset()                    { *m = GerritTryWorkItem{} }
func (m *GerritTryWorkItem) String() string            { return proto.CompactTextString(m) }
func (*GerritTryWorkItem) ProtoMessage()               {}
func (*GerritTryWorkItem) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GerritTryWorkItem) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *GerritTryWorkItem) GetBranch() string {
	if m != nil {
		return m.Branch
	}
	return ""
}

func (m *GerritTryWorkItem) GetChangeId() string {
	if m != nil {
		return m.ChangeId
	}
	return ""
}

func (m *GerritTryWorkItem) GetCommit() string {
	if m != nil {
		return m.Commit
	}
	return ""
}

func (m *GerritTryWorkItem) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *GerritTryWorkItem) GetGoCommit() []string {
	if m != nil {
		return m.GoCommit
	}
	return nil
}

func (m *GerritTryWorkItem) GetGoBranch() []string {
	if m != nil {
		return m.GoBranch
	}
	return nil
}

func (m *GerritTryWorkItem) GetGoVersion() []*MajorMinor {
	if m != nil {
		return m.GoVersion
	}
	return nil
}

func (m *GerritTryWorkItem) GetTryMessage() []*TryVoteMessage {
	if m != nil {
		return m.TryMessage
	}
	return nil
}

type TryVoteMessage struct {
	Message  string `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
	AuthorId int64  `protobuf:"varint,2,opt,name=author_id,json=authorId" json:"author_id,omitempty"`
	Version  int32  `protobuf:"varint,3,opt,name=version" json:"version,omitempty"`
}

func (m *TryVoteMessage) Reset()                    { *m = TryVoteMessage{} }
func (m *TryVoteMessage) String() string            { return proto.CompactTextString(m) }
func (*TryVoteMessage) ProtoMessage()               {}
func (*TryVoteMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *TryVoteMessage) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *TryVoteMessage) GetAuthorId() int64 {
	if m != nil {
		return m.AuthorId
	}
	return 0
}

func (m *TryVoteMessage) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

type MajorMinor struct {
	Major int32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor int32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
}

func (m *MajorMinor) Reset()                    { *m = MajorMinor{} }
func (m *MajorMinor) String() string            { return proto.CompactTextString(m) }
func (*MajorMinor) ProtoMessage()               {}
func (*MajorMinor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *MajorMinor) GetMajor() int32 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *MajorMinor) GetMinor() int32 {
	if m != nil {
		return m.Minor
	}
	return 0
}

type ListGoReleasesRequest struct {
}

func (m *ListGoReleasesRequest) Reset()                    { *m = ListGoReleasesRequest{} }
func (m *ListGoReleasesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListGoReleasesRequest) ProtoMessage()               {}
func (*ListGoReleasesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type ListGoReleasesResponse struct {
	Releases []*GoRelease `protobuf:"bytes,1,rep,name=releases" json:"releases,omitempty"`
}

func (m *ListGoReleasesResponse) Reset()                    { *m = ListGoReleasesResponse{} }
func (m *ListGoReleasesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListGoReleasesResponse) ProtoMessage()               {}
func (*ListGoReleasesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ListGoReleasesResponse) GetReleases() []*GoRelease {
	if m != nil {
		return m.Releases
	}
	return nil
}

type GoRelease struct {
	Major     int32  `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor     int32  `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch     int32  `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	TagName   string `protobuf:"bytes,4,opt,name=tag_name,json=tagName" json:"tag_name,omitempty"`
	TagCommit string `protobuf:"bytes,5,opt,name=tag_commit,json=tagCommit" json:"tag_commit,omitempty"`
	// Release branch information for this major-minor version pair.
	BranchName   string `protobuf:"bytes,6,opt,name=branch_name,json=branchName" json:"branch_name,omitempty"`
	BranchCommit string `protobuf:"bytes,7,opt,name=branch_commit,json=branchCommit" json:"branch_commit,omitempty"`
}

func (m *GoRelease) Reset()                    { *m = GoRelease{} }
func (m *GoRelease) String() string            { return proto.CompactTextString(m) }
func (*GoRelease) ProtoMessage()               {}
func (*GoRelease) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GoRelease) GetMajor() int32 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *GoRelease) GetMinor() int32 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *GoRelease) GetPatch() int32 {
	if m != nil {
		return m.Patch
	}
	return 0
}

func (m *GoRelease) GetTagName() string {
	if m != nil {
		return m.TagName
	}
	return ""
}

func (m *GoRelease) GetTagCommit() string {
	if m != nil {
		return m.TagCommit
	}
	return ""
}

func (m *GoRelease) GetBranchName() string {
	if m != nil {
		return m.BranchName
	}
	return ""
}

func (m *GoRelease) GetBranchCommit() string {
	if m != nil {
		return m.BranchCommit
	}
	return ""
}

type DashboardRequest struct {
	// page is the zero-based page number.
	// TODO: deprecate, replace with time or commit continuation token.
	Page int32 `protobuf:"varint,1,opt,name=page" json:"page,omitempty"`
	// repo is which repo to show ("go", "golang.org/x/net", "" means go).
	Repo string `protobuf:"bytes,2,opt,name=repo" json:"repo,omitempty"`
	// branch specifies which branch to show ("master", "release-branch.go1.13").
	// Empty means "master".
	// The special branch value "mixed" means to blend together all branches by commit time.
	Branch string `protobuf:"bytes,3,opt,name=branch" json:"branch,omitempty"`
	// max_commits specifies the number of commits that are desired.
	// Zero means to use a default.
	MaxCommits int32 `protobuf:"varint,4,opt,name=max_commits,json=maxCommits" json:"max_commits,omitempty"`
}

func (m *DashboardRequest) Reset()                    { *m = DashboardRequest{} }
func (m *DashboardRequest) String() string            { return proto.CompactTextString(m) }
func (*DashboardRequest) ProtoMessage()               {}
func (*DashboardRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *DashboardRequest) GetPage() int32 {
	if m != nil {
		return m.Page
	}
	return 0
}

func (m *DashboardRequest) GetRepo() string {
	if m != nil {
		return m.Repo
	}
	return ""
}

func (m *DashboardRequest) GetBranch() string {
	if m != nil {
		return m.Branch
	}
	return ""
}

func (m *DashboardRequest) GetMaxCommits() int32 {
	if m != nil {
		return m.MaxCommits
	}
	return 0
}

type DashboardResponse struct {
	// commits are the commits to display, starting with the newest.
	Commits []*DashCommit `protobuf:"bytes,1,rep,name=commits" json:"commits,omitempty"`
	// commits_truncated is whether the returned commits were truncated.
	CommitsTruncated bool `protobuf:"varint,5,opt,name=commits_truncated,json=commitsTruncated" json:"commits_truncated,omitempty"`
	// repo_heads contains the current head commit (of their master
	// branch) for every repo on Go's Gerrit server.
	RepoHeads []*DashRepoHead `protobuf:"bytes,2,rep,name=repo_heads,json=repoHeads" json:"repo_heads,omitempty"`
	Branches  []string        `protobuf:"bytes,3,rep,name=branches" json:"branches,omitempty"`
	// releases is the same content is ListGoReleasesResponse, but with the addition of a "master"
	// release first, containing the info for the "master" branch, which is just commits[0]
	// if page 0. But if page != 0, the master head wouldn't be
	// available otherwise, so we denormalize it a bit here:
	// It's sorted from newest to oldest (master, release-branch.go1.latest, release-branch.go1.prior)
	// Only the branch_name and branch_commit fields are guaranteed to be populated.
	Releases []*GoRelease `protobuf:"bytes,4,rep,name=releases" json:"releases,omitempty"`
}

func (m *DashboardResponse) Reset()                    { *m = DashboardResponse{} }
func (m *DashboardResponse) String() string            { return proto.CompactTextString(m) }
func (*DashboardResponse) ProtoMessage()               {}
func (*DashboardResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DashboardResponse) GetCommits() []*DashCommit {
	if m != nil {
		return m.Commits
	}
	return nil
}

func (m *DashboardResponse) GetCommitsTruncated() bool {
	if m != nil {
		return m.CommitsTruncated
	}
	return false
}

func (m *DashboardResponse) GetRepoHeads() []*DashRepoHead {
	if m != nil {
		return m.RepoHeads
	}
	return nil
}

func (m *DashboardResponse) GetBranches() []string {
	if m != nil {
		return m.Branches
	}
	return nil
}

func (m *DashboardResponse) GetReleases() []*GoRelease {
	if m != nil {
		return m.Releases
	}
	return nil
}

type DashCommit struct {
	// commit is the git commit hash ("26957168c4c0cdcc7ca4f0b19d0eb19474d224ac").
	Commit string `protobuf:"bytes,1,opt,name=commit" json:"commit,omitempty"`
	// author_name is the git author name part ("Foo Bar").
	AuthorName string `protobuf:"bytes,2,opt,name=author_name,json=authorName" json:"author_name,omitempty"`
	// author_email is the git author email part ("foo@bar.com").
	AuthorEmail string `protobuf:"bytes,3,opt,name=author_email,json=authorEmail" json:"author_email,omitempty"`
	// commit_time_sec is the timestamp of git commit time, in unix seconds.
	CommitTimeSec int64 `protobuf:"varint,4,opt,name=commit_time_sec,json=commitTimeSec" json:"commit_time_sec,omitempty"`
	// title is the git commit's first line ("runtime: fix all the bugs").
	Title string `protobuf:"bytes,5,opt,name=title" json:"title,omitempty"`
	// branch is the branch this commit was queried from ("master", "release-branch.go1.14")/
	// This is normally redundant but is useful when DashboardRequest.branch == "mixed".
	Branch string `protobuf:"bytes,7,opt,name=branch" json:"branch,omitempty"`
	// For non-go repos, go_commit_at_time is what the Go master commit was at
	// the time of DashCommit.commit_time.
	GoCommitAtTime string `protobuf:"bytes,6,opt,name=go_commit_at_time,json=goCommitAtTime" json:"go_commit_at_time,omitempty"`
	// For non-go repos, go_commit_latest is the most recent Go master commit that's
	// older than the the following x/foo commit's commit_time.
	// If DashCommit is the current HEAD, go_commit_at_time can continue to update.
	// go_commit_at_time might be the same as go_commit_at_time.
	GoCommitLatest string `protobuf:"bytes,8,opt,name=go_commit_latest,json=goCommitLatest" json:"go_commit_latest,omitempty"`
}

func (m *DashCommit) Reset()                    { *m = DashCommit{} }
func (m *DashCommit) String() string            { return proto.CompactTextString(m) }
func (*DashCommit) ProtoMessage()               {}
func (*DashCommit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DashCommit) GetCommit() string {
	if m != nil {
		return m.Commit
	}
	return ""
}

func (m *DashCommit) GetAuthorName() string {
	if m != nil {
		return m.AuthorName
	}
	return ""
}

func (m *DashCommit) GetAuthorEmail() string {
	if m != nil {
		return m.AuthorEmail
	}
	return ""
}

func (m *DashCommit) GetCommitTimeSec() int64 {
	if m != nil {
		return m.CommitTimeSec
	}
	return 0
}

func (m *DashCommit) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *DashCommit) GetBranch() string {
	if m != nil {
		return m.Branch
	}
	return ""
}

func (m *DashCommit) GetGoCommitAtTime() string {
	if m != nil {
		return m.GoCommitAtTime
	}
	return ""
}

func (m *DashCommit) GetGoCommitLatest() string {
	if m != nil {
		return m.GoCommitLatest
	}
	return ""
}

type DashRepoHead struct {
	// gerrit_project is Gerrit project name ("net", "go").
	GerritProject string `protobuf:"bytes,1,opt,name=gerrit_project,json=gerritProject" json:"gerrit_project,omitempty"`
	// commit is the current top-level commit in that project.
	// (currently always on the master branch)
	Commit *DashCommit `protobuf:"bytes,2,opt,name=commit" json:"commit,omitempty"`
}

func (m *DashRepoHead) Reset()                    { *m = DashRepoHead{} }
func (m *DashRepoHead) String() string            { return proto.CompactTextString(m) }
func (*DashRepoHead) ProtoMessage()               {}
func (*DashRepoHead) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *DashRepoHead) GetGerritProject() string {
	if m != nil {
		return m.GerritProject
	}
	return ""
}

func (m *DashRepoHead) GetCommit() *DashCommit {
	if m != nil {
		return m.Commit
	}
	return nil
}

func init() {
	proto.RegisterType((*HasAncestorRequest)(nil), "apipb.HasAncestorRequest")
	proto.RegisterType((*HasAncestorResponse)(nil), "apipb.HasAncestorResponse")
	proto.RegisterType((*GetRefRequest)(nil), "apipb.GetRefRequest")
	proto.RegisterType((*GetRefResponse)(nil), "apipb.GetRefResponse")
	proto.RegisterType((*GoFindTryWorkRequest)(nil), "apipb.GoFindTryWorkRequest")
	proto.RegisterType((*GoFindTryWorkResponse)(nil), "apipb.GoFindTryWorkResponse")
	proto.RegisterType((*GerritTryWorkItem)(nil), "apipb.GerritTryWorkItem")
	proto.RegisterType((*TryVoteMessage)(nil), "apipb.TryVoteMessage")
	proto.RegisterType((*MajorMinor)(nil), "apipb.MajorMinor")
	proto.RegisterType((*ListGoReleasesRequest)(nil), "apipb.ListGoReleasesRequest")
	proto.RegisterType((*ListGoReleasesResponse)(nil), "apipb.ListGoReleasesResponse")
	proto.RegisterType((*GoRelease)(nil), "apipb.GoRelease")
	proto.RegisterType((*DashboardRequest)(nil), "apipb.DashboardRequest")
	proto.RegisterType((*DashboardResponse)(nil), "apipb.DashboardResponse")
	proto.RegisterType((*DashCommit)(nil), "apipb.DashCommit")
	proto.RegisterType((*DashRepoHead)(nil), "apipb.DashRepoHead")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for MaintnerService service

type MaintnerServiceClient interface {
	// HasAncestor reports whether one commit contains another commit
	// in its git history.
	HasAncestor(ctx context.Context, in *HasAncestorRequest, opts ...grpc.CallOption) (*HasAncestorResponse, error)
	// GetRef returns information about a git ref.
	GetRef(ctx context.Context, in *GetRefRequest, opts ...grpc.CallOption) (*GetRefResponse, error)
	// GoFindTryWork finds trybot work for the coordinator to build & test.
	GoFindTryWork(ctx context.Context, in *GoFindTryWorkRequest, opts ...grpc.CallOption) (*GoFindTryWorkResponse, error)
	// ListGoReleases lists Go releases sorted by version with latest first.
	//
	// A release is considered to exist for each git tag named "goX", "goX.Y", or
	// "goX.Y.Z", as long as it has a corresponding "release-branch.goX" or
	// "release-branch.goX.Y" release branch.
	//
	// ListGoReleases returns only the latest patch versions of releases which
	// are considered supported per policy. For example, Go 1.12.6 and 1.11.11.
	// The response is guaranteed to have two versions, otherwise an error
	// is returned.
	ListGoReleases(ctx context.Context, in *ListGoReleasesRequest, opts ...grpc.CallOption) (*ListGoReleasesResponse, error)
	// GetDashboard returns the information for the build.golang.org
	// dashboard. It does not (at least currently)
	// contain any pass/fail information; it only contains information on the branches
	// and commits themselves.
	GetDashboard(ctx context.Context, in *DashboardRequest, opts ...grpc.CallOption) (*DashboardResponse, error)
}

type maintnerServiceClient struct {
	cc *grpc.ClientConn
}

func NewMaintnerServiceClient(cc *grpc.ClientConn) MaintnerServiceClient {
	return &maintnerServiceClient{cc}
}

func (c *maintnerServiceClient) HasAncestor(ctx context.Context, in *HasAncestorRequest, opts ...grpc.CallOption) (*HasAncestorResponse, error) {
	out := new(HasAncestorResponse)
	err := grpc.Invoke(ctx, "/apipb.MaintnerService/HasAncestor", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *maintnerServiceClient) GetRef(ctx context.Context, in *GetRefRequest, opts ...grpc.CallOption) (*GetRefResponse, error) {
	out := new(GetRefResponse)
	err := grpc.Invoke(ctx, "/apipb.MaintnerService/GetRef", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *maintnerServiceClient) GoFindTryWork(ctx context.Context, in *GoFindTryWorkRequest, opts ...grpc.CallOption) (*GoFindTryWorkResponse, error) {
	out := new(GoFindTryWorkResponse)
	err := grpc.Invoke(ctx, "/apipb.MaintnerService/GoFindTryWork", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *maintnerServiceClient) ListGoReleases(ctx context.Context, in *ListGoReleasesRequest, opts ...grpc.CallOption) (*ListGoReleasesResponse, error) {
	out := new(ListGoReleasesResponse)
	err := grpc.Invoke(ctx, "/apipb.MaintnerService/ListGoReleases", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *maintnerServiceClient) GetDashboard(ctx context.Context, in *DashboardRequest, opts ...grpc.CallOption) (*DashboardResponse, error) {
	out := new(DashboardResponse)
	err := grpc.Invoke(ctx, "/apipb.MaintnerService/GetDashboard", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for MaintnerService service

type MaintnerServiceServer interface {
	// HasAncestor reports whether one commit contains another commit
	// in its git history.
	HasAncestor(context.Context, *HasAncestorRequest) (*HasAncestorResponse, error)
	// GetRef returns information about a git ref.
	GetRef(context.Context, *GetRefRequest) (*GetRefResponse, error)
	// GoFindTryWork finds trybot work for the coordinator to build & test.
	GoFindTryWork(context.Context, *GoFindTryWorkRequest) (*GoFindTryWorkResponse, error)
	// ListGoReleases lists Go releases sorted by version with latest first.
	//
	// A release is considered to exist for each git tag named "goX", "goX.Y", or
	// "goX.Y.Z", as long as it has a corresponding "release-branch.goX" or
	// "release-branch.goX.Y" release branch.
	//
	// ListGoReleases returns only the latest patch versions of releases which
	// are considered supported per policy. For example, Go 1.12.6 and 1.11.11.
	// The response is guaranteed to have two versions, otherwise an error
	// is returned.
	ListGoReleases(context.Context, *ListGoReleasesRequest) (*ListGoReleasesResponse, error)
	// GetDashboard returns the information for the build.golang.org
	// dashboard. It does not (at least currently)
	// contain any pass/fail information; it only contains information on the branches
	// and commits themselves.
	GetDashboard(context.Context, *DashboardRequest) (*DashboardResponse, error)
}

func RegisterMaintnerServiceServer(s *grpc.Server, srv MaintnerServiceServer) {
	s.RegisterService(&_MaintnerService_serviceDesc, srv)
}

func _MaintnerService_HasAncestor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasAncestorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MaintnerServiceServer).HasAncestor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apipb.MaintnerService/HasAncestor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MaintnerServiceServer).HasAncestor(ctx, req.(*HasAncestorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MaintnerService_GetRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MaintnerServiceServer).GetRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apipb.MaintnerService/GetRef",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MaintnerServiceServer).GetRef(ctx, req.(*GetRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MaintnerService_GoFindTryWork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GoFindTryWorkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MaintnerServiceServer).GoFindTryWork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apipb.MaintnerService/GoFindTryWork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MaintnerServiceServer).GoFindTryWork(ctx, req.(*GoFindTryWorkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MaintnerService_ListGoReleases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoReleasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MaintnerServiceServer).ListGoReleases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apipb.MaintnerService/ListGoReleases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MaintnerServiceServer).ListGoReleases(ctx, req.(*ListGoReleasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MaintnerService_GetDashboard_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DashboardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MaintnerServiceServer).GetDashboard(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apipb.MaintnerService/GetDashboard",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MaintnerServiceServer).GetDashboard(ctx, req.(*DashboardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MaintnerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "apipb.MaintnerService",
	HandlerType: (*MaintnerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HasAncestor",
			Handler:    _MaintnerService_HasAncestor_Handler,
		},
		{
			MethodName: "GetRef",
			Handler:    _MaintnerService_GetRef_Handler,
		},
		{
			MethodName: "GoFindTryWork",
			Handler:    _MaintnerService_GoFindTryWork_Handler,
		},
		{
			MethodName: "ListGoReleases",
			Handler:    _MaintnerService_ListGoReleases_Handler,
		},
		{
			MethodName: "GetDashboard",
			Handler:    _MaintnerService_GetDashboard_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api.proto",
}

func init() { proto.RegisterFile("api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 988 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xed, 0x6e, 0xdb, 0x36,
	0x17, 0x86, 0xed, 0x38, 0xb6, 0x8f, 0xe3, 0x34, 0x61, 0x93, 0x56, 0x75, 0xdf, 0x22, 0xa9, 0x8a,
	0xb7, 0x48, 0xd1, 0x21, 0x18, 0x32, 0xec, 0xe3, 0x6f, 0xb6, 0xae, 0x4e, 0xb6, 0x7a, 0x18, 0x94,
	0xa0, 0xfb, 0xa9, 0x31, 0xf2, 0x89, 0xac, 0xd6, 0x12, 0x35, 0x92, 0x4e, 0x9b, 0xeb, 0xd8, 0xcd,
	0xec, 0x26, 0x76, 0x25, 0xdb, 0x45, 0x0c, 0x24, 0x0f, 0x15, 0x29, 0x71, 0x31, 0xec, 0x9f, 0xce,
	0x73, 0x3e, 0x79, 0xce, 0x43, 0x1e, 0xc1, 0x80, 0x97, 0xd9, 0x61, 0x29, 0x85, 0x16, 0xac, 0xcb,
	0xcb, 0xac, 0xbc, 0x08, 0x4f, 0x80, 0x9d, 0x70, 0x75, 0x5c, 0x24, 0xa8, 0xb4, 0x90, 0x11, 0xfe,
	0xb6, 0x44, 0xa5, 0xd9, 0x03, 0x58, 0x4f, 0x44, 0x9e, 0x67, 0x3a, 0x68, 0xed, 0xb7, 0x0e, 0x06,
	0x11, 0x49, 0x6c, 0x0c, 0x7d, 0x4e, 0xa6, 0x41, 0xdb, 0x6a, 0x2a, 0x39, 0x8c, 0xe1, 0x7e, 0x23,
	0x92, 0x2a, 0x45, 0xa1, 0x90, 0x3d, 0x85, 0x8d, 0x39, 0x57, 0x71, 0xe5, 0x66, 0x02, 0xf6, 0xa3,
	0xe1, 0xfc, 0xc6, 0x94, 0xfd, 0x1f, 0x36, 0x97, 0xc5, 0xfb, 0x42, 0x7c, 0x28, 0x62, 0xca, 0xda,
	0xb6, 0x46, 0x23, 0x42, 0xbf, 0xb3, 0x60, 0x98, 0xc3, 0x68, 0x82, 0x3a, 0xc2, 0x4b, 0x5f, 0xe5,
	0x16, 0x74, 0x24, 0x5e, 0x52, 0x89, 0xe6, 0x93, 0x3d, 0x83, 0x51, 0x8a, 0x52, 0x66, 0x3a, 0x56,
	0x28, 0xaf, 0xd0, 0x17, 0xb9, 0xe1, 0xc0, 0x33, 0x8b, 0x99, 0x74, 0x64, 0x54, 0x4a, 0xf1, 0x0e,
	0x13, 0x1d, 0x74, 0xac, 0x15, 0xb9, 0xfe, 0xec, 0xc0, 0xf0, 0x39, 0x6c, 0xfa, 0x74, 0x74, 0x94,
	0x1d, 0xe8, 0x5e, 0xf1, 0xc5, 0x12, 0x29, 0xa3, 0x13, 0xc2, 0xaf, 0x61, 0x67, 0x22, 0x5e, 0x67,
	0xc5, 0xec, 0x5c, 0x5e, 0xff, 0x22, 0xe4, 0x7b, 0x5f, 0xdd, 0x1e, 0x0c, 0x2f, 0x85, 0x8c, 0x95,
	0xe6, 0x69, 0x56, 0xa4, 0x74, 0x6e, 0xb8, 0x14, 0xf2, 0xcc, 0x21, 0xe1, 0x8f, 0xb0, 0x7b, 0xcb,
	0x91, 0xf2, 0x1c, 0x41, 0xef, 0x03, 0xcf, 0xb4, 0xf3, 0xea, 0x1c, 0x0c, 0x8f, 0x82, 0x43, 0x3b,
	0xac, 0xc3, 0x89, 0x2d, 0x90, 0xcc, 0x4f, 0x35, 0xe6, 0x91, 0x37, 0x0c, 0xff, 0x68, 0xc3, 0xf6,
	0x1d, 0x35, 0x0b, 0xa0, 0xe7, 0xcf, 0xe8, 0x6a, 0xf6, 0xa2, 0x99, 0xf0, 0x85, 0xe4, 0x45, 0x32,
	0xa7, 0x16, 0x91, 0xc4, 0x1e, 0xc3, 0x20, 0x99, 0xf3, 0x22, 0xc5, 0x38, 0x9b, 0x51, 0x5f, 0xfa,
	0x0e, 0x38, 0x9d, 0xd5, 0x68, 0xb1, 0xd6, 0xa0, 0x45, 0x00, 0xbd, 0x2b, 0x94, 0x2a, 0x13, 0x45,
	0x30, 0xd8, 0x6f, 0x1d, 0x74, 0x23, 0x2f, 0x9a, 0x70, 0xa9, 0xf0, 0x53, 0xed, 0xee, 0x77, 0x4c,
	0xb8, 0x54, 0xb8, 0x81, 0x92, 0x92, 0xca, 0x58, 0xf7, 0xca, 0x6f, 0x5d, 0x21, 0x9f, 0x03, 0xa4,
	0x22, 0xf6, 0x61, 0x7b, 0xb6, 0x0f, 0xdb, 0xd4, 0x87, 0x29, 0x7f, 0x27, 0xe4, 0x34, 0x2b, 0x84,
	0x8c, 0x06, 0xa9, 0x78, 0x4b, 0xb9, 0xbe, 0x82, 0xa1, 0x96, 0xd7, 0x71, 0x8e, 0x4a, 0xf1, 0x14,
	0x83, 0xbe, 0x75, 0xd9, 0x25, 0x97, 0x73, 0x79, 0xfd, 0x56, 0x68, 0x9c, 0x3a, 0x65, 0x04, 0x5a,
	0x5e, 0xd3, 0x77, 0xc8, 0x61, 0xb3, 0xa9, 0x35, 0xe7, 0xf1, 0x51, 0xa8, 0x6d, 0x24, 0x9a, 0x92,
	0xf9, 0x52, 0xcf, 0x85, 0x34, 0xed, 0x31, 0x9d, 0xeb, 0x44, 0x7d, 0x07, 0x9c, 0xce, 0xea, 0x6d,
	0xe8, 0x34, 0xda, 0x10, 0x7e, 0x03, 0x70, 0x53, 0xb3, 0xe1, 0x51, 0x6e, 0x24, 0x1b, 0xbc, 0x1b,
	0x39, 0xc1, 0xa2, 0x46, 0x6d, 0xc3, 0x1a, 0xd4, 0x08, 0xe1, 0x43, 0xd8, 0x7d, 0x93, 0x29, 0x3d,
	0x11, 0x11, 0x2e, 0x90, 0x2b, 0x54, 0x44, 0xaf, 0xf0, 0x35, 0x3c, 0xb8, 0xad, 0x20, 0xfa, 0x7c,
	0x06, 0x7d, 0x49, 0x18, 0xf1, 0x67, 0xcb, 0xf3, 0xc7, 0x1b, 0x47, 0x95, 0x45, 0xf8, 0x67, 0x0b,
	0x06, 0x15, 0xfe, 0x5f, 0x4a, 0x33, 0x68, 0xc9, 0x75, 0x32, 0xa7, 0xc3, 0x3a, 0x81, 0x3d, 0x82,
	0xbe, 0xe6, 0x69, 0x5c, 0xf0, 0x1c, 0x89, 0x25, 0x3d, 0xcd, 0xd3, 0x9f, 0x78, 0x8e, 0xec, 0x09,
	0x80, 0x51, 0x55, 0x6c, 0x30, 0xca, 0x81, 0xe6, 0x29, 0xd1, 0x61, 0x0f, 0x86, 0x8e, 0x0b, 0xce,
	0x79, 0xdd, 0xea, 0xc1, 0x41, 0xd6, 0xff, 0x19, 0x8c, 0xc8, 0x80, 0x42, 0xf4, 0xdc, 0xed, 0x76,
	0x20, 0xbd, 0x12, 0x0a, 0xb6, 0x5e, 0x71, 0x35, 0xbf, 0x10, 0x5c, 0xce, 0xfc, 0x55, 0x64, 0xb0,
	0x56, 0xfa, 0x61, 0x76, 0x23, 0xfb, 0x6d, 0x30, 0x89, 0xa5, 0x20, 0xfa, 0xdb, 0xef, 0xda, 0xa5,
	0xe8, 0x34, 0x2e, 0xc5, 0x1e, 0x0c, 0x73, 0xfe, 0x91, 0xb2, 0x2a, 0x7b, 0xac, 0x6e, 0x04, 0x39,
	0xff, 0xe8, 0x72, 0xaa, 0xf0, 0xaf, 0x16, 0x6c, 0xd7, 0xb2, 0xd2, 0x20, 0x5e, 0x42, 0xcf, 0xbb,
	0xb4, 0x1a, 0xfc, 0x35, 0xa6, 0xce, 0x35, 0xf2, 0x16, 0xec, 0x25, 0x6c, 0xd3, 0x67, 0xac, 0xe5,
	0xb2, 0x48, 0xb8, 0xc6, 0x99, 0xed, 0x51, 0x3f, 0xda, 0x22, 0xc5, 0xb9, 0xc7, 0xd9, 0x11, 0x80,
	0x29, 0x38, 0x9e, 0x23, 0x9f, 0xa9, 0xa0, 0x6d, 0x83, 0xdf, 0xaf, 0x05, 0x8f, 0xb0, 0x14, 0x27,
	0xc8, 0x67, 0xd1, 0x40, 0xd2, 0x97, 0x32, 0x6f, 0xb7, 0x3b, 0x0e, 0xaa, 0xa0, 0xe3, 0x2e, 0x9b,
	0x97, 0x1b, 0x94, 0x59, 0xfb, 0x57, 0xca, 0xfc, 0xde, 0x06, 0xb8, 0x39, 0xc2, 0x27, 0x97, 0xc5,
	0x1e, 0x0c, 0xe9, 0xae, 0xd8, 0x79, 0xba, 0x46, 0x83, 0x83, 0xec, 0x3c, 0x9f, 0xc2, 0x06, 0x19,
	0x60, 0xce, 0xb3, 0x05, 0x35, 0x9d, 0x9c, 0xbe, 0x37, 0x10, 0x7b, 0x0e, 0xf7, 0x5c, 0xb4, 0x58,
	0x67, 0x39, 0xc6, 0x0a, 0x13, 0xdb, 0xfd, 0x4e, 0x34, 0x72, 0xf0, 0x79, 0x96, 0xe3, 0x19, 0x26,
	0x86, 0x8b, 0x3a, 0xd3, 0x0b, 0x24, 0x56, 0x39, 0xa1, 0x36, 0xcf, 0x5e, 0x63, 0x9e, 0x2f, 0x60,
	0xbb, 0x7a, 0x95, 0x62, 0xee, 0x62, 0x13, 0xdf, 0x36, 0xfd, 0xeb, 0x74, 0x6c, 0x63, 0xb3, 0x03,
	0xd8, 0xba, 0x31, 0x5d, 0x70, 0x8d, 0x4a, 0x07, 0xfd, 0xa6, 0xe5, 0x1b, 0x8b, 0x86, 0xbf, 0xc2,
	0x46, 0xbd, 0xf5, 0x2b, 0xd6, 0x4c, 0x6b, 0xc5, 0x9a, 0x61, 0x2f, 0xaa, 0xee, 0x99, 0x06, 0xad,
	0xe4, 0x08, 0x19, 0x1c, 0xfd, 0xdd, 0x86, 0x7b, 0x53, 0x9e, 0x15, 0xba, 0x40, 0x69, 0x76, 0x59,
	0x96, 0x20, 0x7b, 0x05, 0xc3, 0xda, 0xd6, 0x65, 0x8f, 0xc8, 0xfb, 0xee, 0x4e, 0x1f, 0x8f, 0x57,
	0xa9, 0x88, 0xa9, 0x5f, 0xc2, 0xba, 0xdb, 0x75, 0x6c, 0xa7, 0x5a, 0x35, 0xb5, 0x4d, 0x3b, 0xde,
	0xbd, 0x85, 0x92, 0xdb, 0x0f, 0x30, 0x6a, 0x6c, 0x30, 0xf6, 0xb8, 0x62, 0xcd, 0xdd, 0x85, 0x38,
	0xfe, 0xdf, 0x6a, 0x25, 0xc5, 0x9a, 0xc2, 0x66, 0xf3, 0x3d, 0x63, 0xde, 0x7e, 0xe5, 0xfb, 0x37,
	0x7e, 0xf2, 0x09, 0x2d, 0x85, 0x3b, 0x86, 0x8d, 0x09, 0xea, 0xea, 0x4e, 0xb2, 0x87, 0xb5, 0xb6,
	0xd6, 0xdf, 0x86, 0x71, 0x70, 0x57, 0xe1, 0x42, 0x5c, 0xac, 0xdb, 0x1f, 0xa5, 0x2f, 0xfe, 0x09,
	0x00, 0x00, 0xff, 0xff, 0xa8, 0x18, 0x53, 0x68, 0x35, 0x09, 0x00, 0x00,
}
