// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const AGPLV3DarkLogo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
    viewBox="0 0 77.654 32.135"
  >
    <g id="g2" transform="translate(1.364)">
      <path
        id="path1"
        d="M109.019,1769.589l-5.334,23.273h51.548a4.585,4.585,0,0,1-3.456-1.649,3.482,3.482,0,0,1-.34-.58c-.061-.15-.119-.3-.177-.456a4.613,4.613,0,0,1-.187-1.605,11.7,11.7,0,0,1,2.138-5.521,29.773,29.773,0,0,1,5.89-6.427c.558-.464,1.135-.921,1.74-1.366.747-.55,1.5-1.056,2.253-1.529a28.644,28.644,0,0,1,7.994-3.59,30.9,30.9,0,0,0-7.577,3.829c-.094.063-.186.128-.278.192a33.879,33.879,0,0,0-3.892,3.134c-3.672,3.452-5.612,7.03-4.73,9.125a2.636,2.636,0,0,0,.225.412c.948,1.394,3.3,1.635,6.274.886.2-.051.4-.108.613-.168a24.153,24.153,0,0,0,3-1.1c.25-.11.5-.224.757-.345l.077-.038c3.282-1.631,5.8-3.507,6.35-4.635a.7.7,0,0,0,.067-.618c-.39-.79-3.115-.256-6.417,1.174-.265.115-.534.233-.805.36.221-.205.451-.411.685-.614.374-.323.762-.638,1.174-.949a23.412,23.412,0,0,1,1.941-1.323c3.009-2.27,4.53-4.418,4.213-5.215a.56.56,0,0,0-.383-.316,5.536,5.536,0,0,0-3.163.609,23.646,23.646,0,0,0-3.8,2.037l-.182.12-.034.019-.642.427.369-.676a11.606,11.606,0,0,1,2.55-3.02,18.123,18.123,0,0,1,2.746-1.965c.379-.222.757-.428,1.136-.613s.776-.358,1.155-.508a13.345,13.345,0,0,1,3.226-1.057c-.083,0-2.732.285-2.732.285h-63.99Zm41.55.034a31.158,31.158,0,0,0,1.3,9.384q.269,1,.589,2.022.2.633.412,1.246c-.083.122-.166.243-.244.364a12.887,12.887,0,0,0-2.181,5.339,32.871,32.871,0,0,1-1.16-5.8q-.1-.89-.149-1.759a25.555,25.555,0,0,1,1.428-10.793Zm-25.128,2.986H131.2a1.979,1.979,0,0,1,1.126.273.641.641,0,0,1,.3.709l-.676,3.053h-2l.657-2.971h-5l-1.807,8.167-.652,2.957h5l0-.019,1-4.524H126.8l.225-1.021h4.347l-1.246,5.646a.8.8,0,0,1-.086.225,1.246,1.246,0,0,1-.532.479,2.643,2.643,0,0,1-1.246.273H122.6a1.979,1.979,0,0,1-1.126-.273.632.632,0,0,1-.3-.7l2.5-11.287a1.081,1.081,0,0,1,.613-.709c.012-.007.026-.008.038-.014a2.612,2.612,0,0,1,1.122-.259Zm8.886,0h7.136a1.976,1.976,0,0,1,1.121.273.638.638,0,0,1,.307.709l-1.332,6.02a1.078,1.078,0,0,1-.618.7,2.621,2.621,0,0,1-1.241.278h-5.186l-1,4.52-.163.743h-1.955l.149-.671,2.785-12.576Zm9.859,0h1.955l-2.214,10-.484,2.185h4.678c.049.359.106.711.168,1.059h-7.036l.556-2.511Zm-8.138,1.064-1.3,5.857h4.874l1.294-5.857ZM125.653,1787.5h.058a1.374,1.374,0,0,1,.585.115.694.694,0,0,1,.359.355.866.866,0,0,1,.048.513l-.014.072h-.561l0-.067a.441.441,0,0,0-.053-.307.255.255,0,0,0-.072-.067.694.694,0,0,0-.359-.077.837.837,0,0,0-.474.11.422.422,0,0,0-.192.249.185.185,0,0,0,.038.177l0,0a1.31,1.31,0,0,0,.474.168,3.21,3.21,0,0,1,.618.2.731.731,0,0,1,.355.34.746.746,0,0,1,.038.475,1.081,1.081,0,0,1-.254.474,1.286,1.286,0,0,1-.484.345,1.635,1.635,0,0,1-.623.125,1.556,1.556,0,0,1-.671-.125.773.773,0,0,1-.388-.4.976.976,0,0,1-.048-.58l.014-.067h.551l0,.067a.6.6,0,0,0,.034.307.371.371,0,0,0,.192.182.878.878,0,0,0,.383.077,1.051,1.051,0,0,0,.364-.062.642.642,0,0,0,.254-.153.426.426,0,0,0,.11-.206.227.227,0,0,0-.014-.168.351.351,0,0,0-.177-.129l-.47-.139a2.106,2.106,0,0,1-.542-.192.672.672,0,0,1-.292-.316.682.682,0,0,1-.024-.417,1.014,1.014,0,0,1,.235-.455,1.179,1.179,0,0,1,.47-.321A1.648,1.648,0,0,1,125.653,1787.5Zm5.032.01c.03,0,.059,0,.091,0l.345.038.115.01-.168.427-.034.067-.264-.024a.3.3,0,0,0-.173.038l-.01.01a.172.172,0,0,0-.019.019.452.452,0,0,0-.072.182s-.01.042-.019.077h.412l-.105.474h-.4l-.407,1.826h-.556s.361-1.622.407-1.826h-.321l.105-.474h.316c.015-.066.038-.149.038-.149a1.17,1.17,0,0,1,.115-.34.725.725,0,0,1,.264-.259.805.805,0,0,1,.34-.1Zm1.328.024-.182.82h.359l-.105.474h-.359c-.029.132-.259,1.155-.259,1.155s-.019.123-.019.158c0,0,0,0,0,0s0,0,0,0h0l.058,0,.264-.019-.029.427,0,.077-.379.043a.614.614,0,0,1-.34-.077.339.339,0,0,1-.153-.22.363.363,0,0,1-.01-.077,1.959,1.959,0,0,1,.058-.388s.2-.9.244-1.093h-.264l.105-.474h.264c.025-.11.11-.489.11-.489l.446-.235.182-.1Zm-17.661.019h2.157l-.12.537h-1.577c-.025.109-.123.55-.158.709h1.366l-.12.537h-1.366c-.029.134-.292,1.318-.292,1.318h-.58Zm2.89.757a.512.512,0,0,1,.067,0,.652.652,0,0,1,.388.129l.077.053-.3.489-.081-.058a.35.35,0,0,0-.192-.058.3.3,0,0,0-.168.058.423.423,0,0,0-.144.158,1.513,1.513,0,0,0-.144.393l-.259,1.179h-.556l.513-2.3h.518s-.018.07-.024.1c.025-.019.05-.044.072-.058A.591.591,0,0,1,117.242,1788.305Zm1.649,0c.033,0,.066,0,.1,0a.812.812,0,0,1,.7.326.89.89,0,0,1,.149.518,1.73,1.73,0,0,1-.043.369l-.043.168H118.2c0,.032,0,.067,0,.1a.459.459,0,0,0,.077.283.358.358,0,0,0,.086.086.426.426,0,0,0,.235.062.555.555,0,0,0,.307-.091.81.81,0,0,0,.249-.273h.594l-.053.115a1.316,1.316,0,0,1-.47.537,1.269,1.269,0,0,1-.695.2.864.864,0,0,1-.748-.326,1.047,1.047,0,0,1-.105-.872,1.59,1.59,0,0,1,.489-.882,1.238,1.238,0,0,1,.733-.311Zm2.5,0c.033,0,.066,0,.1,0a.812.812,0,0,1,.7.326.889.889,0,0,1,.149.518,1.687,1.687,0,0,1-.043.364l-.043.173h-1.562c0,.021,0,.041,0,.062s0,.02,0,.029,0,0,0,0c0,.023,0,.046,0,.067a.414.414,0,0,0,.072.216c.008.011.015.024.024.033a.389.389,0,0,0,.3.115.55.55,0,0,0,.307-.091.807.807,0,0,0,.249-.273h.6l-.057.115a1.316,1.316,0,0,1-.47.537,1.269,1.269,0,0,1-.695.2.8.8,0,0,1-.9-.848c0-.032,0-.067,0-.1a1.74,1.74,0,0,1,.038-.249,1.589,1.589,0,0,1,.484-.882,1.254,1.254,0,0,1,.738-.312Zm6.8,0c.034,0,.066,0,.1,0a.851.851,0,0,1,.724.321,1.022,1.022,0,0,1,.115.863,1.766,1.766,0,0,1-.278.676,1.321,1.321,0,0,1-1.05.532.839.839,0,0,1-.724-.326.858.858,0,0,1-.153-.522,1.647,1.647,0,0,1,.043-.369,1.5,1.5,0,0,1,.556-.925,1.294,1.294,0,0,1,.666-.249Zm8.421,0c.04,0,.078,0,.12,0a1.23,1.23,0,0,1,.46.067.508.508,0,0,1,.259.2.55.55,0,0,1,.072.292l-.057.35-.105.475a5.233,5.233,0,0,0-.115.613.617.617,0,0,0,.024.22l.038.125h-.566l-.024-.072a.682.682,0,0,1-.01-.115,1.7,1.7,0,0,1-.312.158,1.354,1.354,0,0,1-.441.077.726.726,0,0,1-.57-.2.51.51,0,0,1-.129-.355.772.772,0,0,1,.019-.163.8.8,0,0,1,.149-.321.9.9,0,0,1,.259-.23,1.163,1.163,0,0,1,.312-.125l.34-.057a3.732,3.732,0,0,0,.6-.11.293.293,0,0,1,.01-.033.306.306,0,0,0,0-.211l-.01-.01a.213.213,0,0,0-.019-.019.475.475,0,0,0-.288-.067.637.637,0,0,0-.335.072.626.626,0,0,0-.206.259h-.58l.053-.115a1.224,1.224,0,0,1,.254-.393,1.061,1.061,0,0,1,.4-.235,1.6,1.6,0,0,1,.4-.076Zm2.43,0a.513.513,0,0,1,.067,0,.662.662,0,0,1,.393.129l.072.053-.3.489-.081-.058a.339.339,0,0,0-.187-.058.317.317,0,0,0-.173.058.425.425,0,0,0-.139.158,1.57,1.57,0,0,0-.144.393l-.264,1.179h-.556l.513-2.3h.518s-.013.07-.019.1c.025-.019.049-.044.072-.058A.564.564,0,0,1,139.039,1788.305Zm1.644,0c.033,0,.066,0,.1,0a.81.81,0,0,1,.7.326.879.879,0,0,1,.149.518,1.755,1.755,0,0,1-.048.369l-.038.168h-1.562c0,.032-.01.067-.01.1a.469.469,0,0,0,.077.283c.008.011.02.024.029.033l.019.019a.4.4,0,0,0,.278.1.555.555,0,0,0,.307-.091.826.826,0,0,0,.249-.273h.6l-.058.115a1.328,1.328,0,0,1-.47.537,1.27,1.27,0,0,1-.695.2.855.855,0,0,1-.743-.326,1.052,1.052,0,0,1-.11-.872,1.584,1.584,0,0,1,.484-.882A1.256,1.256,0,0,1,140.683,1788.305Zm-8.392.043h.57s.07,1.365.072,1.385c.023-.049.041-.09.043-.1l.628-1.289h.522s.048,1.349.048,1.356c.015-.028.714-1.356.714-1.356h.566l-1.246,2.3H133.7s-.05-1.248-.053-1.318l-.642,1.318h-.527Zm-13.391.436a.606.606,0,0,0-.364.144.707.707,0,0,0-.2.273h.944c0-.017,0-.037,0-.053a.4.4,0,0,0-.043-.2.336.336,0,0,0-.316-.163H118.9Zm2.5,0a.606.606,0,0,0-.364.144.723.723,0,0,0-.2.273h.944c0-.017,0-.037,0-.053a.381.381,0,0,0-.043-.2.386.386,0,0,0-.048-.062.355.355,0,0,0-.268-.1H121.4Zm19.315,0a.618.618,0,0,0-.379.144.74.74,0,0,0-.2.273h.939c0-.017,0-.037,0-.053a.381.381,0,0,0-.043-.2.341.341,0,0,0-.316-.163h-.01Zm-12.557.01a.635.635,0,0,0-.355.172,1.038,1.038,0,0,0-.283.556,1.269,1.269,0,0,0-.034.273.472.472,0,0,0,.062.259.438.438,0,0,0,.038.048.372.372,0,0,0,.283.11.6.6,0,0,0,.422-.177,1.064,1.064,0,0,0,.283-.566.683.683,0,0,0-.029-.517.349.349,0,0,0-.316-.158A.589.589,0,0,0,128.155,1788.794Zm8.66.839a3.592,3.592,0,0,1-.47.091,1.627,1.627,0,0,0-.307.067.34.34,0,0,0-.129.091.285.285,0,0,0-.067.125.339.339,0,0,0,0,.053s0,0,0,0,0,.011,0,.014a.2.2,0,0,0,0,.024l0,.01a.15.15,0,0,0,0,.014l.01.014a.188.188,0,0,0,.014.019.3.3,0,0,0,.225.063.765.765,0,0,0,.345-.077.672.672,0,0,0,.254-.221A.891.891,0,0,0,136.816,1789.633Zm-29.275-3.843L120.4,1772.51h2.1L119.4,1785.79h-1.728l.882-3.823H113.16l-3.664,3.823h-1.955m6.93-5.191h4.41l.814-3.334q.493-1.984.948-3.307-.911,1.141-2.41,2.709l-3.762,3.932"
        transform="translate(-103.684 -1768.606)"
        fill="#07193e"
      />
      <path
        id="path2"
        d="M629.567,1786.568a5.185,5.185,0,0,1-3.908-1.872,4,4,0,0,1-.392-.669c-.073-.175-.136-.338-.2-.5l.715-.278c.061.157.122.314.186.468a3.234,3.234,0,0,0,.309.526,4.373,4.373,0,0,0,3.323,1.56h1.681a14.791,14.791,0,0,0,1.625-.229,21.089,21.089,0,0,0,3.153-.9c.853-.311,1.716-.676,2.566-1.084a36.317,36.317,0,0,0,5.8-3.51c.615-.452,1.231-.935,1.831-1.435q.805-.67,1.543-1.358a14.769,14.769,0,0,0,2.944-3.775c.567-1.139.663-2.051.272-2.568a1.61,1.61,0,0,0-1.221-.531l-1.014-.079.814-.61c2.91-2.184,4.556-4.768,4-6.286a1.628,1.628,0,0,0-1.04-.96,3.321,3.321,0,0,0-.841-.172h-.894a13.692,13.692,0,0,0-4.6,1.3l-.337-.689a14.546,14.546,0,0,1,4.91-1.376h.954a4.115,4.115,0,0,1,1.069.216,2.37,2.37,0,0,1,1.5,1.42c.63,1.731-.808,4.341-3.61,6.647a1.964,1.964,0,0,1,.918.658c.584.772.516,1.938-.2,3.372a15.329,15.329,0,0,1-3.1,3.99q-.76.708-1.58,1.391c-.612.51-1.241,1-1.868,1.464a37.085,37.085,0,0,1-5.922,3.583c-.872.419-1.758.794-2.635,1.113a21.86,21.86,0,0,1-3.268.927,15.365,15.365,0,0,1-1.743.242Z"
        transform="translate(-578.174 -1761.542)"
        fill="#07193e"
      />
    </g>
  </svg>
);

export default AGPLV3DarkLogo;
