// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ConfigurationsListIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Uni\xF3n 43"
        d="M65.865 256a8.03 8.03 0 0 1-8.029-8.035 8.03 8.03 0 0 1 8.029-8.034h163.867a8.035 8.035 0 0 1 8.033 8.034 8.035 8.035 0 0 1-8.033 8.035Zm-57.834 0a8.03 8.03 0 0 1-8.029-8.035 8.03 8.03 0 0 1 8.029-8.034h29.99a8.035 8.035 0 0 1 8.033 8.034A8.035 8.035 0 0 1 38.021 256Zm57.834-28.917a8.03 8.03 0 0 1-8.029-8.034 8.03 8.03 0 0 1 8.029-8.035h163.867a8.035 8.035 0 0 1 8.033 8.035 8.035 8.035 0 0 1-8.033 8.034Zm-57.834 0a8.03 8.03 0 0 1-8.029-8.034 8.03 8.03 0 0 1 8.029-8.035h29.99a8.035 8.035 0 0 1 8.033 8.035 8.035 8.035 0 0 1-8.033 8.034Zm163.459-28.384H142a8.173 8.173 0 0 1-2.906-.533H65.865a8.03 8.03 0 0 1-8.029-8.034 8.03 8.03 0 0 1 8.029-8.035h34.445a8.134 8.134 0 0 1-3.521-2.068L76 159.218a8.128 8.128 0 0 1-2.377-5.208 8.128 8.128 0 0 1 1.641-5.474l12.373-16.585a68.993 68.993 0 0 1-2.988-7.079l-20.311-2.926a8.163 8.163 0 0 1-7.025-8.15V84.375a8.167 8.167 0 0 1 7.025-8.15l20.311-2.926a70.215 70.215 0 0 1 2.988-7.073L75.258 49.792a8.178 8.178 0 0 1-1.635-5.48 8.113 8.113 0 0 1 2.381-5.2l20.781-20.807a8.141 8.141 0 0 1 5.779-2.393 8.1 8.1 0 0 1 4.93 1.657l16.5 12.373a69.937 69.937 0 0 1 7.09-2.972l2.914-20.333a8.146 8.146 0 0 1 2.723-5.016 8.155 8.155 0 0 1 5.428-2h29.572a8.159 8.159 0 0 1 5.342 2 8.138 8.138 0 0 1 2.727 5.016l2.92 20.333a72.131 72.131 0 0 1 7.086 2.972l16.439-12.373a8.039 8.039 0 0 1 4.9-1.657 8.109 8.109 0 0 1 5.766 2.393l20.8 20.958a8.142 8.142 0 0 1 2.381 5.2 8.135 8.135 0 0 1-1.633 5.474l-12.314 16.434a71.975 71.975 0 0 1 2.994 7.079l20.334 2.926a8.147 8.147 0 0 1 4.957 2.757 8.174 8.174 0 0 1 1.971 5.318v29.5a8.192 8.192 0 0 1-1.971 5.387 8.161 8.161 0 0 1-5.039 2.757l-20.34 2.926a67.225 67.225 0 0 1-2.971 7.079l12.234 16.353a8.209 8.209 0 0 1 1.627 5.486 8.133 8.133 0 0 1-2.367 5.208l-20.8 20.8a8.119 8.119 0 0 1-3.8 2.149h16.77a8.035 8.035 0 0 1 8.033 8.035 8.035 8.035 0 0 1-8.033 8.034h-55.26a8.157 8.157 0 0 1-2.9.533Zm37.543-16.6a8.118 8.118 0 0 1-2.953-1.413l-16.418-12.3a71.877 71.877 0 0 1-7.084 2.972l-1.547 10.745Zm-44.514 0 2.627-17.766a8.133 8.133 0 0 1 5.891-6.691 57.883 57.883 0 0 0 13.561-5.59 8.188 8.188 0 0 1 4.322-1.228 8.164 8.164 0 0 1 4.328 1.234l.039.029 14.875 11.371 10.77-10.995-11.168-14.9a8.122 8.122 0 0 1-1.275-4.368 8.1 8.1 0 0 1 1.264-4.35 62.735 62.735 0 0 0 5.26-13.358l.006-.011a8.194 8.194 0 0 1 6.7-5.868l18.439-2.676-.215-15.16-18.449-2.676a8.116 8.116 0 0 1-6.684-5.868 63.168 63.168 0 0 0-5.6-13.532 8.106 8.106 0 0 1 .578-8.961l11.367-14.876-10.984-10.774-14.9 11.168a8.1 8.1 0 0 1-4.594 1.413 8.215 8.215 0 0 1-4.066-1.083 57.452 57.452 0 0 0-13.562-5.584h-.006a8.154 8.154 0 0 1-5.891-6.7l-2.682-18.438h-15.23l-2.676 18.143a8.113 8.113 0 0 1-5.873 6.679 58.28 58.28 0 0 0-13.592 5.59 8.08 8.08 0 0 1-4.309 1.24 8.15 8.15 0 0 1-4.322-1.245l-.039-.029-14.877-11.371-10.988 10.995 11.395 14.911a8.111 8.111 0 0 1 1.264 4.362 8.137 8.137 0 0 1-1.252 4.344 64.4 64.4 0 0 0-5.283 13.509v.006a8.131 8.131 0 0 1-6.68 5.874l-18.449 2.688v15.229l18.139 2.676a8.163 8.163 0 0 1 6.678 5.874 63.854 63.854 0 0 0 5.59 13.509 8.183 8.183 0 0 1 1.258 4.356 8.161 8.161 0 0 1-1.264 4.368l-.029.035-11.365 14.864 10.988 10.775 14.9-11.168a8.127 8.127 0 0 1 4.58-1.408 8.129 8.129 0 0 1 4.063 1.089 58.074 58.074 0 0 0 13.59 5.584h.006a8.142 8.142 0 0 1 5.873 6.691l2.629 18.073Zm-31.975 0-1.551-10.745a68.569 68.569 0 0 1-7.08-2.972l-16.416 12.373a8.134 8.134 0 0 1-2.682 1.344ZM8.03 198.168a8.03 8.03 0 0 1-8.029-8.034 8.03 8.03 0 0 1 8.029-8.035h29.99a8.035 8.035 0 0 1 8.033 8.035 8.035 8.035 0 0 1-8.033 8.034Zm0-28.917a8.03 8.03 0 0 1-8.029-8.035 8.025 8.025 0 0 1 8.029-8.029h29.99a8.03 8.03 0 0 1 8.033 8.029 8.035 8.035 0 0 1-8.033 8.035Zm0-28.917a8.03 8.03 0 0 1-8.029-8.035 8.025 8.025 0 0 1 8.029-8.029h29.99a8.03 8.03 0 0 1 8.033 8.029 8.035 8.035 0 0 1-8.033 8.035Zm133.771-5.561a38.591 38.591 0 0 1-12.279-8.278 38.613 38.613 0 0 1-8.279-12.286 38.374 38.374 0 0 1-3.035-15.038 38.381 38.381 0 0 1 3.035-15.044 38.551 38.551 0 0 1 8.279-12.286 38.512 38.512 0 0 1 12.279-8.284 38.369 38.369 0 0 1 15.037-3.035 38.407 38.407 0 0 1 15.051 3.035 38.476 38.476 0 0 1 12.291 8.284 38.551 38.551 0 0 1 8.279 12.286 38.381 38.381 0 0 1 3.035 15.044 38.374 38.374 0 0 1-3.035 15.038 38.613 38.613 0 0 1-8.279 12.286 38.554 38.554 0 0 1-12.291 8.278 38.408 38.408 0 0 1-15.051 3.041 38.4 38.4 0 0 1-15.038-3.045Zm6.354-56.19a22.131 22.131 0 0 0-7.094 4.791 22.181 22.181 0 0 0-4.785 7.1 22.193 22.193 0 0 0-1.754 8.7 22.187 22.187 0 0 0 1.754 8.689 22.221 22.221 0 0 0 4.785 7.1 22.2 22.2 0 0 0 7.094 4.785 22.166 22.166 0 0 0 8.684 1.755 22.233 22.233 0 0 0 8.7-1.755 22.259 22.259 0 0 0 7.1-4.785 22.268 22.268 0 0 0 4.779-7.1 22.222 22.222 0 0 0 1.754-8.689 22.228 22.228 0 0 0-1.754-8.7 22.228 22.228 0 0 0-4.779-7.1 22.186 22.186 0 0 0-7.1-4.791 22.232 22.232 0 0 0-8.7-1.755 22.166 22.166 0 0 0-8.683 1.751ZM8.03 111.416a8.03 8.03 0 0 1-8.029-8.035 8.025 8.025 0 0 1 8.029-8.029h29.99a8.03 8.03 0 0 1 8.033 8.029 8.035 8.035 0 0 1-8.033 8.035Zm0-28.917a8.03 8.03 0 0 1-8.029-8.034 8.025 8.025 0 0 1 8.029-8.029h29.99a8.03 8.03 0 0 1 8.033 8.029 8.035 8.035 0 0 1-8.033 8.034Z"
      />
      <path data-name="Rect\xE1ngulo 925" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default ConfigurationsListIcon;
