// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileConfigIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 447"
        d="M179.66 125.384a51.282 51.282 0 0 0-1.483-3.533l8.145-10.875a7.2 7.2 0 0 0-.642-9.386l-14.659-14.767a7.2 7.2 0 0 0-9.387-.646l-10.881 8.2a51.149 51.149 0 0 0-3.53-1.482l-1.939-13.476a7.12 7.12 0 0 0-7.15-6.163h-20.755a7.156 7.156 0 0 0-7.166 6.16l-1.941 13.479q-1.8.675-3.532 1.483l-10.929-8.2a7.2 7.2 0 0 0-9.391.646l-14.654 14.653a7.2 7.2 0 0 0-.648 9.388l8.2 10.881a51.536 51.536 0 0 0-1.482 3.53l-13.474 1.939a7.181 7.181 0 0 0-6.165 7.15v20.7a7.186 7.186 0 0 0 6.16 7.165l13.479 1.939q.675 1.8 1.484 3.535l-8.2 10.98a7.2 7.2 0 0 0 .646 9.391l14.654 14.653a7.2 7.2 0 0 0 9.387.647l10.882-8.2a50.342 50.342 0 0 0 3.528 1.483l1.94 13.474a7.185 7.185 0 0 0 7.081 6.165h20.771a7.22 7.22 0 0 0 7.166-6.16l1.941-13.479a50.349 50.349 0 0 0 3.531-1.484l10.875 8.143a7.2 7.2 0 0 0 9.392-.646l14.654-14.654a7.2 7.2 0 0 0 .65-9.381l-8.1-10.828a50.638 50.638 0 0 0 1.483-3.535l13.474-1.938a7.182 7.182 0 0 0 6.166-7.15v-20.77a7.13 7.13 0 0 0-6.093-7.1Zm-12.348 30.522a42.91 42.91 0 0 1-3.577 9.063 7.2 7.2 0 0 0 .038 7.61l7.2 9.616-5.855 5.973-9.47-7.247-.139-.1a7.179 7.179 0 0 0-7.534-.038 39.415 39.415 0 0 1-9.257 3.8 7.172 7.172 0 0 0-5.159 5.873l-1.707 11.559h-8.267l-1.709-11.767a7.173 7.173 0 0 0-5.178-5.883 39.4 39.4 0 0 1-9.232-3.8 7.235 7.235 0 0 0-7.666.335l-9.5 7.124-5.972-5.855 7.245-9.47.09-.13a7.156 7.156 0 0 0 .052-7.583 43.013 43.013 0 0 1-3.81-9.216 7.17 7.17 0 0 0-5.872-5.161l-11.559-1.7v-8.26l11.768-1.708a7.178 7.178 0 0 0 5.885-5.187 42.913 42.913 0 0 1 3.577-9.167 7.2 7.2 0 0 0-.041-7.6l-7.344-9.613 5.982-5.985 9.484 7.256.139.1a7.19 7.19 0 0 0 7.534.037 39.448 39.448 0 0 1 9.257-3.8 7.168 7.168 0 0 0 5.16-5.872l1.7-11.559h8.268l1.708 11.768a7.179 7.179 0 0 0 5.178 5.883 39.363 39.363 0 0 1 9.232 3.793 7.237 7.237 0 0 0 7.668-.333l9.5-7.125 5.971 5.855-7.252 9.479a7.147 7.147 0 0 0-.511 7.865 42.925 42.925 0 0 1 3.81 9.217 7.173 7.173 0 0 0 5.877 5.162l11.792 1.712.117 8.208-11.746 1.706a7.179 7.179 0 0 0-5.879 5.17Z"
      />
      <path
        data-name="Trazado 448"
        d="M127.721 119.558a25.249 25.249 0 0 0-25.22 25.22 25.249 25.249 0 0 0 25.22 25.221 25.249 25.249 0 0 0 25.221-25.221 25.249 25.249 0 0 0-25.221-25.22Zm12.6 25.22a12.609 12.609 0 0 1-12.6 12.6 12.61 12.61 0 0 1-12.6-12.6 12.611 12.611 0 0 1 12.6-12.6 12.61 12.61 0 0 1 12.6 12.6Z"
      />
      <path
        data-name="Trazado 449"
        d="M235.999 77.198c.388-15.754.957-32.242-.5-47.941-1.094-11.755-6.193-21.735-17.831-25.914a42.8 42.8 0 0 0-5.016-1.448c-6.551-1.478-13.433-1.6-20.09-1.8-11.727-.344-23.449.366-35.177.314-23.493-.1-46.985.323-70.479.414Q82.678.84 78.451.84h-42.21A17.261 17.261 0 0 0 19 18.08v220.68A17.261 17.261 0 0 0 36.241 256h182.541a17.26 17.26 0 0 0 17.24-17.24V128.815c.002-17.182-.445-34.458-.023-51.617Zm-20.922 145.988a14.887 14.887 0 0 1-14.888 14.887H51.821a14.888 14.888 0 0 1-14.888-14.887V33.662a14.888 14.888 0 0 1 14.888-14.888h99.547v25.459a37.8 37.8 0 0 0 37.758 37.759h25.951Zm0-157.656h-25.951a21.321 21.321 0 0 1-21.3-21.3V18.771h32.359a14.888 14.888 0 0 1 14.888 14.888Z"
      />
      <path data-name="Rect\xE1ngulo 900" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileConfigIcon;
