// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const GithubIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 7.819 7.621"
    {...props}
  >
    <path
      id="github"
      d="M8.543,4.917a4.146,4.146,0,0,1-.038.424,3.8,3.8,0,0,1-.8,1.816,3.982,3.982,0,0,1-.514.542,3.72,3.72,0,0,1-.8.531,4.287,4.287,0,0,1-.471.2.286.286,0,0,1-.149.02.174.174,0,0,1-.153-.163c0-.028,0-.056,0-.084V7.214A1.867,1.867,0,0,0,5.6,6.94a.794.794,0,0,0-.239-.477l.229-.035a2.168,2.168,0,0,0,.821-.291,1.347,1.347,0,0,0,.572-.691,2.291,2.291,0,0,0,.14-.592,2.689,2.689,0,0,0,.01-.488,1.44,1.44,0,0,0-.341-.824L6.747,3.49a.076.076,0,0,1-.007-.013A1.352,1.352,0,0,0,6.7,2.445a.478.478,0,0,0-.317.019,2.726,2.726,0,0,0-.62.289l-.137.086a4.467,4.467,0,0,0-.645-.114,4.047,4.047,0,0,0-.663,0,4.241,4.241,0,0,0-.651.115l-.126-.08a2.786,2.786,0,0,0-.643-.3.5.5,0,0,0-.311-.022,1.364,1.364,0,0,0-.038,1.031l-.154.206a1.392,1.392,0,0,0-.227.6,2.519,2.519,0,0,0,0,.578,2.17,2.17,0,0,0,.178.675,1.356,1.356,0,0,0,.609.65,2.294,2.294,0,0,0,.84.258l.131.02a.874.874,0,0,0-.243.515.793.793,0,0,1-.254.085c-.071.012-.141.014-.212.019a.623.623,0,0,1-.495-.2A1.545,1.545,0,0,1,2.578,6.7c-.047-.061-.084-.128-.135-.185a.8.8,0,0,0-.432-.256.347.347,0,0,0-.189.005.389.389,0,0,0-.048.025.126.126,0,0,0,.049.121.521.521,0,0,0,.112.091.712.712,0,0,1,.188.165,1.542,1.542,0,0,1,.233.41.721.721,0,0,0,.585.456,1.773,1.773,0,0,0,.424.032l.212-.022.083-.01.005.069,0,.527,0,.152a.176.176,0,0,1-.2.165.344.344,0,0,1-.1-.021,3.873,3.873,0,0,1-.74-.341,3.772,3.772,0,0,1-.838-.681,4.309,4.309,0,0,1-.445-.57A3.833,3.833,0,0,1,1,6.16a3.936,3.936,0,0,1-.216-.793L.749,5.079a4.242,4.242,0,0,1,0-.7,3.848,3.848,0,0,1,.57-1.705A3.9,3.9,0,0,1,3.053,1.159,3.716,3.716,0,0,1,4,.878,4.223,4.223,0,0,1,4.768.831a4.158,4.158,0,0,1,.523.047,3.674,3.674,0,0,1,.862.246,3.964,3.964,0,0,1,.975.59,3.793,3.793,0,0,1,.609.629,3.933,3.933,0,0,1,.585,1.066,4.2,4.2,0,0,1,.23,1.136l-.011.372h0Z"
      transform="translate(-0.734 -0.829)"
    />
  </svg>
);

export default GithubIcon;
