// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const NewPoolIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1005"
          data-name="Rectángulo 1005"
          width="228.951"
          height="256"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Expand_Tenant:_Add_Pools">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Expand_Tenant:_Add_Pools"
      data-name="Expand Tenant: Add Pools"
      clipPath="url(#clip-Expand_Tenant:_Add_Pools)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Expand_Tenants_Add_Pools" data-name="Expand Tenants Add Pools">
        <g id="Grupo_2392" data-name="Grupo 2392" transform="translate(14)">
          <g id="Grupo_2391" data-name="Grupo 2391">
            <path
              id="Trazado_7129"
              data-name="Trazado 7129"
              d="M210.46,96.042a56.244,56.244,0,1,0-90.223-64.6A71.157,71.157,0,0,0,0,83.178v0A71.315,71.315,0,0,0,62.4,154l-1.316,24.278c-.121-.006-.238-.018-.354-.018a17.611,17.611,0,0,0,0,35.223h0a17.613,17.613,0,0,0,10.082-32.025l1.464-26.922a70.737,70.737,0,0,0,30.53-7.391l37.678,49.042a35.174,35.174,0,1,0,60.272,24.6h0a35.181,35.181,0,0,0-35.132-35.228h0a34.864,34.864,0,0,0-17.3,4.589L111.4,142.085a71.574,71.574,0,0,0,24.769-29.736l43.156,6.286c-.028.495-.075.985-.075,1.484A24.849,24.849,0,1,0,210.46,96.042m-39.406,4.639A44.437,44.437,0,1,1,215.49,56.244a44.437,44.437,0,0,1-44.437,44.437"
              transform="translate(0)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7130"
              data-name="Trazado 7130"
              d="M224.419,96.438l-6.231-6.231V108.9H236.88l-6.23-6.231L243.11,90.207l-6.231-6.23Z"
              transform="translate(-72.057 -27.733)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7131"
              data-name="Trazado 7131"
              d="M267.86,53,255.4,65.457l6.23,6.231L274.09,59.227l6.231,6.23V46.766H261.629Z"
              transform="translate(-84.346 -15.444)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1006"
          data-name="Rectángulo 1006"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default NewPoolIcon;
