// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OperatorSubnetLoginMFARequest operator subnet login m f a request
//
// swagger:model operatorSubnetLoginMFARequest
type OperatorSubnetLoginMFARequest struct {

	// mfa token
	// Required: true
	MfaToken *string `json:"mfa_token"`

	// otp
	// Required: true
	Otp *string `json:"otp"`

	// username
	// Required: true
	Username *string `json:"username"`
}

// Validate validates this operator subnet login m f a request
func (m *OperatorSubnetLoginMFARequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMfaToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOtp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OperatorSubnetLoginMFARequest) validateMfaToken(formats strfmt.Registry) error {

	if err := validate.Required("mfa_token", "body", m.MfaToken); err != nil {
		return err
	}

	return nil
}

func (m *OperatorSubnetLoginMFARequest) validateOtp(formats strfmt.Registry) error {

	if err := validate.Required("otp", "body", m.Otp); err != nil {
		return err
	}

	return nil
}

func (m *OperatorSubnetLoginMFARequest) validateUsername(formats strfmt.Registry) error {

	if err := validate.Required("username", "body", m.Username); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this operator subnet login m f a request based on context it is used
func (m *OperatorSubnetLoginMFARequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *OperatorSubnetLoginMFARequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OperatorSubnetLoginMFARequest) UnmarshalBinary(b []byte) error {
	var res OperatorSubnetLoginMFARequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
