// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const CreateUserIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1016"
          data-name="Rectángulo 1016"
          width="234.495"
          height="256"
          fill="#4ccb92"
        />
      </clipPath>
      <clipPath id="clip-Create_User">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Create_User"
      data-name="Create User"
      clipPath="url(#clip-Create_User)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Create_User-2" data-name="Create User">
        <g id="Grupo_2404" data-name="Grupo 2404" transform="translate(12)">
          <g id="Grupo_2403" data-name="Grupo 2403">
            <path
              id="Trazado_7140"
              data-name="Trazado 7140"
              d="M88.829,144.6h.048a66.829,66.829,0,0,0,27.035-5.707,69.009,69.009,0,0,0,22.1-15.529,72.055,72.055,0,0,0,14.891-22.977,73.863,73.863,0,0,0,5.463-28.1C158.372,32.435,127.183,0,88.831,0h0C50.5,0,19.316,32.43,19.316,72.292S50.5,144.6,88.829,144.6"
              transform="translate(1.421)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7141"
              data-name="Trazado 7141"
              d="M170.085,117.467a64.39,64.39,0,0,0-57.412,35.223c-1.427-.4-2.86-.784-4.3-1.124A94.705,94.705,0,0,0,86.9,149.044v.005c-1.755,0-3.439.046-5,.135A99.747,99.747,0,0,0,8.1,189.42c-.388.519-.767,1.061-1.234,1.756l-.107.15c-.1.142-.214.3-.312.458l-.027.028a37.88,37.88,0,0,0-2.671,37.522A31.97,31.97,0,0,0,32.509,247.36H142.044a31.485,31.485,0,0,0,13.08-2.84,64.408,64.408,0,1,0,14.961-127.054m.383,115.3a50.889,50.889,0,1,1,50.888-50.888,50.888,50.888,0,0,1-50.888,50.888m-7.982-26.944V189.859H146.524V173.895h15.963V157.931H178.45v15.964h15.963v15.964H178.45v15.963Z"
              transform="translate(0 8.64)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1017"
          data-name="Rectángulo 1017"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default CreateUserIcon;
