// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

const S3TierIcon = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className={`min-icon`}
      fill={"currentcolor"}
      viewBox="0 0 33.055 39.954"
      {...props}
    >
      <path
        id="Trazado_6934"
        data-name="Trazado 6934"
        d="M2.663,53.686,0,55.018V78.391l2.663,1.324.016-.019V53.7l-.016-.018"
        transform="translate(0 -46.754)"
        fill="#8c3123"
      />
      <path
        id="Trazado_6935"
        data-name="Trazado 6935"
        d="M34.876,76.323,20.624,79.715V53.686L34.876,57V76.323"
        transform="translate(-17.961 -46.754)"
        fill="#e05243"
      />
      <path
        id="Trazado_6936"
        data-name="Trazado 6936"
        d="M81.178,125.086l6.045.77.038-.088.034-9.913-.072-.077-6.045.758v8.55"
        transform="translate(-70.696 -100.829)"
        fill="#8c3123"
      />
      <path
        id="Trazado_6937"
        data-name="Trazado 6937"
        d="M128,76.361l13.864,3.362.022-.035V53.709l-.022-.023L128,57.043V76.361"
        transform="translate(-111.469 -46.754)"
        fill="#8c3123"
      />
      <path
        id="Trazado_6938"
        data-name="Trazado 6938"
        d="M134.043,125.086l-6.047.77V115.778l6.047.758v8.55"
        transform="translate(-111.469 -100.829)"
        fill="#e05243"
      />
      <path
        id="Trazado_6939"
        data-name="Trazado 6939"
        d="M93.27,78.958l-6.047,1.1-6.045-1.1,6.038-1.583,6.055,1.583"
        transform="translate(-70.696 -67.384)"
        fill="#5e1f18"
      />
      <path
        id="Trazado_6940"
        data-name="Trazado 6940"
        d="M93.27,212.319l-6.047-1.109-6.045,1.109L87.216,214l6.054-1.685"
        transform="translate(-70.696 -183.938)"
        fill="#f2b0a9"
      />
      <path
        id="Trazado_6941"
        data-name="Trazado 6941"
        d="M81.178,11.573l6.045-1.5.049-.015V.04L87.223,0,81.178,3.023v8.55"
        transform="translate(-70.696)"
        fill="#8c3123"
      />
      <path
        id="Trazado_6942"
        data-name="Trazado 6942"
        d="M134.043,11.573,128,10.077V0l6.047,3.023v8.55"
        transform="translate(-111.469)"
        fill="#e05243"
      />
      <path
        id="Trazado_6943"
        data-name="Trazado 6943"
        d="M87.219,231.378l-6.046-3.022v-8.55l6.046,1.5.089.1-.024,9.8-.065.174"
        transform="translate(-70.692 -191.424)"
        fill="#8c3123"
      />
      <path
        id="Trazado_6944"
        data-name="Trazado 6944"
        d="M128,231.378l6.046-3.022v-8.55L128,221.3v10.077"
        transform="translate(-111.469 -191.424)"
        fill="#e05243"
      />
      <path
        id="Trazado_6945"
        data-name="Trazado 6945"
        d="M235.367,53.686l2.664,1.332V78.391l-2.664,1.331V53.686"
        transform="translate(-204.976 -46.754)"
        fill="#e05243"
      />
    </svg>
  );
};

export default S3TierIcon;
