// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TenantList tenant list
//
// swagger:model tenantList
type TenantList struct {

	// capacity
	Capacity int64 `json:"capacity,omitempty"`

	// capacity raw
	CapacityRaw int64 `json:"capacity_raw,omitempty"`

	// capacity raw usage
	CapacityRawUsage int64 `json:"capacity_raw_usage,omitempty"`

	// capacity usage
	CapacityUsage int64 `json:"capacity_usage,omitempty"`

	// creation date
	CreationDate string `json:"creation_date,omitempty"`

	// current state
	CurrentState string `json:"currentState,omitempty"`

	// deletion date
	DeletionDate string `json:"deletion_date,omitempty"`

	// domains
	Domains *DomainsConfiguration `json:"domains,omitempty"`

	// health status
	HealthStatus string `json:"health_status,omitempty"`

	// instance count
	InstanceCount int64 `json:"instance_count,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// namespace
	Namespace string `json:"namespace,omitempty"`

	// pool count
	PoolCount int64 `json:"pool_count,omitempty"`

	// tiers
	Tiers []*TenantTierElement `json:"tiers"`

	// total size
	TotalSize int64 `json:"total_size,omitempty"`

	// volume count
	VolumeCount int64 `json:"volume_count,omitempty"`
}

// Validate validates this tenant list
func (m *TenantList) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TenantList) validateDomains(formats strfmt.Registry) error {
	if swag.IsZero(m.Domains) { // not required
		return nil
	}

	if m.Domains != nil {
		if err := m.Domains.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("domains")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("domains")
			}
			return err
		}
	}

	return nil
}

func (m *TenantList) validateTiers(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiers) { // not required
		return nil
	}

	for i := 0; i < len(m.Tiers); i++ {
		if swag.IsZero(m.Tiers[i]) { // not required
			continue
		}

		if m.Tiers[i] != nil {
			if err := m.Tiers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this tenant list based on the context it is used
func (m *TenantList) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDomains(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TenantList) contextValidateDomains(ctx context.Context, formats strfmt.Registry) error {

	if m.Domains != nil {
		if err := m.Domains.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("domains")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("domains")
			}
			return err
		}
	}

	return nil
}

func (m *TenantList) contextValidateTiers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Tiers); i++ {

		if m.Tiers[i] != nil {
			if err := m.Tiers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TenantList) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TenantList) UnmarshalBinary(b []byte) error {
	var res TenantList
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
