// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileBookIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 442"
        d="M235.994 77.357c.388-15.754 1.486-43.417.028-59.116C234.928 6.486 221.639 1.196 212.322 1 205.771-.478 80.8.119 36.406.119 26.889.13 19.006 8.719 19 18.241v220.678a17.26 17.26 0 0 0 17.24 17.241h182.544a17.26 17.26 0 0 0 17.241-17.241V128.974c-.005-17.183-.451-34.458-.031-51.617Zm-20.92 145.986a14.889 14.889 0 0 1-14.888 14.888H51.816a14.888 14.888 0 0 1-14.888-14.888V33.82a14.889 14.889 0 0 1 14.887-14.888h99.55v25.459a37.8 37.8 0 0 0 37.756 37.759h25.952Zm0-157.656h-25.952a21.32 21.32 0 0 1-21.3-21.3V18.928h32.358a14.889 14.889 0 0 1 14.889 14.887Z"
      />
      <path
        data-name="Trazado 443"
        d="M190.043 108.409h-2.858v-.481c0-4.811-3.442-8.716-7.847-8.89-3.582-.139-7.333-.09-11.4.146v-8.975a9.1 9.1 0 0 0-3.651-7.42 7.623 7.623 0 0 0-8.069-.585 103.462 103.462 0 0 0-20.433 14.719 147.056 147.056 0 0 0-10.4 10.7 128.076 128.076 0 0 0-16.659-5.074 127.9 127.9 0 0 0-34.506-3.51c-4.378.2-7.8 4.1-7.8 8.888v.483h-2.858c-4.489 0-8.141 3.989-8.141 8.892v71.865c0 8.348 6.119 15.14 13.641 15.14h35.989a17.914 17.914 0 0 1 12.641 5.463 12.749 12.749 0 0 0 9.108 3.911h.024a12.907 12.907 0 0 0 9.054-3.9 17.918 17.918 0 0 1 12.68-5.474h35.987c7.522 0 13.641-6.792 13.641-15.14v-71.858c-.006-4.908-3.657-8.9-8.143-8.9Zm-68.633 79.066a124.047 124.047 0 0 0-12.692-3.692 127.989 127.989 0 0 0-28.66-3.509c-1.549 0-2.857-1.653-2.857-3.607v-66.1h2.114a117.162 117.162 0 0 1 42.1 7.846Zm54.992-10.809c0 1.955-1.308 3.607-2.88 3.607a129.374 129.374 0 0 0-26.5 2.984 89.847 89.847 0 0 1 13.362-9.124 15.293 15.293 0 0 0 7.55-13.56v-49.836a112.11 112.11 0 0 1 8.463-.239Zm-19.251-16.057a3.781 3.781 0 0 1-1.6 3.282 100.834 100.834 0 0 0-19.759 14.271 113.862 113.862 0 0 0-3.6 3.464v-64.967a131.421 131.421 0 0 1 10.636-10.965l.011-.009a91.536 91.536 0 0 1 14.314-10.886Z"
      />
      <path data-name="Rect\xE1ngulo 897" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileBookIcon;
