// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const PerformanceMenuIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 12 12"
    {...props}
  >
    <defs>
      <clipPath id="clip-path-performance-menu-icon">
        <rect
          id="Rectángulo_985"
          data-name="Rectángulo 985"
          width="12"
          height="12"
        />
      </clipPath>
    </defs>
    <g
      id="Grupo_2352"
      data-name="Grupo 2352"
      clipPath="url(#clip-path-performance-menu-icon)"
    >
      <path
        id="Trazado_7077"
        data-name="Trazado 7077"
        d="M120.417,129.741a.387.387,0,1,0,.387.387h0a.387.387,0,0,0-.387-.387"
        transform="translate(-114.404 -123.659)"
      />
      <path
        id="Trazado_7078"
        data-name="Trazado 7078"
        d="M6,0a6,6,0,1,0,6,6A6,6,0,0,0,6,0M5.974,1.662h.02a.366.366,0,1,1-.006.733H5.974a.366.366,0,0,1,0-.733m-4.1,4.026v0a.139.139,0,0,1-.139.12H1.717a.139.139,0,0,1-.12-.156v0h0a.139.139,0,0,1,.156-.119h0a.139.139,0,0,1,.118.157M2.2,4.447h0a.2.2,0,0,1-.179-.3v0h0a.2.2,0,1,1,.178.3M3.323,3.238l-.015.013,0,0a.249.249,0,0,1-.165.064v0a.25.25,0,0,1-.164-.438l0,0h0l0,0a.25.25,0,0,1,.341.366M4.555,2.6l0,0-.008,0a.329.329,0,0,1-.119.025v0a.331.331,0,0,1-.117-.642l.01,0h0a.331.331,0,1,1,.238.619m2.1,6.622h0a.176.176,0,0,1-.176.176H5.531a.176.176,0,1,1,0-.353h.952a.177.177,0,0,1,.178.175Zm.781-3.493-.652.556a.016.016,0,0,0,0,.015.8.8,0,1,1-.489-.57.016.016,0,0,0,.016,0l.649-.556h0a.366.366,0,0,1,.476.556m-.05-3.025v0a.4.4,0,0,1-.143-.026l-.012,0a.406.406,0,1,1,.284-.76l.014.005a.408.408,0,0,1-.143.789m1.292.827a.46.46,0,0,1-.3-.114L8.37,3.41a.46.46,0,0,1,.6-.694l.013.011a.46.46,0,0,1-.3.806m.47.964-.009-.016a.529.529,0,1,1,.916-.529l.013.023.009.017h0a.529.529,0,0,1-.213.717h0A.529.529,0,0,1,9.154,4.5m1.014,1.772a.6.6,0,0,1-.675-.512v-.02a.6.6,0,0,1,.592-.679.6.6,0,0,1,.591.516l0,.023a.6.6,0,0,1-.512.672"
      />
    </g>
  </svg>
);

export default PerformanceMenuIcon;
