/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl3.internal.introspection.ClassTool;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.logging.Log;

final class ClassMap {
    static final Method CACHE_MISS = ClassMap.cacheMiss();
    private static final ClassMap EMPTY = new ClassMap();
    private final Map<MethodKey, Method> byKey;
    private final Map<String, Method[]> byName;
    private final Map<String, Field> fieldCache;

    public static Method cacheMiss() {
        try {
            return ClassMap.class.getMethod("cacheMiss", new Class[0]);
        }
        catch (Exception xio) {
            return null;
        }
    }

    private static void create(ClassMap cache, JexlPermissions permissions, Class<?> clazz, Log log) {
        for (Class<?> classToReflect = clazz; classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            Class<?>[] interfaces;
            if (Modifier.isPublic(classToReflect.getModifiers()) && ClassTool.isExported(classToReflect)) {
                ClassMap.populateWithClass(cache, permissions, classToReflect, log);
            }
            for (Class<?> anInterface : interfaces = classToReflect.getInterfaces()) {
                ClassMap.populateWithInterface(cache, permissions, anInterface, log);
            }
        }
        if (!cache.byKey.isEmpty()) {
            ArrayList<Method> lm = new ArrayList<Method>(cache.byKey.values());
            lm.sort(Comparator.comparing(Method::getName));
            int start = 0;
            while (start < lm.size()) {
                String walk;
                int end;
                String name = ((Method)lm.get(start)).getName();
                for (end = start + 1; end < lm.size() && (walk = ((Method)lm.get(end)).getName()).equals(name); ++end) {
                }
                Method[] lmn = lm.subList(start, end).toArray(new Method[0]);
                cache.byName.put(name, lmn);
                start = end;
            }
        }
    }

    static ClassMap empty() {
        return EMPTY;
    }

    private static void populateWithClass(ClassMap cache, JexlPermissions permissions, Class<?> clazz, Log log) {
        block3: {
            try {
                Method[] methods;
                for (Method mi : methods = clazz.getDeclaredMethods()) {
                    if (!Modifier.isPublic(mi.getModifiers())) continue;
                    MethodKey key = new MethodKey(mi);
                    Method pmi = cache.byKey.putIfAbsent(key, permissions.allow(mi) ? mi : CACHE_MISS);
                    if (pmi == null || pmi == CACHE_MISS || !log.isDebugEnabled() || key.equals(new MethodKey(pmi))) continue;
                    log.debug((Object)("Method " + pmi + " is already registered, key: " + key.debugString()));
                }
            }
            catch (SecurityException se) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("While accessing methods of " + clazz + ": "), (Throwable)se);
            }
        }
    }

    private static void populateWithInterface(ClassMap cache, JexlPermissions permissions, Class<?> iface, Log log) {
        if (Modifier.isPublic(iface.getModifiers())) {
            Class<?>[] supers;
            ClassMap.populateWithClass(cache, permissions, iface, log);
            for (Class<?> aSuper : supers = iface.getInterfaces()) {
                ClassMap.populateWithInterface(cache, permissions, aSuper, log);
            }
        }
    }

    private ClassMap() {
        this.byKey = Collections.unmodifiableMap(new AbstractMap<MethodKey, Method>(){

            @Override
            public Set<Map.Entry<MethodKey, Method>> entrySet() {
                return Collections.emptySet();
            }

            @Override
            public Method get(Object name) {
                return CACHE_MISS;
            }

            @Override
            public String toString() {
                return "emptyClassMap{}";
            }
        });
        this.byName = Collections.emptyMap();
        this.fieldCache = Collections.emptyMap();
    }

    ClassMap(Class<?> aClass, JexlPermissions permissions, Log log) {
        this.byKey = new ConcurrentHashMap<MethodKey, Method>();
        this.byName = new HashMap<String, Method[]>();
        ClassMap.create(this, permissions, aClass, log);
        Field[] fields = aClass.getFields();
        if (fields.length > 0) {
            HashMap<String, Field> cache = new HashMap<String, Field>();
            for (Field field : fields) {
                if (!permissions.allow(field)) continue;
                cache.put(field.getName(), field);
            }
            this.fieldCache = cache;
        } else {
            this.fieldCache = Collections.emptyMap();
        }
    }

    Field getField(String fieldName) {
        return this.fieldCache.get(fieldName);
    }

    String[] getFieldNames() {
        return this.fieldCache.keySet().toArray(new String[0]);
    }

    Method getMethod(MethodKey methodKey) throws MethodKey.AmbiguousException {
        Method cacheEntry = this.byKey.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            try {
                Method[] methodList = this.byName.get(methodKey.getMethod());
                if (methodList != null) {
                    cacheEntry = methodKey.getMostSpecificMethod(methodList);
                }
                this.byKey.put(methodKey, cacheEntry == null ? CACHE_MISS : cacheEntry);
            }
            catch (MethodKey.AmbiguousException ae) {
                this.byKey.put(methodKey, CACHE_MISS);
                throw ae;
            }
        }
        return cacheEntry;
    }

    String[] getMethodNames() {
        return this.byName.keySet().toArray(new String[0]);
    }

    Method[] getMethods(String methodName) {
        Method[] lm = this.byName.get(methodName);
        if (lm != null && lm.length > 0) {
            return (Method[])lm.clone();
        }
        return null;
    }
}

