/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.TagVersionEnum;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.RollbackFailedException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class AfterTagChangeSetFilter
implements ChangeSetFilter {
    private final String tag;
    private final Set<String> changeLogsAfterTag = new HashSet<String>();
    private final DatabaseChangeLog databaseChangeLog;

    public AfterTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets, TagVersionEnum tagVersion) throws RollbackFailedException {
        this(tag, ranChangeSets, tagVersion, null);
    }

    public AfterTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets, TagVersionEnum tagVersion, DatabaseChangeLog databaseChangeLog) throws RollbackFailedException {
        this.tag = tag;
        this.databaseChangeLog = databaseChangeLog;
        if (tagVersion == TagVersionEnum.OLDEST) {
            this.oldestVersion(ranChangeSets);
            return;
        }
        boolean seenTag = ranChangeSets.stream().anyMatch(ranChangeSet -> tag.equalsIgnoreCase(ranChangeSet.getTag()));
        if (!seenTag) {
            Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
            throw new RollbackFailedException("Could not find tag '" + tag + "' in the database");
        }
        List reversedRanChangeSets = ranChangeSets.stream().collect(Collectors.collectingAndThen(Collectors.toList(), l -> {
            Collections.reverse(l);
            return l;
        }));
        for (RanChangeSet ranChangeSet2 : reversedRanChangeSets) {
            if (tag.equalsIgnoreCase(ranChangeSet2.getTag())) {
                if (!"tagDatabase".equals(StringUtils.trimToEmpty((String)ranChangeSet2.getDescription())) || !this.shouldKeepTag(ranChangeSet2)) break;
                this.changeLogsAfterTag.add(ranChangeSet2.toString());
                break;
            }
            this.changeLogsAfterTag.add(ranChangeSet2.toString());
        }
    }

    private void oldestVersion(List<RanChangeSet> ranChangeSets) throws RollbackFailedException {
        boolean seenTag = false;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (seenTag && (LiquibaseCommandLineConfiguration.INCLUDE_MATCHING_TAG_IN_ROLLBACK_OLDEST.getCurrentValue().booleanValue() || !this.tag.equalsIgnoreCase(ranChangeSet.getTag()))) {
                this.changeLogsAfterTag.add(ranChangeSet.toString());
            }
            if (!seenTag && this.tag.equalsIgnoreCase(ranChangeSet.getTag())) {
                seenTag = true;
            }
            if (!this.tag.equalsIgnoreCase(ranChangeSet.getTag()) || !"tagDatabase".equals(StringUtils.trimToEmpty((String)ranChangeSet.getDescription())) || !this.shouldKeepTag(ranChangeSet)) continue;
            this.changeLogsAfterTag.add(ranChangeSet.toString());
        }
        if (!seenTag) {
            Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
            throw new RollbackFailedException("Could not find tag '" + this.tag + "' in the database");
        }
    }

    private boolean shouldKeepTag(RanChangeSet ranChangeSet) {
        ChangeSet changeSet;
        if (this.databaseChangeLog != null && (changeSet = this.databaseChangeLog.getChangeSet(ranChangeSet)) != null) {
            return changeSet.getChanges().stream().noneMatch(c -> c instanceof TagDatabaseChange && BooleanUtils.isTrue((Boolean)((TagDatabaseChange)c).isKeepTagOnRollback()));
        }
        return true;
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        if (this.changeLogsAfterTag.contains(changeSet.toString())) {
            return new ChangeSetFilterResult(true, "Changeset is before tag '" + this.tag + "'", this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, "Changeset after tag '" + this.tag + "'", this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

