// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ebs

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCompleteSnapshot = "CompleteSnapshot"

// CompleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CompleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteSnapshot for more information on using the CompleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteSnapshotRequest method.
//    req, resp := client.CompleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/CompleteSnapshot
func (c *EBS) CompleteSnapshotRequest(input *CompleteSnapshotInput) (req *request.Request, output *CompleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opCompleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/snapshots/completion/{snapshotId}",
	}

	if input == nil {
		input = &CompleteSnapshotInput{}
	}

	output = &CompleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteSnapshot API operation for Amazon Elastic Block Store.
//
// Seals and completes the snapshot after all of the required blocks of data
// have been written to it. Completing the snapshot changes the status to completed.
// You cannot write new blocks to a snapshot after it has been completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation CompleteSnapshot for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/CompleteSnapshot
func (c *EBS) CompleteSnapshot(input *CompleteSnapshotInput) (*CompleteSnapshotOutput, error) {
	req, out := c.CompleteSnapshotRequest(input)
	return out, req.Send()
}

// CompleteSnapshotWithContext is the same as CompleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) CompleteSnapshotWithContext(ctx aws.Context, input *CompleteSnapshotInput, opts ...request.Option) (*CompleteSnapshotOutput, error) {
	req, out := c.CompleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnapshotBlock = "GetSnapshotBlock"

// GetSnapshotBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetSnapshotBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnapshotBlock for more information on using the GetSnapshotBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSnapshotBlockRequest method.
//    req, resp := client.GetSnapshotBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/GetSnapshotBlock
func (c *EBS) GetSnapshotBlockRequest(input *GetSnapshotBlockInput) (req *request.Request, output *GetSnapshotBlockOutput) {
	op := &request.Operation{
		Name:       opGetSnapshotBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/snapshots/{snapshotId}/blocks/{blockIndex}",
	}

	if input == nil {
		input = &GetSnapshotBlockInput{}
	}

	output = &GetSnapshotBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnapshotBlock API operation for Amazon Elastic Block Store.
//
// Returns the data in a block in an Amazon Elastic Block Store snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation GetSnapshotBlock for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/GetSnapshotBlock
func (c *EBS) GetSnapshotBlock(input *GetSnapshotBlockInput) (*GetSnapshotBlockOutput, error) {
	req, out := c.GetSnapshotBlockRequest(input)
	return out, req.Send()
}

// GetSnapshotBlockWithContext is the same as GetSnapshotBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnapshotBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) GetSnapshotBlockWithContext(ctx aws.Context, input *GetSnapshotBlockInput, opts ...request.Option) (*GetSnapshotBlockOutput, error) {
	req, out := c.GetSnapshotBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChangedBlocks = "ListChangedBlocks"

// ListChangedBlocksRequest generates a "aws/request.Request" representing the
// client's request for the ListChangedBlocks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChangedBlocks for more information on using the ListChangedBlocks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChangedBlocksRequest method.
//    req, resp := client.ListChangedBlocksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListChangedBlocks
func (c *EBS) ListChangedBlocksRequest(input *ListChangedBlocksInput) (req *request.Request, output *ListChangedBlocksOutput) {
	op := &request.Operation{
		Name:       opListChangedBlocks,
		HTTPMethod: "GET",
		HTTPPath:   "/snapshots/{secondSnapshotId}/changedblocks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChangedBlocksInput{}
	}

	output = &ListChangedBlocksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangedBlocks API operation for Amazon Elastic Block Store.
//
// Returns information about the blocks that are different between two Amazon
// Elastic Block Store snapshots of the same volume/snapshot lineage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation ListChangedBlocks for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListChangedBlocks
func (c *EBS) ListChangedBlocks(input *ListChangedBlocksInput) (*ListChangedBlocksOutput, error) {
	req, out := c.ListChangedBlocksRequest(input)
	return out, req.Send()
}

// ListChangedBlocksWithContext is the same as ListChangedBlocks with the addition of
// the ability to pass a context and additional request options.
//
// See ListChangedBlocks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) ListChangedBlocksWithContext(ctx aws.Context, input *ListChangedBlocksInput, opts ...request.Option) (*ListChangedBlocksOutput, error) {
	req, out := c.ListChangedBlocksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChangedBlocksPages iterates over the pages of a ListChangedBlocks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChangedBlocks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChangedBlocks operation.
//    pageNum := 0
//    err := client.ListChangedBlocksPages(params,
//        func(page *ebs.ListChangedBlocksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EBS) ListChangedBlocksPages(input *ListChangedBlocksInput, fn func(*ListChangedBlocksOutput, bool) bool) error {
	return c.ListChangedBlocksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChangedBlocksPagesWithContext same as ListChangedBlocksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) ListChangedBlocksPagesWithContext(ctx aws.Context, input *ListChangedBlocksInput, fn func(*ListChangedBlocksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChangedBlocksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChangedBlocksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChangedBlocksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSnapshotBlocks = "ListSnapshotBlocks"

// ListSnapshotBlocksRequest generates a "aws/request.Request" representing the
// client's request for the ListSnapshotBlocks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSnapshotBlocks for more information on using the ListSnapshotBlocks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSnapshotBlocksRequest method.
//    req, resp := client.ListSnapshotBlocksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListSnapshotBlocks
func (c *EBS) ListSnapshotBlocksRequest(input *ListSnapshotBlocksInput) (req *request.Request, output *ListSnapshotBlocksOutput) {
	op := &request.Operation{
		Name:       opListSnapshotBlocks,
		HTTPMethod: "GET",
		HTTPPath:   "/snapshots/{snapshotId}/blocks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSnapshotBlocksInput{}
	}

	output = &ListSnapshotBlocksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSnapshotBlocks API operation for Amazon Elastic Block Store.
//
// Returns information about the blocks in an Amazon Elastic Block Store snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation ListSnapshotBlocks for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/ListSnapshotBlocks
func (c *EBS) ListSnapshotBlocks(input *ListSnapshotBlocksInput) (*ListSnapshotBlocksOutput, error) {
	req, out := c.ListSnapshotBlocksRequest(input)
	return out, req.Send()
}

// ListSnapshotBlocksWithContext is the same as ListSnapshotBlocks with the addition of
// the ability to pass a context and additional request options.
//
// See ListSnapshotBlocks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) ListSnapshotBlocksWithContext(ctx aws.Context, input *ListSnapshotBlocksInput, opts ...request.Option) (*ListSnapshotBlocksOutput, error) {
	req, out := c.ListSnapshotBlocksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSnapshotBlocksPages iterates over the pages of a ListSnapshotBlocks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSnapshotBlocks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSnapshotBlocks operation.
//    pageNum := 0
//    err := client.ListSnapshotBlocksPages(params,
//        func(page *ebs.ListSnapshotBlocksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EBS) ListSnapshotBlocksPages(input *ListSnapshotBlocksInput, fn func(*ListSnapshotBlocksOutput, bool) bool) error {
	return c.ListSnapshotBlocksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSnapshotBlocksPagesWithContext same as ListSnapshotBlocksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) ListSnapshotBlocksPagesWithContext(ctx aws.Context, input *ListSnapshotBlocksInput, fn func(*ListSnapshotBlocksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSnapshotBlocksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSnapshotBlocksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSnapshotBlocksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutSnapshotBlock = "PutSnapshotBlock"

// PutSnapshotBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutSnapshotBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSnapshotBlock for more information on using the PutSnapshotBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSnapshotBlockRequest method.
//    req, resp := client.PutSnapshotBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/PutSnapshotBlock
func (c *EBS) PutSnapshotBlockRequest(input *PutSnapshotBlockInput) (req *request.Request, output *PutSnapshotBlockOutput) {
	op := &request.Operation{
		Name:       opPutSnapshotBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/snapshots/{snapshotId}/blocks/{blockIndex}",
	}

	if input == nil {
		input = &PutSnapshotBlockInput{}
	}

	output = &PutSnapshotBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Sign.Remove(v4.SignRequestHandler)
	handler := v4.BuildNamedHandler("v4.CustomSignerHandler", v4.WithUnsignedPayload)
	req.Handlers.Sign.PushFrontNamed(handler)
	return
}

// PutSnapshotBlock API operation for Amazon Elastic Block Store.
//
// Writes a block of data to a snapshot. If the specified block contains data,
// the existing data is overwritten. The target snapshot must be in the pending
// state.
//
// Data written to a snapshot must be aligned with 512-KiB sectors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation PutSnapshotBlock for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/PutSnapshotBlock
func (c *EBS) PutSnapshotBlock(input *PutSnapshotBlockInput) (*PutSnapshotBlockOutput, error) {
	req, out := c.PutSnapshotBlockRequest(input)
	return out, req.Send()
}

// PutSnapshotBlockWithContext is the same as PutSnapshotBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutSnapshotBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) PutSnapshotBlockWithContext(ctx aws.Context, input *PutSnapshotBlockInput, opts ...request.Option) (*PutSnapshotBlockOutput, error) {
	req, out := c.PutSnapshotBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSnapshot = "StartSnapshot"

// StartSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the StartSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSnapshot for more information on using the StartSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSnapshotRequest method.
//    req, resp := client.StartSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/StartSnapshot
func (c *EBS) StartSnapshotRequest(input *StartSnapshotInput) (req *request.Request, output *StartSnapshotOutput) {
	op := &request.Operation{
		Name:       opStartSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/snapshots",
	}

	if input == nil {
		input = &StartSnapshotInput{}
	}

	output = &StartSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSnapshot API operation for Amazon Elastic Block Store.
//
// Creates a new Amazon EBS snapshot. The new snapshot enters the pending state
// after the request completes.
//
// After creating the snapshot, use PutSnapshotBlock (https://docs.aws.amazon.com/ebs/latest/APIReference/API_PutSnapshotBlock.html)
// to write blocks of data to the snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Block Store's
// API operation StartSnapshot for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ValidationException
//   The input fails to satisfy the constraints of the EBS direct APIs.
//
//   * RequestThrottledException
//   The number of API requests has exceed the maximum allowed API request throttling
//   limit.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ServiceQuotaExceededException
//   Your current service quotas do not allow you to perform this action.
//
//   * InternalServerException
//   An internal error has occurred.
//
//   * ConcurrentLimitExceededException
//   You have reached the limit for concurrent API requests. For more information,
//   see Optimizing performance of the EBS direct APIs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapi-performance)
//   in the Amazon Elastic Compute Cloud User Guide.
//
//   * ConflictException
//   The request uses the same client token as a previous, but non-identical request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/StartSnapshot
func (c *EBS) StartSnapshot(input *StartSnapshotInput) (*StartSnapshotOutput, error) {
	req, out := c.StartSnapshotRequest(input)
	return out, req.Send()
}

// StartSnapshotWithContext is the same as StartSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See StartSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EBS) StartSnapshotWithContext(ctx aws.Context, input *StartSnapshotInput, opts ...request.Option) (*StartSnapshotOutput, error) {
	req, out := c.StartSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true" enum:"AccessDeniedExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A block of data in an Amazon Elastic Block Store snapshot.
type Block struct {
	_ struct{} `type:"structure"`

	// The block index.
	BlockIndex *int64 `type:"integer"`

	// The block token for the block index.
	BlockToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) GoString() string {
	return s.String()
}

// SetBlockIndex sets the BlockIndex field's value.
func (s *Block) SetBlockIndex(v int64) *Block {
	s.BlockIndex = &v
	return s
}

// SetBlockToken sets the BlockToken field's value.
func (s *Block) SetBlockToken(v string) *Block {
	s.BlockToken = &v
	return s
}

// A block of data in an Amazon Elastic Block Store snapshot that is different
// from another snapshot of the same volume/snapshot lineage.
type ChangedBlock struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The block index.
	BlockIndex *int64 `type:"integer"`

	// The block token for the block index of the FirstSnapshotId specified in the
	// ListChangedBlocks operation. This value is absent if the first snapshot does
	// not have the changed block that is on the second snapshot.
	FirstBlockToken *string `type:"string"`

	// The block token for the block index of the SecondSnapshotId specified in
	// the ListChangedBlocks operation.
	SecondBlockToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangedBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangedBlock) GoString() string {
	return s.String()
}

// SetBlockIndex sets the BlockIndex field's value.
func (s *ChangedBlock) SetBlockIndex(v int64) *ChangedBlock {
	s.BlockIndex = &v
	return s
}

// SetFirstBlockToken sets the FirstBlockToken field's value.
func (s *ChangedBlock) SetFirstBlockToken(v string) *ChangedBlock {
	s.FirstBlockToken = &v
	return s
}

// SetSecondBlockToken sets the SecondBlockToken field's value.
func (s *ChangedBlock) SetSecondBlockToken(v string) *ChangedBlock {
	s.SecondBlockToken = &v
	return s
}

type CompleteSnapshotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of blocks that were written to the snapshot.
	//
	// ChangedBlocksCount is a required field
	ChangedBlocksCount *int64 `location:"header" locationName:"x-amz-ChangedBlocksCount" type:"integer" required:"true"`

	// An aggregated Base-64 SHA256 checksum based on the checksums of each written
	// block.
	//
	// To generate the aggregated checksum using the linear aggregation method,
	// arrange the checksums for each written block in ascending order of their
	// block index, concatenate them to form a single string, and then generate
	// the checksum on the entire string using the SHA256 algorithm.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The aggregation method used to generate the checksum. Currently, the only
	// supported aggregation method is LINEAR.
	ChecksumAggregationMethod *string `location:"header" locationName:"x-amz-Checksum-Aggregation-Method" type:"string" enum:"ChecksumAggregationMethod"`

	// The algorithm used to generate the checksum. Currently, the only supported
	// algorithm is SHA256.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// The ID of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteSnapshotInput"}
	if s.ChangedBlocksCount == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangedBlocksCount"))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangedBlocksCount sets the ChangedBlocksCount field's value.
func (s *CompleteSnapshotInput) SetChangedBlocksCount(v int64) *CompleteSnapshotInput {
	s.ChangedBlocksCount = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *CompleteSnapshotInput) SetChecksum(v string) *CompleteSnapshotInput {
	s.Checksum = &v
	return s
}

// SetChecksumAggregationMethod sets the ChecksumAggregationMethod field's value.
func (s *CompleteSnapshotInput) SetChecksumAggregationMethod(v string) *CompleteSnapshotInput {
	s.ChecksumAggregationMethod = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *CompleteSnapshotInput) SetChecksumAlgorithm(v string) *CompleteSnapshotInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CompleteSnapshotInput) SetSnapshotId(v string) *CompleteSnapshotInput {
	s.SnapshotId = &v
	return s
}

type CompleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The status of the snapshot.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompleteSnapshotOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *CompleteSnapshotOutput) SetStatus(v string) *CompleteSnapshotOutput {
	s.Status = &v
	return s
}

// You have reached the limit for concurrent API requests. For more information,
// see Optimizing performance of the EBS direct APIs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapi-performance)
// in the Amazon Elastic Compute Cloud User Guide.
type ConcurrentLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentLimitExceededException) GoString() string {
	return s.String()
}

func newErrorConcurrentLimitExceededException(v protocol.ResponseMetadata) error {
	return &ConcurrentLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentLimitExceededException) Code() string {
	return "ConcurrentLimitExceededException"
}

// Message returns the exception's message.
func (s *ConcurrentLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentLimitExceededException) OrigErr() error {
	return nil
}

func (s *ConcurrentLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request uses the same client token as a previous, but non-identical request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetSnapshotBlockInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The block index of the block from which to get data.
	//
	// Obtain the BlockIndex by running the ListChangedBlocks or ListSnapshotBlocks
	// operations.
	//
	// BlockIndex is a required field
	BlockIndex *int64 `location:"uri" locationName:"blockIndex" type:"integer" required:"true"`

	// The block token of the block from which to get data.
	//
	// Obtain the BlockToken by running the ListChangedBlocks or ListSnapshotBlocks
	// operations.
	//
	// BlockToken is a required field
	BlockToken *string `location:"querystring" locationName:"blockToken" type:"string" required:"true"`

	// The ID of the snapshot containing the block from which to get data.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSnapshotBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSnapshotBlockInput"}
	if s.BlockIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockIndex"))
	}
	if s.BlockToken == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockToken"))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockIndex sets the BlockIndex field's value.
func (s *GetSnapshotBlockInput) SetBlockIndex(v int64) *GetSnapshotBlockInput {
	s.BlockIndex = &v
	return s
}

// SetBlockToken sets the BlockToken field's value.
func (s *GetSnapshotBlockInput) SetBlockToken(v string) *GetSnapshotBlockInput {
	s.BlockToken = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *GetSnapshotBlockInput) SetSnapshotId(v string) *GetSnapshotBlockInput {
	s.SnapshotId = &v
	return s
}

type GetSnapshotBlockOutput struct {
	_ struct{} `type:"structure" payload:"BlockData"`

	// The data content of the block.
	//
	// BlockData is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSnapshotBlockOutput's
	// String and GoString methods.
	BlockData io.ReadCloser `type:"blob" sensitive:"true"`

	// The checksum generated for the block, which is Base64 encoded.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The algorithm used to generate the checksum for the block, such as SHA256.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"ChecksumAlgorithm"`

	// The size of the data in the block.
	DataLength *int64 `location:"header" locationName:"x-amz-Data-Length" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotBlockOutput) GoString() string {
	return s.String()
}

// SetBlockData sets the BlockData field's value.
func (s *GetSnapshotBlockOutput) SetBlockData(v io.ReadCloser) *GetSnapshotBlockOutput {
	s.BlockData = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *GetSnapshotBlockOutput) SetChecksum(v string) *GetSnapshotBlockOutput {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *GetSnapshotBlockOutput) SetChecksumAlgorithm(v string) *GetSnapshotBlockOutput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetDataLength sets the DataLength field's value.
func (s *GetSnapshotBlockOutput) SetDataLength(v int64) *GetSnapshotBlockOutput {
	s.DataLength = &v
	return s
}

// An internal error has occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChangedBlocksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the first snapshot to use for the comparison.
	//
	// The FirstSnapshotID parameter must be specified with a SecondSnapshotId parameter;
	// otherwise, an error occurs.
	FirstSnapshotId *string `location:"querystring" locationName:"firstSnapshotId" min:"1" type:"string"`

	// The number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"100" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"pageToken" type:"string"`

	// The ID of the second snapshot to use for the comparison.
	//
	// The SecondSnapshotId parameter must be specified with a FirstSnapshotID parameter;
	// otherwise, an error occurs.
	//
	// SecondSnapshotId is a required field
	SecondSnapshotId *string `location:"uri" locationName:"secondSnapshotId" min:"1" type:"string" required:"true"`

	// The block index from which the comparison should start.
	//
	// The list in the response will start from this block index or the next valid
	// block index in the snapshots.
	StartingBlockIndex *int64 `location:"querystring" locationName:"startingBlockIndex" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangedBlocksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangedBlocksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangedBlocksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangedBlocksInput"}
	if s.FirstSnapshotId != nil && len(*s.FirstSnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstSnapshotId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 100 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 100))
	}
	if s.SecondSnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecondSnapshotId"))
	}
	if s.SecondSnapshotId != nil && len(*s.SecondSnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecondSnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirstSnapshotId sets the FirstSnapshotId field's value.
func (s *ListChangedBlocksInput) SetFirstSnapshotId(v string) *ListChangedBlocksInput {
	s.FirstSnapshotId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChangedBlocksInput) SetMaxResults(v int64) *ListChangedBlocksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangedBlocksInput) SetNextToken(v string) *ListChangedBlocksInput {
	s.NextToken = &v
	return s
}

// SetSecondSnapshotId sets the SecondSnapshotId field's value.
func (s *ListChangedBlocksInput) SetSecondSnapshotId(v string) *ListChangedBlocksInput {
	s.SecondSnapshotId = &v
	return s
}

// SetStartingBlockIndex sets the StartingBlockIndex field's value.
func (s *ListChangedBlocksInput) SetStartingBlockIndex(v int64) *ListChangedBlocksInput {
	s.StartingBlockIndex = &v
	return s
}

type ListChangedBlocksOutput struct {
	_ struct{} `type:"structure"`

	// The size of the blocks in the snapshot, in bytes.
	BlockSize *int64 `type:"integer"`

	// An array of objects containing information about the changed blocks.
	ChangedBlocks []*ChangedBlock `type:"list"`

	// The time when the BlockToken expires.
	ExpiryTime *time.Time `type:"timestamp"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// The size of the volume in GB.
	VolumeSize *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangedBlocksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChangedBlocksOutput) GoString() string {
	return s.String()
}

// SetBlockSize sets the BlockSize field's value.
func (s *ListChangedBlocksOutput) SetBlockSize(v int64) *ListChangedBlocksOutput {
	s.BlockSize = &v
	return s
}

// SetChangedBlocks sets the ChangedBlocks field's value.
func (s *ListChangedBlocksOutput) SetChangedBlocks(v []*ChangedBlock) *ListChangedBlocksOutput {
	s.ChangedBlocks = v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ListChangedBlocksOutput) SetExpiryTime(v time.Time) *ListChangedBlocksOutput {
	s.ExpiryTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangedBlocksOutput) SetNextToken(v string) *ListChangedBlocksOutput {
	s.NextToken = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *ListChangedBlocksOutput) SetVolumeSize(v int64) *ListChangedBlocksOutput {
	s.VolumeSize = &v
	return s
}

type ListSnapshotBlocksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"100" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"pageToken" type:"string"`

	// The ID of the snapshot from which to get block indexes and block tokens.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`

	// The block index from which the list should start. The list in the response
	// will start from this block index or the next valid block index in the snapshot.
	StartingBlockIndex *int64 `location:"querystring" locationName:"startingBlockIndex" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotBlocksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotBlocksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSnapshotBlocksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSnapshotBlocksInput"}
	if s.MaxResults != nil && *s.MaxResults < 100 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 100))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSnapshotBlocksInput) SetMaxResults(v int64) *ListSnapshotBlocksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotBlocksInput) SetNextToken(v string) *ListSnapshotBlocksInput {
	s.NextToken = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *ListSnapshotBlocksInput) SetSnapshotId(v string) *ListSnapshotBlocksInput {
	s.SnapshotId = &v
	return s
}

// SetStartingBlockIndex sets the StartingBlockIndex field's value.
func (s *ListSnapshotBlocksInput) SetStartingBlockIndex(v int64) *ListSnapshotBlocksInput {
	s.StartingBlockIndex = &v
	return s
}

type ListSnapshotBlocksOutput struct {
	_ struct{} `type:"structure"`

	// The size of the blocks in the snapshot, in bytes.
	BlockSize *int64 `type:"integer"`

	// An array of objects containing information about the blocks.
	//
	// Blocks is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListSnapshotBlocksOutput's
	// String and GoString methods.
	Blocks []*Block `type:"list" sensitive:"true"`

	// The time when the BlockToken expires.
	ExpiryTime *time.Time `type:"timestamp"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// The size of the volume in GB.
	VolumeSize *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotBlocksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotBlocksOutput) GoString() string {
	return s.String()
}

// SetBlockSize sets the BlockSize field's value.
func (s *ListSnapshotBlocksOutput) SetBlockSize(v int64) *ListSnapshotBlocksOutput {
	s.BlockSize = &v
	return s
}

// SetBlocks sets the Blocks field's value.
func (s *ListSnapshotBlocksOutput) SetBlocks(v []*Block) *ListSnapshotBlocksOutput {
	s.Blocks = v
	return s
}

// SetExpiryTime sets the ExpiryTime field's value.
func (s *ListSnapshotBlocksOutput) SetExpiryTime(v time.Time) *ListSnapshotBlocksOutput {
	s.ExpiryTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotBlocksOutput) SetNextToken(v string) *ListSnapshotBlocksOutput {
	s.NextToken = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *ListSnapshotBlocksOutput) SetVolumeSize(v int64) *ListSnapshotBlocksOutput {
	s.VolumeSize = &v
	return s
}

type PutSnapshotBlockInput struct {
	_ struct{} `type:"structure" payload:"BlockData"`

	// The data to write to the block.
	//
	// The block data is not signed as part of the Signature Version 4 signing process.
	// As a result, you must generate and provide a Base64-encoded SHA256 checksum
	// for the block data using the x-amz-Checksum header. Also, you must specify
	// the checksum algorithm using the x-amz-Checksum-Algorithm header. The checksum
	// that you provide is part of the Signature Version 4 signing process. It is
	// validated against a checksum generated by Amazon EBS to ensure the validity
	// and authenticity of the data. If the checksums do not correspond, the request
	// fails. For more information, see Using checksums with the EBS direct APIs
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-checksums)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// To use an non-seekable io.Reader for this request wrap the io.Reader with
	// "aws.ReadSeekCloser". The SDK will not retry request errors for non-seekable
	// readers. This will allow the SDK to send the reader's payload as chunked
	// transfer encoding.
	//
	// BlockData is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutSnapshotBlockInput's
	// String and GoString methods.
	//
	// BlockData is a required field
	BlockData io.ReadSeeker `type:"blob" required:"true" sensitive:"true"`

	// The block index of the block in which to write the data. A block index is
	// a logical index in units of 512 KiB blocks. To identify the block index,
	// divide the logical offset of the data in the logical volume by the block
	// size (logical offset of data/524288). The logical offset of the data must
	// be 512 KiB aligned.
	//
	// BlockIndex is a required field
	BlockIndex *int64 `location:"uri" locationName:"blockIndex" type:"integer" required:"true"`

	// A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are supported.
	//
	// Checksum is a required field
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string" required:"true"`

	// The algorithm used to generate the checksum. Currently, the only supported
	// algorithm is SHA256.
	//
	// ChecksumAlgorithm is a required field
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" required:"true" enum:"ChecksumAlgorithm"`

	// The size of the data to write to the block, in bytes. Currently, the only
	// supported size is 524288 bytes.
	//
	// Valid values: 524288
	//
	// DataLength is a required field
	DataLength *int64 `location:"header" locationName:"x-amz-Data-Length" type:"integer" required:"true"`

	// The progress of the write process, as a percentage.
	Progress *int64 `location:"header" locationName:"x-amz-Progress" type:"integer"`

	// The ID of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `location:"uri" locationName:"snapshotId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSnapshotBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSnapshotBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSnapshotBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSnapshotBlockInput"}
	if s.BlockData == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockData"))
	}
	if s.BlockIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockIndex"))
	}
	if s.Checksum == nil {
		invalidParams.Add(request.NewErrParamRequired("Checksum"))
	}
	if s.ChecksumAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("ChecksumAlgorithm"))
	}
	if s.DataLength == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLength"))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockData sets the BlockData field's value.
func (s *PutSnapshotBlockInput) SetBlockData(v io.ReadSeeker) *PutSnapshotBlockInput {
	s.BlockData = v
	return s
}

// SetBlockIndex sets the BlockIndex field's value.
func (s *PutSnapshotBlockInput) SetBlockIndex(v int64) *PutSnapshotBlockInput {
	s.BlockIndex = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *PutSnapshotBlockInput) SetChecksum(v string) *PutSnapshotBlockInput {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *PutSnapshotBlockInput) SetChecksumAlgorithm(v string) *PutSnapshotBlockInput {
	s.ChecksumAlgorithm = &v
	return s
}

// SetDataLength sets the DataLength field's value.
func (s *PutSnapshotBlockInput) SetDataLength(v int64) *PutSnapshotBlockInput {
	s.DataLength = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *PutSnapshotBlockInput) SetProgress(v int64) *PutSnapshotBlockInput {
	s.Progress = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *PutSnapshotBlockInput) SetSnapshotId(v string) *PutSnapshotBlockInput {
	s.SnapshotId = &v
	return s
}

type PutSnapshotBlockOutput struct {
	_ struct{} `type:"structure"`

	// The SHA256 checksum generated for the block data by Amazon EBS.
	Checksum *string `location:"header" locationName:"x-amz-Checksum" type:"string"`

	// The algorithm used by Amazon EBS to generate the checksum.
	ChecksumAlgorithm *string `location:"header" locationName:"x-amz-Checksum-Algorithm" type:"string" enum:"ChecksumAlgorithm"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSnapshotBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSnapshotBlockOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *PutSnapshotBlockOutput) SetChecksum(v string) *PutSnapshotBlockOutput {
	s.Checksum = &v
	return s
}

// SetChecksumAlgorithm sets the ChecksumAlgorithm field's value.
func (s *PutSnapshotBlockOutput) SetChecksumAlgorithm(v string) *PutSnapshotBlockOutput {
	s.ChecksumAlgorithm = &v
	return s
}

// The number of API requests has exceed the maximum allowed API request throttling
// limit.
type RequestThrottledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"RequestThrottledExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestThrottledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestThrottledException) GoString() string {
	return s.String()
}

func newErrorRequestThrottledException(v protocol.ResponseMetadata) error {
	return &RequestThrottledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestThrottledException) Code() string {
	return "RequestThrottledException"
}

// Message returns the exception's message.
func (s *RequestThrottledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestThrottledException) OrigErr() error {
	return nil
}

func (s *RequestThrottledException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestThrottledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestThrottledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ResourceNotFoundExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your current service quotas do not allow you to perform this action.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ServiceQuotaExceededExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully.
	// The subsequent retries with the same client token return the result from
	// the original successful request and they have no additional effect.
	//
	// If you do not specify a client token, one is automatically generated by the
	// Amazon Web Services SDK.
	//
	// For more information, see Idempotency for StartSnapshot API (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// A description for the snapshot.
	Description *string `type:"string"`

	// Indicates whether to encrypt the snapshot. To create an encrypted snapshot,
	// specify true. To create an unencrypted snapshot, omit this parameter.
	//
	// If you specify a value for ParentSnapshotId, omit this parameter.
	//
	// If you specify true, the snapshot is encrypted using the KMS key specified
	// using the KmsKeyArn parameter. If no value is specified for KmsKeyArn, the
	// default KMS key for your account is used. If no default KMS key has been
	// specified for your account, the Amazon Web Services managed KMS key is used.
	// To set a default KMS key for your account, use ModifyEbsDefaultKmsKeyId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html).
	//
	// If your account is enabled for encryption by default, you cannot set this
	// parameter to false. In this case, you can omit this parameter.
	//
	// For more information, see Using encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to
	// be used to encrypt the snapshot. If you do not specify a KMS key, the default
	// Amazon Web Services managed KMS key is used.
	//
	// If you specify a ParentSnapshotId, omit this parameter; the snapshot will
	// be encrypted using the same KMS key that was used to encrypt the parent snapshot.
	//
	// If Encrypted is set to true, you must specify a KMS key ARN.
	//
	// KmsKeyArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSnapshotInput's
	// String and GoString methods.
	KmsKeyArn *string `min:"1" type:"string" sensitive:"true"`

	// The ID of the parent snapshot. If there is no parent snapshot, or if you
	// are creating the first snapshot for an on-premises volume, omit this parameter.
	//
	// If your account is enabled for encryption by default, you cannot use an unencrypted
	// snapshot as a parent snapshot. You must first create an encrypted copy of
	// the parent snapshot using CopySnapshot (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html).
	ParentSnapshotId *string `min:"1" type:"string"`

	// The tags to apply to the snapshot.
	Tags []*Tag `type:"list"`

	// The amount of time (in minutes) after which the snapshot is automatically
	// cancelled if:
	//
	//    * No blocks are written to the snapshot.
	//
	//    * The snapshot is not completed after writing the last block of data.
	//
	// If no value is specified, the timeout defaults to 60 minutes.
	Timeout *int64 `min:"10" type:"integer"`

	// The size of the volume, in GiB. The maximum size is 65536 GiB (64 TiB).
	//
	// VolumeSize is a required field
	VolumeSize *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSnapshotInput"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}
	if s.ParentSnapshotId != nil && len(*s.ParentSnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentSnapshotId", 1))
	}
	if s.Timeout != nil && *s.Timeout < 10 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 10))
	}
	if s.VolumeSize == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSize"))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartSnapshotInput) SetClientToken(v string) *StartSnapshotInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartSnapshotInput) SetDescription(v string) *StartSnapshotInput {
	s.Description = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *StartSnapshotInput) SetEncrypted(v bool) *StartSnapshotInput {
	s.Encrypted = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *StartSnapshotInput) SetKmsKeyArn(v string) *StartSnapshotInput {
	s.KmsKeyArn = &v
	return s
}

// SetParentSnapshotId sets the ParentSnapshotId field's value.
func (s *StartSnapshotInput) SetParentSnapshotId(v string) *StartSnapshotInput {
	s.ParentSnapshotId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSnapshotInput) SetTags(v []*Tag) *StartSnapshotInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *StartSnapshotInput) SetTimeout(v int64) *StartSnapshotInput {
	s.Timeout = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *StartSnapshotInput) SetVolumeSize(v int64) *StartSnapshotInput {
	s.VolumeSize = &v
	return s
}

type StartSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The size of the blocks in the snapshot, in bytes.
	BlockSize *int64 `type:"integer"`

	// The description of the snapshot.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used
	// to encrypt the snapshot.
	//
	// KmsKeyArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartSnapshotOutput's
	// String and GoString methods.
	KmsKeyArn *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Web Services account ID of the snapshot owner.
	OwnerId *string `min:"1" type:"string"`

	// The ID of the parent snapshot.
	ParentSnapshotId *string `min:"1" type:"string"`

	// The ID of the snapshot.
	SnapshotId *string `min:"1" type:"string"`

	// The timestamp when the snapshot was created.
	StartTime *time.Time `type:"timestamp"`

	// The status of the snapshot.
	Status *string `type:"string" enum:"Status"`

	// The tags applied to the snapshot. You can specify up to 50 tags per snapshot.
	// For more information, see Tagging your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Tags []*Tag `type:"list"`

	// The size of the volume, in GiB.
	VolumeSize *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSnapshotOutput) GoString() string {
	return s.String()
}

// SetBlockSize sets the BlockSize field's value.
func (s *StartSnapshotOutput) SetBlockSize(v int64) *StartSnapshotOutput {
	s.BlockSize = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartSnapshotOutput) SetDescription(v string) *StartSnapshotOutput {
	s.Description = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *StartSnapshotOutput) SetKmsKeyArn(v string) *StartSnapshotOutput {
	s.KmsKeyArn = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *StartSnapshotOutput) SetOwnerId(v string) *StartSnapshotOutput {
	s.OwnerId = &v
	return s
}

// SetParentSnapshotId sets the ParentSnapshotId field's value.
func (s *StartSnapshotOutput) SetParentSnapshotId(v string) *StartSnapshotOutput {
	s.ParentSnapshotId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *StartSnapshotOutput) SetSnapshotId(v string) *StartSnapshotOutput {
	s.SnapshotId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StartSnapshotOutput) SetStartTime(v time.Time) *StartSnapshotOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartSnapshotOutput) SetStatus(v string) *StartSnapshotOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSnapshotOutput) SetTags(v []*Tag) *StartSnapshotOutput {
	s.Tags = v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *StartSnapshotOutput) SetVolumeSize(v int64) *StartSnapshotOutput {
	s.VolumeSize = &v
	return s
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `type:"string"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The input fails to satisfy the constraints of the EBS direct APIs.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the validation exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AccessDeniedExceptionReasonUnauthorizedAccount is a AccessDeniedExceptionReason enum value
	AccessDeniedExceptionReasonUnauthorizedAccount = "UNAUTHORIZED_ACCOUNT"

	// AccessDeniedExceptionReasonDependencyAccessDenied is a AccessDeniedExceptionReason enum value
	AccessDeniedExceptionReasonDependencyAccessDenied = "DEPENDENCY_ACCESS_DENIED"
)

// AccessDeniedExceptionReason_Values returns all elements of the AccessDeniedExceptionReason enum
func AccessDeniedExceptionReason_Values() []string {
	return []string{
		AccessDeniedExceptionReasonUnauthorizedAccount,
		AccessDeniedExceptionReasonDependencyAccessDenied,
	}
}

const (
	// ChecksumAggregationMethodLinear is a ChecksumAggregationMethod enum value
	ChecksumAggregationMethodLinear = "LINEAR"
)

// ChecksumAggregationMethod_Values returns all elements of the ChecksumAggregationMethod enum
func ChecksumAggregationMethod_Values() []string {
	return []string{
		ChecksumAggregationMethodLinear,
	}
}

const (
	// ChecksumAlgorithmSha256 is a ChecksumAlgorithm enum value
	ChecksumAlgorithmSha256 = "SHA256"
)

// ChecksumAlgorithm_Values returns all elements of the ChecksumAlgorithm enum
func ChecksumAlgorithm_Values() []string {
	return []string{
		ChecksumAlgorithmSha256,
	}
}

const (
	// RequestThrottledExceptionReasonAccountThrottled is a RequestThrottledExceptionReason enum value
	RequestThrottledExceptionReasonAccountThrottled = "ACCOUNT_THROTTLED"

	// RequestThrottledExceptionReasonDependencyRequestThrottled is a RequestThrottledExceptionReason enum value
	RequestThrottledExceptionReasonDependencyRequestThrottled = "DEPENDENCY_REQUEST_THROTTLED"
)

// RequestThrottledExceptionReason_Values returns all elements of the RequestThrottledExceptionReason enum
func RequestThrottledExceptionReason_Values() []string {
	return []string{
		RequestThrottledExceptionReasonAccountThrottled,
		RequestThrottledExceptionReasonDependencyRequestThrottled,
	}
}

const (
	// ResourceNotFoundExceptionReasonSnapshotNotFound is a ResourceNotFoundExceptionReason enum value
	ResourceNotFoundExceptionReasonSnapshotNotFound = "SNAPSHOT_NOT_FOUND"

	// ResourceNotFoundExceptionReasonDependencyResourceNotFound is a ResourceNotFoundExceptionReason enum value
	ResourceNotFoundExceptionReasonDependencyResourceNotFound = "DEPENDENCY_RESOURCE_NOT_FOUND"
)

// ResourceNotFoundExceptionReason_Values returns all elements of the ResourceNotFoundExceptionReason enum
func ResourceNotFoundExceptionReason_Values() []string {
	return []string{
		ResourceNotFoundExceptionReasonSnapshotNotFound,
		ResourceNotFoundExceptionReasonDependencyResourceNotFound,
	}
}

const (
	// ServiceQuotaExceededExceptionReasonDependencyServiceQuotaExceeded is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonDependencyServiceQuotaExceeded = "DEPENDENCY_SERVICE_QUOTA_EXCEEDED"
)

// ServiceQuotaExceededExceptionReason_Values returns all elements of the ServiceQuotaExceededExceptionReason enum
func ServiceQuotaExceededExceptionReason_Values() []string {
	return []string{
		ServiceQuotaExceededExceptionReasonDependencyServiceQuotaExceeded,
	}
}

const (
	// StatusCompleted is a Status enum value
	StatusCompleted = "completed"

	// StatusPending is a Status enum value
	StatusPending = "pending"

	// StatusError is a Status enum value
	StatusError = "error"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusCompleted,
		StatusPending,
		StatusError,
	}
}

const (
	// ValidationExceptionReasonInvalidCustomerKey is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidCustomerKey = "INVALID_CUSTOMER_KEY"

	// ValidationExceptionReasonInvalidPageToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidPageToken = "INVALID_PAGE_TOKEN"

	// ValidationExceptionReasonInvalidBlockToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBlockToken = "INVALID_BLOCK_TOKEN"

	// ValidationExceptionReasonInvalidSnapshotId is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidSnapshotId = "INVALID_SNAPSHOT_ID"

	// ValidationExceptionReasonUnrelatedSnapshots is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnrelatedSnapshots = "UNRELATED_SNAPSHOTS"

	// ValidationExceptionReasonInvalidBlock is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBlock = "INVALID_BLOCK"

	// ValidationExceptionReasonInvalidContentEncoding is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidContentEncoding = "INVALID_CONTENT_ENCODING"

	// ValidationExceptionReasonInvalidTag is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidTag = "INVALID_TAG"

	// ValidationExceptionReasonInvalidDependencyRequest is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidDependencyRequest = "INVALID_DEPENDENCY_REQUEST"

	// ValidationExceptionReasonInvalidParameterValue is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidParameterValue = "INVALID_PARAMETER_VALUE"

	// ValidationExceptionReasonInvalidVolumeSize is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidVolumeSize = "INVALID_VOLUME_SIZE"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonInvalidCustomerKey,
		ValidationExceptionReasonInvalidPageToken,
		ValidationExceptionReasonInvalidBlockToken,
		ValidationExceptionReasonInvalidSnapshotId,
		ValidationExceptionReasonUnrelatedSnapshots,
		ValidationExceptionReasonInvalidBlock,
		ValidationExceptionReasonInvalidContentEncoding,
		ValidationExceptionReasonInvalidTag,
		ValidationExceptionReasonInvalidDependencyRequest,
		ValidationExceptionReasonInvalidParameterValue,
		ValidationExceptionReasonInvalidVolumeSize,
	}
}
