// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigExemplarSlice(dest, src []otlpmetrics.Exemplar) []otlpmetrics.Exemplar {
	var newDest []otlpmetrics.Exemplar
	if cap(dest) < len(src) {
		newDest = make([]otlpmetrics.Exemplar, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigExemplar(&dest[i], false)
		}
	}
	for i := range src {
		CopyOrigExemplar(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestExemplarSlice() []otlpmetrics.Exemplar {
	orig := make([]otlpmetrics.Exemplar, 5)
	orig[1] = *GenTestOrigExemplar()
	orig[3] = *GenTestOrigExemplar()
	return orig
}
