// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigHistogram()
				CopyOrigHistogram(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigHistogram(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigHistogramUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigHistogram()
	UnmarshalJSONOrigHistogram(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigHistogram(), dest)
}

func TestMarshalAndUnmarshalJSONOrigHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigHistogram(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigHistogram()
				UnmarshalJSONOrigHistogram(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigHistogramFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigHistogram()
			require.Error(t, UnmarshalProtoOrigHistogram(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigHistogramUnknown(t *testing.T) {
	dest := NewOrigHistogram()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigHistogram(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigHistogram(), dest)
}

func TestMarshalAndUnmarshalProtoOrigHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigHistogram(src))
				gotSize := MarshalProtoOrigHistogram(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigHistogram()
				require.NoError(t, UnmarshalProtoOrigHistogram(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigHistogram(src))
			gotSize := MarshalProtoOrigHistogram(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Histogram{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigHistogram()
			require.NoError(t, UnmarshalProtoOrigHistogram(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesHistogram() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"DataPoints/wrong_wire_type":             {0xc},
		"DataPoints/missing_value":               {0xa},
		"AggregationTemporality/wrong_wire_type": {0x14},
		"AggregationTemporality/missing_value":   {0x10},
	}
}

func genTestEncodingValuesHistogram() map[string]*otlpmetrics.Histogram {
	return map[string]*otlpmetrics.Histogram{
		"empty":                       NewOrigHistogram(),
		"DataPoints/default_and_test": {DataPoints: []*otlpmetrics.HistogramDataPoint{{}, GenTestOrigHistogramDataPoint()}},
		"AggregationTemporality/test": {AggregationTemporality: otlpmetrics.AggregationTemporality(13)},
	}
}
