// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestGauge_MoveTo(t *testing.T) {
	ms := generateTestGauge()
	dest := NewGauge()
	ms.MoveTo(dest)
	assert.Equal(t, NewGauge(), ms)
	assert.Equal(t, generateTestGauge(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestGauge(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newGauge(internal.NewOrigGauge(), sharedState)) })
	assert.Panics(t, func() { newGauge(internal.NewOrigGauge(), sharedState).MoveTo(dest) })
}

func TestGauge_CopyTo(t *testing.T) {
	ms := NewGauge()
	orig := NewGauge()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestGauge()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newGauge(internal.NewOrigGauge(), sharedState)) })
}

func TestGauge_DataPoints(t *testing.T) {
	ms := NewGauge()
	assert.Equal(t, NewNumberDataPointSlice(), ms.DataPoints())
	ms.orig.DataPoints = internal.GenerateOrigTestNumberDataPointSlice()
	assert.Equal(t, generateTestNumberDataPointSlice(), ms.DataPoints())
}

func generateTestGauge() Gauge {
	ms := newGauge(internal.GenTestOrigGauge(), internal.NewState())
	return ms
}
