// Code generated by github.com/jmattheis/goverter, DO NOT EDIT.
//go:build !goverter

package house

import common "github.com/jmattheis/goverter/example/format/common"

func init() {
	ConvertApartment = func(source common.DBApartment) common.APIApartment {
		var commonAPIApartment common.APIApartment
		commonAPIApartment.Position = source.Position
		commonAPIApartment.Owner = ConvertPerson(source.Owner)
		commonAPIApartment.OwnerName = source.Owner.Name
		if source.CoResident != nil {
			commonAPIApartment.CoResident = make([]common.APIPerson, len(source.CoResident))
			for i := 0; i < len(source.CoResident); i++ {
				commonAPIApartment.CoResident[i] = ConvertPerson(source.CoResident[i])
			}
		}
		return commonAPIApartment
	}
	ConvertHouse = func(source common.DBHouse) common.APIHouse {
		var commonAPIHouse common.APIHouse
		commonAPIHouse.Address = source.Address
		commonAPIHouse.Apartments = ConvertToApartmentMap(source.Apartments)
		return commonAPIHouse
	}
	ConvertPerson = func(source common.DBPerson) common.APIPerson {
		var commonAPIPerson common.APIPerson
		commonAPIPerson.ID = source.ID
		commonAPIPerson.MiddleName = SQLStringToPString(source.MiddleName)
		pString := source.Name
		commonAPIPerson.FirstName = &pString
		if source.Friends != nil {
			commonAPIPerson.Friends = make([]common.APIPerson, len(source.Friends))
			for i := 0; i < len(source.Friends); i++ {
				commonAPIPerson.Friends[i] = ConvertPerson(source.Friends[i])
			}
		}
		commonAPIPerson.Info = commonInfoToCommonInfo(source.Info)
		return commonAPIPerson
	}
}
func commonInfoToCommonInfo(source common.Info) common.Info {
	var commonInfo common.Info
	commonInfo.Birthplace = source.Birthplace
	return commonInfo
}
