# CLI

The CLI allows you to specify package paths with converter interfaces and
[define global settings](../reference/define-settings.md#cli) that will be
applied to all converters.

```
$ goverter help
Usage:
  goverter gen [OPTIONS] PACKAGE...
  goverter help
  goverter version

PACKAGE(s):
  Define the import paths goverter will use to search for converter interfaces.
  You can define multiple packages and use the special ... golang pattern to
  select multiple packages. See $ go help packages

OPTIONS:
  -build-tags [tags]: (default: goverter)
      a comma-separated list of additional build tags to consider satisfied
      during the loading of conversion interfaces. See 'go help buildconstraint'.
      Can be disabled by supplying an empty string.

  -cwd [value]:
      set the working directory

  -g [value], -global [value]:
      apply settings to all defined converters. For a list of available
      settings see: https://goverter.jmattheis.de/reference/settings

  -output-constraint [constraint]: (default: !goverter)
      A build constraint added to all files generated by goverter.
      Can be disabled by supplying an empty string.

Examples:
  goverter gen ./example/simple ./example/complex
  goverter gen ./example/...
  goverter gen github.com/jmattheis/goverter/example/simple
  goverter gen -g 'ignoreMissing no' -g 'skipCopySameType' ./simple

Documentation:
  Full documentation is available here: https://goverter.jmattheis.de
```
