// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        v3.11.4
// source: github.com/moby/buildkit/solver/pb/ops.proto

// Package pb provides the protobuf definition of LLB: low-level builder instruction.
// LLB is DAG-structured; Op represents a vertex, and Definition represents a graph.

package pb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type NetMode int32

const (
	NetMode_UNSET NetMode = 0 // sandbox
	NetMode_HOST  NetMode = 1
	NetMode_NONE  NetMode = 2
)

// Enum value maps for NetMode.
var (
	NetMode_name = map[int32]string{
		0: "UNSET",
		1: "HOST",
		2: "NONE",
	}
	NetMode_value = map[string]int32{
		"UNSET": 0,
		"HOST":  1,
		"NONE":  2,
	}
)

func (x NetMode) Enum() *NetMode {
	p := new(NetMode)
	*p = x
	return p
}

func (x NetMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetMode) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[0].Descriptor()
}

func (NetMode) Type() protoreflect.EnumType {
	return &file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[0]
}

func (x NetMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetMode.Descriptor instead.
func (NetMode) EnumDescriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{0}
}

type SecurityMode int32

const (
	SecurityMode_SANDBOX  SecurityMode = 0
	SecurityMode_INSECURE SecurityMode = 1 // privileged mode
)

// Enum value maps for SecurityMode.
var (
	SecurityMode_name = map[int32]string{
		0: "SANDBOX",
		1: "INSECURE",
	}
	SecurityMode_value = map[string]int32{
		"SANDBOX":  0,
		"INSECURE": 1,
	}
)

func (x SecurityMode) Enum() *SecurityMode {
	p := new(SecurityMode)
	*p = x
	return p
}

func (x SecurityMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityMode) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[1].Descriptor()
}

func (SecurityMode) Type() protoreflect.EnumType {
	return &file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[1]
}

func (x SecurityMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityMode.Descriptor instead.
func (SecurityMode) EnumDescriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{1}
}

// MountType defines a type of a mount from a supported set
type MountType int32

const (
	MountType_BIND   MountType = 0
	MountType_SECRET MountType = 1
	MountType_SSH    MountType = 2
	MountType_CACHE  MountType = 3
	MountType_TMPFS  MountType = 4
)

// Enum value maps for MountType.
var (
	MountType_name = map[int32]string{
		0: "BIND",
		1: "SECRET",
		2: "SSH",
		3: "CACHE",
		4: "TMPFS",
	}
	MountType_value = map[string]int32{
		"BIND":   0,
		"SECRET": 1,
		"SSH":    2,
		"CACHE":  3,
		"TMPFS":  4,
	}
)

func (x MountType) Enum() *MountType {
	p := new(MountType)
	*p = x
	return p
}

func (x MountType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MountType) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[2].Descriptor()
}

func (MountType) Type() protoreflect.EnumType {
	return &file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[2]
}

func (x MountType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MountType.Descriptor instead.
func (MountType) EnumDescriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{2}
}

// MountContentCache ...
type MountContentCache int32

const (
	MountContentCache_DEFAULT MountContentCache = 0
	MountContentCache_ON      MountContentCache = 1
	MountContentCache_OFF     MountContentCache = 2
)

// Enum value maps for MountContentCache.
var (
	MountContentCache_name = map[int32]string{
		0: "DEFAULT",
		1: "ON",
		2: "OFF",
	}
	MountContentCache_value = map[string]int32{
		"DEFAULT": 0,
		"ON":      1,
		"OFF":     2,
	}
)

func (x MountContentCache) Enum() *MountContentCache {
	p := new(MountContentCache)
	*p = x
	return p
}

func (x MountContentCache) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MountContentCache) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[3].Descriptor()
}

func (MountContentCache) Type() protoreflect.EnumType {
	return &file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[3]
}

func (x MountContentCache) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MountContentCache.Descriptor instead.
func (MountContentCache) EnumDescriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{3}
}

// CacheSharingOpt defines different sharing modes for cache mount
type CacheSharingOpt int32

const (
	// SHARED cache mount can be used concurrently by multiple writers
	CacheSharingOpt_SHARED CacheSharingOpt = 0
	// PRIVATE creates a new mount if there are multiple writers
	CacheSharingOpt_PRIVATE CacheSharingOpt = 1
	// LOCKED pauses second writer until first one releases the mount
	CacheSharingOpt_LOCKED CacheSharingOpt = 2
)

// Enum value maps for CacheSharingOpt.
var (
	CacheSharingOpt_name = map[int32]string{
		0: "SHARED",
		1: "PRIVATE",
		2: "LOCKED",
	}
	CacheSharingOpt_value = map[string]int32{
		"SHARED":  0,
		"PRIVATE": 1,
		"LOCKED":  2,
	}
)

func (x CacheSharingOpt) Enum() *CacheSharingOpt {
	p := new(CacheSharingOpt)
	*p = x
	return p
}

func (x CacheSharingOpt) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CacheSharingOpt) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[4].Descriptor()
}

func (CacheSharingOpt) Type() protoreflect.EnumType {
	return &file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes[4]
}

func (x CacheSharingOpt) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CacheSharingOpt.Descriptor instead.
func (CacheSharingOpt) EnumDescriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{4}
}

// Op represents a vertex of the LLB DAG.
type Op struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// changes to this structure must be represented in json.go.
	// inputs is a set of input edges.
	Inputs []*Input `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// Types that are valid to be assigned to Op:
	//
	//	*Op_Exec
	//	*Op_Source
	//	*Op_File
	//	*Op_Build
	//	*Op_Merge
	//	*Op_Diff
	Op            isOp_Op            `protobuf_oneof:"op"`
	Platform      *Platform          `protobuf:"bytes,10,opt,name=platform,proto3" json:"platform,omitempty"`
	Constraints   *WorkerConstraints `protobuf:"bytes,11,opt,name=constraints,proto3" json:"constraints,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Op) Reset() {
	*x = Op{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Op) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Op) ProtoMessage() {}

func (x *Op) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Op.ProtoReflect.Descriptor instead.
func (*Op) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{0}
}

func (x *Op) GetInputs() []*Input {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *Op) GetOp() isOp_Op {
	if x != nil {
		return x.Op
	}
	return nil
}

func (x *Op) GetExec() *ExecOp {
	if x != nil {
		if x, ok := x.Op.(*Op_Exec); ok {
			return x.Exec
		}
	}
	return nil
}

func (x *Op) GetSource() *SourceOp {
	if x != nil {
		if x, ok := x.Op.(*Op_Source); ok {
			return x.Source
		}
	}
	return nil
}

func (x *Op) GetFile() *FileOp {
	if x != nil {
		if x, ok := x.Op.(*Op_File); ok {
			return x.File
		}
	}
	return nil
}

func (x *Op) GetBuild() *BuildOp {
	if x != nil {
		if x, ok := x.Op.(*Op_Build); ok {
			return x.Build
		}
	}
	return nil
}

func (x *Op) GetMerge() *MergeOp {
	if x != nil {
		if x, ok := x.Op.(*Op_Merge); ok {
			return x.Merge
		}
	}
	return nil
}

func (x *Op) GetDiff() *DiffOp {
	if x != nil {
		if x, ok := x.Op.(*Op_Diff); ok {
			return x.Diff
		}
	}
	return nil
}

func (x *Op) GetPlatform() *Platform {
	if x != nil {
		return x.Platform
	}
	return nil
}

func (x *Op) GetConstraints() *WorkerConstraints {
	if x != nil {
		return x.Constraints
	}
	return nil
}

type isOp_Op interface {
	isOp_Op()
}

type Op_Exec struct {
	Exec *ExecOp `protobuf:"bytes,2,opt,name=exec,proto3,oneof"`
}

type Op_Source struct {
	Source *SourceOp `protobuf:"bytes,3,opt,name=source,proto3,oneof"`
}

type Op_File struct {
	File *FileOp `protobuf:"bytes,4,opt,name=file,proto3,oneof"`
}

type Op_Build struct {
	Build *BuildOp `protobuf:"bytes,5,opt,name=build,proto3,oneof"`
}

type Op_Merge struct {
	Merge *MergeOp `protobuf:"bytes,6,opt,name=merge,proto3,oneof"`
}

type Op_Diff struct {
	Diff *DiffOp `protobuf:"bytes,7,opt,name=diff,proto3,oneof"`
}

func (*Op_Exec) isOp_Op() {}

func (*Op_Source) isOp_Op() {}

func (*Op_File) isOp_Op() {}

func (*Op_Build) isOp_Op() {}

func (*Op_Merge) isOp_Op() {}

func (*Op_Diff) isOp_Op() {}

// Platform is github.com/opencontainers/image-spec/specs-go/v1.Platform
type Platform struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Architecture  string                 `protobuf:"bytes,1,opt,name=Architecture,proto3" json:"Architecture,omitempty"`
	OS            string                 `protobuf:"bytes,2,opt,name=OS,proto3" json:"OS,omitempty"`
	Variant       string                 `protobuf:"bytes,3,opt,name=Variant,proto3" json:"Variant,omitempty"`
	OSVersion     string                 `protobuf:"bytes,4,opt,name=OSVersion,proto3" json:"OSVersion,omitempty"`
	OSFeatures    []string               `protobuf:"bytes,5,rep,name=OSFeatures,proto3" json:"OSFeatures,omitempty"` // unused
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Platform) Reset() {
	*x = Platform{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Platform) ProtoMessage() {}

func (x *Platform) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Platform.ProtoReflect.Descriptor instead.
func (*Platform) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{1}
}

func (x *Platform) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *Platform) GetOS() string {
	if x != nil {
		return x.OS
	}
	return ""
}

func (x *Platform) GetVariant() string {
	if x != nil {
		return x.Variant
	}
	return ""
}

func (x *Platform) GetOSVersion() string {
	if x != nil {
		return x.OSVersion
	}
	return ""
}

func (x *Platform) GetOSFeatures() []string {
	if x != nil {
		return x.OSFeatures
	}
	return nil
}

// Input represents an input edge for an Op.
type Input struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// digest of the marshaled input Op
	Digest string `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// output index of the input Op
	Index         int64 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Input) Reset() {
	*x = Input{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{2}
}

func (x *Input) GetDigest() string {
	if x != nil {
		return x.Digest
	}
	return ""
}

func (x *Input) GetIndex() int64 {
	if x != nil {
		return x.Index
	}
	return 0
}

// ExecOp executes a command in a container.
type ExecOp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Meta          *Meta                  `protobuf:"bytes,1,opt,name=meta,proto3" json:"meta,omitempty"`
	Mounts        []*Mount               `protobuf:"bytes,2,rep,name=mounts,proto3" json:"mounts,omitempty"`
	Network       NetMode                `protobuf:"varint,3,opt,name=network,proto3,enum=pb.NetMode" json:"network,omitempty"`
	Security      SecurityMode           `protobuf:"varint,4,opt,name=security,proto3,enum=pb.SecurityMode" json:"security,omitempty"`
	Secretenv     []*SecretEnv           `protobuf:"bytes,5,rep,name=secretenv,proto3" json:"secretenv,omitempty"`
	CdiDevices    []*CDIDevice           `protobuf:"bytes,6,rep,name=cdiDevices,proto3" json:"cdiDevices,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecOp) Reset() {
	*x = ExecOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecOp) ProtoMessage() {}

func (x *ExecOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecOp.ProtoReflect.Descriptor instead.
func (*ExecOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{3}
}

func (x *ExecOp) GetMeta() *Meta {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ExecOp) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *ExecOp) GetNetwork() NetMode {
	if x != nil {
		return x.Network
	}
	return NetMode_UNSET
}

func (x *ExecOp) GetSecurity() SecurityMode {
	if x != nil {
		return x.Security
	}
	return SecurityMode_SANDBOX
}

func (x *ExecOp) GetSecretenv() []*SecretEnv {
	if x != nil {
		return x.Secretenv
	}
	return nil
}

func (x *ExecOp) GetCdiDevices() []*CDIDevice {
	if x != nil {
		return x.CdiDevices
	}
	return nil
}

// Meta is a set of arguments for ExecOp.
// Meta is unrelated to LLB metadata.
// FIXME: rename (ExecContext? ExecArgs?)
type Meta struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	Args                      []string               `protobuf:"bytes,1,rep,name=args,proto3" json:"args,omitempty"`
	Env                       []string               `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	Cwd                       string                 `protobuf:"bytes,3,opt,name=cwd,proto3" json:"cwd,omitempty"`
	User                      string                 `protobuf:"bytes,4,opt,name=user,proto3" json:"user,omitempty"`
	ProxyEnv                  *ProxyEnv              `protobuf:"bytes,5,opt,name=proxy_env,json=proxyEnv,proto3" json:"proxy_env,omitempty"`
	ExtraHosts                []*HostIP              `protobuf:"bytes,6,rep,name=extraHosts,proto3" json:"extraHosts,omitempty"`
	Hostname                  string                 `protobuf:"bytes,7,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Ulimit                    []*Ulimit              `protobuf:"bytes,9,rep,name=ulimit,proto3" json:"ulimit,omitempty"`
	CgroupParent              string                 `protobuf:"bytes,10,opt,name=cgroupParent,proto3" json:"cgroupParent,omitempty"`
	RemoveMountStubsRecursive bool                   `protobuf:"varint,11,opt,name=removeMountStubsRecursive,proto3" json:"removeMountStubsRecursive,omitempty"`
	ValidExitCodes            []int32                `protobuf:"varint,12,rep,packed,name=validExitCodes,proto3" json:"validExitCodes,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Meta) Reset() {
	*x = Meta{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Meta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Meta) ProtoMessage() {}

func (x *Meta) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Meta.ProtoReflect.Descriptor instead.
func (*Meta) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{4}
}

func (x *Meta) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *Meta) GetEnv() []string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *Meta) GetCwd() string {
	if x != nil {
		return x.Cwd
	}
	return ""
}

func (x *Meta) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *Meta) GetProxyEnv() *ProxyEnv {
	if x != nil {
		return x.ProxyEnv
	}
	return nil
}

func (x *Meta) GetExtraHosts() []*HostIP {
	if x != nil {
		return x.ExtraHosts
	}
	return nil
}

func (x *Meta) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Meta) GetUlimit() []*Ulimit {
	if x != nil {
		return x.Ulimit
	}
	return nil
}

func (x *Meta) GetCgroupParent() string {
	if x != nil {
		return x.CgroupParent
	}
	return ""
}

func (x *Meta) GetRemoveMountStubsRecursive() bool {
	if x != nil {
		return x.RemoveMountStubsRecursive
	}
	return false
}

func (x *Meta) GetValidExitCodes() []int32 {
	if x != nil {
		return x.ValidExitCodes
	}
	return nil
}

type HostIP struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Host          string                 `protobuf:"bytes,1,opt,name=Host,proto3" json:"Host,omitempty"`
	IP            string                 `protobuf:"bytes,2,opt,name=IP,proto3" json:"IP,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HostIP) Reset() {
	*x = HostIP{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HostIP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostIP) ProtoMessage() {}

func (x *HostIP) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostIP.ProtoReflect.Descriptor instead.
func (*HostIP) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{5}
}

func (x *HostIP) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *HostIP) GetIP() string {
	if x != nil {
		return x.IP
	}
	return ""
}

type Ulimit struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Soft          int64                  `protobuf:"varint,2,opt,name=Soft,proto3" json:"Soft,omitempty"`
	Hard          int64                  `protobuf:"varint,3,opt,name=Hard,proto3" json:"Hard,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Ulimit) Reset() {
	*x = Ulimit{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Ulimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ulimit) ProtoMessage() {}

func (x *Ulimit) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ulimit.ProtoReflect.Descriptor instead.
func (*Ulimit) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{6}
}

func (x *Ulimit) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Ulimit) GetSoft() int64 {
	if x != nil {
		return x.Soft
	}
	return 0
}

func (x *Ulimit) GetHard() int64 {
	if x != nil {
		return x.Hard
	}
	return 0
}

// SecretEnv is an environment variable that is backed by a secret.
type SecretEnv struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ID            string                 `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Optional      bool                   `protobuf:"varint,3,opt,name=optional,proto3" json:"optional,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretEnv) Reset() {
	*x = SecretEnv{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretEnv) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretEnv) ProtoMessage() {}

func (x *SecretEnv) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretEnv.ProtoReflect.Descriptor instead.
func (*SecretEnv) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{7}
}

func (x *SecretEnv) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *SecretEnv) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SecretEnv) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

// CDIDevice specifies a CDI device information.
type CDIDevice struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Fully qualified CDI device name (e.g., vendor.com/gpu=gpudevice1)
	// https://github.com/cncf-tags/container-device-interface/blob/main/SPEC.md
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional defines if CDI device is required.
	Optional      bool `protobuf:"varint,2,opt,name=optional,proto3" json:"optional,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CDIDevice) Reset() {
	*x = CDIDevice{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CDIDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CDIDevice) ProtoMessage() {}

func (x *CDIDevice) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CDIDevice.ProtoReflect.Descriptor instead.
func (*CDIDevice) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{8}
}

func (x *CDIDevice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CDIDevice) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

// Mount specifies how to mount an input Op as a filesystem.
type Mount struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Input         int64                  `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`
	Selector      string                 `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	Dest          string                 `protobuf:"bytes,3,opt,name=dest,proto3" json:"dest,omitempty"`
	Output        int64                  `protobuf:"varint,4,opt,name=output,proto3" json:"output,omitempty"`
	Readonly      bool                   `protobuf:"varint,5,opt,name=readonly,proto3" json:"readonly,omitempty"`
	MountType     MountType              `protobuf:"varint,6,opt,name=mountType,proto3,enum=pb.MountType" json:"mountType,omitempty"`
	TmpfsOpt      *TmpfsOpt              `protobuf:"bytes,19,opt,name=TmpfsOpt,proto3" json:"TmpfsOpt,omitempty"`
	CacheOpt      *CacheOpt              `protobuf:"bytes,20,opt,name=cacheOpt,proto3" json:"cacheOpt,omitempty"`
	SecretOpt     *SecretOpt             `protobuf:"bytes,21,opt,name=secretOpt,proto3" json:"secretOpt,omitempty"`
	SSHOpt        *SSHOpt                `protobuf:"bytes,22,opt,name=SSHOpt,proto3" json:"SSHOpt,omitempty"`
	ResultID      string                 `protobuf:"bytes,23,opt,name=resultID,proto3" json:"resultID,omitempty"`
	ContentCache  MountContentCache      `protobuf:"varint,24,opt,name=contentCache,proto3,enum=pb.MountContentCache" json:"contentCache,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mount) Reset() {
	*x = Mount{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{9}
}

func (x *Mount) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

func (x *Mount) GetSelector() string {
	if x != nil {
		return x.Selector
	}
	return ""
}

func (x *Mount) GetDest() string {
	if x != nil {
		return x.Dest
	}
	return ""
}

func (x *Mount) GetOutput() int64 {
	if x != nil {
		return x.Output
	}
	return 0
}

func (x *Mount) GetReadonly() bool {
	if x != nil {
		return x.Readonly
	}
	return false
}

func (x *Mount) GetMountType() MountType {
	if x != nil {
		return x.MountType
	}
	return MountType_BIND
}

func (x *Mount) GetTmpfsOpt() *TmpfsOpt {
	if x != nil {
		return x.TmpfsOpt
	}
	return nil
}

func (x *Mount) GetCacheOpt() *CacheOpt {
	if x != nil {
		return x.CacheOpt
	}
	return nil
}

func (x *Mount) GetSecretOpt() *SecretOpt {
	if x != nil {
		return x.SecretOpt
	}
	return nil
}

func (x *Mount) GetSSHOpt() *SSHOpt {
	if x != nil {
		return x.SSHOpt
	}
	return nil
}

func (x *Mount) GetResultID() string {
	if x != nil {
		return x.ResultID
	}
	return ""
}

func (x *Mount) GetContentCache() MountContentCache {
	if x != nil {
		return x.ContentCache
	}
	return MountContentCache_DEFAULT
}

// TmpfsOpt defines options describing tpmfs mounts
type TmpfsOpt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specify an upper limit on the size of the filesystem.
	Size          int64 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TmpfsOpt) Reset() {
	*x = TmpfsOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TmpfsOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TmpfsOpt) ProtoMessage() {}

func (x *TmpfsOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TmpfsOpt.ProtoReflect.Descriptor instead.
func (*TmpfsOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{10}
}

func (x *TmpfsOpt) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// CacheOpt defines options specific to cache mounts
type CacheOpt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID is an optional namespace for the mount
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Sharing is the sharing mode for the mount
	Sharing       CacheSharingOpt `protobuf:"varint,2,opt,name=sharing,proto3,enum=pb.CacheSharingOpt" json:"sharing,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CacheOpt) Reset() {
	*x = CacheOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CacheOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheOpt) ProtoMessage() {}

func (x *CacheOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheOpt.ProtoReflect.Descriptor instead.
func (*CacheOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{11}
}

func (x *CacheOpt) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *CacheOpt) GetSharing() CacheSharingOpt {
	if x != nil {
		return x.Sharing
	}
	return CacheSharingOpt_SHARED
}

// SecretOpt defines options describing secret mounts
type SecretOpt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of secret. Used for quering the value.
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// UID of secret file
	Uid uint32 `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// GID of secret file
	Gid uint32 `protobuf:"varint,3,opt,name=gid,proto3" json:"gid,omitempty"`
	// Mode is the filesystem mode of secret file
	Mode uint32 `protobuf:"varint,4,opt,name=mode,proto3" json:"mode,omitempty"`
	// Optional defines if secret value is required. Error is produced
	// if value is not found and optional is false.
	Optional      bool `protobuf:"varint,5,opt,name=optional,proto3" json:"optional,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SecretOpt) Reset() {
	*x = SecretOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretOpt) ProtoMessage() {}

func (x *SecretOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretOpt.ProtoReflect.Descriptor instead.
func (*SecretOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{12}
}

func (x *SecretOpt) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *SecretOpt) GetUid() uint32 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *SecretOpt) GetGid() uint32 {
	if x != nil {
		return x.Gid
	}
	return 0
}

func (x *SecretOpt) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *SecretOpt) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

// SSHOpt defines options describing ssh mounts
type SSHOpt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of exposed ssh rule. Used for quering the value.
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// UID of agent socket
	Uid uint32 `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// GID of agent socket
	Gid uint32 `protobuf:"varint,3,opt,name=gid,proto3" json:"gid,omitempty"`
	// Mode is the filesystem mode of agent socket
	Mode uint32 `protobuf:"varint,4,opt,name=mode,proto3" json:"mode,omitempty"`
	// Optional defines if ssh socket is required. Error is produced
	// if client does not expose ssh.
	Optional      bool `protobuf:"varint,5,opt,name=optional,proto3" json:"optional,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SSHOpt) Reset() {
	*x = SSHOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SSHOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSHOpt) ProtoMessage() {}

func (x *SSHOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSHOpt.ProtoReflect.Descriptor instead.
func (*SSHOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{13}
}

func (x *SSHOpt) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *SSHOpt) GetUid() uint32 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *SSHOpt) GetGid() uint32 {
	if x != nil {
		return x.Gid
	}
	return 0
}

func (x *SSHOpt) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *SSHOpt) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

// SourceOp specifies a source such as build contexts and images.
type SourceOp struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// TODO: use source type or any type instead of URL protocol.
	// identifier e.g. local://, docker-image://, git://, https://...
	Identifier string `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// attrs are defined in attr.go
	Attrs         map[string]string `protobuf:"bytes,2,rep,name=attrs,proto3" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SourceOp) Reset() {
	*x = SourceOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceOp) ProtoMessage() {}

func (x *SourceOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceOp.ProtoReflect.Descriptor instead.
func (*SourceOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{14}
}

func (x *SourceOp) GetIdentifier() string {
	if x != nil {
		return x.Identifier
	}
	return ""
}

func (x *SourceOp) GetAttrs() map[string]string {
	if x != nil {
		return x.Attrs
	}
	return nil
}

// BuildOp is used for nested build invocation.
// BuildOp is experimental and can break without backwards compatibility
type BuildOp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Builder       int64                  `protobuf:"varint,1,opt,name=builder,proto3" json:"builder,omitempty"`
	Inputs        map[string]*BuildInput `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Def           *Definition            `protobuf:"bytes,3,opt,name=def,proto3" json:"def,omitempty"`
	Attrs         map[string]string      `protobuf:"bytes,4,rep,name=attrs,proto3" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"` // outputs
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BuildOp) Reset() {
	*x = BuildOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BuildOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildOp) ProtoMessage() {}

func (x *BuildOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildOp.ProtoReflect.Descriptor instead.
func (*BuildOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{15}
}

func (x *BuildOp) GetBuilder() int64 {
	if x != nil {
		return x.Builder
	}
	return 0
}

func (x *BuildOp) GetInputs() map[string]*BuildInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *BuildOp) GetDef() *Definition {
	if x != nil {
		return x.Def
	}
	return nil
}

func (x *BuildOp) GetAttrs() map[string]string {
	if x != nil {
		return x.Attrs
	}
	return nil
}

// BuildInput is used for BuildOp.
type BuildInput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Input         int64                  `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BuildInput) Reset() {
	*x = BuildInput{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BuildInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildInput) ProtoMessage() {}

func (x *BuildInput) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildInput.ProtoReflect.Descriptor instead.
func (*BuildInput) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{16}
}

func (x *BuildInput) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

// OpMetadata is a per-vertex metadata entry, which can be defined for arbitrary Op vertex and overridable on the run time.
type OpMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ignore_cache specifies to ignore the cache for this Op.
	IgnoreCache bool `protobuf:"varint,1,opt,name=ignore_cache,json=ignoreCache,proto3" json:"ignore_cache,omitempty"`
	// Description can be used for keeping any text fields that builder doesn't parse
	Description map[string]string `protobuf:"bytes,2,rep,name=description,proto3" json:"description,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// index 3 reserved for WorkerConstraint in previous versions
	// WorkerConstraint worker_constraint = 3;
	ExportCache   *ExportCache    `protobuf:"bytes,4,opt,name=export_cache,json=exportCache,proto3" json:"export_cache,omitempty"`
	Caps          map[string]bool `protobuf:"bytes,5,rep,name=caps,proto3" json:"caps,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ProgressGroup *ProgressGroup  `protobuf:"bytes,6,opt,name=progress_group,json=progressGroup,proto3" json:"progress_group,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpMetadata) Reset() {
	*x = OpMetadata{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpMetadata) ProtoMessage() {}

func (x *OpMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpMetadata.ProtoReflect.Descriptor instead.
func (*OpMetadata) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{17}
}

func (x *OpMetadata) GetIgnoreCache() bool {
	if x != nil {
		return x.IgnoreCache
	}
	return false
}

func (x *OpMetadata) GetDescription() map[string]string {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *OpMetadata) GetExportCache() *ExportCache {
	if x != nil {
		return x.ExportCache
	}
	return nil
}

func (x *OpMetadata) GetCaps() map[string]bool {
	if x != nil {
		return x.Caps
	}
	return nil
}

func (x *OpMetadata) GetProgressGroup() *ProgressGroup {
	if x != nil {
		return x.ProgressGroup
	}
	return nil
}

// Source is a source mapping description for a file
type Source struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Locations     map[string]*Locations  `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Infos         []*SourceInfo          `protobuf:"bytes,2,rep,name=infos,proto3" json:"infos,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Source) Reset() {
	*x = Source{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{18}
}

func (x *Source) GetLocations() map[string]*Locations {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *Source) GetInfos() []*SourceInfo {
	if x != nil {
		return x.Infos
	}
	return nil
}

// Locations is a list of ranges with a index to its source map.
type Locations struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Locations     []*Location            `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Locations) Reset() {
	*x = Locations{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Locations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Locations) ProtoMessage() {}

func (x *Locations) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Locations.ProtoReflect.Descriptor instead.
func (*Locations) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{19}
}

func (x *Locations) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

// Source info contains the shared metadata of a source mapping
type SourceInfo struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Filename      string                 `protobuf:"bytes,1,opt,name=filename,proto3" json:"filename,omitempty"`
	Data          []byte                 `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	Definition    *Definition            `protobuf:"bytes,3,opt,name=definition,proto3" json:"definition,omitempty"`
	Language      string                 `protobuf:"bytes,4,opt,name=language,proto3" json:"language,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SourceInfo) Reset() {
	*x = SourceInfo{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceInfo) ProtoMessage() {}

func (x *SourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceInfo.ProtoReflect.Descriptor instead.
func (*SourceInfo) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{20}
}

func (x *SourceInfo) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *SourceInfo) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SourceInfo) GetDefinition() *Definition {
	if x != nil {
		return x.Definition
	}
	return nil
}

func (x *SourceInfo) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

// Location defines list of areas in to source file
type Location struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SourceIndex   int32                  `protobuf:"varint,1,opt,name=sourceIndex,proto3" json:"sourceIndex,omitempty"`
	Ranges        []*Range               `protobuf:"bytes,2,rep,name=ranges,proto3" json:"ranges,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{21}
}

func (x *Location) GetSourceIndex() int32 {
	if x != nil {
		return x.SourceIndex
	}
	return 0
}

func (x *Location) GetRanges() []*Range {
	if x != nil {
		return x.Ranges
	}
	return nil
}

// Range is an area in the source file
type Range struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Start         *Position              `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End           *Position              `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Range) Reset() {
	*x = Range{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{22}
}

func (x *Range) GetStart() *Position {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *Range) GetEnd() *Position {
	if x != nil {
		return x.End
	}
	return nil
}

// Position is single location in a source file
type Position struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Line          int32                  `protobuf:"varint,1,opt,name=line,proto3" json:"line,omitempty"`
	Character     int32                  `protobuf:"varint,2,opt,name=character,proto3" json:"character,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Position) Reset() {
	*x = Position{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Position) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Position) ProtoMessage() {}

func (x *Position) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Position.ProtoReflect.Descriptor instead.
func (*Position) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{23}
}

func (x *Position) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *Position) GetCharacter() int32 {
	if x != nil {
		return x.Character
	}
	return 0
}

type ExportCache struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         bool                   `protobuf:"varint,1,opt,name=Value,proto3" json:"Value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExportCache) Reset() {
	*x = ExportCache{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportCache) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportCache) ProtoMessage() {}

func (x *ExportCache) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportCache.ProtoReflect.Descriptor instead.
func (*ExportCache) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{24}
}

func (x *ExportCache) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

type ProgressGroup struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Weak          bool                   `protobuf:"varint,3,opt,name=weak,proto3" json:"weak,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProgressGroup) Reset() {
	*x = ProgressGroup{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProgressGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProgressGroup) ProtoMessage() {}

func (x *ProgressGroup) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProgressGroup.ProtoReflect.Descriptor instead.
func (*ProgressGroup) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{25}
}

func (x *ProgressGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ProgressGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProgressGroup) GetWeak() bool {
	if x != nil {
		return x.Weak
	}
	return false
}

type ProxyEnv struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	HttpProxy     string                 `protobuf:"bytes,1,opt,name=http_proxy,json=httpProxy,proto3" json:"http_proxy,omitempty"`
	HttpsProxy    string                 `protobuf:"bytes,2,opt,name=https_proxy,json=httpsProxy,proto3" json:"https_proxy,omitempty"`
	FtpProxy      string                 `protobuf:"bytes,3,opt,name=ftp_proxy,json=ftpProxy,proto3" json:"ftp_proxy,omitempty"`
	NoProxy       string                 `protobuf:"bytes,4,opt,name=no_proxy,json=noProxy,proto3" json:"no_proxy,omitempty"`
	AllProxy      string                 `protobuf:"bytes,5,opt,name=all_proxy,json=allProxy,proto3" json:"all_proxy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyEnv) Reset() {
	*x = ProxyEnv{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyEnv) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyEnv) ProtoMessage() {}

func (x *ProxyEnv) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyEnv.ProtoReflect.Descriptor instead.
func (*ProxyEnv) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{26}
}

func (x *ProxyEnv) GetHttpProxy() string {
	if x != nil {
		return x.HttpProxy
	}
	return ""
}

func (x *ProxyEnv) GetHttpsProxy() string {
	if x != nil {
		return x.HttpsProxy
	}
	return ""
}

func (x *ProxyEnv) GetFtpProxy() string {
	if x != nil {
		return x.FtpProxy
	}
	return ""
}

func (x *ProxyEnv) GetNoProxy() string {
	if x != nil {
		return x.NoProxy
	}
	return ""
}

func (x *ProxyEnv) GetAllProxy() string {
	if x != nil {
		return x.AllProxy
	}
	return ""
}

// WorkerConstraints defines conditions for the worker
type WorkerConstraints struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Filter        []string               `protobuf:"bytes,1,rep,name=filter,proto3" json:"filter,omitempty"` // containerd-style filter
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkerConstraints) Reset() {
	*x = WorkerConstraints{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerConstraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConstraints) ProtoMessage() {}

func (x *WorkerConstraints) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConstraints.ProtoReflect.Descriptor instead.
func (*WorkerConstraints) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{27}
}

func (x *WorkerConstraints) GetFilter() []string {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Definition is the LLB definition structure with per-vertex metadata entries
type Definition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// def is a list of marshaled Op messages
	Def [][]byte `protobuf:"bytes,1,rep,name=def,proto3" json:"def,omitempty"`
	// metadata contains metadata for the each of the Op messages.
	// A key must be an LLB op digest string. Currently, empty string is not expected as a key, but it may change in the future.
	Metadata map[string]*OpMetadata `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Source contains the source mapping information for the vertexes in the definition
	Source        *Source `protobuf:"bytes,3,opt,name=Source,proto3" json:"Source,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Definition) Reset() {
	*x = Definition{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Definition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Definition) ProtoMessage() {}

func (x *Definition) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Definition.ProtoReflect.Descriptor instead.
func (*Definition) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{28}
}

func (x *Definition) GetDef() [][]byte {
	if x != nil {
		return x.Def
	}
	return nil
}

func (x *Definition) GetMetadata() map[string]*OpMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Definition) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

type FileOp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Actions       []*FileAction          `protobuf:"bytes,2,rep,name=actions,proto3" json:"actions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileOp) Reset() {
	*x = FileOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileOp) ProtoMessage() {}

func (x *FileOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileOp.ProtoReflect.Descriptor instead.
func (*FileOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{29}
}

func (x *FileOp) GetActions() []*FileAction {
	if x != nil {
		return x.Actions
	}
	return nil
}

type FileAction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// changes to this structure must be represented in json.go.
	Input          int64 `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`                   // could be real input or target (target index + max input index)
	SecondaryInput int64 `protobuf:"varint,2,opt,name=secondaryInput,proto3" json:"secondaryInput,omitempty"` // --//--
	Output         int64 `protobuf:"varint,3,opt,name=output,proto3" json:"output,omitempty"`
	// Types that are valid to be assigned to Action:
	//
	//	*FileAction_Copy
	//	*FileAction_Mkfile
	//	*FileAction_Mkdir
	//	*FileAction_Rm
	//	*FileAction_Symlink
	Action        isFileAction_Action `protobuf_oneof:"action"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileAction) Reset() {
	*x = FileAction{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileAction) ProtoMessage() {}

func (x *FileAction) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileAction.ProtoReflect.Descriptor instead.
func (*FileAction) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{30}
}

func (x *FileAction) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

func (x *FileAction) GetSecondaryInput() int64 {
	if x != nil {
		return x.SecondaryInput
	}
	return 0
}

func (x *FileAction) GetOutput() int64 {
	if x != nil {
		return x.Output
	}
	return 0
}

func (x *FileAction) GetAction() isFileAction_Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *FileAction) GetCopy() *FileActionCopy {
	if x != nil {
		if x, ok := x.Action.(*FileAction_Copy); ok {
			return x.Copy
		}
	}
	return nil
}

func (x *FileAction) GetMkfile() *FileActionMkFile {
	if x != nil {
		if x, ok := x.Action.(*FileAction_Mkfile); ok {
			return x.Mkfile
		}
	}
	return nil
}

func (x *FileAction) GetMkdir() *FileActionMkDir {
	if x != nil {
		if x, ok := x.Action.(*FileAction_Mkdir); ok {
			return x.Mkdir
		}
	}
	return nil
}

func (x *FileAction) GetRm() *FileActionRm {
	if x != nil {
		if x, ok := x.Action.(*FileAction_Rm); ok {
			return x.Rm
		}
	}
	return nil
}

func (x *FileAction) GetSymlink() *FileActionSymlink {
	if x != nil {
		if x, ok := x.Action.(*FileAction_Symlink); ok {
			return x.Symlink
		}
	}
	return nil
}

type isFileAction_Action interface {
	isFileAction_Action()
}

type FileAction_Copy struct {
	// FileActionCopy copies files from secondaryInput on top of input
	Copy *FileActionCopy `protobuf:"bytes,4,opt,name=copy,proto3,oneof"`
}

type FileAction_Mkfile struct {
	// FileActionMkFile creates a new file
	Mkfile *FileActionMkFile `protobuf:"bytes,5,opt,name=mkfile,proto3,oneof"`
}

type FileAction_Mkdir struct {
	// FileActionMkDir creates a new directory
	Mkdir *FileActionMkDir `protobuf:"bytes,6,opt,name=mkdir,proto3,oneof"`
}

type FileAction_Rm struct {
	// FileActionRm removes a file
	Rm *FileActionRm `protobuf:"bytes,7,opt,name=rm,proto3,oneof"`
}

type FileAction_Symlink struct {
	// FileActionSymlink creates a symlink
	Symlink *FileActionSymlink `protobuf:"bytes,8,opt,name=symlink,proto3,oneof"`
}

func (*FileAction_Copy) isFileAction_Action() {}

func (*FileAction_Mkfile) isFileAction_Action() {}

func (*FileAction_Mkdir) isFileAction_Action() {}

func (*FileAction_Rm) isFileAction_Action() {}

func (*FileAction_Symlink) isFileAction_Action() {}

type FileActionCopy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// src is the source path
	Src string `protobuf:"bytes,1,opt,name=src,proto3" json:"src,omitempty"`
	// dest path
	Dest string `protobuf:"bytes,2,opt,name=dest,proto3" json:"dest,omitempty"`
	// optional owner override
	Owner *ChownOpt `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// optional permission bits override
	Mode int32 `protobuf:"varint,4,opt,name=mode,proto3" json:"mode,omitempty"`
	// followSymlink resolves symlinks in src
	FollowSymlink bool `protobuf:"varint,5,opt,name=followSymlink,proto3" json:"followSymlink,omitempty"`
	// dirCopyContents only copies contents if src is a directory
	DirCopyContents bool `protobuf:"varint,6,opt,name=dirCopyContents,proto3" json:"dirCopyContents,omitempty"`
	// attemptUnpackDockerCompatibility detects if src is an archive to unpack it instead
	AttemptUnpackDockerCompatibility bool `protobuf:"varint,7,opt,name=attemptUnpackDockerCompatibility,proto3" json:"attemptUnpackDockerCompatibility,omitempty"`
	// createDestPath creates dest path directories if needed
	CreateDestPath bool `protobuf:"varint,8,opt,name=createDestPath,proto3" json:"createDestPath,omitempty"`
	// allowWildcard allows filepath.Match wildcards in src path
	AllowWildcard bool `protobuf:"varint,9,opt,name=allowWildcard,proto3" json:"allowWildcard,omitempty"`
	// allowEmptyWildcard doesn't fail the whole copy if wildcard doesn't resolve to files
	AllowEmptyWildcard bool `protobuf:"varint,10,opt,name=allowEmptyWildcard,proto3" json:"allowEmptyWildcard,omitempty"`
	// optional created time override
	Timestamp int64 `protobuf:"varint,11,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// include only files/dirs matching at least one of these patterns
	IncludePatterns []string `protobuf:"bytes,12,rep,name=include_patterns,json=includePatterns,proto3" json:"include_patterns,omitempty"`
	// exclude files/dir matching any of these patterns (even if they match an include pattern)
	ExcludePatterns []string `protobuf:"bytes,13,rep,name=exclude_patterns,json=excludePatterns,proto3" json:"exclude_patterns,omitempty"`
	// alwaysReplaceExistingDestPaths results in an existing dest path that differs in type from the src path being replaced rather than the default of returning an error
	AlwaysReplaceExistingDestPaths bool `protobuf:"varint,14,opt,name=alwaysReplaceExistingDestPaths,proto3" json:"alwaysReplaceExistingDestPaths,omitempty"`
	// mode in non-octal format
	ModeStr       string `protobuf:"bytes,15,opt,name=modeStr,proto3" json:"modeStr,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileActionCopy) Reset() {
	*x = FileActionCopy{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileActionCopy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileActionCopy) ProtoMessage() {}

func (x *FileActionCopy) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileActionCopy.ProtoReflect.Descriptor instead.
func (*FileActionCopy) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{31}
}

func (x *FileActionCopy) GetSrc() string {
	if x != nil {
		return x.Src
	}
	return ""
}

func (x *FileActionCopy) GetDest() string {
	if x != nil {
		return x.Dest
	}
	return ""
}

func (x *FileActionCopy) GetOwner() *ChownOpt {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *FileActionCopy) GetMode() int32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *FileActionCopy) GetFollowSymlink() bool {
	if x != nil {
		return x.FollowSymlink
	}
	return false
}

func (x *FileActionCopy) GetDirCopyContents() bool {
	if x != nil {
		return x.DirCopyContents
	}
	return false
}

func (x *FileActionCopy) GetAttemptUnpackDockerCompatibility() bool {
	if x != nil {
		return x.AttemptUnpackDockerCompatibility
	}
	return false
}

func (x *FileActionCopy) GetCreateDestPath() bool {
	if x != nil {
		return x.CreateDestPath
	}
	return false
}

func (x *FileActionCopy) GetAllowWildcard() bool {
	if x != nil {
		return x.AllowWildcard
	}
	return false
}

func (x *FileActionCopy) GetAllowEmptyWildcard() bool {
	if x != nil {
		return x.AllowEmptyWildcard
	}
	return false
}

func (x *FileActionCopy) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *FileActionCopy) GetIncludePatterns() []string {
	if x != nil {
		return x.IncludePatterns
	}
	return nil
}

func (x *FileActionCopy) GetExcludePatterns() []string {
	if x != nil {
		return x.ExcludePatterns
	}
	return nil
}

func (x *FileActionCopy) GetAlwaysReplaceExistingDestPaths() bool {
	if x != nil {
		return x.AlwaysReplaceExistingDestPaths
	}
	return false
}

func (x *FileActionCopy) GetModeStr() string {
	if x != nil {
		return x.ModeStr
	}
	return ""
}

type FileActionMkFile struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// path for the new file
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// permission bits
	Mode int32 `protobuf:"varint,2,opt,name=mode,proto3" json:"mode,omitempty"`
	// data is the new file contents
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// optional owner for the new file
	Owner *ChownOpt `protobuf:"bytes,4,opt,name=owner,proto3" json:"owner,omitempty"`
	// optional created time override
	Timestamp     int64 `protobuf:"varint,5,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileActionMkFile) Reset() {
	*x = FileActionMkFile{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileActionMkFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileActionMkFile) ProtoMessage() {}

func (x *FileActionMkFile) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileActionMkFile.ProtoReflect.Descriptor instead.
func (*FileActionMkFile) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{32}
}

func (x *FileActionMkFile) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileActionMkFile) GetMode() int32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *FileActionMkFile) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *FileActionMkFile) GetOwner() *ChownOpt {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *FileActionMkFile) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type FileActionSymlink struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// destination path for the new file representing the link
	Oldpath string `protobuf:"bytes,1,opt,name=oldpath,proto3" json:"oldpath,omitempty"`
	// source path for the link
	Newpath string `protobuf:"bytes,2,opt,name=newpath,proto3" json:"newpath,omitempty"`
	// optional owner for the new file
	Owner *ChownOpt `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// optional created time override
	Timestamp     int64 `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileActionSymlink) Reset() {
	*x = FileActionSymlink{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileActionSymlink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileActionSymlink) ProtoMessage() {}

func (x *FileActionSymlink) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileActionSymlink.ProtoReflect.Descriptor instead.
func (*FileActionSymlink) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{33}
}

func (x *FileActionSymlink) GetOldpath() string {
	if x != nil {
		return x.Oldpath
	}
	return ""
}

func (x *FileActionSymlink) GetNewpath() string {
	if x != nil {
		return x.Newpath
	}
	return ""
}

func (x *FileActionSymlink) GetOwner() *ChownOpt {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *FileActionSymlink) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type FileActionMkDir struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// path for the new directory
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// permission bits
	Mode int32 `protobuf:"varint,2,opt,name=mode,proto3" json:"mode,omitempty"`
	// makeParents creates parent directories as well if needed
	MakeParents bool `protobuf:"varint,3,opt,name=makeParents,proto3" json:"makeParents,omitempty"`
	// optional owner for the new directory
	Owner *ChownOpt `protobuf:"bytes,4,opt,name=owner,proto3" json:"owner,omitempty"`
	// optional created time override
	Timestamp     int64 `protobuf:"varint,5,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileActionMkDir) Reset() {
	*x = FileActionMkDir{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileActionMkDir) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileActionMkDir) ProtoMessage() {}

func (x *FileActionMkDir) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileActionMkDir.ProtoReflect.Descriptor instead.
func (*FileActionMkDir) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{34}
}

func (x *FileActionMkDir) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileActionMkDir) GetMode() int32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *FileActionMkDir) GetMakeParents() bool {
	if x != nil {
		return x.MakeParents
	}
	return false
}

func (x *FileActionMkDir) GetOwner() *ChownOpt {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *FileActionMkDir) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type FileActionRm struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// path to remove
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// allowNotFound doesn't fail the rm if file is not found
	AllowNotFound bool `protobuf:"varint,2,opt,name=allowNotFound,proto3" json:"allowNotFound,omitempty"`
	// allowWildcard allows filepath.Match wildcards in path
	AllowWildcard bool `protobuf:"varint,3,opt,name=allowWildcard,proto3" json:"allowWildcard,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FileActionRm) Reset() {
	*x = FileActionRm{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileActionRm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileActionRm) ProtoMessage() {}

func (x *FileActionRm) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileActionRm.ProtoReflect.Descriptor instead.
func (*FileActionRm) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{35}
}

func (x *FileActionRm) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FileActionRm) GetAllowNotFound() bool {
	if x != nil {
		return x.AllowNotFound
	}
	return false
}

func (x *FileActionRm) GetAllowWildcard() bool {
	if x != nil {
		return x.AllowWildcard
	}
	return false
}

type ChownOpt struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	User          *UserOpt               `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	Group         *UserOpt               `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChownOpt) Reset() {
	*x = ChownOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChownOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChownOpt) ProtoMessage() {}

func (x *ChownOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChownOpt.ProtoReflect.Descriptor instead.
func (*ChownOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{36}
}

func (x *ChownOpt) GetUser() *UserOpt {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ChownOpt) GetGroup() *UserOpt {
	if x != nil {
		return x.Group
	}
	return nil
}

type UserOpt struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// changes to this structure must be represented in json.go.
	//
	// Types that are valid to be assigned to User:
	//
	//	*UserOpt_ByName
	//	*UserOpt_ByID
	User          isUserOpt_User `protobuf_oneof:"user"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserOpt) Reset() {
	*x = UserOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserOpt) ProtoMessage() {}

func (x *UserOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserOpt.ProtoReflect.Descriptor instead.
func (*UserOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{37}
}

func (x *UserOpt) GetUser() isUserOpt_User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *UserOpt) GetByName() *NamedUserOpt {
	if x != nil {
		if x, ok := x.User.(*UserOpt_ByName); ok {
			return x.ByName
		}
	}
	return nil
}

func (x *UserOpt) GetByID() uint32 {
	if x != nil {
		if x, ok := x.User.(*UserOpt_ByID); ok {
			return x.ByID
		}
	}
	return 0
}

type isUserOpt_User interface {
	isUserOpt_User()
}

type UserOpt_ByName struct {
	ByName *NamedUserOpt `protobuf:"bytes,1,opt,name=byName,proto3,oneof"`
}

type UserOpt_ByID struct {
	ByID uint32 `protobuf:"varint,2,opt,name=byID,proto3,oneof"`
}

func (*UserOpt_ByName) isUserOpt_User() {}

func (*UserOpt_ByID) isUserOpt_User() {}

type NamedUserOpt struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Input         int64                  `protobuf:"varint,2,opt,name=input,proto3" json:"input,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NamedUserOpt) Reset() {
	*x = NamedUserOpt{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamedUserOpt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamedUserOpt) ProtoMessage() {}

func (x *NamedUserOpt) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamedUserOpt.ProtoReflect.Descriptor instead.
func (*NamedUserOpt) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{38}
}

func (x *NamedUserOpt) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NamedUserOpt) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

type MergeInput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Input         int64                  `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MergeInput) Reset() {
	*x = MergeInput{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MergeInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeInput) ProtoMessage() {}

func (x *MergeInput) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeInput.ProtoReflect.Descriptor instead.
func (*MergeInput) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{39}
}

func (x *MergeInput) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

type MergeOp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Inputs        []*MergeInput          `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MergeOp) Reset() {
	*x = MergeOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MergeOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeOp) ProtoMessage() {}

func (x *MergeOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeOp.ProtoReflect.Descriptor instead.
func (*MergeOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{40}
}

func (x *MergeOp) GetInputs() []*MergeInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

type LowerDiffInput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Input         int64                  `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LowerDiffInput) Reset() {
	*x = LowerDiffInput{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LowerDiffInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LowerDiffInput) ProtoMessage() {}

func (x *LowerDiffInput) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LowerDiffInput.ProtoReflect.Descriptor instead.
func (*LowerDiffInput) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{41}
}

func (x *LowerDiffInput) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

type UpperDiffInput struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Input         int64                  `protobuf:"varint,1,opt,name=input,proto3" json:"input,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpperDiffInput) Reset() {
	*x = UpperDiffInput{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpperDiffInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpperDiffInput) ProtoMessage() {}

func (x *UpperDiffInput) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpperDiffInput.ProtoReflect.Descriptor instead.
func (*UpperDiffInput) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{42}
}

func (x *UpperDiffInput) GetInput() int64 {
	if x != nil {
		return x.Input
	}
	return 0
}

type DiffOp struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Lower         *LowerDiffInput        `protobuf:"bytes,1,opt,name=lower,proto3" json:"lower,omitempty"`
	Upper         *UpperDiffInput        `protobuf:"bytes,2,opt,name=upper,proto3" json:"upper,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DiffOp) Reset() {
	*x = DiffOp{}
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiffOp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiffOp) ProtoMessage() {}

func (x *DiffOp) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiffOp.ProtoReflect.Descriptor instead.
func (*DiffOp) Descriptor() ([]byte, []int) {
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP(), []int{43}
}

func (x *DiffOp) GetLower() *LowerDiffInput {
	if x != nil {
		return x.Lower
	}
	return nil
}

func (x *DiffOp) GetUpper() *UpperDiffInput {
	if x != nil {
		return x.Upper
	}
	return nil
}

var File_github_com_moby_buildkit_solver_pb_ops_proto protoreflect.FileDescriptor

const file_github_com_moby_buildkit_solver_pb_ops_proto_rawDesc = "" +
	"\n" +
	",github.com/moby/buildkit/solver/pb/ops.proto\x12\x02pb\"\xe8\x02\n" +
	"\x02Op\x12!\n" +
	"\x06inputs\x18\x01 \x03(\v2\t.pb.InputR\x06inputs\x12 \n" +
	"\x04exec\x18\x02 \x01(\v2\n" +
	".pb.ExecOpH\x00R\x04exec\x12&\n" +
	"\x06source\x18\x03 \x01(\v2\f.pb.SourceOpH\x00R\x06source\x12 \n" +
	"\x04file\x18\x04 \x01(\v2\n" +
	".pb.FileOpH\x00R\x04file\x12#\n" +
	"\x05build\x18\x05 \x01(\v2\v.pb.BuildOpH\x00R\x05build\x12#\n" +
	"\x05merge\x18\x06 \x01(\v2\v.pb.MergeOpH\x00R\x05merge\x12 \n" +
	"\x04diff\x18\a \x01(\v2\n" +
	".pb.DiffOpH\x00R\x04diff\x12(\n" +
	"\bplatform\x18\n" +
	" \x01(\v2\f.pb.PlatformR\bplatform\x127\n" +
	"\vconstraints\x18\v \x01(\v2\x15.pb.WorkerConstraintsR\vconstraintsB\x04\n" +
	"\x02op\"\x96\x01\n" +
	"\bPlatform\x12\"\n" +
	"\fArchitecture\x18\x01 \x01(\tR\fArchitecture\x12\x0e\n" +
	"\x02OS\x18\x02 \x01(\tR\x02OS\x12\x18\n" +
	"\aVariant\x18\x03 \x01(\tR\aVariant\x12\x1c\n" +
	"\tOSVersion\x18\x04 \x01(\tR\tOSVersion\x12\x1e\n" +
	"\n" +
	"OSFeatures\x18\x05 \x03(\tR\n" +
	"OSFeatures\"5\n" +
	"\x05Input\x12\x16\n" +
	"\x06digest\x18\x01 \x01(\tR\x06digest\x12\x14\n" +
	"\x05index\x18\x02 \x01(\x03R\x05index\"\xfa\x01\n" +
	"\x06ExecOp\x12\x1c\n" +
	"\x04meta\x18\x01 \x01(\v2\b.pb.MetaR\x04meta\x12!\n" +
	"\x06mounts\x18\x02 \x03(\v2\t.pb.MountR\x06mounts\x12%\n" +
	"\anetwork\x18\x03 \x01(\x0e2\v.pb.NetModeR\anetwork\x12,\n" +
	"\bsecurity\x18\x04 \x01(\x0e2\x10.pb.SecurityModeR\bsecurity\x12+\n" +
	"\tsecretenv\x18\x05 \x03(\v2\r.pb.SecretEnvR\tsecretenv\x12-\n" +
	"\n" +
	"cdiDevices\x18\x06 \x03(\v2\r.pb.CDIDeviceR\n" +
	"cdiDevices\"\xf3\x02\n" +
	"\x04Meta\x12\x12\n" +
	"\x04args\x18\x01 \x03(\tR\x04args\x12\x10\n" +
	"\x03env\x18\x02 \x03(\tR\x03env\x12\x10\n" +
	"\x03cwd\x18\x03 \x01(\tR\x03cwd\x12\x12\n" +
	"\x04user\x18\x04 \x01(\tR\x04user\x12)\n" +
	"\tproxy_env\x18\x05 \x01(\v2\f.pb.ProxyEnvR\bproxyEnv\x12*\n" +
	"\n" +
	"extraHosts\x18\x06 \x03(\v2\n" +
	".pb.HostIPR\n" +
	"extraHosts\x12\x1a\n" +
	"\bhostname\x18\a \x01(\tR\bhostname\x12\"\n" +
	"\x06ulimit\x18\t \x03(\v2\n" +
	".pb.UlimitR\x06ulimit\x12\"\n" +
	"\fcgroupParent\x18\n" +
	" \x01(\tR\fcgroupParent\x12<\n" +
	"\x19removeMountStubsRecursive\x18\v \x01(\bR\x19removeMountStubsRecursive\x12&\n" +
	"\x0evalidExitCodes\x18\f \x03(\x05R\x0evalidExitCodes\",\n" +
	"\x06HostIP\x12\x12\n" +
	"\x04Host\x18\x01 \x01(\tR\x04Host\x12\x0e\n" +
	"\x02IP\x18\x02 \x01(\tR\x02IP\"D\n" +
	"\x06Ulimit\x12\x12\n" +
	"\x04Name\x18\x01 \x01(\tR\x04Name\x12\x12\n" +
	"\x04Soft\x18\x02 \x01(\x03R\x04Soft\x12\x12\n" +
	"\x04Hard\x18\x03 \x01(\x03R\x04Hard\"K\n" +
	"\tSecretEnv\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\tR\x02ID\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x1a\n" +
	"\boptional\x18\x03 \x01(\bR\boptional\";\n" +
	"\tCDIDevice\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1a\n" +
	"\boptional\x18\x02 \x01(\bR\boptional\"\xaa\x03\n" +
	"\x05Mount\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\x12\x1a\n" +
	"\bselector\x18\x02 \x01(\tR\bselector\x12\x12\n" +
	"\x04dest\x18\x03 \x01(\tR\x04dest\x12\x16\n" +
	"\x06output\x18\x04 \x01(\x03R\x06output\x12\x1a\n" +
	"\breadonly\x18\x05 \x01(\bR\breadonly\x12+\n" +
	"\tmountType\x18\x06 \x01(\x0e2\r.pb.MountTypeR\tmountType\x12(\n" +
	"\bTmpfsOpt\x18\x13 \x01(\v2\f.pb.TmpfsOptR\bTmpfsOpt\x12(\n" +
	"\bcacheOpt\x18\x14 \x01(\v2\f.pb.CacheOptR\bcacheOpt\x12+\n" +
	"\tsecretOpt\x18\x15 \x01(\v2\r.pb.SecretOptR\tsecretOpt\x12\"\n" +
	"\x06SSHOpt\x18\x16 \x01(\v2\n" +
	".pb.SSHOptR\x06SSHOpt\x12\x1a\n" +
	"\bresultID\x18\x17 \x01(\tR\bresultID\x129\n" +
	"\fcontentCache\x18\x18 \x01(\x0e2\x15.pb.MountContentCacheR\fcontentCache\"\x1e\n" +
	"\bTmpfsOpt\x12\x12\n" +
	"\x04size\x18\x01 \x01(\x03R\x04size\"I\n" +
	"\bCacheOpt\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\tR\x02ID\x12-\n" +
	"\asharing\x18\x02 \x01(\x0e2\x13.pb.CacheSharingOptR\asharing\"o\n" +
	"\tSecretOpt\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\tR\x02ID\x12\x10\n" +
	"\x03uid\x18\x02 \x01(\rR\x03uid\x12\x10\n" +
	"\x03gid\x18\x03 \x01(\rR\x03gid\x12\x12\n" +
	"\x04mode\x18\x04 \x01(\rR\x04mode\x12\x1a\n" +
	"\boptional\x18\x05 \x01(\bR\boptional\"l\n" +
	"\x06SSHOpt\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\tR\x02ID\x12\x10\n" +
	"\x03uid\x18\x02 \x01(\rR\x03uid\x12\x10\n" +
	"\x03gid\x18\x03 \x01(\rR\x03gid\x12\x12\n" +
	"\x04mode\x18\x04 \x01(\rR\x04mode\x12\x1a\n" +
	"\boptional\x18\x05 \x01(\bR\boptional\"\x93\x01\n" +
	"\bSourceOp\x12\x1e\n" +
	"\n" +
	"identifier\x18\x01 \x01(\tR\n" +
	"identifier\x12-\n" +
	"\x05attrs\x18\x02 \x03(\v2\x17.pb.SourceOp.AttrsEntryR\x05attrs\x1a8\n" +
	"\n" +
	"AttrsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xa9\x02\n" +
	"\aBuildOp\x12\x18\n" +
	"\abuilder\x18\x01 \x01(\x03R\abuilder\x12/\n" +
	"\x06inputs\x18\x02 \x03(\v2\x17.pb.BuildOp.InputsEntryR\x06inputs\x12 \n" +
	"\x03def\x18\x03 \x01(\v2\x0e.pb.DefinitionR\x03def\x12,\n" +
	"\x05attrs\x18\x04 \x03(\v2\x16.pb.BuildOp.AttrsEntryR\x05attrs\x1aI\n" +
	"\vInputsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12$\n" +
	"\x05value\x18\x02 \x01(\v2\x0e.pb.BuildInputR\x05value:\x028\x01\x1a8\n" +
	"\n" +
	"AttrsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\"\n" +
	"\n" +
	"BuildInput\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\"\x87\x03\n" +
	"\n" +
	"OpMetadata\x12!\n" +
	"\fignore_cache\x18\x01 \x01(\bR\vignoreCache\x12A\n" +
	"\vdescription\x18\x02 \x03(\v2\x1f.pb.OpMetadata.DescriptionEntryR\vdescription\x122\n" +
	"\fexport_cache\x18\x04 \x01(\v2\x0f.pb.ExportCacheR\vexportCache\x12,\n" +
	"\x04caps\x18\x05 \x03(\v2\x18.pb.OpMetadata.CapsEntryR\x04caps\x128\n" +
	"\x0eprogress_group\x18\x06 \x01(\v2\x11.pb.ProgressGroupR\rprogressGroup\x1a>\n" +
	"\x10DescriptionEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a7\n" +
	"\tCapsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\bR\x05value:\x028\x01\"\xb4\x01\n" +
	"\x06Source\x127\n" +
	"\tlocations\x18\x01 \x03(\v2\x19.pb.Source.LocationsEntryR\tlocations\x12$\n" +
	"\x05infos\x18\x02 \x03(\v2\x0e.pb.SourceInfoR\x05infos\x1aK\n" +
	"\x0eLocationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12#\n" +
	"\x05value\x18\x02 \x01(\v2\r.pb.LocationsR\x05value:\x028\x01\"7\n" +
	"\tLocations\x12*\n" +
	"\tlocations\x18\x01 \x03(\v2\f.pb.LocationR\tlocations\"\x88\x01\n" +
	"\n" +
	"SourceInfo\x12\x1a\n" +
	"\bfilename\x18\x01 \x01(\tR\bfilename\x12\x12\n" +
	"\x04data\x18\x02 \x01(\fR\x04data\x12.\n" +
	"\n" +
	"definition\x18\x03 \x01(\v2\x0e.pb.DefinitionR\n" +
	"definition\x12\x1a\n" +
	"\blanguage\x18\x04 \x01(\tR\blanguage\"O\n" +
	"\bLocation\x12 \n" +
	"\vsourceIndex\x18\x01 \x01(\x05R\vsourceIndex\x12!\n" +
	"\x06ranges\x18\x02 \x03(\v2\t.pb.RangeR\x06ranges\"K\n" +
	"\x05Range\x12\"\n" +
	"\x05start\x18\x01 \x01(\v2\f.pb.PositionR\x05start\x12\x1e\n" +
	"\x03end\x18\x02 \x01(\v2\f.pb.PositionR\x03end\"<\n" +
	"\bPosition\x12\x12\n" +
	"\x04line\x18\x01 \x01(\x05R\x04line\x12\x1c\n" +
	"\tcharacter\x18\x02 \x01(\x05R\tcharacter\"#\n" +
	"\vExportCache\x12\x14\n" +
	"\x05Value\x18\x01 \x01(\bR\x05Value\"G\n" +
	"\rProgressGroup\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x12\n" +
	"\x04weak\x18\x03 \x01(\bR\x04weak\"\x9f\x01\n" +
	"\bProxyEnv\x12\x1d\n" +
	"\n" +
	"http_proxy\x18\x01 \x01(\tR\thttpProxy\x12\x1f\n" +
	"\vhttps_proxy\x18\x02 \x01(\tR\n" +
	"httpsProxy\x12\x1b\n" +
	"\tftp_proxy\x18\x03 \x01(\tR\bftpProxy\x12\x19\n" +
	"\bno_proxy\x18\x04 \x01(\tR\anoProxy\x12\x1b\n" +
	"\tall_proxy\x18\x05 \x01(\tR\ballProxy\"+\n" +
	"\x11WorkerConstraints\x12\x16\n" +
	"\x06filter\x18\x01 \x03(\tR\x06filter\"\xc9\x01\n" +
	"\n" +
	"Definition\x12\x10\n" +
	"\x03def\x18\x01 \x03(\fR\x03def\x128\n" +
	"\bmetadata\x18\x02 \x03(\v2\x1c.pb.Definition.MetadataEntryR\bmetadata\x12\"\n" +
	"\x06Source\x18\x03 \x01(\v2\n" +
	".pb.SourceR\x06Source\x1aK\n" +
	"\rMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12$\n" +
	"\x05value\x18\x02 \x01(\v2\x0e.pb.OpMetadataR\x05value:\x028\x01\"2\n" +
	"\x06FileOp\x12(\n" +
	"\aactions\x18\x02 \x03(\v2\x0e.pb.FileActionR\aactions\"\xca\x02\n" +
	"\n" +
	"FileAction\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\x12&\n" +
	"\x0esecondaryInput\x18\x02 \x01(\x03R\x0esecondaryInput\x12\x16\n" +
	"\x06output\x18\x03 \x01(\x03R\x06output\x12(\n" +
	"\x04copy\x18\x04 \x01(\v2\x12.pb.FileActionCopyH\x00R\x04copy\x12.\n" +
	"\x06mkfile\x18\x05 \x01(\v2\x14.pb.FileActionMkFileH\x00R\x06mkfile\x12+\n" +
	"\x05mkdir\x18\x06 \x01(\v2\x13.pb.FileActionMkDirH\x00R\x05mkdir\x12\"\n" +
	"\x02rm\x18\a \x01(\v2\x10.pb.FileActionRmH\x00R\x02rm\x121\n" +
	"\asymlink\x18\b \x01(\v2\x15.pb.FileActionSymlinkH\x00R\asymlinkB\b\n" +
	"\x06action\"\xde\x04\n" +
	"\x0eFileActionCopy\x12\x10\n" +
	"\x03src\x18\x01 \x01(\tR\x03src\x12\x12\n" +
	"\x04dest\x18\x02 \x01(\tR\x04dest\x12\"\n" +
	"\x05owner\x18\x03 \x01(\v2\f.pb.ChownOptR\x05owner\x12\x12\n" +
	"\x04mode\x18\x04 \x01(\x05R\x04mode\x12$\n" +
	"\rfollowSymlink\x18\x05 \x01(\bR\rfollowSymlink\x12(\n" +
	"\x0fdirCopyContents\x18\x06 \x01(\bR\x0fdirCopyContents\x12J\n" +
	" attemptUnpackDockerCompatibility\x18\a \x01(\bR attemptUnpackDockerCompatibility\x12&\n" +
	"\x0ecreateDestPath\x18\b \x01(\bR\x0ecreateDestPath\x12$\n" +
	"\rallowWildcard\x18\t \x01(\bR\rallowWildcard\x12.\n" +
	"\x12allowEmptyWildcard\x18\n" +
	" \x01(\bR\x12allowEmptyWildcard\x12\x1c\n" +
	"\ttimestamp\x18\v \x01(\x03R\ttimestamp\x12)\n" +
	"\x10include_patterns\x18\f \x03(\tR\x0fincludePatterns\x12)\n" +
	"\x10exclude_patterns\x18\r \x03(\tR\x0fexcludePatterns\x12F\n" +
	"\x1ealwaysReplaceExistingDestPaths\x18\x0e \x01(\bR\x1ealwaysReplaceExistingDestPaths\x12\x18\n" +
	"\amodeStr\x18\x0f \x01(\tR\amodeStr\"\x90\x01\n" +
	"\x10FileActionMkFile\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x12\n" +
	"\x04mode\x18\x02 \x01(\x05R\x04mode\x12\x12\n" +
	"\x04data\x18\x03 \x01(\fR\x04data\x12\"\n" +
	"\x05owner\x18\x04 \x01(\v2\f.pb.ChownOptR\x05owner\x12\x1c\n" +
	"\ttimestamp\x18\x05 \x01(\x03R\ttimestamp\"\x89\x01\n" +
	"\x11FileActionSymlink\x12\x18\n" +
	"\aoldpath\x18\x01 \x01(\tR\aoldpath\x12\x18\n" +
	"\anewpath\x18\x02 \x01(\tR\anewpath\x12\"\n" +
	"\x05owner\x18\x03 \x01(\v2\f.pb.ChownOptR\x05owner\x12\x1c\n" +
	"\ttimestamp\x18\x04 \x01(\x03R\ttimestamp\"\x9d\x01\n" +
	"\x0fFileActionMkDir\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x12\n" +
	"\x04mode\x18\x02 \x01(\x05R\x04mode\x12 \n" +
	"\vmakeParents\x18\x03 \x01(\bR\vmakeParents\x12\"\n" +
	"\x05owner\x18\x04 \x01(\v2\f.pb.ChownOptR\x05owner\x12\x1c\n" +
	"\ttimestamp\x18\x05 \x01(\x03R\ttimestamp\"n\n" +
	"\fFileActionRm\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12$\n" +
	"\rallowNotFound\x18\x02 \x01(\bR\rallowNotFound\x12$\n" +
	"\rallowWildcard\x18\x03 \x01(\bR\rallowWildcard\"N\n" +
	"\bChownOpt\x12\x1f\n" +
	"\x04user\x18\x01 \x01(\v2\v.pb.UserOptR\x04user\x12!\n" +
	"\x05group\x18\x02 \x01(\v2\v.pb.UserOptR\x05group\"S\n" +
	"\aUserOpt\x12*\n" +
	"\x06byName\x18\x01 \x01(\v2\x10.pb.NamedUserOptH\x00R\x06byName\x12\x14\n" +
	"\x04byID\x18\x02 \x01(\rH\x00R\x04byIDB\x06\n" +
	"\x04user\"8\n" +
	"\fNamedUserOpt\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x14\n" +
	"\x05input\x18\x02 \x01(\x03R\x05input\"\"\n" +
	"\n" +
	"MergeInput\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\"1\n" +
	"\aMergeOp\x12&\n" +
	"\x06inputs\x18\x01 \x03(\v2\x0e.pb.MergeInputR\x06inputs\"&\n" +
	"\x0eLowerDiffInput\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\"&\n" +
	"\x0eUpperDiffInput\x12\x14\n" +
	"\x05input\x18\x01 \x01(\x03R\x05input\"\\\n" +
	"\x06DiffOp\x12(\n" +
	"\x05lower\x18\x01 \x01(\v2\x12.pb.LowerDiffInputR\x05lower\x12(\n" +
	"\x05upper\x18\x02 \x01(\v2\x12.pb.UpperDiffInputR\x05upper*(\n" +
	"\aNetMode\x12\t\n" +
	"\x05UNSET\x10\x00\x12\b\n" +
	"\x04HOST\x10\x01\x12\b\n" +
	"\x04NONE\x10\x02*)\n" +
	"\fSecurityMode\x12\v\n" +
	"\aSANDBOX\x10\x00\x12\f\n" +
	"\bINSECURE\x10\x01*@\n" +
	"\tMountType\x12\b\n" +
	"\x04BIND\x10\x00\x12\n" +
	"\n" +
	"\x06SECRET\x10\x01\x12\a\n" +
	"\x03SSH\x10\x02\x12\t\n" +
	"\x05CACHE\x10\x03\x12\t\n" +
	"\x05TMPFS\x10\x04*1\n" +
	"\x11MountContentCache\x12\v\n" +
	"\aDEFAULT\x10\x00\x12\x06\n" +
	"\x02ON\x10\x01\x12\a\n" +
	"\x03OFF\x10\x02*6\n" +
	"\x0fCacheSharingOpt\x12\n" +
	"\n" +
	"\x06SHARED\x10\x00\x12\v\n" +
	"\aPRIVATE\x10\x01\x12\n" +
	"\n" +
	"\x06LOCKED\x10\x02B$Z\"github.com/moby/buildkit/solver/pbb\x06proto3"

var (
	file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescOnce sync.Once
	file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescData []byte
)

func file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescGZIP() []byte {
	file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescOnce.Do(func() {
		file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_github_com_moby_buildkit_solver_pb_ops_proto_rawDesc), len(file_github_com_moby_buildkit_solver_pb_ops_proto_rawDesc)))
	})
	return file_github_com_moby_buildkit_solver_pb_ops_proto_rawDescData
}

var file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_github_com_moby_buildkit_solver_pb_ops_proto_goTypes = []any{
	(NetMode)(0),              // 0: pb.NetMode
	(SecurityMode)(0),         // 1: pb.SecurityMode
	(MountType)(0),            // 2: pb.MountType
	(MountContentCache)(0),    // 3: pb.MountContentCache
	(CacheSharingOpt)(0),      // 4: pb.CacheSharingOpt
	(*Op)(nil),                // 5: pb.Op
	(*Platform)(nil),          // 6: pb.Platform
	(*Input)(nil),             // 7: pb.Input
	(*ExecOp)(nil),            // 8: pb.ExecOp
	(*Meta)(nil),              // 9: pb.Meta
	(*HostIP)(nil),            // 10: pb.HostIP
	(*Ulimit)(nil),            // 11: pb.Ulimit
	(*SecretEnv)(nil),         // 12: pb.SecretEnv
	(*CDIDevice)(nil),         // 13: pb.CDIDevice
	(*Mount)(nil),             // 14: pb.Mount
	(*TmpfsOpt)(nil),          // 15: pb.TmpfsOpt
	(*CacheOpt)(nil),          // 16: pb.CacheOpt
	(*SecretOpt)(nil),         // 17: pb.SecretOpt
	(*SSHOpt)(nil),            // 18: pb.SSHOpt
	(*SourceOp)(nil),          // 19: pb.SourceOp
	(*BuildOp)(nil),           // 20: pb.BuildOp
	(*BuildInput)(nil),        // 21: pb.BuildInput
	(*OpMetadata)(nil),        // 22: pb.OpMetadata
	(*Source)(nil),            // 23: pb.Source
	(*Locations)(nil),         // 24: pb.Locations
	(*SourceInfo)(nil),        // 25: pb.SourceInfo
	(*Location)(nil),          // 26: pb.Location
	(*Range)(nil),             // 27: pb.Range
	(*Position)(nil),          // 28: pb.Position
	(*ExportCache)(nil),       // 29: pb.ExportCache
	(*ProgressGroup)(nil),     // 30: pb.ProgressGroup
	(*ProxyEnv)(nil),          // 31: pb.ProxyEnv
	(*WorkerConstraints)(nil), // 32: pb.WorkerConstraints
	(*Definition)(nil),        // 33: pb.Definition
	(*FileOp)(nil),            // 34: pb.FileOp
	(*FileAction)(nil),        // 35: pb.FileAction
	(*FileActionCopy)(nil),    // 36: pb.FileActionCopy
	(*FileActionMkFile)(nil),  // 37: pb.FileActionMkFile
	(*FileActionSymlink)(nil), // 38: pb.FileActionSymlink
	(*FileActionMkDir)(nil),   // 39: pb.FileActionMkDir
	(*FileActionRm)(nil),      // 40: pb.FileActionRm
	(*ChownOpt)(nil),          // 41: pb.ChownOpt
	(*UserOpt)(nil),           // 42: pb.UserOpt
	(*NamedUserOpt)(nil),      // 43: pb.NamedUserOpt
	(*MergeInput)(nil),        // 44: pb.MergeInput
	(*MergeOp)(nil),           // 45: pb.MergeOp
	(*LowerDiffInput)(nil),    // 46: pb.LowerDiffInput
	(*UpperDiffInput)(nil),    // 47: pb.UpperDiffInput
	(*DiffOp)(nil),            // 48: pb.DiffOp
	nil,                       // 49: pb.SourceOp.AttrsEntry
	nil,                       // 50: pb.BuildOp.InputsEntry
	nil,                       // 51: pb.BuildOp.AttrsEntry
	nil,                       // 52: pb.OpMetadata.DescriptionEntry
	nil,                       // 53: pb.OpMetadata.CapsEntry
	nil,                       // 54: pb.Source.LocationsEntry
	nil,                       // 55: pb.Definition.MetadataEntry
}
var file_github_com_moby_buildkit_solver_pb_ops_proto_depIdxs = []int32{
	7,  // 0: pb.Op.inputs:type_name -> pb.Input
	8,  // 1: pb.Op.exec:type_name -> pb.ExecOp
	19, // 2: pb.Op.source:type_name -> pb.SourceOp
	34, // 3: pb.Op.file:type_name -> pb.FileOp
	20, // 4: pb.Op.build:type_name -> pb.BuildOp
	45, // 5: pb.Op.merge:type_name -> pb.MergeOp
	48, // 6: pb.Op.diff:type_name -> pb.DiffOp
	6,  // 7: pb.Op.platform:type_name -> pb.Platform
	32, // 8: pb.Op.constraints:type_name -> pb.WorkerConstraints
	9,  // 9: pb.ExecOp.meta:type_name -> pb.Meta
	14, // 10: pb.ExecOp.mounts:type_name -> pb.Mount
	0,  // 11: pb.ExecOp.network:type_name -> pb.NetMode
	1,  // 12: pb.ExecOp.security:type_name -> pb.SecurityMode
	12, // 13: pb.ExecOp.secretenv:type_name -> pb.SecretEnv
	13, // 14: pb.ExecOp.cdiDevices:type_name -> pb.CDIDevice
	31, // 15: pb.Meta.proxy_env:type_name -> pb.ProxyEnv
	10, // 16: pb.Meta.extraHosts:type_name -> pb.HostIP
	11, // 17: pb.Meta.ulimit:type_name -> pb.Ulimit
	2,  // 18: pb.Mount.mountType:type_name -> pb.MountType
	15, // 19: pb.Mount.TmpfsOpt:type_name -> pb.TmpfsOpt
	16, // 20: pb.Mount.cacheOpt:type_name -> pb.CacheOpt
	17, // 21: pb.Mount.secretOpt:type_name -> pb.SecretOpt
	18, // 22: pb.Mount.SSHOpt:type_name -> pb.SSHOpt
	3,  // 23: pb.Mount.contentCache:type_name -> pb.MountContentCache
	4,  // 24: pb.CacheOpt.sharing:type_name -> pb.CacheSharingOpt
	49, // 25: pb.SourceOp.attrs:type_name -> pb.SourceOp.AttrsEntry
	50, // 26: pb.BuildOp.inputs:type_name -> pb.BuildOp.InputsEntry
	33, // 27: pb.BuildOp.def:type_name -> pb.Definition
	51, // 28: pb.BuildOp.attrs:type_name -> pb.BuildOp.AttrsEntry
	52, // 29: pb.OpMetadata.description:type_name -> pb.OpMetadata.DescriptionEntry
	29, // 30: pb.OpMetadata.export_cache:type_name -> pb.ExportCache
	53, // 31: pb.OpMetadata.caps:type_name -> pb.OpMetadata.CapsEntry
	30, // 32: pb.OpMetadata.progress_group:type_name -> pb.ProgressGroup
	54, // 33: pb.Source.locations:type_name -> pb.Source.LocationsEntry
	25, // 34: pb.Source.infos:type_name -> pb.SourceInfo
	26, // 35: pb.Locations.locations:type_name -> pb.Location
	33, // 36: pb.SourceInfo.definition:type_name -> pb.Definition
	27, // 37: pb.Location.ranges:type_name -> pb.Range
	28, // 38: pb.Range.start:type_name -> pb.Position
	28, // 39: pb.Range.end:type_name -> pb.Position
	55, // 40: pb.Definition.metadata:type_name -> pb.Definition.MetadataEntry
	23, // 41: pb.Definition.Source:type_name -> pb.Source
	35, // 42: pb.FileOp.actions:type_name -> pb.FileAction
	36, // 43: pb.FileAction.copy:type_name -> pb.FileActionCopy
	37, // 44: pb.FileAction.mkfile:type_name -> pb.FileActionMkFile
	39, // 45: pb.FileAction.mkdir:type_name -> pb.FileActionMkDir
	40, // 46: pb.FileAction.rm:type_name -> pb.FileActionRm
	38, // 47: pb.FileAction.symlink:type_name -> pb.FileActionSymlink
	41, // 48: pb.FileActionCopy.owner:type_name -> pb.ChownOpt
	41, // 49: pb.FileActionMkFile.owner:type_name -> pb.ChownOpt
	41, // 50: pb.FileActionSymlink.owner:type_name -> pb.ChownOpt
	41, // 51: pb.FileActionMkDir.owner:type_name -> pb.ChownOpt
	42, // 52: pb.ChownOpt.user:type_name -> pb.UserOpt
	42, // 53: pb.ChownOpt.group:type_name -> pb.UserOpt
	43, // 54: pb.UserOpt.byName:type_name -> pb.NamedUserOpt
	44, // 55: pb.MergeOp.inputs:type_name -> pb.MergeInput
	46, // 56: pb.DiffOp.lower:type_name -> pb.LowerDiffInput
	47, // 57: pb.DiffOp.upper:type_name -> pb.UpperDiffInput
	21, // 58: pb.BuildOp.InputsEntry.value:type_name -> pb.BuildInput
	24, // 59: pb.Source.LocationsEntry.value:type_name -> pb.Locations
	22, // 60: pb.Definition.MetadataEntry.value:type_name -> pb.OpMetadata
	61, // [61:61] is the sub-list for method output_type
	61, // [61:61] is the sub-list for method input_type
	61, // [61:61] is the sub-list for extension type_name
	61, // [61:61] is the sub-list for extension extendee
	0,  // [0:61] is the sub-list for field type_name
}

func init() { file_github_com_moby_buildkit_solver_pb_ops_proto_init() }
func file_github_com_moby_buildkit_solver_pb_ops_proto_init() {
	if File_github_com_moby_buildkit_solver_pb_ops_proto != nil {
		return
	}
	file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[0].OneofWrappers = []any{
		(*Op_Exec)(nil),
		(*Op_Source)(nil),
		(*Op_File)(nil),
		(*Op_Build)(nil),
		(*Op_Merge)(nil),
		(*Op_Diff)(nil),
	}
	file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[30].OneofWrappers = []any{
		(*FileAction_Copy)(nil),
		(*FileAction_Mkfile)(nil),
		(*FileAction_Mkdir)(nil),
		(*FileAction_Rm)(nil),
		(*FileAction_Symlink)(nil),
	}
	file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes[37].OneofWrappers = []any{
		(*UserOpt_ByName)(nil),
		(*UserOpt_ByID)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_github_com_moby_buildkit_solver_pb_ops_proto_rawDesc), len(file_github_com_moby_buildkit_solver_pb_ops_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_github_com_moby_buildkit_solver_pb_ops_proto_goTypes,
		DependencyIndexes: file_github_com_moby_buildkit_solver_pb_ops_proto_depIdxs,
		EnumInfos:         file_github_com_moby_buildkit_solver_pb_ops_proto_enumTypes,
		MessageInfos:      file_github_com_moby_buildkit_solver_pb_ops_proto_msgTypes,
	}.Build()
	File_github_com_moby_buildkit_solver_pb_ops_proto = out.File
	file_github_com_moby_buildkit_solver_pb_ops_proto_goTypes = nil
	file_github_com_moby_buildkit_solver_pb_ops_proto_depIdxs = nil
}
