// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package recaptchaenterprisepb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_FullMethodName   = "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/CreateAssessment"
	RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_FullMethodName = "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/AnnotateAssessment"
)

// RecaptchaEnterpriseServiceV1Beta1Client is the client API for RecaptchaEnterpriseServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceV1Beta1Client interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
}

type recaptchaEnterpriseServiceV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceV1Beta1Client(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceV1Beta1Client {
	return &recaptchaEnterpriseServiceV1Beta1Client{cc}
}

func (c *recaptchaEnterpriseServiceV1Beta1Client) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceV1Beta1Client) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceV1Beta1Server is the server API for RecaptchaEnterpriseServiceV1Beta1 service.
// All implementations should embed UnimplementedRecaptchaEnterpriseServiceV1Beta1Server
// for forward compatibility
type RecaptchaEnterpriseServiceV1Beta1Server interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
}

// UnimplementedRecaptchaEnterpriseServiceV1Beta1Server should be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceV1Beta1Server struct {
}

func (UnimplementedRecaptchaEnterpriseServiceV1Beta1Server) CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (UnimplementedRecaptchaEnterpriseServiceV1Beta1Server) AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}

// UnsafeRecaptchaEnterpriseServiceV1Beta1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RecaptchaEnterpriseServiceV1Beta1Server will
// result in compilation errors.
type UnsafeRecaptchaEnterpriseServiceV1Beta1Server interface {
	mustEmbedUnimplementedRecaptchaEnterpriseServiceV1Beta1Server()
}

func RegisterRecaptchaEnterpriseServiceV1Beta1Server(s grpc.ServiceRegistrar, srv RecaptchaEnterpriseServiceV1Beta1Server) {
	s.RegisterService(&RecaptchaEnterpriseServiceV1Beta1_ServiceDesc, srv)
}

func _RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RecaptchaEnterpriseServiceV1Beta1_ServiceDesc is the grpc.ServiceDesc for RecaptchaEnterpriseServiceV1Beta1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RecaptchaEnterpriseServiceV1Beta1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1",
	HandlerType: (*RecaptchaEnterpriseServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto",
}
