// Copyright 2025 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: grafeas/v1/risk.proto

package grafeas

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Risk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CISA maintains the authoritative source of vulnerabilities that have been
	// exploited in the wild.
	CisaKev *CISAKnownExploitedVulnerabilities `protobuf:"bytes,1,opt,name=cisa_kev,json=cisaKev,proto3" json:"cisa_kev,omitempty"`
	// The Exploit Prediction Scoring System (EPSS) estimates the likelihood
	// (probability) that a software vulnerability will be exploited in the wild.
	Epss *ExploitPredictionScoringSystem `protobuf:"bytes,2,opt,name=epss,proto3" json:"epss,omitempty"`
}

func (x *Risk) Reset() {
	*x = Risk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_risk_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Risk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Risk) ProtoMessage() {}

func (x *Risk) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_risk_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Risk.ProtoReflect.Descriptor instead.
func (*Risk) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_risk_proto_rawDescGZIP(), []int{0}
}

func (x *Risk) GetCisaKev() *CISAKnownExploitedVulnerabilities {
	if x != nil {
		return x.CisaKev
	}
	return nil
}

func (x *Risk) GetEpss() *ExploitPredictionScoringSystem {
	if x != nil {
		return x.Epss
	}
	return nil
}

type CISAKnownExploitedVulnerabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the vulnerability is known to have been leveraged as part of a
	// ransomware campaign.
	KnownRansomwareCampaignUse string `protobuf:"bytes,1,opt,name=known_ransomware_campaign_use,json=knownRansomwareCampaignUse,proto3" json:"known_ransomware_campaign_use,omitempty"`
}

func (x *CISAKnownExploitedVulnerabilities) Reset() {
	*x = CISAKnownExploitedVulnerabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_risk_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CISAKnownExploitedVulnerabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CISAKnownExploitedVulnerabilities) ProtoMessage() {}

func (x *CISAKnownExploitedVulnerabilities) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_risk_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CISAKnownExploitedVulnerabilities.ProtoReflect.Descriptor instead.
func (*CISAKnownExploitedVulnerabilities) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_risk_proto_rawDescGZIP(), []int{1}
}

func (x *CISAKnownExploitedVulnerabilities) GetKnownRansomwareCampaignUse() string {
	if x != nil {
		return x.KnownRansomwareCampaignUse
	}
	return ""
}

type ExploitPredictionScoringSystem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentile of the current score, the proportion of all scored
	// vulnerabilities with the same or a lower EPSS score
	Percentile float64 `protobuf:"fixed64,1,opt,name=percentile,proto3" json:"percentile,omitempty"`
	// The EPSS score representing the probability [0-1] of exploitation in the
	// wild in the next 30 days
	Score float64 `protobuf:"fixed64,2,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *ExploitPredictionScoringSystem) Reset() {
	*x = ExploitPredictionScoringSystem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_risk_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExploitPredictionScoringSystem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExploitPredictionScoringSystem) ProtoMessage() {}

func (x *ExploitPredictionScoringSystem) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_risk_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExploitPredictionScoringSystem.ProtoReflect.Descriptor instead.
func (*ExploitPredictionScoringSystem) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_risk_proto_rawDescGZIP(), []int{2}
}

func (x *ExploitPredictionScoringSystem) GetPercentile() float64 {
	if x != nil {
		return x.Percentile
	}
	return 0
}

func (x *ExploitPredictionScoringSystem) GetScore() float64 {
	if x != nil {
		return x.Score
	}
	return 0
}

var File_grafeas_v1_risk_proto protoreflect.FileDescriptor

var file_grafeas_v1_risk_proto_rawDesc = []byte{
	0x0a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x69, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x22, 0x90, 0x01, 0x0a, 0x04, 0x52, 0x69, 0x73, 0x6b, 0x12, 0x48, 0x0a, 0x08,
	0x63, 0x69, 0x73, 0x61, 0x5f, 0x6b, 0x65, 0x76, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x49, 0x53, 0x41,
	0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x65, 0x64, 0x56, 0x75,
	0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x07, 0x63,
	0x69, 0x73, 0x61, 0x4b, 0x65, 0x76, 0x12, 0x3e, 0x0a, 0x04, 0x65, 0x70, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x52, 0x04, 0x65, 0x70, 0x73, 0x73, 0x22, 0x66, 0x0a, 0x21, 0x43, 0x49, 0x53, 0x41, 0x4b, 0x6e,
	0x6f, 0x77, 0x6e, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x65, 0x64, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x73, 0x6f, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1a, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x61, 0x6e, 0x73, 0x6f, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x55, 0x73, 0x65, 0x22, 0x56,
	0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x51, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_grafeas_v1_risk_proto_rawDescOnce sync.Once
	file_grafeas_v1_risk_proto_rawDescData = file_grafeas_v1_risk_proto_rawDesc
)

func file_grafeas_v1_risk_proto_rawDescGZIP() []byte {
	file_grafeas_v1_risk_proto_rawDescOnce.Do(func() {
		file_grafeas_v1_risk_proto_rawDescData = protoimpl.X.CompressGZIP(file_grafeas_v1_risk_proto_rawDescData)
	})
	return file_grafeas_v1_risk_proto_rawDescData
}

var file_grafeas_v1_risk_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_grafeas_v1_risk_proto_goTypes = []interface{}{
	(*Risk)(nil), // 0: grafeas.v1.Risk
	(*CISAKnownExploitedVulnerabilities)(nil), // 1: grafeas.v1.CISAKnownExploitedVulnerabilities
	(*ExploitPredictionScoringSystem)(nil),    // 2: grafeas.v1.ExploitPredictionScoringSystem
}
var file_grafeas_v1_risk_proto_depIdxs = []int32{
	1, // 0: grafeas.v1.Risk.cisa_kev:type_name -> grafeas.v1.CISAKnownExploitedVulnerabilities
	2, // 1: grafeas.v1.Risk.epss:type_name -> grafeas.v1.ExploitPredictionScoringSystem
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_grafeas_v1_risk_proto_init() }
func file_grafeas_v1_risk_proto_init() {
	if File_grafeas_v1_risk_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_grafeas_v1_risk_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Risk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_risk_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CISAKnownExploitedVulnerabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_risk_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExploitPredictionScoringSystem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grafeas_v1_risk_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grafeas_v1_risk_proto_goTypes,
		DependencyIndexes: file_grafeas_v1_risk_proto_depIdxs,
		MessageInfos:      file_grafeas_v1_risk_proto_msgTypes,
	}.Build()
	File_grafeas_v1_risk_proto = out.File
	file_grafeas_v1_risk_proto_rawDesc = nil
	file_grafeas_v1_risk_proto_goTypes = nil
	file_grafeas_v1_risk_proto_depIdxs = nil
}
