// Code generated by protoc-gen-volcengine-sdk
// source: VodVCreativeService
// DO NOT EDIT!

package vod

import (
	"encoding/json"
	"fmt"
	"github.com/volcengine/volc-sdk-golang/base"
	"testing"

	"github.com/volcengine/volc-sdk-golang/service/vod"
	"github.com/volcengine/volc-sdk-golang/service/vod/models/request"
)

func Test_AsyncVCreativeTask(t *testing.T) {
	// Create a VOD instance in the specified region.
	// instance := vod.NewInstanceWithRegion("cn-north-1")
	instance := vod.NewInstance()

	// Configure your Access Key ID (AK) and Secret Access Key (SK) in the environment variables or in the local ~/.volc/config file. For detailed instructions, see  https://www.volcengine.com/docs/4/65655.
	// The SDK will automatically fetch the AK and SK from the environment variables or the ~/.volc/config file as needed.
	// During testing, you may use the following code snippet. However, do not store the AK and SK directly in your project code to prevent potential leakage and safeguard the security of all resources associated with your account.
	instance.SetCredential(base.Credentials{
		AccessKeyID:     "your ak",
		SecretAccessKey: "your sk",
	})
	paramObj := map[string]interface{}{
		"input":      "vid://{your vid}",
		"style":      "漫画风",
		"resolution": "720p",
	}
	paramStr, _ := json.Marshal(paramObj)
	query := &request.VodAsyncVCreativeTaskRequest{
		Uploader:     "your Uploader",
		ParamStr:     string(paramStr),
		Scene:        "videostyletrans",
		CallbackArgs: "your CallbackArgs",
	}

	resp, status, err := instance.AsyncVCreativeTask(query)
	fmt.Println(status)
	fmt.Println(err)
	fmt.Println(resp.String())
}

func Test_GetVCreativeTaskResult(t *testing.T) {
	// Create a VOD instance in the specified region.
	// instance := vod.NewInstanceWithRegion("cn-north-1")
	instance := vod.NewInstance()

	// Configure your Access Key ID (AK) and Secret Access Key (SK) in the environment variables or in the local ~/.volc/config file. For detailed instructions, see  https://www.volcengine.com/docs/4/65655.
	// The SDK will automatically fetch the AK and SK from the environment variables or the ~/.volc/config file as needed.
	// During testing, you may use the following code snippet. However, do not store the AK and SK directly in your project code to prevent potential leakage and safeguard the security of all resources associated with your account.
	instance.SetCredential(base.Credentials{
		AccessKeyID:     "your ak",
		SecretAccessKey: "your sk",
	})

	query := &request.VodGetVCreativeTaskResultRequest{
		VCreativeId: "your VCreativeId",
	}

	resp, status, err := instance.GetVCreativeTaskResult(query)
	fmt.Println(status)
	fmt.Println(err)
	fmt.Println(resp.String())
}
