// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/spanner/v1/change_stream.proto

package spannerpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Mod type describes the type of change Spanner applied to the data. For
// example, if the client submits an INSERT_OR_UPDATE request, Spanner will
// perform an insert if there is no existing row and return ModType INSERT.
// Alternatively, if there is an existing row, Spanner will perform an
// update and return ModType UPDATE.
type ChangeStreamRecord_DataChangeRecord_ModType int32

const (
	// Not specified.
	ChangeStreamRecord_DataChangeRecord_MOD_TYPE_UNSPECIFIED ChangeStreamRecord_DataChangeRecord_ModType = 0
	// Indicates data was inserted.
	ChangeStreamRecord_DataChangeRecord_INSERT ChangeStreamRecord_DataChangeRecord_ModType = 10
	// Indicates existing data was updated.
	ChangeStreamRecord_DataChangeRecord_UPDATE ChangeStreamRecord_DataChangeRecord_ModType = 20
	// Indicates existing data was deleted.
	ChangeStreamRecord_DataChangeRecord_DELETE ChangeStreamRecord_DataChangeRecord_ModType = 30
)

// Enum value maps for ChangeStreamRecord_DataChangeRecord_ModType.
var (
	ChangeStreamRecord_DataChangeRecord_ModType_name = map[int32]string{
		0:  "MOD_TYPE_UNSPECIFIED",
		10: "INSERT",
		20: "UPDATE",
		30: "DELETE",
	}
	ChangeStreamRecord_DataChangeRecord_ModType_value = map[string]int32{
		"MOD_TYPE_UNSPECIFIED": 0,
		"INSERT":               10,
		"UPDATE":               20,
		"DELETE":               30,
	}
)

func (x ChangeStreamRecord_DataChangeRecord_ModType) Enum() *ChangeStreamRecord_DataChangeRecord_ModType {
	p := new(ChangeStreamRecord_DataChangeRecord_ModType)
	*p = x
	return p
}

func (x ChangeStreamRecord_DataChangeRecord_ModType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeStreamRecord_DataChangeRecord_ModType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_change_stream_proto_enumTypes[0].Descriptor()
}

func (ChangeStreamRecord_DataChangeRecord_ModType) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_change_stream_proto_enumTypes[0]
}

func (x ChangeStreamRecord_DataChangeRecord_ModType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord_ModType.Descriptor instead.
func (ChangeStreamRecord_DataChangeRecord_ModType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Value capture type describes which values are recorded in the data
// change record.
type ChangeStreamRecord_DataChangeRecord_ValueCaptureType int32

const (
	// Not specified.
	ChangeStreamRecord_DataChangeRecord_VALUE_CAPTURE_TYPE_UNSPECIFIED ChangeStreamRecord_DataChangeRecord_ValueCaptureType = 0
	// Records both old and new values of the modified watched columns.
	ChangeStreamRecord_DataChangeRecord_OLD_AND_NEW_VALUES ChangeStreamRecord_DataChangeRecord_ValueCaptureType = 10
	// Records only new values of the modified watched columns.
	ChangeStreamRecord_DataChangeRecord_NEW_VALUES ChangeStreamRecord_DataChangeRecord_ValueCaptureType = 20
	// Records new values of all watched columns, including modified and
	// unmodified columns.
	ChangeStreamRecord_DataChangeRecord_NEW_ROW ChangeStreamRecord_DataChangeRecord_ValueCaptureType = 30
	// Records the new values of all watched columns, including modified and
	// unmodified columns. Also records the old values of the modified
	// columns.
	ChangeStreamRecord_DataChangeRecord_NEW_ROW_AND_OLD_VALUES ChangeStreamRecord_DataChangeRecord_ValueCaptureType = 40
)

// Enum value maps for ChangeStreamRecord_DataChangeRecord_ValueCaptureType.
var (
	ChangeStreamRecord_DataChangeRecord_ValueCaptureType_name = map[int32]string{
		0:  "VALUE_CAPTURE_TYPE_UNSPECIFIED",
		10: "OLD_AND_NEW_VALUES",
		20: "NEW_VALUES",
		30: "NEW_ROW",
		40: "NEW_ROW_AND_OLD_VALUES",
	}
	ChangeStreamRecord_DataChangeRecord_ValueCaptureType_value = map[string]int32{
		"VALUE_CAPTURE_TYPE_UNSPECIFIED": 0,
		"OLD_AND_NEW_VALUES":             10,
		"NEW_VALUES":                     20,
		"NEW_ROW":                        30,
		"NEW_ROW_AND_OLD_VALUES":         40,
	}
)

func (x ChangeStreamRecord_DataChangeRecord_ValueCaptureType) Enum() *ChangeStreamRecord_DataChangeRecord_ValueCaptureType {
	p := new(ChangeStreamRecord_DataChangeRecord_ValueCaptureType)
	*p = x
	return p
}

func (x ChangeStreamRecord_DataChangeRecord_ValueCaptureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChangeStreamRecord_DataChangeRecord_ValueCaptureType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_v1_change_stream_proto_enumTypes[1].Descriptor()
}

func (ChangeStreamRecord_DataChangeRecord_ValueCaptureType) Type() protoreflect.EnumType {
	return &file_google_spanner_v1_change_stream_proto_enumTypes[1]
}

func (x ChangeStreamRecord_DataChangeRecord_ValueCaptureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord_ValueCaptureType.Descriptor instead.
func (ChangeStreamRecord_DataChangeRecord_ValueCaptureType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0, 1}
}

// Spanner Change Streams enable customers to capture and stream out changes to
// their Spanner databases in real-time. A change stream
// can be created with option partition_mode='IMMUTABLE_KEY_RANGE' or
// partition_mode='MUTABLE_KEY_RANGE'.
//
// This message is only used in Change Streams created with the option
// partition_mode='MUTABLE_KEY_RANGE'. Spanner automatically creates a special
// Table-Valued Function (TVF) along with each Change Streams. The function
// provides access to the change stream's records. The function is named
// READ_<change_stream_name> (where <change_stream_name> is the
// name of the change stream), and it returns a table with only one column
// called ChangeRecord.
type ChangeStreamRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of the change stream subrecords.
	//
	// Types that are assignable to Record:
	//
	//	*ChangeStreamRecord_DataChangeRecord_
	//	*ChangeStreamRecord_HeartbeatRecord_
	//	*ChangeStreamRecord_PartitionStartRecord_
	//	*ChangeStreamRecord_PartitionEndRecord_
	//	*ChangeStreamRecord_PartitionEventRecord_
	Record isChangeStreamRecord_Record `protobuf_oneof:"record"`
}

func (x *ChangeStreamRecord) Reset() {
	*x = ChangeStreamRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord) ProtoMessage() {}

func (x *ChangeStreamRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0}
}

func (m *ChangeStreamRecord) GetRecord() isChangeStreamRecord_Record {
	if m != nil {
		return m.Record
	}
	return nil
}

func (x *ChangeStreamRecord) GetDataChangeRecord() *ChangeStreamRecord_DataChangeRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_DataChangeRecord_); ok {
		return x.DataChangeRecord
	}
	return nil
}

func (x *ChangeStreamRecord) GetHeartbeatRecord() *ChangeStreamRecord_HeartbeatRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_HeartbeatRecord_); ok {
		return x.HeartbeatRecord
	}
	return nil
}

func (x *ChangeStreamRecord) GetPartitionStartRecord() *ChangeStreamRecord_PartitionStartRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_PartitionStartRecord_); ok {
		return x.PartitionStartRecord
	}
	return nil
}

func (x *ChangeStreamRecord) GetPartitionEndRecord() *ChangeStreamRecord_PartitionEndRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_PartitionEndRecord_); ok {
		return x.PartitionEndRecord
	}
	return nil
}

func (x *ChangeStreamRecord) GetPartitionEventRecord() *ChangeStreamRecord_PartitionEventRecord {
	if x, ok := x.GetRecord().(*ChangeStreamRecord_PartitionEventRecord_); ok {
		return x.PartitionEventRecord
	}
	return nil
}

type isChangeStreamRecord_Record interface {
	isChangeStreamRecord_Record()
}

type ChangeStreamRecord_DataChangeRecord_ struct {
	// Data change record describing a data change for a change stream
	// partition.
	DataChangeRecord *ChangeStreamRecord_DataChangeRecord `protobuf:"bytes,1,opt,name=data_change_record,json=dataChangeRecord,proto3,oneof"`
}

type ChangeStreamRecord_HeartbeatRecord_ struct {
	// Heartbeat record describing a heartbeat for a change stream partition.
	HeartbeatRecord *ChangeStreamRecord_HeartbeatRecord `protobuf:"bytes,2,opt,name=heartbeat_record,json=heartbeatRecord,proto3,oneof"`
}

type ChangeStreamRecord_PartitionStartRecord_ struct {
	// Partition start record describing a new change stream partition.
	PartitionStartRecord *ChangeStreamRecord_PartitionStartRecord `protobuf:"bytes,3,opt,name=partition_start_record,json=partitionStartRecord,proto3,oneof"`
}

type ChangeStreamRecord_PartitionEndRecord_ struct {
	// Partition end record describing a terminated change stream partition.
	PartitionEndRecord *ChangeStreamRecord_PartitionEndRecord `protobuf:"bytes,4,opt,name=partition_end_record,json=partitionEndRecord,proto3,oneof"`
}

type ChangeStreamRecord_PartitionEventRecord_ struct {
	// Partition event record describing key range changes for a change stream
	// partition.
	PartitionEventRecord *ChangeStreamRecord_PartitionEventRecord `protobuf:"bytes,5,opt,name=partition_event_record,json=partitionEventRecord,proto3,oneof"`
}

func (*ChangeStreamRecord_DataChangeRecord_) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_HeartbeatRecord_) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_PartitionStartRecord_) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_PartitionEndRecord_) isChangeStreamRecord_Record() {}

func (*ChangeStreamRecord_PartitionEventRecord_) isChangeStreamRecord_Record() {}

// A data change record contains a set of changes to a table with the same
// modification type (insert, update, or delete) committed at the same commit
// timestamp in one change stream partition for the same transaction. Multiple
// data change records can be returned for the same transaction across
// multiple change stream partitions.
type ChangeStreamRecord_DataChangeRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the timestamp in which the change was committed.
	// DataChangeRecord.commit_timestamps,
	// PartitionStartRecord.start_timestamps,
	// PartitionEventRecord.commit_timestamps, and
	// PartitionEndRecord.end_timestamps can have the same value in the same
	// partition.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
	// Record sequence numbers are unique and monotonically increasing (but not
	// necessarily contiguous) for a specific timestamp across record
	// types in the same partition. To guarantee ordered processing, the reader
	// should process records (of potentially different types) in
	// record_sequence order for a specific timestamp in the same partition.
	//
	// The record sequence number ordering across partitions is only meaningful
	// in the context of a specific transaction. Record sequence numbers are
	// unique across partitions for a specific transaction. Sort the
	// DataChangeRecords for the same
	// [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
	// by
	// [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
	// to reconstruct the ordering of the changes within the transaction.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// Provides a globally unique string that represents the transaction in
	// which the change was committed. Multiple transactions can have the same
	// commit timestamp, but each transaction has a unique
	// server_transaction_id.
	ServerTransactionId string `protobuf:"bytes,3,opt,name=server_transaction_id,json=serverTransactionId,proto3" json:"server_transaction_id,omitempty"`
	// Indicates whether this is the last record for a transaction in the
	//
	//	current partition. Clients can use this field to determine when all
	//	records for a transaction in the current partition have been received.
	IsLastRecordInTransactionInPartition bool `protobuf:"varint,4,opt,name=is_last_record_in_transaction_in_partition,json=isLastRecordInTransactionInPartition,proto3" json:"is_last_record_in_transaction_in_partition,omitempty"`
	// Name of the table affected by the change.
	Table string `protobuf:"bytes,5,opt,name=table,proto3" json:"table,omitempty"`
	// Provides metadata describing the columns associated with the
	// [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
	// below.
	ColumnMetadata []*ChangeStreamRecord_DataChangeRecord_ColumnMetadata `protobuf:"bytes,6,rep,name=column_metadata,json=columnMetadata,proto3" json:"column_metadata,omitempty"`
	// Describes the changes that were made.
	Mods []*ChangeStreamRecord_DataChangeRecord_Mod `protobuf:"bytes,7,rep,name=mods,proto3" json:"mods,omitempty"`
	// Describes the type of change.
	ModType ChangeStreamRecord_DataChangeRecord_ModType `protobuf:"varint,8,opt,name=mod_type,json=modType,proto3,enum=google.spanner.v1.ChangeStreamRecord_DataChangeRecord_ModType" json:"mod_type,omitempty"`
	// Describes the value capture type that was specified in the change stream
	// configuration when this change was captured.
	ValueCaptureType ChangeStreamRecord_DataChangeRecord_ValueCaptureType `protobuf:"varint,9,opt,name=value_capture_type,json=valueCaptureType,proto3,enum=google.spanner.v1.ChangeStreamRecord_DataChangeRecord_ValueCaptureType" json:"value_capture_type,omitempty"`
	// Indicates the number of data change records that are part of this
	// transaction across all change stream partitions. This value can be used
	// to assemble all the records associated with a particular transaction.
	NumberOfRecordsInTransaction int32 `protobuf:"varint,10,opt,name=number_of_records_in_transaction,json=numberOfRecordsInTransaction,proto3" json:"number_of_records_in_transaction,omitempty"`
	// Indicates the number of partitions that return data change records for
	// this transaction. This value can be helpful in assembling all records
	// associated with a particular transaction.
	NumberOfPartitionsInTransaction int32 `protobuf:"varint,11,opt,name=number_of_partitions_in_transaction,json=numberOfPartitionsInTransaction,proto3" json:"number_of_partitions_in_transaction,omitempty"`
	// Indicates the transaction tag associated with this transaction.
	TransactionTag string `protobuf:"bytes,12,opt,name=transaction_tag,json=transactionTag,proto3" json:"transaction_tag,omitempty"`
	// Indicates whether the transaction is a system transaction. System
	// transactions include those issued by time-to-live (TTL), column backfill,
	// etc.
	IsSystemTransaction bool `protobuf:"varint,13,opt,name=is_system_transaction,json=isSystemTransaction,proto3" json:"is_system_transaction,omitempty"`
}

func (x *ChangeStreamRecord_DataChangeRecord) Reset() {
	*x = ChangeStreamRecord_DataChangeRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_DataChangeRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_DataChangeRecord) ProtoMessage() {}

func (x *ChangeStreamRecord_DataChangeRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_DataChangeRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ChangeStreamRecord_DataChangeRecord) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *ChangeStreamRecord_DataChangeRecord) GetServerTransactionId() string {
	if x != nil {
		return x.ServerTransactionId
	}
	return ""
}

func (x *ChangeStreamRecord_DataChangeRecord) GetIsLastRecordInTransactionInPartition() bool {
	if x != nil {
		return x.IsLastRecordInTransactionInPartition
	}
	return false
}

func (x *ChangeStreamRecord_DataChangeRecord) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ChangeStreamRecord_DataChangeRecord) GetColumnMetadata() []*ChangeStreamRecord_DataChangeRecord_ColumnMetadata {
	if x != nil {
		return x.ColumnMetadata
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord) GetMods() []*ChangeStreamRecord_DataChangeRecord_Mod {
	if x != nil {
		return x.Mods
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord) GetModType() ChangeStreamRecord_DataChangeRecord_ModType {
	if x != nil {
		return x.ModType
	}
	return ChangeStreamRecord_DataChangeRecord_MOD_TYPE_UNSPECIFIED
}

func (x *ChangeStreamRecord_DataChangeRecord) GetValueCaptureType() ChangeStreamRecord_DataChangeRecord_ValueCaptureType {
	if x != nil {
		return x.ValueCaptureType
	}
	return ChangeStreamRecord_DataChangeRecord_VALUE_CAPTURE_TYPE_UNSPECIFIED
}

func (x *ChangeStreamRecord_DataChangeRecord) GetNumberOfRecordsInTransaction() int32 {
	if x != nil {
		return x.NumberOfRecordsInTransaction
	}
	return 0
}

func (x *ChangeStreamRecord_DataChangeRecord) GetNumberOfPartitionsInTransaction() int32 {
	if x != nil {
		return x.NumberOfPartitionsInTransaction
	}
	return 0
}

func (x *ChangeStreamRecord_DataChangeRecord) GetTransactionTag() string {
	if x != nil {
		return x.TransactionTag
	}
	return ""
}

func (x *ChangeStreamRecord_DataChangeRecord) GetIsSystemTransaction() bool {
	if x != nil {
		return x.IsSystemTransaction
	}
	return false
}

// A heartbeat record is returned as a progress indicator, when there are no
// data changes or any other partition record types in the change stream
// partition.
type ChangeStreamRecord_HeartbeatRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the timestamp at which the query has returned all the records
	// in the change stream partition with timestamp <= heartbeat timestamp.
	// The heartbeat timestamp will not be the same as the timestamps of other
	// record types in the same partition.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *ChangeStreamRecord_HeartbeatRecord) Reset() {
	*x = ChangeStreamRecord_HeartbeatRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_HeartbeatRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_HeartbeatRecord) ProtoMessage() {}

func (x *ChangeStreamRecord_HeartbeatRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_HeartbeatRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_HeartbeatRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ChangeStreamRecord_HeartbeatRecord) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// A partition start record serves as a notification that the client should
// schedule the partitions to be queried. PartitionStartRecord returns
// information about one or more partitions.
type ChangeStreamRecord_PartitionStartRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start timestamp at which the partitions should be queried to return
	// change stream records with timestamps >= start_timestamp.
	// DataChangeRecord.commit_timestamps,
	// PartitionStartRecord.start_timestamps,
	// PartitionEventRecord.commit_timestamps, and
	// PartitionEndRecord.end_timestamps can have the same value in the same
	// partition.
	StartTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	// Record sequence numbers are unique and monotonically increasing (but not
	// necessarily contiguous) for a specific timestamp across record
	// types in the same partition. To guarantee ordered processing, the reader
	// should process records (of potentially different types) in
	// record_sequence order for a specific timestamp in the same partition.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// Unique partition identifiers to be used in queries.
	PartitionTokens []string `protobuf:"bytes,3,rep,name=partition_tokens,json=partitionTokens,proto3" json:"partition_tokens,omitempty"`
}

func (x *ChangeStreamRecord_PartitionStartRecord) Reset() {
	*x = ChangeStreamRecord_PartitionStartRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_PartitionStartRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_PartitionStartRecord) ProtoMessage() {}

func (x *ChangeStreamRecord_PartitionStartRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_PartitionStartRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_PartitionStartRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ChangeStreamRecord_PartitionStartRecord) GetStartTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTimestamp
	}
	return nil
}

func (x *ChangeStreamRecord_PartitionStartRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *ChangeStreamRecord_PartitionStartRecord) GetPartitionTokens() []string {
	if x != nil {
		return x.PartitionTokens
	}
	return nil
}

// A partition end record serves as a notification that the client should stop
// reading the partition. No further records are expected to be retrieved on
// it.
type ChangeStreamRecord_PartitionEndRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// End timestamp at which the change stream partition is terminated. All
	// changes generated by this partition will have timestamps <=
	// end_timestamp. DataChangeRecord.commit_timestamps,
	// PartitionStartRecord.start_timestamps,
	// PartitionEventRecord.commit_timestamps, and
	// PartitionEndRecord.end_timestamps can have the same value in the same
	// partition. PartitionEndRecord is the last record returned for a
	// partition.
	EndTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=end_timestamp,json=endTimestamp,proto3" json:"end_timestamp,omitempty"`
	// Record sequence numbers are unique and monotonically increasing (but not
	// necessarily contiguous) for a specific timestamp across record
	// types in the same partition. To guarantee ordered processing, the reader
	// should process records (of potentially different types) in
	// record_sequence order for a specific timestamp in the same partition.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// Unique partition identifier describing the terminated change stream
	// partition.
	// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
	// is equal to the partition token of the change stream partition currently
	// queried to return this PartitionEndRecord.
	PartitionToken string `protobuf:"bytes,3,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
}

func (x *ChangeStreamRecord_PartitionEndRecord) Reset() {
	*x = ChangeStreamRecord_PartitionEndRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_PartitionEndRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_PartitionEndRecord) ProtoMessage() {}

func (x *ChangeStreamRecord_PartitionEndRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_PartitionEndRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_PartitionEndRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 3}
}

func (x *ChangeStreamRecord_PartitionEndRecord) GetEndTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTimestamp
	}
	return nil
}

func (x *ChangeStreamRecord_PartitionEndRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *ChangeStreamRecord_PartitionEndRecord) GetPartitionToken() string {
	if x != nil {
		return x.PartitionToken
	}
	return ""
}

// A partition event record describes key range changes for a change stream
// partition. The changes to a row defined by its primary key can be captured
// in one change stream partition for a specific time range, and then be
// captured in a different change stream partition for a different time range.
// This movement of key ranges across change stream partitions is a reflection
// of activities, such as Spanner's dynamic splitting and load balancing, etc.
// Processing this event is needed if users want to guarantee processing of
// the changes for any key in timestamp order. If time ordered processing of
// changes for a primary key is not needed, this event can be ignored.
// To guarantee time ordered processing for each primary key, if the event
// describes move-ins, the reader of this partition needs to wait until the
// readers of the source partitions have processed all records with timestamps
// <= this PartitionEventRecord.commit_timestamp, before advancing beyond this
// PartitionEventRecord. If the event describes move-outs, the reader can
// notify the readers of the destination partitions that they can continue
// processing.
type ChangeStreamRecord_PartitionEventRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the commit timestamp at which the key range change occurred.
	// DataChangeRecord.commit_timestamps,
	// PartitionStartRecord.start_timestamps,
	// PartitionEventRecord.commit_timestamps, and
	// PartitionEndRecord.end_timestamps can have the same value in the same
	// partition.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
	// Record sequence numbers are unique and monotonically increasing (but not
	// necessarily contiguous) for a specific timestamp across record
	// types in the same partition. To guarantee ordered processing, the reader
	// should process records (of potentially different types) in
	// record_sequence order for a specific timestamp in the same partition.
	RecordSequence string `protobuf:"bytes,2,opt,name=record_sequence,json=recordSequence,proto3" json:"record_sequence,omitempty"`
	// Unique partition identifier describing the partition this event
	// occurred on.
	// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
	// is equal to the partition token of the change stream partition currently
	// queried to return this PartitionEventRecord.
	PartitionToken string `protobuf:"bytes,3,opt,name=partition_token,json=partitionToken,proto3" json:"partition_token,omitempty"`
	// Set when one or more key ranges are moved into the change stream
	// partition identified by
	// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
	//
	// Example: Two key ranges are moved into partition (P1) from partition (P2)
	// and partition (P3) in a single transaction at timestamp T.
	//
	// The PartitionEventRecord returned in P1 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P1"
	//	  move_in_events {
	//	    source_partition_token: "P2"
	//	  }
	//	  move_in_events {
	//	    source_partition_token: "P3"
	//	  }
	//	}
	//
	// The PartitionEventRecord returned in P2 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P2"
	//	  move_out_events {
	//	    destination_partition_token: "P1"
	//	  }
	//	}
	//
	// The PartitionEventRecord returned in P3 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P3"
	//	  move_out_events {
	//	    destination_partition_token: "P1"
	//	  }
	//	}
	MoveInEvents []*ChangeStreamRecord_PartitionEventRecord_MoveInEvent `protobuf:"bytes,4,rep,name=move_in_events,json=moveInEvents,proto3" json:"move_in_events,omitempty"`
	// Set when one or more key ranges are moved out of the change stream
	// partition identified by
	// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
	//
	// Example: Two key ranges are moved out of partition (P1) to partition (P2)
	// and partition (P3) in a single transaction at timestamp T.
	//
	// The PartitionEventRecord returned in P1 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P1"
	//	  move_out_events {
	//	    destination_partition_token: "P2"
	//	  }
	//	  move_out_events {
	//	    destination_partition_token: "P3"
	//	  }
	//	}
	//
	// The PartitionEventRecord returned in P2 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P2"
	//	  move_in_events {
	//	    source_partition_token: "P1"
	//	  }
	//	}
	//
	// The PartitionEventRecord returned in P3 will reflect the move as:
	//
	//	PartitionEventRecord {
	//	  commit_timestamp: T
	//	  partition_token: "P3"
	//	  move_in_events {
	//	    source_partition_token: "P1"
	//	  }
	//	}
	MoveOutEvents []*ChangeStreamRecord_PartitionEventRecord_MoveOutEvent `protobuf:"bytes,5,rep,name=move_out_events,json=moveOutEvents,proto3" json:"move_out_events,omitempty"`
}

func (x *ChangeStreamRecord_PartitionEventRecord) Reset() {
	*x = ChangeStreamRecord_PartitionEventRecord{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_PartitionEventRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_PartitionEventRecord) ProtoMessage() {}

func (x *ChangeStreamRecord_PartitionEventRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_PartitionEventRecord.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_PartitionEventRecord) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 4}
}

func (x *ChangeStreamRecord_PartitionEventRecord) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

func (x *ChangeStreamRecord_PartitionEventRecord) GetRecordSequence() string {
	if x != nil {
		return x.RecordSequence
	}
	return ""
}

func (x *ChangeStreamRecord_PartitionEventRecord) GetPartitionToken() string {
	if x != nil {
		return x.PartitionToken
	}
	return ""
}

func (x *ChangeStreamRecord_PartitionEventRecord) GetMoveInEvents() []*ChangeStreamRecord_PartitionEventRecord_MoveInEvent {
	if x != nil {
		return x.MoveInEvents
	}
	return nil
}

func (x *ChangeStreamRecord_PartitionEventRecord) GetMoveOutEvents() []*ChangeStreamRecord_PartitionEventRecord_MoveOutEvent {
	if x != nil {
		return x.MoveOutEvents
	}
	return nil
}

// Metadata for a column.
type ChangeStreamRecord_DataChangeRecord_ColumnMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the column.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the column.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Indicates whether the column is a primary key column.
	IsPrimaryKey bool `protobuf:"varint,3,opt,name=is_primary_key,json=isPrimaryKey,proto3" json:"is_primary_key,omitempty"`
	// Ordinal position of the column based on the original table definition
	// in the schema starting with a value of 1.
	OrdinalPosition int64 `protobuf:"varint,4,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) Reset() {
	*x = ChangeStreamRecord_DataChangeRecord_ColumnMetadata{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_DataChangeRecord_ColumnMetadata) ProtoMessage() {}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord_ColumnMetadata.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_DataChangeRecord_ColumnMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) GetIsPrimaryKey() bool {
	if x != nil {
		return x.IsPrimaryKey
	}
	return false
}

func (x *ChangeStreamRecord_DataChangeRecord_ColumnMetadata) GetOrdinalPosition() int64 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// Returns the value and associated metadata for a particular field of the
// [Mod][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod].
type ChangeStreamRecord_DataChangeRecord_ModValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index within the repeated
	// [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
	// field, to obtain the column metadata for the column that was modified.
	ColumnMetadataIndex int32 `protobuf:"varint,1,opt,name=column_metadata_index,json=columnMetadataIndex,proto3" json:"column_metadata_index,omitempty"`
	// The value of the column.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ChangeStreamRecord_DataChangeRecord_ModValue) Reset() {
	*x = ChangeStreamRecord_DataChangeRecord_ModValue{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_DataChangeRecord_ModValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_DataChangeRecord_ModValue) ProtoMessage() {}

func (x *ChangeStreamRecord_DataChangeRecord_ModValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord_ModValue.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_DataChangeRecord_ModValue) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *ChangeStreamRecord_DataChangeRecord_ModValue) GetColumnMetadataIndex() int32 {
	if x != nil {
		return x.ColumnMetadataIndex
	}
	return 0
}

func (x *ChangeStreamRecord_DataChangeRecord_ModValue) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

// A mod describes all data changes in a watched table row.
type ChangeStreamRecord_DataChangeRecord_Mod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returns the value of the primary key of the modified row.
	Keys []*ChangeStreamRecord_DataChangeRecord_ModValue `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Returns the old values before the change for the modified columns.
	// Always empty for
	// [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
	// or if old values are not being captured specified by
	// [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
	OldValues []*ChangeStreamRecord_DataChangeRecord_ModValue `protobuf:"bytes,2,rep,name=old_values,json=oldValues,proto3" json:"old_values,omitempty"`
	// Returns the new values after the change for the modified columns.
	// Always empty for
	// [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
	NewValues []*ChangeStreamRecord_DataChangeRecord_ModValue `protobuf:"bytes,3,rep,name=new_values,json=newValues,proto3" json:"new_values,omitempty"`
}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) Reset() {
	*x = ChangeStreamRecord_DataChangeRecord_Mod{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_DataChangeRecord_Mod) ProtoMessage() {}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_DataChangeRecord_Mod.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_DataChangeRecord_Mod) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) GetKeys() []*ChangeStreamRecord_DataChangeRecord_ModValue {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) GetOldValues() []*ChangeStreamRecord_DataChangeRecord_ModValue {
	if x != nil {
		return x.OldValues
	}
	return nil
}

func (x *ChangeStreamRecord_DataChangeRecord_Mod) GetNewValues() []*ChangeStreamRecord_DataChangeRecord_ModValue {
	if x != nil {
		return x.NewValues
	}
	return nil
}

// Describes move-in of the key ranges into the change stream partition
// identified by
// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
//
// To maintain processing the changes for a particular key in timestamp
// order, the query processing the change stream partition identified by
// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
// should not advance beyond the partition event record commit timestamp
// until the queries processing the source change stream partitions have
// processed all change stream records with timestamps <= the partition
// event record commit timestamp.
type ChangeStreamRecord_PartitionEventRecord_MoveInEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique partition identifier describing the source change stream
	// partition that recorded changes for the key range that is moving
	// into this partition.
	SourcePartitionToken string `protobuf:"bytes,1,opt,name=source_partition_token,json=sourcePartitionToken,proto3" json:"source_partition_token,omitempty"`
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveInEvent) Reset() {
	*x = ChangeStreamRecord_PartitionEventRecord_MoveInEvent{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveInEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_PartitionEventRecord_MoveInEvent) ProtoMessage() {}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveInEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_PartitionEventRecord_MoveInEvent.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_PartitionEventRecord_MoveInEvent) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveInEvent) GetSourcePartitionToken() string {
	if x != nil {
		return x.SourcePartitionToken
	}
	return ""
}

// Describes move-out of the key ranges out of the change stream partition
// identified by
// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
//
// To maintain processing the changes for a particular key in timestamp
// order, the query processing the
// [MoveOutEvent][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent]
// in the partition identified by
// [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
// should inform the queries processing the destination partitions that
// they can unblock and proceed processing records past the
// [commit_timestamp][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.commit_timestamp].
type ChangeStreamRecord_PartitionEventRecord_MoveOutEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unique partition identifier describing the destination change
	// stream partition that will record changes for the key range that is
	// moving out of this partition.
	DestinationPartitionToken string `protobuf:"bytes,1,opt,name=destination_partition_token,json=destinationPartitionToken,proto3" json:"destination_partition_token,omitempty"`
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) Reset() {
	*x = ChangeStreamRecord_PartitionEventRecord_MoveOutEvent{}
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) ProtoMessage() {}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_v1_change_stream_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStreamRecord_PartitionEventRecord_MoveOutEvent.ProtoReflect.Descriptor instead.
func (*ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) Descriptor() ([]byte, []int) {
	return file_google_spanner_v1_change_stream_proto_rawDescGZIP(), []int{0, 4, 1}
}

func (x *ChangeStreamRecord_PartitionEventRecord_MoveOutEvent) GetDestinationPartitionToken() string {
	if x != nil {
		return x.DestinationPartitionToken
	}
	return ""
}

var File_google_spanner_v1_change_stream_proto protoreflect.FileDescriptor

var file_google_spanner_v1_change_stream_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x19, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x66,
	0x0a, 0x12, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x48, 0x00, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x62, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62,
	0x65, 0x61, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x68, 0x65, 0x61, 0x72, 0x74,
	0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x72, 0x0a, 0x16, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x6c,
	0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x72, 0x0a, 0x16,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x48, 0x00, 0x52, 0x14, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x1a, 0xae, 0x0d, 0x0a, 0x10, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x45, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x2a, 0x69, 0x73, 0x5f,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x24, 0x69,
	0x73, 0x4c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x6e, 0x0a, 0x0f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x04, 0x6d, 0x6f, 0x64,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e,
	0x4d, 0x6f, 0x64, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x73, 0x12, 0x59, 0x0a, 0x08, 0x6d, 0x6f, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x2e, 0x4d, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6d, 0x6f, 0x64,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x75, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x61,
	0x70, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x61,
	0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x20, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73,
	0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1c, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x23, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x6f, 0x66,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x1f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x73,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x73, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa2,
	0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x50, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x6c, 0x0a, 0x08, 0x4d, 0x6f, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0x9a, 0x02, 0x0a, 0x03, 0x4d, 0x6f, 0x64, 0x12, 0x53, 0x0a, 0x04, 0x6b, 0x65, 0x79,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e,
	0x4d, 0x6f, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x5e,
	0x0a, 0x0a, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x4d, 0x6f, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x09, 0x6f, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5e,
	0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x4d, 0x6f, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x47,
	0x0a, 0x07, 0x4d, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x4f, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x0a, 0x12,
	0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x1e, 0x22, 0x87, 0x01, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x43, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x4f, 0x4c, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4e, 0x45, 0x57, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x45, 0x57, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x10, 0x14, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x57, 0x5f,
	0x52, 0x4f, 0x57, 0x10, 0x1e, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x45, 0x57, 0x5f, 0x52, 0x4f, 0x57,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4f, 0x4c, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x10,
	0x28, 0x1a, 0x4b, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x1a, 0xaf,
	0x01, 0x0a, 0x14, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x1a, 0xa7, 0x01, 0x0a, 0x12, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x64, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x3f, 0x0a, 0x0d, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0xa3, 0x04, 0x0a, 0x14, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x12, 0x45, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6c, 0x0a, 0x0e,
	0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x6d, 0x6f,
	0x76, 0x65, 0x49, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x0f, 0x6d, 0x6f,
	0x76, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e,
	0x4d, 0x6f, 0x76, 0x65, 0x4f, 0x75, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x6d, 0x6f,
	0x76, 0x65, 0x4f, 0x75, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x43, 0x0a, 0x0b, 0x4d,
	0x6f, 0x76, 0x65, 0x49, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x1a, 0x4e, 0x0a, 0x0c, 0x4d, 0x6f, 0x76, 0x65, 0x4f, 0x75, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x3e, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0xb4, 0x01, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_v1_change_stream_proto_rawDescOnce sync.Once
	file_google_spanner_v1_change_stream_proto_rawDescData = file_google_spanner_v1_change_stream_proto_rawDesc
)

func file_google_spanner_v1_change_stream_proto_rawDescGZIP() []byte {
	file_google_spanner_v1_change_stream_proto_rawDescOnce.Do(func() {
		file_google_spanner_v1_change_stream_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_v1_change_stream_proto_rawDescData)
	})
	return file_google_spanner_v1_change_stream_proto_rawDescData
}

var file_google_spanner_v1_change_stream_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_spanner_v1_change_stream_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_spanner_v1_change_stream_proto_goTypes = []any{
	(ChangeStreamRecord_DataChangeRecord_ModType)(0),             // 0: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType
	(ChangeStreamRecord_DataChangeRecord_ValueCaptureType)(0),    // 1: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
	(*ChangeStreamRecord)(nil),                                   // 2: google.spanner.v1.ChangeStreamRecord
	(*ChangeStreamRecord_DataChangeRecord)(nil),                  // 3: google.spanner.v1.ChangeStreamRecord.DataChangeRecord
	(*ChangeStreamRecord_HeartbeatRecord)(nil),                   // 4: google.spanner.v1.ChangeStreamRecord.HeartbeatRecord
	(*ChangeStreamRecord_PartitionStartRecord)(nil),              // 5: google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
	(*ChangeStreamRecord_PartitionEndRecord)(nil),                // 6: google.spanner.v1.ChangeStreamRecord.PartitionEndRecord
	(*ChangeStreamRecord_PartitionEventRecord)(nil),              // 7: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
	(*ChangeStreamRecord_DataChangeRecord_ColumnMetadata)(nil),   // 8: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
	(*ChangeStreamRecord_DataChangeRecord_ModValue)(nil),         // 9: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
	(*ChangeStreamRecord_DataChangeRecord_Mod)(nil),              // 10: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
	(*ChangeStreamRecord_PartitionEventRecord_MoveInEvent)(nil),  // 11: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
	(*ChangeStreamRecord_PartitionEventRecord_MoveOutEvent)(nil), // 12: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
	(*timestamppb.Timestamp)(nil),                                // 13: google.protobuf.Timestamp
	(*Type)(nil),                                                 // 14: google.spanner.v1.Type
	(*structpb.Value)(nil),                                       // 15: google.protobuf.Value
}
var file_google_spanner_v1_change_stream_proto_depIdxs = []int32{
	3,  // 0: google.spanner.v1.ChangeStreamRecord.data_change_record:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord
	4,  // 1: google.spanner.v1.ChangeStreamRecord.heartbeat_record:type_name -> google.spanner.v1.ChangeStreamRecord.HeartbeatRecord
	5,  // 2: google.spanner.v1.ChangeStreamRecord.partition_start_record:type_name -> google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
	6,  // 3: google.spanner.v1.ChangeStreamRecord.partition_end_record:type_name -> google.spanner.v1.ChangeStreamRecord.PartitionEndRecord
	7,  // 4: google.spanner.v1.ChangeStreamRecord.partition_event_record:type_name -> google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
	13, // 5: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.commit_timestamp:type_name -> google.protobuf.Timestamp
	8,  // 6: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
	10, // 7: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
	0,  // 8: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mod_type:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType
	1,  // 9: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.value_capture_type:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
	13, // 10: google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.timestamp:type_name -> google.protobuf.Timestamp
	13, // 11: google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.start_timestamp:type_name -> google.protobuf.Timestamp
	13, // 12: google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.end_timestamp:type_name -> google.protobuf.Timestamp
	13, // 13: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.commit_timestamp:type_name -> google.protobuf.Timestamp
	11, // 14: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.move_in_events:type_name -> google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
	12, // 15: google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.move_out_events:type_name -> google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
	14, // 16: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.type:type_name -> google.spanner.v1.Type
	15, // 17: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.value:type_name -> google.protobuf.Value
	9,  // 18: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.keys:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
	9,  // 19: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.old_values:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
	9,  // 20: google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.new_values:type_name -> google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_spanner_v1_change_stream_proto_init() }
func file_google_spanner_v1_change_stream_proto_init() {
	if File_google_spanner_v1_change_stream_proto != nil {
		return
	}
	file_google_spanner_v1_type_proto_init()
	file_google_spanner_v1_change_stream_proto_msgTypes[0].OneofWrappers = []any{
		(*ChangeStreamRecord_DataChangeRecord_)(nil),
		(*ChangeStreamRecord_HeartbeatRecord_)(nil),
		(*ChangeStreamRecord_PartitionStartRecord_)(nil),
		(*ChangeStreamRecord_PartitionEndRecord_)(nil),
		(*ChangeStreamRecord_PartitionEventRecord_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_v1_change_stream_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_v1_change_stream_proto_goTypes,
		DependencyIndexes: file_google_spanner_v1_change_stream_proto_depIdxs,
		EnumInfos:         file_google_spanner_v1_change_stream_proto_enumTypes,
		MessageInfos:      file_google_spanner_v1_change_stream_proto_msgTypes,
	}.Build()
	File_google_spanner_v1_change_stream_proto = out.File
	file_google_spanner_v1_change_stream_proto_rawDesc = nil
	file_google_spanner_v1_change_stream_proto_goTypes = nil
	file_google_spanner_v1_change_stream_proto_depIdxs = nil
}
