// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package discoveryengine provides access to the Discovery Engine API.
//
// For product documentation, see: https://cloud.google.com/discovery-engine/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/discoveryengine/v1alpha"
//	...
//	ctx := context.Background()
//	discoveryengineService, err := discoveryengine.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	discoveryengineService, err := discoveryengine.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package discoveryengine // import "google.golang.org/api/discoveryengine/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "discoveryengine:v1alpha"
const apiName = "discoveryengine"
const apiVersion = "v1alpha"
const basePath = "https://discoveryengine.googleapis.com/"
const basePathTemplate = "https://discoveryengine.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://discoveryengine.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Locations = NewLocationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Locations *LocationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewLocationsService(s *Service) *LocationsService {
	rs := &LocationsService{s: s}
	return rs
}

type LocationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Collections = NewProjectsLocationsCollectionsService(s)
	rs.DataStores = NewProjectsLocationsDataStoresService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Collections *ProjectsLocationsCollectionsService

	DataStores *ProjectsLocationsDataStoresService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsCollectionsService(s *Service) *ProjectsLocationsCollectionsService {
	rs := &ProjectsLocationsCollectionsService{s: s}
	rs.DataConnector = NewProjectsLocationsCollectionsDataConnectorService(s)
	rs.DataStores = NewProjectsLocationsCollectionsDataStoresService(s)
	rs.Engines = NewProjectsLocationsCollectionsEnginesService(s)
	rs.Operations = NewProjectsLocationsCollectionsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsService struct {
	s *Service

	DataConnector *ProjectsLocationsCollectionsDataConnectorService

	DataStores *ProjectsLocationsCollectionsDataStoresService

	Engines *ProjectsLocationsCollectionsEnginesService

	Operations *ProjectsLocationsCollectionsOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorService(s *Service) *ProjectsLocationsCollectionsDataConnectorService {
	rs := &ProjectsLocationsCollectionsDataConnectorService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataConnectorOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataConnectorService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataConnectorOperationsService
}

func NewProjectsLocationsCollectionsDataConnectorOperationsService(s *Service) *ProjectsLocationsCollectionsDataConnectorOperationsService {
	rs := &ProjectsLocationsCollectionsDataConnectorOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataConnectorOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresService(s *Service) *ProjectsLocationsCollectionsDataStoresService {
	rs := &ProjectsLocationsCollectionsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsCollectionsDataStoresBranchesService(s)
	rs.Conversations = NewProjectsLocationsCollectionsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsCollectionsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsCollectionsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsDataStoresServingConfigsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsCollectionsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsCollectionsDataStoresBranchesService

	Conversations *ProjectsLocationsCollectionsDataStoresConversationsService

	Models *ProjectsLocationsCollectionsDataStoresModelsService

	Operations *ProjectsLocationsCollectionsDataStoresOperationsService

	Schemas *ProjectsLocationsCollectionsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsCollectionsDataStoresServingConfigsService

	SiteSearchEngine *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsCollectionsDataStoresUserEventsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsCollectionsDataStoresBranchesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresConversationsService(s *Service) *ProjectsLocationsCollectionsDataStoresConversationsService {
	rs := &ProjectsLocationsCollectionsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresModelsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresModelsOperationsService
}

func NewProjectsLocationsCollectionsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSchemasService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSchemasOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSchemasOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSchemasOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSchemasOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSchemasOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresServingConfigsService(s *Service) *ProjectsLocationsCollectionsDataStoresServingConfigsService {
	rs := &ProjectsLocationsCollectionsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s)
	rs.TargetSites = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService

	TargetSites *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService{s: s}
	rs.Operations = NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s)
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service

	Operations *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService
}

func NewProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService(s *Service) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService {
	rs := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsCollectionsDataStoresUserEventsService(s *Service) *ProjectsLocationsCollectionsDataStoresUserEventsService {
	rs := &ProjectsLocationsCollectionsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesService(s *Service) *ProjectsLocationsCollectionsEnginesService {
	rs := &ProjectsLocationsCollectionsEnginesService{s: s}
	rs.Conversations = NewProjectsLocationsCollectionsEnginesConversationsService(s)
	rs.Operations = NewProjectsLocationsCollectionsEnginesOperationsService(s)
	rs.ServingConfigs = NewProjectsLocationsCollectionsEnginesServingConfigsService(s)
	return rs
}

type ProjectsLocationsCollectionsEnginesService struct {
	s *Service

	Conversations *ProjectsLocationsCollectionsEnginesConversationsService

	Operations *ProjectsLocationsCollectionsEnginesOperationsService

	ServingConfigs *ProjectsLocationsCollectionsEnginesServingConfigsService
}

func NewProjectsLocationsCollectionsEnginesConversationsService(s *Service) *ProjectsLocationsCollectionsEnginesConversationsService {
	rs := &ProjectsLocationsCollectionsEnginesConversationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesConversationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesOperationsService(s *Service) *ProjectsLocationsCollectionsEnginesOperationsService {
	rs := &ProjectsLocationsCollectionsEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsEnginesServingConfigsService(s *Service) *ProjectsLocationsCollectionsEnginesServingConfigsService {
	rs := &ProjectsLocationsCollectionsEnginesServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsEnginesServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsCollectionsOperationsService(s *Service) *ProjectsLocationsCollectionsOperationsService {
	rs := &ProjectsLocationsCollectionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCollectionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresService(s *Service) *ProjectsLocationsDataStoresService {
	rs := &ProjectsLocationsDataStoresService{s: s}
	rs.Branches = NewProjectsLocationsDataStoresBranchesService(s)
	rs.Conversations = NewProjectsLocationsDataStoresConversationsService(s)
	rs.Models = NewProjectsLocationsDataStoresModelsService(s)
	rs.Operations = NewProjectsLocationsDataStoresOperationsService(s)
	rs.Schemas = NewProjectsLocationsDataStoresSchemasService(s)
	rs.ServingConfigs = NewProjectsLocationsDataStoresServingConfigsService(s)
	rs.SiteSearchEngine = NewProjectsLocationsDataStoresSiteSearchEngineService(s)
	rs.SuggestionDenyListEntries = NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s)
	rs.UserEvents = NewProjectsLocationsDataStoresUserEventsService(s)
	return rs
}

type ProjectsLocationsDataStoresService struct {
	s *Service

	Branches *ProjectsLocationsDataStoresBranchesService

	Conversations *ProjectsLocationsDataStoresConversationsService

	Models *ProjectsLocationsDataStoresModelsService

	Operations *ProjectsLocationsDataStoresOperationsService

	Schemas *ProjectsLocationsDataStoresSchemasService

	ServingConfigs *ProjectsLocationsDataStoresServingConfigsService

	SiteSearchEngine *ProjectsLocationsDataStoresSiteSearchEngineService

	SuggestionDenyListEntries *ProjectsLocationsDataStoresSuggestionDenyListEntriesService

	UserEvents *ProjectsLocationsDataStoresUserEventsService
}

func NewProjectsLocationsDataStoresBranchesService(s *Service) *ProjectsLocationsDataStoresBranchesService {
	rs := &ProjectsLocationsDataStoresBranchesService{s: s}
	rs.Documents = NewProjectsLocationsDataStoresBranchesDocumentsService(s)
	rs.Operations = NewProjectsLocationsDataStoresBranchesOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresBranchesService struct {
	s *Service

	Documents *ProjectsLocationsDataStoresBranchesDocumentsService

	Operations *ProjectsLocationsDataStoresBranchesOperationsService
}

func NewProjectsLocationsDataStoresBranchesDocumentsService(s *Service) *ProjectsLocationsDataStoresBranchesDocumentsService {
	rs := &ProjectsLocationsDataStoresBranchesDocumentsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesDocumentsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresBranchesOperationsService(s *Service) *ProjectsLocationsDataStoresBranchesOperationsService {
	rs := &ProjectsLocationsDataStoresBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresConversationsService(s *Service) *ProjectsLocationsDataStoresConversationsService {
	rs := &ProjectsLocationsDataStoresConversationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresConversationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresModelsService(s *Service) *ProjectsLocationsDataStoresModelsService {
	rs := &ProjectsLocationsDataStoresModelsService{s: s}
	rs.Operations = NewProjectsLocationsDataStoresModelsOperationsService(s)
	return rs
}

type ProjectsLocationsDataStoresModelsService struct {
	s *Service

	Operations *ProjectsLocationsDataStoresModelsOperationsService
}

func NewProjectsLocationsDataStoresModelsOperationsService(s *Service) *ProjectsLocationsDataStoresModelsOperationsService {
	rs := &ProjectsLocationsDataStoresModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresOperationsService(s *Service) *ProjectsLocationsDataStoresOperationsService {
	rs := &ProjectsLocationsDataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSchemasService(s *Service) *ProjectsLocationsDataStoresSchemasService {
	rs := &ProjectsLocationsDataStoresSchemasService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSchemasService struct {
	s *Service
}

func NewProjectsLocationsDataStoresServingConfigsService(s *Service) *ProjectsLocationsDataStoresServingConfigsService {
	rs := &ProjectsLocationsDataStoresServingConfigsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresServingConfigsService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSiteSearchEngineService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineService{s: s}
	rs.TargetSites = NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s)
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineService struct {
	s *Service

	TargetSites *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService
}

func NewProjectsLocationsDataStoresSiteSearchEngineTargetSitesService(s *Service) *ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService {
	rs := &ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSiteSearchEngineTargetSitesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresSuggestionDenyListEntriesService(s *Service) *ProjectsLocationsDataStoresSuggestionDenyListEntriesService {
	rs := &ProjectsLocationsDataStoresSuggestionDenyListEntriesService{s: s}
	return rs
}

type ProjectsLocationsDataStoresSuggestionDenyListEntriesService struct {
	s *Service
}

func NewProjectsLocationsDataStoresUserEventsService(s *Service) *ProjectsLocationsDataStoresUserEventsService {
	rs := &ProjectsLocationsDataStoresUserEventsService{s: s}
	return rs
}

type ProjectsLocationsDataStoresUserEventsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorContext: A description of the
// context in which an error occurred.
type GoogleCloudDiscoveryengineLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudDiscoveryengineLoggingHttpRequestContext `json:"httpRequest,omitempty"`

	// ReportLocation: The location in the source code where the decision
	// was made to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudDiscoveryengineLoggingSourceLocation `json:"reportLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpRequest") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingErrorLog: An error log which is
// reported to the Error Reporting system.
type GoogleCloudDiscoveryengineLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudDiscoveryengineLoggingErrorContext `json:"context,omitempty"`

	// ImportPayload: The error payload that is populated on LRO import
	// APIs.
	ImportPayload *GoogleCloudDiscoveryengineLoggingImportErrorContext `json:"importPayload,omitempty"`

	// Message: A message describing the error.
	Message string `json:"message,omitempty"`

	// RequestPayload: The API request payload, represented as a protocol
	// buffer. Most API request types are supported—for example: *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentServ
	// ice.CreateDocumentRequest` *
	// `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventSer
	// vice.WriteUserEventRequest`
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`

	// ResponsePayload: The API response payload, represented as a protocol
	// buffer. This is used to log some "soft errors", where the response is
	// valid but we consider there are some quality issues like unjoined
	// events. The following API responses are supported, and no PII is
	// included: *
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`
	//  *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent`
	//  *
	// `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEven
	// t`
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`

	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudDiscoveryengineLoggingServiceContext `json:"serviceContext,omitempty"`

	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingErrorLog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingHttpRequestContext: HTTP request
// data that is related to a reported error.
type GoogleCloudDiscoveryengineLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResponseStatusCode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingHttpRequestContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingImportErrorContext: The error
// payload that is populated on LRO import APIs, including the
// following: *
// `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments`
//
//	*
//
// `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvent
// s`
type GoogleCloudDiscoveryengineLoggingImportErrorContext struct {
	// Document: The detailed content which caused the error on importing a
	// document.
	Document string `json:"document,omitempty"`

	// GcsPath: Google Cloud Storage file path of the import source. Can be
	// set for batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`

	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`

	// Operation: The operation resource name of the LRO.
	Operation string `json:"operation,omitempty"`

	// UserEvent: The detailed content which caused the error on importing a
	// user event.
	UserEvent string `json:"userEvent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingImportErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingServiceContext: Describes a running
// service that sends errors.
type GoogleCloudDiscoveryengineLoggingServiceContext struct {
	// Service: An identifier of the service—for example,
	// `discoveryengine.googleapis.com`.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingServiceContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineLoggingSourceLocation: Indicates a location
// in the source code of the service for which errors are reported.
type GoogleCloudDiscoveryengineLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method—for
	// example,
	// `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`
	// .
	FunctionName string `json:"functionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FunctionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineLoggingSourceLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1CreateSchemaMetadata: Metadata for Create
// Schema LRO.
type GoogleCloudDiscoveryengineV1CreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1CreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1CreateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1DeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1DeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1DeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1DeleteSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsMetadata: Metadata related
// to the progress of the ImportDocuments operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportDocumentsResponse: Response of the
// ImportDocumentsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1ImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1ImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the
// ImportSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse:
// Response message for
// CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// FailedEntriesCount: Count of deny list entries that failed to be
	// imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`

	// ImportedEntriesCount: Count of deny list entries successfully
	// imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1ImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1ImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1ImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1ImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata: Metadata related
// to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeDocumentsResponse: Response message
// for DocumentService.PurgeDocuments method. If the long running
// operation is successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1PurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata:
// Metadata related to the progress of the
// PurgeSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse:
// Response message for CompletionService.PurgeSuggestionDenyListEntries
// method.
type GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1Schema: Defines the structure and layout
// of a type of document data.
type GoogleCloudDiscoveryengineV1Schema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JsonSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1Schema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1UpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1UpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1UpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1UpdateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaAdditionalParams: AdditionalParams
// message for WidgetService methods for security and privacy
// enhancement.
type GoogleCloudDiscoveryengineV1alphaAdditionalParams struct {
	// Token: Token that used for non-human user check.
	Token string `json:"token,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Token") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Token") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaAdditionalParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaAdditionalParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata:
// Metadata related to the progress of the
// SiteSearchEngineService.BatchCreateTargetSites operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest:
// Request message for SiteSearchEngineService.BatchCreateTargetSites
// method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest struct {
	// Requests: Required. The request message specifying the resources to
	// create. A maximum of 20 TargetSites can be created in a batch.
	Requests []*GoogleCloudDiscoveryengineV1alphaCreateTargetSiteRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse:
// Response message for SiteSearchEngineService.BatchCreateTargetSites
// method.
type GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse struct {
	// TargetSites: TargetSites created.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetSites") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetSites") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaBatchVerifyTargetSitesRequest:
// Request message for SiteSearchEngineService.BatchVerifyTargetSites
// method.
type GoogleCloudDiscoveryengineV1alphaBatchVerifyTargetSitesRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaBigQuerySource: BigQuery source
// import data from.
type GoogleCloudDiscoveryengineV1alphaBigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for user event imports: * `user_event` (default):
	// One UserEvent per row. Supported values for document imports: *
	// `document` (default): One Document format per row. Each document must
	// have a valid Document.id and one of Document.json_data or
	// Document.struct_data. * `custom`: One custom data per row in
	// arbitrary format that conforms to the defined Schema of the data
	// store. This can only be used by Gen App Builder.
	DataSchema string `json:"dataSchema,omitempty"`

	// DatasetId: Required. The BigQuery data set to copy the data from with
	// a length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`

	// GcsStagingDir: Intermediate Cloud Storage directory used for the
	// import with a length limit of 2,000 characters. Can be specified if
	// one wants to have the BigQuery export to a specific Cloud Storage
	// directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`

	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`

	// ProjectId: The project ID (can be project # or ID) that the BigQuery
	// source is in with a length limit of 128 characters. If not specified,
	// inherits the project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`

	// TableId: Required. The BigQuery table to copy the data from with a
	// length limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaBigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCompleteQueryRequest: Request
// message for CompletionService.CompleteQuery method.
type GoogleCloudDiscoveryengineV1alphaCompleteQueryRequest struct {
	// DataStore: Required. The parent data store resource name for which
	// the completion is performed, such as
	// `projects/*/locations/global/collections/default_collection/dataStores
	// /default_data_store`.
	DataStore string `json:"dataStore,omitempty"`

	// IncludeTailSuggestions: Indicates if tail suggestions should be
	// returned if there are no suggestions that match the full query. Even
	// if set to true, if there are suggestions that match the full query,
	// those are returned and no tail suggestions are returned.
	IncludeTailSuggestions bool `json:"includeTailSuggestions,omitempty"`

	// Query: Required. The typeahead input used to fetch suggestions.
	// Maximum length is 128 characters.
	Query string `json:"query,omitempty"`

	// QueryModel: Selects data model of query suggestions for serving.
	// Currently supported values: * `document` - Using suggestions
	// generated from user-imported documents. * `search-history` - Using
	// suggestions generated from the past history of SearchService.Search
	// API calls. Do not use it when there is no traffic for Search API. *
	// `user-event` - Using suggestions generated from user-imported search
	// events. * `document-completable` - Using suggestions taken directly
	// from user-imported document fields marked as completable. Default
	// values: * `document` is the default model for regular dataStores. *
	// `search-history` is the default model for site search dataStores.
	QueryModel string `json:"queryModel,omitempty"`

	// UserPseudoId: A unique identifier for tracking visitors. For example,
	// this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique
	// identifier should not change if the visitor logs in or out of the
	// website. This field should NOT have a fixed value such as
	// `unknown_visitor`. This should be the same identifier as
	// UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataStore") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCompleteQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCompleteQueryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse: Response
// message for CompletionService.CompleteQuery method.
type GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse struct {
	// QuerySuggestions: Results of the matched query suggestions. The
	// result list is ordered and the first result is a top suggestion.
	QuerySuggestions []*GoogleCloudDiscoveryengineV1alphaCompleteQueryResponseQuerySuggestion `json:"querySuggestions,omitempty"`

	// TailMatchTriggered: True if the returned suggestions are all tail
	// suggestions. For tail matching to be triggered,
	// include_tail_suggestions in the request must be true and there must
	// be no suggestions that match the full query.
	TailMatchTriggered bool `json:"tailMatchTriggered,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "QuerySuggestions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QuerySuggestions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCompleteQueryResponseQuerySuggestion:
//
//	Suggestions as search queries.
type GoogleCloudDiscoveryengineV1alphaCompleteQueryResponseQuerySuggestion struct {
	// CompletableFieldPaths: The unique document field paths that serve as
	// the source of this suggestion if it was generated from completable
	// fields. This field is only populated for the document-completable
	// model.
	CompletableFieldPaths []string `json:"completableFieldPaths,omitempty"`

	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CompletableFieldPaths") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompletableFieldPaths") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCompleteQueryResponseQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCompleteQueryResponseQuerySuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCompletionInfo: Detailed completion
// information including completion attribution token and clicked
// completion info.
type GoogleCloudDiscoveryengineV1alphaCompletionInfo struct {
	// SelectedPosition: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion position, starting
	// from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`

	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.QuerySuggestion.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SelectedPosition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SelectedPosition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCompletionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCompletionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConversation: External conversation
// proto definition.
type GoogleCloudDiscoveryengineV1alphaConversation struct {
	// EndTime: Output only. The time the conversation finished.
	EndTime string `json:"endTime,omitempty"`

	// Messages: Conversation messages.
	Messages []*GoogleCloudDiscoveryengineV1alphaConversationMessage `json:"messages,omitempty"`

	// Name: Immutable. Fully qualified name
	// `project/*/locations/global/collections/{collection}/dataStore/*/conve
	// rsations/*` or
	// `project/*/locations/global/collections/{collection}/engines/*/convers
	// ations/*`.
	Name string `json:"name,omitempty"`

	// StartTime: Output only. The time the conversation started.
	StartTime string `json:"startTime,omitempty"`

	// State: The state of the Conversation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unknown.
	//   "IN_PROGRESS" - Conversation is currently open.
	//   "COMPLETED" - Conversation has been completed.
	State string `json:"state,omitempty"`

	// UserPseudoId: A unique identifier for tracking users.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaConversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConversation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConversationContext: Defines context
// of the conversation
type GoogleCloudDiscoveryengineV1alphaConversationContext struct {
	// ActiveDocument: The current active document the user opened. It
	// contains the document resource reference.
	ActiveDocument string `json:"activeDocument,omitempty"`

	// ContextDocuments: The current list of documents the user is seeing.
	// It contains the document resource references.
	ContextDocuments []string `json:"contextDocuments,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActiveDocument") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveDocument") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaConversationContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConversationContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConversationMessage: Defines a
// conversation message.
type GoogleCloudDiscoveryengineV1alphaConversationMessage struct {
	// CreateTime: Output only. Message creation timestamp.
	CreateTime string `json:"createTime,omitempty"`

	// Reply: Search reply.
	Reply *GoogleCloudDiscoveryengineV1alphaReply `json:"reply,omitempty"`

	// UserInput: User text input.
	UserInput *GoogleCloudDiscoveryengineV1alphaTextInput `json:"userInput,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaConversationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConversationMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConverseConversationRequest: Request
// message for ConversationalSearchService.ConverseConversation method.
type GoogleCloudDiscoveryengineV1alphaConverseConversationRequest struct {
	// Conversation: The conversation to be used by auto session only. The
	// name field will be ignored as we automatically assign new name for
	// the conversation in auto session.
	Conversation *GoogleCloudDiscoveryengineV1alphaConversation `json:"conversation,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents
	// being filtered. Filter expression is case-sensitive. This will be
	// used to filter search results which may affect the summary response.
	// If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	// Filtering in Vertex AI Search is done by mapping the LHS filter key
	// to a key property defined in the Vertex AI Search backend -- this
	// mapping is defined by the customer in their schema. For example a
	// media customer might have a field 'name' in their schema. In this
	// case the filter would look like this: filter --> name:'ANY("king
	// kong")' For more information about filtering including syntax and
	// filter operators, see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`

	// Name: Required. The resource name of the Conversation to get. Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collec
	// tion}/dataStores/{data_store_id}/conversations/{conversation_id}`.
	// Use
	// `projects/{project_number}/locations/{location_id}/collections/{collec
	// tion}/dataStores/{data_store_id}/conversations/-` to activate auto
	// session mode, which automatically creates a new conversation inside a
	// ConverseConversation session.
	Name string `json:"name,omitempty"`

	// Query: Required. Current user input.
	Query *GoogleCloudDiscoveryengineV1alphaTextInput `json:"query,omitempty"`

	// SafeSearch: Whether to turn on safe search.
	SafeSearch bool `json:"safeSearch,omitempty"`

	// ServingConfig: The resource name of the Serving Config to use.
	// Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collec
	// tion}/dataStores/{data_store_id}/servingConfigs/{serving_config_id}`
	// If this is not set, the default serving config will be used.
	ServingConfig string `json:"servingConfig,omitempty"`

	// SummarySpec: A specification for configuring the summary returned in
	// the response.
	SummarySpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`

	// UserLabels: The user labels applied to a resource must meet the
	// following requirements: * Each resource can have multiple labels, up
	// to a maximum of 64. * Each label must be a key-value pair. * Keys
	// have a minimum length of 1 character and a maximum length of 63
	// characters and cannot be empty. Values can be empty and have a
	// maximum length of 63 characters. * Keys and values can contain only
	// lowercase letters, numeric characters, underscores, and dashes. All
	// characters must use UTF-8 encoding, and international characters are
	// allowed. * The key portion of a label must be unique. However, you
	// can use the same key with multiple resources. * Keys must start with
	// a lowercase letter or international character. See Google Cloud
	// Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConverseConversationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaConverseConversationResponse:
// Response message for ConversationalSearchService.ConverseConversation
// method.
type GoogleCloudDiscoveryengineV1alphaConverseConversationResponse struct {
	// Conversation: Updated conversation including the answer.
	Conversation *GoogleCloudDiscoveryengineV1alphaConversation `json:"conversation,omitempty"`

	// RelatedQuestions: Suggested related questions.
	RelatedQuestions []string `json:"relatedQuestions,omitempty"`

	// Reply: Answer to the current query.
	Reply *GoogleCloudDiscoveryengineV1alphaReply `json:"reply,omitempty"`

	// SearchResults: Search Results.
	SearchResults []*GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult `json:"searchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaConverseConversationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata: Metadata
// related to the progress of the DataStoreService.CreateDataStore
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata: Metadata
// related to the progress of the EngineService.CreateEngine operation.
// This will be returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata: Metadata for
// Create Schema LRO.
type GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.CreateTargetSite operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCreateTargetSiteRequest: Request
// message for SiteSearchEngineService.CreateTargetSite method.
type GoogleCloudDiscoveryengineV1alphaCreateTargetSiteRequest struct {
	// Parent: Required. Parent resource name of TargetSite, such as
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/siteSearchEngine`.
	Parent string `json:"parent,omitempty"`

	// TargetSite: Required. The TargetSite to create.
	TargetSite *GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSite,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCreateTargetSiteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCreateTargetSiteRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaCustomAttribute: A custom attribute
// that is not explicitly modeled in a resource, e.g. UserEvent.
type GoogleCloudDiscoveryengineV1alphaCustomAttribute struct {
	// Numbers: The numerical values of this custom attribute. For example,
	// `[2.3, 15.4]` when the key is "lengths_cm". Exactly one of
	// CustomAttribute.text or CustomAttribute.numbers should be set.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Numbers []float64 `json:"numbers,omitempty"`

	// Text: The textual values of this custom attribute. For example,
	// `["yellow", "green"]` when the key is "color". Empty string is not
	// allowed. Otherwise, an `INVALID_ARGUMENT` error is returned. Exactly
	// one of CustomAttribute.text or CustomAttribute.numbers should be set.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Numbers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Numbers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaCustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaCustomAttribute) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaCustomAttribute
	var s1 struct {
		Numbers []gensupport.JSONFloat64 `json:"numbers"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Numbers = make([]float64, len(s1.Numbers))
	for i := range s1.Numbers {
		s.Numbers[i] = float64(s1.Numbers[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1alphaDataStore: DataStore captures global
// settings and configs at the DataStore level.
type GoogleCloudDiscoveryengineV1alphaDataStore struct {
	// ContentConfig: Immutable. The content config of the data store. If
	// this field is unset, the server behavior defaults to
	// ContentConfig.NO_CONTENT.
	//
	// Possible values:
	//   "CONTENT_CONFIG_UNSPECIFIED" - Default value.
	//   "NO_CONTENT" - Only contains documents without any
	// Document.content.
	//   "CONTENT_REQUIRED" - Only contains documents with Document.content.
	//   "PUBLIC_WEBSITE" - The data store is used for public website
	// search.
	ContentConfig string `json:"contentConfig,omitempty"`

	// CreateTime: Output only. Timestamp the DataStore was created at.
	CreateTime string `json:"createTime,omitempty"`

	// DefaultSchemaId: Output only. The id of the default Schema
	// asscociated to this data store.
	DefaultSchemaId string `json:"defaultSchemaId,omitempty"`

	// DisplayName: Required. The data store display name. This field must
	// be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`

	// IndustryVertical: Immutable. The industry vertical that the data
	// store registers.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not
	// specific to any industry vertical.
	//   "MEDIA" - The media industry vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`

	// Name: Immutable. The full resource name of the data store. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/d
	// ataStores/{data_store_id}`. This field must be a UTF-8 encoded string
	// with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// SolutionTypes: The solutions that the data store enrolls. Available
	// solutions for each industry_vertical: * `MEDIA`:
	// `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. *
	// `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled.
	// Other solutions cannot be enrolled.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative
	// AI agent.
	SolutionTypes []string `json:"solutionTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDataStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDataStore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata: Metadata
// related to the progress of the DataStoreService.DeleteDataStore
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata: Metadata
// related to the progress of the EngineService.DeleteEngine operation.
// This will be returned by the google.longrunning.Operation.metadata
// field.
type GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.DeleteTargetSite operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata:
// Metadata related to the progress of the
// SiteSearchEngineService.DisableAdvancedSiteSearch operation. This
// will be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchRequest:
// Request message for SiteSearchEngineService.DisableAdvancedSiteSearch
// method.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse:
// Response message for
// SiteSearchEngineService.DisableAdvancedSiteSearch method.
type GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaDocument: Document captures all raw
// metadata information of items to be recommended or searched.
type GoogleCloudDiscoveryengineV1alphaDocument struct {
	// Content: The unstructured data linked to this document. Content must
	// be set if this document is under a `CONTENT_REQUIRED` data store.
	Content *GoogleCloudDiscoveryengineV1alphaDocumentContent `json:"content,omitempty"`

	// DerivedStructData: Output only. This field is OUTPUT_ONLY. It
	// contains derived data that are not in the original input document.
	DerivedStructData googleapi.RawMessage `json:"derivedStructData,omitempty"`

	// Id: Immutable. The identifier of the document. Id should conform to
	// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
	// limit of 63 characters.
	Id string `json:"id,omitempty"`

	// JsonData: The JSON string representation of the document. It should
	// conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	JsonData string `json:"jsonData,omitempty"`

	// Name: Immutable. The full resource name of the document. Format:
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/branches/{branch}/documents/{document_id}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`

	// ParentDocumentId: The identifier of the parent document. Currently
	// supports at most two level document hierarchy. Id should conform to
	// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
	// limit of 63 characters.
	ParentDocumentId string `json:"parentDocumentId,omitempty"`

	// SchemaId: The identifier of the schema located in the same data
	// store.
	SchemaId string `json:"schemaId,omitempty"`

	// StructData: The structured JSON data for the document. It should
	// conform to the registered Schema or an `INVALID_ARGUMENT` error is
	// thrown.
	StructData googleapi.RawMessage `json:"structData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDocument) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocument
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentContent: Unstructured data
// linked to this document.
type GoogleCloudDiscoveryengineV1alphaDocumentContent struct {
	// MimeType: The MIME type of the content. Supported types: *
	// `application/pdf` (PDF, only native PDFs are supported for now) *
	// `text/html` (HTML) *
	// `application/vnd.openxmlformats-officedocument.wordprocessingml.docume
	// nt` (DOCX) *
	// `application/vnd.openxmlformats-officedocument.presentationml.presenta
	// tion` (PPTX) * `text/plain` (TXT) See
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `json:"mimeType,omitempty"`

	// RawBytes: The content represented as a stream of bytes. The maximum
	// length is 1,000,000 bytes (1 MB / ~0.95 MiB). Note: As with all
	// `bytes` fields, this field is represented as pure binary in Protocol
	// Buffers and base64-encoded string in JSON. For example,
	// `abc123!?$*&()'-=@~` should be represented as
	// `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	RawBytes string `json:"rawBytes,omitempty"`

	// Uri: The URI of the content. Only Cloud Storage URIs (e.g.
	// `gs://bucket-name/path/to/file`) are supported. The maximum file size
	// is 2.5 MB for text-based formats, 100 MB for other formats.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MimeType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDocumentContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentContent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentInfo: Detailed document
// information associated with a user event.
type GoogleCloudDiscoveryengineV1alphaDocumentInfo struct {
	// Id: The Document resource ID.
	Id string `json:"id,omitempty"`

	// Name: The Document resource full name, of the form:
	// `projects/{project_id}/locations/{location}/collections/{collection_id
	// }/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_
	// id}`
	Name string `json:"name,omitempty"`

	// PromotionIds: The promotion IDs associated with this Document.
	// Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`

	// Quantity: Quantity of the Document associated with the user event.
	// Defaults to 1. For example, this field will be 2 if two quantities of
	// the same Document are involved in a `add-to-cart` event. Required for
	// events of the following event types: * `add-to-cart` * `purchase`
	Quantity int64 `json:"quantity,omitempty"`

	// Uri: The Document URI - only allowed for website data stores.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDocumentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig: A
// singleton resource of DataStore. It's empty when DataStore is
// created, which defaults to digital parser. The first call to
// DataStoreService.UpdateDocumentProcessingConfig method will
// initialize the config.
type GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig struct {
	// Name: Output only. The full resource name of the Document Processing
	// Config. Format:
	// `projects/*/locations/*/collections/*/dataStores/*/documentProcessingC
	// onfig`.
	Name string `json:"name,omitempty"`

	// OcrConfig: The OCR config. Currently it only applies to PDFs.
	OcrConfig *GoogleCloudDiscoveryengineV1alphaOcrConfig `json:"ocrConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaDoubleList: Double list.
type GoogleCloudDiscoveryengineV1alphaDoubleList struct {
	// Values: Double values.
	Values []float64 `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaDoubleList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDoubleList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaDoubleList) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaDoubleList
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata:
// Metadata related to the progress of the
// SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchRequest:
// Request message for SiteSearchEngineService.EnableAdvancedSiteSearch
// method.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse:
// Response message for SiteSearchEngineService.EnableAdvancedSiteSearch
// method.
type GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaEngine: Metadata that describes the
// training and serving parameters of an Engine.
type GoogleCloudDiscoveryengineV1alphaEngine struct {
	// ChatEngineConfig: Configurations for the Chat Engine. Only applicable
	// if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig `json:"chatEngineConfig,omitempty"`

	// ChatEngineMetadata: Output only. Additional information of the Chat
	// Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
	ChatEngineMetadata *GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata `json:"chatEngineMetadata,omitempty"`

	// CommonConfig: Common config spec that specifies the metadata of the
	// engine.
	CommonConfig *GoogleCloudDiscoveryengineV1alphaEngineCommonConfig `json:"commonConfig,omitempty"`

	// CreateTime: Output only. Timestamp the Recommendation Engine was
	// created at.
	CreateTime string `json:"createTime,omitempty"`

	// DataStoreIds: The data stores associated with this engine. For
	// SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of
	// engines, they can only associate with at most one data store. If
	// solution_type is SOLUTION_TYPE_CHAT, multiple DataStores in the same
	// Collection can be associated here. Note that when used in
	// CreateEngineRequest, one DataStore id must be provided as the system
	// will use it for necessary intializations.
	DataStoreIds []string `json:"dataStoreIds,omitempty"`

	// DisplayName: Required. The display name of the engine. Should be
	// human readable. UTF-8 encoded string with limit of 1024 characters.
	DisplayName string `json:"displayName,omitempty"`

	// IndustryVertical: The industry vertical that the engine registers.
	// The restriction of the Engine industry vertical is based on
	// DataStore: If unspecified, default to `GENERIC`. Vertical on Engine
	// has to match vertical of the DataStore liniked to the engine.
	//
	// Possible values:
	//   "INDUSTRY_VERTICAL_UNSPECIFIED" - Value used when unset.
	//   "GENERIC" - The generic vertical for documents that are not
	// specific to any industry vertical.
	//   "MEDIA" - The media industry vertical.
	IndustryVertical string `json:"industryVertical,omitempty"`

	// MediaRecommendationEngineConfig: Configurations for the Media Engine.
	// Only applicable on the data stores with solution_type
	// SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
	MediaRecommendationEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig `json:"mediaRecommendationEngineConfig,omitempty"`

	// Name: Immutable. The fully qualified resource name of the engine.
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters. Format:
	// `projects/{project_number}/locations/{location}/collections/{collectio
	// n}/engines/{engine}` engine should be 1-63 characters, and valid
	// characters are /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	Name string `json:"name,omitempty"`

	// RecommendationMetadata: Output only. Additional information of a
	// recommendation engine. Only applicable if solution_type is
	// SOLUTION_TYPE_RECOMMENDATION.
	RecommendationMetadata *GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata `json:"recommendationMetadata,omitempty"`

	// SearchEngineConfig: Configurations for the Search Engine. Only
	// applicable if solution_type is SOLUTION_TYPE_SEARCH.
	SearchEngineConfig *GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig `json:"searchEngineConfig,omitempty"`

	// SimilarDocumentsConfig: Additional config specs for a `similar-items`
	// engine.
	SimilarDocumentsConfig *GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig `json:"similarDocumentsConfig,omitempty"`

	// SolutionType: Required. The solutions of the engine.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative
	// AI agent.
	SolutionType string `json:"solutionType,omitempty"`

	// UpdateTime: Output only. Timestamp the Recommendation Engine was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChatEngineConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChatEngineConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig:
// Configurations for a Chat Engine.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig struct {
	// AgentCreationConfig: The configurationt generate the Dialogflow agent
	// that is associated to this Engine. Note that these configurations are
	// one-time consumed by and passed to Dialogflow service. It means they
	// cannot be retrieved using EngineService.GetEngine or
	// EngineService.ListEngines API after engine creation.
	AgentCreationConfig *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig `json:"agentCreationConfig,omitempty"`

	// DialogflowAgentToLink: The resource name of an exist Dialogflow agent
	// to link to this Chat Engine. Customers can either provide
	// `agent_creation_config` to create agent or provide an agent name that
	// links the agent with the Chat engine. Format:
	// `projects//locations//agents/`. Note that the
	// `dialogflow_agent_to_link` are one-time consumed by and passed to
	// Dialogflow service. It means they cannot be retrieved using
	// EngineService.GetEngine or EngineService.ListEngines API after engine
	// creation. Please use ChatEngineMetadata.dialogflow_agent for actual
	// agent association after Engine is created.
	DialogflowAgentToLink string `json:"dialogflowAgentToLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgentCreationConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgentCreationConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationCo
// nfig: Configurations for generating a Dialogflow agent. Note that
// these configurations are one-time consumed by and passed to
// Dialogflow service. It means they cannot be retrieved using
// EngineService.GetEngine or EngineService.ListEngines API after engine
// creation.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig struct {
	// Business: Name of the company, organization or other entity that the
	// agent represents. Used for knowledge connector LLM prompt and for
	// knowledge search.
	Business string `json:"business,omitempty"`

	// DefaultLanguageCode: Required. The default language of the agent as a
	// language tag. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a
	// list of the currently supported language codes.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`

	// Location: Agent location for Agent creation, supported values:
	// global/us/eu. If not provided, us Engine will create Agent using
	// us-central-1 by default; eu Engine will create Agent using eu-west-1
	// by default.
	Location string `json:"location,omitempty"`

	// TimeZone: Required. The time zone of the agent from the time zone
	// database (https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Business") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Business") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata: Additional
// information of a Chat Engine. Fields in this message are output only.
type GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata struct {
	// DialogflowAgent: The resource name of a Dialogflow agent, that this
	// Chat Engine refers to. Format: `projects//locations//agents/`.
	DialogflowAgent string `json:"dialogflowAgent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DialogflowAgent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DialogflowAgent") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineCommonConfig: Common
// configurations for an Engine.
type GoogleCloudDiscoveryengineV1alphaEngineCommonConfig struct {
	// CompanyName: The name of the company, business or entity that is
	// associated with the engine. Setting this may help improve LLM related
	// features.
	CompanyName string `json:"companyName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompanyName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompanyName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineCommonConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineCommonConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig
// : Additional config specs for a Media Recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig struct {
	// OptimizationObjective: The optimization objective e.g. `cvr`. This
	// field together with optimization_objective describe engine metadata
	// to use to control engine training and serving. Currently supported
	// values: `ctr`, `cvr`. If not specified, we choose default based on
	// engine type. Default depends on type of recommendation:
	// `recommended-for-you` => `ctr` `others-you-may-like` => `ctr`
	OptimizationObjective string `json:"optimizationObjective,omitempty"`

	// OptimizationObjectiveConfig: Name and value of the custom threshold
	// for cvr optimization_objective. For target_field `watch-time`,
	// target_field_value must be an integer value indicating the media
	// progress time in seconds between (0, 86400] (excludes 0, includes
	// 86400) (e.g., 90). For target_field `watch-percentage`, the
	// target_field_value must be a valid float value between (0, 1.0]
	// (excludes 0, includes 1.0) (e.g., 0.5).
	OptimizationObjectiveConfig *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig `json:"optimizationObjectiveConfig,omitempty"`

	// TrainingState: The training state that the engine is in (e.g.
	// `TRAINING` or `PAUSED`). Since part of the cost of running the
	// service is frequency of training - this can be used to determine when
	// to train engine in order to control cost. If not specified: the
	// default value for `CreateEngine` method is `TRAINING`. The default
	// value for `UpdateEngine` method is to keep the state the same as
	// before.
	//
	// Possible values:
	//   "TRAINING_STATE_UNSPECIFIED" - Unspecified training state.
	//   "PAUSED" - The engine training is paused.
	//   "TRAINING" - The engine is training.
	TrainingState string `json:"trainingState,omitempty"`

	// Type: Required. The type of engine e.g. `recommended-for-you`. This
	// field together with optimization_objective describe engine metadata
	// to use to control engine training and serving. Currently supported
	// values: `recommended-for-you`, `others-you-may-like`,
	// `more-like-this`, `most-popular-items`.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "OptimizationObjective") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptimizationObjective") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig
// OptimizationObjectiveConfig: Custom threshold for `cvr`
// optimization_objective.
type GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig struct {
	// TargetField: Required. The name of the field to target. Currently
	// supported values: `watch-percentage`, `watch-time`.
	TargetField string `json:"targetField,omitempty"`

	// TargetFieldValueFloat: Required. The threshold to be applied to the
	// target (e.g., 0.5).
	TargetFieldValueFloat float64 `json:"targetFieldValueFloat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TargetField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TargetField") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig
	var s1 struct {
		TargetFieldValueFloat gensupport.JSONFloat64 `json:"targetFieldValueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetFieldValueFloat = float64(s1.TargetFieldValueFloat)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata:
// Additional information of a recommendation engine.
type GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata struct {
	// DataState: Output only. The state of data requirements for this
	// engine: `DATA_OK` and `DATA_ERROR`. Engine cannot be trained if the
	// data is in `DATA_ERROR` state. Engine can have `DATA_ERROR` state
	// even if serving state is `ACTIVE`: engines were trained successfully
	// before, but cannot be refreshed because the underlying engine no
	// longer has sufficient data for training.
	//
	// Possible values:
	//   "DATA_STATE_UNSPECIFIED" - Unspecified default value, should never
	// be explicitly set.
	//   "DATA_OK" - The engine has sufficient training data.
	//   "DATA_ERROR" - The engine does not have sufficient training data.
	// Error messages can be queried via Stackdriver.
	DataState string `json:"dataState,omitempty"`

	// LastTuneTime: Output only. The timestamp when the latest successful
	// tune finished. Only applicable on Media Recommendation engines.
	LastTuneTime string `json:"lastTuneTime,omitempty"`

	// ServingState: Output only. The serving state of the engine: `ACTIVE`,
	// `NOT_ACTIVE`.
	//
	// Possible values:
	//   "SERVING_STATE_UNSPECIFIED" - Unspecified serving state.
	//   "INACTIVE" - The engine is not serving.
	//   "ACTIVE" - The engine is serving and can be queried.
	//   "TUNED" - The engine is trained on tuned hyperparameters and can be
	// queried.
	ServingState string `json:"servingState,omitempty"`

	// TuningOperation: Output only. The latest tune operation id associated
	// with the engine. Only applicable on Media Recommendation engines. If
	// present, this operation id can be used to determine if there is an
	// ongoing tune for this engine. To check the operation status, send the
	// GetOperation request with this operation id in the engine resource
	// format. If no tuning has happened for this engine, the string is
	// empty.
	TuningOperation string `json:"tuningOperation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataState") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig:
// Configurations for a Search Engine.
type GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig struct {
	// SearchAddOns: The add-on that this search engine enables.
	//
	// Possible values:
	//   "SEARCH_ADD_ON_UNSPECIFIED" - Default value when the enum is
	// unspecified. This is invalid to use.
	//   "SEARCH_ADD_ON_LLM" - Large language model add-on.
	SearchAddOns []string `json:"searchAddOns,omitempty"`

	// SearchTier: The search feature tier of this engine. Different tiers
	// might have different pricing. To learn more, please check the pricing
	// documentation. Defaults to SearchTier.SEARCH_TIER_STANDARD if not
	// specified.
	//
	// Possible values:
	//   "SEARCH_TIER_UNSPECIFIED" - Default value when the enum is
	// unspecified. This is invalid to use.
	//   "SEARCH_TIER_STANDARD" - Standard tier.
	//   "SEARCH_TIER_ENTERPRISE" - Enterprise tier.
	SearchTier string `json:"searchTier,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SearchAddOns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SearchAddOns") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig:
// Additional config specs for a `similar-items` engine.
type GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig struct {
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata: Metadata
// related to the progress of the EstimateDataSize operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest: Request
// message for EstimateBillingService.EstimateDataSize method
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest struct {
	// FileDataSource: Structured or unstructured data.
	FileDataSource *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestFileDataSource `json:"fileDataSource,omitempty"`

	// WebsiteDataSource: Website data.
	WebsiteDataSource *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSource `json:"websiteDataSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FileDataSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileDataSource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestFileDataSource
// : Data source contains files either in Cloud Storage or BigQuery.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestFileDataSource struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1alphaBigQuerySource `json:"bigquerySource,omitempty"`

	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1alphaGcsSource `json:"gcsSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigquerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestFileDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestFileDataSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSou
// rce: Data source is a set of website patterns that we crawl to get
// the total number of websites.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSource struct {
	// EstimatorUriPatterns: Required. The URI patterns to estimate the data
	// sizes. At most 10 patterns are allowed, otherwise an INVALID_ARGUMENT
	// error is thrown.
	EstimatorUriPatterns []*GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSourceEstimatorUriPattern `json:"estimatorUriPatterns,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EstimatorUriPatterns") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EstimatorUriPatterns") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSou
// rceEstimatorUriPattern: URI patterns that we use to crawl.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSourceEstimatorUriPattern struct {
	// ExactMatch: Whether we infer the generated URI or use the exact
	// provided one.
	ExactMatch bool `json:"exactMatch,omitempty"`

	// Exclusive: Whether the pattern is exclusive or not. If set to true,
	// the pattern is considered exclusive. If unset or set to false, the
	// pattern is considered inclusive by default.
	Exclusive bool `json:"exclusive,omitempty"`

	// ProvidedUriPattern: User provided URI pattern. For example,
	// `foo.com/bar/*`.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSourceEstimatorUriPattern) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequestWebsiteDataSourceEstimatorUriPattern
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse: Response
// of the EstimateDataSize request. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse struct {
	// DataSizeBytes: Data size in terms of bytes.
	DataSizeBytes int64 `json:"dataSizeBytes,omitempty,string"`

	// DocumentCount: Total number of documents.
	DocumentCount int64 `json:"documentCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DataSizeBytes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSizeBytes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse
// : Response message for
// SiteSearchEngineService.FetchDomainVerificationStatus method.
type GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TargetSites: List of TargetSites containing the site verification
	// status.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`

	// TotalSize: The total number of items matching the request. This will
	// always be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaFieldConfig: Configurations for
// fields of a schema. For example, configuring a field is indexable, or
// searchable.
type GoogleCloudDiscoveryengineV1alphaFieldConfig struct {
	// CompletableOption: If completable_option is COMPLETABLE_ENABLED,
	// field values are directly used and returned as suggestions for
	// Autocomplete in CompletionService.CompleteQuery. If
	// completable_option is unset, the server behavior defaults to
	// COMPLETABLE_DISABLED for fields that support setting completable
	// options, which are just `string` fields. For those fields that do not
	// support setting completable options, the server will skip completable
	// option setting, and setting completable_option for those fields will
	// throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "COMPLETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "COMPLETABLE_ENABLED" - Completable option enabled for a schema
	// field.
	//   "COMPLETABLE_DISABLED" - Completable option disabled for a schema
	// field.
	CompletableOption string `json:"completableOption,omitempty"`

	// DynamicFacetableOption: If dynamic_facetable_option is
	// DYNAMIC_FACETABLE_ENABLED, field values are available for dynamic
	// facet. Could only be DYNAMIC_FACETABLE_DISABLED if
	// FieldConfig.indexable_option is INDEXABLE_DISABLED. Otherwise, an
	// `INVALID_ARGUMENT` error will be returned. If
	// dynamic_facetable_option is unset, the server behavior defaults to
	// DYNAMIC_FACETABLE_DISABLED for fields that support setting dynamic
	// facetable options. For those fields that do not support setting
	// dynamic facetable options, such as `object` and `boolean`, the server
	// will skip dynamic facetable option setting, and setting
	// dynamic_facetable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "DYNAMIC_FACETABLE_ENABLED" - Dynamic facetable option enabled for
	// a schema field.
	//   "DYNAMIC_FACETABLE_DISABLED" - Dynamic facetable option disabled
	// for a schema field.
	DynamicFacetableOption string `json:"dynamicFacetableOption,omitempty"`

	// FieldPath: Required. Field path of the schema field. For example:
	// `title`, `description`, `release_info.release_year`.
	FieldPath string `json:"fieldPath,omitempty"`

	// FieldType: Output only. Raw type of the field.
	//
	// Possible values:
	//   "FIELD_TYPE_UNSPECIFIED" - Field type is unspecified.
	//   "OBJECT" - Field value type is Object.
	//   "STRING" - Field value type is String.
	//   "NUMBER" - Field value type is Number.
	//   "INTEGER" - Field value type is Integer.
	//   "BOOLEAN" - Field value type is Boolean.
	//   "GEOLOCATION" - Field value type is Geolocation.
	//   "DATETIME" - Field value type is Datetime.
	FieldType string `json:"fieldType,omitempty"`

	// IndexableOption: If indexable_option is INDEXABLE_ENABLED, field
	// values are indexed so that it can be filtered or faceted in
	// SearchService.Search. If indexable_option is unset, the server
	// behavior defaults to INDEXABLE_DISABLED for fields that support
	// setting indexable options. For those fields that do not support
	// setting indexable options, such as `object` and `boolean` and key
	// properties, the server will skip indexable_option setting, and
	// setting indexable_option for those fields will throw
	// `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "INDEXABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "INDEXABLE_ENABLED" - Indexable option enabled for a schema field.
	//   "INDEXABLE_DISABLED" - Indexable option disabled for a schema
	// field.
	IndexableOption string `json:"indexableOption,omitempty"`

	// KeyPropertyType: Output only. Type of the key property that this
	// field is mapped to. Empty string if this is not annotated as mapped
	// to a key property. Example types are `title`, `description`. Full
	// list is defined by `keyPropertyMapping` in the schema field
	// annotation. If the schema field has a `KeyPropertyMapping`
	// annotation, `indexable_option` and `searchable_option` of this field
	// cannot be modified.
	KeyPropertyType string `json:"keyPropertyType,omitempty"`

	// RecsFilterableOption: If recs_filterable_option is
	// FILTERABLE_ENABLED, field values are filterable by filter expression
	// in RecommendationService.Recommend. If FILTERABLE_ENABLED but the
	// field type is numerical, field values are not filterable by text
	// queries in RecommendationService.Recommend. Only textual fields are
	// supported. If recs_filterable_option is unset, the default setting is
	// FILTERABLE_DISABLED for fields that support setting filterable
	// options. When a field set to [FILTERABLE_DISABLED] is filtered, a
	// warning is generated and an empty result is returned.
	//
	// Possible values:
	//   "FILTERABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "FILTERABLE_ENABLED" - Filterable option enabled for a schema
	// field.
	//   "FILTERABLE_DISABLED" - Filterable option disabled for a schema
	// field.
	RecsFilterableOption string `json:"recsFilterableOption,omitempty"`

	// RetrievableOption: If retrievable_option is RETRIEVABLE_ENABLED,
	// field values are included in the search results. If
	// retrievable_option is unset, the server behavior defaults to
	// RETRIEVABLE_DISABLED for fields that support setting retrievable
	// options. For those fields that do not support setting retrievable
	// options, such as `object` and `boolean`, the server will skip
	// retrievable option setting, and setting retrievable_option for those
	// fields will throw `INVALID_ARGUMENT` error.
	//
	// Possible values:
	//   "RETRIEVABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "RETRIEVABLE_ENABLED" - Retrievable option enabled for a schema
	// field.
	//   "RETRIEVABLE_DISABLED" - Retrievable option disabled for a schema
	// field.
	RetrievableOption string `json:"retrievableOption,omitempty"`

	// SearchableOption: If searchable_option is SEARCHABLE_ENABLED, field
	// values are searchable by text queries in SearchService.Search. If
	// SEARCHABLE_ENABLED but field type is numerical, field values will not
	// be searchable by text queries in SearchService.Search, as there are
	// no text values associated to numerical fields. If searchable_option
	// is unset, the server behavior defaults to SEARCHABLE_DISABLED for
	// fields that support setting searchable options. Only `string` fields
	// that have no key property mapping support setting searchable_option.
	// For those fields that do not support setting searchable options, the
	// server will skip searchable option setting, and setting
	// searchable_option for those fields will throw `INVALID_ARGUMENT`
	// error.
	//
	// Possible values:
	//   "SEARCHABLE_OPTION_UNSPECIFIED" - Value used when unset.
	//   "SEARCHABLE_ENABLED" - Searchable option enabled for a schema
	// field.
	//   "SEARCHABLE_DISABLED" - Searchable option disabled for a schema
	// field.
	SearchableOption string `json:"searchableOption,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompletableOption")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompletableOption") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaFieldConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaFieldConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaGcsSource: Cloud Storage location
// for input content.
type GoogleCloudDiscoveryengineV1alphaGcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for document imports: * `document` (default): One
	// JSON Document per line. Each document must have a valid Document.id.
	// * `content`: Unstructured data (e.g. PDF, HTML). Each file matched by
	// `input_uris` becomes a document, with the ID set to the first 128
	// bits of SHA256(URI) encoded as a hex string. * `custom`: One custom
	// data JSON per row in arbitrary format that conforms to the defined
	// Schema of the data store. This can only be used by Gen App Builder. *
	// `csv`: A CSV file with header conforming to the defined Schema of the
	// data store. Each entry after the header is imported as a Document.
	// This can only be used by Gen App Builder. Supported values for user
	// even imports: * `user_event` (default): One JSON UserEvent per line.
	DataSchema string `json:"dataSchema,omitempty"`

	// InputUris: Required. Cloud Storage URIs to input files. URI can be up
	// to 2000 characters long. URIs can match the full object path (for
	// example, `gs://bucket/directory/object.json`) or a pattern matching
	// one or more files, such as `gs://bucket/directory/*.json`. A request
	// can contain at most 100 files (or 100,000 files if `data_schema` is
	// `content`). Each file can be up to 2 GB (or 100 MB if `data_schema`
	// is `content`).
	InputUris []string `json:"inputUris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaGcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata: Metadata
// related to the progress of the ImportDocuments operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest: Request
// message for Import methods.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest struct {
	// AutoGenerateIds: Whether to automatically generate IDs for the
	// documents if absent. If set to `true`, Document.ids are automatically
	// generated based on the hash of the payload, where IDs may not be
	// consistent during multiple imports. In which case
	// ReconciliationMode.FULL is highly recommended to avoid duplicate
	// contents. If unset or set to `false`, Document.ids have to be
	// specified using id_field, otherwise, documents without IDs fail to be
	// imported. Only set this field when using GcsSource or BigQuerySource,
	// and when GcsSource.data_schema or BigQuerySource.data_schema is
	// `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown.
	AutoGenerateIds bool `json:"autoGenerateIds,omitempty"`

	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1alphaBigQuerySource `json:"bigquerySource,omitempty"`

	// ErrorConfig: The desired location of errors incurred during the
	// Import.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1alphaGcsSource `json:"gcsSource,omitempty"`

	// IdField: The field in the Cloud Storage and BigQuery sources that
	// indicates the unique IDs of the documents. For GcsSource it is the
	// key of the JSON field. For instance, `my_id` for JSON `{"my_id":
	// "some_uuid"}`. For BigQuerySource it is the column name of the
	// BigQuery table where the unique ids are stored. The values of the
	// JSON field or the BigQuery column are used as the Document.ids. The
	// JSON field or the BigQuery column must be of string type, and the
	// values must be set as valid strings conform to RFC-1034
	// (https://tools.ietf.org/html/rfc1034) with 1-63 characters.
	// Otherwise, documents without valid IDs fail to be imported. Only set
	// this field when using GcsSource or BigQuerySource, and when
	// GcsSource.data_schema or BigQuerySource.data_schema is `custom`. And
	// only set this field when auto_generate_ids is unset or set as
	// `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is
	// unset, a default value `_id` is used when importing from the allowed
	// data sources.
	IdField string `json:"idField,omitempty"`

	// InlineSource: The Inline source for the input content for documents.
	InlineSource *GoogleCloudDiscoveryengineV1alphaImportDocumentsRequestInlineSource `json:"inlineSource,omitempty"`

	// ReconciliationMode: The mode of reconciliation between existing
	// documents and the documents to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to `INCREMENTAL`.
	//   "INCREMENTAL" - Inserts new documents or updates existing
	// documents.
	//   "FULL" - Calculates diff and replaces the entire document dataset.
	// Existing documents may be deleted if they are not present in the
	// source location.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AutoGenerateIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AutoGenerateIds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsRequestInlineSource:
// The inline source for the input config for ImportDocuments method.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsRequestInlineSource struct {
	// Documents: Required. A list of documents to update/create. Each
	// document must have a valid Document.id. Recommended max of 100 items.
	Documents []*GoogleCloudDiscoveryengineV1alphaDocument `json:"documents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Documents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsRequestInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse: Response of
// the ImportDocumentsRequest. If the long running operation is done,
// then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1alphaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetada
// ta: Metadata related to the progress of the
// ImportSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesReques
// t: Request message for
// CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest struct {
	// GcsSource: Cloud Storage location for the input content. Only 1 file
	// can be specified that contains all entries to import. Supported
	// values `gcs_source.schema` for autocomplete suggestion deny list
	// entry imports: * `suggestion_deny_list` (default): One JSON
	// [SuggestionDenyListEntry] per line.
	GcsSource *GoogleCloudDiscoveryengineV1alphaGcsSource `json:"gcsSource,omitempty"`

	// InlineSource: The Inline source for the input content for suggestion
	// deny list entries.
	InlineSource *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequestInlineSource `json:"inlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesReques
// tInlineSource: The inline source for SuggestionDenyListEntry.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequestInlineSource struct {
	// Entries: Required. A list of all denylist entries to import. Max of
	// 1000 items.
	Entries []*GoogleCloudDiscoveryengineV1alphaSuggestionDenyListEntry `json:"entries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequestInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRespon
// se: Response message for
// CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// FailedEntriesCount: Count of deny list entries that failed to be
	// imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`

	// ImportedEntriesCount: Count of deny list entries successfully
	// imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest: Request
// message for the ImportUserEvents request.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest struct {
	// BigquerySource: BigQuery input source.
	BigquerySource *GoogleCloudDiscoveryengineV1alphaBigQuerySource `json:"bigquerySource,omitempty"`

	// ErrorConfig: The desired location of errors incurred during the
	// Import. Cannot be set for inline user event imports.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// GcsSource: Cloud Storage location for the input content.
	GcsSource *GoogleCloudDiscoveryengineV1alphaGcsSource `json:"gcsSource,omitempty"`

	// InlineSource: The Inline source for the input content for UserEvents.
	InlineSource *GoogleCloudDiscoveryengineV1alphaImportUserEventsRequestInlineSource `json:"inlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigquerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsRequestInlineSource:
// The inline source for the input config for ImportUserEvents method.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsRequestInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended
	// max of 10k items.
	UserEvents []*GoogleCloudDiscoveryengineV1alphaUserEvent `json:"userEvents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEvents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsRequestInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsRequestInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse: Response
// of the ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaInterval: A floating point interval.
type GoogleCloudDiscoveryengineV1alphaInterval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`

	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`

	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`

	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaInterval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaInterval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaListConversationsResponse: Response
// for ListConversations method.
type GoogleCloudDiscoveryengineV1alphaListConversationsResponse struct {
	// Conversations: All the Conversations for a given data store.
	Conversations []*GoogleCloudDiscoveryengineV1alphaConversation `json:"conversations,omitempty"`

	// NextPageToken: Pagination token, if not returned indicates the last
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Conversations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListConversationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListDataStoresResponse: Response
// message for DataStoreService.ListDataStores method.
type GoogleCloudDiscoveryengineV1alphaListDataStoresResponse struct {
	// DataStores: All the customer's DataStores.
	DataStores []*GoogleCloudDiscoveryengineV1alphaDataStore `json:"dataStores,omitempty"`

	// NextPageToken: A token that can be sent as
	// ListDataStoresRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataStores") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListDataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListDataStoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListDocumentsResponse: Response
// message for DocumentService.ListDocuments method.
type GoogleCloudDiscoveryengineV1alphaListDocumentsResponse struct {
	// Documents: The Documents.
	Documents []*GoogleCloudDiscoveryengineV1alphaDocument `json:"documents,omitempty"`

	// NextPageToken: A token that can be sent as
	// ListDocumentsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Documents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Documents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListEnginesResponse: Response
// message for EngineService.ListEngines method.
type GoogleCloudDiscoveryengineV1alphaListEnginesResponse struct {
	// Engines: All the customer's Engines.
	Engines []*GoogleCloudDiscoveryengineV1alphaEngine `json:"engines,omitempty"`

	// NextPageToken: Not supported.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Engines") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Engines") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListEnginesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListEnginesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListSchemasResponse: Response
// message for SchemaService.ListSchemas method.
type GoogleCloudDiscoveryengineV1alphaListSchemasResponse struct {
	// NextPageToken: A token that can be sent as
	// ListSchemasRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Schemas: The Schemas.
	Schemas []*GoogleCloudDiscoveryengineV1alphaSchema `json:"schemas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListSchemasResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse: Response
// message for SiteSearchEngineService.ListTargetSites method.
type GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TargetSites: List of TargetSites.
	TargetSites []*GoogleCloudDiscoveryengineV1alphaTargetSite `json:"targetSites,omitempty"`

	// TotalSize: The total number of items matching the request. This will
	// always be populated in the response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest: Request
// message for WidgetService.LookupWidgetConfig method.
type GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest struct {
	// WidgetConfigId: Required. The UUID of the Widget Config.
	WidgetConfigId string `json:"widgetConfigId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "WidgetConfigId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "WidgetConfigId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse: Response
// message for WidgetService.LookupWidgetConfig method.
type GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse struct {
	// AnonymousWidgetConfig: The Anonymous Widget Config associated with
	// the UUID.
	AnonymousWidgetConfig *GoogleCloudDiscoveryengineV1alphaWidgetConfig `json:"anonymousWidgetConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AnonymousWidgetConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnonymousWidgetConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaMediaInfo: Media-specific user event
// information.
type GoogleCloudDiscoveryengineV1alphaMediaInfo struct {
	// MediaProgressDuration: The media progress time in seconds, if
	// applicable. For example, if the end user has finished 90 seconds of a
	// playback video, then MediaInfo.media_progress_duration.seconds should
	// be set to 90.
	MediaProgressDuration string `json:"mediaProgressDuration,omitempty"`

	// MediaProgressPercentage: Media progress should be computed using only
	// the media_progress_duration relative to the media total length. This
	// value must be between `[0, 1.0]` inclusive. If this is not a playback
	// or the progress cannot be computed (e.g. ongoing livestream), this
	// field should be unset.
	MediaProgressPercentage float64 `json:"mediaProgressPercentage,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MediaProgressDuration") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MediaProgressDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaMediaInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaMediaInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaMediaInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaMediaInfo
	var s1 struct {
		MediaProgressPercentage gensupport.JSONFloat64 `json:"mediaProgressPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MediaProgressPercentage = float64(s1.MediaProgressPercentage)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaOcrConfig: The OCR options for
// parsing documents.
type GoogleCloudDiscoveryengineV1alphaOcrConfig struct {
	// Enabled: Required. If OCR is enabled or not. OCR must be enabled for
	// other OcrConfig options to apply. We will only perform OCR on the
	// first 80 pages of the PDF files.
	Enabled bool `json:"enabled,omitempty"`

	// EnhancedDocumentElements: Apply additional enhanced OCR processing to
	// a list of document elements. Supported values: * `table`: advanced
	// table parsing model.
	EnhancedDocumentElements []string `json:"enhancedDocumentElements,omitempty"`

	// UseNativeText: If true, will use native text instead of OCR text on
	// pages containing native text.
	UseNativeText bool `json:"useNativeText,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaOcrConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaOcrConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPageInfo: Detailed page information.
type GoogleCloudDiscoveryengineV1alphaPageInfo struct {
	// PageCategory: The most specific category associated with a category
	// page. To represent full path of category, use '>' sign to separate
	// different hierarchies. If '>' is part of the category name, please
	// replace it with other character(s). Category pages include special
	// pages such as sales or promotions. For instance, a special sale page
	// may have the category hierarchy: "pageCategory" : "Sales > 2017
	// Black Friday Deals". Required for `view-category-page` events. Other
	// event types should not set this field. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	PageCategory string `json:"pageCategory,omitempty"`

	// PageviewId: A unique ID of a web page view. This should be kept the
	// same for all user events triggered from the same pageview. For
	// example, an item detail page view could trigger multiple events as
	// the user is browsing the page. The `pageview_id` property should be
	// kept the same for all these events so that they can be grouped
	// together properly. When using the client side event reporting with
	// JavaScript pixel and Google Tag Manager, this value is filled in
	// automatically.
	PageviewId string `json:"pageviewId,omitempty"`

	// ReferrerUri: The referrer URL of the current page. When using the
	// client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically. However, some browser
	// privacy restrictions may cause this field to be empty.
	ReferrerUri string `json:"referrerUri,omitempty"`

	// Uri: Complete URL (window.location.href) of the user's current page.
	// When using the client side event reporting with JavaScript pixel and
	// Google Tag Manager, this value is filled in automatically. Maximum
	// length 5,000 characters.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageCategory") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageCategory") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPageInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPanelInfo: Detailed panel
// information associated with a user event.
type GoogleCloudDiscoveryengineV1alphaPanelInfo struct {
	// DisplayName: The display name of the panel.
	DisplayName string `json:"displayName,omitempty"`

	// PanelId: Required. The panel ID.
	PanelId string `json:"panelId,omitempty"`

	// PanelPosition: The ordered position of the panel, if shown to the
	// user with other panels. If set, then total_panels must also be set.
	PanelPosition int64 `json:"panelPosition,omitempty"`

	// TotalPanels: The total number of panels, including this one, shown to
	// the user. Must be set if panel_position is set.
	TotalPanels int64 `json:"totalPanels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPanelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPanelInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPauseEngineRequest: Request for
// pausing training of an engine.
type GoogleCloudDiscoveryengineV1alphaPauseEngineRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata: Metadata
// related to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest: Request
// message for DocumentService.PurgeDocuments method.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest struct {
	// Filter: Required. Filter matching documents to purge. Only currently
	// supported value is `*` (all items).
	Filter string `json:"filter,omitempty"`

	// Force: Actually performs the purge. If `force` is set to false,
	// return the expected purge count without deleting any documents.
	Force bool `json:"force,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse: Response
// message for DocumentService.PurgeDocuments method. If the long
// running operation is successfully done, then this message is returned
// by the google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadat
// a: Metadata related to the progress of the
// PurgeSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRequest
// : Request message for
// CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRespons
// e: Response message for
// CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata: Metadata
// related to the progress of the PurgeUserEvents operation. This will
// be returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest: Request
// message for PurgeUserEvents method.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be
	// deleted with a length limit of 5,000 characters. The eligible fields
	// for filtering are: * `eventType`: Double quoted UserEvent.event_type
	// string. * `eventTime`: in ISO 8601 "zulu" format. * `userPseudoId`:
	// Double quoted string. Specifying this will delete all events
	// associated with a visitor. * `userId`: Double quoted string.
	// Specifying this will delete all events associated with a user.
	// Examples: * Deleting all events in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" *
	// Deleting specific eventType: `eventType = "search" * Deleting all
	// events for a specific visitor: `userPseudoId = "visitor1024" *
	// Deleting all events inside a DataStore: `*` The filtering fields are
	// assumed to have an implicit AND.
	Filter string `json:"filter,omitempty"`

	// Force: The `force` field is currently not supported. Purge user event
	// requests will permanently delete all purgeable events. Once the
	// development is complete: If `force` is set to false, the method will
	// return the expected purge count without deleting any user events.
	// This field will default to false if not included in the request.
	Force bool `json:"force,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse: Response of
// the PurgeUserEventsRequest. If the long running operation is
// successfully done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse struct {
	// PurgeCount: The total count of events purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecommendRequest: Request message
// for Recommend method.
type GoogleCloudDiscoveryengineV1alphaRecommendRequest struct {
	// Filter: Filter for restricting recommendation results with a length
	// limit of 5,000 characters. Currently, only filter expressions on the
	// `filter_tags` attribute is supported. Examples: * `(filter_tags:
	// ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))` *
	// `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags:
	// ANY("Green"))` If `attributeFilteringSyntax` is set to true under the
	// `params` field, then attribute-based expressions are expected instead
	// of the above described tag-based syntax. Examples: * (launguage:
	// ANY("en", "es")) AND NOT (categories: ANY("Movie")) * (available:
	// true) AND (launguage: ANY("en", "es")) OR (categories: ANY("Movie"))
	// If your filter blocks all results, the API will return generic
	// (unfiltered) popular Documents. If you only want results strictly
	// matching the filters, set `strictFiltering` to True in
	// RecommendRequest.params to receive empty results instead. Note that
	// the API will never return Documents with `storageStatus` of `EXPIRED`
	// or `DELETED` regardless of filter choices.
	Filter string `json:"filter,omitempty"`

	// PageSize: Maximum number of results to return. Set this property to
	// the number of recommendation results needed. If zero, the service
	// will choose a reasonable default. The maximum allowed value is 100.
	// Values above 100 will be coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`

	// Params: Additional domain specific parameters for the
	// recommendations. Allowed values: * `returnDocument`: Boolean. If set
	// to true, the associated Document object will be returned in
	// RecommendResponse.RecommendationResult.document. * `returnScore`:
	// Boolean. If set to true, the recommendation 'score' corresponding to
	// each returned Document will be set in
	// RecommendResponse.RecommendationResult.metadata. The given 'score'
	// indicates the probability of a Document conversion given the user's
	// context and history. * `strictFiltering`: Boolean. True by default.
	// If set to false, the service will return generic (unfiltered) popular
	// Documents instead of empty if your filter blocks all recommendation
	// results. * `diversityLevel`: String. Default empty. If set to be
	// non-empty, then it needs to be one of: * `no-diversity` *
	// `low-diversity` * `medium-diversity` * `high-diversity` *
	// `auto-diversity` This gives request-level control and adjusts
	// recommendation results based on Document category. *
	// `attributeFilteringSyntax`: Boolean. False by default. If set to
	// true, the `filter` field is interpreted according to the new,
	// attribute-based syntax.
	Params googleapi.RawMessage `json:"params,omitempty"`

	// UserEvent: Required. Context about the user, what they are looking at
	// and what action they took to trigger the Recommend request. Note that
	// this user event detail won't be ingested to userEvent logs. Thus, a
	// separate userEvent write request is required for event logging. Don't
	// set UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the
	// same fixed ID for different users. If you are trying to receive
	// non-personalized recommendations (not recommended; this can
	// negatively impact model performance), instead set
	// UserEvent.user_pseudo_id to a random unique ID and leave
	// UserEvent.user_info.user_id unset.
	UserEvent *GoogleCloudDiscoveryengineV1alphaUserEvent `json:"userEvent,omitempty"`

	// UserLabels: The user labels applied to a resource must meet the
	// following requirements: * Each resource can have multiple labels, up
	// to a maximum of 64. * Each label must be a key-value pair. * Keys
	// have a minimum length of 1 character and a maximum length of 63
	// characters and cannot be empty. Values can be empty and have a
	// maximum length of 63 characters. * Keys and values can contain only
	// lowercase letters, numeric characters, underscores, and dashes. All
	// characters must use UTF-8 encoding, and international characters are
	// allowed. * The key portion of a label must be unique. However, you
	// can use the same key with multiple resources. * Keys must start with
	// a lowercase letter or international character. See Requirements for
	// labels
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`

	// ValidateOnly: Use validate only mode for this recommendation query.
	// If set to true, a fake model will be used that returns arbitrary
	// Document IDs. Note that the validate only mode should only be used
	// for testing the API, or if the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecommendRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecommendRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecommendResponse: Response message
// for Recommend method.
type GoogleCloudDiscoveryengineV1alphaRecommendResponse struct {
	// AttributionToken: A unique attribution token. This should be included
	// in the UserEvent logs resulting from this recommendation, which
	// enables accurate attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// MissingIds: IDs of documents in the request that were missing from
	// the default Branch associated with the requested ServingConfig.
	MissingIds []string `json:"missingIds,omitempty"`

	// Results: A list of recommended Documents. The order represents the
	// ranking (from the most relevant Document to the least).
	Results []*GoogleCloudDiscoveryengineV1alphaRecommendResponseRecommendationResult `json:"results,omitempty"`

	// ValidateOnly: True if RecommendRequest.validate_only was set.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecommendResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecommendResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecommendResponseRecommendationResult
// : RecommendationResult represents a generic recommendation result
// with associated metadata.
type GoogleCloudDiscoveryengineV1alphaRecommendResponseRecommendationResult struct {
	// Document: Set if `returnDocument` is set to true in
	// RecommendRequest.params.
	Document *GoogleCloudDiscoveryengineV1alphaDocument `json:"document,omitempty"`

	// Id: Resource ID of the recommended Document.
	Id string `json:"id,omitempty"`

	// Metadata: Additional Document metadata / annotations. Possible
	// values: * `score`: Recommendation score in double value. Is set if
	// `returnScore` is set to true in RecommendRequest.params.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecommendResponseRecommendationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecommendResponseRecommendationResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata: Metadata
// related to the progress of the SiteSearchEngineService.RecrawlUris
// operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// InvalidUris: Unique URIs in the request that don't match any
	// TargetSite in the DataStore, only match TargetSites that haven't been
	// fully indexed, or match a TargetSite with type EXCLUDE.
	InvalidUris []string `json:"invalidUris,omitempty"`

	// PendingCount: Total number of URIs that have yet to be crawled.
	PendingCount int64 `json:"pendingCount,omitempty"`

	// QuotaExceededCount: Total number of URIs that were rejected due to
	// insufficient indexing resources.
	QuotaExceededCount int64 `json:"quotaExceededCount,omitempty"`

	// SuccessCount: Total number of URIs that have been crawled so far.
	SuccessCount int64 `json:"successCount,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ValidUrisCount: Total number of unique URIs in the request that are
	// not in invalid_uris.
	ValidUrisCount int64 `json:"validUrisCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest: Request message
// for SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest struct {
	// Uris: Required. List of URIs to crawl. At most 10K URIs are
	// supported, otherwise an INVALID_ARGUMENT error is thrown. Each URI
	// should match at least one TargetSite in `site_search_engine`.
	Uris []string `json:"uris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uris") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uris") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse: Response
// message for SiteSearchEngineService.RecrawlUris method.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse struct {
	// FailedUris: URIs that were not crawled before the LRO terminated.
	FailedUris []string `json:"failedUris,omitempty"`

	// FailureSamples: Details for a sample of up to 10 `failed_uris`.
	FailureSamples []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo `json:"failureSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FailedUris") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailedUris") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo:
// Details about why a particular URI failed to be crawled. Each
// FailureInfo contains one FailureReason per CorpusType.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo struct {
	// FailureReasons: List of failure reasons by corpus type (e.g. desktop,
	// mobile).
	FailureReasons []*GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason `json:"failureReasons,omitempty"`

	// Uri: URI that failed to be crawled.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FailureReasons") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailureReasons") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailure
// Reason: Details about why crawling failed for a particular
// CorpusType, e.g. DESKTOP and MOBILE crawling may fail for different
// reasons.
type GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason struct {
	// CorpusType: DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
	//
	// Possible values:
	//   "CORPUS_TYPE_UNSPECIFIED" - Default value.
	//   "DESKTOP" - Denotes a crawling attempt for the desktop version of a
	// page.
	//   "MOBILE" - Denotes a crawling attempt for the mobile version of a
	// page.
	CorpusType string `json:"corpusType,omitempty"`

	// ErrorMessage: Reason why the URI was not crawled.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorpusType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorpusType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaReply: Defines a reply message to
// user.
type GoogleCloudDiscoveryengineV1alphaReply struct {
	// References: References in the reply.
	References []*GoogleCloudDiscoveryengineV1alphaReplyReference `json:"references,omitempty"`

	// Reply: DEPRECATED: use `summary` instead. Text reply.
	Reply string `json:"reply,omitempty"`

	// Summary: Summary based on search results.
	Summary *GoogleCloudDiscoveryengineV1alphaSearchResponseSummary `json:"summary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "References") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "References") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaReply
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaReplyReference: Defines reference in
// reply.
type GoogleCloudDiscoveryengineV1alphaReplyReference struct {
	// AnchorText: Anchor text.
	AnchorText string `json:"anchorText,omitempty"`

	// End: Anchor text end index.
	End int64 `json:"end,omitempty"`

	// Start: Anchor text start index.
	Start int64 `json:"start,omitempty"`

	// Uri: URI link reference.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnchorText") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnchorText") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaReplyReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaReplyReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaResumeEngineRequest: Request for
// resuming training of an engine.
type GoogleCloudDiscoveryengineV1alphaResumeEngineRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaSchema: Defines the structure and
// layout of a type of document data.
type GoogleCloudDiscoveryengineV1alphaSchema struct {
	// FieldConfigs: Output only. Configurations for fields of the schema.
	FieldConfigs []*GoogleCloudDiscoveryengineV1alphaFieldConfig `json:"fieldConfigs,omitempty"`

	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FieldConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchInfo: Detailed search
// information.
type GoogleCloudDiscoveryengineV1alphaSearchInfo struct {
	// Offset: An integer that specifies the current offset for pagination
	// (the 0-indexed starting location, amongst the products deemed by the
	// API as relevant). See SearchRequest.offset for definition. If this
	// field is negative, an `INVALID_ARGUMENT` is returned. This can only
	// be set for `search` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Offset int64 `json:"offset,omitempty"`

	// OrderBy: The order in which products are returned, if applicable. See
	// SearchRequest.order_by for definition and syntax. The value must be a
	// UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. This can only be
	// set for `search` events. Other event types should not set this field.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	OrderBy string `json:"orderBy,omitempty"`

	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length
	// limit of 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is
	// returned. At least one of search_query or PageInfo.page_category is
	// required for `search` events. Other event types should not set this
	// field. Otherwise, an `INVALID_ARGUMENT` error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Offset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Offset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1alphaSearchRequest struct {
	// BoostSpec: Boost specification to boost certain documents. For more
	// information on boosting, see Boosting
	// (https://cloud.google.com/retail/docs/boosting#boost)
	BoostSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec `json:"boostSpec,omitempty"`

	// Branch: The branch resource name, such as
	// `projects/*/locations/global/collections/default_collection/dataStores
	// /default_data_store/branches/0`. Use `default_branch` as the branch
	// ID or leave this field empty, to search documents under the default
	// branch.
	Branch string `json:"branch,omitempty"`

	// CanonicalFilter: The default filter that is applied when a user
	// performs a search without checking any filters on the search page.
	// The filter applied to every search request when quality improvement
	// such as query expansion is needed. In the case a query does not have
	// a sufficient amount of results this filter will be used to determine
	// whether or not to enable the query expansion flow. The original
	// filter will still be used for the query expanded search. This field
	// is strongly recommended to achieve high search quality. For more
	// information about filter syntax, see SearchRequest.filter.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`

	// ContentSearchSpec: A specification for configuring the behavior of
	// content search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`

	// EmbeddingSpec: Uses the provided embedding to do additional semantic
	// document retrieval. The retrieval is based on the dot product of
	// SearchRequest.EmbeddingSpec.EmbeddingVector.vector and the document
	// embedding that is provided in
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path. If
	// SearchRequest.EmbeddingSpec.EmbeddingVector.field_path is not
	// provided, it will use ServingConfig.EmbeddingConfig.field_paths.
	EmbeddingSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec `json:"embeddingSpec,omitempty"`

	// FacetSpecs: Facet specifications for faceted search. If empty, no
	// facets are returned. A maximum of 100 values are allowed. Otherwise,
	// an `INVALID_ARGUMENT` error is returned.
	FacetSpecs []*GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec `json:"facetSpecs,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents
	// being filtered. Filter expression is case-sensitive. If this field is
	// unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in
	// Vertex AI Search is done by mapping the LHS filter key to a key
	// property defined in the Vertex AI Search backend -- this mapping is
	// defined by the customer in their schema. For example a media customer
	// might have a field 'name' in their schema. In this case the filter
	// would look like this: filter --> name:'ANY("king kong")' For more
	// information about filtering including syntax and filter operators,
	// see Filter
	// (https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
	Filter string `json:"filter,omitempty"`

	// ImageQuery: Raw image query.
	ImageQuery *GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery `json:"imageQuery,omitempty"`

	// Offset: A 0-indexed integer that specifies the current offset (that
	// is, starting result location, amongst the Documents deemed by the API
	// as relevant) in search results. This field is only considered if
	// page_token is unset. If this field is negative, an `INVALID_ARGUMENT`
	// is returned.
	Offset int64 `json:"offset,omitempty"`

	// OrderBy: The order in which documents are returned. Documents can be
	// ordered by a field in an Document object. Leave it unset if ordered
	// by relevance. `order_by` expression is case-sensitive. For more
	// information on ordering, see Ordering
	// (https://cloud.google.com/retail/docs/filter-and-order#order) If this
	// field is unrecognizable, an `INVALID_ARGUMENT` is returned.
	OrderBy string `json:"orderBy,omitempty"`

	// PageSize: Maximum number of Documents to return. If unspecified,
	// defaults to a reasonable value. The maximum allowed value is 100.
	// Values above 100 are coerced to 100. If this field is negative, an
	// `INVALID_ARGUMENT` is returned.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token received from a previous SearchService.Search
	// call. Provide this to retrieve the subsequent page. When paginating,
	// all other parameters provided to SearchService.Search must match the
	// call that provided the page token. Otherwise, an `INVALID_ARGUMENT`
	// error is returned.
	PageToken string `json:"pageToken,omitempty"`

	// Params: Additional search parameters. For public website search only,
	// supported values are: * `user_country_code`: string. Default empty.
	// If set to non-empty, results are restricted or boosted based on the
	// location provided. Example: user_country_code: "au" For available
	// codes see Country Codes
	// (https://developers.google.com/custom-search/docs/json_api_reference#countryCodes)
	// * `search_type`: double. Default empty. Enables non-webpage searching
	// depending on the value. The only valid non-default value is 1, which
	// enables image searching. Example: search_type: 1
	Params googleapi.RawMessage `json:"params,omitempty"`

	// Query: Raw search query.
	Query string `json:"query,omitempty"`

	// QueryExpansionSpec: The query expansion specification that specifies
	// the conditions under which query expansion occurs.
	QueryExpansionSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`

	// RankingExpression: The ranking expression controls the customized
	// ranking on retrieval documents. This overrides
	// ServingConfig.ranking_expression. The ranking expression is a single
	// function or multiple functions that are joint by "+". *
	// ranking_expression = function, { " + ", function }; Supported
	// functions: * double * relevance_score * double *
	// dotProduct(embedding_field_path) Function variables:
	// `relevance_score`: pre-defined keywords, used for measure relevance
	// between query and document. `embedding_field_path`: the document
	// embedding field used with query embedding vector. `dotProduct`:
	// embedding function between embedding_field_path and query embedding
	// vector. Example ranking expression: If document has an embedding
	// field doc_embedding, the ranking expression could be `0.5 *
	// relevance_score + 0.3 * dotProduct(doc_embedding)`.
	RankingExpression string `json:"rankingExpression,omitempty"`

	// SafeSearch: Whether to turn on safe search. This is only supported
	// for website search.
	SafeSearch bool `json:"safeSearch,omitempty"`

	// ServingConfig: Required. The resource name of the Search serving
	// config, such as
	// `projects/*/locations/global/collections/default_collection/engines/*/
	// servingConfigs/default_serving_config`, or
	// `projects/*/locations/global/collections/default_collection/dataStores
	// /default_data_store/servingConfigs/default_serving_config`. This
	// field is used to identify the serving configuration name, set of
	// models used to make the search.
	ServingConfig string `json:"servingConfig,omitempty"`

	// SpellCorrectionSpec: The spell correction specification that
	// specifies the mode under which spell correction takes effect.
	SpellCorrectionSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec `json:"spellCorrectionSpec,omitempty"`

	// UserInfo: Information about the end user. Highly recommended for
	// analytics. UserInfo.user_agent is used to deduce `device_type` for
	// analytics.
	UserInfo *GoogleCloudDiscoveryengineV1alphaUserInfo `json:"userInfo,omitempty"`

	// UserLabels: The user labels applied to a resource must meet the
	// following requirements: * Each resource can have multiple labels, up
	// to a maximum of 64. * Each label must be a key-value pair. * Keys
	// have a minimum length of 1 character and a maximum length of 63
	// characters and cannot be empty. Values can be empty and have a
	// maximum length of 63 characters. * Keys and values can contain only
	// lowercase letters, numeric characters, underscores, and dashes. All
	// characters must use UTF-8 encoding, and international characters are
	// allowed. * The key portion of a label must be unique. However, you
	// can use the same key with multiple resources. * Keys must start with
	// a lowercase letter or international character. See Google Cloud
	// Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `json:"userLabels,omitempty"`

	// UserPseudoId: A unique identifier for tracking visitors. For example,
	// this could be implemented with an HTTP cookie, which should be able
	// to uniquely identify a visitor on a single device. This unique
	// identifier should not change if the visitor logs in or out of the
	// website. This field should NOT have a fixed value such as
	// `unknown_visitor`. This should be the same identifier as
	// UserEvent.user_pseudo_id and CompleteQueryRequest.user_pseudo_id The
	// field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoostSpec") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec: Boost
// specification to boost certain documents.
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a document
	// matches multiple conditions in the specifictions, boost scores from
	// these specifications are all applied and combined in a non-linear
	// way. Maximum number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostS
// pec: Boost applies to documents which match a condition.
type GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0. Setting to 1.0 gives
	// the document a big promotion. However, it does not necessarily mean
	// that the boosted document will be the top result at all times, nor
	// that other documents will be excluded. Results could still be shown
	// even when none of them matches the condition. And results that are
	// significantly more relevant to the search query can still trump your
	// heavily favored but irrelevant documents. Setting to -1.0 gives the
	// document a big demotion. However, results that are deeply relevant
	// might still be shown. The document will have an upstream battle to
	// get a fairly high ranking, but it is not blocked out completely.
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float64 `json:"boost,omitempty"`

	// Condition: An expression which specifies a boost condition. The
	// syntax and supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: *
	// To boost documents with document ID "doc_1" or "doc_2", and color
	// "Red" or "Blue": * (id: ANY("doc_1", "doc_2")) AND (color:
	// ANY("Red","Blue"))
	Condition string `json:"condition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Boost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec: A
// specification for configuring the behavior of content search.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec struct {
	// ExtractiveContentSpec: If there is no extractive_content_spec
	// provided, there will be no extractive answer in the search response.
	ExtractiveContentSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec `json:"extractiveContentSpec,omitempty"`

	// SnippetSpec: If `snippetSpec` is not specified, snippets are not
	// included in the search response.
	SnippetSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec `json:"snippetSpec,omitempty"`

	// SummarySpec: If `summarySpec` is not specified, summaries are not
	// included in the search response.
	SummarySpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec `json:"summarySpec,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ExtractiveContentSpec") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExtractiveContentSpec") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtract
// iveContentSpec: A specification for configuring the extractive
// content in a search response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec struct {
	// MaxExtractiveAnswerCount: The maximum number of extractive answers
	// returned in each search result. An extractive answer is a verbatim
	// answer extracted from the original document, which provides a precise
	// and contextually relevant answer to the search query. If the number
	// of matching answers is less than the `max_extractive_answer_count`,
	// return all of the answers. Otherwise, return the
	// `max_extractive_answer_count`. At most five answers are returned for
	// each SearchResult.
	MaxExtractiveAnswerCount int64 `json:"maxExtractiveAnswerCount,omitempty"`

	// MaxExtractiveSegmentCount: The max number of extractive segments
	// returned in each search result. Only applied if the DataStore is set
	// to DataStore.ContentConfig.CONTENT_REQUIRED or
	// DataStore.solution_types is SOLUTION_TYPE_CHAT. An extractive segment
	// is a text segment extracted from the original document that is
	// relevant to the search query, and, in general, more verbose than an
	// extractive answer. The segment could then be used as input for LLMs
	// to generate summaries and answers. If the number of matching segments
	// is less than `max_extractive_segment_count`, return all of the
	// segments. Otherwise, return the `max_extractive_segment_count`.
	MaxExtractiveSegmentCount int64 `json:"maxExtractiveSegmentCount,omitempty"`

	// NumNextSegments: Return at most `num_next_segments` segments after
	// each selected segments.
	NumNextSegments int64 `json:"numNextSegments,omitempty"`

	// NumPreviousSegments: Specifies whether to also include the adjacent
	// from each selected segments. Return at most `num_previous_segments`
	// segments before each selected segments.
	NumPreviousSegments int64 `json:"numPreviousSegments,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MaxExtractiveAnswerCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxExtractiveAnswerCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippet
// Spec: A specification for configuring snippets in a search response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec struct {
	// MaxSnippetCount: [DEPRECATED] This field is deprecated. To control
	// snippet return, use `return_snippet` field. For backwards
	// compatibility, we will return snippet if max_snippet_count > 0.
	MaxSnippetCount int64 `json:"maxSnippetCount,omitempty"`

	// ReferenceOnly: [DEPRECATED] This field is deprecated and will have no
	// affect on the snippet.
	ReferenceOnly bool `json:"referenceOnly,omitempty"`

	// ReturnSnippet: If `true`, then return snippet. If no snippet can be
	// generated, we return "No snippet is available for this page." A
	// `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also
	// be returned.
	ReturnSnippet bool `json:"returnSnippet,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxSnippetCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxSnippetCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummary
// Spec: A specification for configuring a summary returned in a search
// response.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec struct {
	// IgnoreAdversarialQuery: Specifies whether to filter out adversarial
	// queries. The default value is `false`. Google employs search-query
	// classification to detect adversarial queries. No summary is returned
	// if the search query is classified as an adversarial query. For
	// example, a user might ask a question regarding negative comments
	// about the company or submit a query designed to generate unsafe,
	// policy-violating output. If this field is set to `true`, we skip
	// generating summaries for adversarial queries and return fallback
	// messages instead.
	IgnoreAdversarialQuery bool `json:"ignoreAdversarialQuery,omitempty"`

	// IgnoreNonSummarySeekingQuery: Specifies whether to filter out queries
	// that are not summary-seeking. The default value is `false`. Google
	// employs search-query classification to detect summary-seeking
	// queries. No summary is returned if the search query is classified as
	// a non-summary seeking query. For example, `why is the sky blue` and
	// `Who is the best soccer player in the world?` are summary-seeking
	// queries, but `SFO airport` and `world cup 2026` are not. They are
	// most likely navigational queries. If this field is set to `true`, we
	// skip generating summaries for non-summary seeking queries and return
	// fallback messages instead.
	IgnoreNonSummarySeekingQuery bool `json:"ignoreNonSummarySeekingQuery,omitempty"`

	// IncludeCitations: Specifies whether to include citations in the
	// summary. The default value is `false`. When this field is set to
	// `true`, summaries include in-line citation numbers. Example summary
	// including citations: BigQuery is Google Cloud's fully managed and
	// completely serverless enterprise data warehouse [1]. BigQuery
	// supports all data types, works across clouds, and has built-in
	// machine learning and business intelligence, all within a unified
	// platform [2, 3]. The citation numbers refer to the returned search
	// results and are 1-indexed. For example, [1] means that the sentence
	// is attributed to the first search result. [2, 3] means that the
	// sentence is attributed to both the second and third search results.
	IncludeCitations bool `json:"includeCitations,omitempty"`

	// LanguageCode: Language code for Summary. Use language tags defined by
	// BCP47 (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is
	// an experimental feature.
	LanguageCode string `json:"languageCode,omitempty"`

	// ModelPromptSpec: If specified, the spec will be used to modify the
	// prompt provided to the LLM.
	ModelPromptSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec `json:"modelPromptSpec,omitempty"`

	// ModelSpec: If specified, the spec will be used to modify the model
	// specification provided to the LLM.
	ModelSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec `json:"modelSpec,omitempty"`

	// SummaryResultCount: The number of top results to generate the summary
	// from. If the number of results returned is less than
	// `summaryResultCount`, the summary is generated from all of the
	// results. At most five results can be used to generate a summary.
	SummaryResultCount int64 `json:"summaryResultCount,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IgnoreAdversarialQuery") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IgnoreAdversarialQuery")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummary
// SpecModelPromptSpec: Specification of the prompt to use with the
// model.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec struct {
	// Preamble: Text at the beginning of the prompt that instructs the
	// assistant. Examples are available in the user guide.
	Preamble string `json:"preamble,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Preamble") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Preamble") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummary
// SpecModelSpec: Specification of the model.
type GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec struct {
	// Version: The model version used to generate the summary. Supported
	// values are: * `stable`: string. Default value when no value is
	// specified. Uses a generally available, fine-tuned version of the
	// text-bison@001 model. * `preview`: string. (Public preview) Uses a
	// fine-tuned version of the text-bison@002 model. This model works only
	// for summaries in English.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Version") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Version") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec: The
// specification that uses customized query embedding vector to do
// semantic document retrieval.
type GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec struct {
	// EmbeddingVectors: The embedding vector used for retrieval. Limit to
	// 1.
	EmbeddingVectors []*GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector `json:"embeddingVectors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmbeddingVectors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmbeddingVectors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVe
// ctor: Embedding vector.
type GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector struct {
	// FieldPath: Embedding field path in schema.
	FieldPath string `json:"fieldPath,omitempty"`

	// Vector: Query embedding vector.
	Vector []float64 `json:"vector,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldPath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldPath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector
	var s1 struct {
		Vector []gensupport.JSONFloat64 `json:"vector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Vector = make([]float64, len(s1.Vector))
	for i := range s1.Vector {
		s.Vector[i] = float64(s1.Vector[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec: A facet
// specification to perform faceted search.
type GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If
	// set to true, the position of this facet among all facets in the
	// response is determined automatically. If dynamic facets are enabled,
	// it is ordered together. If set to false, the position of this facet
	// in the response is the same as in the request, and it is ranked
	// before the facets with dynamic position enable and all dynamic
	// facets. For example, you may always want to have rating facet
	// returned in the response, but it's not necessarily to always display
	// the rating facet at the top. In that case, you can set
	// enable_dynamic_position to true so that the position of rating facet
	// in response is determined automatically. Another example, assuming
	// you have the following facets in the request: * "rating",
	// enable_dynamic_position = true * "price", enable_dynamic_position =
	// false * "brands", enable_dynamic_position = false And also you have a
	// dynamic facets enabled, which generates a facet `gender`. Then the
	// final order of the facets in the response can be ("price", "brands",
	// "rating", "gender") or ("price", "brands", "gender", "rating")
	// depends on how API orders "gender" and "rating" facets. However,
	// notice that "price" and "brands" are always ranked at first and
	// second position because their enable_dynamic_position is false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`

	// ExcludedFilterKeys: List of keys to exclude when faceting. By
	// default, FacetKey.key is not excluded from the filter unless it is
	// listed in this field. Listing a facet key in this field allows its
	// values to appear as facet results, even when they are filtered out of
	// search results. Using this field does not affect what search results
	// are returned. For example, suppose there are 100 documents with the
	// color facet "Red" and 200 documents with the color facet "Blue". A
	// query containing the filter "color:ANY("Red")" and having "color" as
	// FacetKey.key would by default return only "Red" documents in the
	// search results, and also return "Red" with count 100 as the only
	// color facet. Although there are also blue documents available, "Blue"
	// would not be shown as an available facet value. If "color" is listed
	// in "excludedFilterKeys", then the query returns the facet values
	// "Red" with count 100 and "Blue" with count 200, because the "color"
	// key is now excluded from the filter. Because this field doesn't
	// affect search results, the search results are still correctly
	// filtered to return only "Red" documents. A maximum of 100 values are
	// allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`

	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`

	// Limit: Maximum of facet values that should be returned for this
	// facet. If unspecified, defaults to 20. The maximum allowed value is
	// 300. Values above 300 are coerced to 300. If this field is negative,
	// an `INVALID_ARGUMENT` is returned.
	Limit int64 `json:"limit,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableDynamicPosition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey:
// Specifies how a facet is computed.
type GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey struct {
	// CaseInsensitive: True to make facet keys case insensitive when
	// getting faceting values with prefixes or contains; false otherwise.
	CaseInsensitive bool `json:"caseInsensitive,omitempty"`

	// Contains: Only get facet values that contains the given strings. For
	// example, suppose "category" has three values "Action > 2022", "Action
	// > 2021" and "Sci-Fi > 2022". If set "contains" to "2022", the
	// "category" facet only contains "Action > 2022" and "Sci-Fi > 2022".
	// Only supported on textual fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`

	// Intervals: Set only if values should be bucketed into intervals. Must
	// be set for facets with numerical values. Must not be set for facet
	// with text values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudDiscoveryengineV1alphaInterval `json:"intervals,omitempty"`

	// Key: Required. Supported textual and numerical facet keys in Document
	// object, over which the facet values are computed. Facet key is
	// case-sensitive.
	Key string `json:"key,omitempty"`

	// OrderBy: The order in which documents are returned. Allowed values
	// are: * "count desc", which means order by
	// SearchResponse.Facet.values.count descending. * "value desc", which
	// means order by SearchResponse.Facet.values.value descending. Only
	// applies to textual facets. If not set, textual values are sorted in
	// natural order (https://en.wikipedia.org/wiki/Natural_sort_order);
	// numerical intervals are sorted in the order given by
	// FacetSpec.FacetKey.intervals.
	OrderBy string `json:"orderBy,omitempty"`

	// Prefixes: Only get facet values that start with the given string
	// prefix. For example, suppose "category" has three values "Action >
	// 2022", "Action > 2021" and "Sci-Fi > 2022". If set "prefixes" to
	// "Action", the "category" facet only contains "Action > 2022" and
	// "Action > 2021". Only supported on textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`

	// RestrictedValues: Only get facet for the given restricted values.
	// Only supported on textual fields. For example, suppose "category" has
	// three values "Action > 2022", "Action > 2021" and "Sci-Fi > 2022". If
	// set "restricted_values" to "Action > 2022", the "category" facet only
	// contains "Action > 2022". Only supported on textual fields. Maximum
	// is 10.
	RestrictedValues []string `json:"restrictedValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseInsensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseInsensitive") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery: Specifies
// the image query input.
type GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery struct {
	// ImageBytes: Base64 encoded image bytes. Supported image formats:
	// JPEG, PNG, and BMP.
	ImageBytes string `json:"imageBytes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageBytes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageBytes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec:
// Specification to determine under which conditions query expansion
// should occur.
type GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur.
	// Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition. In
	// this case, server behavior defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query
	// is used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by the Search API.
	Condition string `json:"condition,omitempty"`

	// PinUnexpandedResults: Whether to pin unexpanded results. If this
	// field is set to true, unexpanded products are always at the top of
	// the search results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec:
// The specification for query spell correction.
type GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec struct {
	// Mode: The mode under which spell correction should take effect to
	// replace the original search query. Default to Mode.AUTO.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified spell correction mode. In this
	// case, server behavior defaults to Mode.AUTO.
	//   "SUGGESTION_ONLY" - Search API will try to find a spell suggestion
	// if there is any and put in the SearchResponse.corrected_query. The
	// spell suggestion will not be used as the search query.
	//   "AUTO" - Automatic spell correction built by the Search API. Search
	// will be based on the corrected query if found.
	Mode string `json:"mode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mode") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponse: Response message for
// SearchService.Search method.
type GoogleCloudDiscoveryengineV1alphaSearchResponse struct {
	// AppliedControls: Controls applied as part of the Control service.
	AppliedControls []string `json:"appliedControls,omitempty"`

	// AttributionToken: A unique search token. This should be included in
	// the UserEvent logs resulting from this search, which enables accurate
	// attribution of search model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CorrectedQuery: Contains the spell corrected query, if found. If the
	// spell correction type is AUTOMATIC, then the search results are based
	// on corrected_query. Otherwise the original query is used for search.
	CorrectedQuery string `json:"correctedQuery,omitempty"`

	// Facets: Results of facets requested by user.
	Facets []*GoogleCloudDiscoveryengineV1alphaSearchResponseFacet `json:"facets,omitempty"`

	GeoSearchDebugInfo []*GoogleCloudDiscoveryengineV1alphaSearchResponseGeoSearchDebugInfo `json:"geoSearchDebugInfo,omitempty"`

	// GuidedSearchResult: Guided search result.
	GuidedSearchResult *GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResult `json:"guidedSearchResult,omitempty"`

	// NextPageToken: A token that can be sent as SearchRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// QueryExpansionInfo: Query expansion information for the returned
	// results.
	QueryExpansionInfo *GoogleCloudDiscoveryengineV1alphaSearchResponseQueryExpansionInfo `json:"queryExpansionInfo,omitempty"`

	// RedirectUri: The URI of a customer-defined redirect page. If redirect
	// action is triggered, no search is performed, and only redirect_uri
	// and attribution_token are set in the response.
	RedirectUri string `json:"redirectUri,omitempty"`

	// Results: A list of matched documents. The order represents the
	// ranking.
	Results []*GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult `json:"results,omitempty"`

	// Summary: A summary as part of the search results. This field is only
	// returned if SearchRequest.ContentSearchSpec.summary_spec is set.
	Summary *GoogleCloudDiscoveryengineV1alphaSearchResponseSummary `json:"summary,omitempty"`

	// TotalSize: The estimated total count of matched items irrespective of
	// pagination. The count of results returned by pagination may be less
	// than the total_size that matches.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppliedControls") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppliedControls") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseFacet: A facet result.
type GoogleCloudDiscoveryengineV1alphaSearchResponseFacet struct {
	// DynamicFacet: Whether the facet is dynamically generated.
	DynamicFacet bool `json:"dynamicFacet,omitempty"`

	// Key: The key for this facet. E.g., "colors" or "price". It matches
	// SearchRequest.FacetSpec.FacetKey.key.
	Key string `json:"key,omitempty"`

	// Values: The facet values for this field.
	Values []*GoogleCloudDiscoveryengineV1alphaSearchResponseFacetFacetValue `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DynamicFacet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DynamicFacet") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseFacet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseFacetFacetValue: A
// facet value which contains value names and their count.
type GoogleCloudDiscoveryengineV1alphaSearchResponseFacetFacetValue struct {
	// Count: Number of items that have this facet value.
	Count int64 `json:"count,omitempty,string"`

	// Interval: Interval value for a facet, such as 10, 20) for facet
	// "price". It matches [SearchRequest.FacetSpec.FacetKey.intervals.
	Interval *GoogleCloudDiscoveryengineV1alphaInterval `json:"interval,omitempty"`

	// Value: Text value of a facet, such as "Black" for facet "colors".
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseFacetFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseFacetFacetValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseGeoSearchDebugInfo:
// Debug information specifically related to forward geocoding issues
// arising from Geolocation Search.
type GoogleCloudDiscoveryengineV1alphaSearchResponseGeoSearchDebugInfo struct {
	// ErrorMessage: The error produced.
	ErrorMessage string `json:"errorMessage,omitempty"`

	// OriginalAddressQuery: The address from which forward geocoding
	// ingestion produced issues.
	OriginalAddressQuery string `json:"originalAddressQuery,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorMessage") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseGeoSearchDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseGeoSearchDebugInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResult:
// Guided search result. The guided search helps user to refine the
// search results and narrow down to the real needs from a broaded
// search results.
type GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResult struct {
	// FollowUpQuestions: Suggested follow-up questions.
	FollowUpQuestions []string `json:"followUpQuestions,omitempty"`

	// RefinementAttributes: A list of ranked refinement attributes.
	RefinementAttributes []*GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResultRefinementAttribute `json:"refinementAttributes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FollowUpQuestions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FollowUpQuestions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResultRefin
// ementAttribute: Useful attribute for search result refinements.
type GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResultRefinementAttribute struct {
	// AttributeKey: Attribute key used to refine the results e.g.
	// 'movie_type'.
	AttributeKey string `json:"attributeKey,omitempty"`

	// AttributeValue: Attribute value used to refine the results e.g.
	// 'drama'.
	AttributeValue string `json:"attributeValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttributeKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResultRefinementAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseGuidedSearchResultRefinementAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseQueryExpansionInfo:
// Information describing query expansion including whether expansion
// has occurred.
type GoogleCloudDiscoveryengineV1alphaSearchResponseQueryExpansionInfo struct {
	// ExpandedQuery: Bool describing whether query expansion has occurred.
	ExpandedQuery bool `json:"expandedQuery,omitempty"`

	// PinnedResultCount: Number of pinned results. This field will only be
	// set when expansion happens and
	// SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to
	// true.
	PinnedResultCount int64 `json:"pinnedResultCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ExpandedQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpandedQuery") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseQueryExpansionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseQueryExpansionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult:
// Represents the search results.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult struct {
	// Document: The document data snippet in the search response. Only
	// fields that are marked as retrievable are populated.
	Document *GoogleCloudDiscoveryengineV1alphaDocument `json:"document,omitempty"`

	// Id: Document.id of the searched Document.
	Id string `json:"id,omitempty"`

	// ModelScores: Google provided available scores.
	ModelScores map[string]GoogleCloudDiscoveryengineV1alphaDoubleList `json:"modelScores,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummary: Summary of
// the top N search result specified by the summary spec.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummary struct {
	// SafetyAttributes: A collection of Safety Attribute categories and
	// their associated confidence scores.
	SafetyAttributes *GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes `json:"safetyAttributes,omitempty"`

	// SummarySkippedReasons: Additional summary-skipped reasons. This
	// provides the reason for ignored cases. If nothing is skipped, this
	// field is not set.
	//
	// Possible values:
	//   "SUMMARY_SKIPPED_REASON_UNSPECIFIED" - Default value. The summary
	// skipped reason is not specified.
	//   "ADVERSARIAL_QUERY_IGNORED" - The adversarial query ignored case.
	// Only populated when SummarySpec.ignore_adversarial_query is set to
	// `true`.
	//   "NON_SUMMARY_SEEKING_QUERY_IGNORED" - The non-summary seeking query
	// ignored case. Only populated when
	// SummarySpec.ignore_non_summary_seeking_query is set to `true`.
	//   "OUT_OF_DOMAIN_QUERY_IGNORED" - The out-of-domain query ignored
	// case. Google skips the summary if there are no high-relevance search
	// results. For example, the data store contains facts about company A
	// but the user query is asking questions about company B.
	//   "POTENTIAL_POLICY_VIOLATION" - The potential policy violation case.
	// Google skips the summary if there is a potential policy violation
	// detected. This includes content that may be violent or toxic.
	//   "LLM_ADDON_NOT_ENABLED" - The LLM addon not enabled case. Google
	// skips the summary if the LLM addon is not enabled.
	SummarySkippedReasons []string `json:"summarySkippedReasons,omitempty"`

	// SummaryText: The summary content.
	SummaryText string `json:"summaryText,omitempty"`

	SummaryWithMetadata *GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySummaryWithMetadata `json:"summaryWithMetadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SafetyAttributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SafetyAttributes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitation:
// Citation info for a segment.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitation struct {
	// EndIndex: End of the attributed segment, exclusive.
	EndIndex int64 `json:"endIndex,omitempty,string"`

	// Sources: Citation sources for the attributed segment.
	Sources []*GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationSource `json:"sources,omitempty"`

	// StartIndex: Index indicates the start of the segment, measured in
	// bytes/unicode.
	StartIndex int64 `json:"startIndex,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndIndex") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationMetadata
// : Citation metadata.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationMetadata struct {
	// Citations: Citations for segments.
	Citations []*GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitation `json:"citations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Citations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationSource:
// Citation source.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationSource struct {
	// ReferenceIndex: Document reference index from
	// SummaryWithMetadata.references. It is 0-indexed and the value will be
	// zero if the reference_index is not set explicitly.
	ReferenceIndex int64 `json:"referenceIndex,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ReferenceIndex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ReferenceIndex") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryReference:
// Document reference.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryReference struct {
	// Document: Required. Document.name of the document. Full resource name
	// of the referenced document, in the format
	// `projects/*/locations/*/collections/*/dataStores/*/branches/*/document
	// s/*`.
	Document string `json:"document,omitempty"`

	// Title: Title of the document.
	Title string `json:"title,omitempty"`

	// Uri: Cloud Storage or HTTP uri for the document.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Document") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Document") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes
// : Safety Attribute categories and their associated confidence scores.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes struct {
	// Categories: The display names of Safety Attribute categories
	// associated with the generated content. Order matches the Scores.
	Categories []string `json:"categories,omitempty"`

	// Scores: The confidence scores of the each category, higher value
	// means higher confidence. Order matches the Categories.
	Scores []float64 `json:"scores,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Categories") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySafetyAttributes
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySummaryWithMetad
// ata: Summary with metadata information.
type GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySummaryWithMetadata struct {
	// CitationMetadata: Citation metadata for given summary.
	CitationMetadata *GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryCitationMetadata `json:"citationMetadata,omitempty"`

	// References: Document References.
	References []*GoogleCloudDiscoveryengineV1alphaSearchResponseSummaryReference `json:"references,omitempty"`

	// Summary: Summary text with no citation information.
	Summary string `json:"summary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CitationMetadata") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CitationMetadata") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySummaryWithMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSearchResponseSummarySummaryWithMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSiteSearchEngine: SiteSearchEngine
// captures DataStore level site search persisting configurations. It is
// a singleton value per data store.
type GoogleCloudDiscoveryengineV1alphaSiteSearchEngine struct {
	// Name: The fully qualified resource name of the site search engine.
	// Format: `projects/*/locations/*/dataStores/*/siteSearchEngine`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSiteSearchEngine) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSiteSearchEngine
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo: Verification
// information for target sites in advanced site search.
type GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo struct {
	// SiteVerificationState: Site verification state indicating the
	// ownership and validity.
	//
	// Possible values:
	//   "SITE_VERIFICATION_STATE_UNSPECIFIED" - Defaults to VERIFIED.
	//   "VERIFIED" - Site ownership verified.
	//   "UNVERIFIED" - Site ownership pending verification or verification
	// failed.
	//   "EXEMPTED" - Site exempt from verification, e.g. a public website
	// that opens to all.
	SiteVerificationState string `json:"siteVerificationState,omitempty"`

	// VerifyTime: Latest site verification time.
	VerifyTime string `json:"verifyTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "SiteVerificationState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SiteVerificationState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaSuggestionDenyListEntry: Suggestion
// deny list entry identifying the phrase to block from suggestions and
// the applied operation for the phrase.
type GoogleCloudDiscoveryengineV1alphaSuggestionDenyListEntry struct {
	// BlockPhrase: Required. Phrase to block from suggestions served. Can
	// be maximum 125 characters.
	BlockPhrase string `json:"blockPhrase,omitempty"`

	// MatchOperator: Required. The match operator to apply for this phrase.
	// Whether to block the exact phrase, or block any suggestions
	// containing this phrase.
	//
	// Possible values:
	//   "MATCH_OPERATOR_UNSPECIFIED" - Default value. Should not be used
	//   "EXACT_MATCH" - If the suggestion is an exact match to the
	// block_phrase, then block it.
	//   "CONTAINS" - If the suggestion contains the block_phrase, then
	// block it.
	MatchOperator string `json:"matchOperator,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlockPhrase") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlockPhrase") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaSuggestionDenyListEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaSuggestionDenyListEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSite: A target site for the
// SiteSearchEngine.
type GoogleCloudDiscoveryengineV1alphaTargetSite struct {
	// ExactMatch: Input only. If set to false, a uri_pattern is generated
	// to include all pages whose address contains the provided_uri_pattern.
	// If set to true, an uri_pattern is generated to try to be an exact
	// match of the provided_uri_pattern or just the specific page if the
	// provided_uri_pattern is a specific one. provided_uri_pattern is
	// always normalized to generate the URI pattern to be used by the
	// search engine.
	ExactMatch bool `json:"exactMatch,omitempty"`

	// FailureReason: Output only. Failure reason.
	FailureReason *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason `json:"failureReason,omitempty"`

	// GeneratedUriPattern: Output only. This is system-generated based on
	// the provided_uri_pattern.
	GeneratedUriPattern string `json:"generatedUriPattern,omitempty"`

	// IndexingStatus: Output only. Indexing status.
	//
	// Possible values:
	//   "INDEXING_STATUS_UNSPECIFIED" - Defaults to SUCCEEDED.
	//   "PENDING" - The target site is in the update queue and will be
	// picked up by indexing pipeline.
	//   "FAILED" - The target site fails to be indexed.
	//   "SUCCEEDED" - The target site has been indexed.
	//   "DELETING" - The previously indexed target site has been marked to
	// be deleted. This is a transitioning state which will resulted in
	// either: 1. target site deleted if unindexing is successful; 2. state
	// reverts to SUCCEEDED if the unindexing fails.
	IndexingStatus string `json:"indexingStatus,omitempty"`

	// Name: Output only. The fully qualified resource name of the target
	// site.
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/siteSearchEngine/targetSites/{target_site}` The
	// `target_site_id` is system-generated.
	Name string `json:"name,omitempty"`

	// ProvidedUriPattern: Required. Input only. The user provided URI
	// pattern from which the `generated_uri_pattern` is generated.
	ProvidedUriPattern string `json:"providedUriPattern,omitempty"`

	// SiteVerificationInfo: Output only. Site ownership and validity
	// verification status.
	SiteVerificationInfo *GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo `json:"siteVerificationInfo,omitempty"`

	// Type: The type of the target site, e.g. whether the site is to be
	// included or excluded.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - This value is unused. In this case, server
	// behavior defaults to Type.INCLUDE.
	//   "INCLUDE" - Include the target site.
	//   "EXCLUDE" - Exclude the target site.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The target site's last updated time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExactMatch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExactMatch") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTargetSite) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSite
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason: Site search
// indexing failure reasons.
type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason struct {
	// QuotaFailure: Failed due to insufficient quota.
	QuotaFailure *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure `json:"quotaFailure,omitempty"`

	// ForceSendFields is a list of field names (e.g. "QuotaFailure") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "QuotaFailure") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure struct {
}

// GoogleCloudDiscoveryengineV1alphaTextInput: Defines text input.
type GoogleCloudDiscoveryengineV1alphaTextInput struct {
	// Context: Conversation context of the input.
	Context *GoogleCloudDiscoveryengineV1alphaConversationContext `json:"context,omitempty"`

	// Input: Text input.
	Input string `json:"input,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTextInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata: Metadata
// related to the progress of the TrainCustomModel operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest: Request
// message for SearchTuningService.TrainCustomModel method.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest struct {
	// ErrorConfig: The desired location of errors incurred during the data
	// ingestion and training.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// GcsTrainingInput: Cloud Storage training input.
	GcsTrainingInput *GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequestGcsTrainingInput `json:"gcsTrainingInput,omitempty"`

	// ModelType: Model to be trained. Supported values are: *
	// **search-tuning**: Fine tuning the search system based on data
	// provided.
	ModelType string `json:"modelType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequestGcsTrainingInp
// ut: Cloud Storage training data input.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequestGcsTrainingInput struct {
	// CorpusDataPath: The Cloud Storage corpus data which could be
	// associated in train data. The data path format is gs:///. A newline
	// delimited jsonl/ndjson file. For search-tuning model, each line
	// should have the _id, title and text. Example: {"_id": "doc1", title:
	// "relevant doc", "text": "relevant text"}
	CorpusDataPath string `json:"corpusDataPath,omitempty"`

	// QueryDataPath: The gcs query data which could be associated in train
	// data. The data path format is gs:///. A newline delimited
	// jsonl/ndjson file. For search-tuning model, each line should have the
	// _id and text. Example: {"_id": "query1", "text": "example query"}
	QueryDataPath string `json:"queryDataPath,omitempty"`

	// TestDataPath: Cloud Storage test data. Same format as
	// train_data_path. If not provided, a random 80/20 train/test split
	// will be performed on train_data_path.
	TestDataPath string `json:"testDataPath,omitempty"`

	// TrainDataPath: Cloud Storage training data path whose format should
	// be gs:///. The file should be in tsv format. Each line should have
	// the doc_id and query_id and score (number). For search-tuning model,
	// it should have the query-id corpus-id score as tsv file header. The
	// score should be a number in [0, inf+). The larger the number is, the
	// more relevant the pair is. Example: query-id\tcorpus-id\tscore
	// query1\tdoc1\t1
	TrainDataPath string `json:"trainDataPath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CorpusDataPath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CorpusDataPath") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequestGcsTrainingInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequestGcsTrainingInput
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse: Response
// of the TrainCustomModelRequest. This message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1alphaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// data.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ModelStatus: The trained model status. Possible values are: *
	// **bad-data**: The training data quality is bad. * **no-improvement**:
	// Tuning didn't improve performance. Won't deploy. * **in-progress**:
	// Model training is in progress. * **ready**: The model is ready for
	// serving.
	ModelStatus string `json:"modelStatus,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTransactionInfo: A transaction
// represents the entire purchase transaction.
type GoogleCloudDiscoveryengineV1alphaTransactionInfo struct {
	// Cost: All the costs associated with the products. These can be
	// manufacturing costs, shipping expenses not borne by the end user, or
	// any other costs, such that: * Profit = value - tax - cost
	Cost float64 `json:"cost,omitempty"`

	// Currency: Required. Currency code. Use three-character ISO-4217 code.
	Currency string `json:"currency,omitempty"`

	// DiscountValue: The total discount(s) value applied to this
	// transaction. This figure should be excluded from
	// TransactionInfo.value For example, if a user paid
	// TransactionInfo.value amount, then nominal (pre-discount) value of
	// the transaction is the sum of TransactionInfo.value and
	// TransactionInfo.discount_value This means that profit is calculated
	// the same way, regardless of the discount value, and that
	// TransactionInfo.discount_value can be larger than
	// TransactionInfo.value: * Profit = value - tax - cost
	DiscountValue float64 `json:"discountValue,omitempty"`

	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`

	// TransactionId: The transaction ID with a length limit of 128
	// characters.
	TransactionId string `json:"transactionId,omitempty"`

	// Value: Required. Total non-zero value associated with the
	// transaction. This value may include shipping, tax, or other
	// adjustments to the total value that you want to include.
	Value float64 `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTransactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTransactionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDiscoveryengineV1alphaTransactionInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTransactionInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		DiscountValue gensupport.JSONFloat64 `json:"discountValue"`
		Tax           gensupport.JSONFloat64 `json:"tax"`
		Value         gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.DiscountValue = float64(s1.DiscountValue)
	s.Tax = float64(s1.Tax)
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata: Metadata
// associated with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata struct {
	// Engine: Required. The resource name of the engine that this tune
	// applies to. Format:
	// `projects/{project_number}/locations/{location_id}/collections/{collec
	// tion_id}/engines/{engine_id}`
	Engine string `json:"engine,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Engine") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineRequest: Request to
// manually start a tuning process now (instead of waiting for the
// periodically scheduled tuning to happen).
type GoogleCloudDiscoveryengineV1alphaTuneEngineRequest struct {
}

// GoogleCloudDiscoveryengineV1alphaTuneEngineResponse: Response
// associated with a tune operation.
type GoogleCloudDiscoveryengineV1alphaTuneEngineResponse struct {
}

// GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata: Metadata
// related to the progress of the
// SiteSearchEngineService.UpdateTargetSite operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUserEvent: UserEvent captures all
// metadata information Discovery Engine API needs to know about how end
// users interact with customers' website.
type GoogleCloudDiscoveryengineV1alphaUserEvent struct {
	// Attributes: Extra user event features to include in the
	// recommendation model. These attributes must NOT contain data that
	// needs to be parsed or processed further, e.g. JSON or other
	// encodings. If you provide custom attributes for ingested user events,
	// also include them in the user events that you associate with
	// prediction requests. Custom attribute formatting must be consistent
	// between imported events and events provided with prediction requests.
	// This lets the Discovery Engine API use those custom attributes when
	// training models and serving predictions, which helps improve
	// recommendation quality. This field needs to pass all below criteria,
	// otherwise an `INVALID_ARGUMENT` error is returned: * The key must be
	// a UTF-8 encoded string with a length limit of 5,000 characters. * For
	// text attributes, at most 400 values are allowed. Empty values are not
	// allowed. Each value must be a UTF-8 encoded string with a length
	// limit of 256 characters. * For number attributes, at most 400 values
	// are allowed. For product recommendations, an example of extra user
	// information is `traffic_channel`, which is how a user arrives at the
	// site. Users can arrive at the site by coming to the site directly,
	// coming through Google search, or in other ways.
	Attributes map[string]GoogleCloudDiscoveryengineV1alphaCustomAttribute `json:"attributes,omitempty"`

	// AttributionToken: Token to attribute an API response to user
	// action(s) to trigger the event. Highly recommended for user events
	// that are the result of RecommendationService.Recommend. This field
	// enables accurate attribution of recommendation model performance. The
	// value must be one of: * RecommendResponse.attribution_token for
	// events that are the result of RecommendationService.Recommend. *
	// SearchResponse.attribution_token for events that are the result of
	// SearchService.Search. This token enables us to accurately attribute
	// page view or conversion completion back to the event and the
	// particular predict response containing this clicked/purchased
	// product. If user clicks on product K in the recommendation results,
	// pass RecommendResponse.attribution_token as a URL parameter to
	// product K's page. When recording events on product K's page, log the
	// RecommendResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CompletionInfo: CompletionService.CompleteQuery details related to
	// the event. This field should be set for `search` event when
	// autocomplete function is enabled and the user clicks a suggestion for
	// search.
	CompletionInfo *GoogleCloudDiscoveryengineV1alphaCompletionInfo `json:"completionInfo,omitempty"`

	// DirectUserRequest: Should set to true if the request is made directly
	// from the end user, in which case the UserEvent.user_info.user_agent
	// can be populated from the HTTP request. This flag should be set only
	// if the API request is made directly from the end user such as a
	// mobile app (and not if a gateway or a server is processing and
	// pushing the user events). This should not be set when using the
	// JavaScript tag in UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`

	// Documents: List of Documents associated with this user event. This
	// field is optional except for the following event types: * `view-item`
	// * `add-to-cart` * `purchase` * `media-play` * `media-complete` In a
	// `search` event, this field represents the documents returned to the
	// end user on the current page (the end user may have not finished
	// browsing the whole page yet). When a new page is returned to the end
	// user, after pagination/filtering/ordering even for the same query, a
	// new `search` event with different UserEvent.documents is desired.
	Documents []*GoogleCloudDiscoveryengineV1alphaDocumentInfo `json:"documents,omitempty"`

	// EventTime: Only required for UserEventService.ImportUserEvents
	// method. Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`

	// EventType: Required. User event type. Allowed values are: Generic
	// values: * `search`: Search for Documents. * `view-item`: Detailed
	// page view of a Document. * `view-item-list`: View of a panel or
	// ordered list of Documents. * `view-home-page`: View of the home page.
	// * `view-category-page`: View of a category page, e.g. Home > Men >
	// Jeans Retail-related values: * `add-to-cart`: Add an item(s) to cart,
	// e.g. in Retail online shopping * `purchase`: Purchase an item(s)
	// Media-related values: * `media-play`: Start/resume watching a video,
	// playing a song, etc. * `media-complete`: Finished or stopped midway
	// through a video, song, etc.
	EventType string `json:"eventType,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the documents
	// being filtered. One example is for `search` events, the associated
	// SearchRequest may contain a filter expression in SearchRequest.filter
	// conforming to https://google.aip.dev/160#filtering. Similarly, for
	// `view-item-list` events that are generated from a RecommendRequest,
	// this field may be populated directly from RecommendRequest.filter
	// conforming to https://google.aip.dev/160#filtering. The value must be
	// a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	Filter string `json:"filter,omitempty"`

	// MediaInfo: Media-specific info.
	MediaInfo *GoogleCloudDiscoveryengineV1alphaMediaInfo `json:"mediaInfo,omitempty"`

	// PageInfo: Page metadata such as categories and other critical
	// information for certain event types such as `view-category-page`.
	PageInfo *GoogleCloudDiscoveryengineV1alphaPageInfo `json:"pageInfo,omitempty"`

	// Panel: Panel metadata associated with this user event.
	Panel *GoogleCloudDiscoveryengineV1alphaPanelInfo `json:"panel,omitempty"`

	// PromotionIds: The promotion IDs if this is an event associated with
	// promotions. Currently, this field is restricted to at most one ID.
	PromotionIds []string `json:"promotionIds,omitempty"`

	// SearchInfo: SearchService.Search details related to the event. This
	// field should be set for `search` event.
	SearchInfo *GoogleCloudDiscoveryengineV1alphaSearchInfo `json:"searchInfo,omitempty"`

	// SessionId: A unique identifier for tracking a visitor session with a
	// length limit of 128 bytes. A session is an aggregation of an end user
	// behavior in a time span. A general guideline to populate the
	// session_id: 1. If user has no activity for 30 min, a new session_id
	// should be assigned. 2. The session_id should be unique across users,
	// suggest use uuid or add UserEvent.user_pseudo_id as prefix.
	SessionId string `json:"sessionId,omitempty"`

	// TagIds: A list of identifiers for the independent experiment groups
	// this user event belongs to. This is used to distinguish between user
	// events associated with different experiment setups on the customer
	// end.
	TagIds []string `json:"tagIds,omitempty"`

	// TransactionInfo: The transaction metadata (if any) associated with
	// this user event.
	TransactionInfo *GoogleCloudDiscoveryengineV1alphaTransactionInfo `json:"transactionInfo,omitempty"`

	// UserInfo: Information about the end user.
	UserInfo *GoogleCloudDiscoveryengineV1alphaUserInfo `json:"userInfo,omitempty"`

	// UserPseudoId: Required. A unique identifier for tracking visitors.
	// For example, this could be implemented with an HTTP cookie, which
	// should be able to uniquely identify a visitor on a single device.
	// This unique identifier should not change if the visitor log in/out of
	// the website. Do not set the field to the same fixed ID for different
	// users. This mixes the event history of those users together, which
	// results in degraded model quality. The field must be a UTF-8 encoded
	// string with a length limit of 128 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned. The field should not contain
	// PII or user-data. We recommend to use Google Analytics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	UserPseudoId string `json:"userPseudoId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaUserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUserEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaUserInfo: Information of an end
// user.
type GoogleCloudDiscoveryengineV1alphaUserInfo struct {
	// UserAgent: User agent as included in the HTTP header. The field must
	// be a UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an `INVALID_ARGUMENT` error is returned. This should not
	// be set when using the client side event reporting with GTM or
	// JavaScript tag in UserEventService.CollectUserEvent or if
	// UserEvent.direct_user_request is set.
	UserAgent string `json:"userAgent,omitempty"`

	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. Don't set for anonymous users.
	// Always use a hashed value for this ID. Don't set the field to the
	// same fixed ID for different users. This mixes the event history of
	// those users together, which results in degraded model quality. The
	// field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserAgent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserAgent") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaUserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest: Request
// message for WidgetService.WidgetCompleteQuery method.
type GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest struct {
	// AdditionalParams: Additional params for security and privacy
	// enhancement.
	AdditionalParams *GoogleCloudDiscoveryengineV1alphaAdditionalParams `json:"additionalParams,omitempty"`

	// CompleteQueryRequest: Required. The CompleteQuery request to perform
	// auto-complete suggestion query.
	CompleteQueryRequest *GoogleCloudDiscoveryengineV1alphaCompleteQueryRequest `json:"completeQueryRequest,omitempty"`

	// ConfigId: Required. The UUID of the WidgetConfig. This field is used
	// to identify the widget configuration, set of models used to make the
	// auto complete query.
	ConfigId string `json:"configId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalParams") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse:
// Response message for WidgetService.WidgetCompleteQuery method.
type GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse struct {
	// UToken: The token in response.
	UToken string `json:"uToken,omitempty"`

	// WidgetQuerySuggestions: Results of the matched query suggestions in
	// widget. The result list is ordered and the first result is a top
	// suggestion.
	WidgetQuerySuggestions []*GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponseWidgetQuerySuggestion `json:"widgetQuerySuggestions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UToken") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponseWidgetQuer
// ySuggestion: Suggestions as search queries.
type GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponseWidgetQuerySuggestion struct {
	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Suggestion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Suggestion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponseWidgetQuerySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponseWidgetQuerySuggestion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetConfig: WidgetConfig captures
// configs at the Widget level.
type GoogleCloudDiscoveryengineV1alphaWidgetConfig struct {
	// AllowPublicAccess: Whether allow no-auth integration with widget. If
	// set true, public access to search or other solutions from widget is
	// allowed without authenication token provided by customer hosted
	// backend server.
	AllowPublicAccess bool `json:"allowPublicAccess,omitempty"`

	// AllowlistedDomains: Allowlisted domains that can load this widget.
	AllowlistedDomains []string `json:"allowlistedDomains,omitempty"`

	// ConfigId: Output only. Unique obfuscated identifier of a
	// WidgetConfig.
	ConfigId string `json:"configId,omitempty"`

	// ContentSearchSpec: The content search spec that configs the desired
	// behavior of content search.
	ContentSearchSpec *GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec `json:"contentSearchSpec,omitempty"`

	// CreateTime: Output only. Timestamp the WidgetConfig was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataStoreType: Output only. The type of the parent data store.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Unspecified data store type.
	//   "SITE_SEARCH" - The parent data store contains a site search
	// engine.
	//   "STRUCTURED" - The parent data store contains a search engine for
	// structured data.
	//   "UNSTRUCTURED" - The parent data store contains a search engine for
	// unstructured data.
	//   "BLENDED" - The parent data store is served for blended search with
	// multiple data stores.
	DataStoreType string `json:"dataStoreType,omitempty"`

	// DisplayName: Required. The human readable widget config display name.
	// Used in Discovery UI. This field must be a UTF-8 encoded string with
	// a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	DisplayName string `json:"displayName,omitempty"`

	// EnableAutocomplete: Whether or not to enable autocomplete.
	EnableAutocomplete bool `json:"enableAutocomplete,omitempty"`

	// EnableConversationalSearch: Whether to allow conversational search
	// (LLM, multi-turn) or not (non-LLM, single-turn).
	EnableConversationalSearch bool `json:"enableConversationalSearch,omitempty"`

	// EnableQualityFeedback: Turn on or off collecting the search result
	// quality feedback from end users.
	EnableQualityFeedback bool `json:"enableQualityFeedback,omitempty"`

	// EnableResultScore: Whether to show the result score.
	EnableResultScore bool `json:"enableResultScore,omitempty"`

	// EnableSafeSearch: Whether to enable safe search.
	EnableSafeSearch bool `json:"enableSafeSearch,omitempty"`

	// EnableSnippetResultSummary: Turn on or off summary for each snippets
	// result.
	EnableSnippetResultSummary bool `json:"enableSnippetResultSummary,omitempty"`

	// EnableSummarization: Turn on or off summarization for the search
	// response.
	EnableSummarization bool `json:"enableSummarization,omitempty"`

	// FacetField: The configuration and appearance of facets in the end
	// user view.
	FacetField []*GoogleCloudDiscoveryengineV1alphaWidgetConfigFacetField `json:"facetField,omitempty"`

	// FieldsUiComponentsMap: The key is the UI component. Mock. Currently
	// supported `title`, `thumbnail`, `url`, `custom1`, `custom2`,
	// `custom3`. The value is the name of the field along with its device
	// visibility. The 3 custom fields are optional and can be added or
	// removed. `title`, `thumbnail`, `url` are required UI components that
	// cannot be removed.
	FieldsUiComponentsMap map[string]GoogleCloudDiscoveryengineV1alphaWidgetConfigUIComponentField `json:"fieldsUiComponentsMap,omitempty"`

	// LlmEnabled: Output only. Whether LLM is enabled in the corresponding
	// data store.
	LlmEnabled bool `json:"llmEnabled,omitempty"`

	// MinimumDataTermAccepted: Output only. Whether the customer accepted
	// data use terms.
	MinimumDataTermAccepted bool `json:"minimumDataTermAccepted,omitempty"`

	// Name: Immutable. The full resource name of the widget config. Format:
	// `projects/{project}/locations/{location}/collections/{collection_id}/d
	// ataStores/{data_store_id}/widgetConfigs/{widget_config_id}`. This
	// field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `json:"name,omitempty"`

	// ResultDisplayType: The type of snippet to display in UCS widget. -
	// RESULT_DISPLAY_TYPE_UNSPECIFIED for existing users. - SNIPPET for new
	// non-enterprise search users. - EXTRACTIVE_ANSWER for new enterprise
	// search users.
	//
	// Possible values:
	//   "RESULT_DISPLAY_TYPE_UNSPECIFIED" - Unspecified display type
	// (default to showing snippet).
	//   "SNIPPET" - Display results from the snippet field.
	//   "EXTRACTIVE_ANSWER" - Display results from extractive answers
	// field.
	ResultDisplayType string `json:"resultDisplayType,omitempty"`

	// SolutionType: Required. Immutable. Specifies the solution type that
	// this WidgetConfig can be used for.
	//
	// Possible values:
	//   "SOLUTION_TYPE_UNSPECIFIED" - Default value.
	//   "SOLUTION_TYPE_RECOMMENDATION" - Used for Recommendations AI.
	//   "SOLUTION_TYPE_SEARCH" - Used for Discovery Search.
	//   "SOLUTION_TYPE_CHAT" - Used for use cases related to the Generative
	// AI agent.
	SolutionType string `json:"solutionType,omitempty"`

	// UpdateTime: Output only. Timestamp the WidgetConfig was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowPublicAccess")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowPublicAccess") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetConfigFacetField: Facet fields
// that store the mapping of fields to end user widget appearance.
type GoogleCloudDiscoveryengineV1alphaWidgetConfigFacetField struct {
	// DisplayName: Optional. The field name that end users will see.
	DisplayName string `json:"displayName,omitempty"`

	// Field: Required. Registered field name. The format is `field.abc`.
	Field string `json:"field,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetConfigFacetField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetConfigFacetField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetConfigUIComponentField: Facet
// field that maps to a UI Component.
type GoogleCloudDiscoveryengineV1alphaWidgetConfigUIComponentField struct {
	// DeviceVisibility: The field visibility on different types of devices.
	//
	// Possible values:
	//   "DEVICE_VISIBILITY_UNSPECIFIED" - Default value when not specified.
	// Server returns INVALID_ARGUMENT if used in requests.
	//   "MOBILE" - The UI component is visible on Mobile devices.
	//   "DESKTOP" - The UI component is visible on Browser-based client.
	DeviceVisibility []string `json:"deviceVisibility,omitempty"`

	// DisplayTemplate: The template to customize how the field is
	// displayed. An example value would be a string that looks like:
	// "Price: {value}".
	DisplayTemplate string `json:"displayTemplate,omitempty"`

	// Field: Required. Registered field name. The format is `field.abc`.
	Field string `json:"field,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceVisibility") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceVisibility") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetConfigUIComponentField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetConfigUIComponentField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest:
// Request message for WidgetService.WidgetConverseConversation method.
type GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest struct {
	// AdditionalParams: Additional params for security and privacy
	// enhancement.
	AdditionalParams *GoogleCloudDiscoveryengineV1alphaAdditionalParams `json:"additionalParams,omitempty"`

	// ConfigId: Required. The UUID of the WidgetConfig. This field is used
	// to identify the widget configuration, set of models used to make the
	// user event collection.
	ConfigId string `json:"configId,omitempty"`

	// ConversationId: The id of the Conversation to get. Use "-" to
	// activate auto session mode, which automatically creates a new
	// conversation inside a ConverseConversation session.
	ConversationId string `json:"conversationId,omitempty"`

	// ConverseConversationRequest: Required. The
	// ConverseConversationRequest request to perform converse a
	// conversation. The ServingConfig id will be `default_search` by
	// default.
	ConverseConversationRequest *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest `json:"converseConversationRequest,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalParams") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse:
// Response message for WidgetService.WidgetConverseConversation method.
type GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse struct {
	// ConversationId: The id of the Conversation returned.
	ConversationId string `json:"conversationId,omitempty"`

	// ConverseConversationResponse: ConverseConversationResponse returned
	// from ConversationalSearchService.ConverseConversation.
	ConverseConversationResponse *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse `json:"converseConversationResponse,omitempty"`

	// UToken: The token in response.
	UToken string `json:"uToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConversationId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversationId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest: Request message
// for WidgetService.WidgetSearch method.
type GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest struct {
	// AdditionalParams: Additional params for security and privacy
	// enhancement.
	AdditionalParams *GoogleCloudDiscoveryengineV1alphaAdditionalParams `json:"additionalParams,omitempty"`

	// ConfigId: Required. The UUID of the Search WidgetConfig. This field
	// is used to identify the search widget configuration, set of models
	// used to make the search.
	ConfigId string `json:"configId,omitempty"`

	// SearchRequest: Required. The search request to perform search.
	SearchRequest *GoogleCloudDiscoveryengineV1alphaSearchRequest `json:"searchRequest,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdditionalParams") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalParams") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse: Response
// message for WidgetService.WidgetSearch method.
type GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse struct {
	// SearchResponse: The search response after performing search.
	SearchResponse *GoogleCloudDiscoveryengineV1alphaSearchResponse `json:"searchResponse,omitempty"`

	// UToken: The token in response.
	UToken string `json:"uToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SearchResponse") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SearchResponse") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata: Metadata for
// Create Schema LRO.
type GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata: Metadata for
// DeleteSchema LRO.
type GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata: Metadata
// related to the progress of the ImportDocuments operation. This is
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportDocumentsResponse: Response of
// the ImportDocumentsRequest. If the long running operation is done,
// then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1betaImportDocumentsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportErrorConfig: Configuration of
// destination for Import related errors.
type GoogleCloudDiscoveryengineV1betaImportErrorConfig struct {
	// GcsPrefix: Cloud Storage prefix for import errors. This must be an
	// empty, existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportErrorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportErrorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadat
// a: Metadata related to the progress of the
// ImportSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesRespons
// e: Response message for
// CompletionService.ImportSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// FailedEntriesCount: Count of deny list entries that failed to be
	// imported.
	FailedEntriesCount int64 `json:"failedEntriesCount,omitempty,string"`

	// ImportedEntriesCount: Count of deny list entries successfully
	// imported.
	ImportedEntriesCount int64 `json:"importedEntriesCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata: Metadata
// related to the progress of the Import operation. This is returned by
// the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaImportUserEventsResponse: Response of
// the ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudDiscoveryengineV1betaImportUserEventsResponse struct {
	// ErrorConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorConfig *GoogleCloudDiscoveryengineV1betaImportErrorConfig `json:"errorConfig,omitempty"`

	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// JoinedEventsCount: Count of user events imported with complete
	// existing Documents.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with Document
	// information not found in the existing Branch.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata: Metadata
// related to the progress of the PurgeDocuments operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// SuccessCount: Count of entries that were deleted successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse: Response
// message for DocumentService.PurgeDocuments method. If the long
// running operation is successfully done, then this message is returned
// by the google.longrunning.Operations.response field.
type GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse struct {
	// PurgeCount: The total count of documents purged as a result of the
	// operation.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// PurgeSample: A sample of document names that will be deleted. Only
	// populated if `force` is set to false. A max of 100 names will be
	// returned and the names are chosen at random.
	PurgeSample []string `json:"purgeSample,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PurgeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgeCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata
// : Metadata related to the progress of the
// PurgeSuggestionDenyListEntries operation. This is returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse
// : Response message for
// CompletionService.PurgeSuggestionDenyListEntries method.
type GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// PurgeCount: Number of suggestion deny list entries purged.
	PurgeCount int64 `json:"purgeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaSchema: Defines the structure and
// layout of a type of document data.
type GoogleCloudDiscoveryengineV1betaSchema struct {
	// JsonSchema: The JSON representation of the schema.
	JsonSchema string `json:"jsonSchema,omitempty"`

	// Name: Immutable. The full resource name of the schema, in the format
	// of
	// `projects/{project}/locations/{location}/collections/{collection}/data
	// Stores/{data_store}/schemas/{schema}`. This field must be a UTF-8
	// encoded string with a length limit of 1024 characters.
	Name string `json:"name,omitempty"`

	// StructSchema: The structured representation of the schema.
	StructSchema googleapi.RawMessage `json:"structSchema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JsonSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JsonSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata: Metadata for
// UpdateSchema LRO.
type GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values. * A month and day, with a
// zero year (for example, an anniversary). * A year on its own, with a
// zero month and a zero day. * A year and month, with a zero day (for
// example, a credit card expiration date). Related types: *
// google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "discoveryengine.locations.lookupWidgetConfig":

type LocationsLookupWidgetConfigCall struct {
	s                                                          *Service
	location                                                   string
	googleclouddiscoveryenginev1alphalookupwidgetconfigrequest *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// LookupWidgetConfig: Gets the Widget Config using the uuid.
//
//   - location: The location resource where lookup widget will be
//     performed. Format: `locations/{location}`.
func (r *LocationsService) LookupWidgetConfig(location string, googleclouddiscoveryenginev1alphalookupwidgetconfigrequest *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest) *LocationsLookupWidgetConfigCall {
	c := &LocationsLookupWidgetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googleclouddiscoveryenginev1alphalookupwidgetconfigrequest = googleclouddiscoveryenginev1alphalookupwidgetconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsLookupWidgetConfigCall) Fields(s ...googleapi.Field) *LocationsLookupWidgetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsLookupWidgetConfigCall) Context(ctx context.Context) *LocationsLookupWidgetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsLookupWidgetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsLookupWidgetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphalookupwidgetconfigrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+location}/lookupWidgetConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.locations.lookupWidgetConfig" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse.ServerRes
// ponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsLookupWidgetConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the Widget Config using the uuid.",
	//   "flatPath": "v1alpha/locations/{locationsId}/lookupWidgetConfig",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.locations.lookupWidgetConfig",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "location": {
	//       "description": "Required. The location resource where lookup widget will be performed. Format: `locations/{location}`",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+location}/lookupWidgetConfig",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaLookupWidgetConfigResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.locations.widgetCompleteQuery":

type LocationsWidgetCompleteQueryCall struct {
	s                                                           *Service
	location                                                    string
	googleclouddiscoveryenginev1alphawidgetcompletequeryrequest *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// WidgetCompleteQuery: Performs a user input completion with keyword
// suggestion. Similar to the CompletionService.CompleteQuery method,
// but a widget version that allows CompleteQuery without API Key. It
// supports CompleteQuery with or without JWT token.
//
//   - location: The location resource where widget complete query will be
//     performed. Format: `locations/{location}`.
func (r *LocationsService) WidgetCompleteQuery(location string, googleclouddiscoveryenginev1alphawidgetcompletequeryrequest *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest) *LocationsWidgetCompleteQueryCall {
	c := &LocationsWidgetCompleteQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googleclouddiscoveryenginev1alphawidgetcompletequeryrequest = googleclouddiscoveryenginev1alphawidgetcompletequeryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsWidgetCompleteQueryCall) Fields(s ...googleapi.Field) *LocationsWidgetCompleteQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsWidgetCompleteQueryCall) Context(ctx context.Context) *LocationsWidgetCompleteQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsWidgetCompleteQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsWidgetCompleteQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphawidgetcompletequeryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+location}/widgetCompleteQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.locations.widgetCompleteQuery" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsWidgetCompleteQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs a user input completion with keyword suggestion. Similar to the CompletionService.CompleteQuery method, but a widget version that allows CompleteQuery without API Key. It supports CompleteQuery with or without JWT token.",
	//   "flatPath": "v1alpha/locations/{locationsId}/widgetCompleteQuery",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.locations.widgetCompleteQuery",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "location": {
	//       "description": "Required. The location resource where widget complete query will be performed. Format: `locations/{location}`",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+location}/widgetCompleteQuery",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetCompleteQueryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.locations.widgetConverseConversation":

type LocationsWidgetConverseConversationCall struct {
	s                                                                  *Service
	location                                                           string
	googleclouddiscoveryenginev1alphawidgetconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest
	urlParams_                                                         gensupport.URLParams
	ctx_                                                               context.Context
	header_                                                            http.Header
}

// WidgetConverseConversation: Converse a conversation with Widget.
//
//   - location: The location resource where widget converse conversation
//     will be performed. Format: `locations/{location}`.
func (r *LocationsService) WidgetConverseConversation(location string, googleclouddiscoveryenginev1alphawidgetconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest) *LocationsWidgetConverseConversationCall {
	c := &LocationsWidgetConverseConversationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googleclouddiscoveryenginev1alphawidgetconverseconversationrequest = googleclouddiscoveryenginev1alphawidgetconverseconversationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsWidgetConverseConversationCall) Fields(s ...googleapi.Field) *LocationsWidgetConverseConversationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsWidgetConverseConversationCall) Context(ctx context.Context) *LocationsWidgetConverseConversationCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsWidgetConverseConversationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsWidgetConverseConversationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphawidgetconverseconversationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+location}/widgetConverseConversation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.locations.widgetConverseConversation" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse.S
// erverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsWidgetConverseConversationCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Converse a conversation with Widget.",
	//   "flatPath": "v1alpha/locations/{locationsId}/widgetConverseConversation",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.locations.widgetConverseConversation",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "location": {
	//       "description": "Required. The location resource where widget converse conversation will be performed. Format: `locations/{location}`",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+location}/widgetConverseConversation",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetConverseConversationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.locations.widgetSearch":

type LocationsWidgetSearchCall struct {
	s                                                    *Service
	location                                             string
	googleclouddiscoveryenginev1alphawidgetsearchrequest *GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// WidgetSearch: Performs a search. Similar to the SearchService.Search
// method, but a widget version that allows search without API Key. It
// supports search with or without JWT token.
//
//   - location: The location resource where widget search will be
//     performed. Format: `locations/{location}`.
func (r *LocationsService) WidgetSearch(location string, googleclouddiscoveryenginev1alphawidgetsearchrequest *GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest) *LocationsWidgetSearchCall {
	c := &LocationsWidgetSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googleclouddiscoveryenginev1alphawidgetsearchrequest = googleclouddiscoveryenginev1alphawidgetsearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsWidgetSearchCall) Fields(s ...googleapi.Field) *LocationsWidgetSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsWidgetSearchCall) Context(ctx context.Context) *LocationsWidgetSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsWidgetSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsWidgetSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphawidgetsearchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+location}/widgetSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.locations.widgetSearch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsWidgetSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs a search. Similar to the SearchService.Search method, but a widget version that allows search without API Key. It supports search with or without JWT token.",
	//   "flatPath": "v1alpha/locations/{locationsId}/widgetSearch",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.locations.widgetSearch",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "location": {
	//       "description": "Required. The location resource where widget search will be performed. Format: `locations/{location}`",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+location}/widgetSearch",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetSearchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaWidgetSearchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.estimateDataSize":

type ProjectsLocationsEstimateDataSizeCall struct {
	s                                                        *Service
	location                                                 string
	googleclouddiscoveryenginev1alphaestimatedatasizerequest *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// EstimateDataSize: Estimates the data size to be used by a customer.
//
//   - location: Full resource name of the Location, such as
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsService) EstimateDataSize(location string, googleclouddiscoveryenginev1alphaestimatedatasizerequest *GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest) *ProjectsLocationsEstimateDataSizeCall {
	c := &ProjectsLocationsEstimateDataSizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googleclouddiscoveryenginev1alphaestimatedatasizerequest = googleclouddiscoveryenginev1alphaestimatedatasizerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEstimateDataSizeCall) Fields(s ...googleapi.Field) *ProjectsLocationsEstimateDataSizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEstimateDataSizeCall) Context(ctx context.Context) *ProjectsLocationsEstimateDataSizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEstimateDataSizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEstimateDataSizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaestimatedatasizerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+location}:estimateDataSize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.estimateDataSize" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEstimateDataSizeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Estimates the data size to be used by a customer.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}:estimateDataSize",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.estimateDataSize",
	//   "parameterOrder": [
	//     "location"
	//   ],
	//   "parameters": {
	//     "location": {
	//       "description": "Required. Full resource name of the Location, such as `projects/{project}/locations/{location}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+location}:estimateDataSize",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEstimateDataSizeRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataConnector.operations.get":

type ProjectsLocationsCollectionsDataConnectorOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataConnectorOperationsService) Get(name string) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataConnectorOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataConnectorOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataConnector.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataConnector/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataConnector.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataConnector/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataConnector.operations.list":

type ProjectsLocationsCollectionsDataConnectorOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataConnectorOperationsService) List(name string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c := &ProjectsLocationsCollectionsDataConnectorOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataConnectorOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataConnector.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataConnector/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataConnector.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataConnector$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataConnectorOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.completeQuery":

type ProjectsLocationsCollectionsDataStoresCompleteQueryCall struct {
	s            *Service
	dataStore    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CompleteQuery: Completes the specified user input with keyword
// suggestions.
//
//   - dataStore: The parent data store resource name for which the
//     completion is performed, such as
//     `projects/*/locations/global/collections/default_collection/dataStor
//     es/default_data_store`.
func (r *ProjectsLocationsCollectionsDataStoresService) CompleteQuery(dataStore string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c := &ProjectsLocationsCollectionsDataStoresCompleteQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataStore = dataStore
	return c
}

// IncludeTailSuggestions sets the optional parameter
// "includeTailSuggestions": Indicates if tail suggestions should be
// returned if there are no suggestions that match the full query. Even
// if set to true, if there are suggestions that match the full query,
// those are returned and no tail suggestions are returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) IncludeTailSuggestions(includeTailSuggestions bool) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("includeTailSuggestions", fmt.Sprint(includeTailSuggestions))
	return c
}

// Query sets the optional parameter "query": Required. The typeahead
// input used to fetch suggestions. Maximum length is 128 characters.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Query(query string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("query", query)
	return c
}

// QueryModel sets the optional parameter "queryModel": Selects data
// model of query suggestions for serving. Currently supported values: *
// `document` - Using suggestions generated from user-imported
// documents. * `search-history` - Using suggestions generated from the
// past history of SearchService.Search API calls. Do not use it when
// there is no traffic for Search API. * `user-event` - Using
// suggestions generated from user-imported search events. *
// `document-completable` - Using suggestions taken directly from
// user-imported document fields marked as completable. Default values:
// * `document` is the default model for regular dataStores. *
// `search-history` is the default model for site search dataStores.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) QueryModel(queryModel string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("queryModel", queryModel)
	return c
}

// UserPseudoId sets the optional parameter "userPseudoId": A unique
// identifier for tracking visitors. For example, this could be
// implemented with an HTTP cookie, which should be able to uniquely
// identify a visitor on a single device. This unique identifier should
// not change if the visitor logs in or out of the website. This field
// should NOT have a fixed value such as `unknown_visitor`. This should
// be the same identifier as UserEvent.user_pseudo_id and
// SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded
// string with a length limit of 128 characters. Otherwise, an
// `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) UserPseudoId(userPseudoId string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("userPseudoId", userPseudoId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCompleteQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+dataStore}:completeQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataStore": c.dataStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.completeQuery" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresCompleteQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Completes the specified user input with keyword suggestions.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}:completeQuery",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.completeQuery",
	//   "parameterOrder": [
	//     "dataStore"
	//   ],
	//   "parameters": {
	//     "dataStore": {
	//       "description": "Required. The parent data store resource name for which the completion is performed, such as `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "includeTailSuggestions": {
	//       "description": "Indicates if tail suggestions should be returned if there are no suggestions that match the full query. Even if set to true, if there are suggestions that match the full query, those are returned and no tail suggestions are returned.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "query": {
	//       "description": "Required. The typeahead input used to fetch suggestions. Maximum length is 128 characters.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "queryModel": {
	//       "description": "Selects data model of query suggestions for serving. Currently supported values: * `document` - Using suggestions generated from user-imported documents. * `search-history` - Using suggestions generated from the past history of SearchService.Search API calls. Do not use it when there is no traffic for Search API. * `user-event` - Using suggestions generated from user-imported search events. * `document-completable` - Using suggestions taken directly from user-imported document fields marked as completable. Default values: * `document` is the default model for regular dataStores. * `search-history` is the default model for site search dataStores.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userPseudoId": {
	//       "description": "A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+dataStore}:completeQuery",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaCompleteQueryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.create":

type ProjectsLocationsCollectionsDataStoresCreateCall struct {
	s                                          *Service
	parent                                     string
	googleclouddiscoveryenginev1alphadatastore *GoogleCloudDiscoveryengineV1alphaDataStore
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates a DataStore. DataStore is for storing Documents. To
// serve these documents for Search, or Recommendation use case, an
// Engine needs to be created separately.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}`.
func (r *ProjectsLocationsCollectionsDataStoresService) Create(parent string, googleclouddiscoveryenginev1alphadatastore *GoogleCloudDiscoveryengineV1alphaDataStore) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphadatastore = googleclouddiscoveryenginev1alphadatastore
	return c
}

// CreateAdvancedSiteSearch sets the optional parameter
// "createAdvancedSiteSearch": A boolean flag indicating whether user
// want to directly create an advanced data store for site search. If
// the data store is not configured as site search (GENERIC vertical and
// PUBLIC_WEBSITE content_config), this flag will be ignored.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) CreateAdvancedSiteSearch(createAdvancedSiteSearch bool) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("createAdvancedSiteSearch", fmt.Sprint(createAdvancedSiteSearch))
	return c
}

// DataStoreId sets the optional parameter "dataStoreId": Required. The
// ID to use for the DataStore, which will become the final component of
// the DataStore's resource name. This field must conform to RFC-1034
// (https://tools.ietf.org/html/rfc1034) standard with a length limit of
// 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) DataStoreId(dataStoreId string) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("dataStoreId", dataStoreId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadatastore)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/dataStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a DataStore. DataStore is for storing Documents. To serve these documents for Search, or Recommendation use case, an Engine needs to be created separately.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "createAdvancedSiteSearch": {
	//       "description": "A boolean flag indicating whether user want to directly create an advanced data store for site search. If the data store is not configured as site search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will be ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "dataStoreId": {
	//       "description": "Required. The ID to use for the DataStore, which will become the final component of the DataStore's resource name. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/dataStores",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDataStore"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.delete":

type ProjectsLocationsCollectionsDataStoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataStore.
//
//   - name: Full resource name of DataStore, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     /dataStores/{data_store_id}`. If the caller does not have
//     permission to delete the DataStore, regardless of whether or not it
//     exists, a PERMISSION_DENIED error is returned. If the DataStore to
//     delete does not exist, a NOT_FOUND error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) Delete(name string) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of DataStore, such as `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`. If the caller does not have permission to delete the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the DataStore to delete does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.get":

type ProjectsLocationsCollectionsDataStoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DataStore.
//
//   - name: Full resource name of DataStore, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     /dataStores/{data_store_id}`. If the caller does not have
//     permission to access the DataStore, regardless of whether or not it
//     exists, a PERMISSION_DENIED error is returned. If the requested
//     DataStore does not exist, a NOT_FOUND error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) Get(name string) *ProjectsLocationsCollectionsDataStoresGetCall {
	c := &ProjectsLocationsCollectionsDataStoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaDataStore or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDataStore.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDataStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDataStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of DataStore, such as `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`. If the caller does not have permission to access the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested DataStore does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDataStore"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.getDocumentProcessingConfig":

type ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDocumentProcessingConfig: Gets a DocumentProcessingConfig.
//
//   - name: Full DocumentProcessingConfig resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection_id}/dataStores/{data_store_id}/documentProcessingConfig`.
func (r *ProjectsLocationsCollectionsDataStoresService) GetDocumentProcessingConfig(name string) *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall {
	c := &ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.getDocumentProcessingConfig" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresGetDocumentProcessingConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a DocumentProcessingConfig.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/documentProcessingConfig",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.getDocumentProcessingConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full DocumentProcessingConfig resource name. Format: `projects/{project_number}/locations/{location_id}/collections/{collection_id}/dataStores/{data_store_id}/documentProcessingConfig`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/documentProcessingConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.getSiteSearchEngine":

type ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSiteSearchEngine: Gets the SiteSearchEngine.
//
//   - name: Resource name of SiteSearchEngine, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`. If the caller does not
//     have permission to access the [SiteSearchEngine], regardless of
//     whether or not it exists, a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) GetSiteSearchEngine(name string) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c := &ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.getSiteSearchEngine" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaSiteSearchEngine or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaSiteSearchEngine.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresGetSiteSearchEngineCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaSiteSearchEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaSiteSearchEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the SiteSearchEngine.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.getSiteSearchEngine",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of SiteSearchEngine, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`. If the caller does not have permission to access the [SiteSearchEngine], regardless of whether or not it exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSiteSearchEngine"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.list":

type ProjectsLocationsCollectionsDataStoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the DataStores associated with the project.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     `. If the caller does not have permission to list DataStores under
//     this location, regardless of whether or not this data store exists,
//     a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCollectionsDataStoresService) List(parent string) *ProjectsLocationsCollectionsDataStoresListCall {
	c := &ProjectsLocationsCollectionsDataStoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter by solution type.
// For example: filter = 'solution_type:SOLUTION_TYPE_SEARCH'
func (c *ProjectsLocationsCollectionsDataStoresListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataStores to return. If unspecified, defaults to 10. The maximum
// allowed value is 50. Values above 50 will be coerced to 50. If this
// field is negative, an INVALID_ARGUMENT is returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDataStoresResponse.next_page_token, received from a previous
// DataStoreService.ListDataStores call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// DataStoreService.ListDataStores must match the call that provided the
// page token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/dataStores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.list" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaListDataStoresResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaListDataStoresResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListDataStoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListDataStoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the DataStores associated with the project.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Filter by solution type. For example: filter = 'solution_type:SOLUTION_TYPE_SEARCH'",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of DataStores to return. If unspecified, defaults to 10. The maximum allowed value is 50. Values above 50 will be coerced to 50. If this field is negative, an INVALID_ARGUMENT is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListDataStoresResponse.next_page_token, received from a previous DataStoreService.ListDataStores call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DataStoreService.ListDataStores must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection_id}`. If the caller does not have permission to list DataStores under this location, regardless of whether or not this data store exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/dataStores",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListDataStoresResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListDataStoresResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.patch":

type ProjectsLocationsCollectionsDataStoresPatchCall struct {
	s                                          *Service
	name                                       string
	googleclouddiscoveryenginev1alphadatastore *GoogleCloudDiscoveryengineV1alphaDataStore
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Patch: Updates a DataStore
//
//   - name: Immutable. The full resource name of the data store. Format:
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     /dataStores/{data_store_id}`. This field must be a UTF-8 encoded
//     string with a length limit of 1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresService) Patch(name string, googleclouddiscoveryenginev1alphadatastore *GoogleCloudDiscoveryengineV1alphaDataStore) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphadatastore = googleclouddiscoveryenginev1alphadatastore
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided DataStore to update. If an unsupported or
// unknown field is provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadatastore)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaDataStore or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDataStore.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDataStore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDataStore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataStore",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The full resource name of the data store. Format: `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided DataStore to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDataStore"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDataStore"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.trainCustomModel":

type ProjectsLocationsCollectionsDataStoresTrainCustomModelCall struct {
	s                                                        *Service
	dataStore                                                string
	googleclouddiscoveryenginev1alphatraincustommodelrequest *GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// TrainCustomModel: Trains a custom model.
//
//   - dataStore: The resource name of the Data Store, such as
//     `projects/*/locations/global/collections/default_collection/dataStor
//     es/default_data_store`. This field is used to identify the data
//     store where to train the models.
func (r *ProjectsLocationsCollectionsDataStoresService) TrainCustomModel(dataStore string, googleclouddiscoveryenginev1alphatraincustommodelrequest *GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest) *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall {
	c := &ProjectsLocationsCollectionsDataStoresTrainCustomModelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataStore = dataStore
	c.googleclouddiscoveryenginev1alphatraincustommodelrequest = googleclouddiscoveryenginev1alphatraincustommodelrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphatraincustommodelrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+dataStore}:trainCustomModel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataStore": c.dataStore,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.trainCustomModel" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresTrainCustomModelCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Trains a custom model.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}:trainCustomModel",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.trainCustomModel",
	//   "parameterOrder": [
	//     "dataStore"
	//   ],
	//   "parameters": {
	//     "dataStore": {
	//       "description": "Required. The resource name of the Data Store, such as `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`. This field is used to identify the data store where to train the models.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+dataStore}:trainCustomModel",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaTrainCustomModelRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.updateDocumentProcessingConfig":

type ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall struct {
	s                                                         *Service
	name                                                      string
	googleclouddiscoveryenginev1alphadocumentprocessingconfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// UpdateDocumentProcessingConfig: Updates the DocumentProcessingConfig.
// DocumentProcessingConfig is a singleon resource of DataStore. It's
// empty when DataStore is created. The first call to this method will
// set up DocumentProcessingConfig.
//
//   - name: Output only. The full resource name of the Document
//     Processing Config. Format:
//     `projects/*/locations/*/collections/*/dataStores/*/documentProcessin
//     gConfig`.
func (r *ProjectsLocationsCollectionsDataStoresService) UpdateDocumentProcessingConfig(name string, googleclouddiscoveryenginev1alphadocumentprocessingconfig *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig) *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall {
	c := &ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphadocumentprocessingconfig = googleclouddiscoveryenginev1alphadocumentprocessingconfig
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided DocumentProcessingConfig to update. The
// following are the only supported fields: *
// DocumentProcessingConfig.orc_config If not set, all supported fields
// are updated.
func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadocumentprocessingconfig)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.updateDocumentProcessingConfig" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresUpdateDocumentProcessingConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the DocumentProcessingConfig. DocumentProcessingConfig is a singleon resource of DataStore. It's empty when DataStore is created. The first call to this method will set up DocumentProcessingConfig.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/documentProcessingConfig",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.updateDocumentProcessingConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The full resource name of the Document Processing Config. Format: `projects/*/locations/*/collections/*/dataStores/*/documentProcessingConfig`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/documentProcessingConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided DocumentProcessingConfig to update. The following are the only supported fields: * DocumentProcessingConfig.orc_config If not set, all supported fields are updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.create":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleclouddiscoveryenginev1alphadocument *GoogleCloudDiscoveryengineV1alphaDocument
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates a Document.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Create(parent string, googleclouddiscoveryenginev1alphadocument *GoogleCloudDiscoveryengineV1alphaDocument) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphadocument = googleclouddiscoveryenginev1alphadocument
	return c
}

// DocumentId sets the optional parameter "documentId": Required. The ID
// to use for the Document, which will become the final component of the
// Document.name. If the caller does not have permission to create the
// Document, regardless of whether or not it exists, a
// `PERMISSION_DENIED` error is returned. This field must be unique
// among all Documents with the same parent. Otherwise, an
// `ALREADY_EXISTS` error is returned. This field must conform to
// RFC-1034 (https://tools.ietf.org/html/rfc1034) standard with a length
// limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) DocumentId(documentId string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("documentId", documentId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.create" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Document.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "documentId": {
	//       "description": "Required. The ID to use for the Document, which will become the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. This field must be unique among all Documents with the same parent. Otherwise, an `ALREADY_EXISTS` error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/documents",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to delete the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the Document to delete does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Document.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to delete the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the Document to delete does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.get":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Document.
//
//   - name: Full resource name of Document, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document}`. If
//     the caller does not have permission to access the Document,
//     regardless of whether or not it exists, a `PERMISSION_DENIED` error
//     is returned. If the requested Document does not exist, a
//     `NOT_FOUND` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Document.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Document, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`. If the caller does not have permission to access the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the requested Document does not exist, a `NOT_FOUND` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.import":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall struct {
	s                                                       *Service
	parent                                                  string
	googleclouddiscoveryenginev1alphaimportdocumentsrequest *GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Import: Bulk import of multiple Documents. Request processing may be
// synchronous. Non-existing items will be created. Note: It is possible
// for a subset of the Documents to be successfully updated.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Requires create/update
//     permission.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Import(parent string, googleclouddiscoveryenginev1alphaimportdocumentsrequest *GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaimportdocumentsrequest = googleclouddiscoveryenginev1alphaimportdocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaimportdocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/documents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of multiple Documents. Request processing may be synchronous. Non-existing items will be created. Note: It is possible for a subset of the Documents to be successfully updated.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Requires create/update permission.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/documents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaImportDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.list":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Documents.
//
//   - parent: The parent branch resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`. Use `default_branch` as
//     the branch ID, to list documents under the default branch. If the
//     caller does not have permission to list Documents under this
//     branch, regardless of whether or not this branch exists, a
//     `PERMISSION_DENIED` error is returned.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) List(parent string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Documents to return. If unspecified, defaults to 100. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListDocumentsResponse.next_page_token, received from a previous
// DocumentService.ListDocuments call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// DocumentService.ListDocuments must match the call that provided the
// page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/documents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.list" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaListDocumentsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaListDocumentsResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListDocumentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListDocumentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of Documents.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of Documents to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an `INVALID_ARGUMENT` error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListDocumentsResponse.next_page_token, received from a previous DocumentService.ListDocuments call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DocumentService.ListDocuments must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`. Use `default_branch` as the branch ID, to list documents under the default branch. If the caller does not have permission to list Documents under this branch, regardless of whether or not this branch exists, a `PERMISSION_DENIED` error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/documents",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListDocumentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListDocumentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall struct {
	s                                         *Service
	name                                      string
	googleclouddiscoveryenginev1alphadocument *GoogleCloudDiscoveryengineV1alphaDocument
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a Document.
//
//   - name: Immutable. The full resource name of the document. Format:
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}/documents/{document_id}`.
//     This field must be a UTF-8 encoded string with a length limit of
//     1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Patch(name string, googleclouddiscoveryenginev1alphadocument *GoogleCloudDiscoveryengineV1alphaDocument) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphadocument = googleclouddiscoveryenginev1alphadocument
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Document is not found, a new Document will be created.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadocument)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaDocument or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaDocument.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaDocument, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaDocument{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Document.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents/{documentsId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Document is not found, a new Document will be created.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The full resource name of the document. Format: `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/documents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocument"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDocument"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge":

type ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall struct {
	s                                                      *Service
	parent                                                 string
	googleclouddiscoveryenginev1alphapurgedocumentsrequest *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Purge: Permanently deletes all selected Documents in a branch. This
// process is asynchronous. Depending on the number of Documents to be
// deleted, this operation can take hours to complete. Before the delete
// operation completes, some Documents might still be returned by
// DocumentService.GetDocument or DocumentService.ListDocuments. To get
// a list of the Documents to be deleted, set
// PurgeDocumentsRequest.force to false.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/branches/{branch}`.
func (r *ProjectsLocationsCollectionsDataStoresBranchesDocumentsService) Purge(parent string, googleclouddiscoveryenginev1alphapurgedocumentsrequest *GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphapurgedocumentsrequest = googleclouddiscoveryenginev1alphapurgedocumentsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphapurgedocumentsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/documents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesDocumentsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Permanently deletes all selected Documents in a branch. This process is asynchronous. Depending on the number of Documents to be deleted, this operation can take hours to complete. Before the delete operation completes, some Documents might still be returned by DocumentService.GetDocument or DocumentService.ListDocuments. To get a list of the Documents to be deleted, set PurgeDocumentsRequest.force to false.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/documents:purge",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.documents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/documents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaPurgeDocumentsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.operations.get":

type ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.branches.operations.list":

type ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresBranchesOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.branches.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/branches/{branchesId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.branches.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresBranchesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.converse":

type ProjectsLocationsCollectionsDataStoresConversationsConverseCall struct {
	s                                                            *Service
	name                                                         string
	googleclouddiscoveryenginev1alphaconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// Converse: Converses a conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
//     Use
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/-` to activate
//     auto session mode, which automatically creates a new conversation
//     inside a ConverseConversation session.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Converse(name string, googleclouddiscoveryenginev1alphaconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsConverseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaconverseconversationrequest = googleclouddiscoveryenginev1alphaconverseconversationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsConverseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconverseconversationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:converse")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.converse" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse.ServerR
// esponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsConverseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConverseConversationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConverseConversationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Converses a conversation.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations/{conversationsId}:converse",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.converse",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to get. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`. Use `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-` to activate auto session mode, which automatically creates a new conversation inside a ConverseConversation session.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:converse",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConverseConversationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConverseConversationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.create":

type ProjectsLocationsCollectionsDataStoresConversationsCreateCall struct {
	s                                             *Service
	parent                                        string
	googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Creates a Conversation. If the Conversation to create already
// exists, an ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent data store. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Create(parent string, googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaconversation = googleclouddiscoveryenginev1alphaconversation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.create" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Conversation. If the Conversation to create already exists, an ALREADY_EXISTS error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Full resource name of parent data store. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversations",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.delete":

type ProjectsLocationsCollectionsDataStoresConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Conversation. If the Conversation to delete does
// not exist, a NOT_FOUND error is returned.
//
//   - name: The resource name of the Conversation to delete. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Delete(name string) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Conversation. If the Conversation to delete does not exist, a NOT_FOUND error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations/{conversationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to delete. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.get":

type ProjectsLocationsCollectionsDataStoresConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Conversation.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations/{conversationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to get. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.list":

type ProjectsLocationsCollectionsDataStoresConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Conversations by their parent DataStore.
//
//   - parent: The data store resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) List(parent string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the
// list results. The supported features are: user_pseudo_id, state.
// Example: "user_pseudo_id = some_id"
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma-separated list
// of fields to order by, sorted in ascending order. Use "desc" after a
// field name for descending. Supported fields: * `update_time` *
// `create_time` * `conversation_name` Example: "update_time desc"
// "create_time"
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. If unspecified, defaults to 50. Max allowed value
// is 1000.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListConversations` call. Provide this to
// retrieve the subsequent page.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.list" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaListConversationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaListConversationsResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all Conversations by their parent DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to apply on the list results. The supported features are: user_pseudo_id, state. Example: \"user_pseudo_id = some_id\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "A comma-separated list of fields to order by, sorted in ascending order. Use \"desc\" after a field name for descending. Supported fields: * `update_time` * `create_time` * `conversation_name` Example: \"update_time desc\" \"create_time\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListConversations` call. Provide this to retrieve the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The data store resource name. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversations",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListConversationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.conversations.patch":

type ProjectsLocationsCollectionsDataStoresConversationsPatchCall struct {
	s                                             *Service
	name                                          string
	googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates a Conversation. Conversation action type cannot be
// changed. If the Conversation to update does not exist, a NOT_FOUND
// error is returned.
//
//   - name: Immutable. Fully qualified name
//     `project/*/locations/global/collections/{collection}/dataStore/*/con
//     versations/*` or
//     `project/*/locations/global/collections/{collection}/engines/*/conve
//     rsations/*`.
func (r *ProjectsLocationsCollectionsDataStoresConversationsService) Patch(name string, googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaconversation = googleclouddiscoveryenginev1alphaconversation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Conversation to update. The following are NOT
// supported: * Conversation.name If not set or empty, all supported
// fields are updated.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.conversations.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Conversation. Conversation action type cannot be changed. If the Conversation to update does not exist, a NOT_FOUND error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/conversations/{conversationsId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.conversations.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. Fully qualified name `project/*/locations/global/collections/{collection}/dataStore/*/conversations/*` or `project/*/locations/global/collections/{collection}/engines/*/conversations/*`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Conversation to update. The following are NOT supported: * Conversation.name If not set or empty, all supported fields are updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.models.operations.get":

type ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/models/{modelsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.models.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/models/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.models.operations.list":

type ProjectsLocationsCollectionsDataStoresModelsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresModelsOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresModelsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.models.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/models/{modelsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.models.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/models/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresModelsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.operations.get":

type ProjectsLocationsCollectionsDataStoresOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.operations.list":

type ProjectsLocationsCollectionsDataStoresOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.create":

type ProjectsLocationsCollectionsDataStoresSchemasCreateCall struct {
	s                                       *Service
	parent                                  string
	googleclouddiscoveryenginev1alphaschema *GoogleCloudDiscoveryengineV1alphaSchema
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a Schema.
//
//   - parent: The parent data store resource name, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Create(parent string, googleclouddiscoveryenginev1alphaschema *GoogleCloudDiscoveryengineV1alphaSchema) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaschema = googleclouddiscoveryenginev1alphaschema
	return c
}

// SchemaId sets the optional parameter "schemaId": Required. The ID to
// use for the Schema, which will become the final component of the
// Schema.name. This field should conform to RFC-1034
// (https://tools.ietf.org/html/rfc1034) standard with a length limit of
// 63 characters.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) SchemaId(schemaId string) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.urlParams_.Set("schemaId", schemaId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaschema)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Schema.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent data store resource name, in the format of `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "schemaId": {
	//       "description": "Required. The ID to use for the Schema, which will become the final component of the Schema.name. This field should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/schemas",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSchema"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.delete":

type ProjectsLocationsCollectionsDataStoresSchemasDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Schema.
//
//   - name: The full resource name of the schema, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/schemas/{schema}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Delete(name string) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Schema.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The full resource name of the schema, in the format of `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.get":

type ProjectsLocationsCollectionsDataStoresSchemasGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Schema.
//
//   - name: The full resource name of the schema, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/schemas/{schema}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Get(name string) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaSchema or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaSchema.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaSchema, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaSchema{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Schema.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The full resource name of the schema, in the format of `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSchema"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.list":

type ProjectsLocationsCollectionsDataStoresSchemasListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Schemas.
//
//   - parent: The parent data store resource name, in the format of
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) List(parent string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Schemas to return. The service may return fewer than this value.
// If unspecified, at most 100 Schemas will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous SchemaService.ListSchemas call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to SchemaService.ListSchemas must match the call
// that provided the page token.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/schemas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.list" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaListSchemasResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1alphaListSchemasResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListSchemasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListSchemasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of Schemas.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Schemas to return. The service may return fewer than this value. If unspecified, at most 100 Schemas will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous SchemaService.ListSchemas call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SchemaService.ListSchemas must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent data store resource name, in the format of `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/schemas",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListSchemasResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListSchemasResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.patch":

type ProjectsLocationsCollectionsDataStoresSchemasPatchCall struct {
	s                                       *Service
	name                                    string
	googleclouddiscoveryenginev1alphaschema *GoogleCloudDiscoveryengineV1alphaSchema
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates a Schema.
//
//   - name: Immutable. The full resource name of the schema, in the
//     format of
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/schemas/{schema}`. This field must be a UTF-8
//     encoded string with a length limit of 1024 characters.
func (r *ProjectsLocationsCollectionsDataStoresSchemasService) Patch(name string, googleclouddiscoveryenginev1alphaschema *GoogleCloudDiscoveryengineV1alphaSchema) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaschema = googleclouddiscoveryenginev1alphaschema
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Schema is not found, a new Schema will be created. In
// this situation, `update_mask` is ignored.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaschema)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Schema.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Schema is not found, a new Schema will be created. In this situation, `update_mask` is ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. The full resource name of the schema, in the format of `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSchema"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get":

type ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list":

type ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresSchemasOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/schemas/{schemasId}/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.schemas.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/schemas/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSchemasOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend":

type ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall struct {
	s                                                 *Service
	servingConfig                                     string
	googleclouddiscoveryenginev1alpharecommendrequest *GoogleCloudDiscoveryengineV1alphaRecommendRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Recommend: Makes a recommendation, which requires a contextual user
// event.
//
//   - servingConfig: Full resource name of a ServingConfig:
//     `projects/*/locations/global/collections/*/engines/*/servingConfigs/
//     *`, or
//     `projects/*/locations/global/collections/*/dataStores/*/servingConfi
//     gs/*` One default serving config is created along with your
//     recommendation engine creation. The engine ID will be used as the
//     ID of the default serving config. For example, for Engine
//     `projects/*/locations/global/collections/*/engines/my-engine`, you
//     can use
//     `projects/*/locations/global/collections/*/engines/my-engine/serving
//     Configs/my-engine` for your RecommendationService.Recommend
//     requests.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Recommend(servingConfig string, googleclouddiscoveryenginev1alpharecommendrequest *GoogleCloudDiscoveryengineV1alphaRecommendRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1alpharecommendrequest = googleclouddiscoveryenginev1alpharecommendrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alpharecommendrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+servingConfig}:recommend")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaRecommendResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaRecommendResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsRecommendCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaRecommendResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaRecommendResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Makes a recommendation, which requires a contextual user event.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/servingConfigs/{servingConfigsId}:recommend",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend",
	//   "parameterOrder": [
	//     "servingConfig"
	//   ],
	//   "parameters": {
	//     "servingConfig": {
	//       "description": "Required. Full resource name of a ServingConfig: `projects/*/locations/global/collections/*/engines/*/servingConfigs/*`, or `projects/*/locations/global/collections/*/dataStores/*/servingConfigs/*` One default serving config is created along with your recommendation engine creation. The engine ID will be used as the ID of the default serving config. For example, for Engine `projects/*/locations/global/collections/*/engines/my-engine`, you can use `projects/*/locations/global/collections/*/engines/my-engine/servingConfigs/my-engine` for your RecommendationService.Recommend requests.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/servingConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+servingConfig}:recommend",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaRecommendRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaRecommendResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.servingConfigs.search":

type ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall struct {
	s                                              *Service
	servingConfig                                  string
	googleclouddiscoveryenginev1alphasearchrequest *GoogleCloudDiscoveryengineV1alphaSearchRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Search: Performs a search.
//
//   - servingConfig: The resource name of the Search serving config, such
//     as
//     `projects/*/locations/global/collections/default_collection/engines/
//     */servingConfigs/default_serving_config`, or
//     `projects/*/locations/global/collections/default_collection/dataStor
//     es/default_data_store/servingConfigs/default_serving_config`. This
//     field is used to identify the serving configuration name, set of
//     models used to make the search.
func (r *ProjectsLocationsCollectionsDataStoresServingConfigsService) Search(servingConfig string, googleclouddiscoveryenginev1alphasearchrequest *GoogleCloudDiscoveryengineV1alphaSearchRequest) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.servingConfig = servingConfig
	c.googleclouddiscoveryenginev1alphasearchrequest = googleclouddiscoveryenginev1alphasearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphasearchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+servingConfig}:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"servingConfig": c.servingConfig,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.servingConfigs.search" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaSearchResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaSearchResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaSearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaSearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs a search.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/servingConfigs/{servingConfigsId}:search",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.servingConfigs.search",
	//   "parameterOrder": [
	//     "servingConfig"
	//   ],
	//   "parameters": {
	//     "servingConfig": {
	//       "description": "Required. The resource name of the Search serving config, such as `projects/*/locations/global/collections/default_collection/engines/*/servingConfigs/default_serving_config`, or `projects/*/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`. This field is used to identify the serving configuration name, set of models used to make the search.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/servingConfigs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+servingConfig}:search",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSearchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaSearchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresServingConfigsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaSearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleclouddiscoveryenginev1alphasearchrequest.PageToken = pt }(c.googleclouddiscoveryenginev1alphasearchrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleclouddiscoveryenginev1alphasearchrequest.PageToken = x.NextPageToken
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.batchVerifyTargetSites":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall struct {
	s                                                              *Service
	parent                                                         string
	googleclouddiscoveryenginev1alphabatchverifytargetsitesrequest *GoogleCloudDiscoveryengineV1alphaBatchVerifyTargetSitesRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// BatchVerifyTargetSites: Verify target sites' ownership and validity.
// This API sends all the target sites under site search engine for
// verification.
//
//   - parent: The parent resource shared by all TargetSites being
//     verified.
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) BatchVerifyTargetSites(parent string, googleclouddiscoveryenginev1alphabatchverifytargetsitesrequest *GoogleCloudDiscoveryengineV1alphaBatchVerifyTargetSitesRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphabatchverifytargetsitesrequest = googleclouddiscoveryenginev1alphabatchverifytargetsitesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphabatchverifytargetsitesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}:batchVerifyTargetSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.batchVerifyTargetSites" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineBatchVerifyTargetSitesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Verify target sites' ownership and validity. This API sends all the target sites under site search engine for verification.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine:batchVerifyTargetSites",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.batchVerifyTargetSites",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource shared by all TargetSites being verified. `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}:batchVerifyTargetSites",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaBatchVerifyTargetSitesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.disableAdvancedSiteSearch":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall struct {
	s                                                                 *Service
	siteSearchEngine                                                  string
	googleclouddiscoveryenginev1alphadisableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// DisableAdvancedSiteSearch: Downgrade from advanced site search to
// basic site search.
//
//   - siteSearchEngine: Full resource name of the SiteSearchEngine, such
//     as
//     `projects/{project}/locations/{location}/dataStores/{data_store_id}/
//     siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) DisableAdvancedSiteSearch(siteSearchEngine string, googleclouddiscoveryenginev1alphadisableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	c.googleclouddiscoveryenginev1alphadisableadvancedsitesearchrequest = googleclouddiscoveryenginev1alphadisableadvancedsitesearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphadisableadvancedsitesearchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+siteSearchEngine}:disableAdvancedSiteSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.disableAdvancedSiteSearch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineDisableAdvancedSiteSearchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Downgrade from advanced site search to basic site search.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine:disableAdvancedSiteSearch",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.disableAdvancedSiteSearch",
	//   "parameterOrder": [
	//     "siteSearchEngine"
	//   ],
	//   "parameters": {
	//     "siteSearchEngine": {
	//       "description": "Required. Full resource name of the SiteSearchEngine, such as `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+siteSearchEngine}:disableAdvancedSiteSearch",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.enableAdvancedSiteSearch":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall struct {
	s                                                                *Service
	siteSearchEngine                                                 string
	googleclouddiscoveryenginev1alphaenableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// EnableAdvancedSiteSearch: Upgrade from basic site search to advanced
// site search.
//
//   - siteSearchEngine: Full resource name of the SiteSearchEngine, such
//     as
//     `projects/{project}/locations/{location}/dataStores/{data_store_id}/
//     siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) EnableAdvancedSiteSearch(siteSearchEngine string, googleclouddiscoveryenginev1alphaenableadvancedsitesearchrequest *GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	c.googleclouddiscoveryenginev1alphaenableadvancedsitesearchrequest = googleclouddiscoveryenginev1alphaenableadvancedsitesearchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaenableadvancedsitesearchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+siteSearchEngine}:enableAdvancedSiteSearch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.enableAdvancedSiteSearch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineEnableAdvancedSiteSearchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Upgrade from basic site search to advanced site search.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine:enableAdvancedSiteSearch",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.enableAdvancedSiteSearch",
	//   "parameterOrder": [
	//     "siteSearchEngine"
	//   ],
	//   "parameters": {
	//     "siteSearchEngine": {
	//       "description": "Required. Full resource name of the SiteSearchEngine, such as `projects/{project}/locations/{location}/dataStores/{data_store_id}/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+siteSearchEngine}:enableAdvancedSiteSearch",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.fetchDomainVerificationStatus":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall struct {
	s                *Service
	siteSearchEngine string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// FetchDomainVerificationStatus: Returns list of target sites with its
// domain verification status. This method can only be called under data
// store with BASIC_SITE_SEARCH state at the moment.
//
//   - siteSearchEngine: The site search engine resource under which we
//     fetch all the domain verification status.
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) FetchDomainVerificationStatus(siteSearchEngine string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, server
// will pick an appropriate default. The maximum value is 1000; values
// above 1000 will be coerced to 1000. If this field is negative, an
// INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `FetchDomainVerificationStatus` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `FetchDomainVerificationStatus` must
// match the call that provided the page token.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+siteSearchEngine}:fetchDomainVerificationStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.fetchDomainVerificationStatus" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusRespons
// e or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusRespons
// e.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns list of target sites with its domain verification status. This method can only be called under data store with BASIC_SITE_SEARCH state at the moment.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine:fetchDomainVerificationStatus",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.fetchDomainVerificationStatus",
	//   "parameterOrder": [
	//     "siteSearchEngine"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, server will pick an appropriate default. The maximum value is 1000; values above 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `FetchDomainVerificationStatus` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `FetchDomainVerificationStatus` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "siteSearchEngine": {
	//       "description": "Required. The site search engine resource under which we fetch all the domain verification status. `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+siteSearchEngine}:fetchDomainVerificationStatus",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineFetchDomainVerificationStatusCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaFetchDomainVerificationStatusResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.recrawlUris":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall struct {
	s                                                   *Service
	siteSearchEngine                                    string
	googleclouddiscoveryenginev1alpharecrawlurisrequest *GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// RecrawlUris: Request on-demand recrawl for a list of URIs.
//
//   - siteSearchEngine: Full resource name of the SiteSearchEngine, such
//     as
//     `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`
//     .
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineService) RecrawlUris(siteSearchEngine string, googleclouddiscoveryenginev1alpharecrawlurisrequest *GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.siteSearchEngine = siteSearchEngine
	c.googleclouddiscoveryenginev1alpharecrawlurisrequest = googleclouddiscoveryenginev1alpharecrawlurisrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alpharecrawlurisrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+siteSearchEngine}:recrawlUris")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"siteSearchEngine": c.siteSearchEngine,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.recrawlUris" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineRecrawlUrisCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Request on-demand recrawl for a list of URIs.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine:recrawlUris",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.recrawlUris",
	//   "parameterOrder": [
	//     "siteSearchEngine"
	//   ],
	//   "parameters": {
	//     "siteSearchEngine": {
	//       "description": "Required. Full resource name of the SiteSearchEngine, such as `projects/*/locations/*/collections/*/dataStores/*/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+siteSearchEngine}:recrawlUris",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaRecrawlUrisRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.get":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.list":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.batchCreate":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall struct {
	s                                                              *Service
	parent                                                         string
	googleclouddiscoveryenginev1alphabatchcreatetargetsitesrequest *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest
	urlParams_                                                     gensupport.URLParams
	ctx_                                                           context.Context
	header_                                                        http.Header
}

// BatchCreate: Creates TargetSite in a batch.
//
//   - parent: The parent resource shared by all TargetSites being
//     created.
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`. The parent field in the
//     CreateBookRequest messages must either be empty or match this
//     field.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) BatchCreate(parent string, googleclouddiscoveryenginev1alphabatchcreatetargetsitesrequest *GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphabatchcreatetargetsitesrequest = googleclouddiscoveryenginev1alphabatchcreatetargetsitesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphabatchcreatetargetsitesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/targetSites:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.batchCreate" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates TargetSite in a batch.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource shared by all TargetSites being created. `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`. The parent field in the CreateBookRequest messages must either be empty or match this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/targetSites:batchCreate",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.create":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall struct {
	s                                           *Service
	parent                                      string
	googleclouddiscoveryenginev1alphatargetsite *GoogleCloudDiscoveryengineV1alphaTargetSite
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Create: Creates a TargetSite.
//
//   - parent: Parent resource name of TargetSite, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) Create(parent string, googleclouddiscoveryenginev1alphatargetsite *GoogleCloudDiscoveryengineV1alphaTargetSite) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphatargetsite = googleclouddiscoveryenginev1alphatargetsite
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphatargetsite)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/targetSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a TargetSite.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Parent resource name of TargetSite, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/targetSites",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaTargetSite"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.delete":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a TargetSite.
//
//   - name: Full resource name of TargetSite, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
//     If the caller does not have permission to access the TargetSite,
//     regardless of whether or not it exists, a PERMISSION_DENIED error
//     is returned. If the requested TargetSite does not exist, a
//     NOT_FOUND error is returned.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) Delete(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a TargetSite.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites/{targetSitesId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of TargetSite, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`. If the caller does not have permission to access the TargetSite, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested TargetSite does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/targetSites/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.get":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a TargetSite.
//
//   - name: Full resource name of TargetSite, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine/targetSites/{target_site}`.
//     If the caller does not have permission to access the TargetSite,
//     regardless of whether or not it exists, a PERMISSION_DENIED error
//     is returned. If the requested TargetSite does not exist, a
//     NOT_FOUND error is returned.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) Get(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaTargetSite or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaTargetSite.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaTargetSite, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaTargetSite{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a TargetSite.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites/{targetSitesId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of TargetSite, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}`. If the caller does not have permission to access the TargetSite, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested TargetSite does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/targetSites/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaTargetSite"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.list":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of TargetSites.
//
//   - parent: The parent site search engine resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine`. If the caller does not
//     have permission to list TargetSites under this site search engine,
//     regardless of whether or not this branch exists, a
//     PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) List(parent string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size.
// Server may return fewer items than requested. If unspecified, server
// will pick an appropriate default. The maximum value is 1000; values
// above 1000 will be coerced to 1000. If this field is negative, an
// INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListTargetSites` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListTargetSites` must match the call that provided the
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/targetSites")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.list" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of TargetSites.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Requested page size. Server may return fewer items than requested. If unspecified, server will pick an appropriate default. The maximum value is 1000; values above 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListTargetSites` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListTargetSites` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent site search engine resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine`. If the caller does not have permission to list TargetSites under this site search engine, regardless of whether or not this branch exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/targetSites",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListTargetSitesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.patch":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall struct {
	s                                           *Service
	name                                        string
	googleclouddiscoveryenginev1alphatargetsite *GoogleCloudDiscoveryengineV1alphaTargetSite
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates a TargetSite.
//
//   - name: Output only. The fully qualified resource name of the target
//     site.
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}/siteSearchEngine/targetSites/{target_site}`
//     The `target_site_id` is system-generated.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesService) Patch(name string, googleclouddiscoveryenginev1alphatargetsite *GoogleCloudDiscoveryengineV1alphaTargetSite) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphatargetsite = googleclouddiscoveryenginev1alphatargetsite
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphatargetsite)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a TargetSite.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites/{targetSitesId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The fully qualified resource name of the target site. `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/siteSearchEngine/targetSites/{target_site}` The `target_site_id` is system-generated.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/targetSites/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaTargetSite"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.get":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService) Get(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/targetSites/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.list":

type ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsService) List(name string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c := &ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Filter(filter string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/siteSearchEngine/targetSites/operations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.siteSearchEngine.targetSites.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+/siteSearchEngine/targetSites$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsDataStoresSiteSearchEngineTargetSitesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.import":

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall struct {
	s                                                                       *Service
	parent                                                                  string
	googleclouddiscoveryenginev1alphaimportsuggestiondenylistentriesrequest *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest
	urlParams_                                                              gensupport.URLParams
	ctx_                                                                    context.Context
	header_                                                                 http.Header
}

// Import: Imports all SuggestionDenyListEntry for a DataStore.
//
//   - parent: The parent data store resource name for which to import
//     denylist entries. Follows pattern
//     projects/*/locations/*/collections/*/dataStores/*.
func (r *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService) Import(parent string, googleclouddiscoveryenginev1alphaimportsuggestiondenylistentriesrequest *GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall {
	c := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaimportsuggestiondenylistentriesrequest = googleclouddiscoveryenginev1alphaimportsuggestiondenylistentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaimportsuggestiondenylistentriesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/suggestionDenyListEntries:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Imports all SuggestionDenyListEntry for a DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/suggestionDenyListEntries:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent data store resource name for which to import denylist entries. Follows pattern projects/*/locations/*/collections/*/dataStores/*.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/suggestionDenyListEntries:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.purge":

type ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall struct {
	s                                                                      *Service
	parent                                                                 string
	googleclouddiscoveryenginev1alphapurgesuggestiondenylistentriesrequest *GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRequest
	urlParams_                                                             gensupport.URLParams
	ctx_                                                                   context.Context
	header_                                                                http.Header
}

// Purge: Permanently deletes all SuggestionDenyListEntry for a
// DataStore.
//
//   - parent: The parent data store resource name for which to import
//     denylist entries. Follows pattern
//     projects/*/locations/*/collections/*/dataStores/*.
func (r *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesService) Purge(parent string, googleclouddiscoveryenginev1alphapurgesuggestiondenylistentriesrequest *GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRequest) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphapurgesuggestiondenylistentriesrequest = googleclouddiscoveryenginev1alphapurgesuggestiondenylistentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphapurgesuggestiondenylistentriesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/suggestionDenyListEntries:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresSuggestionDenyListEntriesPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Permanently deletes all SuggestionDenyListEntry for a DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/suggestionDenyListEntries:purge",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.suggestionDenyListEntries.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent data store resource name for which to import denylist entries. Follows pattern projects/*/locations/*/collections/*/dataStores/*.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/suggestionDenyListEntries:purge",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.collect":

type ProjectsLocationsCollectionsDataStoresUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a third-party
// domain. This method is used only by the Discovery Engine API
// JavaScript pixel and Google Tag Manager. Users should not call this
// method directly.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Collect(parent string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in
// milliseconds. This prevents browser caching of otherwise identical
// get requests. The name is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// Uri sets the optional parameter "uri": The URL including
// cgi-parameters but excluding the hash fragment with a length limit of
// 5,000 characters. This is often more useful than the referer URL,
// because many browsers only send the domain for third-party requests.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Uri(uri string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL
// encoded UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.collect" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event from the browser. This uses a GET request to due to browser restriction of POST-ing to a third-party domain. This method is used only by the Discovery Engine API JavaScript pixel and Google Tag Manager. Users should not call this method directly.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:collect",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.collect",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "ets": {
	//       "description": "The event timestamp in milliseconds. This prevents browser caching of otherwise identical get requests. The name is abbreviated to reduce the payload bytes.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "uri": {
	//       "description": "The URL including cgi-parameters but excluding the hash fragment with a length limit of 5,000 characters. This is often more useful than the referer URL, because many browsers only send the domain for third-party requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userEvent": {
	//       "description": "Required. URL encoded UserEvent proto with a length limit of 2,000,000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userEvents:collect",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.import":

type ProjectsLocationsCollectionsDataStoresUserEventsImportCall struct {
	s                                                        *Service
	parent                                                   string
	googleclouddiscoveryenginev1alphaimportusereventsrequest *GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Import: Bulk import of User events. Request processing might be
// synchronous. Events that already exist are skipped. Use this method
// for backfilling historical user events. Operation.response is of type
// ImportResponse. Note that it is possible for a subset of the items to
// be successfully inserted. Operation.metadata is of type
// ImportMetadata.
//
//   - parent: Parent DataStore resource name, of the form
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Import(parent string, googleclouddiscoveryenginev1alphaimportusereventsrequest *GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaimportusereventsrequest = googleclouddiscoveryenginev1alphaimportusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaimportusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of User events. Request processing might be synchronous. Events that already exist are skipped. Use this method for backfilling historical user events. Operation.response is of type ImportResponse. Note that it is possible for a subset of the items to be successfully inserted. Operation.metadata is of type ImportMetadata.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:import",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Parent DataStore resource name, of the form `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userEvents:import",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaImportUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.purge":

type ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall struct {
	s                                                       *Service
	parent                                                  string
	googleclouddiscoveryenginev1alphapurgeusereventsrequest *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Purge: Deletes permanently all user events specified by the filter
// provided. Depending on the number of events specified by the filter,
// this operation could take hours or days to complete. To test a
// filter, use the list command first.
//
//   - parent: The resource name of the catalog under which the events are
//     created. The format is
//     `projects/${projectId}/locations/global/collections/{$collectionId}/
//     dataStores/${dataStoreId}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Purge(parent string, googleclouddiscoveryenginev1alphapurgeusereventsrequest *GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest) *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphapurgeusereventsrequest = googleclouddiscoveryenginev1alphapurgeusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphapurgeusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userEvents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes permanently all user events specified by the filter provided. Depending on the number of events specified by the filter, this operation could take hours or days to complete. To test a filter, use the list command first.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:purge",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the catalog under which the events are created. The format is `projects/${projectId}/locations/global/collections/{$collectionId}/dataStores/${dataStoreId}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userEvents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaPurgeUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.dataStores.userEvents.write":

type ProjectsLocationsCollectionsDataStoresUserEventsWriteCall struct {
	s                                          *Service
	parent                                     string
	googleclouddiscoveryenginev1alphauserevent *GoogleCloudDiscoveryengineV1alphaUserEvent
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Write: Writes a single user event.
//
//   - parent: The parent DataStore resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}/da
//     taStores/{data_store}`.
func (r *ProjectsLocationsCollectionsDataStoresUserEventsService) Write(parent string, googleclouddiscoveryenginev1alphauserevent *GoogleCloudDiscoveryengineV1alphaUserEvent) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c := &ProjectsLocationsCollectionsDataStoresUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphauserevent = googleclouddiscoveryenginev1alphauserevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphauserevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.dataStores.userEvents.write" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaUserEvent or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaUserEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsDataStoresUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaUserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaUserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataStores/{dataStoresId}/userEvents:write",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.dataStores.userEvents.write",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent DataStore resource name, such as `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/dataStores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userEvents:write",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaUserEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaUserEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.create":

type ProjectsLocationsCollectionsEnginesCreateCall struct {
	s                                       *Service
	parent                                  string
	googleclouddiscoveryenginev1alphaengine *GoogleCloudDiscoveryengineV1alphaEngine
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a Engine.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection}`.
func (r *ProjectsLocationsCollectionsEnginesService) Create(parent string, googleclouddiscoveryenginev1alphaengine *GoogleCloudDiscoveryengineV1alphaEngine) *ProjectsLocationsCollectionsEnginesCreateCall {
	c := &ProjectsLocationsCollectionsEnginesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaengine = googleclouddiscoveryenginev1alphaengine
	return c
}

// EngineId sets the optional parameter "engineId": Required. The ID to
// use for the Engine, which will become the final component of the
// Engine's resource name. This field must conform to RFC-1034
// (https://tools.ietf.org/html/rfc1034) standard with a length limit of
// 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsEnginesCreateCall) EngineId(engineId string) *ProjectsLocationsCollectionsEnginesCreateCall {
	c.urlParams_.Set("engineId", engineId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaengine)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/engines")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Engine.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "engineId": {
	//       "description": "Required. The ID to use for the Engine, which will become the final component of the Engine's resource name. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/engines",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.delete":

type ProjectsLocationsCollectionsEnginesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Engine.
//
//   - name: Full resource name of Engine, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     /engines/{engine_id}`. If the caller does not have permission to
//     delete the Engine, regardless of whether or not it exists, a
//     PERMISSION_DENIED error is returned. If the Engine to delete does
//     not exist, a NOT_FOUND error is returned.
func (r *ProjectsLocationsCollectionsEnginesService) Delete(name string) *ProjectsLocationsCollectionsEnginesDeleteCall {
	c := &ProjectsLocationsCollectionsEnginesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Engine.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.engines.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Engine, such as `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`. If the caller does not have permission to delete the Engine, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the Engine to delete does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.get":

type ProjectsLocationsCollectionsEnginesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Engine.
//
//   - name: Full resource name of Engine, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     /engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsEnginesService) Get(name string) *ProjectsLocationsCollectionsEnginesGetCall {
	c := &ProjectsLocationsCollectionsEnginesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaEngine or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaEngine.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Engine.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Engine, such as `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.list":

type ProjectsLocationsCollectionsEnginesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Engines associated with the project.
//
//   - parent: The parent resource name, such as
//     `projects/{project}/locations/{location}/collections/{collection_id}
//     `.
func (r *ProjectsLocationsCollectionsEnginesService) List(parent string) *ProjectsLocationsCollectionsEnginesListCall {
	c := &ProjectsLocationsCollectionsEnginesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter by solution type.
// For example: solution_type=SOLUTION_TYPE_SEARCH
func (c *ProjectsLocationsCollectionsEnginesListCall) Filter(filter string) *ProjectsLocationsCollectionsEnginesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Not supported.
func (c *ProjectsLocationsCollectionsEnginesListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsEnginesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Not supported.
func (c *ProjectsLocationsCollectionsEnginesListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsEnginesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/engines")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.list" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaListEnginesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDiscoveryengineV1alphaListEnginesResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListEnginesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListEnginesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the Engines associated with the project.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter by solution type. For example: solution_type=SOLUTION_TYPE_SEARCH",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Not supported.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Not supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource name, such as `projects/{project}/locations/{location}/collections/{collection_id}`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/engines",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListEnginesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsEnginesListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListEnginesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.engines.patch":

type ProjectsLocationsCollectionsEnginesPatchCall struct {
	s                                       *Service
	name                                    string
	googleclouddiscoveryenginev1alphaengine *GoogleCloudDiscoveryengineV1alphaEngine
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates an Engine
//
//   - name: Immutable. The fully qualified resource name of the engine.
//     This field must be a UTF-8 encoded string with a length limit of
//     1024 characters. Format:
//     `projects/{project_number}/locations/{location}/collections/{collect
//     ion}/engines/{engine}` engine should be 1-63 characters, and valid
//     characters are /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is
//     returned.
func (r *ProjectsLocationsCollectionsEnginesService) Patch(name string, googleclouddiscoveryenginev1alphaengine *GoogleCloudDiscoveryengineV1alphaEngine) *ProjectsLocationsCollectionsEnginesPatchCall {
	c := &ProjectsLocationsCollectionsEnginesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaengine = googleclouddiscoveryenginev1alphaengine
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Engine to update. If an unsupported or unknown
// field is provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCollectionsEnginesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsEnginesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaengine)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaEngine or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaEngine.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an Engine",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.engines.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. The fully qualified resource name of the engine. This field must be a UTF-8 encoded string with a length limit of 1024 characters. Format: `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}` engine should be 1-63 characters, and valid characters are /a-z0-9*/. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Engine to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.pause":

type ProjectsLocationsCollectionsEnginesPauseCall struct {
	s                                                   *Service
	name                                                string
	googleclouddiscoveryenginev1alphapauseenginerequest *GoogleCloudDiscoveryengineV1alphaPauseEngineRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Pause: Pauses the training of an existing engine. Only applicable if
// SolutionType is SOLUTION_TYPE_RECOMMENDATION.
//
//   - name: The name of the engine to pause. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection_id}/engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsEnginesService) Pause(name string, googleclouddiscoveryenginev1alphapauseenginerequest *GoogleCloudDiscoveryengineV1alphaPauseEngineRequest) *ProjectsLocationsCollectionsEnginesPauseCall {
	c := &ProjectsLocationsCollectionsEnginesPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphapauseenginerequest = googleclouddiscoveryenginev1alphapauseenginerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesPauseCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesPauseCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphapauseenginerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.pause" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaEngine or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaEngine.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesPauseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Pauses the training of an existing engine. Only applicable if SolutionType is SOLUTION_TYPE_RECOMMENDATION.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}:pause",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.pause",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the engine to pause. Format: `projects/{project_number}/locations/{location_id}/collections/{collection_id}/engines/{engine_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:pause",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaPauseEngineRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.resume":

type ProjectsLocationsCollectionsEnginesResumeCall struct {
	s                                                    *Service
	name                                                 string
	googleclouddiscoveryenginev1alpharesumeenginerequest *GoogleCloudDiscoveryengineV1alphaResumeEngineRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// Resume: Resumes the training of an existing engine. Only applicable
// if SolutionType is SOLUTION_TYPE_RECOMMENDATION.
//
//   - name: The name of the engine to resume. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection_id}/engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsEnginesService) Resume(name string, googleclouddiscoveryenginev1alpharesumeenginerequest *GoogleCloudDiscoveryengineV1alphaResumeEngineRequest) *ProjectsLocationsCollectionsEnginesResumeCall {
	c := &ProjectsLocationsCollectionsEnginesResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alpharesumeenginerequest = googleclouddiscoveryenginev1alpharesumeenginerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesResumeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesResumeCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alpharesumeenginerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.resume" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaEngine or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDiscoveryengineV1alphaEngine.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesResumeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaEngine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaEngine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Resumes the training of an existing engine. Only applicable if SolutionType is SOLUTION_TYPE_RECOMMENDATION.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}:resume",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.resume",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the engine to resume. Format: `projects/{project_number}/locations/{location_id}/collections/{collection_id}/engines/{engine_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:resume",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaResumeEngineRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaEngine"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.tune":

type ProjectsLocationsCollectionsEnginesTuneCall struct {
	s                                                  *Service
	name                                               string
	googleclouddiscoveryenginev1alphatuneenginerequest *GoogleCloudDiscoveryengineV1alphaTuneEngineRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Tune: Tunes an existing engine. Only applicable if SolutionType is
// SOLUTION_TYPE_RECOMMENDATION.
//
//   - name: The resource name of the engine to tune. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection_id}/engines/{engine_id}`.
func (r *ProjectsLocationsCollectionsEnginesService) Tune(name string, googleclouddiscoveryenginev1alphatuneenginerequest *GoogleCloudDiscoveryengineV1alphaTuneEngineRequest) *ProjectsLocationsCollectionsEnginesTuneCall {
	c := &ProjectsLocationsCollectionsEnginesTuneCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphatuneenginerequest = googleclouddiscoveryenginev1alphatuneenginerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesTuneCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesTuneCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesTuneCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesTuneCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesTuneCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesTuneCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphatuneenginerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:tune")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.tune" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesTuneCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Tunes an existing engine. Only applicable if SolutionType is SOLUTION_TYPE_RECOMMENDATION.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}:tune",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.tune",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the engine to tune. Format: `projects/{project_number}/locations/{location_id}/collections/{collection_id}/engines/{engine_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:tune",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaTuneEngineRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.conversations.converse":

type ProjectsLocationsCollectionsEnginesConversationsConverseCall struct {
	s                                                            *Service
	name                                                         string
	googleclouddiscoveryenginev1alphaconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// Converse: Converses a conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
//     Use
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/-` to activate
//     auto session mode, which automatically creates a new conversation
//     inside a ConverseConversation session.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) Converse(name string, googleclouddiscoveryenginev1alphaconverseconversationrequest *GoogleCloudDiscoveryengineV1alphaConverseConversationRequest) *ProjectsLocationsCollectionsEnginesConversationsConverseCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsConverseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaconverseconversationrequest = googleclouddiscoveryenginev1alphaconverseconversationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsConverseCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsConverseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsConverseCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsConverseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsConverseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsConverseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconverseconversationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:converse")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.converse" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConverseConversationResponse.ServerR
// esponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsConverseCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConverseConversationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConverseConversationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Converses a conversation.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations/{conversationsId}:converse",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.converse",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to get. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`. Use `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/-` to activate auto session mode, which automatically creates a new conversation inside a ConverseConversation session.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:converse",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConverseConversationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConverseConversationResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.conversations.create":

type ProjectsLocationsCollectionsEnginesConversationsCreateCall struct {
	s                                             *Service
	parent                                        string
	googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Creates a Conversation. If the Conversation to create already
// exists, an ALREADY_EXISTS error is returned.
//
//   - parent: Full resource name of parent data store. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) Create(parent string, googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation) *ProjectsLocationsCollectionsEnginesConversationsCreateCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddiscoveryenginev1alphaconversation = googleclouddiscoveryenginev1alphaconversation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.create" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Conversation. If the Conversation to create already exists, an ALREADY_EXISTS error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations",
	//   "httpMethod": "POST",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Full resource name of parent data store. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversations",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.conversations.delete":

type ProjectsLocationsCollectionsEnginesConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Conversation. If the Conversation to delete does
// not exist, a NOT_FOUND error is returned.
//
//   - name: The resource name of the Conversation to delete. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) Delete(name string) *ProjectsLocationsCollectionsEnginesConversationsDeleteCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Conversation. If the Conversation to delete does not exist, a NOT_FOUND error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations/{conversationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to delete. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.conversations.get":

type ProjectsLocationsCollectionsEnginesConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Conversation.
//
//   - name: The resource name of the Conversation to get. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}/conversations/{conversation_id}`.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) Get(name string) *ProjectsLocationsCollectionsEnginesConversationsGetCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.get" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Conversation.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations/{conversationsId}",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Conversation to get. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}/conversations/{conversation_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.conversations.list":

type ProjectsLocationsCollectionsEnginesConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Conversations by their parent DataStore.
//
//   - parent: The data store resource name. Format:
//     `projects/{project_number}/locations/{location_id}/collections/{coll
//     ection}/dataStores/{data_store_id}`.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) List(parent string) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the
// list results. The supported features are: user_pseudo_id, state.
// Example: "user_pseudo_id = some_id"
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Filter(filter string) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma-separated list
// of fields to order by, sorted in ascending order. Use "desc" after a
// field name for descending. Supported fields: * `update_time` *
// `create_time` * `conversation_name` Example: "update_time desc"
// "create_time"
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. If unspecified, defaults to 50. Max allowed value
// is 1000.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListConversations` call. Provide this to
// retrieve the subsequent page.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) PageToken(pageToken string) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.list" call.
// Exactly one of
// *GoogleCloudDiscoveryengineV1alphaListConversationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaListConversationsResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all Conversations by their parent DataStore.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations",
	//   "httpMethod": "GET",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to apply on the list results. The supported features are: user_pseudo_id, state. Example: \"user_pseudo_id = some_id\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "A comma-separated list of fields to order by, sorted in ascending order. Use \"desc\" after a field name for descending. Supported fields: * `update_time` * `create_time` * `conversation_name` Example: \"update_time desc\" \"create_time\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListConversations` call. Provide this to retrieve the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The data store resource name. Format: `projects/{project_number}/locations/{location_id}/collections/{collection}/dataStores/{data_store_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversations",
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaListConversationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCollectionsEnginesConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudDiscoveryengineV1alphaListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "discoveryengine.projects.locations.collections.engines.conversations.patch":

type ProjectsLocationsCollectionsEnginesConversationsPatchCall struct {
	s                                             *Service
	name                                          string
	googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates a Conversation. Conversation action type cannot be
// changed. If the Conversation to update does not exist, a NOT_FOUND
// error is returned.
//
//   - name: Immutable. Fully qualified name
//     `project/*/locations/global/collections/{collection}/dataStore/*/con
//     versations/*` or
//     `project/*/locations/global/collections/{collection}/engines/*/conve
//     rsations/*`.
func (r *ProjectsLocationsCollectionsEnginesConversationsService) Patch(name string, googleclouddiscoveryenginev1alphaconversation *GoogleCloudDiscoveryengineV1alphaConversation) *ProjectsLocationsCollectionsEnginesConversationsPatchCall {
	c := &ProjectsLocationsCollectionsEnginesConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddiscoveryenginev1alphaconversation = googleclouddiscoveryenginev1alphaconversation
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Conversation to update. The following are NOT
// supported: * Conversation.name If not set or empty, all supported
// fields are updated.
func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCollectionsEnginesConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddiscoveryenginev1alphaconversation)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.conversations.patch" call.
// Exactly one of *GoogleCloudDiscoveryengineV1alphaConversation or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDiscoveryengineV1alphaConversation.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCollectionsEnginesConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDiscoveryengineV1alphaConversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDiscoveryengineV1alphaConversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Conversation. Conversation action type cannot be changed. If the Conversation to update does not exist, a NOT_FOUND error is returned.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/conversations/{conversationsId}",
	//   "httpMethod": "PATCH",
	//   "id": "discoveryengine.projects.locations.collections.engines.conversations.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. Fully qualified name `project/*/locations/global/collections/{collection}/dataStore/*/conversations/*` or `project/*/locations/global/collections/{collection}/engines/*/conversations/*`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/collections/[^/]+/engines/[^/]+/conversations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Conversation to update. The following are NOT supported: * Conversation.name If not set or empty, all supported fields are updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDiscoveryengineV1alphaConversation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "discoveryengine.projects.locations.collections.engines.operations.get":

type ProjectsLocationsCollectionsEnginesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCollectionsEnginesOperationsService) Get(name string) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c := &ProjectsLocationsCollectionsEnginesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCollectionsEnginesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "discoveryengine.projects.locations.collections.engines.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCollectionsEnginesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1alpha/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/engines/{enginesId}/operations/{operationsId}",
	//   "httpMethod": "GET"