/*
 * ZLint Copyright 2018 Regents of the University of Michigan
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package util

var tldMap = map[string]bool{
	"LIFE":                                 true,
	"LOFT":                                 true,
	"KDDI":                                 true,
	"GENTING":                              true,
	"NYC":                                  true,
	"DANCE":                                true,
	"ENGINEERING":                          true,
	"VEGAS":                                true,
	"CHASE":                                true,
	"GW":                                   true,
	"XN--Q9JYB4C":                          true,
	"GU":                                   true,
	"GT":                                   true,
	"GS":                                   true,
	"GR":                                   true,
	"GQ":                                   true,
	"GP":                                   true,
	"GLADE":                                true,
	"GG":                                   true,
	"GF":                                   true,
	"GE":                                   true,
	"GD":                                   true,
	"GB":                                   true,
	"GA":                                   true,
	"TUNES":                                true,
	"GN":                                   true,
	"GM":                                   true,
	"GL":                                   true,
	"GI":                                   true,
	"GH":                                   true,
	"MAP":                                  true,
	"MONEY":                                true,
	"HDFC":                                 true,
	"HEALTHCARE":                           true,
	"JNJ":                                  true,
	"PROPERTY":                             true,
	"MAN":                                  true,
	"FAITH":                                true,
	"DURBAN":                               true,
	"ERICSSON":                             true,
	"BET":                                  true,
	"EPSON":                                true,
	"ONYOURSIDE":                           true,
	"CAMERA":                               true,
	"XN--MGBAI9AZGQP6J":                    true,
	"SECURITY":                             true,
	"XN--2SCRJ9C":                          true,
	"ZM":                                   true,
	"XN--JVR189M":                          true,
	"PARIS":                                true,
	"ZA":                                   true,
	"SYSTEMS":                              true,
	"ACTIVE":                               true,
	"ZW":                                   true,
	"ZR":                                   true,
	"GIVING":                               true,
	"XN--L1ACC":                            true,
	"XN--42C2D9A":                          true,
	"TJX":                                  true,
	"NOW":                                  true,
	"TAIPEI":                               true,
	"OLLO":                                 true,
	"XN--C2BR7G":                           true,
	"XN--GECRJ9C":                          true,
	"GUGE":                                 true,
	"SMILE":                                true,
	"MOBI":                                 true,
	"WOLTERSKLUWER":                        true,
	"TOURS":                                true,
	"KITCHEN":                              true,
	"AIGO":                                 true,
	"AETNA":                                true,
	"XN--CLCHC0EA0B2G2A9GCD":               true,
	"HOTELS":                               true,
	"VOYAGE":                               true,
	"CONDOS":                               true,
	"VIRGIN":                               true,
	"WANGGOU":                              true,
	"EDU":                                  true,
	"ORG":                                  true,
	"XN--GCKR3F0F":                         true,
	"FARM":                                 true,
	"MOTO":                                 true,
	"NATURA":                               true,
	"BOSCH":                                true,
	"LB":                                   true,
	"LC":                                   true,
	"ONL":                                  true,
	"LA":                                   true,
	"SUPPLY":                               true,
	"LK":                                   true,
	"LI":                                   true,
	"LV":                                   true,
	"LT":                                   true,
	"LU":                                   true,
	"LR":                                   true,
	"LS":                                   true,
	"XN--MGBB9FBPOB":                       true,
	"JIO":                                  true,
	"SURGERY":                              true,
	"LOANS":                                true,
	"JPRS":                                 true,
	"LANCASTER":                            true,
	"FORD":                                 true,
	"SHOUJI":                               true,
	"GY":                                   true,
	"SMART":                                true,
	"CFD":                                  true,
	"CFA":                                  true,
	"HITACHI":                              true,
	"CALL":                                 true,
	"PNC":                                  true,
	"LIFESTYLE":                            true,
	"BRIDGESTONE":                          true,
	"TKMAXX":                               true,
	"XN--55QW42G":                          true,
	"RICHARDLI":                            true,
	"SCHWARZ":                              true,
	"CAPITALONE":                           true,
	"POHL":                                 true,
	"XN--RHQV96G":                          true,
	"CAREERS":                              true,
	"PARTNERS":                             true,
	"JOT":                                  true,
	"JOY":                                  true,
	"PRO":                                  true,
	"PRU":                                  true,
	"RUHR":                                 true,
	"LECLERC":                              true,
	"SAS":                                  true,
	"SAP":                                  true,
	"NEUSTAR":                              true,
	"YAMAXUN":                              true,
	"XN--KPU716F":                          true,
	"PROPERTIES":                           true,
	"APP":                                  true,
	"MENU":                                 true,
	"MCDONALDS":                            true,
	"XN--J6W193G":                          true,
	"HORSE":                                true,
	"DISCOVER":                             true,
	"SANOFI":                               true,
	"AMERICANFAMILY":                       true,
	"BOEHRINGER":                           true,
	"SPREADBETTING":                        true,
	"SHARP":                                true,
	"AFL":                                  true,
	"MEDIA":                                true,
	"RODEO":                                true,
	"XN--KCRX77D1X4A":                      true,
	"JUNIPER":                              true,
	"MOBILE":                               true,
	"WATCHES":                              true,
	"GLASS":                                true,
	"MOBILY":                               true,
	"PROF":                                 true,
	"PROD":                                 true,
	"KERRYLOGISTICS":                       true,
	"NATIONWIDE":                           true,
	"JPMORGAN":                             true,
	"FITNESS":                              true,
	"MUTUAL":                               true,
	"LAND":                                 true,
	"VENTURES":                             true,
	"KYOTO":                                true,
	"TRADE":                                true,
	"CLICK":                                true,
	"SHIA":                                 true,
	"BBC":                                  true,
	"COOKINGCHANNEL":                       true,
	"WHOSWHO":                              true,
	"CLUBMED":                              true,
	"BBT":                                  true,
	"AUDIBLE":                              true,
	"CHANNEL":                              true,
	"ALFAROMEO":                            true,
	"ISELECT":                              true,
	"TUI":                                  true,
	"TRADING":                              true,
	"XN--MGBA3A4F16A":                      true,
	"SAMSCLUB":                             true,
	"DEGREE":                               true,
	"XN--CCK2B3B":                          true,
	"MOTORCYCLES":                          true,
	"UNIVERSITY":                           true,
	"FYI":                                  true,
	"RIGHTATHOME":                          true,
	"ONLINE":                               true,
	"NINJA":                                true,
	"CLOUD":                                true,
	"LEGAL":                                true,
	"DELIVERY":                             true,
	"ALSACE":                               true,
	"SKIN":                                 true,
	"FLOWERS":                              true,
	"VIAJES":                               true,
	"QA":                                   true,
	"NICO":                                 true,
	"ORACLE":                               true,
	"SANDVIKCOROMANT":                      true,
	"PAY":                                  true,
	"BOSTIK":                               true,
	"XN--I1B6B1A6A2E":                      true,
	"LANDROVER":                            true,
	"HONDA":                                true,
	"AWS":                                  true,
	"XN--MGBBH1A":                          true,
	"LIVE":                                 true,
	"BLUE":                                 true,
	"WED":                                  true,
	"COOKING":                              true,
	"ANDROID":                              true,
	"MASERATI":                             true,
	"LIDL":                                 true,
	"KM":                                   true,
	"AEG":                                  true,
	"FIRMDALE":                             true,
	"XN--VUQ861B":                          true,
	"SEARCH":                               true,
	"BUY":                                  true,
	"AUTHOR":                               true,
	"REISE":                                true,
	"MEET":                                 true,
	"PRAXI":                                true,
	"LOVE":                                 true,
	"DELL":                                 true,
	"ZARA":                                 true,
	"COMCAST":                              true,
	"SEXY":                                 true,
	"XN--MXTQ1M":                           true,
	"SAPO":                                 true,
	"FINANCIAL":                            true,
	"AGAKHAN":                              true,
	"KOELN":                                true,
	"OSAKA":                                true,
	"MOV":                                  true,
	"COLOGNE":                              true,
	"MOI":                                  true,
	"JLC":                                  true,
	"JLL":                                  true,
	"XN--MGBA7C0BBN0A":                     true,
	"MOE":                                  true,
	"BCN":                                  true,
	"STREAM":                               true,
	"APARTMENTS":                           true,
	"BCG":                                  true,
	"DM":                                   true,
	"ITAU":                                 true,
	"CARAVAN":                              true,
	"SAARLAND":                             true,
	"TVS":                                  true,
	"IMAMAT":                               true,
	"CK":                                   true,
	"CI":                                   true,
	"CH":                                   true,
	"CO":                                   true,
	"CN":                                   true,
	"CM":                                   true,
	"CL":                                   true,
	"CC":                                   true,
	"CA":                                   true,
	"CG":                                   true,
	"CF":                                   true,
	"SRL":                                  true,
	"CD":                                   true,
	"XN--TCKWE":                            true,
	"CZ":                                   true,
	"CY":                                   true,
	"CX":                                   true,
	"SRT":                                  true,
	"CS":                                   true,
	"CR":                                   true,
	"CW":                                   true,
	"CV":                                   true,
	"CU":                                   true,
	"TDK":                                  true,
	"NAME":                                 true,
	"XN--MGBC0A9AZCG":                      true,
	"XN--NYQY26A":                          true,
	"VOTING":                               true,
	"JUEGOS":                               true,
	"MACYS":                                true,
	"BZH":                                  true,
	"LOL":                                  true,
	"YAHOO":                                true,
	"XN--LGBBAT1AD8J":                      true,
	"PIZZA":                                true,
	"COMMBANK":                             true,
	"XN--TIQ49XQYJ":                        true,
	"MODA":                                 true,
	"AIRTEL":                               true,
	"VA":                                   true,
	"VC":                                   true,
	"VE":                                   true,
	"VG":                                   true,
	"AUCTION":                              true,
	"VI":                                   true,
	"VN":                                   true,
	"VU":                                   true,
	"SOFTBANK":                             true,
	"XN--W4R85EL8FHU5DNRA":                 true,
	"TRUST":                                true,
	"PANERAI":                              true,
	"XN--KGBECHTV":                         true,
	"ABUDHABI":                             true,
	"ABBVIE":                               true,
	"STADA":                                true,
	"XBOX":                                 true,
	"BEATS":                                true,
	"WILLIAMHILL":                          true,
	"SPIEGEL":                              true,
	"DATING":                               true,
	"BUILDERS":                             true,
	"ALLY":                                 true,
	"STAPLES":                              true,
	"FUJIXEROX":                            true,
	"QUEBEC":                               true,
	"KPMG":                                 true,
	"LIVING":                               true,
	"FAIRWINDS":                            true,
	"XN--XKC2DL3A5EE0H":                    true,
	"RSVP":                                 true,
	"SURF":                                 true,
	"WINDOWS":                              true,
	"LOCKER":                               true,
	"SUPPORT":                              true,
	"HT":                                   true,
	"HU":                                   true,
	"HK":                                   true,
	"GAMES":                                true,
	"HM":                                   true,
	"LACAIXA":                              true,
	"MARKETING":                            true,
	"JMP":                                  true,
	"SCHAEFFLER":                           true,
	"SCA":                                  true,
	"SCB":                                  true,
	"NIKON":                                true,
	"SKYPE":                                true,
	"XN--FIQ228C5HS":                       true,
	"ASDA":                                 true,
	"WEATHERCHANNEL":                       true,
	"SNCF":                                 true,
	"AUTOS":                                true,
	"XN--BCK1B9A5DRE4C":                    true,
	"GAME":                                 true,
	"ALLSTATE":                             true,
	"INDUSTRIES":                           true,
	"MEMORIAL":                             true,
	"HANGOUT":                              true,
	"TEL":                                  true,
	"IVECO":                                true,
	"HR":                                   true,
	"WEATHER":                              true,
	"CALVINKLEIN":                          true,
	"BLOOMBERG":                            true,
	"ARTE":                                 true,
	"NBA":                                  true,
	"GMAIL":                                true,
	"XN--Y9A3AQ":                           true,
	"GMO":                                  true,
	"ADS":                                  true,
	"TRAVELERSINSURANCE":                   true,
	"XN--45Q11C":                           true,
	"FLIGHTS":                              true,
	"GMX":                                  true,
	"RENT":                                 true,
	"VRSN-END-OF-ZONE-MARKER-DUMMY-RECORD": true,
	"LUNDBECK":                             true,
	"ROGERS":                               true,
	"CANCERRESEARCH":                       true,
	"ROCHER":                               true,
	"DEMOCRAT":                             true,
	"SAFETY":                               true,
	"HN":                                   true,
	"AMICA":                                true,
	"ZAPPOS":                               true,
	"DISH":                                 true,
	"MARKETS":                              true,
	"GIFTS":                                true,
	"MERCKMSD":                             true,
	"EAT":                                  true,
	"BUGATTI":                              true,
	"SHOP":                                 true,
	"NORTHWESTERNMUTUAL":                   true,
	"BRADESCO":                             true,
	"ESQ":                                  true,
	"SHOW":                                 true,
	"WEIR":                                 true,
	"HOW":                                  true,
	"HOT":                                  true,
	"XN--NQV7F":                            true,
	"XN--1QQW23A":                          true,
	"RMIT":                                 true,
	"VERISIGN":                             true,
	"FIRESTONE":                            true,
	"XN--30RR7Y":                           true,
	"CHEAP":                                true,
	"SWIFTCOVER":                           true,
	"BOATS":                                true,
	"INTEL":                                true,
	"GROUP":                                true,
	"HYATT":                                true,
	"HOMEGOODS":                            true,
	"BIKE":                                 true,
	"CITADEL":                              true,
	"ABOGADO":                              true,
	"FIT":                                  true,
	"PICTET":                               true,
	"AZURE":                                true,
	"AUDIO":                                true,
	"LEASE":                                true,
	"XN--MGBGU82A":                         true,
	"REVIEW":                               true,
	"TATAR":                                true,
	"ISMAILI":                              true,
	"CLAIMS":                               true,
	"JEEP":                                 true,
	"COMPANY":                              true,
	"ACCOUNTANTS":                          true,
	"REALESTATE":                           true,
	"FISHING":                              true,
	"COOP":                                 true,
	"XN--8Y0A063A":                         true,
	"AFRICA":                               true,
	"SB":                                   true,
	"COOL":                                 true,
	"CITYEATS":                             true,
	"MD":                                   true,
	"MG":                                   true,
	"MA":                                   true,
	"RWE":                                  true,
	"MC":                                   true,
	"MM":                                   true,
	"ML":                                   true,
	"MO":                                   true,
	"AGENCY":                               true,
	"MH":                                   true,
	"MK":                                   true,
	"ENTERPRISES":                          true,
	"BLOG":                                 true,
	"MT":                                   true,
	"ACCOUNTANT":                           true,
	"MV":                                   true,
	"MQ":                                   true,
	"MP":                                   true,
	"MS":                                   true,
	"INK":                                  true,
	"GBIZ":                                 true,
	"ING":                                  true,
	"MY":                                   true,
	"MX":                                   true,
	"MZ":                                   true,
	"XN--MIX891F":                          true,
	"READ":                                 true,
	"CUISINELLA":                           true,
	"DOG":                                  true,
	"GRAINGER":                             true,
	"WINNERS":                              true,
	"LILLY":                                true,
	"DOT":                                  true,
	"GIFT":                                 true,
	"UPS":                                  true,
	"XN--E1A4C":                            true,
	"ORANGE":                               true,
	"XN--MGBA3A3EJT":                       true,
	"XN--D1ACJ3B":                          true,
	"UBANK":                                true,
	"SBS":                                  true,
	"SARL":                                 true,
	"MUSEUM":                               true,
	"NAGOYA":                               true,
	"PUB":                                  true,
	"SBI":                                  true,
	"MMA":                                  true,
	"BAR":                                  true,
	"WALES":                                true,
	"TELECITY":                             true,
	"WEBER":                                true,
	"XN--5SU34J936BGSG":                    true,
	"LIXIL":                                true,
	"DABUR":                                true,
	"LUXE":                                 true,
	"STC":                                  true,
	"HOMESENSE":                            true,
	"DENTAL":                               true,
	"REST":                                 true,
	"COMPUTER":                             true,
	"DIGITAL":                              true,
	"WEBCAM":                               true,
	"COMPARE":                              true,
	"THEATRE":                              true,
	"CERN":                                 true,
	"GENT":                                 true,
	"HEALTH":                               true,
	"ONG":                                  true,
	"ONE":                                  true,
	"XN--SES554G":                          true,
	"FILM":                                 true,
	"RU":                                   true,
	"SCHOLARSHIPS":                         true,
	"RS":                                   true,
	"GEORGE":                               true,
	"ANALYTICS":                            true,
	"WTC":                                  true,
	"WTF":                                  true,
	"SOCCER":                               true,
	"FAMILY":                               true,
	"ENERGY":                               true,
	"XN--OGBPF8FL":                         true,
	"YACHTS":                               true,
	"JAGUAR":                               true,
	"DUPONT":                               true,
	"LY":                                   true,
	"XN--NQV7FS00EMA":                      true,
	"XFINITY":                              true,
	"COUNTRY":                              true,
	"XN--90AE":                             true,
	"FINAL":                                true,
	"SLING":                                true,
	"QUEST":                                true,
	"XN--NGBRX":                            true,
	"HGTV":                                 true,
	"AMSTERDAM":                            true,
	"XN--JLQ61U9W7B":                       true,
	"OLAYANGROUP":                          true,
	"ABBOTT":                               true,
	"YOKOHAMA":                             true,
	"BLANCO":                               true,
	"SCHULE":                               true,
	"DATSUN":                               true,
	"TJMAXX":                               true,
	"ORIGINS":                              true,
	"IST":                                  true,
	"STUDIO":                               true,
	"CLINIQUE":                             true,
	"RENTALS":                              true,
	"SEW":                                  true,
	"SES":                                  true,
	"FINANCE":                              true,
	"SEX":                                  true,
	"WORLD":                                true,
	"XN--MGBI4ECEXP":                       true,
	"CARS":                                 true,
	"FRL":                                  true,
	"IPIRANGA":                             true,
	"CITIC":                                true,
	"XN--5TZM5G":                           true,
	"CARE":                                 true,
	"INFO":                                 true,
	"FRONTDOOR":                            true,
	"XN--FCT429K":                          true,
	"SOLAR":                                true,
	"XN--FZC2C9E2C":                        true,
	"DESIGN":                               true,
	"LEXUS":                                true,
	"BING":                                 true,
	"XN--DEBA0AD":                          true,
	"DO":                                   true,
	"FOREX":                                true,
	"DJ":                                   true,
	"DK":                                   true,
	"DE":                                   true,
	"XN--MGBTX2B":                          true,
	"CONTACT":                              true,
	"DZ":                                   true,
	"MAISON":                               true,
	"MLB":                                  true,
	"GOO":                                  true,
	"DHL":                                  true,
	"THEATER":                              true,
	"COUPON":                               true,
	"MLS":                                  true,
	"BOFA":                                 true,
	"GOT":                                  true,
	"GOV":                                  true,
	"GOP":                                  true,
	"CITY":                                 true,
	"ZONE":                                 true,
	"XN--NGBC5AZD":                         true,
	"NRA":                                  true,
	"CITI":                                 true,
	"ADULT":                                true,
	"NRW":                                  true,
	"DNP":                                  true,
	"WF":                                   true,
	"REVIEWS":                              true,
	"BERLIN":                               true,
	"WS":                                   true,
	"LAWYER":                               true,
	"XN--FJQ720A":                          true,
	"IMMOBILIEN":                           true,
	"RIP":                                  true,
	"RIO":                                  true,
	"RIL":                                  true,
	"XN--J1AEF":                            true,
	"XIN":                                  true,
	"HIPHOP":                               true,
	"KOMATSU":                              true,
	"BNL":                                  true,
	"TOWN":                                 true,
	"SCHOOL":                               true,
	"CHLOE":                                true,
	"RACING":                               true,
	"MU":                                   true,
	"XN--FIQS8S":                           true,
	"WALTER":                               true,
	"XN--55QX5D":                           true,
	"HELP":                                 true,
	"FERRARI":                              true,
	"FIAT":                                 true,
	"ROOM":                                 true,
	"LDS":                                  true,
	"FOOD":                                 true,
	"BLOCKBUSTER":                          true,
	"ROOT":                                 true,
	"HOMES":                                true,
	"LAMBORGHINI":                          true,
	"CLUB":                                 true,
	"FOX":                                  true,
	"FUND":                                 true,
	"TOYS":                                 true,
	"DOWNLOAD":                             true,
	"FOO":                                  true,
	"TODAY":                                true,
	"XN--FPCRJ9C3D":                        true,
	"PRUDENTIAL":                           true,
	"LGBT":                                 true,
	"AUSPOST":                              true,
	"FAGE":                                 true,
	"WINE":                                 true,
	"PET":                                  true,
	"MADRID":                               true,
	"FISH":                                 true,
	"VOLVO":                                true,
	"CARDS":                                true,
	"ASSOCIATES":                           true,
	"COM":                                  true,
	"CASE":                                 true,
	"CASA":                                 true,
	"CASH":                                 true,
	"ORGANIC":                              true,
	"MAKEUP":                               true,
	"SHIKSHA":                              true,
	"DUNS":                                 true,
	"XIHUAN":                               true,
	"RUN":                                  true,
	"MORTGAGE":                             true,
	"FLORIST":                              true,
	"BNPPARIBAS":                           true,
	"STORAGE":                              true,
	"AMEX":                                 true,
	"DIY":                                  true,
	"AIG":                                  true,
	"IEEE":                                 true,
	"ZIP":                                  true,
	"CHROME":                               true,
	"XXX":                                  true,
	"XN--UNUP4Y":                           true,
	"SOFTWARE":                             true,
	"DUBAI":                                true,
	"XN--ECKVDTC9D":                        true,
	"IQ":                                   true,
	"IS":                                   true,
	"IR":                                   true,
	"IT":                                   true,
	"XN--G2XX48C":                          true,
	"IM":                                   true,
	"IL":                                   true,
	"IO":                                   true,
	"IN":                                   true,
	"CBRE":                                 true,
	"UCONNECT":                             true,
	"FIDELITY":                             true,
	"MARSHALLS":                            true,
	"ID":                                   true,
	"SHOES":                                true,
	"XN--MGBBH1A71E":                       true,
	"PWC":                                  true,
	"NAB":                                  true,
	"HBO":                                  true,
	"GRIPE":                                true,
	"FEDEX":                                true,
	"DISCOUNT":                             true,
	"PARS":                                 true,
	"BOM":                                  true,
	"BOO":                                  true,
	"SG":                                   true,
	"INVESTMENTS":                          true,
	"EDEKA":                                true,
	"XN--EFVY88H":                          true,
	"RELIANCE":                             true,
	"LUXURY":                               true,
	"SYDNEY":                               true,
	"XN--S9BRJ9C":                          true,
	"DELOITTE":                             true,
	"FOODNETWORK":                          true,
	"GOOGLE":                               true,
	"WARMAN":                               true,
	"SAFE":                                 true,
	"XN--VERMGENSBERATER-CTB":              true,
	"PIAGET":                               true,
	"YODOBASHI":                            true,
	"XN--CG4BKI":                           true,
	"TATAMOTORS":                           true,
	"CREDIT":                               true,
	"FLY":                                  true,
	"XN--0ZWM56D":                          true,
	"MOSCOW":                               true,
	"AE":                                   true,
	"EXTRASPACE":                           true,
	"NOKIA":                                true,
	"QVC":                                  true,
	"TRAVELCHANNEL":                        true,
	"XN--KPRW13D":                          true,
	"VOLKSWAGEN":                           true,
	"PLACE":                                true,
	"GRAPHICS":                             true,
	"ANQUAN":                               true,
	"TRV":                                  true,
	"HTC":                                  true,
	"XN--MGB9AWBF":                         true,
	"COMSEC":                               true,
	"XEROX":                                true,
	"SILK":                                 true,
	"NI":                                   true,
	"NL":                                   true,
	"NO":                                   true,
	"TRAVELERS":                            true,
	"NC":                                   true,
	"CANON":                                true,
	"NE":                                   true,
	"NF":                                   true,
	"NG":                                   true,
	"KOSHER":                               true,
	"KINDER":                               true,
	"NZ":                                   true,
	"TECH":                                 true,
	"XN--80ASEHDB":                         true,
	"NP":                                   true,
	"NR":                                   true,
	"NU":                                   true,
	"KIWI":                                 true,
	"MIAMI":                                true,
	"GOLDPOINT":                            true,
	"XN--9T4B11YI5A":                       true,
	"CONSTRUCTION":                         true,
	"KRED":                                 true,
	"GUITARS":                              true,
	"LEGO":                                 true,
	"ACADEMY":                              true,
	"XN--CZRU2D":                           true,
	"CONTRACTORS":                          true,
	"COFFEE":                               true,
	"ONION":                                true,
	"XN--MGBAB2BD":                         true,
	"VISA":                                 true,
	"SEEK":                                 true,
	"SHRIRAM":                              true,
	"EXCHANGE":                             true,
	"HAMBURG":                              true,
	"SUPPLIES":                             true,
	"FIRE":                                 true,
	"RECIPES":                              true,
	"ICE":                                  true,
	"ICU":                                  true,
	"JAVA":                                 true,
	"LEFRAK":                               true,
	"XN--H2BREG3EVE":                       true,
	"LANCIA":                               true,
	"CYMRU":                                true,
	"FAIL":                                 true,
	"HONEYWELL":                            true,
	"YUN":                                  true,
	"XN--6QQ986B3XL":                       true,
	"DODGE":                                true,
	"STARHUB":                              true,
	"PHONE":                                true,
	"PICTURES":                             true,
	"TAX":                                  true,
	"TAB":                                  true,
	"XN--WGBL6A":                           true,
	"NORTON":                               true,
	"LAMER":                                true,
	"PRIME":                                true,
	"FEEDBACK":                             true,
	"FORUM":                                true,
	"GUARDIAN":                             true,
	"GALLUP":                               true,
	"CATHOLIC":                             true,
	"HOUSE":                                true,
	"XYZ":                                  true,
	"EXPRESS":                              true,
	"BOOTS":                                true,
	"COLLEGE":                              true,
	"VACATIONS":                            true,
	"RICH":                                 true,
	"LIFEINSURANCE":                        true,
	"VIKING":                               true,
	"STOCKHOLM":                            true,
	"POLITIE":                              true,
	"MARKET":                               true,
	"BUDAPEST":                             true,
	"SHAW":                                 true,
	"LTDA":                                 true,
	"LATINO":                               true,
	"RUGBY":                                true,
	"LOAN":                                 true,
	"NFL":                                  true,
	"PROTECTION":                           true,
	"BABY":                                 true,
	"KPN":                                  true,
	"LIAISON":                              true,
	"OKINAWA":                              true,
	"CROWN":                                true,
	"SUCKS":                                true,
	"YOGA":                                 true,
	"REN":                                  true,
	"BARCLAYCARD":                          true,
	"RED":                                  true,
	"ENGINEER":                             true,
	"TRAINING":                             true,
	"XN--MGBT3DHD":                         true,
	"WALMART":                              true,
	"XN--C1AVG":                            true,
	"VET":                                  true,
	"AMFAM":                                true,
	"REISEN":                               true,
	"HOSTING":                              true,
	"LTD":                                  true,
	"SZ":                                   true,
	"SY":                                   true,
	"SX":                                   true,
	"XN--45BR5CYL":                         true,
	"SR":                                   true,
	"SV":                                   true,
	"SU":                                   true,
	"ST":                                   true,
	"SK":                                   true,
	"SJ":                                   true,
	"SI":                                   true,
	"SH":                                   true,
	"SO":                                   true,
	"SN":                                   true,
	"SM":                                   true,
	"SL":                                   true,
	"SC":                                   true,
	"LANXESS":                              true,
	"SA":                                   true,
	"OLAYAN":                               true,
	"SE":                                   true,
	"SD":                                   true,
	"JOBURG":                               true,
	"IBM":                                  true,
	"CAR":                                  true,
	"CAT":                                  true,
	"CAM":                                  true,
	"CAL":                                  true,
	"DATE":                                 true,
	"CAB":                                  true,
	"DATA":                                 true,
	"ALLFINANZ":                            true,
	"AIRFORCE":                             true,
	"ASIA":                                 true,
	"TIRES":                                true,
	"SANDVIK":                              true,
	"PANASONIC":                            true,
	"XN--90A3AC":                           true,
	"RAID":                                 true,
	"DOCS":                                 true,
	"STUDY":                                true,
	"ISTANBUL":                             true,
	"NIKE":                                 true,
	"SINGLES":                              true,
	"XN--MGBAAKC7DVF":                      true,
	"MIL":                                  true,
	"TIENDA":                               true,
	"LINK":                                 true,
	"FRESENIUS":                            true,
	"MIT":                                  true,
	"PROMO":                                true,
	"AOL":                                  true,
	"XN--3HCRJ9C":                          true,
	"PLUS":                                 true,
	"HOCKEY":                               true,
	"TOTAL":                                true,
	"PHILIPS":                              true,
	"XN--9KRT00A":                          true,
	"IKANO":                                true,
	"BOUTIQUE":                             true,
	"SFR":                                  true,
	"SAVE":                                 true,
	"ATTORNEY":                             true,
	"NGO":                                  true,
	"PIONEER":                              true,
	"HOLDINGS":                             true,
	"BMS":                                  true,
	"BMW":                                  true,
	"PRESS":                                true,
	"ADAC":                                 true,
	"COUPONS":                              true,
	"AERO":                                 true,
	"MCKINSEY":                             true,
	"EE":                                   true,
	"EG":                                   true,
	"EC":                                   true,
	"CATERING":                             true,
	"LATROBE":                              true,
	"EU":                                   true,
	"ET":                                   true,
	"POST":                                 true,
	"SAXO":                                 true,
	"ES":                                   true,
	"ER":                                   true,
	"XN--H2BRJ9C8C":                        true,
	"XN--4GBRIM":                           true,
	"ECO":                                  true,
	"INSURANCE":                            true,
	"NETFLIX":                              true,
	"XN--9DBQ2A":                           true,
	"CAPITAL":                              true,
	"BASEBALL":                             true,
	"YANDEX":                               true,
	"BAYERN":                               true,
	"XN--VHQUV":                            true,
	"IE":                                   true,
	"HOSPITAL":                             true,
	"AFAMILYCOMPANY":                       true,
	"GODADDY":                              true,
	"FLICKR":                               true,
	"LINCOLN":                              true,
	"XN--XHQ521B":                          true,
	"BESTBUY":                              true,
	"REALTY":                               true,
	"DEALER":                               true,
	"HSBC":                                 true,
	"XN--MK1BU44C":                         true,
	"XN--90AIS":                            true,
	"GRATIS":                               true,
	"VISTA":                                true,
	"ROCKS":                                true,
	"DUCK":                                 true,
	"SINA":                                 true,
	"CRICKET":                              true,
	"BASKETBALL":                           true,
	"EXPOSED":                              true,
	"TEAM":                                 true,
	"QPON":                                 true,
	"CAPETOWN":                             true,
	"MORMON":                               true,
	"EUROVISION":                           true,
	"STORE":                                true,
	"IMMO":                                 true,
	"WATCH":                                true,
	"NOWRUZ":                               true,
	"OTT":                                  true,
	"BOX":                                  true,
	"BE":                                   true,
	"XN--H2BRJ9C":                          true,
	"JP":                                   true,
	"JM":                                   true,
	"JO":                                   true,
	"JE":                                   true,
	"PCCW":                                 true,
	"XN--MGBAYH7GPA":                       true,
	"IWC":                                  true,
	"BB":                                   true,
	"NEXT":                                 true,
	"PRODUCTIONS":                          true,
	"EUS":                                  true,
	"XN--MGBCA7DZDO":                       true,
	"XN--3DS443G":                          true,
	"OFF":                                  true,
	"BOT":                                  true,
	"XN--FHBEI":                            true,
	"XN--IMR513N":                          true,
	"XN--P1AI":                             true,
	"XN--NODE":                             true,
	"XN--FLW351E":                          true,
	"SALON":                                true,
	"XN--YFRO4I67O":                        true,
	"PHD":                                  true,
	"CIRCLE":                               true,
	"ALIPAY":                               true,
	"SHOPPING":                             true,
	"PORN":                                 true,
	"SKY":                                  true,
	"BROTHER":                              true,
	"CARTIER":                              true,
	"VERSICHERUNG":                         true,
	"BRUSSELS":                             true,
	"SKI":                                  true,
	"SOCIAL":                               true,
	"RESTAURANT":                           true,
	"BY":                                   true,
	"GEA":                                  true,
	"VIDEO":                                true,
	"TCI":                                  true,
	"DDS":                                  true,
	"BBVA":                                 true,
	"LIMO":                                 true,
	"BOOKING":                              true,
	"XN--W4RS40L":                          true,
	"ANZ":                                  true,
	"OFFICE":                               true,
	"GLOBAL":                               true,
	"SCHMIDT":                              true,
	"APPLE":                                true,
	"ARMY":                                 true,
	"MOVISTAR":                             true,
	"TALK":                                 true,
	"ME":                                   true,
	"OBSERVER":                             true,
	"ATHLETA":                              true,
	"KRD":                                  true,
	"KAUFEN":                               true,
	"JETZT":                                true,
	"XN--G6W251D":                          true,
	"INT":                                  true,
	"HOMEDEPOT":                            true,
	"ACCENTURE":                            true,
	"XN--45BRJ9C":                          true,
	"MN":                                   true,
	"SWISS":                                true,
	"ICBC":                                 true,
	"EVERBANK":                             true,
	"GIVES":                                true,
	"TATTOO":                               true,
	"MW":                                   true,
	"XN--MGBX4CD0AB":                       true,
	"FAN":                                  true,
	"GOOG":                                 true,
	"STYLE":                                true,
	"NADEX":                                true,
	"MR":                                   true,
	"SPOT":                                 true,
	"CLINIC":                               true,
	"DESI":                                 true,
	"YOU":                                  true,
	"PINK":                                 true,
	"RYUKYU":                               true,
	"PING":                                 true,
	"PHARMACY":                             true,
	"UNICOM":                               true,
	"DIAMONDS":                             true,
	"LADBROKES":                            true,
	"HOTELES":                              true,
	"XN--ROVU88B":                          true,
	"CAMP":                                 true,
	"HISAMITSU":                            true,
	"XN--11B5BS3A9AJ6G":                    true,
	"INTERNATIONAL":                        true,
	"TOSHIBA":                              true,
	"POKER":                                true,
	"PIN":                                  true,
	"PID":                                  true,
	"FLIR":                                 true,
	"CORSICA":                              true,
	"BAUHAUS":                              true,
	"GLE":                                  true,
	"WME":                                  true,
	"INSURE":                               true,
	"OM":                                   true,
	"UBS":                                  true,
	"MAIF":                                 true,
	"WEDDING":                              true,
	"ARCHI":                                true,
	"XN--1CK2E1B":                          true,
	"DEV":                                  true,
	"ESURANCE":                             true,
	"AUDI":                                 true,
	"SUZUKI":                               true,
	"VISION":                               true,
	"SCOR":                                 true,
	"BANAMEX":                              true,
	"CRUISE":                               true,
	"GUIDE":                                true,
	"BAIDU":                                true,
	"FRONTIER":                             true,
	"XN--11B4C3D":                          true,
	"NEWHOLLAND":                           true,
	"DCLK":                                 true,
	"FERRERO":                              true,
	"MICROSOFT":                            true,
	"ACO":                                  true,
	"NEC":                                  true,
	"XN--YGBI2AMMX":                        true,
	"SERVICES":                             true,
	"NEW":                                  true,
	"NET":                                  true,
	"OPEN":                                 true,
	"SALE":                                 true,
	"SOHU":                                 true,
	"EARTH":                                true,
	"METLIFE":                              true,
	"TORAY":                                true,
	"GALLERY":                              true,
	"MEME":                                 true,
	"LANCOME":                              true,
	"XN--54B7FTA0CC":                       true,
	"REIT":                                 true,
	"MED":                                  true,
	"HDFCBANK":                             true,
	"MEO":                                  true,
	"MEN":                                  true,
	"BOOK":                                 true,
	"GDN":                                  true,
	"FURNITURE":                            true,
	"BIBLE":                                true,
	"GOLF":                                 true,
	"GOLD":                                 true,
	"INTUIT":                               true,
	"MELBOURNE":                            true,
	"SHANGRILA":                            true,
	"TEMASEK":                              true,
	"CHRISTMAS":                            true,
	"TZ":                                   true,
	"TV":                                   true,
	"TW":                                   true,
	"TT":                                   true,
	"TR":                                   true,
	"TP":                                   true,
	"TN":                                   true,
	"TO":                                   true,
	"TL":                                   true,
	"TM":                                   true,
	"TJ":                                   true,
	"TK":                                   true,
	"TH":                                   true,
	"TF":                                   true,
	"TG":                                   true,
	"TD":                                   true,
	"TC":                                   true,
	"AC":                                   true,
	"ALSTOM":                               true,
	"AD":                                   true,
	"AG":                                   true,
	"AF":                                   true,
	"AI":                                   true,
	"AM":                                   true,
	"AL":                                   true,
	"AO":                                   true,
	"AN":                                   true,
	"AQ":                                   true,
	"PAMPEREDCHEF":                         true,
	"AS":                                   true,
	"AR":                                   true,
	"AU":                                   true,
	"AT":                                   true,
	"AW":                                   true,
	"AX":                                   true,
	"AZ":                                   true,
	"SEVEN":                                true,
	"COACH":                                true,
	"KERRYPROPERTIES":                      true,
	"COURSES":                              true,
	"CAFE":                                 true,
	"WIEN":                                 true,
	"ARPA":                                 true,
	"WIKI":                                 true,
	"XN--ZFR164B":                          true,
	"IRISH":                                true,
	"PHOTO":                                true,
	"AXA":                                  true,
	"FIDO":                                 true,
	"LAT":                                  true,
	"OVH":                                  true,
	"LAW":                                  true,
	"MOVIE":                                true,
	"YOUTUBE":                              true,
	"SEAT":                                 true,
	"SWATCH":                               true,
	"HERMES":                               true,
	"DTV":                                  true,
	"SELECT":                               true,
	"UOL":                                  true,
	"MONASH":                               true,
	"DOCTOR":                               true,
	"CYOU":                                 true,
	"DVAG":                                 true,
	"TELEFONICA":                           true,
	"FTR":                                  true,
	"KERRYHOTELS":                          true,
	"HAUS":                                 true,
	"VANA":                                 true,
	"RICOH":                                true,
	"REPUBLICAN":                           true,
	"TECHNOLOGY":                           true,
	"LIPSY":                                true,
	"CBA":                                  true,
	"CAREER":                               true,
	"XN--MGBAAM7A8H":                       true,
	"CBN":                                  true,
	"CBS":                                  true,
	"CHRYSLER":                             true,
	"TUSHU":                                true,
	"FR":                                   true,
	"CODES":                                true,
	"INSTITUTE":                            true,
	"HAIR":                                 true,
	"BLACKFRIDAY":                          true,
	"FI":                                   true,
	"FJ":                                   true,
	"FK":                                   true,
	"FM":                                   true,
	"XN--MGBPL2FH":                         true,
	"FO":                                   true,
	"VLAANDEREN":                           true,
	"NATO":                                 true,
	"SOLUTIONS":                            true,
	"OMEGA":                                true,
	"BOND":                                 true,
	"BAREFOOT":                             true,
	"BARGAINS":                             true,
	"ESTATE":                               true,
	"SITE":                                 true,
	"HOST":                                 true,
	"MITSUBISHI":                           true,
	"LIKE":                                 true,
	"NOWTV":                                true,
	"KUOKGROUP":                            true,
	"NTT":                                  true,
	"ORIENTEXPRESS":                        true,
	"RADIO":                                true,
	"PAGE":                                 true,
	"CONSULTING":                           true,
	"DUNLOP":                               true,
	"XN--3OQ18VL8PN36A":                    true,
	"TOP":                                  true,
	"YE":                                   true,
	"GREEN":                                true,
	"FUTBOL":                               true,
	"YU":                                   true,
	"YT":                                   true,
	"HIV":                                  true,
	"XN--B4W605FERD":                       true,
	"NHK":                                  true,
	"XN--VERMGENSBERATUNG-PWB":             true,
	"KFH":                                  true,
	"REALTOR":                              true,
	"ABB":                                  true,
	"ABC":                                  true,
	"XN--FZYS8D69UVGM":                     true,
	"BAND":                                 true,
	"INFINITI":                             true,
	"XN--80ADXHKS":                         true,
	"GOODHANDS":                            true,
	"BANK":                                 true,
	"TOYOTA":                               true,
	"OTSUKA":                               true,
	"TOOLS":                                true,
	"AQUARELLE":                            true,
	"TAXI":                                 true,
	"WOODSIDE":                             true,
	"ARAB":                                 true,
	"XN--9ET52U":                           true,
	"XN--D1ALF":                            true,
	"CLOTHING":                             true,
	"AKDN":                                 true,
	"ARAMCO":                               true,
	"FOUNDATION":                           true,
	"XPERIA":                               true,
	"TOKYO":                                true,
	"ACTOR":                                true,
	"LPL":                                  true,
	"SCJOHNSON":                            true,
	"PLAYSTATION":                          true,
	"VIG":                                  true,
	"GURU":                                 true,
	"PFIZER":                               true,
	"NISSAN":                               true,
	"VIN":                                  true,
	"VIP":                                  true,
	"NISSAY":                               true,
	"STAR":                                 true,
	"BUSINESS":                             true,
	"DOOSAN":                               true,
	"VUELOS":                               true,
	"FUN":                                  true,
	"IFM":                                  true,
	"ALIBABA":                              true,
	"WEBSITE":                              true,
	"CEB":                                  true,
	"NEXUS":                                true,
	"SAKURA":                               true,
	"SHOWTIME":                             true,
	"WOW":                                  true,
	"CSC":                                  true,
	"HOTMAIL":                              true,
	"CRUISES":                              true,
	"TUBE":                                 true,
	"LOCUS":                                true,
	"NA":                                   true,
	"FARMERS":                              true,
	"XN--WGBH1C":                           true,
	"MANGO":                                true,
	"COMMUNITY":                            true,
	"CHAT":                                 true,
	"JOBS":                                 true,
	"WORKS":                                true,
	"CHANEL":                               true,
	"TAOBAO":                               true,
	"MANAGEMENT":                           true,
	"XN--PSSY2U":                           true,
	"WORK":                                 true,
	"REDUMBRELLA":                          true,
	"CIPRIANI":                             true,
	"XN--QCKA1PMC":                         true,
	"JEWELRY":                              true,
	"PROGRESSIVE":                          true,
	"MUTUELLE":                             true,
	"FROGANS":                              true,
	"HERE":                                 true,
	"UNO":                                  true,
	"VIVA":                                 true,
	"KG":                                   true,
	"TARGET":                               true,
	"KE":                                   true,
	"KI":                                   true,
	"KH":                                   true,
	"KN":                                   true,
	"VIVO":                                 true,
	"MATTEL":                               true,
	"KR":                                   true,
	"VANGUARD":                             true,
	"KP":                                   true,
	"KW":                                   true,
	"ITV":                                  true,
	"KZ":                                   true,
	"KY":                                   true,
	"MOPAR":                                true,
	"XN--PGBS0DH":                          true,
	"GROCERY":                              true,
	"AAA":                                  true,
	"NETWORK":                              true,
	"EQUIPMENT":                            true,
	"BLACK":                                true,
	"AIRBUS":                               true,
	"BIO":                                  true,
	"XN--GK3AT1E":                          true,
	"BENTLEY":                              true,
	"BID":                                  true,
	"BIZ":                                  true,
	"XN--CZR694B":                          true,
	"TIPS":                                 true,
	"EPOST":                                true,
	"ETISALAT":                             true,
	"BHARTI":                               true,
	"CASEIH":                               true,
	"XN--T60B56A":                          true,
	"MCD":                                  true,
	"AMERICANEXPRESS":                      true,
	"WEIBO":                                true,
	"WANG":                                 true,
	"MONTBLANC":                            true,
	"PHOTOS":                               true,
	"GMBH":                                 true,
	"CLEANING":                             true,
	"BEST":                                 true,
	"GLOBO":                                true,
	"EXPERT":                               true,
	"PHOTOGRAPHY":                          true,
	"TENNIS":                               true,
	"PICS":                                 true,
	"PLUMBING":                             true,
	"EMERCK":                               true,
	"XN--ESTV75G":                          true,
	"SONG":                                 true,
	"REHAB":                                true,
	"SONY":                                 true,
	"THD":                                  true,
	"LINDE":                                true,
	"CREDITUNION":                          true,
	"XN--P1ACF":                            true,
	"DENTIST":                              true,
	"KIM":                                  true,
	"KIA":                                  true,
	"XN--NGBE9E0A":                         true,
	"CRS":                                  true,
	"XN--RVC1E0AM3E":                       true,
	"NETBANK":                              true,
	"DIRECT":                               true,
	"ZIPPO":                                true,
	"BROADWAY":                             true,
	"PR":                                   true,
	"PS":                                   true,
	"PW":                                   true,
	"PT":                                   true,
	"PY":                                   true,
	"XN--KPRY57D":                          true,
	"XN--3BST00M":                          true,
	"FANS":                                 true,
	"PA":                                   true,
	"PF":                                   true,
	"PG":                                   true,
	"PE":                                   true,
	"PK":                                   true,
	"PH":                                   true,
	"PN":                                   true,
	"PL":                                   true,
	"PM":                                   true,
	"RW":                                   true,
	"KINDLE":                               true,
	"DOMAINS":                              true,
	"FORSALE":                              true,
	"XN--IO0A7I":                           true,
	"XN--ZCKZAH":                           true,
	"ZUERICH":                              true,
	"TMALL":                                true,
	"REXROTH":                              true,
	"BEER":                                 true,
	"BUZZ":                                 true,
	"BANANAREPUBLIC":                       true,
	"BINGO":                                true,
	"DOHA":                                 true,
	"PHYSIO":                               true,
	"FUJITSU":                              true,
	"CHURCH":                               true,
	"DVR":                                  true,
	"HUGHES":                               true,
	"RE":                                   true,
	"TIFFANY":                              true,
	"OBI":                                  true,
	"FREE":                                 true,
	"BARCLAYS":                             true,
	"LIGHTING":                             true,
	"DIRECTORY":                            true,
	"AVIANCA":                              true,
	"XN--3E0B707E":                         true,
	"RO":                                   true,
	"MONSTER":                              true,
	"TRAVEL":                               true,
	"CASINO":                               true,
	"CREDITCARD":                           true,
	"FLSMIDTH":                             true,
	"LONDON":                               true,
	"TIAA":                                 true,
	"VODKA":                                true,
	"PRAMERICA":                            true,
	"MBA":                                  true,
	"GAP":                                  true,
	"GAL":                                  true,
	"SOY":                                  true,
	"XN--PBT977C":                          true,
	"JCP":                                  true,
	"MOM":                                  true,
	"BEAUTY":                               true,
	"MTR":                                  true,
	"AUTO":                                 true,
	"FOOTBALL":                             true,
	"BARCELONA":                            true,
	"XN--O3CW4H":                           true,
	"MTN":                                  true,
	"JCB":                                  true,
	"MTPC":                                 true,
	"ART":                                  true,
	"XN--80AQECDR1A":                       true,
	"XN--6FRZ82G":                          true,
	"DELTA":                                true,
	"BD":                                   true,
	"REPAIR":                               true,
	"BF":                                   true,
	"BG":                                   true,
	"BA":                                   true,
	"DEAL":                                 true,
	"BM":                                   true,
	"BN":                                   true,
	"BO":                                   true,
	"BH":                                   true,
	"BI":                                   true,
	"BJ":                                   true,
	"BT":                                   true,
	"BV":                                   true,
	"BW":                                   true,
	"BR":                                   true,
	"BS":                                   true,
	"GGEE":                                 true,
	"STATEFARM":                            true,
	"EMAIL":                                true,
	"BZ":                                   true,
	"SHELL":                                true,
	"HKT":                                  true,
	"EVENTS":                               true,
	"TICKETS":                              true,
	"XN--80AO21A":                          true,
	"PARTS":                                true,
	"BUILD":                                true,
	"SENER":                                true,
	"NAVY":                                 true,
	"PARTY":                                true,
	"LIMITED":                              true,
	"CISCO":                                true,
	"SCOT":                                 true,
	"VILLAS":                               true,
	"XN--XKC2AL3HYE2A":                     true,
	"GARDEN":                               true,
	"STATOIL":                              true,
	"XN--HXT814E":                          true,
	"REPORT":                               true,
	"CENTER":                               true,
	"TEVA":                                 true,
	"SAMSUNG":                              true,
	"SCIENCE":                              true,
	"XN--J1AMH":                            true,
	"LUPIN":                                true,
	"DEALS":                                true,
	"GUCCI":                                true,
	"FASHION":                              true,
	"XN--QXAM":                             true,
	"REDSTONE":                             true,
	"UY":                                   true,
	"UZ":                                   true,
	"US":                                   true,
	"UM":                                   true,
	"UK":                                   true,
	"UG":                                   true,
	"EDUCATION":                            true,
	"UA":                                   true,
	"BROKER":                               true,
	"XN--HLCJ6AYA9ESC7A":                   true,
	"IMDB":                                 true,
	"XN--HGBK6AJ7F53BBA":                   true,
	"HOLIDAY":                              true,
	"HYUNDAI":                              true,
	"FAST":                                 true,
	"TIROL":                                true,
	"MARRIOTT":                             true,
	"MINI":                                 true,
	"DIET":                                 true,
	"LPLFINANCIAL":                         true,
	"PASSAGENS":                            true,
	"XN--80AKHBYKNJ4F":                     true,
	"MINT":                                 true,
	"STCGROUP":                             true,
	"GALLO":                                true,
	"VISTAPRINT":                           true,
	"WIN":                                  true,
	"ABLE":                                 true,
	"XN--80ASWG":                           true,
	"STATEBANK":                            true,
	"NEXTDIRECT":                           true,
	"LOTTE":                                true,
	"SECURE":                               true,
	"BOSTON":                               true,
	"LOTTO":                                true,
	"XN--FIQZ9S":                           true,
	"DRIVE":                                true,
	"NEWS":                                 true,
	"MSD":                                  true,
	"DAD":                                  true,
	"ERNI":                                 true,
	"HELSINKI":                             true,
	"XN--JXALPDLP":                         true,
	"LASALLE":                              true,
	"XN--3PXU8K":                           true,
	"XN--FIQ64B":                           true,
	"DAY":                                  true,
	"PLAY":                                 true,
	"SYMANTEC":                             true,
	"SPACE":                                true,
	"CHINTAI":                              true,
	"OLDNAVY":                              true,
	"XN--MGBERP4A5D4AR":                    true,
	"VOTO":                                 true,
	"IINET":                                true,
	"VOTE":                                 true,
	"AARP":                                 true,
	"XN--CZRS0T":                           true,
	"OOO":                                  true,
	"ZERO":                                 true,
	"XN--KPUT3I":                           true,
	"CEO":                                  true,
	"ABARTH":                               true,
	"GOODYEAR":                             true,
}
