// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gkebackup/v1/gkebackup.proto

package gkebackuppb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BackupForGKE_CreateBackupPlan_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupPlan"
	BackupForGKE_ListBackupPlans_FullMethodName           = "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlans"
	BackupForGKE_GetBackupPlan_FullMethodName             = "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlan"
	BackupForGKE_UpdateBackupPlan_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupPlan"
	BackupForGKE_DeleteBackupPlan_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupPlan"
	BackupForGKE_CreateBackupChannel_FullMethodName       = "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupChannel"
	BackupForGKE_ListBackupChannels_FullMethodName        = "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupChannels"
	BackupForGKE_GetBackupChannel_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupChannel"
	BackupForGKE_UpdateBackupChannel_FullMethodName       = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupChannel"
	BackupForGKE_DeleteBackupChannel_FullMethodName       = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupChannel"
	BackupForGKE_ListBackupPlanBindings_FullMethodName    = "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlanBindings"
	BackupForGKE_GetBackupPlanBinding_FullMethodName      = "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlanBinding"
	BackupForGKE_CreateBackup_FullMethodName              = "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackup"
	BackupForGKE_ListBackups_FullMethodName               = "/google.cloud.gkebackup.v1.BackupForGKE/ListBackups"
	BackupForGKE_GetBackup_FullMethodName                 = "/google.cloud.gkebackup.v1.BackupForGKE/GetBackup"
	BackupForGKE_UpdateBackup_FullMethodName              = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackup"
	BackupForGKE_DeleteBackup_FullMethodName              = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackup"
	BackupForGKE_ListVolumeBackups_FullMethodName         = "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeBackups"
	BackupForGKE_GetVolumeBackup_FullMethodName           = "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeBackup"
	BackupForGKE_CreateRestorePlan_FullMethodName         = "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestorePlan"
	BackupForGKE_ListRestorePlans_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlans"
	BackupForGKE_GetRestorePlan_FullMethodName            = "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlan"
	BackupForGKE_UpdateRestorePlan_FullMethodName         = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestorePlan"
	BackupForGKE_DeleteRestorePlan_FullMethodName         = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestorePlan"
	BackupForGKE_CreateRestoreChannel_FullMethodName      = "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestoreChannel"
	BackupForGKE_ListRestoreChannels_FullMethodName       = "/google.cloud.gkebackup.v1.BackupForGKE/ListRestoreChannels"
	BackupForGKE_GetRestoreChannel_FullMethodName         = "/google.cloud.gkebackup.v1.BackupForGKE/GetRestoreChannel"
	BackupForGKE_UpdateRestoreChannel_FullMethodName      = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestoreChannel"
	BackupForGKE_DeleteRestoreChannel_FullMethodName      = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestoreChannel"
	BackupForGKE_ListRestorePlanBindings_FullMethodName   = "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlanBindings"
	BackupForGKE_GetRestorePlanBinding_FullMethodName     = "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlanBinding"
	BackupForGKE_CreateRestore_FullMethodName             = "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestore"
	BackupForGKE_ListRestores_FullMethodName              = "/google.cloud.gkebackup.v1.BackupForGKE/ListRestores"
	BackupForGKE_GetRestore_FullMethodName                = "/google.cloud.gkebackup.v1.BackupForGKE/GetRestore"
	BackupForGKE_UpdateRestore_FullMethodName             = "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestore"
	BackupForGKE_DeleteRestore_FullMethodName             = "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestore"
	BackupForGKE_ListVolumeRestores_FullMethodName        = "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeRestores"
	BackupForGKE_GetVolumeRestore_FullMethodName          = "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeRestore"
	BackupForGKE_GetBackupIndexDownloadUrl_FullMethodName = "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupIndexDownloadUrl"
)

// BackupForGKEClient is the client API for BackupForGKE service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BackupForGKEClient interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new BackupChannel in a given location.
	CreateBackupChannel(ctx context.Context, in *CreateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupChannels in a given location.
	ListBackupChannels(ctx context.Context, in *ListBackupChannelsRequest, opts ...grpc.CallOption) (*ListBackupChannelsResponse, error)
	// Retrieve the details of a single BackupChannel.
	GetBackupChannel(ctx context.Context, in *GetBackupChannelRequest, opts ...grpc.CallOption) (*BackupChannel, error)
	// Update a BackupChannel.
	UpdateBackupChannel(ctx context.Context, in *UpdateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing BackupChannel.
	DeleteBackupChannel(ctx context.Context, in *DeleteBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupPlanBindings in a given location.
	ListBackupPlanBindings(ctx context.Context, in *ListBackupPlanBindingsRequest, opts ...grpc.CallOption) (*ListBackupPlanBindingsResponse, error)
	// Retrieve the details of a single BackupPlanBinding.
	GetBackupPlanBinding(ctx context.Context, in *GetBackupPlanBindingRequest, opts ...grpc.CallOption) (*BackupPlanBinding, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Update a Backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new RestoreChannel in a given location.
	CreateRestoreChannel(ctx context.Context, in *CreateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestoreChannels in a given location.
	ListRestoreChannels(ctx context.Context, in *ListRestoreChannelsRequest, opts ...grpc.CallOption) (*ListRestoreChannelsResponse, error)
	// Retrieve the details of a single RestoreChannel.
	GetRestoreChannel(ctx context.Context, in *GetRestoreChannelRequest, opts ...grpc.CallOption) (*RestoreChannel, error)
	// Update a RestoreChannel.
	UpdateRestoreChannel(ctx context.Context, in *UpdateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing RestoreChannel.
	DeleteRestoreChannel(ctx context.Context, in *DeleteRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestorePlanBindings in a given location.
	ListRestorePlanBindings(ctx context.Context, in *ListRestorePlanBindingsRequest, opts ...grpc.CallOption) (*ListRestorePlanBindingsResponse, error)
	// Retrieve the details of a single RestorePlanBinding.
	GetRestorePlanBinding(ctx context.Context, in *GetRestorePlanBindingRequest, opts ...grpc.CallOption) (*RestorePlanBinding, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error)
	// Update a Restore.
	UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error)
	// Retrieve the link to the backupIndex.
	GetBackupIndexDownloadUrl(ctx context.Context, in *GetBackupIndexDownloadUrlRequest, opts ...grpc.CallOption) (*GetBackupIndexDownloadUrlResponse, error)
}

type backupForGKEClient struct {
	cc grpc.ClientConnInterface
}

func NewBackupForGKEClient(cc grpc.ClientConnInterface) BackupForGKEClient {
	return &backupForGKEClient{cc}
}

func (c *backupForGKEClient) CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateBackupPlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error) {
	out := new(ListBackupPlansResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListBackupPlans_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error) {
	out := new(BackupPlan)
	err := c.cc.Invoke(ctx, BackupForGKE_GetBackupPlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateBackupPlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteBackupPlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateBackupChannel(ctx context.Context, in *CreateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateBackupChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupChannels(ctx context.Context, in *ListBackupChannelsRequest, opts ...grpc.CallOption) (*ListBackupChannelsResponse, error) {
	out := new(ListBackupChannelsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListBackupChannels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupChannel(ctx context.Context, in *GetBackupChannelRequest, opts ...grpc.CallOption) (*BackupChannel, error) {
	out := new(BackupChannel)
	err := c.cc.Invoke(ctx, BackupForGKE_GetBackupChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackupChannel(ctx context.Context, in *UpdateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateBackupChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackupChannel(ctx context.Context, in *DeleteBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteBackupChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupPlanBindings(ctx context.Context, in *ListBackupPlanBindingsRequest, opts ...grpc.CallOption) (*ListBackupPlanBindingsResponse, error) {
	out := new(ListBackupPlanBindingsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListBackupPlanBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupPlanBinding(ctx context.Context, in *GetBackupPlanBindingRequest, opts ...grpc.CallOption) (*BackupPlanBinding, error) {
	out := new(BackupPlanBinding)
	err := c.cc.Invoke(ctx, BackupForGKE_GetBackupPlanBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, BackupForGKE_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error) {
	out := new(ListVolumeBackupsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListVolumeBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error) {
	out := new(VolumeBackup)
	err := c.cc.Invoke(ctx, BackupForGKE_GetVolumeBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateRestorePlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error) {
	out := new(ListRestorePlansResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListRestorePlans_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error) {
	out := new(RestorePlan)
	err := c.cc.Invoke(ctx, BackupForGKE_GetRestorePlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateRestorePlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteRestorePlan_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestoreChannel(ctx context.Context, in *CreateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateRestoreChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestoreChannels(ctx context.Context, in *ListRestoreChannelsRequest, opts ...grpc.CallOption) (*ListRestoreChannelsResponse, error) {
	out := new(ListRestoreChannelsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListRestoreChannels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestoreChannel(ctx context.Context, in *GetRestoreChannelRequest, opts ...grpc.CallOption) (*RestoreChannel, error) {
	out := new(RestoreChannel)
	err := c.cc.Invoke(ctx, BackupForGKE_GetRestoreChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestoreChannel(ctx context.Context, in *UpdateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateRestoreChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestoreChannel(ctx context.Context, in *DeleteRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteRestoreChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestorePlanBindings(ctx context.Context, in *ListRestorePlanBindingsRequest, opts ...grpc.CallOption) (*ListRestorePlanBindingsResponse, error) {
	out := new(ListRestorePlanBindingsResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListRestorePlanBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestorePlanBinding(ctx context.Context, in *GetRestorePlanBindingRequest, opts ...grpc.CallOption) (*RestorePlanBinding, error) {
	out := new(RestorePlanBinding)
	err := c.cc.Invoke(ctx, BackupForGKE_GetRestorePlanBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_CreateRestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error) {
	out := new(ListRestoresResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListRestores_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error) {
	out := new(Restore)
	err := c.cc.Invoke(ctx, BackupForGKE_GetRestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_UpdateRestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BackupForGKE_DeleteRestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error) {
	out := new(ListVolumeRestoresResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_ListVolumeRestores_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error) {
	out := new(VolumeRestore)
	err := c.cc.Invoke(ctx, BackupForGKE_GetVolumeRestore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupIndexDownloadUrl(ctx context.Context, in *GetBackupIndexDownloadUrlRequest, opts ...grpc.CallOption) (*GetBackupIndexDownloadUrlResponse, error) {
	out := new(GetBackupIndexDownloadUrlResponse)
	err := c.cc.Invoke(ctx, BackupForGKE_GetBackupIndexDownloadUrl_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupForGKEServer is the server API for BackupForGKE service.
// All implementations should embed UnimplementedBackupForGKEServer
// for forward compatibility
type BackupForGKEServer interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error)
	// Creates a new BackupChannel in a given location.
	CreateBackupChannel(context.Context, *CreateBackupChannelRequest) (*longrunningpb.Operation, error)
	// Lists BackupChannels in a given location.
	ListBackupChannels(context.Context, *ListBackupChannelsRequest) (*ListBackupChannelsResponse, error)
	// Retrieve the details of a single BackupChannel.
	GetBackupChannel(context.Context, *GetBackupChannelRequest) (*BackupChannel, error)
	// Update a BackupChannel.
	UpdateBackupChannel(context.Context, *UpdateBackupChannelRequest) (*longrunningpb.Operation, error)
	// Deletes an existing BackupChannel.
	DeleteBackupChannel(context.Context, *DeleteBackupChannelRequest) (*longrunningpb.Operation, error)
	// Lists BackupPlanBindings in a given location.
	ListBackupPlanBindings(context.Context, *ListBackupPlanBindingsRequest) (*ListBackupPlanBindingsResponse, error)
	// Retrieve the details of a single BackupPlanBinding.
	GetBackupPlanBinding(context.Context, *GetBackupPlanBindingRequest) (*BackupPlanBinding, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Update a Backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error)
	// Creates a new RestoreChannel in a given location.
	CreateRestoreChannel(context.Context, *CreateRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Lists RestoreChannels in a given location.
	ListRestoreChannels(context.Context, *ListRestoreChannelsRequest) (*ListRestoreChannelsResponse, error)
	// Retrieve the details of a single RestoreChannel.
	GetRestoreChannel(context.Context, *GetRestoreChannelRequest) (*RestoreChannel, error)
	// Update a RestoreChannel.
	UpdateRestoreChannel(context.Context, *UpdateRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Deletes an existing RestoreChannel.
	DeleteRestoreChannel(context.Context, *DeleteRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Lists RestorePlanBindings in a given location.
	ListRestorePlanBindings(context.Context, *ListRestorePlanBindingsRequest) (*ListRestorePlanBindingsResponse, error)
	// Retrieve the details of a single RestorePlanBinding.
	GetRestorePlanBinding(context.Context, *GetRestorePlanBindingRequest) (*RestorePlanBinding, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(context.Context, *GetRestoreRequest) (*Restore, error)
	// Update a Restore.
	UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error)
	// Retrieve the link to the backupIndex.
	GetBackupIndexDownloadUrl(context.Context, *GetBackupIndexDownloadUrlRequest) (*GetBackupIndexDownloadUrlResponse, error)
}

// UnimplementedBackupForGKEServer should be embedded to have forward compatible implementations.
type UnimplementedBackupForGKEServer struct {
}

func (UnimplementedBackupForGKEServer) CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupPlan not implemented")
}
func (UnimplementedBackupForGKEServer) ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupPlans not implemented")
}
func (UnimplementedBackupForGKEServer) GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlan not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupPlan not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupPlan not implemented")
}
func (UnimplementedBackupForGKEServer) CreateBackupChannel(context.Context, *CreateBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupChannel not implemented")
}
func (UnimplementedBackupForGKEServer) ListBackupChannels(context.Context, *ListBackupChannelsRequest) (*ListBackupChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupChannels not implemented")
}
func (UnimplementedBackupForGKEServer) GetBackupChannel(context.Context, *GetBackupChannelRequest) (*BackupChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupChannel not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateBackupChannel(context.Context, *UpdateBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupChannel not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteBackupChannel(context.Context, *DeleteBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupChannel not implemented")
}
func (UnimplementedBackupForGKEServer) ListBackupPlanBindings(context.Context, *ListBackupPlanBindingsRequest) (*ListBackupPlanBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupPlanBindings not implemented")
}
func (UnimplementedBackupForGKEServer) GetBackupPlanBinding(context.Context, *GetBackupPlanBindingRequest) (*BackupPlanBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlanBinding not implemented")
}
func (UnimplementedBackupForGKEServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (UnimplementedBackupForGKEServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedBackupForGKEServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedBackupForGKEServer) ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeBackups not implemented")
}
func (UnimplementedBackupForGKEServer) GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeBackup not implemented")
}
func (UnimplementedBackupForGKEServer) CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestorePlan not implemented")
}
func (UnimplementedBackupForGKEServer) ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestorePlans not implemented")
}
func (UnimplementedBackupForGKEServer) GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestorePlan not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestorePlan not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestorePlan not implemented")
}
func (UnimplementedBackupForGKEServer) CreateRestoreChannel(context.Context, *CreateRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestoreChannel not implemented")
}
func (UnimplementedBackupForGKEServer) ListRestoreChannels(context.Context, *ListRestoreChannelsRequest) (*ListRestoreChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestoreChannels not implemented")
}
func (UnimplementedBackupForGKEServer) GetRestoreChannel(context.Context, *GetRestoreChannelRequest) (*RestoreChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestoreChannel not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateRestoreChannel(context.Context, *UpdateRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestoreChannel not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteRestoreChannel(context.Context, *DeleteRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestoreChannel not implemented")
}
func (UnimplementedBackupForGKEServer) ListRestorePlanBindings(context.Context, *ListRestorePlanBindingsRequest) (*ListRestorePlanBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestorePlanBindings not implemented")
}
func (UnimplementedBackupForGKEServer) GetRestorePlanBinding(context.Context, *GetRestorePlanBindingRequest) (*RestorePlanBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestorePlanBinding not implemented")
}
func (UnimplementedBackupForGKEServer) CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestore not implemented")
}
func (UnimplementedBackupForGKEServer) ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestores not implemented")
}
func (UnimplementedBackupForGKEServer) GetRestore(context.Context, *GetRestoreRequest) (*Restore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestore not implemented")
}
func (UnimplementedBackupForGKEServer) UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestore not implemented")
}
func (UnimplementedBackupForGKEServer) DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestore not implemented")
}
func (UnimplementedBackupForGKEServer) ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeRestores not implemented")
}
func (UnimplementedBackupForGKEServer) GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeRestore not implemented")
}
func (UnimplementedBackupForGKEServer) GetBackupIndexDownloadUrl(context.Context, *GetBackupIndexDownloadUrlRequest) (*GetBackupIndexDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupIndexDownloadUrl not implemented")
}

// UnsafeBackupForGKEServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BackupForGKEServer will
// result in compilation errors.
type UnsafeBackupForGKEServer interface {
	mustEmbedUnimplementedBackupForGKEServer()
}

func RegisterBackupForGKEServer(s grpc.ServiceRegistrar, srv BackupForGKEServer) {
	s.RegisterService(&BackupForGKE_ServiceDesc, srv)
}

func _BackupForGKE_CreateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateBackupPlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, req.(*CreateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListBackupPlans_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, req.(*ListBackupPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetBackupPlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, req.(*GetBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateBackupPlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, req.(*UpdateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteBackupPlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, req.(*DeleteBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateBackupChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackupChannel(ctx, req.(*CreateBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListBackupChannels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupChannels(ctx, req.(*ListBackupChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetBackupChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupChannel(ctx, req.(*GetBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateBackupChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackupChannel(ctx, req.(*UpdateBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteBackupChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackupChannel(ctx, req.(*DeleteBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupPlanBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPlanBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupPlanBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListBackupPlanBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupPlanBindings(ctx, req.(*ListBackupPlanBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupPlanBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupPlanBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupPlanBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetBackupPlanBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupPlanBinding(ctx, req.(*GetBackupPlanBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListVolumeBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, req.(*ListVolumeBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetVolumeBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, req.(*GetVolumeBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateRestorePlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, req.(*CreateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestorePlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestorePlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListRestorePlans_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, req.(*ListRestorePlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetRestorePlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, req.(*GetRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateRestorePlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, req.(*UpdateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteRestorePlan_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, req.(*DeleteRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateRestoreChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestoreChannel(ctx, req.(*CreateRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestoreChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestoreChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestoreChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListRestoreChannels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestoreChannels(ctx, req.(*ListRestoreChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetRestoreChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestoreChannel(ctx, req.(*GetRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateRestoreChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestoreChannel(ctx, req.(*UpdateRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteRestoreChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestoreChannel(ctx, req.(*DeleteRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestorePlanBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestorePlanBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestorePlanBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListRestorePlanBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestorePlanBindings(ctx, req.(*ListRestorePlanBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestorePlanBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestorePlanBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestorePlanBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetRestorePlanBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestorePlanBinding(ctx, req.(*GetRestorePlanBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_CreateRestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestore(ctx, req.(*CreateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListRestores_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestores(ctx, req.(*ListRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetRestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestore(ctx, req.(*GetRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_UpdateRestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, req.(*UpdateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_DeleteRestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, req.(*DeleteRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_ListVolumeRestores_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, req.(*ListVolumeRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetVolumeRestore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, req.(*GetVolumeRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupIndexDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupIndexDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupIndexDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackupForGKE_GetBackupIndexDownloadUrl_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupIndexDownloadUrl(ctx, req.(*GetBackupIndexDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BackupForGKE_ServiceDesc is the grpc.ServiceDesc for BackupForGKE service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BackupForGKE_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkebackup.v1.BackupForGKE",
	HandlerType: (*BackupForGKEServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBackupPlan",
			Handler:    _BackupForGKE_CreateBackupPlan_Handler,
		},
		{
			MethodName: "ListBackupPlans",
			Handler:    _BackupForGKE_ListBackupPlans_Handler,
		},
		{
			MethodName: "GetBackupPlan",
			Handler:    _BackupForGKE_GetBackupPlan_Handler,
		},
		{
			MethodName: "UpdateBackupPlan",
			Handler:    _BackupForGKE_UpdateBackupPlan_Handler,
		},
		{
			MethodName: "DeleteBackupPlan",
			Handler:    _BackupForGKE_DeleteBackupPlan_Handler,
		},
		{
			MethodName: "CreateBackupChannel",
			Handler:    _BackupForGKE_CreateBackupChannel_Handler,
		},
		{
			MethodName: "ListBackupChannels",
			Handler:    _BackupForGKE_ListBackupChannels_Handler,
		},
		{
			MethodName: "GetBackupChannel",
			Handler:    _BackupForGKE_GetBackupChannel_Handler,
		},
		{
			MethodName: "UpdateBackupChannel",
			Handler:    _BackupForGKE_UpdateBackupChannel_Handler,
		},
		{
			MethodName: "DeleteBackupChannel",
			Handler:    _BackupForGKE_DeleteBackupChannel_Handler,
		},
		{
			MethodName: "ListBackupPlanBindings",
			Handler:    _BackupForGKE_ListBackupPlanBindings_Handler,
		},
		{
			MethodName: "GetBackupPlanBinding",
			Handler:    _BackupForGKE_GetBackupPlanBinding_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _BackupForGKE_CreateBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _BackupForGKE_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _BackupForGKE_GetBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _BackupForGKE_UpdateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _BackupForGKE_DeleteBackup_Handler,
		},
		{
			MethodName: "ListVolumeBackups",
			Handler:    _BackupForGKE_ListVolumeBackups_Handler,
		},
		{
			MethodName: "GetVolumeBackup",
			Handler:    _BackupForGKE_GetVolumeBackup_Handler,
		},
		{
			MethodName: "CreateRestorePlan",
			Handler:    _BackupForGKE_CreateRestorePlan_Handler,
		},
		{
			MethodName: "ListRestorePlans",
			Handler:    _BackupForGKE_ListRestorePlans_Handler,
		},
		{
			MethodName: "GetRestorePlan",
			Handler:    _BackupForGKE_GetRestorePlan_Handler,
		},
		{
			MethodName: "UpdateRestorePlan",
			Handler:    _BackupForGKE_UpdateRestorePlan_Handler,
		},
		{
			MethodName: "DeleteRestorePlan",
			Handler:    _BackupForGKE_DeleteRestorePlan_Handler,
		},
		{
			MethodName: "CreateRestoreChannel",
			Handler:    _BackupForGKE_CreateRestoreChannel_Handler,
		},
		{
			MethodName: "ListRestoreChannels",
			Handler:    _BackupForGKE_ListRestoreChannels_Handler,
		},
		{
			MethodName: "GetRestoreChannel",
			Handler:    _BackupForGKE_GetRestoreChannel_Handler,
		},
		{
			MethodName: "UpdateRestoreChannel",
			Handler:    _BackupForGKE_UpdateRestoreChannel_Handler,
		},
		{
			MethodName: "DeleteRestoreChannel",
			Handler:    _BackupForGKE_DeleteRestoreChannel_Handler,
		},
		{
			MethodName: "ListRestorePlanBindings",
			Handler:    _BackupForGKE_ListRestorePlanBindings_Handler,
		},
		{
			MethodName: "GetRestorePlanBinding",
			Handler:    _BackupForGKE_GetRestorePlanBinding_Handler,
		},
		{
			MethodName: "CreateRestore",
			Handler:    _BackupForGKE_CreateRestore_Handler,
		},
		{
			MethodName: "ListRestores",
			Handler:    _BackupForGKE_ListRestores_Handler,
		},
		{
			MethodName: "GetRestore",
			Handler:    _BackupForGKE_GetRestore_Handler,
		},
		{
			MethodName: "UpdateRestore",
			Handler:    _BackupForGKE_UpdateRestore_Handler,
		},
		{
			MethodName: "DeleteRestore",
			Handler:    _BackupForGKE_DeleteRestore_Handler,
		},
		{
			MethodName: "ListVolumeRestores",
			Handler:    _BackupForGKE_ListVolumeRestores_Handler,
		},
		{
			MethodName: "GetVolumeRestore",
			Handler:    _BackupForGKE_GetVolumeRestore_Handler,
		},
		{
			MethodName: "GetBackupIndexDownloadUrl",
			Handler:    _BackupForGKE_GetBackupIndexDownloadUrl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkebackup/v1/gkebackup.proto",
}
