// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

package genai

import (
	"context"
	"fmt"
	"iter"
	"net/http"
	"reflect"
)

func blobToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"displayName"}) != nil {
		return nil, fmt.Errorf("displayName parameter is not supported in Gemini API")
	}

	fromData := getValueByPath(fromObject, []string{"data"})
	if fromData != nil {
		setValueByPath(toObject, []string{"data"}, fromData)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func candidateFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromContent := getValueByPath(fromObject, []string{"content"})
	if fromContent != nil {
		setValueByPath(toObject, []string{"content"}, fromContent)
	}

	fromCitationMetadata := getValueByPath(fromObject, []string{"citationMetadata"})
	if fromCitationMetadata != nil {
		fromCitationMetadata, err = citationMetadataFromMldev(fromCitationMetadata.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"citationMetadata"}, fromCitationMetadata)
	}

	fromTokenCount := getValueByPath(fromObject, []string{"tokenCount"})
	if fromTokenCount != nil {
		setValueByPath(toObject, []string{"tokenCount"}, fromTokenCount)
	}

	fromFinishReason := getValueByPath(fromObject, []string{"finishReason"})
	if fromFinishReason != nil {
		setValueByPath(toObject, []string{"finishReason"}, fromFinishReason)
	}

	fromUrlContextMetadata := getValueByPath(fromObject, []string{"urlContextMetadata"})
	if fromUrlContextMetadata != nil {
		setValueByPath(toObject, []string{"urlContextMetadata"}, fromUrlContextMetadata)
	}

	fromAvgLogprobs := getValueByPath(fromObject, []string{"avgLogprobs"})
	if fromAvgLogprobs != nil {
		setValueByPath(toObject, []string{"avgLogprobs"}, fromAvgLogprobs)
	}

	fromGroundingMetadata := getValueByPath(fromObject, []string{"groundingMetadata"})
	if fromGroundingMetadata != nil {
		setValueByPath(toObject, []string{"groundingMetadata"}, fromGroundingMetadata)
	}

	fromIndex := getValueByPath(fromObject, []string{"index"})
	if fromIndex != nil {
		setValueByPath(toObject, []string{"index"}, fromIndex)
	}

	fromLogprobsResult := getValueByPath(fromObject, []string{"logprobsResult"})
	if fromLogprobsResult != nil {
		setValueByPath(toObject, []string{"logprobsResult"}, fromLogprobsResult)
	}

	fromSafetyRatings := getValueByPath(fromObject, []string{"safetyRatings"})
	if fromSafetyRatings != nil {
		setValueByPath(toObject, []string{"safetyRatings"}, fromSafetyRatings)
	}

	return toObject, nil
}

func citationMetadataFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromCitations := getValueByPath(fromObject, []string{"citationSources"})
	if fromCitations != nil {
		setValueByPath(toObject, []string{"citations"}, fromCitations)
	}

	return toObject, nil
}

func computeTokensParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"contents"}, fromContents)
	}

	return toObject, nil
}

func computeTokensResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromTokensInfo := getValueByPath(fromObject, []string{"tokensInfo"})
	if fromTokensInfo != nil {
		setValueByPath(toObject, []string{"tokensInfo"}, fromTokensInfo)
	}

	return toObject, nil
}

func contentEmbeddingFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromValues := getValueByPath(fromObject, []string{"values"})
	if fromValues != nil {
		setValueByPath(toObject, []string{"values"}, fromValues)
	}

	fromStatistics := getValueByPath(fromObject, []string{"statistics"})
	if fromStatistics != nil {
		fromStatistics, err = contentEmbeddingStatisticsFromVertex(fromStatistics.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"statistics"}, fromStatistics)
	}

	return toObject, nil
}

func contentEmbeddingStatisticsFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromTruncated := getValueByPath(fromObject, []string{"truncated"})
	if fromTruncated != nil {
		setValueByPath(toObject, []string{"truncated"}, fromTruncated)
	}

	fromTokenCount := getValueByPath(fromObject, []string{"token_count"})
	if fromTokenCount != nil {
		setValueByPath(toObject, []string{"tokenCount"}, fromTokenCount)
	}

	return toObject, nil
}

func contentToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromParts := getValueByPath(fromObject, []string{"parts"})
	if fromParts != nil {
		fromParts, err = applyConverterToSlice(fromParts.([]any), partToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"parts"}, fromParts)
	}

	fromRole := getValueByPath(fromObject, []string{"role"})
	if fromRole != nil {
		setValueByPath(toObject, []string{"role"}, fromRole)
	}

	return toObject, nil
}

func controlReferenceConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromControlType := getValueByPath(fromObject, []string{"controlType"})
	if fromControlType != nil {
		setValueByPath(toObject, []string{"controlType"}, fromControlType)
	}

	fromEnableControlImageComputation := getValueByPath(fromObject, []string{"enableControlImageComputation"})
	if fromEnableControlImageComputation != nil {
		setValueByPath(toObject, []string{"computeControl"}, fromEnableControlImageComputation)
	}

	return toObject, nil
}

func countTokensConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	if getValueByPath(fromObject, []string{"systemInstruction"}) != nil {
		return nil, fmt.Errorf("systemInstruction parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"tools"}) != nil {
		return nil, fmt.Errorf("tools parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"generationConfig"}) != nil {
		return nil, fmt.Errorf("generationConfig parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func countTokensConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"systemInstruction"}, fromSystemInstruction)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"tools"}, fromTools)
	}

	fromGenerationConfig := getValueByPath(fromObject, []string{"generationConfig"})
	if fromGenerationConfig != nil {
		fromGenerationConfig, err = generationConfigToVertex(fromGenerationConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"generationConfig"}, fromGenerationConfig)
	}

	return toObject, nil
}

func countTokensParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		fromContents, err = applyConverterToSlice(fromContents.([]any), contentToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"contents"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = countTokensConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func countTokensParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"contents"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = countTokensConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func countTokensResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromTotalTokens := getValueByPath(fromObject, []string{"totalTokens"})
	if fromTotalTokens != nil {
		setValueByPath(toObject, []string{"totalTokens"}, fromTotalTokens)
	}

	fromCachedContentTokenCount := getValueByPath(fromObject, []string{"cachedContentTokenCount"})
	if fromCachedContentTokenCount != nil {
		setValueByPath(toObject, []string{"cachedContentTokenCount"}, fromCachedContentTokenCount)
	}

	return toObject, nil
}

func countTokensResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromTotalTokens := getValueByPath(fromObject, []string{"totalTokens"})
	if fromTotalTokens != nil {
		setValueByPath(toObject, []string{"totalTokens"}, fromTotalTokens)
	}

	return toObject, nil
}

func deleteModelParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromModel)
	}

	return toObject, nil
}

func deleteModelParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromModel)
	}

	return toObject, nil
}

func deleteModelResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	return toObject, nil
}

func deleteModelResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	return toObject, nil
}

func editImageConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromOutputGcsUri := getValueByPath(fromObject, []string{"outputGcsUri"})
	if fromOutputGcsUri != nil {
		setValueByPath(parentObject, []string{"parameters", "storageUri"}, fromOutputGcsUri)
	}

	fromNegativePrompt := getValueByPath(fromObject, []string{"negativePrompt"})
	if fromNegativePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "negativePrompt"}, fromNegativePrompt)
	}

	fromNumberOfImages := getValueByPath(fromObject, []string{"numberOfImages"})
	if fromNumberOfImages != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfImages)
	}

	fromAspectRatio := getValueByPath(fromObject, []string{"aspectRatio"})
	if fromAspectRatio != nil {
		setValueByPath(parentObject, []string{"parameters", "aspectRatio"}, fromAspectRatio)
	}

	fromGuidanceScale := getValueByPath(fromObject, []string{"guidanceScale"})
	if fromGuidanceScale != nil {
		setValueByPath(parentObject, []string{"parameters", "guidanceScale"}, fromGuidanceScale)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"parameters", "seed"}, fromSeed)
	}

	fromSafetyFilterLevel := getValueByPath(fromObject, []string{"safetyFilterLevel"})
	if fromSafetyFilterLevel != nil {
		setValueByPath(parentObject, []string{"parameters", "safetySetting"}, fromSafetyFilterLevel)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	fromIncludeSafetyAttributes := getValueByPath(fromObject, []string{"includeSafetyAttributes"})
	if fromIncludeSafetyAttributes != nil {
		setValueByPath(parentObject, []string{"parameters", "includeSafetyAttributes"}, fromIncludeSafetyAttributes)
	}

	fromIncludeRaiReason := getValueByPath(fromObject, []string{"includeRaiReason"})
	if fromIncludeRaiReason != nil {
		setValueByPath(parentObject, []string{"parameters", "includeRaiReason"}, fromIncludeRaiReason)
	}

	fromLanguage := getValueByPath(fromObject, []string{"language"})
	if fromLanguage != nil {
		setValueByPath(parentObject, []string{"parameters", "language"}, fromLanguage)
	}

	fromOutputMimeType := getValueByPath(fromObject, []string{"outputMimeType"})
	if fromOutputMimeType != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "mimeType"}, fromOutputMimeType)
	}

	fromOutputCompressionQuality := getValueByPath(fromObject, []string{"outputCompressionQuality"})
	if fromOutputCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "compressionQuality"}, fromOutputCompressionQuality)
	}

	fromAddWatermark := getValueByPath(fromObject, []string{"addWatermark"})
	if fromAddWatermark != nil {
		setValueByPath(parentObject, []string{"parameters", "addWatermark"}, fromAddWatermark)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	fromEditMode := getValueByPath(fromObject, []string{"editMode"})
	if fromEditMode != nil {
		setValueByPath(parentObject, []string{"parameters", "editMode"}, fromEditMode)
	}

	fromBaseSteps := getValueByPath(fromObject, []string{"baseSteps"})
	if fromBaseSteps != nil {
		setValueByPath(parentObject, []string{"parameters", "editConfig", "baseSteps"}, fromBaseSteps)
	}

	return toObject, nil
}

func editImageParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(toObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromReferenceImages := getValueByPath(fromObject, []string{"referenceImages"})
	if fromReferenceImages != nil {
		fromReferenceImages, err = applyConverterToSlice(fromReferenceImages.([]any), referenceImageAPIToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "referenceImages"}, fromReferenceImages)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = editImageConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func editImageResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromGeneratedImages := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedImages != nil {
		fromGeneratedImages, err = applyConverterToSlice(fromGeneratedImages.([]any), generatedImageFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedImages"}, fromGeneratedImages)
	}

	return toObject, nil
}

func embedContentConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromTaskType := getValueByPath(fromObject, []string{"taskType"})
	if fromTaskType != nil {
		setValueByPath(parentObject, []string{"requests[]", "taskType"}, fromTaskType)
	}

	fromTitle := getValueByPath(fromObject, []string{"title"})
	if fromTitle != nil {
		setValueByPath(parentObject, []string{"requests[]", "title"}, fromTitle)
	}

	fromOutputDimensionality := getValueByPath(fromObject, []string{"outputDimensionality"})
	if fromOutputDimensionality != nil {
		setValueByPath(parentObject, []string{"requests[]", "outputDimensionality"}, fromOutputDimensionality)
	}

	if getValueByPath(fromObject, []string{"mimeType"}) != nil {
		return nil, fmt.Errorf("mimeType parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"autoTruncate"}) != nil {
		return nil, fmt.Errorf("autoTruncate parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func embedContentConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromTaskType := getValueByPath(fromObject, []string{"taskType"})
	if fromTaskType != nil {
		setValueByPath(parentObject, []string{"instances[]", "task_type"}, fromTaskType)
	}

	fromTitle := getValueByPath(fromObject, []string{"title"})
	if fromTitle != nil {
		setValueByPath(parentObject, []string{"instances[]", "title"}, fromTitle)
	}

	fromOutputDimensionality := getValueByPath(fromObject, []string{"outputDimensionality"})
	if fromOutputDimensionality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputDimensionality"}, fromOutputDimensionality)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(parentObject, []string{"instances[]", "mimeType"}, fromMimeType)
	}

	fromAutoTruncate := getValueByPath(fromObject, []string{"autoTruncate"})
	if fromAutoTruncate != nil {
		setValueByPath(parentObject, []string{"parameters", "autoTruncate"}, fromAutoTruncate)
	}

	return toObject, nil
}

func embedContentParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContentsForEmbed(ac, fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"requests[]", "content"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = embedContentConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	setValueByPath(toObject, []string{"requests[]", "model"}, fromModel)

	return toObject, nil
}

func embedContentParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContentsForEmbed(ac, fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[]", "content"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = embedContentConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func embedContentResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromEmbeddings := getValueByPath(fromObject, []string{"embeddings"})
	if fromEmbeddings != nil {
		setValueByPath(toObject, []string{"embeddings"}, fromEmbeddings)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	return toObject, nil
}

func embedContentResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromEmbeddings := getValueByPath(fromObject, []string{"predictions[]", "embeddings"})
	if fromEmbeddings != nil {
		fromEmbeddings, err = applyConverterToSlice(fromEmbeddings.([]any), contentEmbeddingFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"embeddings"}, fromEmbeddings)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	return toObject, nil
}

func endpointFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"endpoint"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDeployedModelId := getValueByPath(fromObject, []string{"deployedModelId"})
	if fromDeployedModelId != nil {
		setValueByPath(toObject, []string{"deployedModelId"}, fromDeployedModelId)
	}

	return toObject, nil
}

func fileDataToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"displayName"}) != nil {
		return nil, fmt.Errorf("displayName parameter is not supported in Gemini API")
	}

	fromFileUri := getValueByPath(fromObject, []string{"fileUri"})
	if fromFileUri != nil {
		setValueByPath(toObject, []string{"fileUri"}, fromFileUri)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func functionDeclarationToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"behavior"}) != nil {
		return nil, fmt.Errorf("behavior parameter is not supported in Vertex AI")
	}

	fromDescription := getValueByPath(fromObject, []string{"description"})
	if fromDescription != nil {
		setValueByPath(toObject, []string{"description"}, fromDescription)
	}

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromParameters := getValueByPath(fromObject, []string{"parameters"})
	if fromParameters != nil {
		setValueByPath(toObject, []string{"parameters"}, fromParameters)
	}

	fromParametersJsonSchema := getValueByPath(fromObject, []string{"parametersJsonSchema"})
	if fromParametersJsonSchema != nil {
		setValueByPath(toObject, []string{"parametersJsonSchema"}, fromParametersJsonSchema)
	}

	fromResponse := getValueByPath(fromObject, []string{"response"})
	if fromResponse != nil {
		setValueByPath(toObject, []string{"response"}, fromResponse)
	}

	fromResponseJsonSchema := getValueByPath(fromObject, []string{"responseJsonSchema"})
	if fromResponseJsonSchema != nil {
		setValueByPath(toObject, []string{"responseJsonSchema"}, fromResponseJsonSchema)
	}

	return toObject, nil
}

func generateContentConfigToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		fromSystemInstruction, err = contentToMldev(fromSystemInstruction.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"systemInstruction"}, fromSystemInstruction)
	}

	fromTemperature := getValueByPath(fromObject, []string{"temperature"})
	if fromTemperature != nil {
		setValueByPath(toObject, []string{"temperature"}, fromTemperature)
	}

	fromTopP := getValueByPath(fromObject, []string{"topP"})
	if fromTopP != nil {
		setValueByPath(toObject, []string{"topP"}, fromTopP)
	}

	fromTopK := getValueByPath(fromObject, []string{"topK"})
	if fromTopK != nil {
		setValueByPath(toObject, []string{"topK"}, fromTopK)
	}

	fromCandidateCount := getValueByPath(fromObject, []string{"candidateCount"})
	if fromCandidateCount != nil {
		setValueByPath(toObject, []string{"candidateCount"}, fromCandidateCount)
	}

	fromMaxOutputTokens := getValueByPath(fromObject, []string{"maxOutputTokens"})
	if fromMaxOutputTokens != nil {
		setValueByPath(toObject, []string{"maxOutputTokens"}, fromMaxOutputTokens)
	}

	fromStopSequences := getValueByPath(fromObject, []string{"stopSequences"})
	if fromStopSequences != nil {
		setValueByPath(toObject, []string{"stopSequences"}, fromStopSequences)
	}

	fromResponseLogprobs := getValueByPath(fromObject, []string{"responseLogprobs"})
	if fromResponseLogprobs != nil {
		setValueByPath(toObject, []string{"responseLogprobs"}, fromResponseLogprobs)
	}

	fromLogprobs := getValueByPath(fromObject, []string{"logprobs"})
	if fromLogprobs != nil {
		setValueByPath(toObject, []string{"logprobs"}, fromLogprobs)
	}

	fromPresencePenalty := getValueByPath(fromObject, []string{"presencePenalty"})
	if fromPresencePenalty != nil {
		setValueByPath(toObject, []string{"presencePenalty"}, fromPresencePenalty)
	}

	fromFrequencyPenalty := getValueByPath(fromObject, []string{"frequencyPenalty"})
	if fromFrequencyPenalty != nil {
		setValueByPath(toObject, []string{"frequencyPenalty"}, fromFrequencyPenalty)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(toObject, []string{"seed"}, fromSeed)
	}

	fromResponseMimeType := getValueByPath(fromObject, []string{"responseMimeType"})
	if fromResponseMimeType != nil {
		setValueByPath(toObject, []string{"responseMimeType"}, fromResponseMimeType)
	}

	fromResponseSchema := getValueByPath(fromObject, []string{"responseSchema"})
	if fromResponseSchema != nil {
		fromResponseSchema, err = tSchema(fromResponseSchema)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"responseSchema"}, fromResponseSchema)
	}

	fromResponseJsonSchema := getValueByPath(fromObject, []string{"responseJsonSchema"})
	if fromResponseJsonSchema != nil {
		setValueByPath(toObject, []string{"responseJsonSchema"}, fromResponseJsonSchema)
	}

	if getValueByPath(fromObject, []string{"routingConfig"}) != nil {
		return nil, fmt.Errorf("routingConfig parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"modelSelectionConfig"}) != nil {
		return nil, fmt.Errorf("modelSelectionConfig parameter is not supported in Gemini API")
	}

	fromSafetySettings := getValueByPath(fromObject, []string{"safetySettings"})
	if fromSafetySettings != nil {
		fromSafetySettings, err = applyConverterToSlice(fromSafetySettings.([]any), safetySettingToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"safetySettings"}, fromSafetySettings)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"tools"}, fromTools)
	}

	fromToolConfig := getValueByPath(fromObject, []string{"toolConfig"})
	if fromToolConfig != nil {
		setValueByPath(parentObject, []string{"toolConfig"}, fromToolConfig)
	}

	if getValueByPath(fromObject, []string{"labels"}) != nil {
		return nil, fmt.Errorf("labels parameter is not supported in Gemini API")
	}

	fromCachedContent := getValueByPath(fromObject, []string{"cachedContent"})
	if fromCachedContent != nil {
		fromCachedContent, err = tCachedContentName(ac, fromCachedContent)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"cachedContent"}, fromCachedContent)
	}

	fromResponseModalities := getValueByPath(fromObject, []string{"responseModalities"})
	if fromResponseModalities != nil {
		setValueByPath(toObject, []string{"responseModalities"}, fromResponseModalities)
	}

	fromMediaResolution := getValueByPath(fromObject, []string{"mediaResolution"})
	if fromMediaResolution != nil {
		setValueByPath(toObject, []string{"mediaResolution"}, fromMediaResolution)
	}

	fromSpeechConfig := getValueByPath(fromObject, []string{"speechConfig"})
	if fromSpeechConfig != nil {
		fromSpeechConfig, err = tSpeechConfig(fromSpeechConfig)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"speechConfig"}, fromSpeechConfig)
	}

	if getValueByPath(fromObject, []string{"audioTimestamp"}) != nil {
		return nil, fmt.Errorf("audioTimestamp parameter is not supported in Gemini API")
	}

	fromThinkingConfig := getValueByPath(fromObject, []string{"thinkingConfig"})
	if fromThinkingConfig != nil {
		setValueByPath(toObject, []string{"thinkingConfig"}, fromThinkingConfig)
	}

	fromImageConfig := getValueByPath(fromObject, []string{"imageConfig"})
	if fromImageConfig != nil {
		setValueByPath(toObject, []string{"imageConfig"}, fromImageConfig)
	}

	return toObject, nil
}

func generateContentConfigToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"systemInstruction"}, fromSystemInstruction)
	}

	fromTemperature := getValueByPath(fromObject, []string{"temperature"})
	if fromTemperature != nil {
		setValueByPath(toObject, []string{"temperature"}, fromTemperature)
	}

	fromTopP := getValueByPath(fromObject, []string{"topP"})
	if fromTopP != nil {
		setValueByPath(toObject, []string{"topP"}, fromTopP)
	}

	fromTopK := getValueByPath(fromObject, []string{"topK"})
	if fromTopK != nil {
		setValueByPath(toObject, []string{"topK"}, fromTopK)
	}

	fromCandidateCount := getValueByPath(fromObject, []string{"candidateCount"})
	if fromCandidateCount != nil {
		setValueByPath(toObject, []string{"candidateCount"}, fromCandidateCount)
	}

	fromMaxOutputTokens := getValueByPath(fromObject, []string{"maxOutputTokens"})
	if fromMaxOutputTokens != nil {
		setValueByPath(toObject, []string{"maxOutputTokens"}, fromMaxOutputTokens)
	}

	fromStopSequences := getValueByPath(fromObject, []string{"stopSequences"})
	if fromStopSequences != nil {
		setValueByPath(toObject, []string{"stopSequences"}, fromStopSequences)
	}

	fromResponseLogprobs := getValueByPath(fromObject, []string{"responseLogprobs"})
	if fromResponseLogprobs != nil {
		setValueByPath(toObject, []string{"responseLogprobs"}, fromResponseLogprobs)
	}

	fromLogprobs := getValueByPath(fromObject, []string{"logprobs"})
	if fromLogprobs != nil {
		setValueByPath(toObject, []string{"logprobs"}, fromLogprobs)
	}

	fromPresencePenalty := getValueByPath(fromObject, []string{"presencePenalty"})
	if fromPresencePenalty != nil {
		setValueByPath(toObject, []string{"presencePenalty"}, fromPresencePenalty)
	}

	fromFrequencyPenalty := getValueByPath(fromObject, []string{"frequencyPenalty"})
	if fromFrequencyPenalty != nil {
		setValueByPath(toObject, []string{"frequencyPenalty"}, fromFrequencyPenalty)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(toObject, []string{"seed"}, fromSeed)
	}

	fromResponseMimeType := getValueByPath(fromObject, []string{"responseMimeType"})
	if fromResponseMimeType != nil {
		setValueByPath(toObject, []string{"responseMimeType"}, fromResponseMimeType)
	}

	fromResponseSchema := getValueByPath(fromObject, []string{"responseSchema"})
	if fromResponseSchema != nil {
		fromResponseSchema, err = tSchema(fromResponseSchema)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"responseSchema"}, fromResponseSchema)
	}

	fromResponseJsonSchema := getValueByPath(fromObject, []string{"responseJsonSchema"})
	if fromResponseJsonSchema != nil {
		setValueByPath(toObject, []string{"responseJsonSchema"}, fromResponseJsonSchema)
	}

	fromRoutingConfig := getValueByPath(fromObject, []string{"routingConfig"})
	if fromRoutingConfig != nil {
		setValueByPath(toObject, []string{"routingConfig"}, fromRoutingConfig)
	}

	fromModelSelectionConfig := getValueByPath(fromObject, []string{"modelSelectionConfig"})
	if fromModelSelectionConfig != nil {
		setValueByPath(toObject, []string{"modelConfig"}, fromModelSelectionConfig)
	}

	fromSafetySettings := getValueByPath(fromObject, []string{"safetySettings"})
	if fromSafetySettings != nil {
		setValueByPath(parentObject, []string{"safetySettings"}, fromSafetySettings)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"tools"}, fromTools)
	}

	fromToolConfig := getValueByPath(fromObject, []string{"toolConfig"})
	if fromToolConfig != nil {
		setValueByPath(parentObject, []string{"toolConfig"}, fromToolConfig)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	fromCachedContent := getValueByPath(fromObject, []string{"cachedContent"})
	if fromCachedContent != nil {
		fromCachedContent, err = tCachedContentName(ac, fromCachedContent)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"cachedContent"}, fromCachedContent)
	}

	fromResponseModalities := getValueByPath(fromObject, []string{"responseModalities"})
	if fromResponseModalities != nil {
		setValueByPath(toObject, []string{"responseModalities"}, fromResponseModalities)
	}

	fromMediaResolution := getValueByPath(fromObject, []string{"mediaResolution"})
	if fromMediaResolution != nil {
		setValueByPath(toObject, []string{"mediaResolution"}, fromMediaResolution)
	}

	fromSpeechConfig := getValueByPath(fromObject, []string{"speechConfig"})
	if fromSpeechConfig != nil {
		fromSpeechConfig, err = tSpeechConfig(fromSpeechConfig)
		if err != nil {
			return nil, err
		}

		fromSpeechConfig, err = speechConfigToVertex(fromSpeechConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"speechConfig"}, fromSpeechConfig)
	}

	fromAudioTimestamp := getValueByPath(fromObject, []string{"audioTimestamp"})
	if fromAudioTimestamp != nil {
		setValueByPath(toObject, []string{"audioTimestamp"}, fromAudioTimestamp)
	}

	fromThinkingConfig := getValueByPath(fromObject, []string{"thinkingConfig"})
	if fromThinkingConfig != nil {
		setValueByPath(toObject, []string{"thinkingConfig"}, fromThinkingConfig)
	}

	fromImageConfig := getValueByPath(fromObject, []string{"imageConfig"})
	if fromImageConfig != nil {
		setValueByPath(toObject, []string{"imageConfig"}, fromImageConfig)
	}

	return toObject, nil
}

func generateContentParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		fromContents, err = applyConverterToSlice(fromContents.([]any), contentToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"contents"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = generateContentConfigToMldev(ac, fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generationConfig"}, fromConfig)
	}

	return toObject, nil
}

func generateContentParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"contents"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = generateContentConfigToVertex(ac, fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generationConfig"}, fromConfig)
	}

	return toObject, nil
}

func generateContentResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromCandidates := getValueByPath(fromObject, []string{"candidates"})
	if fromCandidates != nil {
		fromCandidates, err = applyConverterToSlice(fromCandidates.([]any), candidateFromMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"candidates"}, fromCandidates)
	}

	fromModelVersion := getValueByPath(fromObject, []string{"modelVersion"})
	if fromModelVersion != nil {
		setValueByPath(toObject, []string{"modelVersion"}, fromModelVersion)
	}

	fromPromptFeedback := getValueByPath(fromObject, []string{"promptFeedback"})
	if fromPromptFeedback != nil {
		setValueByPath(toObject, []string{"promptFeedback"}, fromPromptFeedback)
	}

	fromResponseId := getValueByPath(fromObject, []string{"responseId"})
	if fromResponseId != nil {
		setValueByPath(toObject, []string{"responseId"}, fromResponseId)
	}

	fromUsageMetadata := getValueByPath(fromObject, []string{"usageMetadata"})
	if fromUsageMetadata != nil {
		setValueByPath(toObject, []string{"usageMetadata"}, fromUsageMetadata)
	}

	return toObject, nil
}

func generateContentResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromCandidates := getValueByPath(fromObject, []string{"candidates"})
	if fromCandidates != nil {
		setValueByPath(toObject, []string{"candidates"}, fromCandidates)
	}

	fromCreateTime := getValueByPath(fromObject, []string{"createTime"})
	if fromCreateTime != nil {
		setValueByPath(toObject, []string{"createTime"}, fromCreateTime)
	}

	fromModelVersion := getValueByPath(fromObject, []string{"modelVersion"})
	if fromModelVersion != nil {
		setValueByPath(toObject, []string{"modelVersion"}, fromModelVersion)
	}

	fromPromptFeedback := getValueByPath(fromObject, []string{"promptFeedback"})
	if fromPromptFeedback != nil {
		setValueByPath(toObject, []string{"promptFeedback"}, fromPromptFeedback)
	}

	fromResponseId := getValueByPath(fromObject, []string{"responseId"})
	if fromResponseId != nil {
		setValueByPath(toObject, []string{"responseId"}, fromResponseId)
	}

	fromUsageMetadata := getValueByPath(fromObject, []string{"usageMetadata"})
	if fromUsageMetadata != nil {
		setValueByPath(toObject, []string{"usageMetadata"}, fromUsageMetadata)
	}

	return toObject, nil
}

func generateImagesConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	if getValueByPath(fromObject, []string{"outputGcsUri"}) != nil {
		return nil, fmt.Errorf("outputGcsUri parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"negativePrompt"}) != nil {
		return nil, fmt.Errorf("negativePrompt parameter is not supported in Gemini API")
	}

	fromNumberOfImages := getValueByPath(fromObject, []string{"numberOfImages"})
	if fromNumberOfImages != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfImages)
	}

	fromAspectRatio := getValueByPath(fromObject, []string{"aspectRatio"})
	if fromAspectRatio != nil {
		setValueByPath(parentObject, []string{"parameters", "aspectRatio"}, fromAspectRatio)
	}

	fromGuidanceScale := getValueByPath(fromObject, []string{"guidanceScale"})
	if fromGuidanceScale != nil {
		setValueByPath(parentObject, []string{"parameters", "guidanceScale"}, fromGuidanceScale)
	}

	if getValueByPath(fromObject, []string{"seed"}) != nil {
		return nil, fmt.Errorf("seed parameter is not supported in Gemini API")
	}

	fromSafetyFilterLevel := getValueByPath(fromObject, []string{"safetyFilterLevel"})
	if fromSafetyFilterLevel != nil {
		setValueByPath(parentObject, []string{"parameters", "safetySetting"}, fromSafetyFilterLevel)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	fromIncludeSafetyAttributes := getValueByPath(fromObject, []string{"includeSafetyAttributes"})
	if fromIncludeSafetyAttributes != nil {
		setValueByPath(parentObject, []string{"parameters", "includeSafetyAttributes"}, fromIncludeSafetyAttributes)
	}

	fromIncludeRaiReason := getValueByPath(fromObject, []string{"includeRaiReason"})
	if fromIncludeRaiReason != nil {
		setValueByPath(parentObject, []string{"parameters", "includeRaiReason"}, fromIncludeRaiReason)
	}

	fromLanguage := getValueByPath(fromObject, []string{"language"})
	if fromLanguage != nil {
		setValueByPath(parentObject, []string{"parameters", "language"}, fromLanguage)
	}

	fromOutputMimeType := getValueByPath(fromObject, []string{"outputMimeType"})
	if fromOutputMimeType != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "mimeType"}, fromOutputMimeType)
	}

	fromOutputCompressionQuality := getValueByPath(fromObject, []string{"outputCompressionQuality"})
	if fromOutputCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "compressionQuality"}, fromOutputCompressionQuality)
	}

	if getValueByPath(fromObject, []string{"addWatermark"}) != nil {
		return nil, fmt.Errorf("addWatermark parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"labels"}) != nil {
		return nil, fmt.Errorf("labels parameter is not supported in Gemini API")
	}

	fromImageSize := getValueByPath(fromObject, []string{"imageSize"})
	if fromImageSize != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleImageSize"}, fromImageSize)
	}

	if getValueByPath(fromObject, []string{"enhancePrompt"}) != nil {
		return nil, fmt.Errorf("enhancePrompt parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func generateImagesConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromOutputGcsUri := getValueByPath(fromObject, []string{"outputGcsUri"})
	if fromOutputGcsUri != nil {
		setValueByPath(parentObject, []string{"parameters", "storageUri"}, fromOutputGcsUri)
	}

	fromNegativePrompt := getValueByPath(fromObject, []string{"negativePrompt"})
	if fromNegativePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "negativePrompt"}, fromNegativePrompt)
	}

	fromNumberOfImages := getValueByPath(fromObject, []string{"numberOfImages"})
	if fromNumberOfImages != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfImages)
	}

	fromAspectRatio := getValueByPath(fromObject, []string{"aspectRatio"})
	if fromAspectRatio != nil {
		setValueByPath(parentObject, []string{"parameters", "aspectRatio"}, fromAspectRatio)
	}

	fromGuidanceScale := getValueByPath(fromObject, []string{"guidanceScale"})
	if fromGuidanceScale != nil {
		setValueByPath(parentObject, []string{"parameters", "guidanceScale"}, fromGuidanceScale)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"parameters", "seed"}, fromSeed)
	}

	fromSafetyFilterLevel := getValueByPath(fromObject, []string{"safetyFilterLevel"})
	if fromSafetyFilterLevel != nil {
		setValueByPath(parentObject, []string{"parameters", "safetySetting"}, fromSafetyFilterLevel)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	fromIncludeSafetyAttributes := getValueByPath(fromObject, []string{"includeSafetyAttributes"})
	if fromIncludeSafetyAttributes != nil {
		setValueByPath(parentObject, []string{"parameters", "includeSafetyAttributes"}, fromIncludeSafetyAttributes)
	}

	fromIncludeRaiReason := getValueByPath(fromObject, []string{"includeRaiReason"})
	if fromIncludeRaiReason != nil {
		setValueByPath(parentObject, []string{"parameters", "includeRaiReason"}, fromIncludeRaiReason)
	}

	fromLanguage := getValueByPath(fromObject, []string{"language"})
	if fromLanguage != nil {
		setValueByPath(parentObject, []string{"parameters", "language"}, fromLanguage)
	}

	fromOutputMimeType := getValueByPath(fromObject, []string{"outputMimeType"})
	if fromOutputMimeType != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "mimeType"}, fromOutputMimeType)
	}

	fromOutputCompressionQuality := getValueByPath(fromObject, []string{"outputCompressionQuality"})
	if fromOutputCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "compressionQuality"}, fromOutputCompressionQuality)
	}

	fromAddWatermark := getValueByPath(fromObject, []string{"addWatermark"})
	if fromAddWatermark != nil {
		setValueByPath(parentObject, []string{"parameters", "addWatermark"}, fromAddWatermark)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	fromImageSize := getValueByPath(fromObject, []string{"imageSize"})
	if fromImageSize != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleImageSize"}, fromImageSize)
	}

	fromEnhancePrompt := getValueByPath(fromObject, []string{"enhancePrompt"})
	if fromEnhancePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "enhancePrompt"}, fromEnhancePrompt)
	}

	return toObject, nil
}

func generateImagesParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(toObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = generateImagesConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func generateImagesParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(toObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = generateImagesConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func generateImagesResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromGeneratedImages := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedImages != nil {
		fromGeneratedImages, err = applyConverterToSlice(fromGeneratedImages.([]any), generatedImageFromMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedImages"}, fromGeneratedImages)
	}

	fromPositivePromptSafetyAttributes := getValueByPath(fromObject, []string{"positivePromptSafetyAttributes"})
	if fromPositivePromptSafetyAttributes != nil {
		fromPositivePromptSafetyAttributes, err = safetyAttributesFromMldev(fromPositivePromptSafetyAttributes.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"positivePromptSafetyAttributes"}, fromPositivePromptSafetyAttributes)
	}

	return toObject, nil
}

func generateImagesResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromGeneratedImages := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedImages != nil {
		fromGeneratedImages, err = applyConverterToSlice(fromGeneratedImages.([]any), generatedImageFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedImages"}, fromGeneratedImages)
	}

	fromPositivePromptSafetyAttributes := getValueByPath(fromObject, []string{"positivePromptSafetyAttributes"})
	if fromPositivePromptSafetyAttributes != nil {
		fromPositivePromptSafetyAttributes, err = safetyAttributesFromVertex(fromPositivePromptSafetyAttributes.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"positivePromptSafetyAttributes"}, fromPositivePromptSafetyAttributes)
	}

	return toObject, nil
}

func generateVideosConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromNumberOfVideos := getValueByPath(fromObject, []string{"numberOfVideos"})
	if fromNumberOfVideos != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfVideos)
	}

	if getValueByPath(fromObject, []string{"outputGcsUri"}) != nil {
		return nil, fmt.Errorf("outputGcsUri parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"fps"}) != nil {
		return nil, fmt.Errorf("fps parameter is not supported in Gemini API")
	}

	fromDurationSeconds := getValueByPath(fromObject, []string{"durationSeconds"})
	if fromDurationSeconds != nil {
		setValueByPath(parentObject, []string{"parameters", "durationSeconds"}, fromDurationSeconds)
	}

	if getValueByPath(fromObject, []string{"seed"}) != nil {
		return nil, fmt.Errorf("seed parameter is not supported in Gemini API")
	}

	fromAspectRatio := getValueByPath(fromObject, []string{"aspectRatio"})
	if fromAspectRatio != nil {
		setValueByPath(parentObject, []string{"parameters", "aspectRatio"}, fromAspectRatio)
	}

	fromResolution := getValueByPath(fromObject, []string{"resolution"})
	if fromResolution != nil {
		setValueByPath(parentObject, []string{"parameters", "resolution"}, fromResolution)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	if getValueByPath(fromObject, []string{"pubsubTopic"}) != nil {
		return nil, fmt.Errorf("pubsubTopic parameter is not supported in Gemini API")
	}

	fromNegativePrompt := getValueByPath(fromObject, []string{"negativePrompt"})
	if fromNegativePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "negativePrompt"}, fromNegativePrompt)
	}

	fromEnhancePrompt := getValueByPath(fromObject, []string{"enhancePrompt"})
	if fromEnhancePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "enhancePrompt"}, fromEnhancePrompt)
	}

	if getValueByPath(fromObject, []string{"generateAudio"}) != nil {
		return nil, fmt.Errorf("generateAudio parameter is not supported in Gemini API")
	}

	fromLastFrame := getValueByPath(fromObject, []string{"lastFrame"})
	if fromLastFrame != nil {
		fromLastFrame, err = imageToMldev(fromLastFrame.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "lastFrame"}, fromLastFrame)
	}

	fromReferenceImages := getValueByPath(fromObject, []string{"referenceImages"})
	if fromReferenceImages != nil {
		fromReferenceImages, err = applyConverterToSlice(fromReferenceImages.([]any), videoGenerationReferenceImageToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "referenceImages"}, fromReferenceImages)
	}

	if getValueByPath(fromObject, []string{"mask"}) != nil {
		return nil, fmt.Errorf("mask parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"compressionQuality"}) != nil {
		return nil, fmt.Errorf("compressionQuality parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func generateVideosConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromNumberOfVideos := getValueByPath(fromObject, []string{"numberOfVideos"})
	if fromNumberOfVideos != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfVideos)
	}

	fromOutputGcsUri := getValueByPath(fromObject, []string{"outputGcsUri"})
	if fromOutputGcsUri != nil {
		setValueByPath(parentObject, []string{"parameters", "storageUri"}, fromOutputGcsUri)
	}

	fromFps := getValueByPath(fromObject, []string{"fps"})
	if fromFps != nil {
		setValueByPath(parentObject, []string{"parameters", "fps"}, fromFps)
	}

	fromDurationSeconds := getValueByPath(fromObject, []string{"durationSeconds"})
	if fromDurationSeconds != nil {
		setValueByPath(parentObject, []string{"parameters", "durationSeconds"}, fromDurationSeconds)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"parameters", "seed"}, fromSeed)
	}

	fromAspectRatio := getValueByPath(fromObject, []string{"aspectRatio"})
	if fromAspectRatio != nil {
		setValueByPath(parentObject, []string{"parameters", "aspectRatio"}, fromAspectRatio)
	}

	fromResolution := getValueByPath(fromObject, []string{"resolution"})
	if fromResolution != nil {
		setValueByPath(parentObject, []string{"parameters", "resolution"}, fromResolution)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	fromPubsubTopic := getValueByPath(fromObject, []string{"pubsubTopic"})
	if fromPubsubTopic != nil {
		setValueByPath(parentObject, []string{"parameters", "pubsubTopic"}, fromPubsubTopic)
	}

	fromNegativePrompt := getValueByPath(fromObject, []string{"negativePrompt"})
	if fromNegativePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "negativePrompt"}, fromNegativePrompt)
	}

	fromEnhancePrompt := getValueByPath(fromObject, []string{"enhancePrompt"})
	if fromEnhancePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "enhancePrompt"}, fromEnhancePrompt)
	}

	fromGenerateAudio := getValueByPath(fromObject, []string{"generateAudio"})
	if fromGenerateAudio != nil {
		setValueByPath(parentObject, []string{"parameters", "generateAudio"}, fromGenerateAudio)
	}

	fromLastFrame := getValueByPath(fromObject, []string{"lastFrame"})
	if fromLastFrame != nil {
		fromLastFrame, err = imageToVertex(fromLastFrame.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "lastFrame"}, fromLastFrame)
	}

	fromReferenceImages := getValueByPath(fromObject, []string{"referenceImages"})
	if fromReferenceImages != nil {
		fromReferenceImages, err = applyConverterToSlice(fromReferenceImages.([]any), videoGenerationReferenceImageToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "referenceImages"}, fromReferenceImages)
	}

	fromMask := getValueByPath(fromObject, []string{"mask"})
	if fromMask != nil {
		fromMask, err = videoGenerationMaskToVertex(fromMask.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "mask"}, fromMask)
	}

	fromCompressionQuality := getValueByPath(fromObject, []string{"compressionQuality"})
	if fromCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "compressionQuality"}, fromCompressionQuality)
	}

	return toObject, nil
}

func generateVideosOperationFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	fromDone := getValueByPath(fromObject, []string{"done"})
	if fromDone != nil {
		setValueByPath(toObject, []string{"done"}, fromDone)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	fromResponse := getValueByPath(fromObject, []string{"response", "generateVideoResponse"})
	if fromResponse != nil {
		fromResponse, err = generateVideosResponseFromMldev(fromResponse.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"response"}, fromResponse)
	}

	return toObject, nil
}

func generateVideosOperationFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	fromDone := getValueByPath(fromObject, []string{"done"})
	if fromDone != nil {
		setValueByPath(toObject, []string{"done"}, fromDone)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	fromResponse := getValueByPath(fromObject, []string{"response"})
	if fromResponse != nil {
		fromResponse, err = generateVideosResponseFromVertex(fromResponse.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"response"}, fromResponse)
	}

	return toObject, nil
}

func generateVideosParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(toObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToMldev(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = videoToMldev(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "video"}, fromVideo)
	}

	fromSource := getValueByPath(fromObject, []string{"source"})
	if fromSource != nil {
		_, err = generateVideosSourceToMldev(fromSource.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = generateVideosConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func generateVideosParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(toObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = videoToVertex(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "video"}, fromVideo)
	}

	fromSource := getValueByPath(fromObject, []string{"source"})
	if fromSource != nil {
		_, err = generateVideosSourceToVertex(fromSource.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = generateVideosConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func generateVideosResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGeneratedVideos := getValueByPath(fromObject, []string{"generatedSamples"})
	if fromGeneratedVideos != nil {
		fromGeneratedVideos, err = applyConverterToSlice(fromGeneratedVideos.([]any), generatedVideoFromMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedVideos"}, fromGeneratedVideos)
	}

	fromRaiMediaFilteredCount := getValueByPath(fromObject, []string{"raiMediaFilteredCount"})
	if fromRaiMediaFilteredCount != nil {
		setValueByPath(toObject, []string{"raiMediaFilteredCount"}, fromRaiMediaFilteredCount)
	}

	fromRaiMediaFilteredReasons := getValueByPath(fromObject, []string{"raiMediaFilteredReasons"})
	if fromRaiMediaFilteredReasons != nil {
		setValueByPath(toObject, []string{"raiMediaFilteredReasons"}, fromRaiMediaFilteredReasons)
	}

	return toObject, nil
}

func generateVideosResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGeneratedVideos := getValueByPath(fromObject, []string{"videos"})
	if fromGeneratedVideos != nil {
		fromGeneratedVideos, err = applyConverterToSlice(fromGeneratedVideos.([]any), generatedVideoFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedVideos"}, fromGeneratedVideos)
	}

	fromRaiMediaFilteredCount := getValueByPath(fromObject, []string{"raiMediaFilteredCount"})
	if fromRaiMediaFilteredCount != nil {
		setValueByPath(toObject, []string{"raiMediaFilteredCount"}, fromRaiMediaFilteredCount)
	}

	fromRaiMediaFilteredReasons := getValueByPath(fromObject, []string{"raiMediaFilteredReasons"})
	if fromRaiMediaFilteredReasons != nil {
		setValueByPath(toObject, []string{"raiMediaFilteredReasons"}, fromRaiMediaFilteredReasons)
	}

	return toObject, nil
}

func generateVideosSourceToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(parentObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToMldev(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = videoToMldev(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "video"}, fromVideo)
	}

	return toObject, nil
}

func generateVideosSourceToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(parentObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = videoToVertex(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "video"}, fromVideo)
	}

	return toObject, nil
}

func generatedImageFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"_self"})
	if fromImage != nil {
		fromImage, err = imageFromMldev(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromImage)
	}

	fromRaiFilteredReason := getValueByPath(fromObject, []string{"raiFilteredReason"})
	if fromRaiFilteredReason != nil {
		setValueByPath(toObject, []string{"raiFilteredReason"}, fromRaiFilteredReason)
	}

	fromSafetyAttributes := getValueByPath(fromObject, []string{"_self"})
	if fromSafetyAttributes != nil {
		fromSafetyAttributes, err = safetyAttributesFromMldev(fromSafetyAttributes.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"safetyAttributes"}, fromSafetyAttributes)
	}

	return toObject, nil
}

func generatedImageFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"_self"})
	if fromImage != nil {
		fromImage, err = imageFromVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromImage)
	}

	fromRaiFilteredReason := getValueByPath(fromObject, []string{"raiFilteredReason"})
	if fromRaiFilteredReason != nil {
		setValueByPath(toObject, []string{"raiFilteredReason"}, fromRaiFilteredReason)
	}

	fromSafetyAttributes := getValueByPath(fromObject, []string{"_self"})
	if fromSafetyAttributes != nil {
		fromSafetyAttributes, err = safetyAttributesFromVertex(fromSafetyAttributes.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"safetyAttributes"}, fromSafetyAttributes)
	}

	fromEnhancedPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromEnhancedPrompt != nil {
		setValueByPath(toObject, []string{"enhancedPrompt"}, fromEnhancedPrompt)
	}

	return toObject, nil
}

func generatedImageMaskFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMask := getValueByPath(fromObject, []string{"_self"})
	if fromMask != nil {
		fromMask, err = imageFromVertex(fromMask.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"mask"}, fromMask)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(toObject, []string{"labels"}, fromLabels)
	}

	return toObject, nil
}

func generatedVideoFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromVideo := getValueByPath(fromObject, []string{"_self"})
	if fromVideo != nil {
		fromVideo, err = videoFromMldev(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"video"}, fromVideo)
	}

	return toObject, nil
}

func generatedVideoFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromVideo := getValueByPath(fromObject, []string{"_self"})
	if fromVideo != nil {
		fromVideo, err = videoFromVertex(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"video"}, fromVideo)
	}

	return toObject, nil
}

func generationConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModelSelectionConfig := getValueByPath(fromObject, []string{"modelSelectionConfig"})
	if fromModelSelectionConfig != nil {
		setValueByPath(toObject, []string{"modelConfig"}, fromModelSelectionConfig)
	}

	fromAudioTimestamp := getValueByPath(fromObject, []string{"audioTimestamp"})
	if fromAudioTimestamp != nil {
		setValueByPath(toObject, []string{"audioTimestamp"}, fromAudioTimestamp)
	}

	fromCandidateCount := getValueByPath(fromObject, []string{"candidateCount"})
	if fromCandidateCount != nil {
		setValueByPath(toObject, []string{"candidateCount"}, fromCandidateCount)
	}

	fromEnableAffectiveDialog := getValueByPath(fromObject, []string{"enableAffectiveDialog"})
	if fromEnableAffectiveDialog != nil {
		setValueByPath(toObject, []string{"enableAffectiveDialog"}, fromEnableAffectiveDialog)
	}

	fromFrequencyPenalty := getValueByPath(fromObject, []string{"frequencyPenalty"})
	if fromFrequencyPenalty != nil {
		setValueByPath(toObject, []string{"frequencyPenalty"}, fromFrequencyPenalty)
	}

	fromLogprobs := getValueByPath(fromObject, []string{"logprobs"})
	if fromLogprobs != nil {
		setValueByPath(toObject, []string{"logprobs"}, fromLogprobs)
	}

	fromMaxOutputTokens := getValueByPath(fromObject, []string{"maxOutputTokens"})
	if fromMaxOutputTokens != nil {
		setValueByPath(toObject, []string{"maxOutputTokens"}, fromMaxOutputTokens)
	}

	fromMediaResolution := getValueByPath(fromObject, []string{"mediaResolution"})
	if fromMediaResolution != nil {
		setValueByPath(toObject, []string{"mediaResolution"}, fromMediaResolution)
	}

	fromPresencePenalty := getValueByPath(fromObject, []string{"presencePenalty"})
	if fromPresencePenalty != nil {
		setValueByPath(toObject, []string{"presencePenalty"}, fromPresencePenalty)
	}

	fromResponseJsonSchema := getValueByPath(fromObject, []string{"responseJsonSchema"})
	if fromResponseJsonSchema != nil {
		setValueByPath(toObject, []string{"responseJsonSchema"}, fromResponseJsonSchema)
	}

	fromResponseLogprobs := getValueByPath(fromObject, []string{"responseLogprobs"})
	if fromResponseLogprobs != nil {
		setValueByPath(toObject, []string{"responseLogprobs"}, fromResponseLogprobs)
	}

	fromResponseMimeType := getValueByPath(fromObject, []string{"responseMimeType"})
	if fromResponseMimeType != nil {
		setValueByPath(toObject, []string{"responseMimeType"}, fromResponseMimeType)
	}

	fromResponseModalities := getValueByPath(fromObject, []string{"responseModalities"})
	if fromResponseModalities != nil {
		setValueByPath(toObject, []string{"responseModalities"}, fromResponseModalities)
	}

	fromResponseSchema := getValueByPath(fromObject, []string{"responseSchema"})
	if fromResponseSchema != nil {
		setValueByPath(toObject, []string{"responseSchema"}, fromResponseSchema)
	}

	fromRoutingConfig := getValueByPath(fromObject, []string{"routingConfig"})
	if fromRoutingConfig != nil {
		setValueByPath(toObject, []string{"routingConfig"}, fromRoutingConfig)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(toObject, []string{"seed"}, fromSeed)
	}

	fromSpeechConfig := getValueByPath(fromObject, []string{"speechConfig"})
	if fromSpeechConfig != nil {
		fromSpeechConfig, err = speechConfigToVertex(fromSpeechConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"speechConfig"}, fromSpeechConfig)
	}

	fromStopSequences := getValueByPath(fromObject, []string{"stopSequences"})
	if fromStopSequences != nil {
		setValueByPath(toObject, []string{"stopSequences"}, fromStopSequences)
	}

	fromTemperature := getValueByPath(fromObject, []string{"temperature"})
	if fromTemperature != nil {
		setValueByPath(toObject, []string{"temperature"}, fromTemperature)
	}

	fromThinkingConfig := getValueByPath(fromObject, []string{"thinkingConfig"})
	if fromThinkingConfig != nil {
		setValueByPath(toObject, []string{"thinkingConfig"}, fromThinkingConfig)
	}

	fromTopK := getValueByPath(fromObject, []string{"topK"})
	if fromTopK != nil {
		setValueByPath(toObject, []string{"topK"}, fromTopK)
	}

	fromTopP := getValueByPath(fromObject, []string{"topP"})
	if fromTopP != nil {
		setValueByPath(toObject, []string{"topP"}, fromTopP)
	}

	return toObject, nil
}

func getModelParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromModel)
	}

	return toObject, nil
}

func getModelParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromModel)
	}

	return toObject, nil
}

func googleMapsToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"authConfig"}) != nil {
		return nil, fmt.Errorf("authConfig parameter is not supported in Gemini API")
	}

	fromEnableWidget := getValueByPath(fromObject, []string{"enableWidget"})
	if fromEnableWidget != nil {
		setValueByPath(toObject, []string{"enableWidget"}, fromEnableWidget)
	}

	return toObject, nil
}

func googleSearchToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromTimeRangeFilter := getValueByPath(fromObject, []string{"timeRangeFilter"})
	if fromTimeRangeFilter != nil {
		setValueByPath(toObject, []string{"timeRangeFilter"}, fromTimeRangeFilter)
	}

	if getValueByPath(fromObject, []string{"excludeDomains"}) != nil {
		return nil, fmt.Errorf("excludeDomains parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func imageFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImageBytes := getValueByPath(fromObject, []string{"bytesBase64Encoded"})
	if fromImageBytes != nil {
		fromImageBytes, err = tBytes(fromImageBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"imageBytes"}, fromImageBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func imageFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGcsUri := getValueByPath(fromObject, []string{"gcsUri"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsUri"}, fromGcsUri)
	}

	fromImageBytes := getValueByPath(fromObject, []string{"bytesBase64Encoded"})
	if fromImageBytes != nil {
		fromImageBytes, err = tBytes(fromImageBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"imageBytes"}, fromImageBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func imageToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"gcsUri"}) != nil {
		return nil, fmt.Errorf("gcsUri parameter is not supported in Gemini API")
	}

	fromImageBytes := getValueByPath(fromObject, []string{"imageBytes"})
	if fromImageBytes != nil {
		fromImageBytes, err = tBytes(fromImageBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"bytesBase64Encoded"}, fromImageBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func imageToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGcsUri := getValueByPath(fromObject, []string{"gcsUri"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsUri"}, fromGcsUri)
	}

	fromImageBytes := getValueByPath(fromObject, []string{"imageBytes"})
	if fromImageBytes != nil {
		fromImageBytes, err = tBytes(fromImageBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"bytesBase64Encoded"}, fromImageBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func listModelsConfigToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPageSize := getValueByPath(fromObject, []string{"pageSize"})
	if fromPageSize != nil {
		setValueByPath(parentObject, []string{"_query", "pageSize"}, fromPageSize)
	}

	fromPageToken := getValueByPath(fromObject, []string{"pageToken"})
	if fromPageToken != nil {
		setValueByPath(parentObject, []string{"_query", "pageToken"}, fromPageToken)
	}

	fromFilter := getValueByPath(fromObject, []string{"filter"})
	if fromFilter != nil {
		setValueByPath(parentObject, []string{"_query", "filter"}, fromFilter)
	}

	fromQueryBase := getValueByPath(fromObject, []string{"queryBase"})
	if fromQueryBase != nil {
		fromQueryBase, err = tModelsURL(ac, fromQueryBase)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"_url", "models_url"}, fromQueryBase)
	}

	return toObject, nil
}

func listModelsConfigToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPageSize := getValueByPath(fromObject, []string{"pageSize"})
	if fromPageSize != nil {
		setValueByPath(parentObject, []string{"_query", "pageSize"}, fromPageSize)
	}

	fromPageToken := getValueByPath(fromObject, []string{"pageToken"})
	if fromPageToken != nil {
		setValueByPath(parentObject, []string{"_query", "pageToken"}, fromPageToken)
	}

	fromFilter := getValueByPath(fromObject, []string{"filter"})
	if fromFilter != nil {
		setValueByPath(parentObject, []string{"_query", "filter"}, fromFilter)
	}

	fromQueryBase := getValueByPath(fromObject, []string{"queryBase"})
	if fromQueryBase != nil {
		fromQueryBase, err = tModelsURL(ac, fromQueryBase)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"_url", "models_url"}, fromQueryBase)
	}

	return toObject, nil
}

func listModelsParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = listModelsConfigToMldev(ac, fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func listModelsParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = listModelsConfigToVertex(ac, fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func listModelsResponseFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromNextPageToken := getValueByPath(fromObject, []string{"nextPageToken"})
	if fromNextPageToken != nil {
		setValueByPath(toObject, []string{"nextPageToken"}, fromNextPageToken)
	}

	fromModels := getValueByPath(fromObject, []string{"_self"})
	if fromModels != nil {
		fromModels, err = tExtractModels(fromModels)
		if err != nil {
			return nil, err
		}

		fromModels, err = applyConverterToSlice(fromModels.([]any), modelFromMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"models"}, fromModels)
	}

	return toObject, nil
}

func listModelsResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromNextPageToken := getValueByPath(fromObject, []string{"nextPageToken"})
	if fromNextPageToken != nil {
		setValueByPath(toObject, []string{"nextPageToken"}, fromNextPageToken)
	}

	fromModels := getValueByPath(fromObject, []string{"_self"})
	if fromModels != nil {
		fromModels, err = tExtractModels(fromModels)
		if err != nil {
			return nil, err
		}

		fromModels, err = applyConverterToSlice(fromModels.([]any), modelFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"models"}, fromModels)
	}

	return toObject, nil
}

func maskReferenceConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMaskMode := getValueByPath(fromObject, []string{"maskMode"})
	if fromMaskMode != nil {
		setValueByPath(toObject, []string{"maskMode"}, fromMaskMode)
	}

	fromSegmentationClasses := getValueByPath(fromObject, []string{"segmentationClasses"})
	if fromSegmentationClasses != nil {
		setValueByPath(toObject, []string{"maskClasses"}, fromSegmentationClasses)
	}

	fromMaskDilation := getValueByPath(fromObject, []string{"maskDilation"})
	if fromMaskDilation != nil {
		setValueByPath(toObject, []string{"dilation"}, fromMaskDilation)
	}

	return toObject, nil
}

func modelFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(toObject, []string{"displayName"}, fromDisplayName)
	}

	fromDescription := getValueByPath(fromObject, []string{"description"})
	if fromDescription != nil {
		setValueByPath(toObject, []string{"description"}, fromDescription)
	}

	fromVersion := getValueByPath(fromObject, []string{"version"})
	if fromVersion != nil {
		setValueByPath(toObject, []string{"version"}, fromVersion)
	}

	fromTunedModelInfo := getValueByPath(fromObject, []string{"_self"})
	if fromTunedModelInfo != nil {
		setValueByPath(toObject, []string{"tunedModelInfo"}, fromTunedModelInfo)
	}

	fromInputTokenLimit := getValueByPath(fromObject, []string{"inputTokenLimit"})
	if fromInputTokenLimit != nil {
		setValueByPath(toObject, []string{"inputTokenLimit"}, fromInputTokenLimit)
	}

	fromOutputTokenLimit := getValueByPath(fromObject, []string{"outputTokenLimit"})
	if fromOutputTokenLimit != nil {
		setValueByPath(toObject, []string{"outputTokenLimit"}, fromOutputTokenLimit)
	}

	fromSupportedActions := getValueByPath(fromObject, []string{"supportedGenerationMethods"})
	if fromSupportedActions != nil {
		setValueByPath(toObject, []string{"supportedActions"}, fromSupportedActions)
	}

	return toObject, nil
}

func modelFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(toObject, []string{"displayName"}, fromDisplayName)
	}

	fromDescription := getValueByPath(fromObject, []string{"description"})
	if fromDescription != nil {
		setValueByPath(toObject, []string{"description"}, fromDescription)
	}

	fromVersion := getValueByPath(fromObject, []string{"versionId"})
	if fromVersion != nil {
		setValueByPath(toObject, []string{"version"}, fromVersion)
	}

	fromEndpoints := getValueByPath(fromObject, []string{"deployedModels"})
	if fromEndpoints != nil {
		fromEndpoints, err = applyConverterToSlice(fromEndpoints.([]any), endpointFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"endpoints"}, fromEndpoints)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(toObject, []string{"labels"}, fromLabels)
	}

	fromTunedModelInfo := getValueByPath(fromObject, []string{"_self"})
	if fromTunedModelInfo != nil {
		fromTunedModelInfo, err = tunedModelInfoFromVertex(fromTunedModelInfo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"tunedModelInfo"}, fromTunedModelInfo)
	}

	fromDefaultCheckpointId := getValueByPath(fromObject, []string{"defaultCheckpointId"})
	if fromDefaultCheckpointId != nil {
		setValueByPath(toObject, []string{"defaultCheckpointId"}, fromDefaultCheckpointId)
	}

	fromCheckpoints := getValueByPath(fromObject, []string{"checkpoints"})
	if fromCheckpoints != nil {
		setValueByPath(toObject, []string{"checkpoints"}, fromCheckpoints)
	}

	return toObject, nil
}

func partToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromVideoMetadata := getValueByPath(fromObject, []string{"videoMetadata"})
	if fromVideoMetadata != nil {
		setValueByPath(toObject, []string{"videoMetadata"}, fromVideoMetadata)
	}

	fromThought := getValueByPath(fromObject, []string{"thought"})
	if fromThought != nil {
		setValueByPath(toObject, []string{"thought"}, fromThought)
	}

	fromInlineData := getValueByPath(fromObject, []string{"inlineData"})
	if fromInlineData != nil {
		fromInlineData, err = blobToMldev(fromInlineData.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"inlineData"}, fromInlineData)
	}

	fromFileData := getValueByPath(fromObject, []string{"fileData"})
	if fromFileData != nil {
		fromFileData, err = fileDataToMldev(fromFileData.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"fileData"}, fromFileData)
	}

	fromThoughtSignature := getValueByPath(fromObject, []string{"thoughtSignature"})
	if fromThoughtSignature != nil {
		setValueByPath(toObject, []string{"thoughtSignature"}, fromThoughtSignature)
	}

	fromFunctionCall := getValueByPath(fromObject, []string{"functionCall"})
	if fromFunctionCall != nil {
		setValueByPath(toObject, []string{"functionCall"}, fromFunctionCall)
	}

	fromCodeExecutionResult := getValueByPath(fromObject, []string{"codeExecutionResult"})
	if fromCodeExecutionResult != nil {
		setValueByPath(toObject, []string{"codeExecutionResult"}, fromCodeExecutionResult)
	}

	fromExecutableCode := getValueByPath(fromObject, []string{"executableCode"})
	if fromExecutableCode != nil {
		setValueByPath(toObject, []string{"executableCode"}, fromExecutableCode)
	}

	fromFunctionResponse := getValueByPath(fromObject, []string{"functionResponse"})
	if fromFunctionResponse != nil {
		setValueByPath(toObject, []string{"functionResponse"}, fromFunctionResponse)
	}

	fromText := getValueByPath(fromObject, []string{"text"})
	if fromText != nil {
		setValueByPath(toObject, []string{"text"}, fromText)
	}

	return toObject, nil
}

func productImageToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromProductImage := getValueByPath(fromObject, []string{"productImage"})
	if fromProductImage != nil {
		fromProductImage, err = imageToVertex(fromProductImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromProductImage)
	}

	return toObject, nil
}

func recontextImageConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromNumberOfImages := getValueByPath(fromObject, []string{"numberOfImages"})
	if fromNumberOfImages != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfImages)
	}

	fromBaseSteps := getValueByPath(fromObject, []string{"baseSteps"})
	if fromBaseSteps != nil {
		setValueByPath(parentObject, []string{"parameters", "editConfig", "baseSteps"}, fromBaseSteps)
	}

	fromOutputGcsUri := getValueByPath(fromObject, []string{"outputGcsUri"})
	if fromOutputGcsUri != nil {
		setValueByPath(parentObject, []string{"parameters", "storageUri"}, fromOutputGcsUri)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"parameters", "seed"}, fromSeed)
	}

	fromSafetyFilterLevel := getValueByPath(fromObject, []string{"safetyFilterLevel"})
	if fromSafetyFilterLevel != nil {
		setValueByPath(parentObject, []string{"parameters", "safetySetting"}, fromSafetyFilterLevel)
	}

	fromPersonGeneration := getValueByPath(fromObject, []string{"personGeneration"})
	if fromPersonGeneration != nil {
		setValueByPath(parentObject, []string{"parameters", "personGeneration"}, fromPersonGeneration)
	}

	fromAddWatermark := getValueByPath(fromObject, []string{"addWatermark"})
	if fromAddWatermark != nil {
		setValueByPath(parentObject, []string{"parameters", "addWatermark"}, fromAddWatermark)
	}

	fromOutputMimeType := getValueByPath(fromObject, []string{"outputMimeType"})
	if fromOutputMimeType != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "mimeType"}, fromOutputMimeType)
	}

	fromOutputCompressionQuality := getValueByPath(fromObject, []string{"outputCompressionQuality"})
	if fromOutputCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "compressionQuality"}, fromOutputCompressionQuality)
	}

	fromEnhancePrompt := getValueByPath(fromObject, []string{"enhancePrompt"})
	if fromEnhancePrompt != nil {
		setValueByPath(parentObject, []string{"parameters", "enhancePrompt"}, fromEnhancePrompt)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	return toObject, nil
}

func recontextImageParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromSource := getValueByPath(fromObject, []string{"source"})
	if fromSource != nil {
		_, err = recontextImageSourceToVertex(fromSource.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = recontextImageConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func recontextImageResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGeneratedImages := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedImages != nil {
		fromGeneratedImages, err = applyConverterToSlice(fromGeneratedImages.([]any), generatedImageFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedImages"}, fromGeneratedImages)
	}

	return toObject, nil
}

func recontextImageSourceToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(parentObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromPersonImage := getValueByPath(fromObject, []string{"personImage"})
	if fromPersonImage != nil {
		fromPersonImage, err = imageToVertex(fromPersonImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "personImage", "image"}, fromPersonImage)
	}

	fromProductImages := getValueByPath(fromObject, []string{"productImages"})
	if fromProductImages != nil {
		fromProductImages, err = applyConverterToSlice(fromProductImages.([]any), productImageToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "productImages"}, fromProductImages)
	}

	return toObject, nil
}

func referenceImageAPIToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromReferenceImage := getValueByPath(fromObject, []string{"referenceImage"})
	if fromReferenceImage != nil {
		fromReferenceImage, err = imageToVertex(fromReferenceImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"referenceImage"}, fromReferenceImage)
	}

	fromReferenceId := getValueByPath(fromObject, []string{"referenceId"})
	if fromReferenceId != nil {
		setValueByPath(toObject, []string{"referenceId"}, fromReferenceId)
	}

	fromReferenceType := getValueByPath(fromObject, []string{"referenceType"})
	if fromReferenceType != nil {
		setValueByPath(toObject, []string{"referenceType"}, fromReferenceType)
	}

	fromMaskImageConfig := getValueByPath(fromObject, []string{"maskImageConfig"})
	if fromMaskImageConfig != nil {
		fromMaskImageConfig, err = maskReferenceConfigToVertex(fromMaskImageConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"maskImageConfig"}, fromMaskImageConfig)
	}

	fromControlImageConfig := getValueByPath(fromObject, []string{"controlImageConfig"})
	if fromControlImageConfig != nil {
		fromControlImageConfig, err = controlReferenceConfigToVertex(fromControlImageConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"controlImageConfig"}, fromControlImageConfig)
	}

	fromStyleImageConfig := getValueByPath(fromObject, []string{"styleImageConfig"})
	if fromStyleImageConfig != nil {
		setValueByPath(toObject, []string{"styleImageConfig"}, fromStyleImageConfig)
	}

	fromSubjectImageConfig := getValueByPath(fromObject, []string{"subjectImageConfig"})
	if fromSubjectImageConfig != nil {
		setValueByPath(toObject, []string{"subjectImageConfig"}, fromSubjectImageConfig)
	}

	return toObject, nil
}

func safetyAttributesFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromCategories := getValueByPath(fromObject, []string{"safetyAttributes", "categories"})
	if fromCategories != nil {
		setValueByPath(toObject, []string{"categories"}, fromCategories)
	}

	fromScores := getValueByPath(fromObject, []string{"safetyAttributes", "scores"})
	if fromScores != nil {
		setValueByPath(toObject, []string{"scores"}, fromScores)
	}

	fromContentType := getValueByPath(fromObject, []string{"contentType"})
	if fromContentType != nil {
		setValueByPath(toObject, []string{"contentType"}, fromContentType)
	}

	return toObject, nil
}

func safetyAttributesFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromCategories := getValueByPath(fromObject, []string{"safetyAttributes", "categories"})
	if fromCategories != nil {
		setValueByPath(toObject, []string{"categories"}, fromCategories)
	}

	fromScores := getValueByPath(fromObject, []string{"safetyAttributes", "scores"})
	if fromScores != nil {
		setValueByPath(toObject, []string{"scores"}, fromScores)
	}

	fromContentType := getValueByPath(fromObject, []string{"contentType"})
	if fromContentType != nil {
		setValueByPath(toObject, []string{"contentType"}, fromContentType)
	}

	return toObject, nil
}

func safetySettingToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"method"}) != nil {
		return nil, fmt.Errorf("method parameter is not supported in Gemini API")
	}

	fromCategory := getValueByPath(fromObject, []string{"category"})
	if fromCategory != nil {
		setValueByPath(toObject, []string{"category"}, fromCategory)
	}

	fromThreshold := getValueByPath(fromObject, []string{"threshold"})
	if fromThreshold != nil {
		setValueByPath(toObject, []string{"threshold"}, fromThreshold)
	}

	return toObject, nil
}

func scribbleImageToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromImage)
	}

	return toObject, nil
}

func segmentImageConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMode := getValueByPath(fromObject, []string{"mode"})
	if fromMode != nil {
		setValueByPath(parentObject, []string{"parameters", "mode"}, fromMode)
	}

	fromMaxPredictions := getValueByPath(fromObject, []string{"maxPredictions"})
	if fromMaxPredictions != nil {
		setValueByPath(parentObject, []string{"parameters", "maxPredictions"}, fromMaxPredictions)
	}

	fromConfidenceThreshold := getValueByPath(fromObject, []string{"confidenceThreshold"})
	if fromConfidenceThreshold != nil {
		setValueByPath(parentObject, []string{"parameters", "confidenceThreshold"}, fromConfidenceThreshold)
	}

	fromMaskDilation := getValueByPath(fromObject, []string{"maskDilation"})
	if fromMaskDilation != nil {
		setValueByPath(parentObject, []string{"parameters", "maskDilation"}, fromMaskDilation)
	}

	fromBinaryColorThreshold := getValueByPath(fromObject, []string{"binaryColorThreshold"})
	if fromBinaryColorThreshold != nil {
		setValueByPath(parentObject, []string{"parameters", "binaryColorThreshold"}, fromBinaryColorThreshold)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	return toObject, nil
}

func segmentImageParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromSource := getValueByPath(fromObject, []string{"source"})
	if fromSource != nil {
		_, err = segmentImageSourceToVertex(fromSource.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = segmentImageConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func segmentImageResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromGeneratedMasks := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedMasks != nil {
		fromGeneratedMasks, err = applyConverterToSlice(fromGeneratedMasks.([]any), generatedImageMaskFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedMasks"}, fromGeneratedMasks)
	}

	return toObject, nil
}

func segmentImageSourceToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPrompt := getValueByPath(fromObject, []string{"prompt"})
	if fromPrompt != nil {
		setValueByPath(parentObject, []string{"instances[0]", "prompt"}, fromPrompt)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromScribbleImage := getValueByPath(fromObject, []string{"scribbleImage"})
	if fromScribbleImage != nil {
		fromScribbleImage, err = scribbleImageToVertex(fromScribbleImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"instances[0]", "scribble"}, fromScribbleImage)
	}

	return toObject, nil
}

func speechConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromVoiceConfig := getValueByPath(fromObject, []string{"voiceConfig"})
	if fromVoiceConfig != nil {
		setValueByPath(toObject, []string{"voiceConfig"}, fromVoiceConfig)
	}

	if getValueByPath(fromObject, []string{"multiSpeakerVoiceConfig"}) != nil {
		return nil, fmt.Errorf("multiSpeakerVoiceConfig parameter is not supported in Vertex AI")
	}

	fromLanguageCode := getValueByPath(fromObject, []string{"languageCode"})
	if fromLanguageCode != nil {
		setValueByPath(toObject, []string{"languageCode"}, fromLanguageCode)
	}

	return toObject, nil
}

func toolToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFunctionDeclarations := getValueByPath(fromObject, []string{"functionDeclarations"})
	if fromFunctionDeclarations != nil {
		setValueByPath(toObject, []string{"functionDeclarations"}, fromFunctionDeclarations)
	}

	if getValueByPath(fromObject, []string{"retrieval"}) != nil {
		return nil, fmt.Errorf("retrieval parameter is not supported in Gemini API")
	}

	fromGoogleSearch := getValueByPath(fromObject, []string{"googleSearch"})
	if fromGoogleSearch != nil {
		fromGoogleSearch, err = googleSearchToMldev(fromGoogleSearch.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"googleSearch"}, fromGoogleSearch)
	}

	fromGoogleSearchRetrieval := getValueByPath(fromObject, []string{"googleSearchRetrieval"})
	if fromGoogleSearchRetrieval != nil {
		setValueByPath(toObject, []string{"googleSearchRetrieval"}, fromGoogleSearchRetrieval)
	}

	if getValueByPath(fromObject, []string{"enterpriseWebSearch"}) != nil {
		return nil, fmt.Errorf("enterpriseWebSearch parameter is not supported in Gemini API")
	}

	fromGoogleMaps := getValueByPath(fromObject, []string{"googleMaps"})
	if fromGoogleMaps != nil {
		fromGoogleMaps, err = googleMapsToMldev(fromGoogleMaps.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"googleMaps"}, fromGoogleMaps)
	}

	fromUrlContext := getValueByPath(fromObject, []string{"urlContext"})
	if fromUrlContext != nil {
		setValueByPath(toObject, []string{"urlContext"}, fromUrlContext)
	}

	fromComputerUse := getValueByPath(fromObject, []string{"computerUse"})
	if fromComputerUse != nil {
		setValueByPath(toObject, []string{"computerUse"}, fromComputerUse)
	}

	fromCodeExecution := getValueByPath(fromObject, []string{"codeExecution"})
	if fromCodeExecution != nil {
		setValueByPath(toObject, []string{"codeExecution"}, fromCodeExecution)
	}

	return toObject, nil
}

func toolToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFunctionDeclarations := getValueByPath(fromObject, []string{"functionDeclarations"})
	if fromFunctionDeclarations != nil {
		fromFunctionDeclarations, err = applyConverterToSlice(fromFunctionDeclarations.([]any), functionDeclarationToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"functionDeclarations"}, fromFunctionDeclarations)
	}

	fromRetrieval := getValueByPath(fromObject, []string{"retrieval"})
	if fromRetrieval != nil {
		setValueByPath(toObject, []string{"retrieval"}, fromRetrieval)
	}

	fromGoogleSearch := getValueByPath(fromObject, []string{"googleSearch"})
	if fromGoogleSearch != nil {
		setValueByPath(toObject, []string{"googleSearch"}, fromGoogleSearch)
	}

	fromGoogleSearchRetrieval := getValueByPath(fromObject, []string{"googleSearchRetrieval"})
	if fromGoogleSearchRetrieval != nil {
		setValueByPath(toObject, []string{"googleSearchRetrieval"}, fromGoogleSearchRetrieval)
	}

	fromEnterpriseWebSearch := getValueByPath(fromObject, []string{"enterpriseWebSearch"})
	if fromEnterpriseWebSearch != nil {
		setValueByPath(toObject, []string{"enterpriseWebSearch"}, fromEnterpriseWebSearch)
	}

	fromGoogleMaps := getValueByPath(fromObject, []string{"googleMaps"})
	if fromGoogleMaps != nil {
		setValueByPath(toObject, []string{"googleMaps"}, fromGoogleMaps)
	}

	fromUrlContext := getValueByPath(fromObject, []string{"urlContext"})
	if fromUrlContext != nil {
		setValueByPath(toObject, []string{"urlContext"}, fromUrlContext)
	}

	fromComputerUse := getValueByPath(fromObject, []string{"computerUse"})
	if fromComputerUse != nil {
		setValueByPath(toObject, []string{"computerUse"}, fromComputerUse)
	}

	fromCodeExecution := getValueByPath(fromObject, []string{"codeExecution"})
	if fromCodeExecution != nil {
		setValueByPath(toObject, []string{"codeExecution"}, fromCodeExecution)
	}

	return toObject, nil
}

func tunedModelInfoFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromBaseModel := getValueByPath(fromObject, []string{"labels", "google-vertex-llm-tuning-base-model-id"})
	if fromBaseModel != nil {
		setValueByPath(toObject, []string{"baseModel"}, fromBaseModel)
	}

	fromCreateTime := getValueByPath(fromObject, []string{"createTime"})
	if fromCreateTime != nil {
		setValueByPath(toObject, []string{"createTime"}, fromCreateTime)
	}

	fromUpdateTime := getValueByPath(fromObject, []string{"updateTime"})
	if fromUpdateTime != nil {
		setValueByPath(toObject, []string{"updateTime"}, fromUpdateTime)
	}

	return toObject, nil
}

func updateModelConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"displayName"}, fromDisplayName)
	}

	fromDescription := getValueByPath(fromObject, []string{"description"})
	if fromDescription != nil {
		setValueByPath(parentObject, []string{"description"}, fromDescription)
	}

	fromDefaultCheckpointId := getValueByPath(fromObject, []string{"defaultCheckpointId"})
	if fromDefaultCheckpointId != nil {
		setValueByPath(parentObject, []string{"defaultCheckpointId"}, fromDefaultCheckpointId)
	}

	return toObject, nil
}

func updateModelConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"displayName"}, fromDisplayName)
	}

	fromDescription := getValueByPath(fromObject, []string{"description"})
	if fromDescription != nil {
		setValueByPath(parentObject, []string{"description"}, fromDescription)
	}

	fromDefaultCheckpointId := getValueByPath(fromObject, []string{"defaultCheckpointId"})
	if fromDefaultCheckpointId != nil {
		setValueByPath(parentObject, []string{"defaultCheckpointId"}, fromDefaultCheckpointId)
	}

	return toObject, nil
}

func updateModelParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromModel)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = updateModelConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func updateModelParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = updateModelConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func upscaleImageAPIConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromOutputGcsUri := getValueByPath(fromObject, []string{"outputGcsUri"})
	if fromOutputGcsUri != nil {
		setValueByPath(parentObject, []string{"parameters", "storageUri"}, fromOutputGcsUri)
	}

	fromIncludeRaiReason := getValueByPath(fromObject, []string{"includeRaiReason"})
	if fromIncludeRaiReason != nil {
		setValueByPath(parentObject, []string{"parameters", "includeRaiReason"}, fromIncludeRaiReason)
	}

	fromOutputMimeType := getValueByPath(fromObject, []string{"outputMimeType"})
	if fromOutputMimeType != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "mimeType"}, fromOutputMimeType)
	}

	fromOutputCompressionQuality := getValueByPath(fromObject, []string{"outputCompressionQuality"})
	if fromOutputCompressionQuality != nil {
		setValueByPath(parentObject, []string{"parameters", "outputOptions", "compressionQuality"}, fromOutputCompressionQuality)
	}

	fromEnhanceInputImage := getValueByPath(fromObject, []string{"enhanceInputImage"})
	if fromEnhanceInputImage != nil {
		setValueByPath(parentObject, []string{"parameters", "upscaleConfig", "enhanceInputImage"}, fromEnhanceInputImage)
	}

	fromImagePreservationFactor := getValueByPath(fromObject, []string{"imagePreservationFactor"})
	if fromImagePreservationFactor != nil {
		setValueByPath(parentObject, []string{"parameters", "upscaleConfig", "imagePreservationFactor"}, fromImagePreservationFactor)
	}

	fromLabels := getValueByPath(fromObject, []string{"labels"})
	if fromLabels != nil {
		setValueByPath(parentObject, []string{"labels"}, fromLabels)
	}

	fromNumberOfImages := getValueByPath(fromObject, []string{"numberOfImages"})
	if fromNumberOfImages != nil {
		setValueByPath(parentObject, []string{"parameters", "sampleCount"}, fromNumberOfImages)
	}

	fromMode := getValueByPath(fromObject, []string{"mode"})
	if fromMode != nil {
		setValueByPath(parentObject, []string{"parameters", "mode"}, fromMode)
	}

	return toObject, nil
}

func upscaleImageAPIParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"instances[0]", "image"}, fromImage)
	}

	fromUpscaleFactor := getValueByPath(fromObject, []string{"upscaleFactor"})
	if fromUpscaleFactor != nil {
		setValueByPath(toObject, []string{"parameters", "upscaleConfig", "upscaleFactor"}, fromUpscaleFactor)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = upscaleImageAPIConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func upscaleImageResponseFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromGeneratedImages := getValueByPath(fromObject, []string{"predictions"})
	if fromGeneratedImages != nil {
		fromGeneratedImages, err = applyConverterToSlice(fromGeneratedImages.([]any), generatedImageFromVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generatedImages"}, fromGeneratedImages)
	}

	return toObject, nil
}

func videoFromMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromUri := getValueByPath(fromObject, []string{"video", "uri"})
	if fromUri != nil {
		setValueByPath(toObject, []string{"uri"}, fromUri)
	}

	fromVideoBytes := getValueByPath(fromObject, []string{"video", "encodedVideo"})
	if fromVideoBytes != nil {
		fromVideoBytes, err = tBytes(fromVideoBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"videoBytes"}, fromVideoBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"encoding"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func videoFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromUri := getValueByPath(fromObject, []string{"gcsUri"})
	if fromUri != nil {
		setValueByPath(toObject, []string{"uri"}, fromUri)
	}

	fromVideoBytes := getValueByPath(fromObject, []string{"bytesBase64Encoded"})
	if fromVideoBytes != nil {
		fromVideoBytes, err = tBytes(fromVideoBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"videoBytes"}, fromVideoBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

func videoGenerationMaskToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_self"}, fromImage)
	}

	fromMaskMode := getValueByPath(fromObject, []string{"maskMode"})
	if fromMaskMode != nil {
		setValueByPath(toObject, []string{"maskMode"}, fromMaskMode)
	}

	return toObject, nil
}

func videoGenerationReferenceImageToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToMldev(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromImage)
	}

	fromReferenceType := getValueByPath(fromObject, []string{"referenceType"})
	if fromReferenceType != nil {
		setValueByPath(toObject, []string{"referenceType"}, fromReferenceType)
	}

	return toObject, nil
}

func videoGenerationReferenceImageToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromImage := getValueByPath(fromObject, []string{"image"})
	if fromImage != nil {
		fromImage, err = imageToVertex(fromImage.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"image"}, fromImage)
	}

	fromReferenceType := getValueByPath(fromObject, []string{"referenceType"})
	if fromReferenceType != nil {
		setValueByPath(toObject, []string{"referenceType"}, fromReferenceType)
	}

	return toObject, nil
}

func videoToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromUri := getValueByPath(fromObject, []string{"uri"})
	if fromUri != nil {
		setValueByPath(toObject, []string{"video", "uri"}, fromUri)
	}

	fromVideoBytes := getValueByPath(fromObject, []string{"videoBytes"})
	if fromVideoBytes != nil {
		fromVideoBytes, err = tBytes(fromVideoBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"video", "encodedVideo"}, fromVideoBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"encoding"}, fromMimeType)
	}

	return toObject, nil
}

func videoToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromUri := getValueByPath(fromObject, []string{"uri"})
	if fromUri != nil {
		setValueByPath(toObject, []string{"gcsUri"}, fromUri)
	}

	fromVideoBytes := getValueByPath(fromObject, []string{"videoBytes"})
	if fromVideoBytes != nil {
		fromVideoBytes, err = tBytes(fromVideoBytes)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"bytesBase64Encoded"}, fromVideoBytes)
	}

	fromMimeType := getValueByPath(fromObject, []string{"mimeType"})
	if fromMimeType != nil {
		setValueByPath(toObject, []string{"mimeType"}, fromMimeType)
	}

	return toObject, nil
}

// Models provides methods for interacting with the available language models.
// You don't need to initiate this struct. Create a client instance via NewClient, and
// then access Models through client.Models field.
type Models struct {
	apiClient *apiClient
}

func (m Models) generateContent(ctx context.Context, model string, contents []*Content, config *GenerateContentConfig) (*GenerateContentResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "contents": contents, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(GenerateContentResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = generateContentParametersToVertex
		fromConverter = generateContentResponseFromVertex
	} else {
		toConverter = generateContentParametersToMldev
		fromConverter = generateContentResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:generateContent", urlParams)
	} else {
		path, err = formatMap("{model}:generateContent", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

func (m Models) generateContentStream(ctx context.Context, model string, contents []*Content, config *GenerateContentConfig) iter.Seq2[*GenerateContentResponse, error] {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "contents": contents, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var rs responseStream[GenerateContentResponse]
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = generateContentParametersToVertex
		fromConverter = generateContentResponseFromVertex
	} else {
		toConverter = generateContentParametersToMldev
		fromConverter = generateContentResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return yieldErrorAndEndIterator[GenerateContentResponse](err)
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:streamGenerateContent?alt=sse", urlParams)
	} else {
		path, err = formatMap("{model}:streamGenerateContent?alt=sse", urlParams)
	}
	if err != nil {
		return yieldErrorAndEndIterator[GenerateContentResponse](fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err))
	}
	delete(body, "_url")
	delete(body, "config")
	err = sendStreamRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions, &rs)
	if err != nil {
		return yieldErrorAndEndIterator[GenerateContentResponse](err)
	}
	return iterateResponseStream(&rs, func(responseMap map[string]any) (*GenerateContentResponse, error) {
		responseMap, err := fromConverter(responseMap, nil)
		if err != nil {
			return nil, err
		}
		var response = new(GenerateContentResponse)
		err = mapToStruct(responseMap, response)
		if err != nil {
			return nil, err
		}
		return response, nil
	})
}

// EmbedContent generates embeddings for the provided contents using the specified model.
func (m Models) EmbedContent(ctx context.Context, model string, contents []*Content, config *EmbedContentConfig) (*EmbedContentResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "contents": contents, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(EmbedContentResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = embedContentParametersToVertex
		fromConverter = embedContentResponseFromVertex
	} else {
		toConverter = embedContentParametersToMldev
		fromConverter = embedContentResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("{model}:batchEmbedContents", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// generateImages private method for generating images.
func (m Models) generateImages(ctx context.Context, model string, prompt string, config *GenerateImagesConfig) (*GenerateImagesResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "prompt": prompt, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(GenerateImagesResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = generateImagesParametersToVertex
		fromConverter = generateImagesResponseFromVertex
	} else {
		toConverter = generateImagesParametersToMldev
		fromConverter = generateImagesResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("{model}:predict", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// editImage private method for editing an image.
func (m Models) editImage(ctx context.Context, model string, prompt string, referenceImages []*referenceImageAPI, config *EditImageConfig) (*EditImageResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "prompt": prompt, "referenceImages": referenceImages, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(EditImageResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = editImageParametersToVertex
		fromConverter = editImageResponseFromVertex
	} else {

		return nil, fmt.Errorf("method EditImage is only supported in the Vertex AI client. You can choose to use Vertex AI by setting ClientConfig.Backend to BackendVertexAI.")

	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("None", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// upscaleImage private method for upscaling an image.
func (m Models) upscaleImage(ctx context.Context, model string, image *Image, upscaleFactor string, config *upscaleImageAPIConfig) (*UpscaleImageResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "image": image, "upscaleFactor": upscaleFactor, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(UpscaleImageResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = upscaleImageAPIParametersToVertex
		fromConverter = upscaleImageResponseFromVertex
	} else {

		return nil, fmt.Errorf("method UpscaleImage is only supported in the Vertex AI client. You can choose to use Vertex AI by setting ClientConfig.Backend to BackendVertexAI.")

	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("None", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// RecontextImage recontextualizes an image.
// There are two types of recontextualization currently supported:
// 1) Imagen Product Recontext - Generate images of products in new scenes
// and contexts.
// 2) Virtual Try-On: Generate images of persons modeling fashion products.
func (m Models) RecontextImage(ctx context.Context, model string, source *RecontextImageSource, config *RecontextImageConfig) (*RecontextImageResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "source": source, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(RecontextImageResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = recontextImageParametersToVertex
		fromConverter = recontextImageResponseFromVertex
	} else {

		return nil, fmt.Errorf("method RecontextImage is only supported in the Vertex AI client. You can choose to use Vertex AI by setting ClientConfig.Backend to BackendVertexAI.")

	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("None", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// SegmentImage segments an image, creating a mask of a specified area.
func (m Models) SegmentImage(ctx context.Context, model string, source *SegmentImageSource, config *SegmentImageConfig) (*SegmentImageResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "source": source, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(SegmentImageResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = segmentImageParametersToVertex
		fromConverter = segmentImageResponseFromVertex
	} else {

		return nil, fmt.Errorf("method SegmentImage is only supported in the Vertex AI client. You can choose to use Vertex AI by setting ClientConfig.Backend to BackendVertexAI.")

	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predict", urlParams)
	} else {
		path, err = formatMap("None", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// Get retrieves a specific model resource by its name.
func (m Models) Get(ctx context.Context, model string, config *GetModelConfig) (*Model, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(Model)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = getModelParametersToVertex
		fromConverter = modelFromVertex
	} else {
		toConverter = getModelParametersToMldev
		fromConverter = modelFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{name}", urlParams)
	} else {
		path, err = formatMap("{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

func (m Models) list(ctx context.Context, config *ListModelsConfig) (*ListModelsResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(ListModelsResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = listModelsParametersToVertex
		fromConverter = listModelsResponseFromVertex
	} else {
		toConverter = listModelsParametersToMldev
		fromConverter = listModelsResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{models_url}", urlParams)
	} else {
		path, err = formatMap("{models_url}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// Update updates a specific model resource.
func (m Models) Update(ctx context.Context, model string, config *UpdateModelConfig) (*Model, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(Model)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = updateModelParametersToVertex
		fromConverter = modelFromVertex
	} else {
		toConverter = updateModelParametersToMldev
		fromConverter = modelFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}", urlParams)
	} else {
		path, err = formatMap("{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPatch, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// Delete deletes a specific model resource by its name.
func (m Models) Delete(ctx context.Context, model string, config *DeleteModelConfig) (*DeleteModelResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(DeleteModelResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = deleteModelParametersToVertex
		fromConverter = deleteModelResponseFromVertex
	} else {
		toConverter = deleteModelParametersToMldev
		fromConverter = deleteModelResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{name}", urlParams)
	} else {
		path, err = formatMap("{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodDelete, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// CountTokens counts the number of tokens in the provided contents.
func (m Models) CountTokens(ctx context.Context, model string, contents []*Content, config *CountTokensConfig) (*CountTokensResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "contents": contents, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(CountTokensResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = countTokensParametersToVertex
		fromConverter = countTokensResponseFromVertex
	} else {
		toConverter = countTokensParametersToMldev
		fromConverter = countTokensResponseFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:countTokens", urlParams)
	} else {
		path, err = formatMap("{model}:countTokens", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// ComputeTokens computes the number of tokens for the provided contents.
func (m Models) ComputeTokens(ctx context.Context, model string, contents []*Content, config *ComputeTokensConfig) (*ComputeTokensResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "contents": contents, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(ComputeTokensResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = computeTokensParametersToVertex
		fromConverter = computeTokensResponseFromVertex
	} else {

		return nil, fmt.Errorf("method ComputeTokens is only supported in the Vertex AI client. You can choose to use Vertex AI by setting ClientConfig.Backend to BackendVertexAI.")

	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:computeTokens", urlParams)
	} else {
		path, err = formatMap("None", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// generateVideos private method for generating videos.
func (m Models) generateVideos(ctx context.Context, model string, prompt *string, image *Image, video *Video, source *GenerateVideosSource, config *GenerateVideosConfig) (*GenerateVideosOperation, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "prompt": prompt, "image": image, "video": video, "source": source, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(GenerateVideosOperation)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = generateVideosParametersToVertex
		fromConverter = generateVideosOperationFromVertex
	} else {
		toConverter = generateVideosParametersToMldev
		fromConverter = generateVideosOperationFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("{model}:predictLongRunning", urlParams)
	} else {
		path, err = formatMap("{model}:predictLongRunning", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// GenerateContent generates content based on the provided model, contents, and configuration.
func (m Models) GenerateContent(ctx context.Context, model string, contents []*Content, config *GenerateContentConfig) (*GenerateContentResponse, error) {
	if config != nil {
		config.setDefaults()
	}
	return m.generateContent(ctx, model, contents, config)
}

// GenerateContentStream generates a stream of content based on the provided model, contents, and configuration.
func (m Models) GenerateContentStream(ctx context.Context, model string, contents []*Content, config *GenerateContentConfig) iter.Seq2[*GenerateContentResponse, error] {
	if config != nil {
		config.setDefaults()
	}
	return m.generateContentStream(ctx, model, contents, config)
}

// List retrieves a paginated list of models resources.
func (m Models) List(ctx context.Context, config *ListModelsConfig) (Page[Model], error) {
	listFunc := func(ctx context.Context, config map[string]any) ([]*Model, string, *HTTPResponse, error) {
		var c ListModelsConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		if c.QueryBase == nil {
			c.QueryBase = Ptr(true)
		}
		if m.apiClient.clientConfig.Backend == BackendVertexAI && !*c.QueryBase {
			if c.Filter != "" {
				c.Filter += "&filter="
			}
			c.Filter += "labels.tune-type:*"
		}
		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.Models, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	c := make(map[string]any)
	deepMarshal(config, &c)
	return newPage(ctx, "models", c, listFunc)
}

// All retrieves all models resources.
//
// This method handles pagination internally, making multiple API calls as needed
// to fetch all entries. It returns an iterator that yields each cached
// content entry one by one. You do not need to manage pagination
// tokens or make multiple calls to retrieve all data.
func (m Models) All(ctx context.Context) iter.Seq2[*Model, error] {
	listFunc := func(ctx context.Context, config map[string]any) ([]*Model, string, *HTTPResponse, error) {
		var c ListModelsConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		if c.QueryBase == nil {
			c.QueryBase = Ptr(true)
		}

		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.Models, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	p, err := newPage(ctx, "models", map[string]any{}, listFunc)
	if err != nil {
		return yieldErrorAndEndIterator[Model](err)
	}
	return p.all(ctx)
}

// GenerateImages generates images based on the provided model, prompt, and configuration.
func (m Models) GenerateImages(ctx context.Context, model string, prompt string, config *GenerateImagesConfig) (*GenerateImagesResponse, error) {
	apiResponse, err := m.generateImages(ctx, model, prompt, config)
	if err != nil {
		return nil, err
	}
	var positivePromptSafetyAttributes *SafetyAttributes
	generatedImages := []*GeneratedImage{}

	for _, generatedImage := range apiResponse.GeneratedImages {
		if generatedImage.SafetyAttributes != nil && generatedImage.SafetyAttributes.ContentType == "Positive Prompt" {
			positivePromptSafetyAttributes = generatedImage.SafetyAttributes
		} else {
			generatedImages = append(generatedImages, generatedImage)
		}
	}

	var sdkHTTPResponse *HTTPResponse
	if apiResponse.SDKHTTPResponse != nil {
		sdkHTTPResponse = apiResponse.SDKHTTPResponse
	}

	return &GenerateImagesResponse{
		GeneratedImages:                generatedImages,
		PositivePromptSafetyAttributes: positivePromptSafetyAttributes,
		SDKHTTPResponse:                sdkHTTPResponse,
	}, nil
}

// UpscaleImage upscales an image using the specified model, image, upscale factor, and configuration.
func (m Models) UpscaleImage(ctx context.Context, model string, image *Image, upscaleFactor string, config *UpscaleImageConfig) (*UpscaleImageResponse, error) {
	// Convert to API config.
	apiConfig := &upscaleImageAPIConfig{Mode: "upscale", NumberOfImages: 1}

	if config != nil {
		apiConfig.OutputGCSURI = config.OutputGCSURI
		apiConfig.OutputMIMEType = config.OutputMIMEType
		apiConfig.OutputCompressionQuality = config.OutputCompressionQuality
		apiConfig.IncludeRAIReason = config.IncludeRAIReason
		apiConfig.EnhanceInputImage = config.EnhanceInputImage
		apiConfig.ImagePreservationFactor = config.ImagePreservationFactor
		apiConfig.Labels = config.Labels
	}

	return m.upscaleImage(ctx, model, image, upscaleFactor, apiConfig)
}

// EditImage edits an image based on the provided model, prompt, reference images, and configuration.
func (m Models) EditImage(ctx context.Context, model, prompt string, referenceImages []ReferenceImage, config *EditImageConfig) (*EditImageResponse, error) {
	refImages := make([]*referenceImageAPI, len(referenceImages))
	for i, img := range referenceImages {
		refImages[i] = img.referenceImageAPI()
	}
	return m.editImage(ctx, model, prompt, refImages, config)
}

// GenerateVideos creates a long-running video generation operation.
// This method is kept for backward compatibility. Use GenerateVideosFromSource instead.
func (m Models) GenerateVideos(ctx context.Context, model string, prompt string, image *Image, config *GenerateVideosConfig) (*GenerateVideosOperation, error) {
	// Does not support Video or GenerateVideosSource.
	return m.generateVideos(ctx, model, &prompt, image, nil, nil, config)
}

// GenerateVideos creates a long-running video generation operation.
func (m Models) GenerateVideosFromSource(ctx context.Context, model string, source *GenerateVideosSource, config *GenerateVideosConfig) (*GenerateVideosOperation, error) {
	if source == nil {
		return nil, fmt.Errorf("source is required")
	}
	// Rely on backend validation for combinations of prompt, image, and video.
	return m.generateVideos(ctx, model, nil, nil, nil, source, config)
}
