// Package deviceorientation provides the Chrome DevTools Protocol
// commands, types, and events for the DeviceOrientation domain.
//
// Generated by the cdproto-gen command.
package deviceorientation

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// ClearDeviceOrientationOverrideParams clears the overridden Device
// Orientation.
type ClearDeviceOrientationOverrideParams struct{}

// ClearDeviceOrientationOverride clears the overridden Device Orientation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation#method-clearDeviceOrientationOverride
func ClearDeviceOrientationOverride() *ClearDeviceOrientationOverrideParams {
	return &ClearDeviceOrientationOverrideParams{}
}

// Do executes DeviceOrientation.clearDeviceOrientationOverride against the provided context.
func (p *ClearDeviceOrientationOverrideParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandClearDeviceOrientationOverride, nil, nil)
}

// SetDeviceOrientationOverrideParams overrides the Device Orientation.
type SetDeviceOrientationOverrideParams struct {
	Alpha float64 `json:"alpha"` // Mock alpha
	Beta  float64 `json:"beta"`  // Mock beta
	Gamma float64 `json:"gamma"` // Mock gamma
}

// SetDeviceOrientationOverride overrides the Device Orientation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation#method-setDeviceOrientationOverride
//
// parameters:
//   alpha - Mock alpha
//   beta - Mock beta
//   gamma - Mock gamma
func SetDeviceOrientationOverride(alpha float64, beta float64, gamma float64) *SetDeviceOrientationOverrideParams {
	return &SetDeviceOrientationOverrideParams{
		Alpha: alpha,
		Beta:  beta,
		Gamma: gamma,
	}
}

// Do executes DeviceOrientation.setDeviceOrientationOverride against the provided context.
func (p *SetDeviceOrientationOverrideParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetDeviceOrientationOverride, p, nil)
}

// Command names.
const (
	CommandClearDeviceOrientationOverride = "DeviceOrientation.clearDeviceOrientationOverride"
	CommandSetDeviceOrientationOverride   = "DeviceOrientation.setDeviceOrientationOverride"
)
