// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// MinProximityOption is a wrapper for an MinProximity option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type MinProximityOption struct {
	value int
}

// MinProximity wraps the given value into a MinProximityOption.
func MinProximity(v int) *MinProximityOption {
	return &MinProximityOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *MinProximityOption) Get() int {
	if o == nil {
		return 1
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// MinProximityOption.
func (o MinProximityOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// MinProximityOption.
func (o *MinProximityOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = 1
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *MinProximityOption) Equal(o2 *MinProximityOption) bool {
	if o == nil {
		return o2 == nil || o2.value == 1
	}
	if o2 == nil {
		return o == nil || o.value == 1
	}
	return o.value == o2.value
}

// MinProximityEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func MinProximityEqual(o1, o2 *MinProximityOption) bool {
	return o1.Equal(o2)
}
