// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package securitycenterpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The mute state.
type BulkMuteFindingsRequest_MuteState int32

const (
	// Unused.
	BulkMuteFindingsRequest_MUTE_STATE_UNSPECIFIED BulkMuteFindingsRequest_MuteState = 0
	// Matching findings will be muted (default).
	BulkMuteFindingsRequest_MUTED BulkMuteFindingsRequest_MuteState = 1
	// Matching findings will have their mute state cleared.
	BulkMuteFindingsRequest_UNDEFINED BulkMuteFindingsRequest_MuteState = 2
)

// Enum value maps for BulkMuteFindingsRequest_MuteState.
var (
	BulkMuteFindingsRequest_MuteState_name = map[int32]string{
		0: "MUTE_STATE_UNSPECIFIED",
		1: "MUTED",
		2: "UNDEFINED",
	}
	BulkMuteFindingsRequest_MuteState_value = map[string]int32{
		"MUTE_STATE_UNSPECIFIED": 0,
		"MUTED":                  1,
		"UNDEFINED":              2,
	}
)

func (x BulkMuteFindingsRequest_MuteState) Enum() *BulkMuteFindingsRequest_MuteState {
	p := new(BulkMuteFindingsRequest_MuteState)
	*p = x
	return p
}

func (x BulkMuteFindingsRequest_MuteState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BulkMuteFindingsRequest_MuteState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[0].Descriptor()
}

func (BulkMuteFindingsRequest_MuteState) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[0]
}

func (x BulkMuteFindingsRequest_MuteState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BulkMuteFindingsRequest_MuteState.Descriptor instead.
func (BulkMuteFindingsRequest_MuteState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{0, 0}
}

// The change in state of the asset.
//
// When querying across two points in time this describes
// the change between the two points: ADDED, REMOVED, or ACTIVE.
// If there was no compare_duration supplied in the request the state change
// will be: UNUSED
type ListAssetsResponse_ListAssetsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListAssetsResponse_ListAssetsResult_UNUSED ListAssetsResponse_ListAssetsResult_StateChange = 0
	// Asset was added between the points in time.
	ListAssetsResponse_ListAssetsResult_ADDED ListAssetsResponse_ListAssetsResult_StateChange = 1
	// Asset was removed between the points in time.
	ListAssetsResponse_ListAssetsResult_REMOVED ListAssetsResponse_ListAssetsResult_StateChange = 2
	// Asset was present at both point(s) in time.
	ListAssetsResponse_ListAssetsResult_ACTIVE ListAssetsResponse_ListAssetsResult_StateChange = 3
)

// Enum value maps for ListAssetsResponse_ListAssetsResult_StateChange.
var (
	ListAssetsResponse_ListAssetsResult_StateChange_name = map[int32]string{
		0: "UNUSED",
		1: "ADDED",
		2: "REMOVED",
		3: "ACTIVE",
	}
	ListAssetsResponse_ListAssetsResult_StateChange_value = map[string]int32{
		"UNUSED":  0,
		"ADDED":   1,
		"REMOVED": 2,
		"ACTIVE":  3,
	}
)

func (x ListAssetsResponse_ListAssetsResult_StateChange) Enum() *ListAssetsResponse_ListAssetsResult_StateChange {
	p := new(ListAssetsResponse_ListAssetsResult_StateChange)
	*p = x
	return p
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListAssetsResponse_ListAssetsResult_StateChange) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[1].Descriptor()
}

func (ListAssetsResponse_ListAssetsResult_StateChange) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[1]
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListAssetsResponse_ListAssetsResult_StateChange.Descriptor instead.
func (ListAssetsResponse_ListAssetsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{49, 0, 0}
}

// The change in state of the finding.
//
// When querying across two points in time this describes
// the change in the finding between the two points: CHANGED, UNCHANGED,
// ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
// the finding at timestamp does not match the filter specified, but it did
// at timestamp - compare_duration. If there was no compare_duration
// supplied in the request the state change will be: UNUSED
type ListFindingsResponse_ListFindingsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListFindingsResponse_ListFindingsResult_UNUSED ListFindingsResponse_ListFindingsResult_StateChange = 0
	// The finding has changed state in some way between the points in time
	// and existed at both points.
	ListFindingsResponse_ListFindingsResult_CHANGED ListFindingsResponse_ListFindingsResult_StateChange = 1
	// The finding has not changed state between the points in time and
	// existed at both points.
	ListFindingsResponse_ListFindingsResult_UNCHANGED ListFindingsResponse_ListFindingsResult_StateChange = 2
	// The finding was created between the points in time.
	ListFindingsResponse_ListFindingsResult_ADDED ListFindingsResponse_ListFindingsResult_StateChange = 3
	// The finding at timestamp does not match the filter specified, but it
	// did at timestamp - compare_duration.
	ListFindingsResponse_ListFindingsResult_REMOVED ListFindingsResponse_ListFindingsResult_StateChange = 4
)

// Enum value maps for ListFindingsResponse_ListFindingsResult_StateChange.
var (
	ListFindingsResponse_ListFindingsResult_StateChange_name = map[int32]string{
		0: "UNUSED",
		1: "CHANGED",
		2: "UNCHANGED",
		3: "ADDED",
		4: "REMOVED",
	}
	ListFindingsResponse_ListFindingsResult_StateChange_value = map[string]int32{
		"UNUSED":    0,
		"CHANGED":   1,
		"UNCHANGED": 2,
		"ADDED":     3,
		"REMOVED":   4,
	}
)

func (x ListFindingsResponse_ListFindingsResult_StateChange) Enum() *ListFindingsResponse_ListFindingsResult_StateChange {
	p := new(ListFindingsResponse_ListFindingsResult_StateChange)
	*p = x
	return p
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListFindingsResponse_ListFindingsResult_StateChange) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[2].Descriptor()
}

func (ListFindingsResponse_ListFindingsResult_StateChange) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes[2]
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult_StateChange.Descriptor instead.
func (ListFindingsResponse_ListFindingsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{51, 0, 0}
}

// Request message for bulk findings update.
//
// Note:
// 1. If multiple bulk update requests match the same resource, the order in
// which they get executed is not defined.
// 2. Once a bulk operation is started, there is no way to stop it.
type BulkMuteFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, at which bulk action needs to be applied. Its format
	// is `organizations/[organization_id]`, `folders/[folder_id]`,
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that identifies findings that should be updated.
	// The expression is a list of zero or more restrictions combined
	// via logical operators `AND` and `OR`. Parentheses are supported, and `OR`
	// has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a
	// `-` character in front of them to indicate negation. The fields map to
	// those defined in the corresponding resource.
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// This can be a mute configuration name or any identifier for mute/unmute
	// of findings based on the filter.
	//
	// Deprecated: Marked as deprecated in google/cloud/securitycenter/v1/securitycenter_service.proto.
	MuteAnnotation string `protobuf:"bytes,3,opt,name=mute_annotation,json=muteAnnotation,proto3" json:"mute_annotation,omitempty"`
	// Optional. All findings matching the given filter will have their mute state
	// set to this value. The default value is `MUTED`. Setting this to
	// `UNDEFINED` will clear the mute state on all matching findings.
	MuteState BulkMuteFindingsRequest_MuteState `protobuf:"varint,4,opt,name=mute_state,json=muteState,proto3,enum=google.cloud.securitycenter.v1.BulkMuteFindingsRequest_MuteState" json:"mute_state,omitempty"`
}

func (x *BulkMuteFindingsRequest) Reset() {
	*x = BulkMuteFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsRequest) ProtoMessage() {}

func (x *BulkMuteFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsRequest.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{0}
}

func (x *BulkMuteFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BulkMuteFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/securitycenter/v1/securitycenter_service.proto.
func (x *BulkMuteFindingsRequest) GetMuteAnnotation() string {
	if x != nil {
		return x.MuteAnnotation
	}
	return ""
}

func (x *BulkMuteFindingsRequest) GetMuteState() BulkMuteFindingsRequest_MuteState {
	if x != nil {
		return x.MuteState
	}
	return BulkMuteFindingsRequest_MUTE_STATE_UNSPECIFIED
}

// The response to a BulkMute request. Contains the LRO information.
type BulkMuteFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BulkMuteFindingsResponse) Reset() {
	*x = BulkMuteFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkMuteFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkMuteFindingsResponse) ProtoMessage() {}

func (x *BulkMuteFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkMuteFindingsResponse.ProtoReflect.Descriptor instead.
func (*BulkMuteFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{1}
}

// Request message for creating a finding.
type CreateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new finding's parent. Its format should be
	// `organizations/[organization_id]/sources/[source_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must be alphanumeric and less than or equal to 32 characters and
	// greater than 0 characters in length.
	FindingId string `protobuf:"bytes,2,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
	// Required. The Finding being created. The name and security_marks will be
	// ignored as they are both output only fields on this resource.
	Finding *Finding `protobuf:"bytes,3,opt,name=finding,proto3" json:"finding,omitempty"`
}

func (x *CreateFindingRequest) Reset() {
	*x = CreateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFindingRequest) ProtoMessage() {}

func (x *CreateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFindingRequest.ProtoReflect.Descriptor instead.
func (*CreateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateFindingRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFindingRequest) GetFindingId() string {
	if x != nil {
		return x.FindingId
	}
	return ""
}

func (x *CreateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

// Request message for creating a mute config.
type CreateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new mute configs's parent. Its format is
	// `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The mute config being created.
	MuteConfig *MuteConfig `protobuf:"bytes,2,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must consist of only lowercase letters, numbers, and hyphens, must start
	// with a letter, must end with either a letter or a number, and must be 63
	// characters or less.
	MuteConfigId string `protobuf:"bytes,3,opt,name=mute_config_id,json=muteConfigId,proto3" json:"mute_config_id,omitempty"`
}

func (x *CreateMuteConfigRequest) Reset() {
	*x = CreateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMuteConfigRequest) ProtoMessage() {}

func (x *CreateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateMuteConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *CreateMuteConfigRequest) GetMuteConfigId() string {
	if x != nil {
		return x.MuteConfigId
	}
	return ""
}

// Request message to create single resource value config
type CreateResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new ResourceValueConfig's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource value config being created.
	ResourceValueConfig *ResourceValueConfig `protobuf:"bytes,2,opt,name=resource_value_config,json=resourceValueConfig,proto3" json:"resource_value_config,omitempty"`
}

func (x *CreateResourceValueConfigRequest) Reset() {
	*x = CreateResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateResourceValueConfigRequest) ProtoMessage() {}

func (x *CreateResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateResourceValueConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateResourceValueConfigRequest) GetResourceValueConfig() *ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfig
	}
	return nil
}

// Request message to create multiple resource value configs
type BatchCreateResourceValueConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new ResourceValueConfig's parent.
	// The parent field in the CreateResourceValueConfigRequest
	// messages must either be empty or match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource value configs to be created.
	Requests []*CreateResourceValueConfigRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateResourceValueConfigsRequest) Reset() {
	*x = BatchCreateResourceValueConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateResourceValueConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateResourceValueConfigsRequest) ProtoMessage() {}

func (x *BatchCreateResourceValueConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateResourceValueConfigsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateResourceValueConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchCreateResourceValueConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateResourceValueConfigsRequest) GetRequests() []*CreateResourceValueConfigRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for BatchCreateResourceValueConfigs
type BatchCreateResourceValueConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource value configs created
	ResourceValueConfigs []*ResourceValueConfig `protobuf:"bytes,1,rep,name=resource_value_configs,json=resourceValueConfigs,proto3" json:"resource_value_configs,omitempty"`
}

func (x *BatchCreateResourceValueConfigsResponse) Reset() {
	*x = BatchCreateResourceValueConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateResourceValueConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateResourceValueConfigsResponse) ProtoMessage() {}

func (x *BatchCreateResourceValueConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateResourceValueConfigsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateResourceValueConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchCreateResourceValueConfigsResponse) GetResourceValueConfigs() []*ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfigs
	}
	return nil
}

// Request message to delete resource value config
type DeleteResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ResourceValueConfig to delete
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteResourceValueConfigRequest) Reset() {
	*x = DeleteResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteResourceValueConfigRequest) ProtoMessage() {}

func (x *DeleteResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteResourceValueConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to get resource value config
type GetResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource value config to retrieve. Its format is
	// `organizations/{organization}/resourceValueConfigs/{config_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetResourceValueConfigRequest) Reset() {
	*x = GetResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceValueConfigRequest) ProtoMessage() {}

func (x *GetResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*GetResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetResourceValueConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to list resource value configs of a parent
type ListResourceValueConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of resource value configs.
	// Its format is
	// `organizations/[organization_id]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The number of results to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListResourceValueConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListResourceValueConfigs` must match the call that provided the
	// page token.
	//
	// page_size can be specified, and the new page_size will be used.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListResourceValueConfigsRequest) Reset() {
	*x = ListResourceValueConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourceValueConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceValueConfigsRequest) ProtoMessage() {}

func (x *ListResourceValueConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceValueConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListResourceValueConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListResourceValueConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListResourceValueConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListResourceValueConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message to list resource value configs
type ListResourceValueConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource value configs from the specified parent.
	ResourceValueConfigs []*ResourceValueConfig `protobuf:"bytes,1,rep,name=resource_value_configs,json=resourceValueConfigs,proto3" json:"resource_value_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListResourceValueConfigsResponse) Reset() {
	*x = ListResourceValueConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourceValueConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourceValueConfigsResponse) ProtoMessage() {}

func (x *ListResourceValueConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourceValueConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListResourceValueConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListResourceValueConfigsResponse) GetResourceValueConfigs() []*ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfigs
	}
	return nil
}

func (x *ListResourceValueConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message to update resource value config
type UpdateResourceValueConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource value config being updated.
	ResourceValueConfig *ResourceValueConfig `protobuf:"bytes,1,opt,name=resource_value_config,json=resourceValueConfig,proto3" json:"resource_value_config,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateResourceValueConfigRequest) Reset() {
	*x = UpdateResourceValueConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateResourceValueConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateResourceValueConfigRequest) ProtoMessage() {}

func (x *UpdateResourceValueConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateResourceValueConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateResourceValueConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateResourceValueConfigRequest) GetResourceValueConfig() *ResourceValueConfig {
	if x != nil {
		return x.ResourceValueConfig
	}
	return nil
}

func (x *UpdateResourceValueConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for creating a notification config.
type CreateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new notification config's parent. Its format
	// is `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	// Unique identifier provided by the client within the parent scope.
	// It must be between 1 and 128 characters and contain alphanumeric
	// characters, underscores, or hyphens only.
	ConfigId string `protobuf:"bytes,2,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// Required. The notification config being created. The name and the service
	// account will be ignored as they are both output only fields on this
	// resource.
	NotificationConfig *NotificationConfig `protobuf:"bytes,3,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
}

func (x *CreateNotificationConfigRequest) Reset() {
	*x = CreateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNotificationConfigRequest) ProtoMessage() {}

func (x *CreateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{12}
}

func (x *CreateNotificationConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *CreateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

// Request message for creating Security Health Analytics custom modules.
type CreateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new custom module's parent. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings`,
	// `folders/{folder}/securityHealthAnalyticsSettings`, or
	// `projects/{project}/securityHealthAnalyticsSettings`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. SecurityHealthAnalytics custom module to create. The provided
	// name is ignored and reset with provided parent information and
	// server-generated ID.
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `protobuf:"bytes,2,opt,name=security_health_analytics_custom_module,json=securityHealthAnalyticsCustomModule,proto3" json:"security_health_analytics_custom_module,omitempty"`
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = CreateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*CreateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{13}
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSecurityHealthAnalyticsCustomModuleRequest) GetSecurityHealthAnalyticsCustomModule() *SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModule
	}
	return nil
}

// Request message for creating a source.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the new source's parent. Its format should be
	// `organizations/[organization_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Source being created, only the display_name and description
	// will be used. All other fields will be ignored.
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{14}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

// Request message for deleting a mute config.
type DeleteMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to delete. Its format is
	// `organizations/{organization}/muteConfigs/{config_id}`,
	// `folders/{folder}/muteConfigs/{config_id}`,
	// `projects/{project}/muteConfigs/{config_id}`,
	// `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
	// `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
	// `projects/{project}/locations/global/muteConfigs/{config_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMuteConfigRequest) Reset() {
	*x = DeleteMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMuteConfigRequest) ProtoMessage() {}

func (x *DeleteMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting a notification config.
type DeleteNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to delete. Its format is
	// `organizations/[organization_id]/notificationConfigs/[config_id]`,
	// `folders/[folder_id]/notificationConfigs/[config_id]`,
	// or `projects/[project_id]/notificationConfigs/[config_id]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNotificationConfigRequest) Reset() {
	*x = DeleteNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNotificationConfigRequest) ProtoMessage() {}

func (x *DeleteNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting Security Health Analytics custom modules.
type DeleteSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the custom module to delete. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
	// `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
	// or
	// `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = DeleteSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for retrieving a BigQuery export.
type GetBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the BigQuery export to retrieve. Its format is
	// `organizations/{organization}/bigQueryExports/{export_id}`,
	// `folders/{folder}/bigQueryExports/{export_id}`, or
	// `projects/{project}/bigQueryExports/{export_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBigQueryExportRequest) Reset() {
	*x = GetBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBigQueryExportRequest) ProtoMessage() {}

func (x *GetBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*GetBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetBigQueryExportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for retrieving a mute config.
type GetMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the mute config to retrieve. Its format is
	// `organizations/{organization}/muteConfigs/{config_id}`,
	// `folders/{folder}/muteConfigs/{config_id}`,
	// `projects/{project}/muteConfigs/{config_id}`,
	// `organizations/{organization}/locations/global/muteConfigs/{config_id}`,
	// `folders/{folder}/locations/global/muteConfigs/{config_id}`, or
	// `projects/{project}/locations/global/muteConfigs/{config_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMuteConfigRequest) Reset() {
	*x = GetMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMuteConfigRequest) ProtoMessage() {}

func (x *GetMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*GetMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{19}
}

func (x *GetMuteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a notification config.
type GetNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the notification config to get. Its format is
	// `organizations/[organization_id]/notificationConfigs/[config_id]`,
	// `folders/[folder_id]/notificationConfigs/[config_id]`,
	// or `projects/[project_id]/notificationConfigs/[config_id]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNotificationConfigRequest) Reset() {
	*x = GetNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotificationConfigRequest) ProtoMessage() {}

func (x *GetNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*GetNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{20}
}

func (x *GetNotificationConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting organization settings.
type GetOrganizationSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to get organization settings for. Its
	// format is `organizations/[organization_id]/organizationSettings`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrganizationSettingsRequest) Reset() {
	*x = GetOrganizationSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationSettingsRequest) ProtoMessage() {}

func (x *GetOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrganizationSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{21}
}

func (x *GetOrganizationSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting effective Security Health Analytics custom
// modules.
type GetEffectiveSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the effective custom module to get. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
	// `folders/{folder}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`,
	// or
	// `projects/{project}/securityHealthAnalyticsSettings/effectiveCustomModules/{customModule}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = GetEffectiveSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEffectiveSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{22}
}

func (x *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting Security Health Analytics custom modules.
type GetSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the custom module to get. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings/customModules/{customModule}`,
	// `folders/{folder}/securityHealthAnalyticsSettings/customModules/{customModule}`,
	// or
	// `projects/{project}/securityHealthAnalyticsSettings/customModules/{customModule}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = GetSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{23}
}

func (x *GetSecurityHealthAnalyticsCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a source.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Relative resource name of the source. Its format is
	// `organizations/[organization_id]/source/[source_id]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for grouping by assets.
type GroupAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent to group the assets by. Its format is
	// `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `update_time = "2019-06-10T16:07:18-07:00"`
	//	  `update_time = 1560208038000`
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `create_time = "2019-06-10T16:07:18-07:00"`
	//	  `create_time = 1560208038000`
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	//
	// Use a partial match on the empty string to filter based on a property
	// existing: `resource_properties.my_property : ""`
	//
	// Use a negated partial match on the empty string to filter based on a
	// property not existing: `-resource_properties.my_property : ""`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping.
	// The string value should follow SQL syntax: comma separated list of fields.
	// For example:
	// "security_center_properties.resource_project,security_center_properties.project".
	//
	// The following fields are supported when compare_duration is not set:
	//
	// * security_center_properties.resource_project
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_type
	// * security_center_properties.resource_parent
	// * security_center_properties.resource_parent_display_name
	//
	// The following fields are supported when compare_duration is set:
	//
	// * security_center_properties.resource_type
	// * security_center_properties.resource_project_display_name
	// * security_center_properties.resource_parent_display_name
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" property is
	// updated to indicate whether the asset was added, removed, or remained
	// present during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	//   - "ADDED":   indicates that the asset was not present at the start of
	//     compare_duration, but present at reference_time.
	//   - "REMOVED": indicates that the asset was present at the start of
	//     compare_duration, but not present at reference_time.
	//   - "ACTIVE":  indicates that the asset was present at both the
	//     start and the end of the time period defined by
	//     compare_duration and reference_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all assets present at
	// read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// The value returned by the last `GroupAssetsResponse`; indicates
	// that this is a continuation of a prior `GroupAssets` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *GroupAssetsRequest) Reset() {
	*x = GroupAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupAssetsRequest) ProtoMessage() {}

func (x *GroupAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupAssetsRequest.ProtoReflect.Descriptor instead.
func (*GroupAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{25}
}

func (x *GroupAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GroupAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GroupAssetsRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *GroupAssetsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *GroupAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GroupAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for grouping by assets.
type GroupAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *GroupAssetsResponse) Reset() {
	*x = GroupAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupAssetsResponse) ProtoMessage() {}

func (x *GroupAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupAssetsResponse.ProtoReflect.Descriptor instead.
func (*GroupAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{26}
}

func (x *GroupAssetsResponse) GetGroupByResults() []*GroupResult {
	if x != nil {
		return x.GroupByResults
	}
	return nil
}

func (x *GroupAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *GroupAssetsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for grouping by findings.
type GroupFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source to groupBy. Its format is
	// `organizations/[organization_id]/sources/[source_id]`,
	// `folders/[folder_id]/sources/[source_id]`, or
	// `projects/[project_id]/sources/[source_id]`. To groupBy across all sources
	// provide a source_id of `-`. For example:
	// `organizations/{organization_id}/sources/-, folders/{folder_id}/sources/-`,
	// or `projects/{project_id}/sources/-`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//   - name
	//   - source_properties.a_property
	//   - security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `event_time = "2019-06-10T16:07:18-07:00"`
	//	  `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * workflow_state: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	//	For example, `source_properties.size = 100` is a valid filter string.
	//
	//	Use a partial match on the empty string to filter based on a property
	//	existing: `source_properties.my_property : ""`
	//
	//	Use a negated partial match on the empty string to filter based on a
	//	property not existing: `-source_properties.my_property : ""`
	//
	// * resource:
	//   - resource.name: `=`, `:`
	//   - resource.parent_name: `=`, `:`
	//   - resource.parent_display_name: `=`, `:`
	//   - resource.project_name: `=`, `:`
	//   - resource.project_display_name: `=`, `:`
	//   - resource.type: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Expression that defines what assets fields to use for grouping
	// (including `state_change`). The string value should follow SQL syntax:
	// comma separated list of fields. For example: "parent,resource_name".
	//
	// The following fields are supported when compare_duration is set:
	//
	// * state_change
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" attribute is
	// updated to indicate whether the finding had its state changed, the
	// finding's state remained unchanged, or if the finding was added during the
	// compare_duration period of time that precedes the read_time. This is the
	// time between (read_time - compare_duration) and read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	//   - "CHANGED":   indicates that the finding was present and matched the given
	//     filter at the start of compare_duration, but changed its
	//     state at read_time.
	//   - "UNCHANGED": indicates that the finding was present and matched the given
	//     filter at the start of compare_duration and did not change
	//     state at read_time.
	//   - "ADDED":     indicates that the finding did not match the given filter or
	//     was not present at the start of compare_duration, but was
	//     present at read_time.
	//   - "REMOVED":   indicates that the finding was present and matched the
	//     filter at the start of compare_duration, but did not match
	//     the filter at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all findings present
	// at read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// The value returned by the last `GroupFindingsResponse`; indicates
	// that this is a continuation of a prior `GroupFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *GroupFindingsRequest) Reset() {
	*x = GroupFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsRequest) ProtoMessage() {}

func (x *GroupFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsRequest.ProtoReflect.Descriptor instead.
func (*GroupFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{27}
}

func (x *GroupFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GroupFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *GroupFindingsRequest) GetGroupBy() string {
	if x != nil {
		return x.GroupBy
	}
	return ""
}

func (x *GroupFindingsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupFindingsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *GroupFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GroupFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for group by findings.
type GroupFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *GroupFindingsResponse) Reset() {
	*x = GroupFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupFindingsResponse) ProtoMessage() {}

func (x *GroupFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupFindingsResponse.ProtoReflect.Descriptor instead.
func (*GroupFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{28}
}

func (x *GroupFindingsResponse) GetGroupByResults() []*GroupResult {
	if x != nil {
		return x.GroupByResults
	}
	return nil
}

func (x *GroupFindingsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *GroupFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *GroupFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Result containing the properties and count of a groupBy request.
type GroupResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties matching the groupBy fields in the request.
	Properties map[string]*structpb.Value `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Total count of resources for the given properties.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *GroupResult) Reset() {
	*x = GroupResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupResult) ProtoMessage() {}

func (x *GroupResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupResult.ProtoReflect.Descriptor instead.
func (*GroupResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{29}
}

func (x *GroupResult) GetProperties() map[string]*structpb.Value {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *GroupResult) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Request message for listing descendant Security Health Analytics custom
// modules.
type ListDescendantSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list descendant custom modules. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings`,
	// `folders/{folder}/securityHealthAnalyticsSettings`, or
	// `projects/{project}/securityHealthAnalyticsSettings`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last call indicating a continuation
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListDescendantSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListDescendantSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{30}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing descendant Security Health Analytics custom
// modules.
type ListDescendantSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom modules belonging to the requested parent and its descendants.
	SecurityHealthAnalyticsCustomModules []*SecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=security_health_analytics_custom_modules,json=securityHealthAnalyticsCustomModules,proto3" json:"security_health_analytics_custom_modules,omitempty"`
	// If not empty, indicates that there may be more custom modules to be
	// returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListDescendantSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) GetSecurityHealthAnalyticsCustomModules() []*SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListDescendantSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing the valued resources for a given simulation.
type ListValuedResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list valued resources.
	//
	// Valid formats:
	// `organizations/{organization}`,
	// `organizations/{organization}/simulations/{simulation}`
	// `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression that filters the valued resources in the response.
	// Supported fields:
	//
	//   - `resource_value` supports =
	//   - `resource_type` supports =
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The value returned by the last `ListValuedResourcesResponse`; indicates
	// that this is a continuation of a prior `ListValuedResources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The fields by which to order the valued resources response.
	//
	// Supported fields:
	//
	//   - `exposed_score`
	//
	//   - `resource_value`
	//
	//   - `resource_type`
	//
	//   - `resource`
	//
	//   - `display_name`
	//
	// Values should be a comma separated list of fields. For example:
	// `exposed_score,resource_value`.
	//
	// The default sorting order is descending. To specify ascending or descending
	// order for a field, append a ` ASC` or a ` DESC` suffix, respectively; for
	// example: `exposed_score DESC`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListValuedResourcesRequest) Reset() {
	*x = ListValuedResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListValuedResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListValuedResourcesRequest) ProtoMessage() {}

func (x *ListValuedResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListValuedResourcesRequest.ProtoReflect.Descriptor instead.
func (*ListValuedResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListValuedResourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListValuedResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListValuedResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing the valued resources for a given simulation.
type ListValuedResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The valued resources that the attack path simulation identified.
	ValuedResources []*ValuedResource `protobuf:"bytes,1,rep,name=valued_resources,json=valuedResources,proto3" json:"valued_resources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The estimated total number of results matching the query.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListValuedResourcesResponse) Reset() {
	*x = ListValuedResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListValuedResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListValuedResourcesResponse) ProtoMessage() {}

func (x *ListValuedResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListValuedResourcesResponse.ProtoReflect.Descriptor instead.
func (*ListValuedResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{33}
}

func (x *ListValuedResourcesResponse) GetValuedResources() []*ValuedResource {
	if x != nil {
		return x.ValuedResources
	}
	return nil
}

func (x *ListValuedResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListValuedResourcesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing the attack paths for a given simulation or valued
// resource.
type ListAttackPathsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list attack paths.
	//
	// Valid formats:
	// `organizations/{organization}`,
	// `organizations/{organization}/simulations/{simulation}`
	// `organizations/{organization}/simulations/{simulation}/attackExposureResults/{attack_exposure_result_v2}`
	// `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression that filters the attack path in the response.
	// Supported fields:
	//
	//   - `valued_resources` supports =
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The value returned by the last `ListAttackPathsResponse`; indicates
	// that this is a continuation of a prior `ListAttackPaths` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListAttackPathsRequest) Reset() {
	*x = ListAttackPathsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttackPathsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttackPathsRequest) ProtoMessage() {}

func (x *ListAttackPathsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttackPathsRequest.ProtoReflect.Descriptor instead.
func (*ListAttackPathsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{34}
}

func (x *ListAttackPathsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAttackPathsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAttackPathsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAttackPathsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing the attack paths for a given simulation or
// valued resource.
type ListAttackPathsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The attack paths that the attack path simulation identified.
	AttackPaths []*AttackPath `protobuf:"bytes,1,rep,name=attack_paths,json=attackPaths,proto3" json:"attack_paths,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAttackPathsResponse) Reset() {
	*x = ListAttackPathsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttackPathsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttackPathsResponse) ProtoMessage() {}

func (x *ListAttackPathsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttackPathsResponse.ProtoReflect.Descriptor instead.
func (*ListAttackPathsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListAttackPathsResponse) GetAttackPaths() []*AttackPath {
	if x != nil {
		return x.AttackPaths
	}
	return nil
}

func (x *ListAttackPathsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for getting simulation.
// Simulation name can include "latest" to retrieve the latest simulation
// For example, "organizations/123/simulations/latest"
type GetSimulationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization name or simulation name of this simulation
	//
	// Valid format:
	// `organizations/{organization}/simulations/latest`
	// `organizations/{organization}/simulations/{simulation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSimulationRequest) Reset() {
	*x = GetSimulationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSimulationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSimulationRequest) ProtoMessage() {}

func (x *GetSimulationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSimulationRequest.ProtoReflect.Descriptor instead.
func (*GetSimulationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{36}
}

func (x *GetSimulationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting a valued resource.
type GetValuedResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of this valued resource
	//
	// Valid format:
	// `organizations/{organization}/simulations/{simulation}/valuedResources/{valued_resource}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetValuedResourceRequest) Reset() {
	*x = GetValuedResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetValuedResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetValuedResourceRequest) ProtoMessage() {}

func (x *GetValuedResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetValuedResourceRequest.ProtoReflect.Descriptor instead.
func (*GetValuedResourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{37}
}

func (x *GetValuedResourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing  mute configs at a given scope e.g. organization,
// folder or project.
type ListMuteConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of mute configs. Its format
	// is `organizations/[organization_id]`, `folders/[folder_id]`,
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMuteConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMuteConfigs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMuteConfigsRequest) Reset() {
	*x = ListMuteConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsRequest) ProtoMessage() {}

func (x *ListMuteConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{38}
}

func (x *ListMuteConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMuteConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMuteConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing mute configs.
type ListMuteConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mute configs from the specified parent.
	MuteConfigs []*MuteConfig `protobuf:"bytes,1,rep,name=mute_configs,json=muteConfigs,proto3" json:"mute_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMuteConfigsResponse) Reset() {
	*x = ListMuteConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMuteConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMuteConfigsResponse) ProtoMessage() {}

func (x *ListMuteConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMuteConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListMuteConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{39}
}

func (x *ListMuteConfigsResponse) GetMuteConfigs() []*MuteConfig {
	if x != nil {
		return x.MuteConfigs
	}
	return nil
}

func (x *ListMuteConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing notification configs.
type ListNotificationConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent in which to list the notification
	// configurations. Its format is "organizations/[organization_id]",
	// "folders/[folder_id]", or "projects/[project_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListNotificationConfigsResponse`; indicates
	// that this is a continuation of a prior `ListNotificationConfigs` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListNotificationConfigsRequest) Reset() {
	*x = ListNotificationConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsRequest) ProtoMessage() {}

func (x *ListNotificationConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{40}
}

func (x *ListNotificationConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNotificationConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing notification configs.
type ListNotificationConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notification configs belonging to the requested parent.
	NotificationConfigs []*NotificationConfig `protobuf:"bytes,1,rep,name=notification_configs,json=notificationConfigs,proto3" json:"notification_configs,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNotificationConfigsResponse) Reset() {
	*x = ListNotificationConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationConfigsResponse) ProtoMessage() {}

func (x *ListNotificationConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{41}
}

func (x *ListNotificationConfigsResponse) GetNotificationConfigs() []*NotificationConfig {
	if x != nil {
		return x.NotificationConfigs
	}
	return nil
}

func (x *ListNotificationConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing effective Security Health Analytics custom
// modules.
type ListEffectiveSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list effective custom modules. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings`,
	// `folders/{folder}/securityHealthAnalyticsSettings`, or
	// `projects/{project}/securityHealthAnalyticsSettings`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last call indicating a continuation
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListEffectiveSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{42}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing effective Security Health Analytics custom
// modules.
type ListEffectiveSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Effective custom modules belonging to the requested parent.
	EffectiveSecurityHealthAnalyticsCustomModules []*EffectiveSecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=effective_security_health_analytics_custom_modules,json=effectiveSecurityHealthAnalyticsCustomModules,proto3" json:"effective_security_health_analytics_custom_modules,omitempty"`
	// If not empty, indicates that there may be more effective custom modules to
	// be returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListEffectiveSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{43}
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) GetEffectiveSecurityHealthAnalyticsCustomModules() []*EffectiveSecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.EffectiveSecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListEffectiveSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing Security Health Analytics custom modules.
type ListSecurityHealthAnalyticsCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of parent to list custom modules. Its format is
	// `organizations/{organization}/securityHealthAnalyticsSettings`,
	// `folders/{folder}/securityHealthAnalyticsSettings`, or
	// `projects/{project}/securityHealthAnalyticsSettings`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last call indicating a continuation
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) Reset() {
	*x = ListSecurityHealthAnalyticsCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecurityHealthAnalyticsCustomModulesRequest) ProtoMessage() {}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecurityHealthAnalyticsCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListSecurityHealthAnalyticsCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{44}
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSecurityHealthAnalyticsCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing Security Health Analytics custom modules.
type ListSecurityHealthAnalyticsCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom modules belonging to the requested parent.
	SecurityHealthAnalyticsCustomModules []*SecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,rep,name=security_health_analytics_custom_modules,json=securityHealthAnalyticsCustomModules,proto3" json:"security_health_analytics_custom_modules,omitempty"`
	// If not empty, indicates that there may be more custom modules to be
	// returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) Reset() {
	*x = ListSecurityHealthAnalyticsCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSecurityHealthAnalyticsCustomModulesResponse) ProtoMessage() {}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSecurityHealthAnalyticsCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListSecurityHealthAnalyticsCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{45}
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) GetSecurityHealthAnalyticsCustomModules() []*SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModules
	}
	return nil
}

func (x *ListSecurityHealthAnalyticsCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing sources.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent of sources to list. Its format should
	// be `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListSourcesResponse`; indicates
	// that this is a continuation of a prior `ListSources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{46}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing sources.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources belonging to the requested parent.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{47}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for listing assets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent resource that contains the assets. The
	// value that you can specify on parent depends on the method in which you
	// specify parent. You can specify one of the following values:
	// `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following are the allowed field and operator combinations:
	//
	// * name: `=`
	// * update_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `update_time = "2019-06-10T16:07:18-07:00"`
	//	  `update_time = 1560208038000`
	//
	// * create_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `create_time = "2019-06-10T16:07:18-07:00"`
	//	  `create_time = 1560208038000`
	//
	// * iam_policy.policy_blob: `=`, `:`
	// * resource_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	// * security_marks.marks: `=`, `:`
	// * security_center_properties.resource_name: `=`, `:`
	// * security_center_properties.resource_display_name: `=`, `:`
	// * security_center_properties.resource_type: `=`, `:`
	// * security_center_properties.resource_parent: `=`, `:`
	// * security_center_properties.resource_parent_display_name: `=`, `:`
	// * security_center_properties.resource_project: `=`, `:`
	// * security_center_properties.resource_project_display_name: `=`, `:`
	// * security_center_properties.resource_owners: `=`, `:`
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	//
	// Use a partial match on the empty string to filter based on a property
	// existing: `resource_properties.my_property : ""`
	//
	// Use a negated partial match on the empty string to filter based on a
	// property not existing: `-resource_properties.my_property : ""`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,resource_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,resource_properties.a_property" and "
	// name     desc  ,   resource_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// update_time
	// resource_properties
	// security_marks.marks
	// security_center_properties.resource_name
	// security_center_properties.resource_display_name
	// security_center_properties.resource_parent
	// security_center_properties.resource_parent_display_name
	// security_center_properties.resource_project
	// security_center_properties.resource_project_display_name
	// security_center_properties.resource_type
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListAssetsResult's "state_change"
	// attribute is updated to indicate whether the asset was added, removed, or
	// remained present during the compare_duration period of time that precedes
	// the read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	//   - "ADDED":   indicates that the asset was not present at the start of
	//     compare_duration, but present at read_time.
	//   - "REMOVED": indicates that the asset was present at the start of
	//     compare_duration, but not present at read_time.
	//   - "ACTIVE":  indicates that the asset was present at both the
	//     start and the end of the time period defined by
	//     compare_duration and read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all assets present at
	// read_time.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// A field mask to specify the ListAssetsResult fields to be listed in the
	// response.
	// An empty field mask will list all fields.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListAssetsResponse`; indicates
	// that this is a continuation of a prior `ListAssets` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{48}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAssetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *ListAssetsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing assets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Assets matching the list request.
	ListAssetsResults []*ListAssetsResponse_ListAssetsResult `protobuf:"bytes,1,rep,name=list_assets_results,json=listAssetsResults,proto3" json:"list_assets_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of assets matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{49}
}

func (x *ListAssetsResponse) GetListAssetsResults() []*ListAssetsResponse_ListAssetsResult {
	if x != nil {
		return x.ListAssetsResults
	}
	return nil
}

func (x *ListAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAssetsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for listing findings.
type ListFindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the source the findings belong to. Its format is
	// `organizations/[organization_id]/sources/[source_id]`,
	// `folders/[folder_id]/sources/[source_id]`, or
	// `projects/[project_id]/sources/[source_id]`. To list across all sources
	// provide a source_id of `-`. For example:
	// `organizations/{organization_id}/sources/-`,
	// `folders/{folder_id}/sources/-` or `projects/{projects_id}/sources/-`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//   - name
	//   - source_properties.a_property
	//   - security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	//
	// * name: `=`
	// * parent: `=`, `:`
	// * resource_name: `=`, `:`
	// * state: `=`, `:`
	// * category: `=`, `:`
	// * external_uri: `=`, `:`
	// * event_time: `=`, `>`, `<`, `>=`, `<=`
	//
	//	Usage: This should be milliseconds since epoch or an RFC3339 string.
	//	Examples:
	//	  `event_time = "2019-06-10T16:07:18-07:00"`
	//	  `event_time = 1560208038000`
	//
	// * severity: `=`, `:`
	// * workflow_state: `=`, `:`
	// * security_marks.marks: `=`, `:`
	// * source_properties: `=`, `:`, `>`, `<`, `>=`, `<=`
	//
	//	For example, `source_properties.size = 100` is a valid filter string.
	//
	//	Use a partial match on the empty string to filter based on a property
	//	existing: `source_properties.my_property : ""`
	//
	//	Use a negated partial match on the empty string to filter based on a
	//	property not existing: `-source_properties.my_property : ""`
	//
	// * resource:
	//   - resource.name: `=`, `:`
	//   - resource.parent_name: `=`, `:`
	//   - resource.parent_display_name: `=`, `:`
	//   - resource.project_name: `=`, `:`
	//   - resource.project_display_name: `=`, `:`
	//   - resource.type: `=`, `:`
	//   - resource.folders.resource_folder: `=`, `:`
	//   - resource.display_name: `=`, `:`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,source_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,source_properties.a_property" and "
	// name     desc  ,   source_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// parent
	// state
	// category
	// resource_name
	// event_time
	// source_properties
	// security_marks.marks
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListFindingsResult's "state_change"
	// attribute is updated to indicate whether the finding had its state changed,
	// the finding's state remained unchanged, or if the finding was added in any
	// state during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	//   - "CHANGED":   indicates that the finding was present and matched the given
	//     filter at the start of compare_duration, but changed its
	//     state at read_time.
	//   - "UNCHANGED": indicates that the finding was present and matched the given
	//     filter at the start of compare_duration and did not change
	//     state at read_time.
	//   - "ADDED":     indicates that the finding did not match the given filter or
	//     was not present at the start of compare_duration, but was
	//     present at read_time.
	//   - "REMOVED":   indicates that the finding was present and matched the
	//     filter at the start of compare_duration, but did not match
	//     the filter at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all findings present at
	// read_time.
	CompareDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// A field mask to specify the Finding fields to be listed in the response.
	// An empty field mask will list all fields.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListFindingsResponse`; indicates
	// that this is a continuation of a prior `ListFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize int32 `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListFindingsRequest) Reset() {
	*x = ListFindingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsRequest) ProtoMessage() {}

func (x *ListFindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsRequest.ProtoReflect.Descriptor instead.
func (*ListFindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{50}
}

func (x *ListFindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFindingsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListFindingsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListFindingsRequest) GetCompareDuration() *durationpb.Duration {
	if x != nil {
		return x.CompareDuration
	}
	return nil
}

func (x *ListFindingsRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ListFindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for listing findings.
type ListFindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Findings matching the list request.
	ListFindingsResults []*ListFindingsResponse_ListFindingsResult `protobuf:"bytes,1,rep,name=list_findings_results,json=listFindingsResults,proto3" json:"list_findings_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of findings matching the query.
	TotalSize int32 `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListFindingsResponse) Reset() {
	*x = ListFindingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse) ProtoMessage() {}

func (x *ListFindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{51}
}

func (x *ListFindingsResponse) GetListFindingsResults() []*ListFindingsResponse_ListFindingsResult {
	if x != nil {
		return x.ListFindingsResults
	}
	return nil
}

func (x *ListFindingsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListFindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFindingsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for updating a finding's state.
type SetFindingStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. Example:
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
	// `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
	// `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired State of the finding.
	State Finding_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.v1.Finding_State" json:"state,omitempty"`
	// Required. The time at which the updated state takes effect.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *SetFindingStateRequest) Reset() {
	*x = SetFindingStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetFindingStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetFindingStateRequest) ProtoMessage() {}

func (x *SetFindingStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetFindingStateRequest.ProtoReflect.Descriptor instead.
func (*SetFindingStateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{52}
}

func (x *SetFindingStateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetFindingStateRequest) GetState() Finding_State {
	if x != nil {
		return x.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (x *SetFindingStateRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Request message for updating a finding's mute status.
type SetMuteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [relative resource
	// name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// of the finding. Example:
	// `organizations/{organization_id}/sources/{source_id}/findings/{finding_id}`,
	// `folders/{folder_id}/sources/{source_id}/findings/{finding_id}`,
	// `projects/{project_id}/sources/{source_id}/findings/{finding_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired state of the Mute.
	Mute Finding_Mute `protobuf:"varint,2,opt,name=mute,proto3,enum=google.cloud.securitycenter.v1.Finding_Mute" json:"mute,omitempty"`
}

func (x *SetMuteRequest) Reset() {
	*x = SetMuteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMuteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMuteRequest) ProtoMessage() {}

func (x *SetMuteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMuteRequest.ProtoReflect.Descriptor instead.
func (*SetMuteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{53}
}

func (x *SetMuteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetMuteRequest) GetMute() Finding_Mute {
	if x != nil {
		return x.Mute
	}
	return Finding_MUTE_UNSPECIFIED
}

// Request message for running asset discovery for an organization.
type RunAssetDiscoveryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization to run asset discovery for. Its format
	// is `organizations/[organization_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *RunAssetDiscoveryRequest) Reset() {
	*x = RunAssetDiscoveryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunAssetDiscoveryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunAssetDiscoveryRequest) ProtoMessage() {}

func (x *RunAssetDiscoveryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunAssetDiscoveryRequest.ProtoReflect.Descriptor instead.
func (*RunAssetDiscoveryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{54}
}

func (x *RunAssetDiscoveryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message to simulate a CustomConfig against a given test resource.
// Maximum size of the request is 4 MB by default.
type SimulateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative resource name of the organization, project, or
	// folder. For more information about relative resource names, see [Relative
	// Resource
	// Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
	// Example: `organizations/{organization_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The custom configuration that you need to test.
	CustomConfig *CustomConfig `protobuf:"bytes,2,opt,name=custom_config,json=customConfig,proto3" json:"custom_config,omitempty"`
	// Required. Resource data to simulate custom module against.
	Resource *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{55}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetCustomConfig() *CustomConfig {
	if x != nil {
		return x.CustomConfig
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest) GetResource() *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Response message for simulating a `SecurityHealthAnalyticsCustomModule`
// against a given resource.
type SimulateSecurityHealthAnalyticsCustomModuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Result for test case in the corresponding request.
	Result *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleResponse.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{56}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse) GetResult() *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// Request message for updating a ExternalSystem resource.
type UpdateExternalSystemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The external system resource to update.
	ExternalSystem *ExternalSystem `protobuf:"bytes,1,opt,name=external_system,json=externalSystem,proto3" json:"external_system,omitempty"`
	// The FieldMask to use when updating the external system resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExternalSystemRequest) Reset() {
	*x = UpdateExternalSystemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateExternalSystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExternalSystemRequest) ProtoMessage() {}

func (x *UpdateExternalSystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExternalSystemRequest.ProtoReflect.Descriptor instead.
func (*UpdateExternalSystemRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{57}
}

func (x *UpdateExternalSystemRequest) GetExternalSystem() *ExternalSystem {
	if x != nil {
		return x.ExternalSystem
	}
	return nil
}

func (x *UpdateExternalSystemRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating or creating a finding.
type UpdateFindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The finding resource to update or create if it does not already
	// exist. parent, security_marks, and update_time will be ignored.
	//
	// In the case of creation, the finding id portion of the name must be
	// alphanumeric and less than or equal to 32 characters and greater than 0
	// characters in length.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// The FieldMask to use when updating the finding resource. This field should
	// not be specified when creating a finding.
	//
	// When updating a finding, an empty mask is treated as updating all mutable
	// fields and replacing source_properties.  Individual source_properties can
	// be added/updated by using "source_properties.<property key>" in the field
	// mask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFindingRequest) Reset() {
	*x = UpdateFindingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFindingRequest) ProtoMessage() {}

func (x *UpdateFindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFindingRequest.ProtoReflect.Descriptor instead.
func (*UpdateFindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{58}
}

func (x *UpdateFindingRequest) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *UpdateFindingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a mute config.
type UpdateMuteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The mute config being updated.
	MuteConfig *MuteConfig `protobuf:"bytes,1,opt,name=mute_config,json=muteConfig,proto3" json:"mute_config,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMuteConfigRequest) Reset() {
	*x = UpdateMuteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMuteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMuteConfigRequest) ProtoMessage() {}

func (x *UpdateMuteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMuteConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateMuteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{59}
}

func (x *UpdateMuteConfigRequest) GetMuteConfig() *MuteConfig {
	if x != nil {
		return x.MuteConfig
	}
	return nil
}

func (x *UpdateMuteConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a notification config.
type UpdateNotificationConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The notification config to update.
	NotificationConfig *NotificationConfig `protobuf:"bytes,1,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// The FieldMask to use when updating the notification config.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateNotificationConfigRequest) Reset() {
	*x = UpdateNotificationConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNotificationConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNotificationConfigRequest) ProtoMessage() {}

func (x *UpdateNotificationConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNotificationConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateNotificationConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{60}
}

func (x *UpdateNotificationConfigRequest) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *UpdateNotificationConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating an organization's settings.
type UpdateOrganizationSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization settings resource to update.
	OrganizationSettings *OrganizationSettings `protobuf:"bytes,1,opt,name=organization_settings,json=organizationSettings,proto3" json:"organization_settings,omitempty"`
	// The FieldMask to use when updating the settings resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateOrganizationSettingsRequest) Reset() {
	*x = UpdateOrganizationSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationSettingsRequest) ProtoMessage() {}

func (x *UpdateOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{61}
}

func (x *UpdateOrganizationSettingsRequest) GetOrganizationSettings() *OrganizationSettings {
	if x != nil {
		return x.OrganizationSettings
	}
	return nil
}

func (x *UpdateOrganizationSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating Security Health Analytics custom modules.
type UpdateSecurityHealthAnalyticsCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SecurityHealthAnalytics custom module to update.
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `protobuf:"bytes,1,opt,name=security_health_analytics_custom_module,json=securityHealthAnalyticsCustomModule,proto3" json:"security_health_analytics_custom_module,omitempty"`
	// The list of fields to be updated. The only fields that can be updated are
	// `enablement_state` and `custom_config`. If empty or set to the wildcard
	// value `*`, both `enablement_state` and `custom_config` are updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) Reset() {
	*x = UpdateSecurityHealthAnalyticsCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecurityHealthAnalyticsCustomModuleRequest) ProtoMessage() {}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecurityHealthAnalyticsCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecurityHealthAnalyticsCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{62}
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) GetSecurityHealthAnalyticsCustomModule() *SecurityHealthAnalyticsCustomModule {
	if x != nil {
		return x.SecurityHealthAnalyticsCustomModule
	}
	return nil
}

func (x *UpdateSecurityHealthAnalyticsCustomModuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a source.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source resource to update.
	Source *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The FieldMask to use when updating the source resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{63}
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for updating a SecurityMarks resource.
type UpdateSecurityMarksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The security marks resource to update.
	SecurityMarks *SecurityMarks `protobuf:"bytes,1,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The FieldMask to use when updating the security marks resource.
	//
	// The field mask must not contain duplicate fields.
	// If empty or set to "marks", all marks will be replaced.  Individual
	// marks can be updated using "marks.<mark_key>".
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The time at which the updated SecurityMarks take effect.
	// If not set uses current server time.  Updates will be applied to the
	// SecurityMarks that are active immediately preceding this time. Must be
	// earlier or equal to the server time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *UpdateSecurityMarksRequest) Reset() {
	*x = UpdateSecurityMarksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSecurityMarksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSecurityMarksRequest) ProtoMessage() {}

func (x *UpdateSecurityMarksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSecurityMarksRequest.ProtoReflect.Descriptor instead.
func (*UpdateSecurityMarksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{64}
}

func (x *UpdateSecurityMarksRequest) GetSecurityMarks() *SecurityMarks {
	if x != nil {
		return x.SecurityMarks
	}
	return nil
}

func (x *UpdateSecurityMarksRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSecurityMarksRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Request message for creating a BigQuery export.
type CreateBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent resource of the new BigQuery export. Its
	// format is `organizations/[organization_id]`, `folders/[folder_id]`, or
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The BigQuery export being created.
	BigQueryExport *BigQueryExport `protobuf:"bytes,2,opt,name=big_query_export,json=bigQueryExport,proto3" json:"big_query_export,omitempty"`
	// Required. Unique identifier provided by the client within the parent scope.
	// It must consist of only lowercase letters, numbers, and hyphens, must start
	// with a letter, must end with either a letter or a number, and must be 63
	// characters or less.
	BigQueryExportId string `protobuf:"bytes,3,opt,name=big_query_export_id,json=bigQueryExportId,proto3" json:"big_query_export_id,omitempty"`
}

func (x *CreateBigQueryExportRequest) Reset() {
	*x = CreateBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBigQueryExportRequest) ProtoMessage() {}

func (x *CreateBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*CreateBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{65}
}

func (x *CreateBigQueryExportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBigQueryExportRequest) GetBigQueryExport() *BigQueryExport {
	if x != nil {
		return x.BigQueryExport
	}
	return nil
}

func (x *CreateBigQueryExportRequest) GetBigQueryExportId() string {
	if x != nil {
		return x.BigQueryExportId
	}
	return ""
}

// Request message for updating a BigQuery export.
type UpdateBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery export being updated.
	BigQueryExport *BigQueryExport `protobuf:"bytes,1,opt,name=big_query_export,json=bigQueryExport,proto3" json:"big_query_export,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBigQueryExportRequest) Reset() {
	*x = UpdateBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBigQueryExportRequest) ProtoMessage() {}

func (x *UpdateBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*UpdateBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{66}
}

func (x *UpdateBigQueryExportRequest) GetBigQueryExport() *BigQueryExport {
	if x != nil {
		return x.BigQueryExport
	}
	return nil
}

func (x *UpdateBigQueryExportRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for listing BigQuery exports at a given scope e.g.
// organization, folder or project.
type ListBigQueryExportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns the collection of BigQuery exports. Its
	// format is `organizations/[organization_id]`, `folders/[folder_id]`,
	// `projects/[project_id]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of configs to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListBigQueryExports` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListBigQueryExports`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBigQueryExportsRequest) Reset() {
	*x = ListBigQueryExportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryExportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryExportsRequest) ProtoMessage() {}

func (x *ListBigQueryExportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryExportsRequest.ProtoReflect.Descriptor instead.
func (*ListBigQueryExportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{67}
}

func (x *ListBigQueryExportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBigQueryExportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBigQueryExportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing BigQuery exports.
type ListBigQueryExportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BigQuery exports from the specified parent.
	BigQueryExports []*BigQueryExport `protobuf:"bytes,1,rep,name=big_query_exports,json=bigQueryExports,proto3" json:"big_query_exports,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBigQueryExportsResponse) Reset() {
	*x = ListBigQueryExportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBigQueryExportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBigQueryExportsResponse) ProtoMessage() {}

func (x *ListBigQueryExportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBigQueryExportsResponse.ProtoReflect.Descriptor instead.
func (*ListBigQueryExportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{68}
}

func (x *ListBigQueryExportsResponse) GetBigQueryExports() []*BigQueryExport {
	if x != nil {
		return x.BigQueryExports
	}
	return nil
}

func (x *ListBigQueryExportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for deleting a BigQuery export.
type DeleteBigQueryExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the BigQuery export to delete. Its format is
	// `organizations/{organization}/bigQueryExports/{export_id}`,
	// `folders/{folder}/bigQueryExports/{export_id}`, or
	// `projects/{project}/bigQueryExports/{export_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBigQueryExportRequest) Reset() {
	*x = DeleteBigQueryExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBigQueryExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBigQueryExportRequest) ProtoMessage() {}

func (x *DeleteBigQueryExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBigQueryExportRequest.ProtoReflect.Descriptor instead.
func (*DeleteBigQueryExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{69}
}

func (x *DeleteBigQueryExportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create an Event Threat Detection custom module.
type CreateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new custom module's parent.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings`.
	//   - `folders/{folder}/eventThreatDetectionSettings`.
	//   - `projects/{project}/eventThreatDetectionSettings`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The module to create. The
	// event_threat_detection_custom_module.name will be ignored and server
	// generated.
	EventThreatDetectionCustomModule *EventThreatDetectionCustomModule `protobuf:"bytes,2,opt,name=event_threat_detection_custom_module,json=eventThreatDetectionCustomModule,proto3" json:"event_threat_detection_custom_module,omitempty"`
}

func (x *CreateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = CreateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *CreateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*CreateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{70}
}

func (x *CreateEventThreatDetectionCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEventThreatDetectionCustomModuleRequest) GetEventThreatDetectionCustomModule() *EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModule
	}
	return nil
}

// Request to validate an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the parent to validate the Custom Module under.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings`.
	//   - `folders/{folder}/eventThreatDetectionSettings`.
	//   - `projects/{project}/eventThreatDetectionSettings`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The raw text of the module's contents. Used to generate error
	// messages.
	RawText string `protobuf:"bytes,2,opt,name=raw_text,json=rawText,proto3" json:"raw_text,omitempty"`
	// Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{71}
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetRawText() string {
	if x != nil {
		return x.RawText
	}
	return ""
}

func (x *ValidateEventThreatDetectionCustomModuleRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Response to validating an Event Threat Detection custom module.
type ValidateEventThreatDetectionCustomModuleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of errors returned by the validator. If the list is empty, there
	// were no errors.
	Errors *CustomModuleValidationErrors `protobuf:"bytes,2,opt,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) Reset() {
	*x = ValidateEventThreatDetectionCustomModuleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEventThreatDetectionCustomModuleResponse) ProtoMessage() {}

func (x *ValidateEventThreatDetectionCustomModuleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEventThreatDetectionCustomModuleResponse.ProtoReflect.Descriptor instead.
func (*ValidateEventThreatDetectionCustomModuleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{72}
}

func (x *ValidateEventThreatDetectionCustomModuleResponse) GetErrors() *CustomModuleValidationErrors {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Request to delete an Event Threat Detection custom module.
type DeleteEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the custom module to delete.
	//
	// Its format is:
	//
	// * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
	// * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
	// * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) Reset() {
	*x = DeleteEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *DeleteEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*DeleteEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{73}
}

func (x *DeleteEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get an Event Threat Detection custom module.
type GetEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the custom module to get.
	//
	// Its format is:
	//
	// * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
	// * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
	// * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEventThreatDetectionCustomModuleRequest) Reset() {
	*x = GetEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *GetEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{74}
}

func (x *GetEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list current and descendant resident Event Threat Detection custom
// modules.
type ListDescendantEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent to list custom modules under.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings`.
	//   - `folders/{folder}/eventThreatDetectionSettings`.
	//   - `projects/{project}/eventThreatDetectionSettings`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A page token, received from a previous
	// `ListDescendantEventThreatDetectionCustomModules` call. Provide this to
	// retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDescendantEventThreatDetectionCustomModules` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of modules to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListDescendantEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListDescendantEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{75}
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDescendantEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response for listing current and descendant resident
// Event Threat Detection custom modules.
type ListDescendantEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom modules belonging to the requested parent.
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=event_threat_detection_custom_modules,json=eventThreatDetectionCustomModules,proto3" json:"event_threat_detection_custom_modules,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListDescendantEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDescendantEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDescendantEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListDescendantEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{76}
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) GetEventThreatDetectionCustomModules() []*EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListDescendantEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to list Event Threat Detection custom modules.
type ListEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent to list custom modules under.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings`.
	//   - `folders/{folder}/eventThreatDetectionSettings`.
	//   - `projects/{project}/eventThreatDetectionSettings`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A page token, received from a previous
	// `ListEventThreatDetectionCustomModules` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListEventThreatDetectionCustomModules` must match the call that provided
	// the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of modules to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{77}
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response for listing Event Threat Detection custom modules.
type ListEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom modules belonging to the requested parent.
	EventThreatDetectionCustomModules []*EventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=event_threat_detection_custom_modules,json=eventThreatDetectionCustomModules,proto3" json:"event_threat_detection_custom_modules,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{78}
}

func (x *ListEventThreatDetectionCustomModulesResponse) GetEventThreatDetectionCustomModules() []*EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to update an Event Threat Detection custom module.
type UpdateEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The module being updated.
	EventThreatDetectionCustomModule *EventThreatDetectionCustomModule `protobuf:"bytes,1,opt,name=event_threat_detection_custom_module,json=eventThreatDetectionCustomModule,proto3" json:"event_threat_detection_custom_module,omitempty"`
	// The list of fields to be updated.
	// If empty all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) Reset() {
	*x = UpdateEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *UpdateEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*UpdateEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{79}
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) GetEventThreatDetectionCustomModule() *EventThreatDetectionCustomModule {
	if x != nil {
		return x.EventThreatDetectionCustomModule
	}
	return nil
}

func (x *UpdateEventThreatDetectionCustomModuleRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to get an EffectiveEventThreatDetectionCustomModule.
type GetEffectiveEventThreatDetectionCustomModuleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the effective Event Threat Detection custom
	// module.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
	//   - `folders/{folder}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
	//   - `projects/{project}/eventThreatDetectionSettings/effectiveCustomModules/{module}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) Reset() {
	*x = GetEffectiveEventThreatDetectionCustomModuleRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEffectiveEventThreatDetectionCustomModuleRequest) ProtoMessage() {}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEffectiveEventThreatDetectionCustomModuleRequest.ProtoReflect.Descriptor instead.
func (*GetEffectiveEventThreatDetectionCustomModuleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{80}
}

func (x *GetEffectiveEventThreatDetectionCustomModuleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list effective Event Threat Detection custom modules.
type ListEffectiveEventThreatDetectionCustomModulesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent to list custom modules for.
	//
	// Its format is:
	//
	//   - `organizations/{organization}/eventThreatDetectionSettings`.
	//   - `folders/{folder}/eventThreatDetectionSettings`.
	//   - `projects/{project}/eventThreatDetectionSettings`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A page token, received from a previous
	// `ListEffectiveEventThreatDetectionCustomModules` call. Provide this to
	// retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListEffectiveEventThreatDetectionCustomModules` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of modules to return. The service may return fewer than
	// this value.
	// If unspecified, at most 10 configs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) Reset() {
	*x = ListEffectiveEventThreatDetectionCustomModulesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveEventThreatDetectionCustomModulesRequest) ProtoMessage() {}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveEventThreatDetectionCustomModulesRequest.ProtoReflect.Descriptor instead.
func (*ListEffectiveEventThreatDetectionCustomModulesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{81}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEffectiveEventThreatDetectionCustomModulesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response for listing EffectiveEventThreatDetectionCustomModules.
type ListEffectiveEventThreatDetectionCustomModulesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Effective custom modules belonging to the requested parent.
	EffectiveEventThreatDetectionCustomModules []*EffectiveEventThreatDetectionCustomModule `protobuf:"bytes,1,rep,name=effective_event_threat_detection_custom_modules,json=effectiveEventThreatDetectionCustomModules,proto3" json:"effective_event_threat_detection_custom_modules,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) Reset() {
	*x = ListEffectiveEventThreatDetectionCustomModulesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEffectiveEventThreatDetectionCustomModulesResponse) ProtoMessage() {}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEffectiveEventThreatDetectionCustomModulesResponse.ProtoReflect.Descriptor instead.
func (*ListEffectiveEventThreatDetectionCustomModulesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{82}
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) GetEffectiveEventThreatDetectionCustomModules() []*EffectiveEventThreatDetectionCustomModule {
	if x != nil {
		return x.EffectiveEventThreatDetectionCustomModules
	}
	return nil
}

func (x *ListEffectiveEventThreatDetectionCustomModulesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Result containing the Asset and its State.
type ListAssetsResponse_ListAssetsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset matching the search request.
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// State change of the asset between the points in time.
	StateChange ListAssetsResponse_ListAssetsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListAssetsResponse_ListAssetsResult_StateChange" json:"state_change,omitempty"`
}

func (x *ListAssetsResponse_ListAssetsResult) Reset() {
	*x = ListAssetsResponse_ListAssetsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse_ListAssetsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse_ListAssetsResult) ProtoMessage() {}

func (x *ListAssetsResponse_ListAssetsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse_ListAssetsResult.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse_ListAssetsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{49, 0}
}

func (x *ListAssetsResponse_ListAssetsResult) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *ListAssetsResponse_ListAssetsResult) GetStateChange() ListAssetsResponse_ListAssetsResult_StateChange {
	if x != nil {
		return x.StateChange
	}
	return ListAssetsResponse_ListAssetsResult_UNUSED
}

// Result containing the Finding and its StateChange.
type ListFindingsResponse_ListFindingsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Finding matching the search request.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// State change of the finding between the points in time.
	StateChange ListFindingsResponse_ListFindingsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListFindingsResponse_ListFindingsResult_StateChange" json:"state_change,omitempty"`
	// Output only. Resource that is associated with this finding.
	Resource *ListFindingsResponse_ListFindingsResult_Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult) Reset() {
	*x = ListFindingsResponse_ListFindingsResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{51, 0}
}

func (x *ListFindingsResponse_ListFindingsResult) GetFinding() *Finding {
	if x != nil {
		return x.Finding
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult) GetStateChange() ListFindingsResponse_ListFindingsResult_StateChange {
	if x != nil {
		return x.StateChange
	}
	return ListFindingsResponse_ListFindingsResult_UNUSED
}

func (x *ListFindingsResponse_ListFindingsResult) GetResource() *ListFindingsResponse_ListFindingsResult_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Information related to the Google Cloud resource that is
// associated with this finding.
type ListFindingsResponse_ListFindingsResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name of the resource.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The full resource type of the resource.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// The full resource name of project that the resource belongs to.
	ProjectName string `protobuf:"bytes,2,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// The project ID that the resource belongs to.
	ProjectDisplayName string `protobuf:"bytes,3,opt,name=project_display_name,json=projectDisplayName,proto3" json:"project_display_name,omitempty"`
	// The full resource name of resource's parent.
	ParentName string `protobuf:"bytes,4,opt,name=parent_name,json=parentName,proto3" json:"parent_name,omitempty"`
	// The human readable name of resource's parent.
	ParentDisplayName string `protobuf:"bytes,5,opt,name=parent_display_name,json=parentDisplayName,proto3" json:"parent_display_name,omitempty"`
	// Contains a Folder message for each folder in the assets ancestry.
	// The first folder is the deepest nested folder, and the last folder is
	// the folder directly under the Organization.
	Folders []*Folder `protobuf:"bytes,7,rep,name=folders,proto3" json:"folders,omitempty"`
	// Indicates which cloud provider the finding is from.
	CloudProvider CloudProvider `protobuf:"varint,9,opt,name=cloud_provider,json=cloudProvider,proto3,enum=google.cloud.securitycenter.v1.CloudProvider" json:"cloud_provider,omitempty"`
	// Indicates which organization / tenant the finding is for.
	Organization string `protobuf:"bytes,10,opt,name=organization,proto3" json:"organization,omitempty"`
	// The service or resource provider associated with the resource.
	Service string `protobuf:"bytes,11,opt,name=service,proto3" json:"service,omitempty"`
	// The region or location of the service (if applicable).
	Location string `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
	// Types that are assignable to CloudProviderMetadata:
	//
	//	*ListFindingsResponse_ListFindingsResult_Resource_AwsMetadata
	//	*ListFindingsResponse_ListFindingsResult_Resource_AzureMetadata
	CloudProviderMetadata isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata `protobuf_oneof:"cloud_provider_metadata"`
	// Provides the path to the resource within the resource hierarchy.
	ResourcePath *ResourcePath `protobuf:"bytes,18,opt,name=resource_path,json=resourcePath,proto3" json:"resource_path,omitempty"`
	// A string representation of the resource path.
	// For Google Cloud, it has the format of
	// `org/{organization_id}/folder/{folder_id}/folder/{folder_id}/project/{project_id}`
	// where there can be any number of folders.
	// For AWS, it has the format of
	// `org/{organization_id}/ou/{organizational_unit_id}/ou/{organizational_unit_id}/account/{account_id}`
	// where there can be any number of organizational units.
	// For Azure, it has the format of
	// `mg/{management_group_id}/mg/{management_group_id}/subscription/{subscription_id}/rg/{resource_group_name}`
	// where there can be any number of management groups.
	ResourcePathString string `protobuf:"bytes,19,opt,name=resource_path_string,json=resourcePathString,proto3" json:"resource_path_string,omitempty"`
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) Reset() {
	*x = ListFindingsResponse_ListFindingsResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFindingsResponse_ListFindingsResult_Resource) ProtoMessage() {}

func (x *ListFindingsResponse_ListFindingsResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFindingsResponse_ListFindingsResult_Resource.ProtoReflect.Descriptor instead.
func (*ListFindingsResponse_ListFindingsResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{51, 0, 0}
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetProjectDisplayName() string {
	if x != nil {
		return x.ProjectDisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetParentName() string {
	if x != nil {
		return x.ParentName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetParentDisplayName() string {
	if x != nil {
		return x.ParentDisplayName
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetCloudProvider() CloudProvider {
	if x != nil {
		return x.CloudProvider
	}
	return CloudProvider_CLOUD_PROVIDER_UNSPECIFIED
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (m *ListFindingsResponse_ListFindingsResult_Resource) GetCloudProviderMetadata() isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata {
	if m != nil {
		return m.CloudProviderMetadata
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetAwsMetadata() *AwsMetadata {
	if x, ok := x.GetCloudProviderMetadata().(*ListFindingsResponse_ListFindingsResult_Resource_AwsMetadata); ok {
		return x.AwsMetadata
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetAzureMetadata() *AzureMetadata {
	if x, ok := x.GetCloudProviderMetadata().(*ListFindingsResponse_ListFindingsResult_Resource_AzureMetadata); ok {
		return x.AzureMetadata
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetResourcePath() *ResourcePath {
	if x != nil {
		return x.ResourcePath
	}
	return nil
}

func (x *ListFindingsResponse_ListFindingsResult_Resource) GetResourcePathString() string {
	if x != nil {
		return x.ResourcePathString
	}
	return ""
}

type isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata interface {
	isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata()
}

type ListFindingsResponse_ListFindingsResult_Resource_AwsMetadata struct {
	// The AWS metadata associated with the finding.
	AwsMetadata *AwsMetadata `protobuf:"bytes,16,opt,name=aws_metadata,json=awsMetadata,proto3,oneof"`
}

type ListFindingsResponse_ListFindingsResult_Resource_AzureMetadata struct {
	// The Azure metadata associated with the finding.
	AzureMetadata *AzureMetadata `protobuf:"bytes,17,opt,name=azure_metadata,json=azureMetadata,proto3,oneof"`
}

func (*ListFindingsResponse_ListFindingsResult_Resource_AwsMetadata) isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata() {
}

func (*ListFindingsResponse_ListFindingsResult_Resource_AzureMetadata) isListFindingsResponse_ListFindingsResult_Resource_CloudProviderMetadata() {
}

// Manually constructed resource name. If the custom module evaluates against
// only the resource data, you can omit the `iam_policy_data` field. If it
// evaluates only the `iam_policy_data` field, you can omit the resource data.
type SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the resource, for example,
	// `compute.googleapis.com/Disk`.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Optional. A representation of the Google Cloud resource. Should match the
	// Google Cloud resource JSON format.
	ResourceData *structpb.Struct `protobuf:"bytes,2,opt,name=resource_data,json=resourceData,proto3" json:"resource_data,omitempty"`
	// Optional. A representation of the IAM policy.
	IamPolicyData *iampb.Policy `protobuf:"bytes,3,opt,name=iam_policy_data,json=iamPolicyData,proto3" json:"iam_policy_data,omitempty"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{55, 0}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetResourceData() *structpb.Struct {
	if x != nil {
		return x.ResourceData
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource) GetIamPolicyData() *iampb.Policy {
	if x != nil {
		return x.IamPolicyData
	}
	return nil
}

// Possible test result.
type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Result:
	//
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation
	//	*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error
	Result isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result `protobuf_oneof:"result"`
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) Reset() {
	*x = SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) ProtoMessage() {}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult.ProtoReflect.Descriptor instead.
func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP(), []int{56, 0}
}

func (m *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetResult() isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetFinding() *Finding {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding); ok {
		return x.Finding
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetNoViolation() *emptypb.Empty {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation); ok {
		return x.NoViolation
	}
	return nil
}

func (x *SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult) GetError() *status.Status {
	if x, ok := x.GetResult().(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error); ok {
		return x.Error
	}
	return nil
}

type isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result interface {
	isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result()
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding struct {
	// Finding that would be published for the test case,
	// if a violation is detected.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3,oneof"`
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation struct {
	// Indicates that the test case does not trigger any violation.
	NoViolation *emptypb.Empty `protobuf:"bytes,2,opt,name=no_violation,json=noViolation,proto3,oneof"`
}

type SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error struct {
	// Error encountered during the test.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

func (*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error) isSimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Result() {
}

var File_google_cloud_securitycenter_v1_securitycenter_service_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x53, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x5b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75,
	0x6e, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xab, 0x02,
	0x0a, 0x17, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x03, 0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0e, 0x6d, 0x75, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x65, 0x0a, 0x0a, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d,
	0x75, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6d,
	0x75, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x41, 0x0a, 0x09, 0x4d, 0x75, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x55, 0x4e, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x22, 0x1a, 0x0a, 0x18, 0x42,
	0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc8, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x07, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0xe0, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6d, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xe3, 0x01, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x33, 0x12, 0x31, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6c, 0x0a,
	0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xde, 0x01, 0x0a, 0x26,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x94, 0x01, 0x0a,
	0x27, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x22, 0x71, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x33, 0x12, 0x31, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69,
	0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xff, 0x01, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0xb6, 0x02, 0x0a, 0x30, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43,
	0x12, 0x41, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9e, 0x01, 0x0a, 0x27,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xac, 0x01, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5f, 0x0a, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6f, 0x0a, 0x1f,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x01,
	0x0a, 0x30, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43, 0x0a, 0x41, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x64, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6c, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x70, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x36, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x66, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x52,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x4c, 0x0a, 0x4a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x2d, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43,
	0x0a, 0x41, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x54, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xcc, 0x02, 0x0a, 0x12, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x79, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72,
	0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xec,
	0x01, 0x0a, 0x13, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x62, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65,
	0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xcf, 0x02,
	0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a,
	0x10, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0xee, 0x01, 0x0a, 0x15, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x62, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0xd7, 0x01, 0x0a, 0x0b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x5b, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0x55, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xda, 0x01, 0x0a, 0x39, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43,
	0x12, 0x41, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x02, 0x0a, 0x3a, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x9b, 0x01, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x24,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xde, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbf, 0x01,
	0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a,
	0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0xb6, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61,
	0x74, 0x68, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61,
	0x74, 0x68, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x9e, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x12, 0x28, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x38, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43, 0x12, 0x41, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x02, 0x0a, 0x39, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0xb7, 0x01, 0x0a, 0x32, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x2d, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x01, 0x0a, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x49, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x43, 0x12,
	0x41, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf8, 0x01, 0x0a, 0x30, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x9b, 0x01, 0x0a, 0x28,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x12, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x03, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x8e, 0x04, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x11, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x82, 0x02, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x3b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x72, 0x0a,
	0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x22, 0x3d, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x0a, 0x0a, 0x06, 0x55, 0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03,
	0x22, 0x84, 0x03, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xe1, 0x0b, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x7b, 0x0a, 0x15, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x13, 0x6c, 0x69, 0x73, 0x74, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65,
	0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d,
	0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0xcb, 0x09,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x07,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x76, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x71, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xb7, 0x06, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x14, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x12, 0x54, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0c, 0x61, 0x77, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x77, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x56, 0x0a, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0d, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x51, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x30, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x42, 0x19, 0x0a, 0x17, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x4d, 0x0a, 0x0b,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x55,
	0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x04, 0x22, 0xe5, 0x01, 0x0a, 0x16,
	0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x6d, 0x75, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x2e, 0x4d, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6d, 0x75, 0x74, 0x65,
	0x22, 0x6c, 0x0a, 0x18, 0x52, 0x75, 0x6e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xf8,
	0x03, 0x0a, 0x32, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xc4, 0x01, 0x0a, 0x11, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x0f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0xfe, 0x02, 0x0a, 0x33, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x7b, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xc9,
	0x01, 0x0a, 0x0f, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x07,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x0c, 0x6e, 0x6f, 0x5f, 0x76, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x6f, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xb8, 0x01, 0x0a, 0x1b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9b, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc8,
	0x01, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x68, 0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd0, 0x01, 0x0a, 0x21, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x6e, 0x0a, 0x15, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x90, 0x02, 0x0a,
	0x30, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x9e, 0x01, 0x0a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x23, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x97, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xef, 0x01, 0x0a, 0x1a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61,
	0x72, 0x6b, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xfe, 0x01, 0x0a, 0x1b,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x32, 0x0a, 0x13, 0x62, 0x69, 0x67, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x62, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x10,
	0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa6, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12,
	0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5a, 0x0a, 0x11, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x0f, 0x62, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7,
	0x02, 0x0a, 0x2d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x5e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x12, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x95, 0x01, 0x0a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x2f, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x40, 0x12, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08,
	0x72, 0x61, 0x77, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x61, 0x77, 0x54, 0x65, 0x78, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x30, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x22, 0x8b, 0x01, 0x0a, 0x2d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x5a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88,
	0x01, 0x0a, 0x2a, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x40, 0x0a, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x36, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x40, 0x12, 0x3e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0xf6, 0x01, 0x0a, 0x37, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64,
	0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x92, 0x01, 0x0a,
	0x25, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x21,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xca, 0x01, 0x0a, 0x2c, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x46, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x40, 0x12, 0x3e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xec, 0x01, 0x0a, 0x2d, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x92, 0x01, 0x0a, 0x25, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x21, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x84, 0x02, 0x0a, 0x2d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x95, 0x01, 0x0a, 0x24, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9a, 0x01, 0x0a,
	0x33, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x4f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x49, 0x0a, 0x47, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdc, 0x01, 0x0a, 0x35, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x4f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x49, 0x12, 0x47, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x91, 0x02, 0x0a, 0x36, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0xae, 0x01, 0x0a, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x2a, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xf7, 0xb2, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x12, 0xe2, 0x02, 0x0a, 0x10, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf5, 0x01,
	0xca, 0x41, 0x50, 0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x6c, 0x6b, 0x4d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x92, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x2d, 0x3a, 0x01, 0x2a, 0x22, 0x28, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c,
	0x6b, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x2e, 0x3a, 0x01, 0x2a, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c,
	0x6b, 0x4d, 0x75, 0x74, 0x65, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x62, 0x75, 0x6c,
	0x6b, 0x4d, 0x75, 0x74, 0x65, 0x12, 0xd5, 0x04, 0x0a, 0x29, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x90, 0x03, 0xda, 0x41, 0x2e,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xd8, 0x02, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5a, 0x6f,
	0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a,
	0x70, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xb1, 0x01,
	0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x44, 0xda, 0x41, 0x0d,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2e, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x24, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0xcc, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0x5c, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x2c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x9c, 0x04, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa2, 0x03, 0xda, 0x41, 0x12,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe2, 0x02, 0x3a, 0x0b, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x43, 0x3a, 0x0b, 0x6d, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a,
	0x31, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x22,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x5a, 0x3d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x5a, 0x32, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x3e, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0xab, 0x03, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x99, 0x02, 0xda, 0x41, 0x24, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x2c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x1a, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xce, 0x01, 0x3a,
	0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5a, 0x41, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x42, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x88, 0x03,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0xa2, 0x02, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x94, 0x02, 0x5a, 0x24, 0x2a, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25, 0x2a, 0x23, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x2a, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x28,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x02, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x9d,
	0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01, 0x5a,
	0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2d, 0x2a,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x83,
	0x03, 0x0a, 0x29, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x50, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xeb, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xdd, 0x01, 0x5a, 0x46, 0x2a, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x47, 0x2a, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x91, 0x02, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x91, 0x01, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x83, 0x01, 0x5a, 0x28, 0x12,
	0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x96, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4b, 0xda, 0x41,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a,
	0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x96, 0x03, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa2, 0x02,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x02, 0x5a, 0x24,
	0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x36, 0x12, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xa9, 0x02, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9d,
	0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01, 0x5a,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2d, 0x12,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf,
	0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d,
	0x12, 0xe0, 0x03, 0x0a, 0x2f, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x86, 0x02, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf8, 0x01, 0x5a, 0x4f, 0x12, 0x4d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x50, 0x12, 0x4e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x53,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x03, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x22, 0xeb, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xdd, 0x01, 0x5a, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x47, 0x12, 0x45, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x9a, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x33, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02,
	0x0a, 0x0b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8d, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x83, 0x01,
	0x3a, 0x01, 0x2a, 0x5a, 0x28, 0x3a, 0x01, 0x2a, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5a, 0x29, 0x3a,
	0x01, 0x2a, 0x22, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x88, 0x02, 0x01, 0x12, 0xbf, 0x02, 0x0a, 0x0d, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc0, 0x01, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7,
	0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5a, 0x35, 0x3a, 0x01, 0x2a, 0x22,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x3a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0xe6, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x71,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x5a, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x5a, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x88, 0x02,
	0x01, 0x12, 0x88, 0x04, 0x0a, 0x32, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e,
	0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x9a, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x8a, 0x02, 0x5a, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x5a, 0x56, 0x12, 0x54, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e,
	0x74, 0x12, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69,
	0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12, 0x8f, 0x02, 0x0a,
	0x0c, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x8c, 0x01, 0x5a, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5a,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xa9,
	0x03, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xa4, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x94, 0x02, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x25, 0x12, 0x23,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x5a, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x7d, 0x5a, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x7d, 0x5a, 0x31, 0x12,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x7d,
	0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xbc, 0x02, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x9f, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8f, 0x01, 0x5a, 0x2c, 0x12, 0x2a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x5a, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xf3, 0x03, 0x0a, 0x31, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x02, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf8, 0x01, 0x5a, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0xbd, 0x03, 0x0a, 0x28, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xed, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xdd, 0x01, 0x5a, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x47, 0x12, 0x45, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0xf2, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6b, 0x5a, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x21, 0x12, 0x1f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x24,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x8a, 0x02, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x51, 0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x01, 0x2a, 0x22, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x3a, 0x72, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x88, 0x02,
	0x01, 0x12, 0xc4, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xcf, 0x01, 0xda, 0x41, 0x15, 0x6e, 0x61, 0x6d, 0x65,
	0x2c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb0, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x37, 0x3a, 0x01, 0x2a,
	0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x5a, 0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x38,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0xa5, 0x02, 0x0a, 0x07, 0x53, 0x65, 0x74,
	0x4d, 0x75, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xc0, 0x01,
	0xda, 0x41, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6d, 0x75, 0x74, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xad, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x5a, 0x37,
	0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x4d, 0x75, 0x74, 0x65,
	0x12, 0x9d, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x52, 0xda, 0x41,
	0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xc8, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0xda, 0x41,
	0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x81, 0x04, 0x0a, 0x2b,
	0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa8, 0x02, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x02, 0x3a, 0x01,
	0x2a, 0x5a, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x5a, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x3a, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0xd0, 0x03, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x22, 0xca, 0x02, 0xda, 0x41, 0x1b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa5, 0x02, 0x3a, 0x0f, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5a, 0x5e,
	0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x5f,
	0x3a, 0x0f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x32,
	0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xc1, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x22, 0xd0, 0x01, 0xda, 0x41, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbf, 0x01, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5a, 0x3c, 0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3d,
	0x3a, 0x07, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x37, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x04, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xcb, 0x03, 0xda, 0x41, 0x17, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xaa, 0x03, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5a, 0x3d, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x32, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x5a, 0x3e, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x5a, 0x4f, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x49, 0x3a, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4a, 0x3a, 0x0b,
	0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb,
	0x03, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xc9, 0x02, 0xda, 0x41, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xda, 0x41, 0x1f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x8a, 0x02, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5a, 0x55, 0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x56,
	0x3a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x02, 0x0a,
	0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x22, 0x7c, 0xda, 0x41, 0x15, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5e, 0x3a, 0x15, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x45, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x12, 0xd4, 0x05, 0x0a, 0x29, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x8f, 0x04, 0xda, 0x41, 0x33, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd2, 0x03, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5a, 0x97, 0x01, 0x3a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x6c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x98, 0x01, 0x3a, 0x27, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb1, 0x01, 0x0a, 0x0c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x32, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9f, 0x05,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x4d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73,
	0x22, 0x9c, 0x04, 0xda, 0x41, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x04, 0x3a, 0x0e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x5a, 0x4c, 0x3a, 0x0e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x3a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72,
	0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x4d, 0x3a, 0x0e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x5e, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x4c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x5a, 0x58, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x32, 0x46, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b,
	0x73, 0x7d, 0x5a, 0x59, 0x3a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d,
	0x61, 0x72, 0x6b, 0x73, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x32, 0x40, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x72,
	0x6b, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x73, 0x7d, 0x12,
	0xf4, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xee, 0x01, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x2c, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb9, 0x01, 0x3a, 0x10, 0x62,
	0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5a,
	0x3a, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5a, 0x3b, 0x3a, 0x10, 0x62,
	0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22,
	0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xff, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x91, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x83, 0x01, 0x5a, 0x28, 0x2a, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x29, 0x2a, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x03, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x92,
	0x02, 0xda, 0x41, 0x1c, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xec, 0x01, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5a, 0x4b, 0x3a, 0x10, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x32, 0x37, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4c, 0x3a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x32, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x69, 0x67, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x93, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x83, 0x01, 0x5a, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x2c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xb7, 0x04, 0x0a, 0x26, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xfb, 0x02, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc6, 0x02, 0x3a, 0x24,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5a, 0x69, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x41, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a,
	0x6a, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x47, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0xf4, 0x02, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xe2, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd4, 0x01, 0x5a, 0x43, 0x2a, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x44, 0x2a, 0x42,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2a, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98, 0x03, 0x0a, 0x23,
	0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x22, 0xe2, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xd4, 0x01, 0x5a, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x03, 0x0a, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61,
	0x6e, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x91, 0x02, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x02, 0x5a, 0x52,
	0x12, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61,
	0x6e, 0x74, 0x5a, 0x53, 0x12, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73,
	0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x3a, 0x6c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x12,
	0xab, 0x03, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe4, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd4, 0x01, 0x5a, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d,
	0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x44,
	0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0xad, 0x05,
	0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xf1, 0x03, 0xda, 0x41, 0x30, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xb7, 0x03, 0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5a, 0x8e, 0x01, 0x3a,
	0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x66, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x8f, 0x01,
	0x3a, 0x24, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x32, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32,
	0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc9, 0x03,
	0x0a, 0x28, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf9, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf2, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x4d, 0x3a, 0x01, 0x2a, 0x22,
	0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5a, 0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0xce, 0x03, 0x0a, 0x2c, 0x47, 0x65,
	0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x53, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x22, 0xfd, 0x01, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xef, 0x01, 0x5a, 0x4c, 0x12, 0x4a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x03, 0x0a, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x55, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xff, 0x01, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xef, 0x01, 0x5a,
	0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5a, 0x4d, 0x12,
	0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x50, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x8e,
	0x02, 0x0a, 0x1f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a,
	0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12,
	0xb7, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x9f,
	0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x21, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60,
	0x3a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb3, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xa2, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x92, 0x01, 0x5a, 0x54, 0x12, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xeb, 0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61,
	0x74, 0x68, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe6, 0x01, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd6, 0x01, 0x5a, 0x4a,
	0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x5a, 0x50, 0x12, 0x4e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78,
	0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x73, 0x12, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x1a, 0x51, 0xca, 0x41, 0x1d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe5, 0x05, 0xea, 0x41, 0x67, 0x0a, 0x32, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x55, 0x0a, 0x2c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x6d, 0x0a,
	0x34, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0xd7, 0x01,
	0x0a, 0x3a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x4a, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData = file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc
)

func file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDescData
}

var file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes = make([]protoimpl.MessageInfo, 89)
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes = []any{
	(BulkMuteFindingsRequest_MuteState)(0),                             // 0: google.cloud.securitycenter.v1.BulkMuteFindingsRequest.MuteState
	(ListAssetsResponse_ListAssetsResult_StateChange)(0),               // 1: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.StateChange
	(ListFindingsResponse_ListFindingsResult_StateChange)(0),           // 2: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
	(*BulkMuteFindingsRequest)(nil),                                    // 3: google.cloud.securitycenter.v1.BulkMuteFindingsRequest
	(*BulkMuteFindingsResponse)(nil),                                   // 4: google.cloud.securitycenter.v1.BulkMuteFindingsResponse
	(*CreateFindingRequest)(nil),                                       // 5: google.cloud.securitycenter.v1.CreateFindingRequest
	(*CreateMuteConfigRequest)(nil),                                    // 6: google.cloud.securitycenter.v1.CreateMuteConfigRequest
	(*CreateResourceValueConfigRequest)(nil),                           // 7: google.cloud.securitycenter.v1.CreateResourceValueConfigRequest
	(*BatchCreateResourceValueConfigsRequest)(nil),                     // 8: google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsRequest
	(*BatchCreateResourceValueConfigsResponse)(nil),                    // 9: google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsResponse
	(*DeleteResourceValueConfigRequest)(nil),                           // 10: google.cloud.securitycenter.v1.DeleteResourceValueConfigRequest
	(*GetResourceValueConfigRequest)(nil),                              // 11: google.cloud.securitycenter.v1.GetResourceValueConfigRequest
	(*ListResourceValueConfigsRequest)(nil),                            // 12: google.cloud.securitycenter.v1.ListResourceValueConfigsRequest
	(*ListResourceValueConfigsResponse)(nil),                           // 13: google.cloud.securitycenter.v1.ListResourceValueConfigsResponse
	(*UpdateResourceValueConfigRequest)(nil),                           // 14: google.cloud.securitycenter.v1.UpdateResourceValueConfigRequest
	(*CreateNotificationConfigRequest)(nil),                            // 15: google.cloud.securitycenter.v1.CreateNotificationConfigRequest
	(*CreateSecurityHealthAnalyticsCustomModuleRequest)(nil),           // 16: google.cloud.securitycenter.v1.CreateSecurityHealthAnalyticsCustomModuleRequest
	(*CreateSourceRequest)(nil),                                        // 17: google.cloud.securitycenter.v1.CreateSourceRequest
	(*DeleteMuteConfigRequest)(nil),                                    // 18: google.cloud.securitycenter.v1.DeleteMuteConfigRequest
	(*DeleteNotificationConfigRequest)(nil),                            // 19: google.cloud.securitycenter.v1.DeleteNotificationConfigRequest
	(*DeleteSecurityHealthAnalyticsCustomModuleRequest)(nil),           // 20: google.cloud.securitycenter.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest
	(*GetBigQueryExportRequest)(nil),                                   // 21: google.cloud.securitycenter.v1.GetBigQueryExportRequest
	(*GetMuteConfigRequest)(nil),                                       // 22: google.cloud.securitycenter.v1.GetMuteConfigRequest
	(*GetNotificationConfigRequest)(nil),                               // 23: google.cloud.securitycenter.v1.GetNotificationConfigRequest
	(*GetOrganizationSettingsRequest)(nil),                             // 24: google.cloud.securitycenter.v1.GetOrganizationSettingsRequest
	(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)(nil),     // 25: google.cloud.securitycenter.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
	(*GetSecurityHealthAnalyticsCustomModuleRequest)(nil),              // 26: google.cloud.securitycenter.v1.GetSecurityHealthAnalyticsCustomModuleRequest
	(*GetSourceRequest)(nil),                                           // 27: google.cloud.securitycenter.v1.GetSourceRequest
	(*GroupAssetsRequest)(nil),                                         // 28: google.cloud.securitycenter.v1.GroupAssetsRequest
	(*GroupAssetsResponse)(nil),                                        // 29: google.cloud.securitycenter.v1.GroupAssetsResponse
	(*GroupFindingsRequest)(nil),                                       // 30: google.cloud.securitycenter.v1.GroupFindingsRequest
	(*GroupFindingsResponse)(nil),                                      // 31: google.cloud.securitycenter.v1.GroupFindingsResponse
	(*GroupResult)(nil),                                                // 32: google.cloud.securitycenter.v1.GroupResult
	(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest)(nil),  // 33: google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest
	(*ListDescendantSecurityHealthAnalyticsCustomModulesResponse)(nil), // 34: google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse
	(*ListValuedResourcesRequest)(nil),                                 // 35: google.cloud.securitycenter.v1.ListValuedResourcesRequest
	(*ListValuedResourcesResponse)(nil),                                // 36: google.cloud.securitycenter.v1.ListValuedResourcesResponse
	(*ListAttackPathsRequest)(nil),                                     // 37: google.cloud.securitycenter.v1.ListAttackPathsRequest
	(*ListAttackPathsResponse)(nil),                                    // 38: google.cloud.securitycenter.v1.ListAttackPathsResponse
	(*GetSimulationRequest)(nil),                                       // 39: google.cloud.securitycenter.v1.GetSimulationRequest
	(*GetValuedResourceRequest)(nil),                                   // 40: google.cloud.securitycenter.v1.GetValuedResourceRequest
	(*ListMuteConfigsRequest)(nil),                                     // 41: google.cloud.securitycenter.v1.ListMuteConfigsRequest
	(*ListMuteConfigsResponse)(nil),                                    // 42: google.cloud.securitycenter.v1.ListMuteConfigsResponse
	(*ListNotificationConfigsRequest)(nil),                             // 43: google.cloud.securitycenter.v1.ListNotificationConfigsRequest
	(*ListNotificationConfigsResponse)(nil),                            // 44: google.cloud.securitycenter.v1.ListNotificationConfigsResponse
	(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)(nil),   // 45: google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
	(*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse)(nil),  // 46: google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
	(*ListSecurityHealthAnalyticsCustomModulesRequest)(nil),            // 47: google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesRequest
	(*ListSecurityHealthAnalyticsCustomModulesResponse)(nil),           // 48: google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesResponse
	(*ListSourcesRequest)(nil),                                         // 49: google.cloud.securitycenter.v1.ListSourcesRequest
	(*ListSourcesResponse)(nil),                                        // 50: google.cloud.securitycenter.v1.ListSourcesResponse
	(*ListAssetsRequest)(nil),                                          // 51: google.cloud.securitycenter.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                                         // 52: google.cloud.securitycenter.v1.ListAssetsResponse
	(*ListFindingsRequest)(nil),                                        // 53: google.cloud.securitycenter.v1.ListFindingsRequest
	(*ListFindingsResponse)(nil),                                       // 54: google.cloud.securitycenter.v1.ListFindingsResponse
	(*SetFindingStateRequest)(nil),                                     // 55: google.cloud.securitycenter.v1.SetFindingStateRequest
	(*SetMuteRequest)(nil),                                             // 56: google.cloud.securitycenter.v1.SetMuteRequest
	(*RunAssetDiscoveryRequest)(nil),                                   // 57: google.cloud.securitycenter.v1.RunAssetDiscoveryRequest
	(*SimulateSecurityHealthAnalyticsCustomModuleRequest)(nil),         // 58: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
	(*SimulateSecurityHealthAnalyticsCustomModuleResponse)(nil),        // 59: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
	(*UpdateExternalSystemRequest)(nil),                                // 60: google.cloud.securitycenter.v1.UpdateExternalSystemRequest
	(*UpdateFindingRequest)(nil),                                       // 61: google.cloud.securitycenter.v1.UpdateFindingRequest
	(*UpdateMuteConfigRequest)(nil),                                    // 62: google.cloud.securitycenter.v1.UpdateMuteConfigRequest
	(*UpdateNotificationConfigRequest)(nil),                            // 63: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest
	(*UpdateOrganizationSettingsRequest)(nil),                          // 64: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest
	(*UpdateSecurityHealthAnalyticsCustomModuleRequest)(nil),           // 65: google.cloud.securitycenter.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest
	(*UpdateSourceRequest)(nil),                                        // 66: google.cloud.securitycenter.v1.UpdateSourceRequest
	(*UpdateSecurityMarksRequest)(nil),                                 // 67: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest
	(*CreateBigQueryExportRequest)(nil),                                // 68: google.cloud.securitycenter.v1.CreateBigQueryExportRequest
	(*UpdateBigQueryExportRequest)(nil),                                // 69: google.cloud.securitycenter.v1.UpdateBigQueryExportRequest
	(*ListBigQueryExportsRequest)(nil),                                 // 70: google.cloud.securitycenter.v1.ListBigQueryExportsRequest
	(*ListBigQueryExportsResponse)(nil),                                // 71: google.cloud.securitycenter.v1.ListBigQueryExportsResponse
	(*DeleteBigQueryExportRequest)(nil),                                // 72: google.cloud.securitycenter.v1.DeleteBigQueryExportRequest
	(*CreateEventThreatDetectionCustomModuleRequest)(nil),              // 73: google.cloud.securitycenter.v1.CreateEventThreatDetectionCustomModuleRequest
	(*ValidateEventThreatDetectionCustomModuleRequest)(nil),            // 74: google.cloud.securitycenter.v1.ValidateEventThreatDetectionCustomModuleRequest
	(*ValidateEventThreatDetectionCustomModuleResponse)(nil),           // 75: google.cloud.securitycenter.v1.ValidateEventThreatDetectionCustomModuleResponse
	(*DeleteEventThreatDetectionCustomModuleRequest)(nil),              // 76: google.cloud.securitycenter.v1.DeleteEventThreatDetectionCustomModuleRequest
	(*GetEventThreatDetectionCustomModuleRequest)(nil),                 // 77: google.cloud.securitycenter.v1.GetEventThreatDetectionCustomModuleRequest
	(*ListDescendantEventThreatDetectionCustomModulesRequest)(nil),     // 78: google.cloud.securitycenter.v1.ListDescendantEventThreatDetectionCustomModulesRequest
	(*ListDescendantEventThreatDetectionCustomModulesResponse)(nil),    // 79: google.cloud.securitycenter.v1.ListDescendantEventThreatDetectionCustomModulesResponse
	(*ListEventThreatDetectionCustomModulesRequest)(nil),               // 80: google.cloud.securitycenter.v1.ListEventThreatDetectionCustomModulesRequest
	(*ListEventThreatDetectionCustomModulesResponse)(nil),              // 81: google.cloud.securitycenter.v1.ListEventThreatDetectionCustomModulesResponse
	(*UpdateEventThreatDetectionCustomModuleRequest)(nil),              // 82: google.cloud.securitycenter.v1.UpdateEventThreatDetectionCustomModuleRequest
	(*GetEffectiveEventThreatDetectionCustomModuleRequest)(nil),        // 83: google.cloud.securitycenter.v1.GetEffectiveEventThreatDetectionCustomModuleRequest
	(*ListEffectiveEventThreatDetectionCustomModulesRequest)(nil),      // 84: google.cloud.securitycenter.v1.ListEffectiveEventThreatDetectionCustomModulesRequest
	(*ListEffectiveEventThreatDetectionCustomModulesResponse)(nil),     // 85: google.cloud.securitycenter.v1.ListEffectiveEventThreatDetectionCustomModulesResponse
	nil, // 86: google.cloud.securitycenter.v1.GroupResult.PropertiesEntry
	(*ListAssetsResponse_ListAssetsResult)(nil),                                  // 87: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult
	(*ListFindingsResponse_ListFindingsResult)(nil),                              // 88: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
	(*ListFindingsResponse_ListFindingsResult_Resource)(nil),                     // 89: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
	(*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource)(nil), // 90: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
	(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult)(nil),  // 91: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
	(*Finding)(nil),                                      // 92: google.cloud.securitycenter.v1.Finding
	(*MuteConfig)(nil),                                   // 93: google.cloud.securitycenter.v1.MuteConfig
	(*ResourceValueConfig)(nil),                          // 94: google.cloud.securitycenter.v1.ResourceValueConfig
	(*fieldmaskpb.FieldMask)(nil),                        // 95: google.protobuf.FieldMask
	(*NotificationConfig)(nil),                           // 96: google.cloud.securitycenter.v1.NotificationConfig
	(*SecurityHealthAnalyticsCustomModule)(nil),          // 97: google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	(*Source)(nil),                                       // 98: google.cloud.securitycenter.v1.Source
	(*durationpb.Duration)(nil),                          // 99: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                        // 100: google.protobuf.Timestamp
	(*ValuedResource)(nil),                               // 101: google.cloud.securitycenter.v1.ValuedResource
	(*AttackPath)(nil),                                   // 102: google.cloud.securitycenter.v1.AttackPath
	(*EffectiveSecurityHealthAnalyticsCustomModule)(nil), // 103: google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
	(Finding_State)(0),                                   // 104: google.cloud.securitycenter.v1.Finding.State
	(Finding_Mute)(0),                                    // 105: google.cloud.securitycenter.v1.Finding.Mute
	(*CustomConfig)(nil),                                 // 106: google.cloud.securitycenter.v1.CustomConfig
	(*ExternalSystem)(nil),                               // 107: google.cloud.securitycenter.v1.ExternalSystem
	(*OrganizationSettings)(nil),                         // 108: google.cloud.securitycenter.v1.OrganizationSettings
	(*SecurityMarks)(nil),                                // 109: google.cloud.securitycenter.v1.SecurityMarks
	(*BigQueryExport)(nil),                               // 110: google.cloud.securitycenter.v1.BigQueryExport
	(*EventThreatDetectionCustomModule)(nil),             // 111: google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	(*CustomModuleValidationErrors)(nil),                 // 112: google.cloud.securitycenter.v1.CustomModuleValidationErrors
	(*EffectiveEventThreatDetectionCustomModule)(nil),    // 113: google.cloud.securitycenter.v1.EffectiveEventThreatDetectionCustomModule
	(*structpb.Value)(nil),                               // 114: google.protobuf.Value
	(*Asset)(nil),                                        // 115: google.cloud.securitycenter.v1.Asset
	(*Folder)(nil),                                       // 116: google.cloud.securitycenter.v1.Folder
	(CloudProvider)(0),                                   // 117: google.cloud.securitycenter.v1.CloudProvider
	(*AwsMetadata)(nil),                                  // 118: google.cloud.securitycenter.v1.AwsMetadata
	(*AzureMetadata)(nil),                                // 119: google.cloud.securitycenter.v1.AzureMetadata
	(*ResourcePath)(nil),                                 // 120: google.cloud.securitycenter.v1.ResourcePath
	(*structpb.Struct)(nil),                              // 121: google.protobuf.Struct
	(*iampb.Policy)(nil),                                 // 122: google.iam.v1.Policy
	(*emptypb.Empty)(nil),                                // 123: google.protobuf.Empty
	(*status.Status)(nil),                                // 124: google.rpc.Status
	(*iampb.GetIamPolicyRequest)(nil),                    // 125: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),                    // 126: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),              // 127: google.iam.v1.TestIamPermissionsRequest
	(*longrunningpb.Operation)(nil),                      // 128: google.longrunning.Operation
	(*Simulation)(nil),                                   // 129: google.cloud.securitycenter.v1.Simulation
	(*iampb.TestIamPermissionsResponse)(nil),             // 130: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs = []int32{
	0,   // 0: google.cloud.securitycenter.v1.BulkMuteFindingsRequest.mute_state:type_name -> google.cloud.securitycenter.v1.BulkMuteFindingsRequest.MuteState
	92,  // 1: google.cloud.securitycenter.v1.CreateFindingRequest.finding:type_name -> google.cloud.securitycenter.v1.Finding
	93,  // 2: google.cloud.securitycenter.v1.CreateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v1.MuteConfig
	94,  // 3: google.cloud.securitycenter.v1.CreateResourceValueConfigRequest.resource_value_config:type_name -> google.cloud.securitycenter.v1.ResourceValueConfig
	7,   // 4: google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsRequest.requests:type_name -> google.cloud.securitycenter.v1.CreateResourceValueConfigRequest
	94,  // 5: google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsResponse.resource_value_configs:type_name -> google.cloud.securitycenter.v1.ResourceValueConfig
	94,  // 6: google.cloud.securitycenter.v1.ListResourceValueConfigsResponse.resource_value_configs:type_name -> google.cloud.securitycenter.v1.ResourceValueConfig
	94,  // 7: google.cloud.securitycenter.v1.UpdateResourceValueConfigRequest.resource_value_config:type_name -> google.cloud.securitycenter.v1.ResourceValueConfig
	95,  // 8: google.cloud.securitycenter.v1.UpdateResourceValueConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	96,  // 9: google.cloud.securitycenter.v1.CreateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	97,  // 10: google.cloud.securitycenter.v1.CreateSecurityHealthAnalyticsCustomModuleRequest.security_health_analytics_custom_module:type_name -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	98,  // 11: google.cloud.securitycenter.v1.CreateSourceRequest.source:type_name -> google.cloud.securitycenter.v1.Source
	99,  // 12: google.cloud.securitycenter.v1.GroupAssetsRequest.compare_duration:type_name -> google.protobuf.Duration
	100, // 13: google.cloud.securitycenter.v1.GroupAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	32,  // 14: google.cloud.securitycenter.v1.GroupAssetsResponse.group_by_results:type_name -> google.cloud.securitycenter.v1.GroupResult
	100, // 15: google.cloud.securitycenter.v1.GroupAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	100, // 16: google.cloud.securitycenter.v1.GroupFindingsRequest.read_time:type_name -> google.protobuf.Timestamp
	99,  // 17: google.cloud.securitycenter.v1.GroupFindingsRequest.compare_duration:type_name -> google.protobuf.Duration
	32,  // 18: google.cloud.securitycenter.v1.GroupFindingsResponse.group_by_results:type_name -> google.cloud.securitycenter.v1.GroupResult
	100, // 19: google.cloud.securitycenter.v1.GroupFindingsResponse.read_time:type_name -> google.protobuf.Timestamp
	86,  // 20: google.cloud.securitycenter.v1.GroupResult.properties:type_name -> google.cloud.securitycenter.v1.GroupResult.PropertiesEntry
	97,  // 21: google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse.security_health_analytics_custom_modules:type_name -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	101, // 22: google.cloud.securitycenter.v1.ListValuedResourcesResponse.valued_resources:type_name -> google.cloud.securitycenter.v1.ValuedResource
	102, // 23: google.cloud.securitycenter.v1.ListAttackPathsResponse.attack_paths:type_name -> google.cloud.securitycenter.v1.AttackPath
	93,  // 24: google.cloud.securitycenter.v1.ListMuteConfigsResponse.mute_configs:type_name -> google.cloud.securitycenter.v1.MuteConfig
	96,  // 25: google.cloud.securitycenter.v1.ListNotificationConfigsResponse.notification_configs:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	103, // 26: google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse.effective_security_health_analytics_custom_modules:type_name -> google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
	97,  // 27: google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesResponse.security_health_analytics_custom_modules:type_name -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	98,  // 28: google.cloud.securitycenter.v1.ListSourcesResponse.sources:type_name -> google.cloud.securitycenter.v1.Source
	100, // 29: google.cloud.securitycenter.v1.ListAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	99,  // 30: google.cloud.securitycenter.v1.ListAssetsRequest.compare_duration:type_name -> google.protobuf.Duration
	95,  // 31: google.cloud.securitycenter.v1.ListAssetsRequest.field_mask:type_name -> google.protobuf.FieldMask
	87,  // 32: google.cloud.securitycenter.v1.ListAssetsResponse.list_assets_results:type_name -> google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult
	100, // 33: google.cloud.securitycenter.v1.ListAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	100, // 34: google.cloud.securitycenter.v1.ListFindingsRequest.read_time:type_name -> google.protobuf.Timestamp
	99,  // 35: google.cloud.securitycenter.v1.ListFindingsRequest.compare_duration:type_name -> google.protobuf.Duration
	95,  // 36: google.cloud.securitycenter.v1.ListFindingsRequest.field_mask:type_name -> google.protobuf.FieldMask
	88,  // 37: google.cloud.securitycenter.v1.ListFindingsResponse.list_findings_results:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult
	100, // 38: google.cloud.securitycenter.v1.ListFindingsResponse.read_time:type_name -> google.protobuf.Timestamp
	104, // 39: google.cloud.securitycenter.v1.SetFindingStateRequest.state:type_name -> google.cloud.securitycenter.v1.Finding.State
	100, // 40: google.cloud.securitycenter.v1.SetFindingStateRequest.start_time:type_name -> google.protobuf.Timestamp
	105, // 41: google.cloud.securitycenter.v1.SetMuteRequest.mute:type_name -> google.cloud.securitycenter.v1.Finding.Mute
	106, // 42: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.custom_config:type_name -> google.cloud.securitycenter.v1.CustomConfig
	90,  // 43: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.resource:type_name -> google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource
	91,  // 44: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.result:type_name -> google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult
	107, // 45: google.cloud.securitycenter.v1.UpdateExternalSystemRequest.external_system:type_name -> google.cloud.securitycenter.v1.ExternalSystem
	95,  // 46: google.cloud.securitycenter.v1.UpdateExternalSystemRequest.update_mask:type_name -> google.protobuf.FieldMask
	92,  // 47: google.cloud.securitycenter.v1.UpdateFindingRequest.finding:type_name -> google.cloud.securitycenter.v1.Finding
	95,  // 48: google.cloud.securitycenter.v1.UpdateFindingRequest.update_mask:type_name -> google.protobuf.FieldMask
	93,  // 49: google.cloud.securitycenter.v1.UpdateMuteConfigRequest.mute_config:type_name -> google.cloud.securitycenter.v1.MuteConfig
	95,  // 50: google.cloud.securitycenter.v1.UpdateMuteConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	96,  // 51: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest.notification_config:type_name -> google.cloud.securitycenter.v1.NotificationConfig
	95,  // 52: google.cloud.securitycenter.v1.UpdateNotificationConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	108, // 53: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest.organization_settings:type_name -> google.cloud.securitycenter.v1.OrganizationSettings
	95,  // 54: google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	97,  // 55: google.cloud.securitycenter.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest.security_health_analytics_custom_module:type_name -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	95,  // 56: google.cloud.securitycenter.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	98,  // 57: google.cloud.securitycenter.v1.UpdateSourceRequest.source:type_name -> google.cloud.securitycenter.v1.Source
	95,  // 58: google.cloud.securitycenter.v1.UpdateSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	109, // 59: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.security_marks:type_name -> google.cloud.securitycenter.v1.SecurityMarks
	95,  // 60: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.update_mask:type_name -> google.protobuf.FieldMask
	100, // 61: google.cloud.securitycenter.v1.UpdateSecurityMarksRequest.start_time:type_name -> google.protobuf.Timestamp
	110, // 62: google.cloud.securitycenter.v1.CreateBigQueryExportRequest.big_query_export:type_name -> google.cloud.securitycenter.v1.BigQueryExport
	110, // 63: google.cloud.securitycenter.v1.UpdateBigQueryExportRequest.big_query_export:type_name -> google.cloud.securitycenter.v1.BigQueryExport
	95,  // 64: google.cloud.securitycenter.v1.UpdateBigQueryExportRequest.update_mask:type_name -> google.protobuf.FieldMask
	110, // 65: google.cloud.securitycenter.v1.ListBigQueryExportsResponse.big_query_exports:type_name -> google.cloud.securitycenter.v1.BigQueryExport
	111, // 66: google.cloud.securitycenter.v1.CreateEventThreatDetectionCustomModuleRequest.event_threat_detection_custom_module:type_name -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	112, // 67: google.cloud.securitycenter.v1.ValidateEventThreatDetectionCustomModuleResponse.errors:type_name -> google.cloud.securitycenter.v1.CustomModuleValidationErrors
	111, // 68: google.cloud.securitycenter.v1.ListDescendantEventThreatDetectionCustomModulesResponse.event_threat_detection_custom_modules:type_name -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	111, // 69: google.cloud.securitycenter.v1.ListEventThreatDetectionCustomModulesResponse.event_threat_detection_custom_modules:type_name -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	111, // 70: google.cloud.securitycenter.v1.UpdateEventThreatDetectionCustomModuleRequest.event_threat_detection_custom_module:type_name -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	95,  // 71: google.cloud.securitycenter.v1.UpdateEventThreatDetectionCustomModuleRequest.update_mask:type_name -> google.protobuf.FieldMask
	113, // 72: google.cloud.securitycenter.v1.ListEffectiveEventThreatDetectionCustomModulesResponse.effective_event_threat_detection_custom_modules:type_name -> google.cloud.securitycenter.v1.EffectiveEventThreatDetectionCustomModule
	114, // 73: google.cloud.securitycenter.v1.GroupResult.PropertiesEntry.value:type_name -> google.protobuf.Value
	115, // 74: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.asset:type_name -> google.cloud.securitycenter.v1.Asset
	1,   // 75: google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.state_change:type_name -> google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult.StateChange
	92,  // 76: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.finding:type_name -> google.cloud.securitycenter.v1.Finding
	2,   // 77: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.state_change:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange
	89,  // 78: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.resource:type_name -> google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource
	116, // 79: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.folders:type_name -> google.cloud.securitycenter.v1.Folder
	117, // 80: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.cloud_provider:type_name -> google.cloud.securitycenter.v1.CloudProvider
	118, // 81: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.aws_metadata:type_name -> google.cloud.securitycenter.v1.AwsMetadata
	119, // 82: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.azure_metadata:type_name -> google.cloud.securitycenter.v1.AzureMetadata
	120, // 83: google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.Resource.resource_path:type_name -> google.cloud.securitycenter.v1.ResourcePath
	121, // 84: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.resource_data:type_name -> google.protobuf.Struct
	122, // 85: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest.SimulatedResource.iam_policy_data:type_name -> google.iam.v1.Policy
	92,  // 86: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.finding:type_name -> google.cloud.securitycenter.v1.Finding
	123, // 87: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.no_violation:type_name -> google.protobuf.Empty
	124, // 88: google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse.SimulatedResult.error:type_name -> google.rpc.Status
	3,   // 89: google.cloud.securitycenter.v1.SecurityCenter.BulkMuteFindings:input_type -> google.cloud.securitycenter.v1.BulkMuteFindingsRequest
	16,  // 90: google.cloud.securitycenter.v1.SecurityCenter.CreateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.CreateSecurityHealthAnalyticsCustomModuleRequest
	17,  // 91: google.cloud.securitycenter.v1.SecurityCenter.CreateSource:input_type -> google.cloud.securitycenter.v1.CreateSourceRequest
	5,   // 92: google.cloud.securitycenter.v1.SecurityCenter.CreateFinding:input_type -> google.cloud.securitycenter.v1.CreateFindingRequest
	6,   // 93: google.cloud.securitycenter.v1.SecurityCenter.CreateMuteConfig:input_type -> google.cloud.securitycenter.v1.CreateMuteConfigRequest
	15,  // 94: google.cloud.securitycenter.v1.SecurityCenter.CreateNotificationConfig:input_type -> google.cloud.securitycenter.v1.CreateNotificationConfigRequest
	18,  // 95: google.cloud.securitycenter.v1.SecurityCenter.DeleteMuteConfig:input_type -> google.cloud.securitycenter.v1.DeleteMuteConfigRequest
	19,  // 96: google.cloud.securitycenter.v1.SecurityCenter.DeleteNotificationConfig:input_type -> google.cloud.securitycenter.v1.DeleteNotificationConfigRequest
	20,  // 97: google.cloud.securitycenter.v1.SecurityCenter.DeleteSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest
	39,  // 98: google.cloud.securitycenter.v1.SecurityCenter.GetSimulation:input_type -> google.cloud.securitycenter.v1.GetSimulationRequest
	40,  // 99: google.cloud.securitycenter.v1.SecurityCenter.GetValuedResource:input_type -> google.cloud.securitycenter.v1.GetValuedResourceRequest
	21,  // 100: google.cloud.securitycenter.v1.SecurityCenter.GetBigQueryExport:input_type -> google.cloud.securitycenter.v1.GetBigQueryExportRequest
	125, // 101: google.cloud.securitycenter.v1.SecurityCenter.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	22,  // 102: google.cloud.securitycenter.v1.SecurityCenter.GetMuteConfig:input_type -> google.cloud.securitycenter.v1.GetMuteConfigRequest
	23,  // 103: google.cloud.securitycenter.v1.SecurityCenter.GetNotificationConfig:input_type -> google.cloud.securitycenter.v1.GetNotificationConfigRequest
	24,  // 104: google.cloud.securitycenter.v1.SecurityCenter.GetOrganizationSettings:input_type -> google.cloud.securitycenter.v1.GetOrganizationSettingsRequest
	25,  // 105: google.cloud.securitycenter.v1.SecurityCenter.GetEffectiveSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest
	26,  // 106: google.cloud.securitycenter.v1.SecurityCenter.GetSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.GetSecurityHealthAnalyticsCustomModuleRequest
	27,  // 107: google.cloud.securitycenter.v1.SecurityCenter.GetSource:input_type -> google.cloud.securitycenter.v1.GetSourceRequest
	28,  // 108: google.cloud.securitycenter.v1.SecurityCenter.GroupAssets:input_type -> google.cloud.securitycenter.v1.GroupAssetsRequest
	30,  // 109: google.cloud.securitycenter.v1.SecurityCenter.GroupFindings:input_type -> google.cloud.securitycenter.v1.GroupFindingsRequest
	51,  // 110: google.cloud.securitycenter.v1.SecurityCenter.ListAssets:input_type -> google.cloud.securitycenter.v1.ListAssetsRequest
	33,  // 111: google.cloud.securitycenter.v1.SecurityCenter.ListDescendantSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest
	53,  // 112: google.cloud.securitycenter.v1.SecurityCenter.ListFindings:input_type -> google.cloud.securitycenter.v1.ListFindingsRequest
	41,  // 113: google.cloud.securitycenter.v1.SecurityCenter.ListMuteConfigs:input_type -> google.cloud.securitycenter.v1.ListMuteConfigsRequest
	43,  // 114: google.cloud.securitycenter.v1.SecurityCenter.ListNotificationConfigs:input_type -> google.cloud.securitycenter.v1.ListNotificationConfigsRequest
	45,  // 115: google.cloud.securitycenter.v1.SecurityCenter.ListEffectiveSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest
	47,  // 116: google.cloud.securitycenter.v1.SecurityCenter.ListSecurityHealthAnalyticsCustomModules:input_type -> google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesRequest
	49,  // 117: google.cloud.securitycenter.v1.SecurityCenter.ListSources:input_type -> google.cloud.securitycenter.v1.ListSourcesRequest
	57,  // 118: google.cloud.securitycenter.v1.SecurityCenter.RunAssetDiscovery:input_type -> google.cloud.securitycenter.v1.RunAssetDiscoveryRequest
	55,  // 119: google.cloud.securitycenter.v1.SecurityCenter.SetFindingState:input_type -> google.cloud.securitycenter.v1.SetFindingStateRequest
	56,  // 120: google.cloud.securitycenter.v1.SecurityCenter.SetMute:input_type -> google.cloud.securitycenter.v1.SetMuteRequest
	126, // 121: google.cloud.securitycenter.v1.SecurityCenter.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	127, // 122: google.cloud.securitycenter.v1.SecurityCenter.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	58,  // 123: google.cloud.securitycenter.v1.SecurityCenter.SimulateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest
	60,  // 124: google.cloud.securitycenter.v1.SecurityCenter.UpdateExternalSystem:input_type -> google.cloud.securitycenter.v1.UpdateExternalSystemRequest
	61,  // 125: google.cloud.securitycenter.v1.SecurityCenter.UpdateFinding:input_type -> google.cloud.securitycenter.v1.UpdateFindingRequest
	62,  // 126: google.cloud.securitycenter.v1.SecurityCenter.UpdateMuteConfig:input_type -> google.cloud.securitycenter.v1.UpdateMuteConfigRequest
	63,  // 127: google.cloud.securitycenter.v1.SecurityCenter.UpdateNotificationConfig:input_type -> google.cloud.securitycenter.v1.UpdateNotificationConfigRequest
	64,  // 128: google.cloud.securitycenter.v1.SecurityCenter.UpdateOrganizationSettings:input_type -> google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest
	65,  // 129: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityHealthAnalyticsCustomModule:input_type -> google.cloud.securitycenter.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest
	66,  // 130: google.cloud.securitycenter.v1.SecurityCenter.UpdateSource:input_type -> google.cloud.securitycenter.v1.UpdateSourceRequest
	67,  // 131: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityMarks:input_type -> google.cloud.securitycenter.v1.UpdateSecurityMarksRequest
	68,  // 132: google.cloud.securitycenter.v1.SecurityCenter.CreateBigQueryExport:input_type -> google.cloud.securitycenter.v1.CreateBigQueryExportRequest
	72,  // 133: google.cloud.securitycenter.v1.SecurityCenter.DeleteBigQueryExport:input_type -> google.cloud.securitycenter.v1.DeleteBigQueryExportRequest
	69,  // 134: google.cloud.securitycenter.v1.SecurityCenter.UpdateBigQueryExport:input_type -> google.cloud.securitycenter.v1.UpdateBigQueryExportRequest
	70,  // 135: google.cloud.securitycenter.v1.SecurityCenter.ListBigQueryExports:input_type -> google.cloud.securitycenter.v1.ListBigQueryExportsRequest
	73,  // 136: google.cloud.securitycenter.v1.SecurityCenter.CreateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.CreateEventThreatDetectionCustomModuleRequest
	76,  // 137: google.cloud.securitycenter.v1.SecurityCenter.DeleteEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.DeleteEventThreatDetectionCustomModuleRequest
	77,  // 138: google.cloud.securitycenter.v1.SecurityCenter.GetEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.GetEventThreatDetectionCustomModuleRequest
	78,  // 139: google.cloud.securitycenter.v1.SecurityCenter.ListDescendantEventThreatDetectionCustomModules:input_type -> google.cloud.securitycenter.v1.ListDescendantEventThreatDetectionCustomModulesRequest
	80,  // 140: google.cloud.securitycenter.v1.SecurityCenter.ListEventThreatDetectionCustomModules:input_type -> google.cloud.securitycenter.v1.ListEventThreatDetectionCustomModulesRequest
	82,  // 141: google.cloud.securitycenter.v1.SecurityCenter.UpdateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.UpdateEventThreatDetectionCustomModuleRequest
	74,  // 142: google.cloud.securitycenter.v1.SecurityCenter.ValidateEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.ValidateEventThreatDetectionCustomModuleRequest
	83,  // 143: google.cloud.securitycenter.v1.SecurityCenter.GetEffectiveEventThreatDetectionCustomModule:input_type -> google.cloud.securitycenter.v1.GetEffectiveEventThreatDetectionCustomModuleRequest
	84,  // 144: google.cloud.securitycenter.v1.SecurityCenter.ListEffectiveEventThreatDetectionCustomModules:input_type -> google.cloud.securitycenter.v1.ListEffectiveEventThreatDetectionCustomModulesRequest
	8,   // 145: google.cloud.securitycenter.v1.SecurityCenter.BatchCreateResourceValueConfigs:input_type -> google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsRequest
	10,  // 146: google.cloud.securitycenter.v1.SecurityCenter.DeleteResourceValueConfig:input_type -> google.cloud.securitycenter.v1.DeleteResourceValueConfigRequest
	11,  // 147: google.cloud.securitycenter.v1.SecurityCenter.GetResourceValueConfig:input_type -> google.cloud.securitycenter.v1.GetResourceValueConfigRequest
	12,  // 148: google.cloud.securitycenter.v1.SecurityCenter.ListResourceValueConfigs:input_type -> google.cloud.securitycenter.v1.ListResourceValueConfigsRequest
	14,  // 149: google.cloud.securitycenter.v1.SecurityCenter.UpdateResourceValueConfig:input_type -> google.cloud.securitycenter.v1.UpdateResourceValueConfigRequest
	35,  // 150: google.cloud.securitycenter.v1.SecurityCenter.ListValuedResources:input_type -> google.cloud.securitycenter.v1.ListValuedResourcesRequest
	37,  // 151: google.cloud.securitycenter.v1.SecurityCenter.ListAttackPaths:input_type -> google.cloud.securitycenter.v1.ListAttackPathsRequest
	128, // 152: google.cloud.securitycenter.v1.SecurityCenter.BulkMuteFindings:output_type -> google.longrunning.Operation
	97,  // 153: google.cloud.securitycenter.v1.SecurityCenter.CreateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	98,  // 154: google.cloud.securitycenter.v1.SecurityCenter.CreateSource:output_type -> google.cloud.securitycenter.v1.Source
	92,  // 155: google.cloud.securitycenter.v1.SecurityCenter.CreateFinding:output_type -> google.cloud.securitycenter.v1.Finding
	93,  // 156: google.cloud.securitycenter.v1.SecurityCenter.CreateMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	96,  // 157: google.cloud.securitycenter.v1.SecurityCenter.CreateNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	123, // 158: google.cloud.securitycenter.v1.SecurityCenter.DeleteMuteConfig:output_type -> google.protobuf.Empty
	123, // 159: google.cloud.securitycenter.v1.SecurityCenter.DeleteNotificationConfig:output_type -> google.protobuf.Empty
	123, // 160: google.cloud.securitycenter.v1.SecurityCenter.DeleteSecurityHealthAnalyticsCustomModule:output_type -> google.protobuf.Empty
	129, // 161: google.cloud.securitycenter.v1.SecurityCenter.GetSimulation:output_type -> google.cloud.securitycenter.v1.Simulation
	101, // 162: google.cloud.securitycenter.v1.SecurityCenter.GetValuedResource:output_type -> google.cloud.securitycenter.v1.ValuedResource
	110, // 163: google.cloud.securitycenter.v1.SecurityCenter.GetBigQueryExport:output_type -> google.cloud.securitycenter.v1.BigQueryExport
	122, // 164: google.cloud.securitycenter.v1.SecurityCenter.GetIamPolicy:output_type -> google.iam.v1.Policy
	93,  // 165: google.cloud.securitycenter.v1.SecurityCenter.GetMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	96,  // 166: google.cloud.securitycenter.v1.SecurityCenter.GetNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	108, // 167: google.cloud.securitycenter.v1.SecurityCenter.GetOrganizationSettings:output_type -> google.cloud.securitycenter.v1.OrganizationSettings
	103, // 168: google.cloud.securitycenter.v1.SecurityCenter.GetEffectiveSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycenter.v1.EffectiveSecurityHealthAnalyticsCustomModule
	97,  // 169: google.cloud.securitycenter.v1.SecurityCenter.GetSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	98,  // 170: google.cloud.securitycenter.v1.SecurityCenter.GetSource:output_type -> google.cloud.securitycenter.v1.Source
	29,  // 171: google.cloud.securitycenter.v1.SecurityCenter.GroupAssets:output_type -> google.cloud.securitycenter.v1.GroupAssetsResponse
	31,  // 172: google.cloud.securitycenter.v1.SecurityCenter.GroupFindings:output_type -> google.cloud.securitycenter.v1.GroupFindingsResponse
	52,  // 173: google.cloud.securitycenter.v1.SecurityCenter.ListAssets:output_type -> google.cloud.securitycenter.v1.ListAssetsResponse
	34,  // 174: google.cloud.securitycenter.v1.SecurityCenter.ListDescendantSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycenter.v1.ListDescendantSecurityHealthAnalyticsCustomModulesResponse
	54,  // 175: google.cloud.securitycenter.v1.SecurityCenter.ListFindings:output_type -> google.cloud.securitycenter.v1.ListFindingsResponse
	42,  // 176: google.cloud.securitycenter.v1.SecurityCenter.ListMuteConfigs:output_type -> google.cloud.securitycenter.v1.ListMuteConfigsResponse
	44,  // 177: google.cloud.securitycenter.v1.SecurityCenter.ListNotificationConfigs:output_type -> google.cloud.securitycenter.v1.ListNotificationConfigsResponse
	46,  // 178: google.cloud.securitycenter.v1.SecurityCenter.ListEffectiveSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycenter.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesResponse
	48,  // 179: google.cloud.securitycenter.v1.SecurityCenter.ListSecurityHealthAnalyticsCustomModules:output_type -> google.cloud.securitycenter.v1.ListSecurityHealthAnalyticsCustomModulesResponse
	50,  // 180: google.cloud.securitycenter.v1.SecurityCenter.ListSources:output_type -> google.cloud.securitycenter.v1.ListSourcesResponse
	128, // 181: google.cloud.securitycenter.v1.SecurityCenter.RunAssetDiscovery:output_type -> google.longrunning.Operation
	92,  // 182: google.cloud.securitycenter.v1.SecurityCenter.SetFindingState:output_type -> google.cloud.securitycenter.v1.Finding
	92,  // 183: google.cloud.securitycenter.v1.SecurityCenter.SetMute:output_type -> google.cloud.securitycenter.v1.Finding
	122, // 184: google.cloud.securitycenter.v1.SecurityCenter.SetIamPolicy:output_type -> google.iam.v1.Policy
	130, // 185: google.cloud.securitycenter.v1.SecurityCenter.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	59,  // 186: google.cloud.securitycenter.v1.SecurityCenter.SimulateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycenter.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse
	107, // 187: google.cloud.securitycenter.v1.SecurityCenter.UpdateExternalSystem:output_type -> google.cloud.securitycenter.v1.ExternalSystem
	92,  // 188: google.cloud.securitycenter.v1.SecurityCenter.UpdateFinding:output_type -> google.cloud.securitycenter.v1.Finding
	93,  // 189: google.cloud.securitycenter.v1.SecurityCenter.UpdateMuteConfig:output_type -> google.cloud.securitycenter.v1.MuteConfig
	96,  // 190: google.cloud.securitycenter.v1.SecurityCenter.UpdateNotificationConfig:output_type -> google.cloud.securitycenter.v1.NotificationConfig
	108, // 191: google.cloud.securitycenter.v1.SecurityCenter.UpdateOrganizationSettings:output_type -> google.cloud.securitycenter.v1.OrganizationSettings
	97,  // 192: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityHealthAnalyticsCustomModule:output_type -> google.cloud.securitycenter.v1.SecurityHealthAnalyticsCustomModule
	98,  // 193: google.cloud.securitycenter.v1.SecurityCenter.UpdateSource:output_type -> google.cloud.securitycenter.v1.Source
	109, // 194: google.cloud.securitycenter.v1.SecurityCenter.UpdateSecurityMarks:output_type -> google.cloud.securitycenter.v1.SecurityMarks
	110, // 195: google.cloud.securitycenter.v1.SecurityCenter.CreateBigQueryExport:output_type -> google.cloud.securitycenter.v1.BigQueryExport
	123, // 196: google.cloud.securitycenter.v1.SecurityCenter.DeleteBigQueryExport:output_type -> google.protobuf.Empty
	110, // 197: google.cloud.securitycenter.v1.SecurityCenter.UpdateBigQueryExport:output_type -> google.cloud.securitycenter.v1.BigQueryExport
	71,  // 198: google.cloud.securitycenter.v1.SecurityCenter.ListBigQueryExports:output_type -> google.cloud.securitycenter.v1.ListBigQueryExportsResponse
	111, // 199: google.cloud.securitycenter.v1.SecurityCenter.CreateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	123, // 200: google.cloud.securitycenter.v1.SecurityCenter.DeleteEventThreatDetectionCustomModule:output_type -> google.protobuf.Empty
	111, // 201: google.cloud.securitycenter.v1.SecurityCenter.GetEventThreatDetectionCustomModule:output_type -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	79,  // 202: google.cloud.securitycenter.v1.SecurityCenter.ListDescendantEventThreatDetectionCustomModules:output_type -> google.cloud.securitycenter.v1.ListDescendantEventThreatDetectionCustomModulesResponse
	81,  // 203: google.cloud.securitycenter.v1.SecurityCenter.ListEventThreatDetectionCustomModules:output_type -> google.cloud.securitycenter.v1.ListEventThreatDetectionCustomModulesResponse
	111, // 204: google.cloud.securitycenter.v1.SecurityCenter.UpdateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycenter.v1.EventThreatDetectionCustomModule
	75,  // 205: google.cloud.securitycenter.v1.SecurityCenter.ValidateEventThreatDetectionCustomModule:output_type -> google.cloud.securitycenter.v1.ValidateEventThreatDetectionCustomModuleResponse
	113, // 206: google.cloud.securitycenter.v1.SecurityCenter.GetEffectiveEventThreatDetectionCustomModule:output_type -> google.cloud.securitycenter.v1.EffectiveEventThreatDetectionCustomModule
	85,  // 207: google.cloud.securitycenter.v1.SecurityCenter.ListEffectiveEventThreatDetectionCustomModules:output_type -> google.cloud.securitycenter.v1.ListEffectiveEventThreatDetectionCustomModulesResponse
	9,   // 208: google.cloud.securitycenter.v1.SecurityCenter.BatchCreateResourceValueConfigs:output_type -> google.cloud.securitycenter.v1.BatchCreateResourceValueConfigsResponse
	123, // 209: google.cloud.securitycenter.v1.SecurityCenter.DeleteResourceValueConfig:output_type -> google.protobuf.Empty
	94,  // 210: google.cloud.securitycenter.v1.SecurityCenter.GetResourceValueConfig:output_type -> google.cloud.securitycenter.v1.ResourceValueConfig
	13,  // 211: google.cloud.securitycenter.v1.SecurityCenter.ListResourceValueConfigs:output_type -> google.cloud.securitycenter.v1.ListResourceValueConfigsResponse
	94,  // 212: google.cloud.securitycenter.v1.SecurityCenter.UpdateResourceValueConfig:output_type -> google.cloud.securitycenter.v1.ResourceValueConfig
	36,  // 213: google.cloud.securitycenter.v1.SecurityCenter.ListValuedResources:output_type -> google.cloud.securitycenter.v1.ListValuedResourcesResponse
	38,  // 214: google.cloud.securitycenter.v1.SecurityCenter.ListAttackPaths:output_type -> google.cloud.securitycenter.v1.ListAttackPathsResponse
	152, // [152:215] is the sub-list for method output_type
	89,  // [89:152] is the sub-list for method input_type
	89,  // [89:89] is the sub-list for extension type_name
	89,  // [89:89] is the sub-list for extension extendee
	0,   // [0:89] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v1_securitycenter_service_proto_init() }
func file_google_cloud_securitycenter_v1_securitycenter_service_proto_init() {
	if File_google_cloud_securitycenter_v1_securitycenter_service_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v1_asset_proto_init()
	file_google_cloud_securitycenter_v1_attack_path_proto_init()
	file_google_cloud_securitycenter_v1_bigquery_export_proto_init()
	file_google_cloud_securitycenter_v1_effective_event_threat_detection_custom_module_proto_init()
	file_google_cloud_securitycenter_v1_effective_security_health_analytics_custom_module_proto_init()
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_proto_init()
	file_google_cloud_securitycenter_v1_event_threat_detection_custom_module_validation_errors_proto_init()
	file_google_cloud_securitycenter_v1_external_system_proto_init()
	file_google_cloud_securitycenter_v1_finding_proto_init()
	file_google_cloud_securitycenter_v1_folder_proto_init()
	file_google_cloud_securitycenter_v1_mute_config_proto_init()
	file_google_cloud_securitycenter_v1_notification_config_proto_init()
	file_google_cloud_securitycenter_v1_organization_settings_proto_init()
	file_google_cloud_securitycenter_v1_resource_proto_init()
	file_google_cloud_securitycenter_v1_resource_value_config_proto_init()
	file_google_cloud_securitycenter_v1_run_asset_discovery_response_proto_init()
	file_google_cloud_securitycenter_v1_security_health_analytics_custom_config_proto_init()
	file_google_cloud_securitycenter_v1_security_health_analytics_custom_module_proto_init()
	file_google_cloud_securitycenter_v1_security_marks_proto_init()
	file_google_cloud_securitycenter_v1_simulation_proto_init()
	file_google_cloud_securitycenter_v1_source_proto_init()
	file_google_cloud_securitycenter_v1_valued_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*BulkMuteFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*BulkMuteFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*CreateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*CreateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreateResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateResourceValueConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BatchCreateResourceValueConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*GetResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ListResourceValueConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListResourceValueConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateResourceValueConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*CreateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*CreateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*CreateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*GetBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*GetMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*GetNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*GetOrganizationSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*GetSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*GetSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*GroupAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*GroupAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*GroupFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*GroupFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*GroupResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[31].Exporter = func(v any, i int) any {
			switch v := v.(*ListDescendantSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[32].Exporter = func(v any, i int) any {
			switch v := v.(*ListValuedResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[33].Exporter = func(v any, i int) any {
			switch v := v.(*ListValuedResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[34].Exporter = func(v any, i int) any {
			switch v := v.(*ListAttackPathsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*ListAttackPathsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[36].Exporter = func(v any, i int) any {
			switch v := v.(*GetSimulationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[37].Exporter = func(v any, i int) any {
			switch v := v.(*GetValuedResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[38].Exporter = func(v any, i int) any {
			switch v := v.(*ListMuteConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[39].Exporter = func(v any, i int) any {
			switch v := v.(*ListMuteConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[40].Exporter = func(v any, i int) any {
			switch v := v.(*ListNotificationConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[41].Exporter = func(v any, i int) any {
			switch v := v.(*ListNotificationConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[42].Exporter = func(v any, i int) any {
			switch v := v.(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[43].Exporter = func(v any, i int) any {
			switch v := v.(*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[44].Exporter = func(v any, i int) any {
			switch v := v.(*ListSecurityHealthAnalyticsCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[45].Exporter = func(v any, i int) any {
			switch v := v.(*ListSecurityHealthAnalyticsCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[46].Exporter = func(v any, i int) any {
			switch v := v.(*ListSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[47].Exporter = func(v any, i int) any {
			switch v := v.(*ListSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[48].Exporter = func(v any, i int) any {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[49].Exporter = func(v any, i int) any {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[50].Exporter = func(v any, i int) any {
			switch v := v.(*ListFindingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[51].Exporter = func(v any, i int) any {
			switch v := v.(*ListFindingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[52].Exporter = func(v any, i int) any {
			switch v := v.(*SetFindingStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[53].Exporter = func(v any, i int) any {
			switch v := v.(*SetMuteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[54].Exporter = func(v any, i int) any {
			switch v := v.(*RunAssetDiscoveryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[55].Exporter = func(v any, i int) any {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[56].Exporter = func(v any, i int) any {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[57].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateExternalSystemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[58].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateFindingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[59].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateMuteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[60].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateNotificationConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[61].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateOrganizationSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[62].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateSecurityHealthAnalyticsCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[63].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[64].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateSecurityMarksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[65].Exporter = func(v any, i int) any {
			switch v := v.(*CreateBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[66].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[67].Exporter = func(v any, i int) any {
			switch v := v.(*ListBigQueryExportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[68].Exporter = func(v any, i int) any {
			switch v := v.(*ListBigQueryExportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[69].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteBigQueryExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[70].Exporter = func(v any, i int) any {
			switch v := v.(*CreateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[71].Exporter = func(v any, i int) any {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[72].Exporter = func(v any, i int) any {
			switch v := v.(*ValidateEventThreatDetectionCustomModuleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[73].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[74].Exporter = func(v any, i int) any {
			switch v := v.(*GetEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[75].Exporter = func(v any, i int) any {
			switch v := v.(*ListDescendantEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[76].Exporter = func(v any, i int) any {
			switch v := v.(*ListDescendantEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[77].Exporter = func(v any, i int) any {
			switch v := v.(*ListEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[78].Exporter = func(v any, i int) any {
			switch v := v.(*ListEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[79].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[80].Exporter = func(v any, i int) any {
			switch v := v.(*GetEffectiveEventThreatDetectionCustomModuleRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[81].Exporter = func(v any, i int) any {
			switch v := v.(*ListEffectiveEventThreatDetectionCustomModulesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[82].Exporter = func(v any, i int) any {
			switch v := v.(*ListEffectiveEventThreatDetectionCustomModulesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[84].Exporter = func(v any, i int) any {
			switch v := v.(*ListAssetsResponse_ListAssetsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[85].Exporter = func(v any, i int) any {
			switch v := v.(*ListFindingsResponse_ListFindingsResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[86].Exporter = func(v any, i int) any {
			switch v := v.(*ListFindingsResponse_ListFindingsResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[87].Exporter = func(v any, i int) any {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleRequest_SimulatedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[88].Exporter = func(v any, i int) any {
			switch v := v.(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[86].OneofWrappers = []any{
		(*ListFindingsResponse_ListFindingsResult_Resource_AwsMetadata)(nil),
		(*ListFindingsResponse_ListFindingsResult_Resource_AzureMetadata)(nil),
	}
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes[88].OneofWrappers = []any{
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Finding)(nil),
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_NoViolation)(nil),
		(*SimulateSecurityHealthAnalyticsCustomModuleResponse_SimulatedResult_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   89,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v1_securitycenter_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v1_securitycenter_service_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v1_securitycenter_service_proto = out.File
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_rawDesc = nil
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_goTypes = nil
	file_google_cloud_securitycenter_v1_securitycenter_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error)
	// Gets a BigQuery export.
	GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets a mute config.
	GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Deprecated: Do not use.
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Deprecated: Do not use.
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent’s CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error)
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors.
	ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors.
	ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Deprecated: Do not use.
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error)
	// Gets an effective Event Threat Detection custom module at the given level.
	GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error)
}

type securityCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityCenterClient(cc grpc.ClientConnInterface) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) BulkMuteFindings(ctx context.Context, in *BulkMuteFindingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/BulkMuteFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *CreateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateMuteConfig(ctx context.Context, in *CreateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateNotificationConfig(ctx context.Context, in *CreateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteMuteConfig(ctx context.Context, in *DeleteMuteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteNotificationConfig(ctx context.Context, in *DeleteNotificationConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteSecurityHealthAnalyticsCustomModule(ctx context.Context, in *DeleteSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSimulation(ctx context.Context, in *GetSimulationRequest, opts ...grpc.CallOption) (*Simulation, error) {
	out := new(Simulation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetSimulation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetValuedResource(ctx context.Context, in *GetValuedResourceRequest, opts ...grpc.CallOption) (*ValuedResource, error) {
	out := new(ValuedResource)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetValuedResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetBigQueryExport(ctx context.Context, in *GetBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetMuteConfig(ctx context.Context, in *GetMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetNotificationConfig(ctx context.Context, in *GetNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEffectiveSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	out := new(EffectiveSecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSecurityHealthAnalyticsCustomModule(ctx context.Context, in *GetSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListDescendantSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListDescendantSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListDescendantSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListMuteConfigs(ctx context.Context, in *ListMuteConfigsRequest, opts ...grpc.CallOption) (*ListMuteConfigsResponse, error) {
	out := new(ListMuteConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListMuteConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListNotificationConfigs(ctx context.Context, in *ListNotificationConfigsRequest, opts ...grpc.CallOption) (*ListNotificationConfigsResponse, error) {
	out := new(ListNotificationConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListNotificationConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEffectiveSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListEffectiveSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSecurityHealthAnalyticsCustomModules(ctx context.Context, in *ListSecurityHealthAnalyticsCustomModulesRequest, opts ...grpc.CallOption) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	out := new(ListSecurityHealthAnalyticsCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListSecurityHealthAnalyticsCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetMute(ctx context.Context, in *SetMuteRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetMute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SimulateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *SimulateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	out := new(SimulateSecurityHealthAnalyticsCustomModuleResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SimulateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateExternalSystem(ctx context.Context, in *UpdateExternalSystemRequest, opts ...grpc.CallOption) (*ExternalSystem, error) {
	out := new(ExternalSystem)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateExternalSystem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateMuteConfig(ctx context.Context, in *UpdateMuteConfigRequest, opts ...grpc.CallOption) (*MuteConfig, error) {
	out := new(MuteConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateMuteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateNotificationConfig(ctx context.Context, in *UpdateNotificationConfigRequest, opts ...grpc.CallOption) (*NotificationConfig, error) {
	out := new(NotificationConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateNotificationConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityHealthAnalyticsCustomModule(ctx context.Context, in *UpdateSecurityHealthAnalyticsCustomModuleRequest, opts ...grpc.CallOption) (*SecurityHealthAnalyticsCustomModule, error) {
	out := new(SecurityHealthAnalyticsCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityHealthAnalyticsCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateBigQueryExport(ctx context.Context, in *CreateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteBigQueryExport(ctx context.Context, in *DeleteBigQueryExportRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateBigQueryExport(ctx context.Context, in *UpdateBigQueryExportRequest, opts ...grpc.CallOption) (*BigQueryExport, error) {
	out := new(BigQueryExport)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateBigQueryExport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListBigQueryExports(ctx context.Context, in *ListBigQueryExportsRequest, opts ...grpc.CallOption) (*ListBigQueryExportsResponse, error) {
	out := new(ListBigQueryExportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListBigQueryExports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateEventThreatDetectionCustomModule(ctx context.Context, in *CreateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteEventThreatDetectionCustomModule(ctx context.Context, in *DeleteEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEventThreatDetectionCustomModule(ctx context.Context, in *GetEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListDescendantEventThreatDetectionCustomModules(ctx context.Context, in *ListDescendantEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListDescendantEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEventThreatDetectionCustomModules(ctx context.Context, in *ListEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateEventThreatDetectionCustomModule(ctx context.Context, in *UpdateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EventThreatDetectionCustomModule, error) {
	out := new(EventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ValidateEventThreatDetectionCustomModule(ctx context.Context, in *ValidateEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	out := new(ValidateEventThreatDetectionCustomModuleResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ValidateEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetEffectiveEventThreatDetectionCustomModule(ctx context.Context, in *GetEffectiveEventThreatDetectionCustomModuleRequest, opts ...grpc.CallOption) (*EffectiveEventThreatDetectionCustomModule, error) {
	out := new(EffectiveEventThreatDetectionCustomModule)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveEventThreatDetectionCustomModule", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListEffectiveEventThreatDetectionCustomModules(ctx context.Context, in *ListEffectiveEventThreatDetectionCustomModulesRequest, opts ...grpc.CallOption) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	out := new(ListEffectiveEventThreatDetectionCustomModulesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveEventThreatDetectionCustomModules", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) BatchCreateResourceValueConfigs(ctx context.Context, in *BatchCreateResourceValueConfigsRequest, opts ...grpc.CallOption) (*BatchCreateResourceValueConfigsResponse, error) {
	out := new(BatchCreateResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/BatchCreateResourceValueConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) DeleteResourceValueConfig(ctx context.Context, in *DeleteResourceValueConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/DeleteResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetResourceValueConfig(ctx context.Context, in *GetResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListResourceValueConfigs(ctx context.Context, in *ListResourceValueConfigsRequest, opts ...grpc.CallOption) (*ListResourceValueConfigsResponse, error) {
	out := new(ListResourceValueConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListResourceValueConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateResourceValueConfig(ctx context.Context, in *UpdateResourceValueConfigRequest, opts ...grpc.CallOption) (*ResourceValueConfig, error) {
	out := new(ResourceValueConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateResourceValueConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListValuedResources(ctx context.Context, in *ListValuedResourcesRequest, opts ...grpc.CallOption) (*ListValuedResourcesResponse, error) {
	out := new(ListValuedResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListValuedResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAttackPaths(ctx context.Context, in *ListAttackPathsRequest, opts ...grpc.CallOption) (*ListAttackPathsResponse, error) {
	out := new(ListAttackPathsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListAttackPaths", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
type SecurityCenterServer interface {
	// Kicks off an LRO to bulk mute findings for a parent based on a filter. The
	// parent can be either an organization, folder or project. The findings
	// matched by the filter will be muted after the LRO is done.
	BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error)
	// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
	// given CRM parent, and also creates inherited
	// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
	// parent. These modules are enabled by default.
	CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Creates a mute config.
	CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error)
	// Creates a notification config.
	CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error)
	// Deletes an existing mute config.
	DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error)
	// Deletes a notification config.
	DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error)
	// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
	// descendants in the CRM hierarchy. This method is only supported for
	// resident custom modules.
	DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error)
	// Get the simulation by name or the latest simulation for the given
	// organization.
	GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error)
	// Get the valued resource by name
	GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error)
	// Gets a BigQuery export.
	GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Gets a mute config.
	GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error)
	// Gets a notification config.
	GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Retrieves an EffectiveSecurityHealthAnalyticsCustomModule.
	GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error)
	// Retrieves a SecurityHealthAnalyticsCustomModule.
	GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Deprecated: Do not use.
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings,
	// /v1/folders/{folder_id}/sources/-/findings,
	// /v1/projects/{project_id}/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Deprecated: Do not use.
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
	// the given CRM parent and all of the parent’s CRM descendants.
	ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/{organization_id}/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists mute configs.
	ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error)
	// Lists notification configs.
	ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error)
	// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent, and inherited modules, inherited from CRM ancestors.
	ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error)
	// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
	// parent. This includes resident modules defined at the scope of the parent,
	// and inherited modules, inherited from CRM ancestors.
	ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Deprecated: Do not use.
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error)
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Updates the mute state of a finding.
	SetMute(context.Context, *SetMuteRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
	SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error)
	// Updates external system. This is for a given finding.
	UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates a mute config.
	UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error)
	// Updates a notification config. The following update
	// fields are allowed: description, pubsub_topic, streaming_config.filter
	UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates the SecurityHealthAnalyticsCustomModule under the given name based
	// on the given update mask. Updating the enablement state is supported on
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name and custom
	// config of a module is supported on resident modules only.
	UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
	// Creates a BigQuery export.
	CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error)
	// Deletes an existing BigQuery export.
	DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error)
	// Updates a BigQuery export.
	UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error)
	// Lists BigQuery exports. Note that when requesting BigQuery exports at a
	// given level all exports under that level are also returned e.g. if
	// requesting BigQuery exports under a folder, then all BigQuery exports
	// immediately under the folder plus the ones created under the projects
	// within the folder are returned.
	ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error)
	// Creates a resident Event Threat Detection custom module at the scope of the
	// given Resource Manager parent, and also creates inherited custom modules
	// for all descendants of the given parent. These modules are enabled by
	// default.
	CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Deletes the specified Event Threat Detection custom module and all of its
	// descendants in the Resource Manager hierarchy. This method is only
	// supported for resident custom modules.
	DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error)
	// Gets an Event Threat Detection custom module.
	GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Lists all resident Event Threat Detection custom modules under the
	// given Resource Manager parent and its descendants.
	ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error)
	// Lists all Event Threat Detection custom modules for the given
	// Resource Manager parent. This includes resident modules defined at the
	// scope of the parent along with modules inherited from ancestors.
	ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error)
	// Updates the Event Threat Detection custom module with the given name based
	// on the given update mask. Updating the enablement state is supported for
	// both resident and inherited modules (though resident modules cannot have an
	// enablement state of "inherited"). Updating the display name or
	// configuration of a module is supported for resident modules only. The type
	// of a module cannot be changed.
	UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error)
	// Validates the given Event Threat Detection custom module.
	ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error)
	// Gets an effective Event Threat Detection custom module at the given level.
	GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error)
	// Lists all effective Event Threat Detection custom modules for the
	// given parent. This includes resident modules defined at the scope of the
	// parent along with modules inherited from its ancestors.
	ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error)
	// Creates a ResourceValueConfig for an organization. Maps user's tags to
	// difference resource values for use by the attack path simulation.
	BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error)
	// Deletes a ResourceValueConfig.
	DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error)
	// Gets a ResourceValueConfig.
	GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Lists all ResourceValueConfigs.
	ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error)
	// Updates an existing ResourceValueConfigs with new rules.
	UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error)
	// Lists the valued resources for a set of simulation results and filter.
	ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error)
	// Lists the attack paths for a set of simulation results or valued resources
	// and filter.
	ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error)
}

// UnimplementedSecurityCenterServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityCenterServer struct {
}

func (*UnimplementedSecurityCenterServer) BulkMuteFindings(context.Context, *BulkMuteFindingsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BulkMuteFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateSecurityHealthAnalyticsCustomModule(context.Context, *CreateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*Source, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateMuteConfig(context.Context, *CreateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateNotificationConfig(context.Context, *CreateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteMuteConfig(context.Context, *DeleteMuteConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteNotificationConfig(context.Context, *DeleteNotificationConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteSecurityHealthAnalyticsCustomModule(context.Context, *DeleteSecurityHealthAnalyticsCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSimulation(context.Context, *GetSimulationRequest) (*Simulation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSimulation not implemented")
}
func (*UnimplementedSecurityCenterServer) GetValuedResource(context.Context, *GetValuedResourceRequest) (*ValuedResource, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetValuedResource not implemented")
}
func (*UnimplementedSecurityCenterServer) GetBigQueryExport(context.Context, *GetBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) GetMuteConfig(context.Context, *GetMuteConfigRequest) (*MuteConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetNotificationConfig(context.Context, *GetNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) GetEffectiveSecurityHealthAnalyticsCustomModule(context.Context, *GetEffectiveSecurityHealthAnalyticsCustomModuleRequest) (*EffectiveSecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEffectiveSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSecurityHealthAnalyticsCustomModule(context.Context, *GetSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GroupAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GroupFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedSecurityCenterServer) ListDescendantSecurityHealthAnalyticsCustomModules(context.Context, *ListDescendantSecurityHealthAnalyticsCustomModulesRequest) (*ListDescendantSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDescendantSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListFindings not implemented")
}
func (*UnimplementedSecurityCenterServer) ListMuteConfigs(context.Context, *ListMuteConfigsRequest) (*ListMuteConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListMuteConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListNotificationConfigs(context.Context, *ListNotificationConfigsRequest) (*ListNotificationConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListNotificationConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) ListEffectiveSecurityHealthAnalyticsCustomModules(context.Context, *ListEffectiveSecurityHealthAnalyticsCustomModulesRequest) (*ListEffectiveSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEffectiveSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) ListSecurityHealthAnalyticsCustomModules(context.Context, *ListSecurityHealthAnalyticsCustomModulesRequest) (*ListSecurityHealthAnalyticsCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSecurityHealthAnalyticsCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedSecurityCenterServer) RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RunAssetDiscovery not implemented")
}
func (*UnimplementedSecurityCenterServer) SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetFindingState not implemented")
}
func (*UnimplementedSecurityCenterServer) SetMute(context.Context, *SetMuteRequest) (*Finding, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetMute not implemented")
}
func (*UnimplementedSecurityCenterServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSecurityCenterServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedSecurityCenterServer) SimulateSecurityHealthAnalyticsCustomModule(context.Context, *SimulateSecurityHealthAnalyticsCustomModuleRequest) (*SimulateSecurityHealthAnalyticsCustomModuleResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SimulateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateExternalSystem(context.Context, *UpdateExternalSystemRequest) (*ExternalSystem, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateExternalSystem not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateFinding not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateMuteConfig(context.Context, *UpdateMuteConfigRequest) (*MuteConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateMuteConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateNotificationConfig(context.Context, *UpdateNotificationConfigRequest) (*NotificationConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateNotificationConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateOrganizationSettings not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSecurityHealthAnalyticsCustomModule(context.Context, *UpdateSecurityHealthAnalyticsCustomModuleRequest) (*SecurityHealthAnalyticsCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSecurityHealthAnalyticsCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSecurityMarks not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateBigQueryExport(context.Context, *CreateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteBigQueryExport(context.Context, *DeleteBigQueryExportRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateBigQueryExport(context.Context, *UpdateBigQueryExportRequest) (*BigQueryExport, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateBigQueryExport not implemented")
}
func (*UnimplementedSecurityCenterServer) ListBigQueryExports(context.Context, *ListBigQueryExportsRequest) (*ListBigQueryExportsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListBigQueryExports not implemented")
}
func (*UnimplementedSecurityCenterServer) CreateEventThreatDetectionCustomModule(context.Context, *CreateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteEventThreatDetectionCustomModule(context.Context, *DeleteEventThreatDetectionCustomModuleRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) GetEventThreatDetectionCustomModule(context.Context, *GetEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) ListDescendantEventThreatDetectionCustomModules(context.Context, *ListDescendantEventThreatDetectionCustomModulesRequest) (*ListDescendantEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDescendantEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) ListEventThreatDetectionCustomModules(context.Context, *ListEventThreatDetectionCustomModulesRequest) (*ListEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateEventThreatDetectionCustomModule(context.Context, *UpdateEventThreatDetectionCustomModuleRequest) (*EventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) ValidateEventThreatDetectionCustomModule(context.Context, *ValidateEventThreatDetectionCustomModuleRequest) (*ValidateEventThreatDetectionCustomModuleResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ValidateEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) GetEffectiveEventThreatDetectionCustomModule(context.Context, *GetEffectiveEventThreatDetectionCustomModuleRequest) (*EffectiveEventThreatDetectionCustomModule, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEffectiveEventThreatDetectionCustomModule not implemented")
}
func (*UnimplementedSecurityCenterServer) ListEffectiveEventThreatDetectionCustomModules(context.Context, *ListEffectiveEventThreatDetectionCustomModulesRequest) (*ListEffectiveEventThreatDetectionCustomModulesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEffectiveEventThreatDetectionCustomModules not implemented")
}
func (*UnimplementedSecurityCenterServer) BatchCreateResourceValueConfigs(context.Context, *BatchCreateResourceValueConfigsRequest) (*BatchCreateResourceValueConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCreateResourceValueConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) DeleteResourceValueConfig(context.Context, *DeleteResourceValueConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) GetResourceValueConfig(context.Context, *GetResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) ListResourceValueConfigs(context.Context, *ListResourceValueConfigsRequest) (*ListResourceValueConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListResourceValueConfigs not implemented")
}
func (*UnimplementedSecurityCenterServer) UpdateResourceValueConfig(context.Context, *UpdateResourceValueConfigRequest) (*ResourceValueConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateResourceValueConfig not implemented")
}
func (*UnimplementedSecurityCenterServer) ListValuedResources(context.Context, *ListValuedResourcesRequest) (*ListValuedResourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListValuedResources not implemented")
}
func (*UnimplementedSecurityCenterServer) ListAttackPaths(context.Context, *ListAttackPathsRequest) (*ListAttackPathsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAttackPaths not implemented")
}

func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	s.RegisterService(&_SecurityCenter_serviceDesc, srv)
}

func _SecurityCenter_BulkMuteFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkMuteFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/BulkMuteFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BulkMuteFindings(ctx, req.(*BulkMuteFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSecurityHealthAnalyticsCustomModule(ctx, req.(*CreateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateMuteConfig(ctx, req.(*CreateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateNotificationConfig(ctx, req.(*CreateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteMuteConfig(ctx, req.(*DeleteMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteNotificationConfig(ctx, req.(*DeleteNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteSecurityHealthAnalyticsCustomModule(ctx, req.(*DeleteSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSimulation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSimulationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSimulation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetSimulation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSimulation(ctx, req.(*GetSimulationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetValuedResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValuedResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetValuedResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetValuedResource(ctx, req.(*GetValuedResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetBigQueryExport(ctx, req.(*GetBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetMuteConfig(ctx, req.(*GetMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetNotificationConfig(ctx, req.(*GetNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEffectiveSecurityHealthAnalyticsCustomModule(ctx, req.(*GetEffectiveSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSecurityHealthAnalyticsCustomModule(ctx, req.(*GetSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListDescendantSecurityHealthAnalyticsCustomModules(ctx, req.(*ListDescendantSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListMuteConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMuteConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListMuteConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListMuteConfigs(ctx, req.(*ListMuteConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListNotificationConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListNotificationConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListNotificationConfigs(ctx, req.(*ListNotificationConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEffectiveSecurityHealthAnalyticsCustomModules(ctx, req.(*ListEffectiveSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSecurityHealthAnalyticsCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecurityHealthAnalyticsCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSecurityHealthAnalyticsCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListSecurityHealthAnalyticsCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSecurityHealthAnalyticsCustomModules(ctx, req.(*ListSecurityHealthAnalyticsCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetMute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetMute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetMute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetMute(ctx, req.(*SetMuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SimulateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SimulateSecurityHealthAnalyticsCustomModule(ctx, req.(*SimulateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateExternalSystem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExternalSystemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateExternalSystem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateExternalSystem(ctx, req.(*UpdateExternalSystemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateMuteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMuteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateMuteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateMuteConfig(ctx, req.(*UpdateMuteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateNotificationConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateNotificationConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateNotificationConfig(ctx, req.(*UpdateNotificationConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityHealthAnalyticsCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityHealthAnalyticsCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityHealthAnalyticsCustomModule(ctx, req.(*UpdateSecurityHealthAnalyticsCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateBigQueryExport(ctx, req.(*CreateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteBigQueryExport(ctx, req.(*DeleteBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateBigQueryExport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBigQueryExportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateBigQueryExport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateBigQueryExport(ctx, req.(*UpdateBigQueryExportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListBigQueryExports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBigQueryExportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListBigQueryExports",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListBigQueryExports(ctx, req.(*ListBigQueryExportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateEventThreatDetectionCustomModule(ctx, req.(*CreateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteEventThreatDetectionCustomModule(ctx, req.(*DeleteEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEventThreatDetectionCustomModule(ctx, req.(*GetEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListDescendantEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDescendantEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListDescendantEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListDescendantEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListDescendantEventThreatDetectionCustomModules(ctx, req.(*ListDescendantEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEventThreatDetectionCustomModules(ctx, req.(*ListEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateEventThreatDetectionCustomModule(ctx, req.(*UpdateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ValidateEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ValidateEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ValidateEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ValidateEventThreatDetectionCustomModule(ctx, req.(*ValidateEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveEventThreatDetectionCustomModuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetEffectiveEventThreatDetectionCustomModule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetEffectiveEventThreatDetectionCustomModule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetEffectiveEventThreatDetectionCustomModule(ctx, req.(*GetEffectiveEventThreatDetectionCustomModuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveEventThreatDetectionCustomModulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListEffectiveEventThreatDetectionCustomModules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListEffectiveEventThreatDetectionCustomModules",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListEffectiveEventThreatDetectionCustomModules(ctx, req.(*ListEffectiveEventThreatDetectionCustomModulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_BatchCreateResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/BatchCreateResourceValueConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).BatchCreateResourceValueConfigs(ctx, req.(*BatchCreateResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_DeleteResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/DeleteResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).DeleteResourceValueConfig(ctx, req.(*DeleteResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetResourceValueConfig(ctx, req.(*GetResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListResourceValueConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourceValueConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListResourceValueConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListResourceValueConfigs(ctx, req.(*ListResourceValueConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateResourceValueConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateResourceValueConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateResourceValueConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateResourceValueConfig(ctx, req.(*UpdateResourceValueConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListValuedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListValuedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListValuedResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListValuedResources(ctx, req.(*ListValuedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAttackPaths_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttackPathsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListAttackPaths",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAttackPaths(ctx, req.(*ListAttackPathsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BulkMuteFindings",
			Handler:    _SecurityCenter_BulkMuteFindings_Handler,
		},
		{
			MethodName: "CreateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_CreateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "CreateMuteConfig",
			Handler:    _SecurityCenter_CreateMuteConfig_Handler,
		},
		{
			MethodName: "CreateNotificationConfig",
			Handler:    _SecurityCenter_CreateNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteMuteConfig",
			Handler:    _SecurityCenter_DeleteMuteConfig_Handler,
		},
		{
			MethodName: "DeleteNotificationConfig",
			Handler:    _SecurityCenter_DeleteNotificationConfig_Handler,
		},
		{
			MethodName: "DeleteSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_DeleteSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSimulation",
			Handler:    _SecurityCenter_GetSimulation_Handler,
		},
		{
			MethodName: "GetValuedResource",
			Handler:    _SecurityCenter_GetValuedResource_Handler,
		},
		{
			MethodName: "GetBigQueryExport",
			Handler:    _SecurityCenter_GetBigQueryExport_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetMuteConfig",
			Handler:    _SecurityCenter_GetMuteConfig_Handler,
		},
		{
			MethodName: "GetNotificationConfig",
			Handler:    _SecurityCenter_GetNotificationConfig_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetEffectiveSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_GetEffectiveSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_GetSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListDescendantSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListDescendantSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListMuteConfigs",
			Handler:    _SecurityCenter_ListMuteConfigs_Handler,
		},
		{
			MethodName: "ListNotificationConfigs",
			Handler:    _SecurityCenter_ListNotificationConfigs_Handler,
		},
		{
			MethodName: "ListEffectiveSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListEffectiveSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListSecurityHealthAnalyticsCustomModules",
			Handler:    _SecurityCenter_ListSecurityHealthAnalyticsCustomModules_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetMute",
			Handler:    _SecurityCenter_SetMute_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "SimulateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_SimulateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "UpdateExternalSystem",
			Handler:    _SecurityCenter_UpdateExternalSystem_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateMuteConfig",
			Handler:    _SecurityCenter_UpdateMuteConfig_Handler,
		},
		{
			MethodName: "UpdateNotificationConfig",
			Handler:    _SecurityCenter_UpdateNotificationConfig_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSecurityHealthAnalyticsCustomModule",
			Handler:    _SecurityCenter_UpdateSecurityHealthAnalyticsCustomModule_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
		{
			MethodName: "CreateBigQueryExport",
			Handler:    _SecurityCenter_CreateBigQueryExport_Handler,
		},
		{
			MethodName: "DeleteBigQueryExport",
			Handler:    _SecurityCenter_DeleteBigQueryExport_Handler,
		},
		{
			MethodName: "UpdateBigQueryExport",
			Handler:    _SecurityCenter_UpdateBigQueryExport_Handler,
		},
		{
			MethodName: "ListBigQueryExports",
			Handler:    _SecurityCenter_ListBigQueryExports_Handler,
		},
		{
			MethodName: "CreateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_CreateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "DeleteEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_DeleteEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "GetEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_GetEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ListDescendantEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListDescendantEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "ListEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "UpdateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_UpdateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ValidateEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_ValidateEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "GetEffectiveEventThreatDetectionCustomModule",
			Handler:    _SecurityCenter_GetEffectiveEventThreatDetectionCustomModule_Handler,
		},
		{
			MethodName: "ListEffectiveEventThreatDetectionCustomModules",
			Handler:    _SecurityCenter_ListEffectiveEventThreatDetectionCustomModules_Handler,
		},
		{
			MethodName: "BatchCreateResourceValueConfigs",
			Handler:    _SecurityCenter_BatchCreateResourceValueConfigs_Handler,
		},
		{
			MethodName: "DeleteResourceValueConfig",
			Handler:    _SecurityCenter_DeleteResourceValueConfig_Handler,
		},
		{
			MethodName: "GetResourceValueConfig",
			Handler:    _SecurityCenter_GetResourceValueConfig_Handler,
		},
		{
			MethodName: "ListResourceValueConfigs",
			Handler:    _SecurityCenter_ListResourceValueConfigs_Handler,
		},
		{
			MethodName: "UpdateResourceValueConfig",
			Handler:    _SecurityCenter_UpdateResourceValueConfig_Handler,
		},
		{
			MethodName: "ListValuedResources",
			Handler:    _SecurityCenter_ListValuedResources_Handler,
		},
		{
			MethodName: "ListAttackPaths",
			Handler:    _SecurityCenter_ListAttackPaths_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1/securitycenter_service.proto",
}
