// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudwatchlogs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchlogs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the execution history of a scheduled query within a specified time
// range, including execution status and destination processing metadata.
func (c *Client) GetScheduledQueryHistory(ctx context.Context, params *GetScheduledQueryHistoryInput, optFns ...func(*Options)) (*GetScheduledQueryHistoryOutput, error) {
	if params == nil {
		params = &GetScheduledQueryHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetScheduledQueryHistory", params, optFns, c.addOperationGetScheduledQueryHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetScheduledQueryHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetScheduledQueryHistoryInput struct {

	// The end time for the history retrieval window in Unix epoch time.
	//
	// This member is required.
	EndTime *int64

	// The name or ARN of the scheduled query to retrieve history for.
	//
	// This member is required.
	Identifier *string

	// The start time for the history retrieval window in Unix epoch time.
	//
	// This member is required.
	StartTime *int64

	// Filter results by execution status (Running, Complete, Failed, Timeout, or
	// InvalidQuery).
	ExecutionStatuses []types.ExecutionStatus

	// The maximum number of history records to return in a single call.
	MaxResults *int32

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type GetScheduledQueryHistoryOutput struct {

	// The name of the scheduled query.
	Name *string

	// The token for the next set of items to return. The token expires after 24 hours.
	NextToken *string

	// The ARN of the scheduled query.
	ScheduledQueryArn *string

	// The list of execution history records for the scheduled query.
	TriggerHistory []types.TriggerHistoryRecord

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetScheduledQueryHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetScheduledQueryHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetScheduledQueryHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetScheduledQueryHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetScheduledQueryHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetScheduledQueryHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetScheduledQueryHistoryPaginatorOptions is the paginator options for
// GetScheduledQueryHistory
type GetScheduledQueryHistoryPaginatorOptions struct {
	// The maximum number of history records to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetScheduledQueryHistoryPaginator is a paginator for GetScheduledQueryHistory
type GetScheduledQueryHistoryPaginator struct {
	options   GetScheduledQueryHistoryPaginatorOptions
	client    GetScheduledQueryHistoryAPIClient
	params    *GetScheduledQueryHistoryInput
	nextToken *string
	firstPage bool
}

// NewGetScheduledQueryHistoryPaginator returns a new
// GetScheduledQueryHistoryPaginator
func NewGetScheduledQueryHistoryPaginator(client GetScheduledQueryHistoryAPIClient, params *GetScheduledQueryHistoryInput, optFns ...func(*GetScheduledQueryHistoryPaginatorOptions)) *GetScheduledQueryHistoryPaginator {
	if params == nil {
		params = &GetScheduledQueryHistoryInput{}
	}

	options := GetScheduledQueryHistoryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetScheduledQueryHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetScheduledQueryHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetScheduledQueryHistory page.
func (p *GetScheduledQueryHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetScheduledQueryHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetScheduledQueryHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetScheduledQueryHistoryAPIClient is a client that implements the
// GetScheduledQueryHistory operation.
type GetScheduledQueryHistoryAPIClient interface {
	GetScheduledQueryHistory(context.Context, *GetScheduledQueryHistoryInput, ...func(*Options)) (*GetScheduledQueryHistoryOutput, error)
}

var _ GetScheduledQueryHistoryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetScheduledQueryHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetScheduledQueryHistory",
	}
}
