// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/feature_online_store_service.proto

package aiplatformpb

import (
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Format of the data in the Feature View.
type FeatureViewDataFormat int32

const (
	// Not set. Will be treated as the KeyValue format.
	FeatureViewDataFormat_FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED FeatureViewDataFormat = 0
	// Return response data in key-value format.
	FeatureViewDataFormat_KEY_VALUE FeatureViewDataFormat = 1
	// Return response data in proto Struct format.
	FeatureViewDataFormat_PROTO_STRUCT FeatureViewDataFormat = 2
)

// Enum value maps for FeatureViewDataFormat.
var (
	FeatureViewDataFormat_name = map[int32]string{
		0: "FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED",
		1: "KEY_VALUE",
		2: "PROTO_STRUCT",
	}
	FeatureViewDataFormat_value = map[string]int32{
		"FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED": 0,
		"KEY_VALUE":                            1,
		"PROTO_STRUCT":                         2,
	}
)

func (x FeatureViewDataFormat) Enum() *FeatureViewDataFormat {
	p := new(FeatureViewDataFormat)
	*p = x
	return p
}

func (x FeatureViewDataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FeatureViewDataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes[0].Descriptor()
}

func (FeatureViewDataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes[0]
}

func (x FeatureViewDataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FeatureViewDataFormat.Descriptor instead.
func (FeatureViewDataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{0}
}

// Datapoints for which Operator is true relative to the query's Value
// field will be allowlisted.
type NearestNeighborQuery_NumericFilter_Operator int32

const (
	// Unspecified operator.
	NearestNeighborQuery_NumericFilter_OPERATOR_UNSPECIFIED NearestNeighborQuery_NumericFilter_Operator = 0
	// Entities are eligible if their value is < the query's.
	NearestNeighborQuery_NumericFilter_LESS NearestNeighborQuery_NumericFilter_Operator = 1
	// Entities are eligible if their value is <= the query's.
	NearestNeighborQuery_NumericFilter_LESS_EQUAL NearestNeighborQuery_NumericFilter_Operator = 2
	// Entities are eligible if their value is == the query's.
	NearestNeighborQuery_NumericFilter_EQUAL NearestNeighborQuery_NumericFilter_Operator = 3
	// Entities are eligible if their value is >= the query's.
	NearestNeighborQuery_NumericFilter_GREATER_EQUAL NearestNeighborQuery_NumericFilter_Operator = 4
	// Entities are eligible if their value is > the query's.
	NearestNeighborQuery_NumericFilter_GREATER NearestNeighborQuery_NumericFilter_Operator = 5
	// Entities are eligible if their value is != the query's.
	NearestNeighborQuery_NumericFilter_NOT_EQUAL NearestNeighborQuery_NumericFilter_Operator = 6
)

// Enum value maps for NearestNeighborQuery_NumericFilter_Operator.
var (
	NearestNeighborQuery_NumericFilter_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "LESS",
		2: "LESS_EQUAL",
		3: "EQUAL",
		4: "GREATER_EQUAL",
		5: "GREATER",
		6: "NOT_EQUAL",
	}
	NearestNeighborQuery_NumericFilter_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"LESS":                 1,
		"LESS_EQUAL":           2,
		"EQUAL":                3,
		"GREATER_EQUAL":        4,
		"GREATER":              5,
		"NOT_EQUAL":            6,
	}
)

func (x NearestNeighborQuery_NumericFilter_Operator) Enum() *NearestNeighborQuery_NumericFilter_Operator {
	p := new(NearestNeighborQuery_NumericFilter_Operator)
	*p = x
	return p
}

func (x NearestNeighborQuery_NumericFilter_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NearestNeighborQuery_NumericFilter_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes[1].Descriptor()
}

func (NearestNeighborQuery_NumericFilter_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes[1]
}

func (x NearestNeighborQuery_NumericFilter_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NearestNeighborQuery_NumericFilter_Operator.Descriptor instead.
func (NearestNeighborQuery_NumericFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3, 2, 0}
}

// Lookup key for a feature view.
type FeatureViewDataKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to KeyOneof:
	//
	//	*FeatureViewDataKey_Key
	//	*FeatureViewDataKey_CompositeKey_
	KeyOneof isFeatureViewDataKey_KeyOneof `protobuf_oneof:"key_oneof"`
}

func (x *FeatureViewDataKey) Reset() {
	*x = FeatureViewDataKey{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureViewDataKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureViewDataKey) ProtoMessage() {}

func (x *FeatureViewDataKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureViewDataKey.ProtoReflect.Descriptor instead.
func (*FeatureViewDataKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{0}
}

func (m *FeatureViewDataKey) GetKeyOneof() isFeatureViewDataKey_KeyOneof {
	if m != nil {
		return m.KeyOneof
	}
	return nil
}

func (x *FeatureViewDataKey) GetKey() string {
	if x, ok := x.GetKeyOneof().(*FeatureViewDataKey_Key); ok {
		return x.Key
	}
	return ""
}

func (x *FeatureViewDataKey) GetCompositeKey() *FeatureViewDataKey_CompositeKey {
	if x, ok := x.GetKeyOneof().(*FeatureViewDataKey_CompositeKey_); ok {
		return x.CompositeKey
	}
	return nil
}

type isFeatureViewDataKey_KeyOneof interface {
	isFeatureViewDataKey_KeyOneof()
}

type FeatureViewDataKey_Key struct {
	// String key to use for lookup.
	Key string `protobuf:"bytes,1,opt,name=key,proto3,oneof"`
}

type FeatureViewDataKey_CompositeKey_ struct {
	// The actual Entity ID will be composed from this struct. This should match
	// with the way ID is defined in the FeatureView spec.
	CompositeKey *FeatureViewDataKey_CompositeKey `protobuf:"bytes,2,opt,name=composite_key,json=compositeKey,proto3,oneof"`
}

func (*FeatureViewDataKey_Key) isFeatureViewDataKey_KeyOneof() {}

func (*FeatureViewDataKey_CompositeKey_) isFeatureViewDataKey_KeyOneof() {}

// Request message for
// [FeatureOnlineStoreService.FetchFeatureValues][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues].
// All the features under the requested feature view will be returned.
type FetchFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. FeatureView resource format
	// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
	FeatureView string `protobuf:"bytes,1,opt,name=feature_view,json=featureView,proto3" json:"feature_view,omitempty"`
	// Optional. The request key to fetch feature values for.
	DataKey *FeatureViewDataKey `protobuf:"bytes,6,opt,name=data_key,json=dataKey,proto3" json:"data_key,omitempty"`
	// Optional. Response data format. If not set,
	// [FeatureViewDataFormat.KEY_VALUE][google.cloud.aiplatform.v1.FeatureViewDataFormat.KEY_VALUE]
	// will be used.
	DataFormat FeatureViewDataFormat `protobuf:"varint,7,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.aiplatform.v1.FeatureViewDataFormat" json:"data_format,omitempty"`
}

func (x *FetchFeatureValuesRequest) Reset() {
	*x = FetchFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFeatureValuesRequest) ProtoMessage() {}

func (x *FetchFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*FetchFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{1}
}

func (x *FetchFeatureValuesRequest) GetFeatureView() string {
	if x != nil {
		return x.FeatureView
	}
	return ""
}

func (x *FetchFeatureValuesRequest) GetDataKey() *FeatureViewDataKey {
	if x != nil {
		return x.DataKey
	}
	return nil
}

func (x *FetchFeatureValuesRequest) GetDataFormat() FeatureViewDataFormat {
	if x != nil {
		return x.DataFormat
	}
	return FeatureViewDataFormat_FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED
}

// Response message for
// [FeatureOnlineStoreService.FetchFeatureValues][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues]
type FetchFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Format:
	//
	//	*FetchFeatureValuesResponse_KeyValues
	//	*FetchFeatureValuesResponse_ProtoStruct
	Format isFetchFeatureValuesResponse_Format `protobuf_oneof:"format"`
	// The data key associated with this response.
	// Will only be populated for
	// [FeatureOnlineStoreService.StreamingFetchFeatureValues][] RPCs.
	DataKey *FeatureViewDataKey `protobuf:"bytes,4,opt,name=data_key,json=dataKey,proto3" json:"data_key,omitempty"`
}

func (x *FetchFeatureValuesResponse) Reset() {
	*x = FetchFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFeatureValuesResponse) ProtoMessage() {}

func (x *FetchFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*FetchFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{2}
}

func (m *FetchFeatureValuesResponse) GetFormat() isFetchFeatureValuesResponse_Format {
	if m != nil {
		return m.Format
	}
	return nil
}

func (x *FetchFeatureValuesResponse) GetKeyValues() *FetchFeatureValuesResponse_FeatureNameValuePairList {
	if x, ok := x.GetFormat().(*FetchFeatureValuesResponse_KeyValues); ok {
		return x.KeyValues
	}
	return nil
}

func (x *FetchFeatureValuesResponse) GetProtoStruct() *structpb.Struct {
	if x, ok := x.GetFormat().(*FetchFeatureValuesResponse_ProtoStruct); ok {
		return x.ProtoStruct
	}
	return nil
}

func (x *FetchFeatureValuesResponse) GetDataKey() *FeatureViewDataKey {
	if x != nil {
		return x.DataKey
	}
	return nil
}

type isFetchFeatureValuesResponse_Format interface {
	isFetchFeatureValuesResponse_Format()
}

type FetchFeatureValuesResponse_KeyValues struct {
	// Feature values in KeyValue format.
	KeyValues *FetchFeatureValuesResponse_FeatureNameValuePairList `protobuf:"bytes,3,opt,name=key_values,json=keyValues,proto3,oneof"`
}

type FetchFeatureValuesResponse_ProtoStruct struct {
	// Feature values in proto Struct format.
	ProtoStruct *structpb.Struct `protobuf:"bytes,2,opt,name=proto_struct,json=protoStruct,proto3,oneof"`
}

func (*FetchFeatureValuesResponse_KeyValues) isFetchFeatureValuesResponse_Format() {}

func (*FetchFeatureValuesResponse_ProtoStruct) isFetchFeatureValuesResponse_Format() {}

// A query to find a number of similar entities.
type NearestNeighborQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Instance:
	//
	//	*NearestNeighborQuery_EntityId
	//	*NearestNeighborQuery_Embedding_
	Instance isNearestNeighborQuery_Instance `protobuf_oneof:"instance"`
	// Optional. The number of similar entities to be retrieved from feature view
	// for each query.
	NeighborCount int32 `protobuf:"varint,3,opt,name=neighbor_count,json=neighborCount,proto3" json:"neighbor_count,omitempty"`
	// Optional. The list of string filters.
	StringFilters []*NearestNeighborQuery_StringFilter `protobuf:"bytes,4,rep,name=string_filters,json=stringFilters,proto3" json:"string_filters,omitempty"`
	// Optional. The list of numeric filters.
	NumericFilters []*NearestNeighborQuery_NumericFilter `protobuf:"bytes,8,rep,name=numeric_filters,json=numericFilters,proto3" json:"numeric_filters,omitempty"`
	// Optional. Crowding is a constraint on a neighbor list produced by nearest
	// neighbor search requiring that no more than
	// sper_crowding_attribute_neighbor_count of the k neighbors returned have the
	// same value of crowding_attribute. It's used for improving result diversity.
	PerCrowdingAttributeNeighborCount int32 `protobuf:"varint,5,opt,name=per_crowding_attribute_neighbor_count,json=perCrowdingAttributeNeighborCount,proto3" json:"per_crowding_attribute_neighbor_count,omitempty"`
	// Optional. Parameters that can be set to tune query on the fly.
	Parameters *NearestNeighborQuery_Parameters `protobuf:"bytes,7,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *NearestNeighborQuery) Reset() {
	*x = NearestNeighborQuery{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighborQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighborQuery) ProtoMessage() {}

func (x *NearestNeighborQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighborQuery.ProtoReflect.Descriptor instead.
func (*NearestNeighborQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3}
}

func (m *NearestNeighborQuery) GetInstance() isNearestNeighborQuery_Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (x *NearestNeighborQuery) GetEntityId() string {
	if x, ok := x.GetInstance().(*NearestNeighborQuery_EntityId); ok {
		return x.EntityId
	}
	return ""
}

func (x *NearestNeighborQuery) GetEmbedding() *NearestNeighborQuery_Embedding {
	if x, ok := x.GetInstance().(*NearestNeighborQuery_Embedding_); ok {
		return x.Embedding
	}
	return nil
}

func (x *NearestNeighborQuery) GetNeighborCount() int32 {
	if x != nil {
		return x.NeighborCount
	}
	return 0
}

func (x *NearestNeighborQuery) GetStringFilters() []*NearestNeighborQuery_StringFilter {
	if x != nil {
		return x.StringFilters
	}
	return nil
}

func (x *NearestNeighborQuery) GetNumericFilters() []*NearestNeighborQuery_NumericFilter {
	if x != nil {
		return x.NumericFilters
	}
	return nil
}

func (x *NearestNeighborQuery) GetPerCrowdingAttributeNeighborCount() int32 {
	if x != nil {
		return x.PerCrowdingAttributeNeighborCount
	}
	return 0
}

func (x *NearestNeighborQuery) GetParameters() *NearestNeighborQuery_Parameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

type isNearestNeighborQuery_Instance interface {
	isNearestNeighborQuery_Instance()
}

type NearestNeighborQuery_EntityId struct {
	// Optional. The entity id whose similar entities should be searched for.
	// If embedding is set, search will use embedding instead of
	// entity_id.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3,oneof"`
}

type NearestNeighborQuery_Embedding_ struct {
	// Optional. The embedding vector that be used for similar search.
	Embedding *NearestNeighborQuery_Embedding `protobuf:"bytes,2,opt,name=embedding,proto3,oneof"`
}

func (*NearestNeighborQuery_EntityId) isNearestNeighborQuery_Instance() {}

func (*NearestNeighborQuery_Embedding_) isNearestNeighborQuery_Instance() {}

// The request message for
// [FeatureOnlineStoreService.SearchNearestEntities][google.cloud.aiplatform.v1.FeatureOnlineStoreService.SearchNearestEntities].
type SearchNearestEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. FeatureView resource format
	// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
	FeatureView string `protobuf:"bytes,1,opt,name=feature_view,json=featureView,proto3" json:"feature_view,omitempty"`
	// Required. The query.
	Query *NearestNeighborQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. If set to true, the full entities (including all vector values
	// and metadata) of the nearest neighbors are returned; otherwise only entity
	// id of the nearest neighbors will be returned. Note that returning full
	// entities will significantly increase the latency and cost of the query.
	ReturnFullEntity bool `protobuf:"varint,3,opt,name=return_full_entity,json=returnFullEntity,proto3" json:"return_full_entity,omitempty"`
}

func (x *SearchNearestEntitiesRequest) Reset() {
	*x = SearchNearestEntitiesRequest{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchNearestEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearestEntitiesRequest) ProtoMessage() {}

func (x *SearchNearestEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearestEntitiesRequest.ProtoReflect.Descriptor instead.
func (*SearchNearestEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{4}
}

func (x *SearchNearestEntitiesRequest) GetFeatureView() string {
	if x != nil {
		return x.FeatureView
	}
	return ""
}

func (x *SearchNearestEntitiesRequest) GetQuery() *NearestNeighborQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *SearchNearestEntitiesRequest) GetReturnFullEntity() bool {
	if x != nil {
		return x.ReturnFullEntity
	}
	return false
}

// Nearest neighbors for one query.
type NearestNeighbors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All its neighbors.
	Neighbors []*NearestNeighbors_Neighbor `protobuf:"bytes,1,rep,name=neighbors,proto3" json:"neighbors,omitempty"`
}

func (x *NearestNeighbors) Reset() {
	*x = NearestNeighbors{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighbors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighbors) ProtoMessage() {}

func (x *NearestNeighbors) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighbors.ProtoReflect.Descriptor instead.
func (*NearestNeighbors) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{5}
}

func (x *NearestNeighbors) GetNeighbors() []*NearestNeighbors_Neighbor {
	if x != nil {
		return x.Neighbors
	}
	return nil
}

// Response message for
// [FeatureOnlineStoreService.SearchNearestEntities][google.cloud.aiplatform.v1.FeatureOnlineStoreService.SearchNearestEntities]
type SearchNearestEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The nearest neighbors of the query entity.
	NearestNeighbors *NearestNeighbors `protobuf:"bytes,1,opt,name=nearest_neighbors,json=nearestNeighbors,proto3" json:"nearest_neighbors,omitempty"`
}

func (x *SearchNearestEntitiesResponse) Reset() {
	*x = SearchNearestEntitiesResponse{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchNearestEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchNearestEntitiesResponse) ProtoMessage() {}

func (x *SearchNearestEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchNearestEntitiesResponse.ProtoReflect.Descriptor instead.
func (*SearchNearestEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{6}
}

func (x *SearchNearestEntitiesResponse) GetNearestNeighbors() *NearestNeighbors {
	if x != nil {
		return x.NearestNeighbors
	}
	return nil
}

// ID that is comprised from several parts (columns).
type FeatureViewDataKey_CompositeKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parts to construct Entity ID. Should match with the same ID columns as
	// defined in FeatureView in the same order.
	Parts []string `protobuf:"bytes,1,rep,name=parts,proto3" json:"parts,omitempty"`
}

func (x *FeatureViewDataKey_CompositeKey) Reset() {
	*x = FeatureViewDataKey_CompositeKey{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureViewDataKey_CompositeKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureViewDataKey_CompositeKey) ProtoMessage() {}

func (x *FeatureViewDataKey_CompositeKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureViewDataKey_CompositeKey.ProtoReflect.Descriptor instead.
func (*FeatureViewDataKey_CompositeKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FeatureViewDataKey_CompositeKey) GetParts() []string {
	if x != nil {
		return x.Parts
	}
	return nil
}

// Response structure in the format of key (feature name) and (feature) value
// pair.
type FetchFeatureValuesResponse_FeatureNameValuePairList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of feature names and values.
	Features []*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList) Reset() {
	*x = FetchFeatureValuesResponse_FeatureNameValuePairList{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFeatureValuesResponse_FeatureNameValuePairList) ProtoMessage() {}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFeatureValuesResponse_FeatureNameValuePairList.ProtoReflect.Descriptor instead.
func (*FetchFeatureValuesResponse_FeatureNameValuePairList) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList) GetFeatures() []*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair {
	if x != nil {
		return x.Features
	}
	return nil
}

// Feature name & value pair.
type FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Value
	Data isFetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Data `protobuf_oneof:"data"`
	// Feature short name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) Reset() {
	*x = FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) ProtoMessage() {}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair.ProtoReflect.Descriptor instead.
func (*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (m *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) GetData() isFetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) GetValue() *FeatureValue {
	if x, ok := x.GetData().(*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Value); ok {
		return x.Value
	}
	return nil
}

func (x *FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isFetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Data interface {
	isFetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Data()
}

type FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Value struct {
	// Feature value.
	Value *FeatureValue `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

func (*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Value) isFetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Data() {
}

// The embedding vector.
type NearestNeighborQuery_Embedding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Individual value in the embedding.
	Value []float32 `protobuf:"fixed32,1,rep,packed,name=value,proto3" json:"value,omitempty"`
}

func (x *NearestNeighborQuery_Embedding) Reset() {
	*x = NearestNeighborQuery_Embedding{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighborQuery_Embedding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighborQuery_Embedding) ProtoMessage() {}

func (x *NearestNeighborQuery_Embedding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighborQuery_Embedding.ProtoReflect.Descriptor instead.
func (*NearestNeighborQuery_Embedding) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *NearestNeighborQuery_Embedding) GetValue() []float32 {
	if x != nil {
		return x.Value
	}
	return nil
}

// String filter is used to search a subset of the entities by using boolean
// rules on string columns.
// For example: if a query specifies string filter
// with 'name = color, allow_tokens = {red, blue}, deny_tokens = {purple}','
// then that query will match entities that are red or blue, but if those
// points are also purple, then they will be excluded even if they are
// red/blue. Only string filter is supported for now, numeric filter will be
// supported in the near future.
type NearestNeighborQuery_StringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Column names in BigQuery that used as filters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The allowed tokens.
	AllowTokens []string `protobuf:"bytes,2,rep,name=allow_tokens,json=allowTokens,proto3" json:"allow_tokens,omitempty"`
	// Optional. The denied tokens.
	DenyTokens []string `protobuf:"bytes,3,rep,name=deny_tokens,json=denyTokens,proto3" json:"deny_tokens,omitempty"`
}

func (x *NearestNeighborQuery_StringFilter) Reset() {
	*x = NearestNeighborQuery_StringFilter{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighborQuery_StringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighborQuery_StringFilter) ProtoMessage() {}

func (x *NearestNeighborQuery_StringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighborQuery_StringFilter.ProtoReflect.Descriptor instead.
func (*NearestNeighborQuery_StringFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *NearestNeighborQuery_StringFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NearestNeighborQuery_StringFilter) GetAllowTokens() []string {
	if x != nil {
		return x.AllowTokens
	}
	return nil
}

func (x *NearestNeighborQuery_StringFilter) GetDenyTokens() []string {
	if x != nil {
		return x.DenyTokens
	}
	return nil
}

// Numeric filter is used to search a subset of the entities by using boolean
// rules on numeric columns.
// For example:
// Database Point 0: {name: "a" value_int: 42} {name: "b" value_float: 1.0}
// Database Point 1:  {name: "a" value_int: 10} {name: "b" value_float: 2.0}
// Database Point 2: {name: "a" value_int: -1} {name: "b" value_float: 3.0}
// Query: {name: "a" value_int: 12 operator: LESS}    // Matches Point 1, 2
// {name: "b" value_float: 2.0 operator: EQUAL} // Matches Point 1
type NearestNeighborQuery_NumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of Value must be consistent for all datapoints with a given
	// name.  This is verified at runtime.
	//
	// Types that are assignable to Value:
	//
	//	*NearestNeighborQuery_NumericFilter_ValueInt
	//	*NearestNeighborQuery_NumericFilter_ValueFloat
	//	*NearestNeighborQuery_NumericFilter_ValueDouble
	Value isNearestNeighborQuery_NumericFilter_Value `protobuf_oneof:"Value"`
	// Required. Column name in BigQuery that used as filters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. This MUST be specified for queries and must NOT be specified
	// for database points.
	Op *NearestNeighborQuery_NumericFilter_Operator `protobuf:"varint,5,opt,name=op,proto3,enum=google.cloud.aiplatform.v1.NearestNeighborQuery_NumericFilter_Operator,oneof" json:"op,omitempty"`
}

func (x *NearestNeighborQuery_NumericFilter) Reset() {
	*x = NearestNeighborQuery_NumericFilter{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighborQuery_NumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighborQuery_NumericFilter) ProtoMessage() {}

func (x *NearestNeighborQuery_NumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighborQuery_NumericFilter.ProtoReflect.Descriptor instead.
func (*NearestNeighborQuery_NumericFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3, 2}
}

func (m *NearestNeighborQuery_NumericFilter) GetValue() isNearestNeighborQuery_NumericFilter_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *NearestNeighborQuery_NumericFilter) GetValueInt() int64 {
	if x, ok := x.GetValue().(*NearestNeighborQuery_NumericFilter_ValueInt); ok {
		return x.ValueInt
	}
	return 0
}

func (x *NearestNeighborQuery_NumericFilter) GetValueFloat() float32 {
	if x, ok := x.GetValue().(*NearestNeighborQuery_NumericFilter_ValueFloat); ok {
		return x.ValueFloat
	}
	return 0
}

func (x *NearestNeighborQuery_NumericFilter) GetValueDouble() float64 {
	if x, ok := x.GetValue().(*NearestNeighborQuery_NumericFilter_ValueDouble); ok {
		return x.ValueDouble
	}
	return 0
}

func (x *NearestNeighborQuery_NumericFilter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NearestNeighborQuery_NumericFilter) GetOp() NearestNeighborQuery_NumericFilter_Operator {
	if x != nil && x.Op != nil {
		return *x.Op
	}
	return NearestNeighborQuery_NumericFilter_OPERATOR_UNSPECIFIED
}

type isNearestNeighborQuery_NumericFilter_Value interface {
	isNearestNeighborQuery_NumericFilter_Value()
}

type NearestNeighborQuery_NumericFilter_ValueInt struct {
	// int value type.
	ValueInt int64 `protobuf:"varint,2,opt,name=value_int,json=valueInt,proto3,oneof"`
}

type NearestNeighborQuery_NumericFilter_ValueFloat struct {
	// float value type.
	ValueFloat float32 `protobuf:"fixed32,3,opt,name=value_float,json=valueFloat,proto3,oneof"`
}

type NearestNeighborQuery_NumericFilter_ValueDouble struct {
	// double value type.
	ValueDouble float64 `protobuf:"fixed64,4,opt,name=value_double,json=valueDouble,proto3,oneof"`
}

func (*NearestNeighborQuery_NumericFilter_ValueInt) isNearestNeighborQuery_NumericFilter_Value() {}

func (*NearestNeighborQuery_NumericFilter_ValueFloat) isNearestNeighborQuery_NumericFilter_Value() {}

func (*NearestNeighborQuery_NumericFilter_ValueDouble) isNearestNeighborQuery_NumericFilter_Value() {}

// Parameters that can be overrided in each query to tune query latency and
// recall.
type NearestNeighborQuery_Parameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of neighbors to find via approximate search before
	// exact reordering is performed; if set, this value must be >
	// neighbor_count.
	ApproximateNeighborCandidates int32 `protobuf:"varint,1,opt,name=approximate_neighbor_candidates,json=approximateNeighborCandidates,proto3" json:"approximate_neighbor_candidates,omitempty"`
	// Optional. The fraction of the number of leaves to search, set at query
	// time allows user to tune search performance. This value increase result
	// in both search accuracy and latency increase. The value should be between
	// 0.0 and 1.0.
	LeafNodesSearchFraction float64 `protobuf:"fixed64,2,opt,name=leaf_nodes_search_fraction,json=leafNodesSearchFraction,proto3" json:"leaf_nodes_search_fraction,omitempty"`
}

func (x *NearestNeighborQuery_Parameters) Reset() {
	*x = NearestNeighborQuery_Parameters{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighborQuery_Parameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighborQuery_Parameters) ProtoMessage() {}

func (x *NearestNeighborQuery_Parameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighborQuery_Parameters.ProtoReflect.Descriptor instead.
func (*NearestNeighborQuery_Parameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{3, 3}
}

func (x *NearestNeighborQuery_Parameters) GetApproximateNeighborCandidates() int32 {
	if x != nil {
		return x.ApproximateNeighborCandidates
	}
	return 0
}

func (x *NearestNeighborQuery_Parameters) GetLeafNodesSearchFraction() float64 {
	if x != nil {
		return x.LeafNodesSearchFraction
	}
	return 0
}

// A neighbor of the query vector.
type NearestNeighbors_Neighbor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the similar entity.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The distance between the neighbor and the query vector.
	Distance float64 `protobuf:"fixed64,2,opt,name=distance,proto3" json:"distance,omitempty"`
	// The attributes of the neighbor, e.g. filters, crowding and metadata
	// Note that full entities are returned only when "return_full_entity"
	// is set to true. Otherwise, only the "entity_id" and "distance" fields
	// are populated.
	EntityKeyValues *FetchFeatureValuesResponse `protobuf:"bytes,3,opt,name=entity_key_values,json=entityKeyValues,proto3" json:"entity_key_values,omitempty"`
}

func (x *NearestNeighbors_Neighbor) Reset() {
	*x = NearestNeighbors_Neighbor{}
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NearestNeighbors_Neighbor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NearestNeighbors_Neighbor) ProtoMessage() {}

func (x *NearestNeighbors_Neighbor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NearestNeighbors_Neighbor.ProtoReflect.Descriptor instead.
func (*NearestNeighbors_Neighbor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *NearestNeighbors_Neighbor) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *NearestNeighbors_Neighbor) GetDistance() float64 {
	if x != nil {
		return x.Distance
	}
	return 0
}

func (x *NearestNeighbors_Neighbor) GetEntityKeyValues() *FetchFeatureValuesResponse {
	if x != nil {
		return x.EntityKeyValues
	}
	return nil
}

var File_google_cloud_aiplatform_v1_feature_online_store_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x01, 0x0a, 0x12, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x4b, 0x65,
	0x79, 0x12, 0x12, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x62, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x1a, 0x24, 0x0a, 0x0c, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x72,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x42,
	0x0b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x22, 0x96, 0x02, 0x0a,
	0x19, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x0b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x4e, 0x0a, 0x08,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x12, 0x57, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0xb7, 0x04, 0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70, 0x0a, 0x0a, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x09, 0x6b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x44,
	0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x4b, 0x65, 0x79, 0x1a,
	0x93, 0x02, 0x0a, 0x18, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x80, 0x01, 0x0a,
	0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x50, 0x61, 0x69, 0x72, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x1a,
	0x74, 0x0a, 0x14, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x12, 0x40, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x42, 0x08, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22,
	0xa1, 0x0a, 0x0a, 0x14, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x22, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x5f, 0x0a, 0x09,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61,
	0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x09, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a,
	0x0e, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x69, 0x67,
	0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x69, 0x0a, 0x0e, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x6c, 0x0a, 0x0f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65,
	0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x55, 0x0a, 0x25, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x6f, 0x77, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x69,
	0x67, 0x68, 0x62, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x21, 0x70, 0x65, 0x72, 0x43, 0x72, 0x6f, 0x77, 0x64,
	0x69, 0x6e, 0x67, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4e, 0x65, 0x69, 0x67,
	0x68, 0x62, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65,
	0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x26, 0x0a, 0x09, 0x45,
	0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x75, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x64, 0x65, 0x6e, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x1a, 0xfc, 0x02, 0x0a, 0x0d, 0x4e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x09,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x00, 0x52, 0x08, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x49, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02,
	0x48, 0x00, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x12, 0x23,
	0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x02,
	0x6f, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69,
	0x67, 0x68, 0x62, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x02, 0x6f, 0x70, 0x88, 0x01, 0x01, 0x22,
	0x78, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x47, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x0b, 0x0a,
	0x07, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f,
	0x54, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x06, 0x42, 0x07, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x6f, 0x70, 0x1a, 0x9b, 0x01, 0x0a, 0x0a, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4b, 0x0a, 0x1f, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72,
	0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
	0x61, 0x74, 0x65, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x43, 0x61, 0x6e, 0x64, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x1a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17,
	0x6c, 0x65, 0x61, 0x66, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x22, 0xf0, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65,
	0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0b, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x4b, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62,
	0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x46, 0x75, 0x6c, 0x6c,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x91, 0x02, 0x0a, 0x10, 0x4e, 0x65, 0x61, 0x72, 0x65,
	0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x09, 0x6e,
	0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72,
	0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x2e, 0x4e, 0x65, 0x69,
	0x67, 0x68, 0x62, 0x6f, 0x72, 0x52, 0x09, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73,
	0x1a, 0xa7, 0x01, 0x0a, 0x08, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x64, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x62, 0x0a, 0x11, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x7a, 0x0a, 0x1d, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x11, 0x6e,
	0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x73, 0x52, 0x10, 0x6e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x4e, 0x65, 0x69,
	0x67, 0x68, 0x62, 0x6f, 0x72, 0x73, 0x2a, 0x62, 0x0a, 0x15, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x28, 0x0a, 0x24, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4b, 0x45, 0x59,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x54,
	0x4f, 0x5f, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x10, 0x02, 0x32, 0xf8, 0x04, 0x0a, 0x19, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8b, 0x02, 0x0a, 0x12, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85,
	0x01, 0xda, 0x41, 0x16, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x2c, 0x20, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66,
	0x3a, 0x01, 0x2a, 0x22, 0x61, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0xfd, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65,
	0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x69, 0x3a, 0x01, 0x2a,
	0x22, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x61, 0x72, 0x65, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xdc, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x1e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescData = file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_aiplatform_v1_feature_online_store_service_proto_goTypes = []any{
	(FeatureViewDataFormat)(0),                                                       // 0: google.cloud.aiplatform.v1.FeatureViewDataFormat
	(NearestNeighborQuery_NumericFilter_Operator)(0),                                 // 1: google.cloud.aiplatform.v1.NearestNeighborQuery.NumericFilter.Operator
	(*FeatureViewDataKey)(nil),                                                       // 2: google.cloud.aiplatform.v1.FeatureViewDataKey
	(*FetchFeatureValuesRequest)(nil),                                                // 3: google.cloud.aiplatform.v1.FetchFeatureValuesRequest
	(*FetchFeatureValuesResponse)(nil),                                               // 4: google.cloud.aiplatform.v1.FetchFeatureValuesResponse
	(*NearestNeighborQuery)(nil),                                                     // 5: google.cloud.aiplatform.v1.NearestNeighborQuery
	(*SearchNearestEntitiesRequest)(nil),                                             // 6: google.cloud.aiplatform.v1.SearchNearestEntitiesRequest
	(*NearestNeighbors)(nil),                                                         // 7: google.cloud.aiplatform.v1.NearestNeighbors
	(*SearchNearestEntitiesResponse)(nil),                                            // 8: google.cloud.aiplatform.v1.SearchNearestEntitiesResponse
	(*FeatureViewDataKey_CompositeKey)(nil),                                          // 9: google.cloud.aiplatform.v1.FeatureViewDataKey.CompositeKey
	(*FetchFeatureValuesResponse_FeatureNameValuePairList)(nil),                      // 10: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
	(*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair)(nil), // 11: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair
	(*NearestNeighborQuery_Embedding)(nil),                                           // 12: google.cloud.aiplatform.v1.NearestNeighborQuery.Embedding
	(*NearestNeighborQuery_StringFilter)(nil),                                        // 13: google.cloud.aiplatform.v1.NearestNeighborQuery.StringFilter
	(*NearestNeighborQuery_NumericFilter)(nil),                                       // 14: google.cloud.aiplatform.v1.NearestNeighborQuery.NumericFilter
	(*NearestNeighborQuery_Parameters)(nil),                                          // 15: google.cloud.aiplatform.v1.NearestNeighborQuery.Parameters
	(*NearestNeighbors_Neighbor)(nil),                                                // 16: google.cloud.aiplatform.v1.NearestNeighbors.Neighbor
	(*structpb.Struct)(nil),                                                          // 17: google.protobuf.Struct
	(*FeatureValue)(nil),                                                             // 18: google.cloud.aiplatform.v1.FeatureValue
}
var file_google_cloud_aiplatform_v1_feature_online_store_service_proto_depIdxs = []int32{
	9,  // 0: google.cloud.aiplatform.v1.FeatureViewDataKey.composite_key:type_name -> google.cloud.aiplatform.v1.FeatureViewDataKey.CompositeKey
	2,  // 1: google.cloud.aiplatform.v1.FetchFeatureValuesRequest.data_key:type_name -> google.cloud.aiplatform.v1.FeatureViewDataKey
	0,  // 2: google.cloud.aiplatform.v1.FetchFeatureValuesRequest.data_format:type_name -> google.cloud.aiplatform.v1.FeatureViewDataFormat
	10, // 3: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.key_values:type_name -> google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList
	17, // 4: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.proto_struct:type_name -> google.protobuf.Struct
	2,  // 5: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.data_key:type_name -> google.cloud.aiplatform.v1.FeatureViewDataKey
	12, // 6: google.cloud.aiplatform.v1.NearestNeighborQuery.embedding:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery.Embedding
	13, // 7: google.cloud.aiplatform.v1.NearestNeighborQuery.string_filters:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery.StringFilter
	14, // 8: google.cloud.aiplatform.v1.NearestNeighborQuery.numeric_filters:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery.NumericFilter
	15, // 9: google.cloud.aiplatform.v1.NearestNeighborQuery.parameters:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery.Parameters
	5,  // 10: google.cloud.aiplatform.v1.SearchNearestEntitiesRequest.query:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery
	16, // 11: google.cloud.aiplatform.v1.NearestNeighbors.neighbors:type_name -> google.cloud.aiplatform.v1.NearestNeighbors.Neighbor
	7,  // 12: google.cloud.aiplatform.v1.SearchNearestEntitiesResponse.nearest_neighbors:type_name -> google.cloud.aiplatform.v1.NearestNeighbors
	11, // 13: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.features:type_name -> google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair
	18, // 14: google.cloud.aiplatform.v1.FetchFeatureValuesResponse.FeatureNameValuePairList.FeatureNameValuePair.value:type_name -> google.cloud.aiplatform.v1.FeatureValue
	1,  // 15: google.cloud.aiplatform.v1.NearestNeighborQuery.NumericFilter.op:type_name -> google.cloud.aiplatform.v1.NearestNeighborQuery.NumericFilter.Operator
	4,  // 16: google.cloud.aiplatform.v1.NearestNeighbors.Neighbor.entity_key_values:type_name -> google.cloud.aiplatform.v1.FetchFeatureValuesResponse
	3,  // 17: google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues:input_type -> google.cloud.aiplatform.v1.FetchFeatureValuesRequest
	6,  // 18: google.cloud.aiplatform.v1.FeatureOnlineStoreService.SearchNearestEntities:input_type -> google.cloud.aiplatform.v1.SearchNearestEntitiesRequest
	4,  // 19: google.cloud.aiplatform.v1.FeatureOnlineStoreService.FetchFeatureValues:output_type -> google.cloud.aiplatform.v1.FetchFeatureValuesResponse
	8,  // 20: google.cloud.aiplatform.v1.FeatureOnlineStoreService.SearchNearestEntities:output_type -> google.cloud.aiplatform.v1.SearchNearestEntitiesResponse
	19, // [19:21] is the sub-list for method output_type
	17, // [17:19] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_feature_online_store_service_proto_init() }
func file_google_cloud_aiplatform_v1_feature_online_store_service_proto_init() {
	if File_google_cloud_aiplatform_v1_feature_online_store_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_featurestore_online_service_proto_init()
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[0].OneofWrappers = []any{
		(*FeatureViewDataKey_Key)(nil),
		(*FeatureViewDataKey_CompositeKey_)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[2].OneofWrappers = []any{
		(*FetchFeatureValuesResponse_KeyValues)(nil),
		(*FetchFeatureValuesResponse_ProtoStruct)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[3].OneofWrappers = []any{
		(*NearestNeighborQuery_EntityId)(nil),
		(*NearestNeighborQuery_Embedding_)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[9].OneofWrappers = []any{
		(*FetchFeatureValuesResponse_FeatureNameValuePairList_FeatureNameValuePair_Value)(nil),
	}
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes[12].OneofWrappers = []any{
		(*NearestNeighborQuery_NumericFilter_ValueInt)(nil),
		(*NearestNeighborQuery_NumericFilter_ValueFloat)(nil),
		(*NearestNeighborQuery_NumericFilter_ValueDouble)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_feature_online_store_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_feature_online_store_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_feature_online_store_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_feature_online_store_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_feature_online_store_service_proto = out.File
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_feature_online_store_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FeatureOnlineStoreServiceClient is the client API for FeatureOnlineStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FeatureOnlineStoreServiceClient interface {
	// Fetch feature values under a FeatureView.
	FetchFeatureValues(ctx context.Context, in *FetchFeatureValuesRequest, opts ...grpc.CallOption) (*FetchFeatureValuesResponse, error)
	// Search the nearest entities under a FeatureView.
	// Search only works for indexable feature view; if a feature view isn't
	// indexable, returns Invalid argument response.
	SearchNearestEntities(ctx context.Context, in *SearchNearestEntitiesRequest, opts ...grpc.CallOption) (*SearchNearestEntitiesResponse, error)
}

type featureOnlineStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeatureOnlineStoreServiceClient(cc grpc.ClientConnInterface) FeatureOnlineStoreServiceClient {
	return &featureOnlineStoreServiceClient{cc}
}

func (c *featureOnlineStoreServiceClient) FetchFeatureValues(ctx context.Context, in *FetchFeatureValuesRequest, opts ...grpc.CallOption) (*FetchFeatureValuesResponse, error) {
	out := new(FetchFeatureValuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreService/FetchFeatureValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featureOnlineStoreServiceClient) SearchNearestEntities(ctx context.Context, in *SearchNearestEntitiesRequest, opts ...grpc.CallOption) (*SearchNearestEntitiesResponse, error) {
	out := new(SearchNearestEntitiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeatureOnlineStoreService/SearchNearestEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeatureOnlineStoreServiceServer is the server API for FeatureOnlineStoreService service.
type FeatureOnlineStoreServiceServer interface {
	// Fetch feature values under a FeatureView.
	FetchFeatureValues(context.Context, *FetchFeatureValuesRequest) (*FetchFeatureValuesResponse, error)
	// Search the nearest entities under a FeatureView.
	// Search only works for indexable feature view; if a feature view isn't
	// indexable, returns Invalid argument response.
	SearchNearestEntities(context.Context, *SearchNearestEntitiesRequest) (*SearchNearestEntitiesResponse, error)
}

// UnimplementedFeatureOnlineStoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFeatureOnlineStoreServiceServer struct {
}

func (*UnimplementedFeatureOnlineStoreServiceServer) FetchFeatureValues(context.Context, *FetchFeatureValuesRequest) (*FetchFeatureValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchFeatureValues not implemented")
}
func (*UnimplementedFeatureOnlineStoreServiceServer) SearchNearestEntities(context.Context, *SearchNearestEntitiesRequest) (*SearchNearestEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNearestEntities not implemented")
}

func RegisterFeatureOnlineStoreServiceServer(s *grpc.Server, srv FeatureOnlineStoreServiceServer) {
	s.RegisterService(&_FeatureOnlineStoreService_serviceDesc, srv)
}

func _FeatureOnlineStoreService_FetchFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreServiceServer).FetchFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreService/FetchFeatureValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreServiceServer).FetchFeatureValues(ctx, req.(*FetchFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeatureOnlineStoreService_SearchNearestEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNearestEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeatureOnlineStoreServiceServer).SearchNearestEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeatureOnlineStoreService/SearchNearestEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeatureOnlineStoreServiceServer).SearchNearestEntities(ctx, req.(*SearchNearestEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FeatureOnlineStoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.FeatureOnlineStoreService",
	HandlerType: (*FeatureOnlineStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchFeatureValues",
			Handler:    _FeatureOnlineStoreService_FetchFeatureValues_Handler,
		},
		{
			MethodName: "SearchNearestEntities",
			Handler:    _FeatureOnlineStoreService_SearchNearestEntities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/feature_online_store_service.proto",
}
