//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package generated

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strconv"
	"time"
)

// MessageIDClient contains the methods for the MessageID group.
// Don't use this type directly, use NewMessageIDClient() instead.
type MessageIDClient struct {
	endpoint string
	pl       runtime.Pipeline
}

// NewMessageIDClient creates a new instance of MessageIDClient with the specified values.
//   - endpoint - The URL of the service account, queue or message that is the target of the desired operation.
//   - pl - the pipeline used for sending requests and handling responses.
func NewMessageIDClient(endpoint string, pl runtime.Pipeline) *MessageIDClient {
	client := &MessageIDClient{
		endpoint: endpoint,
		pl:       pl,
	}
	return client
}

// Delete - The Delete operation deletes the specified message.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - popReceipt - Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update
//     Message operation.
//   - options - MessageIDClientDeleteOptions contains the optional parameters for the MessageIDClient.Delete method.
func (client *MessageIDClient) Delete(ctx context.Context, popReceipt string, options *MessageIDClientDeleteOptions) (MessageIDClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, popReceipt, options)
	if err != nil {
		return MessageIDClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessageIDClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return MessageIDClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *MessageIDClient) deleteCreateRequest(ctx context.Context, popReceipt string, options *MessageIDClientDeleteOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("popreceipt", popReceipt)
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-08-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *MessageIDClient) deleteHandleResponse(resp *http.Response) (MessageIDClientDeleteResponse, error) {
	result := MessageIDClientDeleteResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessageIDClientDeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Update - The Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message operation
// updates the visibility timeout of a message. You can also use this operation to
// update the contents of a message. A message must be in a format that can be included in an XML request with UTF-8 encoding,
// and the encoded message can be up to 64KB in size.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-28
//   - popReceipt - Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update
//     Message operation.
//   - queueMessage - A Message object which can be stored in a Queue
//   - options - MessageIDClientUpdateOptions contains the optional parameters for the MessageIDClient.Update method.
func (client *MessageIDClient) Update(ctx context.Context, popReceipt string, queueMessage QueueMessage, options *MessageIDClientUpdateOptions) (MessageIDClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, popReceipt, queueMessage, options)
	if err != nil {
		return MessageIDClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MessageIDClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return MessageIDClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *MessageIDClient) updateCreateRequest(ctx context.Context, popReceipt string, queueMessage QueueMessage, options *MessageIDClientUpdateOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("popreceipt", popReceipt)
	if options != nil && options.Visibilitytimeout != nil {
		reqQP.Set("visibilitytimeout", strconv.FormatInt(int64(*options.Visibilitytimeout), 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2024-08-04"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, runtime.MarshalAsXML(req, queueMessage)
}

// updateHandleResponse handles the Update response.
func (client *MessageIDClient) updateHandleResponse(resp *http.Response) (MessageIDClientUpdateResponse, error) {
	result := MessageIDClientUpdateResponse{}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessageIDClientUpdateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-popreceipt"); val != "" {
		result.PopReceipt = &val
	}
	if val := resp.Header.Get("x-ms-time-next-visible"); val != "" {
		timeNextVisible, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return MessageIDClientUpdateResponse{}, err
		}
		result.TimeNextVisible = &timeNextVisible
	}
	return result, nil
}
