// Code generated by github.com/gobuffalo/mapgen. DO NOT EDIT.

package syncx

import (
	"sort"
	"testing"

	"github.com/stretchr/testify/require"
)

func Test_ByteMap(t *testing.T) {
	r := require.New(t)

	sm := &ByteMap{}

	sm.Store("a", []byte(`A`))

	s, ok := sm.Load("a")
	r.True(ok)
	r.Equal([]byte(`A`), s)

	s, ok = sm.LoadOrStore("b", []byte(`B`))
	r.True(ok)
	r.Equal([]byte(`B`), s)

	s, ok = sm.LoadOrStore("b", []byte(`BB`))
	r.True(ok)
	r.Equal([]byte(`B`), s)

	var keys []string

	sm.Range(func(key string, value []byte) bool {
		keys = append(keys, key)
		return true
	})

	sort.Strings(keys)

	r.Equal(sm.Keys(), keys)

	sm.Delete("b")
	r.Equal([]string{"a", "b"}, keys)

	sm.Delete("b")
	_, ok = sm.Load("b")
	r.False(ok)

	func(m *ByteMap) {
		m.Store("c", []byte(`C`))
	}(sm)
	s, ok = sm.Load("c")
	r.True(ok)
	r.Equal([]byte(`C`), s)
}
